/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.web.api;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class ClearAllPermCacheApi
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(ClearAllPermCacheApi.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        try {
            RequestContext requestContext = RequestContext.get();
            long currUserId = requestContext.getCurrUserId();
            String accountId = requestContext.getAccountId();
            String tenantId = requestContext.getTenantId();
            String tenantCode = requestContext.getTenantCode();
            logger.debug("ClearAllPermCacheApi.doCustomService begin, acc:{}, uu:{}, ten:{}, tenc:{} ", new Object[]{accountId, currUserId, tenantId, tenantCode});
            boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)currUserId);
            boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
            if (!isAdminUser && !superUser) {
                throw new Exception("currUserId\uff1a" + currUserId + ", is not admin or superUser.");
            }
            logger.debug("ClearAllPermCacheApi.doCustomService ready to clean.");
            CacheMrg.clearAllCache();
            logger.debug("ClearAllPermCacheApi.doCustomService clearAllCache.");
            CacheMrg.clearHasEnableOldAdmin();
            logger.debug("ClearAllPermCacheApi.doCustomService clearHasEnableOldAdmin.");
            result.put("isSuccess", Boolean.TRUE.toString());
            result.put("msg", "");
            logger.debug("ClearAllPermCacheApi.doCustomService success.");
            return ApiResult.success(result);
        }
        catch (Exception exp) {
            logger.warn("ClearAllPermCacheApi.doCustomService error.", (Throwable)exp);
            return ApiResult.ex((Throwable)exp);
        }
    }
}

