/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.web.api;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PermissionAPI {
    private static Log logger = LogFactory.getLog(PermissionAPI.class);

    public void clearAllCache() {
        try {
            logger.debug("PermissionAPI.clearAllCache begin.");
            long currUserId = RequestContext.get().getCurrUserId();
            boolean isAdminUser = PermissionServiceHelper.isAdminUser((long)currUserId);
            boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
            if (!isAdminUser && !superUser) {
                throw new Exception("currUserId\uff1a" + currUserId + ", is not admin or superUser.");
            }
            logger.debug("PermissionAPI.clearAllCache ready to clean.");
            PermissionServiceHelper.clearAllCache();
            CacheMrg.clearHasEnableOldAdmin();
            logger.debug("PermissionAPI.clearAllCache success.");
        }
        catch (Exception exp) {
            logger.warn("PermissionAPI.clearAllCache error.", (Throwable)exp);
            throw new KDBizException(BosErrorCode.oAuthSecurity, new Object[]{ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u8bbf\u95ee\u6743\u9650\u3002", (String)"PermissionAPI_0", (String)"bos-permission-webapi", (Object[])new Object[0])});
        }
    }
}

