/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.AdminAppResult;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.HasPermOrgResultImpl;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.cache.AdminUserCache;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.AdminDomainHelper;
import kd.bos.permission.cache.helper.AdminGroupHelper;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.AdminType;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.permission.model.perm.admingroup.AdmGrpFunperm;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AdminPermCache {
    private static final Log logger = LogFactory.getLog(AdminPermCache.class);
    public static final String APPID_BASE = "83bfebc8000037ac";
    public static final String SYSCLOUDID = "83bfebc800000bac";
    public static final String HRCLOUDID = "0PEIU203SX4Y";
    public static final String ADMINTYPE_SUPERADMIN = "10";
    public static final String ENTITY_ADMIN = "perm_admin_edit";

    @Deprecated
    public static List<String> getHasPermAppIds(Long pUserID) {
        return AdminPermCache.getHasPermAppIds(pUserID, null);
    }

    public static List<String> getHasPermAppIds(Long pUserID, Map<String, Object> paramMap) {
        boolean enableOldAdmin;
        Long administratorUserId = 1L;
        PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        if (!permService.isAdminUserWithParaMap(pUserID.longValue(), "", paramMap)) {
            return new ArrayList<String>();
        }
        AdminType adminType = AdminUserCache.getAdminTypeWithParaMap(String.valueOf(pUserID), paramMap);
        if (adminType == null || adminType == AdminType.NotAdmin) {
            return new ArrayList<String>();
        }
        List<Object> hasPermAppIds = new ArrayList(100);
        boolean bl = enableOldAdmin = null == paramMap || null == paramMap.get("enableOldAdmin") ? PermCommonUtil.hasEnableOldAdmin(paramMap) : (Boolean)paramMap.get("enableOldAdmin");
        hasPermAppIds = !enableOldAdmin ? (permService.isAdminUserWithParaMap(pUserID.longValue(), ADMINTYPE_SUPERADMIN, paramMap) ? AdminPermCache.getVirtualAdminHasPermAppIds(adminType) : AdminPermCache.getAdminHasPermAppIds(pUserID, adminType)) : AdminPermCache.getVirtualAdminHasPermAppIds(adminType);
        if (pUserID.equals(administratorUserId)) {
            hasPermAppIds.add("3CW96DYJ=WK3");
        }
        if (!hasPermAppIds.contains("L+YYPU4WNDE")) {
            hasPermAppIds.add("L+YYPU4WNDE");
        }
        return hasPermAppIds;
    }

    public static List<String> getAdminHasPermAppIds(final Long userId, AdminType adminType) {
        Set userAdminGroupIds;
        final String type = CacheMrg.getType4AdminGroupUser();
        ArrayList<String> hasPermAppIds = new ArrayList<String>(100);
        String adminInfoStr = CacheMrg.getCache(type, userId + "");
        if (StringUtils.isNotEmpty((String)adminInfoStr) && !"{}".equals(adminInfoStr)) {
            Map adminInfo = (Map)SerializationUtils.fromJsonString((String)adminInfoStr, Map.class);
            userAdminGroupIds = (Set)SerializationUtils.fromJsonString((String)((String)adminInfo.get("group")), Set.class);
        } else {
            String newSql = " SELECT uap.fuserid, uap.fadmingroupid, ug.flevel, ug.fadmintype FROM t_perm_useradmingroup uap  INNER JOIN t_perm_admingroup ug ON uap.fadmingroupid = ug.fid  INNER JOIN t_perm_adminscheme sch ON sch.fid = ug.fadminscheme  WHERE uap.fuserid = ? AND sch.fenable = '1' ORDER BY ug.flevel ";
            userAdminGroupIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)newSql, (Object[])new Object[]{userId}, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                public Set<Long> handle(ResultSet rs) throws SQLException {
                    HashMap<String, String> adminInfo = new HashMap<String, String>(16);
                    HashSet<String> userIds = new HashSet<String>(16);
                    HashSet<Long> adminGroupIds = new HashSet<Long>(16);
                    String userID = "";
                    while (rs.next()) {
                        userID = rs.getString("FUSERID");
                        Long adminGroupId = rs.getLong("FADMINGROUPID");
                        adminGroupIds.add(adminGroupId);
                        if (userIds.contains(userID)) continue;
                        userIds.add(userID);
                        String adminRootType = rs.getLong("FLEVEL") == 1L ? AdminPermCache.ADMINTYPE_SUPERADMIN : "20";
                        String adminType = rs.getString("FADMINTYPE");
                        adminInfo.put("adminRootType", adminRootType);
                        adminInfo.put("adminType", adminType);
                    }
                    if (adminGroupIds.size() > 0) {
                        adminInfo.put("group", SerializationUtils.toJsonString(adminGroupIds));
                    }
                    CacheMrg.putCache(type, userId + "", SerializationUtils.toJsonString(adminInfo));
                    return adminGroupIds;
                }
            });
        }
        HashSet<String> appIds = new HashSet<String>(100);
        for (Long adminGroupId : userAdminGroupIds) {
            Set<String> adminGroupIdBizAppIds = null;
            DynamicObject adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)"perm_admingroup", (String)"id,parent,level, isdomain, domain_id");
            if (adminGroup == null) continue;
            long level = adminGroup.getLong("level");
            long parentId = adminGroup.getLong("parent.id");
            Boolean isdomain = adminGroup.getBoolean("isdomain");
            long domainId = adminGroup.getLong("domain_id");
            while (level > 1L && CollectionUtils.isEmpty(adminGroupIdBizAppIds)) {
                adminGroupIdBizAppIds = AdminPermCache.getEntityAdminHasPermAppIds(adminGroup.getLong("id"));
                if (!CollectionUtils.isEmpty(adminGroupIdBizAppIds)) continue;
                adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)parentId, (String)"perm_admingroup", (String)"id,parent,level, isdomain, domain_id");
                level = adminGroup.getLong("level");
                parentId = adminGroup.getLong("parent.id");
                Boolean p_isdomain = adminGroup.getBoolean("isdomain");
                if (null == isdomain || !isdomain.booleanValue() || null != p_isdomain && p_isdomain.booleanValue()) continue;
                HashSet<Long> set = new HashSet<Long>(1);
                set.add(domainId);
                Map<Long, Set<String>> domainIdAppIdSetMap = AdminDomainHelper.getDomainIdAppIdSetMap(set);
                adminGroupIdBizAppIds = null == domainIdAppIdSetMap.get(domainId) ? new HashSet(0) : domainIdAppIdSetMap.get(domainId);
                adminGroupIdBizAppIds.addAll(AdminPermCache.getVirtualAdminHasPermAppIds(adminType));
            }
            if (!CollectionUtils.isEmpty(adminGroupIdBizAppIds)) {
                appIds.addAll(adminGroupIdBizAppIds);
                continue;
            }
            appIds.addAll(AdminPermCache.getVirtualAdminHasPermAppIds(adminType));
        }
        if (CollectionUtils.isEmpty(hasPermAppIds)) {
            hasPermAppIds.addAll(appIds);
        }
        return hasPermAppIds;
    }

    public static List<String> getAdminHasPermAppIds(Long userId) {
        AdminType adminType = AdminUserCache.getAdminType(userId.toString());
        if (adminType == null || adminType == AdminType.NotAdmin) {
            return new ArrayList<String>();
        }
        return AdminPermCache.getAdminHasPermAppIds(userId, adminType);
    }

    private static Set<String> getEntityAdminHasPermAppIds(Long adminGroupId) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct fappid from t_perm_admingroupfunperm where fusergroupid = ? ");
        return (Set)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])new Object[]{adminGroupId}, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> set = new HashSet<String>(100);
                while (rs.next()) {
                    String appId = rs.getString("fappid");
                    set.add(appId);
                }
                return set;
            }
        });
    }

    private static List<String> getVirtualAdminHasPermAppIds(AdminType adminType) {
        boolean superAdminStrategy = PermCommonUtil.isSuperAdminStrategy();
        if (superAdminStrategy) {
            return AdminSchemeHelper.queryAllSysApp(false, true);
        }
        StringBuilder sql = new StringBuilder("select distinct dtl.fbizappid from t_perm_adminscheme ads ").append(" inner join t_perm_adminschemeentry ent on (ads.fid = ent.fid) ").append(" inner join t_perm_adminschemedetail dtl on(ent.fentryid = dtl.fentryid) ").append(" where ads.fenable = '1' and ent.fadmintype = ? ");
        return (List)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])new Object[]{new SqlParameter(":fadmintype", -5, (Object)Long.parseLong(adminType.toString()))}, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> list = new ArrayList<String>(200);
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    list.add(appId);
                }
                return list;
            }
        });
    }

    @Deprecated
    public static List<String> getAdminNoPermMenuIds(Long adminId, String appId) {
        return AdminPermCache.getAdminNoPermMenuIds(adminId, appId, null);
    }

    @Deprecated
    public static List<String> getAdminNoPermMenuIds(Long adminId, String appId, Map<String, Object> paramMap) {
        List menuList;
        boolean enableOldAdmin;
        AdminType adminType;
        boolean isSuperAdminStrategy = false;
        if (null == paramMap) {
            paramMap = new HashMap<String, Object>(8);
        }
        isSuperAdminStrategy = null == paramMap.get("isSuperAdminStrategy") ? PermCommonUtil.isSuperAdminStrategy() : (Boolean)paramMap.get("isSuperAdminStrategy");
        ArrayList<String> noPermMenuIds = new ArrayList<String>(100);
        if (!adminId.equals(10L)) {
            ArrayList<String> cosmicMenus;
            if (APPID_BASE.equals(appId)) {
                cosmicMenus = new ArrayList<String>(10);
                cosmicMenus.add("/SLXJ2Z=GE0J");
                cosmicMenus.add("/SLXK+KV6J9S");
                cosmicMenus.add("/SLXLT9=3VCC");
                noPermMenuIds.addAll(cosmicMenus);
            } else if ("0XWTKVOQW+ML".equals(appId)) {
                cosmicMenus = new ArrayList(10);
                cosmicMenus.add("0Z=XT1146SQH");
                cosmicMenus.add("0Z=YK8U6WG1=");
                cosmicMenus.add("0Z=YKU9=29GP");
                noPermMenuIds.addAll(cosmicMenus);
            }
        }
        AdminType adminType2 = adminType = null == paramMap.get("adminType") ? PermissionServiceHelper.getAdminType((long)adminId) : (AdminType)paramMap.get("adminType");
        if (adminType == null || adminType == AdminType.NotAdmin) {
            return null;
        }
        String appNum = AppMetadataCache.getAppNumberById((String)appId);
        AppInfo appInfo = AppHelper.getMetaAppInfo(appNum);
        if (!PermCommonUtil.isInSysCloud(appId) && !PermCommonUtil.isAdminDomainApp(appId)) {
            return null;
        }
        Set<Object> hasPermEntityNums = new HashSet(10);
        boolean bl = enableOldAdmin = null == paramMap || null == paramMap.get("enableOldAdmin") ? PermCommonUtil.hasEnableOldAdmin(paramMap) : (Boolean)paramMap.get("enableOldAdmin");
        if (!enableOldAdmin) {
            String adminInfoStr = CacheMrg.getCache(CacheMrg.getType4AdminGroupUser(), adminId + "");
            if (StringUtils.isNotEmpty((String)adminInfoStr) && !"{}".equals(adminInfoStr)) {
                Map adminInfo = (Map)SerializationUtils.fromJsonString((String)adminInfoStr, Map.class);
                Set adminGroupIds = (Set)SerializationUtils.fromJsonString((String)((String)adminInfo.get("group")), Set.class);
                for (Long adminGroupId : adminGroupIds) {
                    Set<Object> adminGroupHasPermEntity = new HashSet(100);
                    DynamicObject adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)"perm_admingroup", (String)"id, parent, level, isdomain, domain_id");
                    long currentGroupId = adminGroupId;
                    long level = adminGroup.getLong("level");
                    long parent = adminGroup.getLong("parent.id");
                    Boolean isdomain = adminGroup.getBoolean("isdomain");
                    long domainId = adminGroup.getLong("domain_id");
                    while (level > 1L && CollectionUtils.isEmpty(adminGroupHasPermEntity)) {
                        adminGroupHasPermEntity = AdminPermCache.getEntityAdminHasPermEntity(currentGroupId);
                        if (!CollectionUtils.isEmpty(adminGroupHasPermEntity)) continue;
                        adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)parent, (String)"perm_admingroup", (String)"id, parent, level, isdomain, domain_id");
                        currentGroupId = parent;
                        level = adminGroup.getLong("level");
                        parent = adminGroup.getLong("parent.id");
                        Long adminGroupPkId = adminGroup.getLong("id");
                        Boolean p_isdomain = adminGroup.getBoolean("isdomain");
                        if (!Boolean.TRUE.equals(isdomain) || null != p_isdomain && p_isdomain.booleanValue()) continue;
                        HashSet<Long> set = new HashSet<Long>(1);
                        set.add(domainId);
                        AdmGroup adminGroupBean = new AdmGroup(adminGroupPkId, null, null);
                        Map<Long, Set<AdmGrpFunperm>> domainIdAdmGrpFunpermSetMap = AdminDomainHelper.getDomainIdAdmGrpFunpermSetMap(set, adminGroupBean);
                        Set<AdmGrpFunperm> admGrpFunPermBeanSet = domainIdAdmGrpFunpermSetMap.get(domainId);
                        HashSet<String> domainAdminGrpFunPermStrSet = new HashSet<String>(8);
                        if (admGrpFunPermBeanSet != null && !admGrpFunPermBeanSet.isEmpty()) {
                            for (AdmGrpFunperm admGrpFunpermBean : admGrpFunPermBeanSet) {
                                String tempAppId = admGrpFunpermBean.getAppId();
                                String entNum = admGrpFunpermBean.getEntNum();
                                String permItemId = admGrpFunpermBean.getPermItemId();
                                domainAdminGrpFunPermStrSet.add(tempAppId + entNum + permItemId);
                            }
                        }
                        adminGroupHasPermEntity = domainAdminGrpFunPermStrSet;
                        adminGroupHasPermEntity.addAll(AdminPermCache.getVirtualAdminHasPermEntity(adminType.toString()));
                    }
                    if (!CollectionUtils.isEmpty(adminGroupHasPermEntity)) {
                        hasPermEntityNums.addAll(adminGroupHasPermEntity);
                        continue;
                    }
                    if (isSuperAdminStrategy && PermCommonUtil.isInSysCloud(appId)) {
                        List<String> notPublishedMenuId = PermCommonUtil.getNotPublishedMenuIdByAppNum(appNum);
                        noPermMenuIds.addAll(notPublishedMenuId);
                        return noPermMenuIds;
                    }
                    hasPermEntityNums.addAll(AdminPermCache.getVirtualAdminHasPermEntity(adminType.toString()));
                }
            }
        } else {
            if (isSuperAdminStrategy) {
                List<String> notPublishedMenuId = PermCommonUtil.getNotPublishedMenuIdByAppNum(appNum);
                noPermMenuIds.addAll(notPublishedMenuId);
                return noPermMenuIds;
            }
            hasPermEntityNums = AdminPermCache.getVirtualAdminHasPermEntity(adminType.toString());
        }
        Map appIdMenuRuntimeListMap = null == paramMap.get("appIdMenuRuntimeListMap") ? new HashMap(0) : (Map)paramMap.get("appIdMenuRuntimeListMap");
        List list = menuList = null == appIdMenuRuntimeListMap.get(appNum) ? AppMetadataCache.getAppMenusInfoByAppId((String)appNum) : (List)appIdMenuRuntimeListMap.get(appNum);
        if (menuList == null || menuList.size() == 0) {
            return new ArrayList<String>();
        }
        List<String> allMenuFormNums = PermCommonUtil.getFormNumFromMenuMeta(menuList);
        HashMap<String, Set<String>> entityPermItemMap = new HashMap<String, Set<String>>(8);
        List<String> hasBindingPermForms = PermCommonUtil.getHasBindPermFormNums(allMenuFormNums, entityPermItemMap, paramMap);
        boolean paramMapIsEmpty = CollectionUtils.isEmpty(paramMap);
        Map<String, String> checkPermEntityAppMap = PermCommonUtil.getCheckPermEntityAppMapNew(appId, hasBindingPermForms, paramMap);
        for (AppMenuInfo appMenuInfo : menuList) {
            String checkPermAppId;
            String checkPermKey;
            Set bindingPermItemIds;
            boolean issuperadmintype;
            String entityNum;
            String formNum = appMenuInfo.getFormId();
            String menuId = appMenuInfo.getId();
            if (StringUtils.isEmpty((String)formNum) || (entityNum = PermCommonUtil.getEntityNumByFormNum(formNum)) == null) continue;
            Map paramInfo = new HashMap(16);
            String paramName = appMenuInfo.getParams();
            if (StringUtils.isNotEmpty((String)paramName)) {
                paramInfo = (Map)SerializationUtils.fromJsonString((String)paramName, Map.class);
            }
            String superAdminOnlyUse = (String)paramInfo.get("superAdminOnlyUse");
            String superAdminOnlyUseExcSuperUser = (String)paramInfo.get("superAdminOnlyUseExcSuperUser");
            boolean isadmintype = paramMapIsEmpty ? PermissionServiceHelper.isAdminUser((long)adminId, (AdminType)AdminType.Administrator) : (Boolean)paramMap.get("isAdmintype");
            boolean bl2 = issuperadmintype = paramMapIsEmpty ? PermissionServiceHelper.isAdminUser((long)adminId, (String)ADMINTYPE_SUPERADMIN) : (Boolean)paramMap.get("isSuperAdmin");
            if (!(!"true".equals(superAdminOnlyUse) && !"true".equals(superAdminOnlyUseExcSuperUser) || issuperadmintype && isadmintype)) {
                noPermMenuIds.add(menuId);
            }
            if (!hasBindingPermForms.contains(entityNum)) continue;
            String permItemId = appMenuInfo.getPermission();
            String parameterType = appMenuInfo.getParamType();
            if (StringUtils.isEmpty((String)permItemId)) {
                permItemId = "ListShowParameter".equalsIgnoreCase(parameterType) || "ReportShowParameter".equalsIgnoreCase(parameterType) || "FormShowParameter".equalsIgnoreCase(parameterType) ? "47150e89000000ac" : ("BillShowParameter".equalsIgnoreCase(parameterType) || "BaseShowParameter".equalsIgnoreCase(parameterType) ? "47156aff000000ac" : "47150e89000000ac");
            }
            if (CollectionUtils.isEmpty((Collection)(bindingPermItemIds = (Set)entityPermItemMap.get(entityNum))) || !bindingPermItemIds.contains(permItemId) || hasPermEntityNums.contains(checkPermKey = (checkPermAppId = checkPermEntityAppMap.get(entityNum)) + entityNum + permItemId)) continue;
            noPermMenuIds.add(menuId);
        }
        noPermMenuIds.remove("18XQ/L5XWABD");
        return noPermMenuIds;
    }

    @Deprecated
    private static Set<String> getEntityAdminHasPermEntity(Long adminGroupId) {
        String sql = " SELECT DISTINCT fappid||fentitynum||fpermitemid as res FROM t_perm_admingroupfunperm WHERE fusergroupid = " + adminGroupId;
        Set hasPermEntityNums = (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> entity = new HashSet<String>(200);
                while (rs.next()) {
                    String entityNum = rs.getString("res");
                    entity.add(entityNum);
                }
                return entity;
            }
        });
        return hasPermEntityNums;
    }

    @Deprecated
    private static Set<String> getVirtualAdminHasPermEntity(String adminType) {
        String sql = new StringBuffer("select distinct dtl.fbizappid||dtl.fentitynum||dtl.fpermitemid as res from t_perm_adminscheme ads ").append(" inner join t_perm_adminschemeentry ent on (ads.fid = ent.fid) ").append(" inner join t_perm_adminschemedetail dtl on(ent.fentryid = dtl.fentryid) ").append(" where ads.fenable = '1' ").append(" and ent.fadmintype = ? ").toString();
        Set hasPermEntityNums = (Set)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{new SqlParameter(":fadmintype", -5, (Object)Long.valueOf(adminType))}, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> list = new HashSet<String>(200);
                while (rs.next()) {
                    String res = rs.getString("res");
                    list.add(res);
                }
                return list;
            }
        });
        return hasPermEntityNums;
    }

    @Deprecated
    public static boolean checkAdminPerm(Long adminId, String appId, String entityNum) {
        return AdminPermCache.checkAdminPerm(adminId, appId, entityNum, null);
    }

    @Deprecated
    public static boolean checkAdminPerm(Long adminId, String appId, String entityNum, String permItemId) {
        boolean isBindingPerm;
        appId = PermCommonUtil.getCheckPermAppId(appId, entityNum);
        if (!PermissionServiceHelper.isAdminUser((long)adminId)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)permItemId) && !(isBindingPerm = PermCommonUtil.hasBindingFunctionPerm(entityNum, permItemId))) {
            return true;
        }
        try {
            String appNum = AppMetadataCache.getAppNumberById((String)appId);
            if (appNum == null) {
                return false;
            }
            AppInfo appInfo = AppHelper.getMetaAppInfo(appNum);
            if (appInfo == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (!PermCommonUtil.isInSysCloud(appId) && !PermCommonUtil.isAdminDomainApp(appId)) {
            return false;
        }
        return AdminPermCache.checkAdminPermItem(adminId, appId, entityNum, permItemId);
    }

    @Deprecated
    public static boolean checkAdminPermItem(Long adminId, String appId, String entityNum, String permItemId) {
        if (ENTITY_ADMIN.equals(entityNum)) {
            return true;
        }
        boolean isBinding = PermCommonUtil.hasBindingFunctionPerm(entityNum);
        if (!isBinding) {
            return true;
        }
        AdminType adminType = PermissionServiceHelper.getAdminType((long)adminId);
        if (!PermCommonUtil.hasEnableOldAdmin()) {
            String adminInfoStr = CacheMrg.getCache(CacheMrg.getType4AdminGroupUser(), adminId + "");
            if (StringUtils.isNotEmpty((String)adminInfoStr) && !"{}".equals(adminInfoStr)) {
                Map adminInfo = (Map)SerializationUtils.fromJsonString((String)adminInfoStr, Map.class);
                Set adminGroupIds = (Set)SerializationUtils.fromJsonString((String)((String)adminInfo.get("group")), Set.class);
                for (Long adminGroupId : adminGroupIds) {
                    Boolean adminGroupHasPermItem = AdminPermCache.checkAdminGroupHasPermItem(adminGroupId, appId, entityNum, permItemId, adminType);
                    if (!Boolean.TRUE.equals(adminGroupHasPermItem)) continue;
                    return adminGroupHasPermItem;
                }
            }
        } else {
            HashSet<String> permItemSet = StringUtils.isEmpty((String)permItemId) ? new HashSet<String>(1) : new HashSet<String>(Collections.singletonList(permItemId));
            return AdminSchemeHelper.checkVirtualAdminPerm(adminType, appId, entityNum, permItemSet);
        }
        return false;
    }

    @Deprecated
    public static Set<String> getAdminGroupChargeClouds() {
        HashSet<String> cloudIds = new HashSet<String>(4);
        cloudIds.add(SYSCLOUDID);
        cloudIds.add("0QLCSO6KKZC9");
        cloudIds.add(HRCLOUDID);
        return cloudIds;
    }

    @Deprecated
    public static Boolean checkAdminGroupHasPermItem(Long adminGroupId, String appId, String entityNum, String permItemId, AdminType adminType) {
        int entityAdminGroupPermNum = 0;
        DynamicObject adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)"perm_admingroup", (String)"id, parent, level");
        long currentGroupId = adminGroupId;
        long level = adminGroup.getLong("level");
        long parent = adminGroup.getLong("parent.id");
        while (level > 1L && (entityAdminGroupPermNum = AdminPermCache.countEntityAdminGroupPerm(currentGroupId)) == 0) {
            adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)parent, (String)"perm_admingroup", (String)"id, parent, level");
            currentGroupId = parent;
            level = adminGroup.getLong("level");
            parent = adminGroup.getLong("parent.id");
        }
        if (entityAdminGroupPermNum != 0) {
            boolean entityAdminPerm = AdminPermCache.checkEntityAdminPerm(currentGroupId, appId, entityNum, permItemId);
            if (entityAdminPerm) {
                return entityAdminPerm;
            }
        } else {
            HashSet<String> permItemSet = StringUtils.isEmpty((String)permItemId) ? new HashSet<String>(1) : new HashSet<String>(Collections.singletonList(permItemId));
            return AdminSchemeHelper.checkVirtualAdminPerm(adminType, appId, entityNum, permItemSet);
        }
        return Boolean.FALSE;
    }

    @Deprecated
    private static boolean checkEntityAdminPerm(Long adminGroupId, String appId, String entityNum, String permItemId) {
        String sql = " SELECT count(0) cnt FROM t_perm_admingroupfunperm WHERE fusergroupid = ? AND fappid = ? AND fentitynum = ? AND fpermitemid = ? ";
        Boolean exists = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])new Object[]{new SqlParameter(":fusergroupid", -5, (Object)adminGroupId), new SqlParameter(":fappid", 12, (Object)appId), new SqlParameter(":fentitynum", 12, (Object)entityNum), new SqlParameter(":fpermitemid", 12, (Object)permItemId)}, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                int count;
                if (rs.next() && (count = rs.getInt("cnt")) >= 1) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return exists;
    }

    public static int countEntityAdminGroupPerm(Long adminGroupId) {
        String sql = " SELECT count(0) cnt FROM t_perm_admingroupfunperm WHERE fusergroupid = " + adminGroupId;
        int count = (Integer)DB.query((DBRoute)DBRoute.permission, (String)sql, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                int count = 0;
                if (rs.next()) {
                    count = rs.getInt("cnt");
                }
                return count;
            }
        });
        return count;
    }

    @Deprecated
    public static boolean checkVirtualAdminPerm(AdminType adminType, String appId, String entityNum) {
        return AdminSchemeHelper.checkVirtualAdminPerm(adminType, appId, entityNum, null);
    }

    public static List<Long> getAdminExtraUser(Long userId) {
        HashSet adminGroupExtraUsers = new HashSet(100);
        String adminInfoStr = CacheMrg.getCache(CacheMrg.getType4AdminGroupUser(), userId + "");
        if (StringUtils.isNotEmpty((String)adminInfoStr) && !"{}".equals(adminInfoStr)) {
            Map adminInfo = (Map)SerializationUtils.fromJsonString((String)adminInfoStr, Map.class);
            Set adminGroupIds = (Set)SerializationUtils.fromJsonString((String)((String)adminInfo.get("group")), Set.class);
            StringBuilder sql = new StringBuilder().append(" SELECT fuserid FROM t_perm_admingroupadduser WHERE fusergroupid IN (");
            for (Long adminGroupId : adminGroupIds) {
                sql.append(adminGroupId).append(',');
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(')');
            Set adminGroupExtraUser = (Set)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                public Set<Long> handle(ResultSet rs) throws Exception {
                    HashSet<Long> userIds = new HashSet<Long>(100);
                    while (rs.next()) {
                        Long userId = rs.getLong("fuserid");
                        userIds.add(userId);
                    }
                    return userIds;
                }
            });
            adminGroupExtraUsers.addAll(adminGroupExtraUser);
        }
        return new ArrayList<Long>(adminGroupExtraUsers);
    }

    public static HasPermOrgResult getAdminChargeOrgRange(Long userId, String viewType) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        paraMap.put("enableOldAdmin", PermCommonUtil.hasEnableOldAdmin());
        return AdminPermCache.getAdminChargeOrgRangeWithParaMap(userId, viewType, paraMap);
    }

    public static HasPermOrgResult getAdminChargeOrgRangeWithParaMap(Long userId, String viewType, Map<String, Object> paraMap) {
        if (AdminUserCache.isAdminUserWithParaMap(userId.toString(), ADMINTYPE_SUPERADMIN, paraMap)) {
            return new HasPermOrgResultImpl(true, new ArrayList(1));
        }
        String adminInfoStr = CacheMrg.getCache(CacheMrg.getType4AdminGroupUser(), userId + "");
        if (StringUtils.isEmpty((String)adminInfoStr) || "{}".equals(adminInfoStr)) {
            return new HasPermOrgResultImpl(false, new ArrayList(1));
        }
        Map adminInfo = (Map)SerializationUtils.fromJsonString((String)adminInfoStr, Map.class);
        if (null == adminInfo || adminInfo.isEmpty()) {
            return new HasPermOrgResultImpl(false, new ArrayList(1));
        }
        String group = (String)adminInfo.get("group");
        if (StringUtils.isEmpty((String)group)) {
            return new HasPermOrgResultImpl(false, new ArrayList(1));
        }
        Set adminGroupIds = (Set)SerializationUtils.fromJsonString((String)group, Set.class);
        if (null == adminGroupIds || adminGroupIds.isEmpty()) {
            return new HasPermOrgResultImpl(false, new ArrayList(1));
        }
        HashSet<Long> admGroupSetOfUser = new HashSet<Long>(adminGroupIds.size());
        admGroupSetOfUser.addAll(adminGroupIds);
        Map<Long, AdmGroup> DBAdmGroupMap = AdminGroupHelper.getAdmGroupInfoMap(null);
        for (Long groupId : adminGroupIds) {
            AdminPermCache.appendAdmGroupSetOfUser(admGroupSetOfUser, groupId, DBAdmGroupMap);
        }
        HashSet finalOrgRangeSet = new HashSet(128);
        Map<Long, Set<Long>> bizunitOrOrgRangeMap = AdminGroupHelper.getBizunitOrOrgRangeMap(viewType, admGroupSetOfUser);
        for (Long adminGroupId : adminGroupIds) {
            Set<Object> adminOrgRange = new HashSet(100);
            AdmGroup adminGroup = DBAdmGroupMap.get(adminGroupId);
            if (null == adminGroup) {
                throw new KDBizException("admingroup\uff1a[" + adminGroupId + "] not exists\uff0cplease check data correctness\u3002");
            }
            long currentGroupId = adminGroupId;
            Integer level = adminGroup.getLevel();
            long parent = adminGroup.getParent();
            while (level > 1 && CollectionUtils.isEmpty(adminOrgRange) && CollectionUtils.isEmpty(adminOrgRange = bizunitOrOrgRangeMap.get(currentGroupId))) {
                adminGroup = DBAdmGroupMap.get(parent);
                if (null == adminGroup) {
                    throw new KDBizException("admingroup\uff1a[" + adminGroupId + "] not exists\uff0cplease check data correctness\u3002");
                }
                currentGroupId = parent;
                level = adminGroup.getLevel();
                parent = adminGroup.getParent();
            }
            if (!CollectionUtils.isEmpty(adminOrgRange)) {
                finalOrgRangeSet.addAll(adminOrgRange);
                continue;
            }
            return new HasPermOrgResultImpl(true, new ArrayList(1));
        }
        return new HasPermOrgResultImpl(false, new ArrayList(finalOrgRangeSet));
    }

    private static void appendAdmGroupSetOfUser(Set<Long> admGroupSetOfUser, Long groupId, Map<Long, AdmGroup> DBAdmGroupMap) {
        AdmGroup admGroup = DBAdmGroupMap.get(groupId);
        if (null == admGroup) {
            throw new KDBizException("admingroup\uff1a[" + groupId + "] not exists\uff0cplease check data correctness\u3002");
        }
        Integer level = admGroup.getLevel();
        if (null == level) {
            throw new KDBizException("admingroup\uff1a[" + groupId + "] level is null\uff0cplease check data correctness\u3002");
        }
        Long parentId = admGroup.getParent();
        if (Objects.equals(parentId, 0L)) {
            return;
        }
        admGroupSetOfUser.add(parentId);
        AdminPermCache.appendAdmGroupSetOfUser(admGroupSetOfUser, parentId, DBAdmGroupMap);
    }

    private static Set<Long> getEntityAdminGroupOrgRange(Long adminGroupId, String viewType) {
        String table = null;
        table = "01".equals(viewType) ? "t_perm_admingrouporg" : "t_perm_admingroupbizunit";
        String adminOrgRange = " SELECT forgid FROM " + table + " WHERE fusergroupid = " + adminGroupId;
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)adminOrgRange, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> appRange = new HashSet<Long>(100);
                while (rs.next()) {
                    Long orgId = rs.getLong("forgid");
                    appRange.add(orgId);
                }
                return appRange;
            }
        });
    }

    public static List<String> getAdminChargeAppRange(Long userId) {
        return AdminPermCache.getAdminChargeAppRange(userId, null);
    }

    public static List<String> getAdminChargeAppRange(Long userId, Map<String, Object> paraMap) {
        HashSet<String> appRange = new HashSet<String>(1000);
        String adminInfoStr = CacheMrg.getCache(CacheMrg.getType4AdminGroupUser(), userId + "");
        if (StringUtils.isNotEmpty((String)adminInfoStr) && !"{}".equals(adminInfoStr)) {
            Map adminInfo = (Map)SerializationUtils.fromJsonString((String)adminInfoStr, Map.class);
            Set adminGroupIds = (Set)SerializationUtils.fromJsonString((String)((String)adminInfo.get("group")), Set.class);
            HashSet adminGroupAppRanges = new HashSet(100);
            for (Long adminGroupId : adminGroupIds) {
                Set<Object> adminGroupAppRange = new HashSet(100);
                DynamicObject adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)"perm_admingroup", (String)"id, parent, level");
                long currentGroupId = adminGroupId;
                long level = adminGroup.getLong("level");
                long parent = adminGroup.getLong("parent.id");
                while (level > 1L && CollectionUtils.isEmpty(adminGroupAppRange) && CollectionUtils.isEmpty(adminGroupAppRange = AdminPermCache.getEntityAdminGroupAppRange(currentGroupId))) {
                    adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)parent, (String)"perm_admingroup", (String)"id, parent, level");
                    currentGroupId = parent;
                    level = adminGroup.getLong("level");
                    parent = adminGroup.getLong("parent.id");
                }
                if (!CollectionUtils.isEmpty(adminGroupAppRange)) {
                    adminGroupAppRanges.addAll(adminGroupAppRange);
                    continue;
                }
                List<String> appRangeList = AdminPermCache.getVirtualAdminGroupAppRange();
                appRange.addAll(appRangeList);
                adminGroupAppRanges.clear();
                break;
            }
            appRange.addAll(adminGroupAppRanges);
        }
        return new ArrayList<String>(appRange);
    }

    private static List<String> getVirtualAdminGroupAppRange() {
        ArrayList<String> appRange = new ArrayList<String>(100);
        DynamicObjectCollection allBizApps = BizAppServiceHelp.getAllBizApps();
        if (allBizApps == null || allBizApps.isEmpty()) {
            return appRange;
        }
        for (DynamicObject dynamicObject : allBizApps) {
            String appId = dynamicObject.getString("id");
            appRange.add(appId);
        }
        return appRange;
    }

    private static Set<String> getEntityAdminGroupAppRange(Long adminGroupId) {
        HashSet<String> appRange = new HashSet<String>(100);
        String entityName = "perm_admingroupapp";
        String selectProperties = "app";
        QFilter[] filters = new QFilter[]{new QFilter("usergroup.id", "=", (Object)adminGroupId)};
        Map adminGroupApps = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)selectProperties, (QFilter[])filters);
        if (adminGroupApps == null || adminGroupApps.size() == 0) {
            return appRange;
        }
        for (DynamicObject adminGroupApp : adminGroupApps.values()) {
            if (adminGroupApp == null || adminGroupApp.get("app") == null) continue;
            if (adminGroupApp.get("app") instanceof DynamicObject) {
                appRange.add((String)adminGroupApp.getDynamicObject("app").getPkValue());
                continue;
            }
            if (!(adminGroupApp.get("app") instanceof String)) continue;
            appRange.add(adminGroupApp.getString("app"));
        }
        return appRange;
    }

    private static Set<String> getEntityAdminGroupSysRange(Long adminGroupId) {
        String appRange = " SELECT DISTINCT fappid FROM t_perm_admingroupfunperm WHERE fusergroupid = " + adminGroupId;
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)appRange, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> appRange = new HashSet<String>(100);
                while (rs.next()) {
                    String appId = rs.getString("fappid");
                    appRange.add(appId);
                }
                return appRange;
            }
        });
    }

    public static Set<String> getEntityAdminPerm(Long adminGroupId, String appId, String entityNum) {
        String sql = " SELECT fpermitemid FROM t_perm_admingroupfunperm WHERE fusergroupid = ? AND fappid = ? AND fentitynum = ? ";
        Set adminGroupPerm = (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])new Object[]{new SqlParameter(":fusergroupid", -5, (Object)adminGroupId), new SqlParameter(":fappid", 12, (Object)appId), new SqlParameter(":fentitynum", 12, (Object)entityNum)}, (ResultSetHandler)new ResultSetHandler<Set>(){

            public Set handle(ResultSet rs) throws SQLException {
                HashSet<String> set = new HashSet<String>(8);
                while (rs.next()) {
                    set.add(rs.getString("fpermitemid"));
                }
                return set;
            }
        });
        return adminGroupPerm;
    }

    public static Map<String, Map<String, List<String>>> getAdminSysPerm(Long userId) {
        Set<String> adminSysPermSet = AdminPermCache.getAdminSysPermSet(userId);
        if (null == adminSysPermSet) {
            return null;
        }
        if (CollectionUtils.isEmpty(adminSysPermSet)) {
            return new HashMap<String, Map<String, List<String>>>(1);
        }
        HashMap<String, Map<String, List<String>>> result = new HashMap<String, Map<String, List<String>>>(adminSysPermSet.size());
        for (String perm : adminSysPermSet) {
            String[] split = perm.split("\\|");
            String appId = split[0];
            String entityNum = split[1];
            String permItemId = split[2];
            result.computeIfAbsent(appId, k -> new HashMap(16)).computeIfAbsent(entityNum, l -> new ArrayList(10)).add(permItemId);
        }
        return result;
    }

    public static Map<String, Object> getAdminSysPermTwoMap(Long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("adminSysAppEntSetMap", new HashMap(8));
        resultMap.put("adminSysEntPermItemSetMap", new HashMap(8));
        Map<String, Map<String, List<String>>> adminSysPerm = AdminPermCache.getAdminSysPerm(userId);
        if (null == adminSysPerm) {
            return null;
        }
        if (adminSysPerm.isEmpty()) {
            return resultMap;
        }
        Map adminSysAppEntSetMap = (Map)resultMap.get("adminSysAppEntSetMap");
        Map adminSysEntPermItemSetMap = (Map)resultMap.get("adminSysEntPermItemSetMap");
        List<String> sysCloudApp = AdminSchemeHelper.queryAllSysApp(false, true);
        for (Map.Entry<String, Map<String, List<String>>> appEntMap : adminSysPerm.entrySet()) {
            String appId = appEntMap.getKey();
            if (StringUtils.isEmpty((String)appId) || !sysCloudApp.contains(appId)) continue;
            Map<String, List<String>> entPermItemMap = appEntMap.getValue();
            for (Map.Entry<String, List<String>> entPermItem : entPermItemMap.entrySet()) {
                String entNum = entPermItem.getKey();
                if (StringUtils.isEmpty((String)entNum)) continue;
                adminSysAppEntSetMap.computeIfAbsent(appId, k -> new HashSet(16)).add(entNum);
                List<String> permItemIdList = entPermItem.getValue();
                adminSysEntPermItemSetMap.computeIfAbsent(entNum, k -> new HashSet(16)).addAll(permItemIdList);
            }
        }
        return resultMap;
    }

    private static Set<String> getAdminSysPermSet(Long userId) {
        HashSet<String> adminSysPermSet = new HashSet<String>(16);
        String adminInfoStr = CacheMrg.getCache(CacheMrg.getType4AdminGroupUser(), userId + "");
        if (StringUtils.isNotEmpty((String)adminInfoStr) && !"{}".equals(adminInfoStr)) {
            Map adminInfo = (Map)SerializationUtils.fromJsonString((String)adminInfoStr, Map.class);
            Set adminGroupIds = (Set)SerializationUtils.fromJsonString((String)((String)adminInfo.get("group")), Set.class);
            for (Long adminGroupId : adminGroupIds) {
                Set<Object> adminGroupSysPerm = new HashSet(100);
                DynamicObject adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)"perm_admingroup", (String)"id, parent, level");
                long currentGroupId = adminGroupId;
                long level = adminGroup.getLong("level");
                long parent = adminGroup.getLong("parent.id");
                while (level > 1L && CollectionUtils.isEmpty(adminGroupSysPerm) && CollectionUtils.isEmpty(adminGroupSysPerm = AdminPermCache.getEntityAdminGroupSysPerm(currentGroupId))) {
                    adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)parent, (String)"perm_admingroup", (String)"id, parent, level");
                    currentGroupId = parent;
                    level = adminGroup.getLong("level");
                    parent = adminGroup.getLong("parent.id");
                }
                if (!CollectionUtils.isEmpty(adminGroupSysPerm)) {
                    adminSysPermSet.addAll(adminGroupSysPerm);
                    continue;
                }
                return new HashSet<String>(1);
            }
        } else {
            return null;
        }
        return adminSysPermSet;
    }

    private static Set<String> getEntityAdminGroupSysPerm(long adminGroupId) {
        String appRange = " SELECT fappid,fentitynum,fpermitemid FROM t_perm_admingroupfunperm WHERE fusergroupid = " + adminGroupId;
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)appRange, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> perms = new HashSet<String>(100);
                while (rs.next()) {
                    String appId = rs.getString(1);
                    String entityNum = rs.getString(2);
                    String permItemId = rs.getString(3);
                    perms.add(appId + '|' + entityNum + '|' + permItemId);
                }
                return perms;
            }
        });
    }

    public static Set<String> getAdminFunPermInfoWithoutDim(Long adminUserId, Map<String, Object> paramMap) {
        Set<String> hasPermFucPermStrs = new HashSet<String>(8);
        AdminType adminType = null;
        adminType = null == paramMap || null == paramMap.get("adminType") ? PermissionServiceHelper.getAdminType((long)adminUserId) : (AdminType)paramMap.get("adminType");
        String adminInfoStr = CacheMrg.getCache(CacheMrg.getType4AdminGroupUser(), adminUserId + "");
        if (StringUtils.isNotEmpty((String)adminInfoStr) && !"{}".equals(adminInfoStr)) {
            Map adminInfo = (Map)SerializationUtils.fromJsonString((String)adminInfoStr, Map.class);
            Set adminGroupIds = (Set)SerializationUtils.fromJsonString((String)((String)adminInfo.get("group")), Set.class);
            for (Long adminGroupId : adminGroupIds) {
                Set<Object> adminGroupHasPermEntity = new HashSet(100);
                DynamicObject adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)adminGroupId, (String)"perm_admingroup", (String)"id, parent, level");
                long currentGroupId = adminGroupId;
                long level = adminGroup.getLong("level");
                long parent = adminGroup.getLong("parent.id");
                while (level > 1L && CollectionUtils.isEmpty(adminGroupHasPermEntity) && CollectionUtils.isEmpty(adminGroupHasPermEntity = AdminPermCache.getEntityAdminHasPermEntity(currentGroupId))) {
                    adminGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)parent, (String)"perm_admingroup", (String)"id, parent, level");
                    currentGroupId = parent;
                    level = adminGroup.getLong("level");
                    parent = adminGroup.getLong("parent.id");
                }
                if (!CollectionUtils.isEmpty(adminGroupHasPermEntity)) {
                    hasPermFucPermStrs.addAll(adminGroupHasPermEntity);
                    continue;
                }
                hasPermFucPermStrs = AdminPermCache.getVirtualAdminHasPermEntity(adminType.toString());
                break;
            }
        }
        return hasPermFucPermStrs;
    }

    public static List<String> getAdminChargeApps(Long userId, Map<String, Object> paraMap) {
        boolean enableOldAdmin = PermCommonUtil.hasEnableOldAdmin();
        List<String> appIDs = new ArrayList<String>();
        DynamicObject admin = null;
        if (!PermissionServiceHelper.isAdminUser((long)userId)) {
            return appIDs;
        }
        if (!enableOldAdmin) {
            appIDs = AdminPermCache.getAdminChargeAppRange(userId, paraMap);
        } else {
            if (PermissionServiceHelper.isAdminUser((long)userId, (String)ADMINTYPE_SUPERADMIN)) {
                DynamicObjectCollection allBizApps = BizAppServiceHelp.getAllBizApps();
                if (allBizApps == null || allBizApps.isEmpty()) {
                    return appIDs;
                }
                for (DynamicObject dynamicObject : allBizApps) {
                    String appID = dynamicObject.getString("id");
                    appIDs.add(appID);
                }
                return appIDs;
            }
            try {
                admin = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_admin", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
                if (admin == null) {
                    return appIDs;
                }
            }
            catch (Exception e) {
                logger.warn("\u67e5\u8be2\u7528\u6237ID\u4e3a" + userId + "\u7684\u7ba1\u7406\u5458\u5931\u8d25", (Throwable)e);
                return appIDs;
            }
            DynamicObjectCollection appCollection = admin.getDynamicObjectCollection("entry_app");
            if (appCollection != null && !appCollection.isEmpty()) {
                for (DynamicObject appRow : appCollection) {
                    String appID = appRow.getString("app_id");
                    appIDs.add(appID);
                }
            } else {
                String parentID = admin.getString("parent_id");
                return AdminPermCache.getAdminChargeApps(parentID);
            }
        }
        return appIDs;
    }

    private static List<String> getAdminChargeApps(String adminID) {
        ArrayList<String> appIDs = new ArrayList<String>();
        DynamicObject admin = null;
        try {
            admin = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_admin", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)adminID)});
            if (admin == null) {
                return appIDs;
            }
        }
        catch (Exception e) {
            logger.warn("\u67e5\u8be2ID\u4e3a" + adminID + "\u7684\u7ba1\u7406\u5458\u5931\u8d25", (Throwable)e);
            return appIDs;
        }
        Long adminUserId = admin.getLong("user_id");
        if (PermissionServiceHelper.isAdminUser((long)adminUserId, (String)ADMINTYPE_SUPERADMIN)) {
            DynamicObjectCollection allBizApps = BizAppServiceHelp.getAllBizApps();
            if (allBizApps == null || allBizApps.isEmpty()) {
                return appIDs;
            }
            for (DynamicObject dynamicObject : allBizApps) {
                String appID = dynamicObject.getString("id");
                appIDs.add(appID);
            }
            return appIDs;
        }
        DynamicObjectCollection appCollection = admin.getDynamicObjectCollection("entry_app");
        if (appCollection != null && !appCollection.isEmpty()) {
            for (DynamicObject appRow : appCollection) {
                String appID = appRow.getString("app_id");
                appIDs.add(appID);
            }
        } else {
            String parentID = admin.getString("parent_id");
            return AdminPermCache.getAdminChargeApps(parentID);
        }
        return appIDs;
    }

    public static AdminAppResult getAdminApps(Long userId) {
        List<String> appIds = AdminPermCache.getAdminChargeApps(userId, null);
        if (appIds == null || appIds.isEmpty()) {
            return new AdminAppResult(false, appIds);
        }
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        if (null != disabledAppIds && !disabledAppIds.isEmpty()) {
            appIds.removeAll(disabledAppIds);
        }
        appIds.removeIf(k -> StringUtils.isEmpty((String)k));
        return new AdminAppResult(true, appIds);
    }
}

