/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.AdminType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AdminUserCache {
    private static Log logger = LogFactory.getLog(AdminUserCache.class);

    @Deprecated
    public static boolean isAdminUser(String key) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        paraMap.put("enableOldAdmin", PermCommonUtil.hasEnableOldAdmin());
        return AdminUserCache.getAdminTypeWithParaMap(key, paraMap) != null;
    }

    public static boolean isAdminUserWithParaMap(String key, Map<String, Object> paraMap) {
        return AdminUserCache.getAdminTypeWithParaMap(key, paraMap) != null;
    }

    @Deprecated
    public static boolean isAdminUser(String key, String virtualType) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        paraMap.put("enableOldAdmin", PermCommonUtil.hasEnableOldAdmin());
        return AdminUserCache.isAdminUserWithParaMap(key, virtualType, paraMap);
    }

    public static boolean isAdminUserWithParaMap(String key, String virtualType, Map<String, Object> paraMap) {
        if (StringUtils.isNotEmpty((String)virtualType)) {
            return virtualType.equals(AdminUserCache.getVirtualTypeWithParaMap(key, virtualType, paraMap));
        }
        return false;
    }

    @Deprecated
    public static boolean isAdminUser(String key, AdminType adminType) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        paraMap.put("enableOldAdmin", PermCommonUtil.hasEnableOldAdmin());
        return AdminUserCache.isAdminUserWithParaMap(key, adminType, paraMap);
    }

    public static boolean isAdminUserWithParaMap(String key, AdminType adminType, Map<String, Object> paraMap) {
        if (adminType != null) {
            return adminType.equals((Object)AdminUserCache.getAdminTypeWithParaMap(key, paraMap));
        }
        return false;
    }

    @Deprecated
    public static String getVirtualType(String userId, String virtualType) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        paraMap.put("enableOldAdmin", PermCommonUtil.hasEnableOldAdmin());
        return AdminUserCache.getVirtualTypeWithParaMap(userId, virtualType, paraMap);
    }

    public static String getVirtualTypeWithParaMap(String userId, String virtualType, Map<String, Object> paraMap) {
        Map<String, String> adminInfo = AdminUserCache.getAdminInfoWithParaMap(userId, paraMap);
        if (adminInfo.isEmpty()) {
            return null;
        }
        return adminInfo.get("adminRootType");
    }

    @Deprecated
    public static AdminType getAdminType(String userId) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        paraMap.put("enableOldAdmin", PermCommonUtil.hasEnableOldAdmin());
        return AdminUserCache.getAdminTypeWithParaMap(userId, paraMap);
    }

    public static AdminType getAdminTypeWithParaMap(String userId, Map<String, Object> paraMap) {
        Map<String, String> adminInfo = AdminUserCache.getAdminInfoWithParaMap(userId, paraMap);
        if (adminInfo.isEmpty()) {
            return null;
        }
        return AdminType.getAdminType((String)adminInfo.get("adminType"));
    }

    @Deprecated
    private static Map<String, String> getAdminInfo(String userId) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        paraMap.put("enableOldAdmin", PermCommonUtil.hasEnableOldAdmin());
        return AdminUserCache.getAdminInfoWithParaMap(userId, paraMap);
    }

    private static Map<String, String> getAdminInfoWithParaMap(String userId, Map<String, Object> paraMap) {
        Map<String, String> adminInfo;
        boolean enableOldAdmin;
        boolean bl = enableOldAdmin = null == paraMap || null == paraMap.get("enableOldAdmin") ? PermCommonUtil.hasEnableOldAdmin(paraMap) : (Boolean)paraMap.get("enableOldAdmin");
        String type4Admin = null == paraMap || null == paraMap.get("type4Admin") ? (enableOldAdmin ? CacheMrg.getType4AdminUserOld() : CacheMrg.getType4AdminGroupUser()) : (String)paraMap.get("type4Admin");
        String strAdminInfo = null == paraMap || null == paraMap.get("strAdminInfo") ? CacheMrg.getCache(type4Admin, userId) : (String)paraMap.get("strAdminInfo");
        logger.debug("[AdminUserCache][getAdminInfoWithParaMap]\u5165\u53c2:key={}@, \u51fa\u53c2\u67e5\u8be2:type={},field={},value={}", new Object[]{userId, type4Admin, userId, strAdminInfo});
        if (StringUtils.isNotNull((String)strAdminInfo)) {
            try {
                adminInfo = (Map<String, String>)SerializationUtils.fromJsonString((String)strAdminInfo, Map.class);
            }
            catch (Exception e) {
                adminInfo = AdminUserCache.loadCacheWithParaMap(type4Admin, userId, paraMap);
            }
        } else {
            adminInfo = AdminUserCache.loadCacheWithParaMap(type4Admin, userId, paraMap);
        }
        return adminInfo;
    }

    @Deprecated
    private static Map<String, String> loadCache(String type, String userId) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        paraMap.put("enableOldAdmin", PermCommonUtil.hasEnableOldAdmin());
        return AdminUserCache.loadCacheWithParaMap(type, userId, paraMap);
    }

    private static Map<String, String> loadCacheWithParaMap(final String type, final String userId, Map<String, Object> paraMap) {
        boolean enableOldAdmin = null == paraMap || null == paraMap.get("enableOldAdmin") ? PermCommonUtil.hasEnableOldAdmin() : (Boolean)paraMap.get("enableOldAdmin");
        DLock dl = null;
        try {
            Map result;
            dl = DLock.create((String)("loadAdminVirtualType_" + userId));
            dl.lock();
            String strAdminInfo = null;
            try {
                strAdminInfo = CacheMrg.getCache(type, userId);
                if (StringUtils.isNotNull((String)strAdminInfo)) {
                    Map map = (Map)SerializationUtils.fromJsonString((String)strAdminInfo, Map.class);
                    return map;
                }
            }
            catch (Exception e) {
                logger.warn("[AdminUserCache][loadCache]\u53cd\u5e8f\u5217\u5316\u6570\u636e\u5f02\u5e38 strAdminInfo = " + strAdminInfo, (Throwable)e);
            }
            if (!enableOldAdmin) {
                String newSql = " SELECT uap.fuserid, uap.fadmingroupid, ug.flevel, ug.fadmintype FROM t_perm_useradmingroup uap  INNER JOIN t_perm_admingroup ug ON uap.fadmingroupid = ug.fid  INNER JOIN t_perm_adminscheme sch ON sch.fid = ug.fadminscheme  WHERE uap.fuserid = " + userId + " AND sch.fenable = '1' ORDER BY ug.flevel ";
                result = (Map)DB.query((DBRoute)DBRoute.permission, (String)newSql, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                    public Map<String, String> handle(ResultSet rs) throws SQLException {
                        HashMap<String, String> adminInfo = new HashMap<String, String>(3);
                        HashSet<String> userIds = new HashSet<String>(16);
                        HashSet<Long> adminGroupIds = new HashSet<Long>(16);
                        String userID = "";
                        while (rs.next()) {
                            userID = rs.getString("FUSERID");
                            long adminGroupId = rs.getLong("FADMINGROUPID");
                            adminGroupIds.add(adminGroupId);
                            if (userIds.contains(userID)) continue;
                            userIds.add(userID);
                            String adminRootType = rs.getLong("FLEVEL") == 1L ? "10" : "20";
                            String adminType = rs.getString("FADMINTYPE");
                            adminInfo.put("adminRootType", adminRootType);
                            adminInfo.put("adminType", adminType);
                        }
                        if (adminGroupIds.size() > 0) {
                            adminInfo.put("group", SerializationUtils.toJsonString(adminGroupIds));
                        }
                        CacheMrg.putCache(type, userId, SerializationUtils.toJsonString(adminInfo));
                        return adminInfo;
                    }
                });
            } else {
                String sql = "select FUSERID, FTYPE, FADMINTYPE from T_PERM_Admin  where fuserid = " + userId + " AND fadmintype in (  select e.fadmintype from t_perm_adminscheme m inner join t_perm_adminschemeentry e on (m.fid =e.fid and m.FENABLE = '1')) ";
                result = (Map)DB.query((DBRoute)DBRoute.permission, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                    public Map<String, String> handle(ResultSet rs) throws SQLException {
                        HashMap<String, String> adminInfo = new HashMap<String, String>(3);
                        String adminRootType = null;
                        String adminType = null;
                        while (rs.next()) {
                            adminRootType = rs.getString("FTYPE");
                            adminType = rs.getString("FADMINTYPE");
                            adminInfo.put("adminRootType", adminRootType);
                            adminInfo.put("adminType", adminType);
                        }
                        CacheMrg.putCache(type, userId, SerializationUtils.toJsonString(adminInfo));
                        return adminInfo;
                    }
                });
            }
            Map map = result;
            return map;
        }
        catch (Exception e) {
            logger.warn("[AdminUserCache]\u521d\u59cb\u5316\u7ba1\u7406\u5458[" + userId + "]\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            throw e;
        }
        finally {
            if (dl != null) {
                dl.unlock();
            }
        }
    }

    public static boolean updateAdminChargeOrgs(Long parentOrgId, List<Long> forUpdateOrgIds, boolean isAdd) {
        return AdminUserCache.updateAdminChargeOrgs(parentOrgId, forUpdateOrgIds, "15", isAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateAdminChargeOrgs(Long parentOrgId, List<Long> forUpdateOrgIds, String orgViewType, boolean isAdd) {
        boolean notExist;
        boolean enableOldAdmin = PermCommonUtil.hasEnableOldAdmin();
        if (parentOrgId == null && isAdd) {
            logger.warn(ResManager.loadKDString((String)"parentOrgId\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u66f4\u65b0\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5931\u8d25\u3002", (String)"AdminUserCache_1", (String)"bos-permission-cache", (Object[])new Object[0]));
            return false;
        }
        String viewId = "";
        if ("15".equals(orgViewType)) {
            viewId = "15";
        } else if ("01".equals(orgViewType)) {
            viewId = "1";
        } else {
            logger.warn(ResManager.loadKDString((String)"\u66f4\u65b0\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\uff1a\u7ec4\u7ec7\u89c6\u56fe\u7c7b\u578b\u4e0d\u4e3a\u4e1a\u52a1\u5355\u5143\u6216\u884c\u653f\u7ec4\u7ec7\uff0corgViewType = %1\u3002", (String)"AdminUserCache_4", (String)"bos-permission-cache", (Object[])new Object[]{orgViewType}));
            return false;
        }
        String checkSql = "";
        if (parentOrgId != null && (notExist = ((Boolean)DB.query((DBRoute)DBRoute.basedata, (String)(checkSql = "SELECT count(0) from t_org_structure where forgid = " + parentOrgId + " and fviewid = " + viewId), rs -> {
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            return count == 0;
        })).booleanValue())) {
            logger.warn(ResManager.loadKDString((String)"parentOrgId=%1\u4e0d\u5b58\u5728\u5f53\u524d\u89c6\u56feviewType=%2\uff0c\u66f4\u65b0\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5931\u8d25\u3002", (String)"AdminUserCache_2", (String)"bos-permission-cache", (Object[])new Object[]{parentOrgId, orgViewType}));
            return false;
        }
        if (forUpdateOrgIds == null || forUpdateOrgIds.isEmpty()) {
            logger.warn(ResManager.loadKDString((String)"forUpdateOrgIds\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u6240\u4f20\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5f53\u524d\u89c6\u56feviewType=%1\uff0c\u66f4\u65b0\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5931\u8d25\u3002", (String)"AdminUserCache_3", (String)"bos-permission-cache", (Object[])new Object[]{orgViewType}));
            return false;
        }
        StringBuilder checkUpdateOrgIds = new StringBuilder();
        for (Long forUpdateOrgId : forUpdateOrgIds) {
            checkUpdateOrgIds.append(forUpdateOrgId).append(",");
        }
        checkUpdateOrgIds.deleteCharAt(checkUpdateOrgIds.length() - 1);
        StringBuilder checkSqlSb = new StringBuilder().append("SELECT DISTINCT forgid FROM t_org_structure WHERE forgid IN (").append((CharSequence)checkUpdateOrgIds).append(") AND fviewid = ").append(viewId);
        forUpdateOrgIds = (List)DB.query((DBRoute)DBRoute.basedata, (String)checkSqlSb.toString(), rs -> {
            ArrayList<Long> orgIds = new ArrayList<Long>(10);
            while (rs.next()) {
                orgIds.add(rs.getLong(1));
            }
            return orgIds;
        });
        if (forUpdateOrgIds == null || forUpdateOrgIds.isEmpty()) {
            logger.warn(ResManager.loadKDString((String)"forUpdateOrgIds\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u6240\u4f20\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5f53\u524d\u89c6\u56feviewType=%1\uff0c\u66f4\u65b0\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5931\u8d25\u3002", (String)"AdminUserCache_3", (String)"bos-permission-cache", (Object[])new Object[]{orgViewType}));
            return false;
        }
        logger.debug(String.format("AdminUserCache.updateAdminChargeOrgs() param: %s, %s, %s, %s", parentOrgId, Arrays.toString(forUpdateOrgIds.toArray()), orgViewType, isAdd));
        String tableName = "";
        String idField = "";
        String entryKey = "";
        if ("15".equals(orgViewType)) {
            if (!enableOldAdmin) {
                tableName = "t_perm_admingroupbizunit";
                idField = "forgid";
            } else {
                tableName = "t_perm_adminbizentry";
                idField = "fbizorgid";
                entryKey = "bizlist";
            }
        } else if ("01".equals(orgViewType)) {
            if (!enableOldAdmin) {
                tableName = "t_perm_admingrouporg";
                idField = "forgid";
            } else {
                tableName = "t_perm_adminorgentry";
                idField = "fadminorgid";
                entryKey = "entry_adminorg";
            }
        }
        DLock dl = null;
        try {
            Object genEntryIds;
            Set existData;
            dl = DLock.create((String)("updateAdminChargeOrgs_" + orgViewType + "_" + isAdd + "_" + parentOrgId));
            dl.lock();
            StringBuilder updateOrgIds = new StringBuilder();
            for (int i = 0; i < forUpdateOrgIds.size(); ++i) {
                updateOrgIds.append(forUpdateOrgIds.get(i));
                if (i == forUpdateOrgIds.size() - 1) continue;
                updateOrgIds.append(',');
            }
            HashSet<String> pendingData = null;
            StringBuilder sb = new StringBuilder();
            if (!enableOldAdmin) {
                if (isAdd) {
                    sb.append(" SELECT fusergroupid FROM ").append(tableName).append(" WHERE ").append(idField).append(" = ").append(parentOrgId);
                    Set userGroupIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), rs -> {
                        HashSet<String> ids = new HashSet<String>(16);
                        while (rs.next()) {
                            ids.add(rs.getString(1));
                        }
                        return ids;
                    });
                    if (CollectionUtils.isEmpty((Collection)userGroupIds)) {
                        pendingData = new HashSet<String>(16);
                    } else {
                        pendingData = new HashSet(16);
                        for (String userGroupId : userGroupIds) {
                            for (Long forUpdateOrgId : forUpdateOrgIds) {
                                pendingData.add(userGroupId + "|" + forUpdateOrgId);
                            }
                        }
                        sb.setLength(0);
                        String userGroupParam = String.join((CharSequence)",", userGroupIds);
                        sb.append(" SELECT fusergroupid, forgid FROM ").append(tableName).append(" WHERE fusergroupid IN (").append(userGroupParam).append(") AND ").append(idField).append(" IN (").append((CharSequence)updateOrgIds).append(") ");
                        existData = (Set)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), null, rs -> {
                            HashSet<String> result = new HashSet<String>(16);
                            while (rs.next()) {
                                result.add(rs.getString(1) + "|" + rs.getString(2));
                            }
                            return result;
                        });
                        pendingData.removeAll(existData);
                    }
                } else {
                    sb.append(" SELECT fid, fusergroupid FROM ").append(tableName).append(" WHERE ").append(idField).append(" IN (").append((CharSequence)updateOrgIds).append(") ");
                    pendingData = (HashSet<String>)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), rs -> {
                        HashSet<String> result = new HashSet<String>(16);
                        while (rs.next()) {
                            result.add(rs.getString(1));
                        }
                        return result;
                    });
                }
            } else if (isAdd) {
                sb.append(" SELECT fid FROM ").append(tableName).append(" WHERE ").append(idField).append(" = ").append(parentOrgId);
                Set adminIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), rs -> {
                    HashSet<String> ids = new HashSet<String>(16);
                    while (rs.next()) {
                        ids.add(rs.getString(1));
                    }
                    return ids;
                });
                if (CollectionUtils.isEmpty((Collection)adminIds)) {
                    pendingData = new HashSet(16);
                } else {
                    pendingData = new HashSet(16);
                    for (Object adminId : adminIds) {
                        for (Long forUpdateOrgId : forUpdateOrgIds) {
                            pendingData.add((String)adminId + "|" + forUpdateOrgId);
                        }
                    }
                    sb.setLength(0);
                    StringBuilder adminIdParam = new StringBuilder();
                    for (String adminId : adminIds) {
                        adminIdParam.append("'").append(adminId).append("',");
                    }
                    adminIdParam.deleteCharAt(adminIdParam.length() - 1);
                    sb.append(" SELECT fid, ").append(idField).append(" FROM ").append(tableName).append(" WHERE fid IN (").append((CharSequence)adminIdParam).append(") AND ").append(idField).append(" IN (").append((CharSequence)updateOrgIds).append(") ");
                    existData = (Set)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), null, rs -> {
                        HashSet<String> result = new HashSet<String>(16);
                        while (rs.next()) {
                            result.add(rs.getString(1) + "|" + rs.getString(2));
                        }
                        return result;
                    });
                    pendingData.removeAll(existData);
                }
            } else {
                sb.append(" SELECT FID, FENTRYID FROM ").append(tableName).append(" WHERE ").append(idField).append(" IN (").append((CharSequence)updateOrgIds).append(") ");
                pendingData = (Set)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), null, rs -> {
                    HashSet<String> result = new HashSet<String>(16);
                    while (rs.next()) {
                        result.add(rs.getString(1) + "|" + rs.getString(2));
                    }
                    return result;
                });
            }
            if (pendingData == null || pendingData.isEmpty()) {
                StringBuilder sbErrInfo = new StringBuilder();
                sbErrInfo.append(ResManager.loadKDString((String)"\u66f4\u65b0\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u5931\u8d25\uff1a\u672a\u67e5\u5230\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e ", (String)"AdminUserCache_0", (String)"bos-permission-cache", (Object[])new Object[0])).append((CharSequence)sb);
                logger.debug(sbErrInfo.toString());
                boolean adminIdParam = true;
                return adminIdParam;
            }
            String sql = "";
            if (isAdd) {
                ArrayList<Object[]> params;
                int pendingDataSize = pendingData.size();
                if (!enableOldAdmin) {
                    genEntryIds = DB.genLongIds((String)tableName, (int)pendingDataSize);
                    int idsIndex = 0;
                    params = new ArrayList<Object[]>(pendingDataSize);
                    sql = "INSERT INTO " + tableName + " (FID, FUSERGROUPID, FORGID) VALUES (?,?,?)";
                    for (String data : pendingData) {
                        String[] dataInfo = data.split("\\|");
                        Long adminGroupId = Long.parseLong(dataInfo[0]);
                        Long orgId = Long.parseLong(dataInfo[1]);
                        params.add(new Object[]{(long)genEntryIds[idsIndex++], adminGroupId, orgId});
                    }
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)sql, params);
                } else {
                    genEntryIds = DB.genStringIds((String)tableName, (int)pendingDataSize);
                    int idsIndex = 0;
                    params = new ArrayList(pendingDataSize);
                    sql = "INSERT INTO " + tableName + " (FID, FENTRYID, FSEQ, " + idField + ") VALUES (?,?,?,?)";
                    for (String data : pendingData) {
                        String[] dataInfo = data.split("\\|");
                        String adminId = dataInfo[0];
                        Long orgId = Long.parseLong(dataInfo[1]);
                        params.add(new Object[]{adminId, genEntryIds[idsIndex++], 0, orgId});
                    }
                    DB.executeBatch((DBRoute)DBRoute.permission, (String)sql, params);
                }
                logger.debug(sql);
            } else if (!enableOldAdmin) {
                ArrayList<Object[]> params = new ArrayList<Object[]>(pendingData.size());
                genEntryIds = pendingData.iterator();
                while (genEntryIds.hasNext()) {
                    String data = (String)genEntryIds.next();
                    params.add(new Object[]{Long.valueOf(data)});
                }
                String deleteSql = " DELETE FROM " + tableName + " WHERE fid = ? ";
                DB.executeBatch((DBRoute)DBRoute.permission, (String)deleteSql, params);
            } else {
                HashSet<String> ids = new HashSet<String>(1000);
                HashSet<String> entryIds = new HashSet<String>(1000);
                for (String data : pendingData) {
                    String[] idArr = data.split("\\|");
                    ids.add(idArr[0]);
                    entryIds.add(idArr[1]);
                }
                Object[] adminObjs = BusinessDataServiceHelper.load((String)"perm_admin", (String)("id," + entryKey + "." + "id"), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                if (ArrayUtils.isNotEmpty((Object[])adminObjs)) {
                    boolean ifChangeData = false;
                    for (Object adminObj : adminObjs) {
                        DynamicObjectCollection orgs = adminObj.getDynamicObjectCollection(entryKey);
                        Iterator iterator = orgs.iterator();
                        while (iterator.hasNext()) {
                            DynamicObject orgDObj = (DynamicObject)iterator.next();
                            if (!entryIds.contains(orgDObj.getString("id"))) continue;
                            iterator.remove();
                            ifChangeData = true;
                        }
                    }
                    if (ifChangeData) {
                        SaveServiceHelper.save((DynamicObject[])adminObjs);
                    }
                }
            }
            PermissionServiceHelper.clearAllCache();
            logger.debug(ResManager.loadKDString((String)"\u66f4\u65b0\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u6210\u529f\u3002", (String)"AdminUserCache_5", (String)"bos-permission-cache", (Object[])new Object[0]));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.warn(ResManager.loadKDString((String)"\u66f4\u65b0\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (String)"AdminUserCache_6", (String)"bos-permission-cache", (Object[])new Object[0]), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (dl != null) {
                dl.unlock();
            }
        }
    }

    public static void putCache(String key, String value) {
        String type = !PermCommonUtil.hasEnableOldAdmin() ? CacheMrg.getType4AdminGroupUser() : CacheMrg.getType4AdminUserOld();
        CacheMrg.putCache(type, key, value);
    }

    public static void removeCache(String key) {
        String type = !PermCommonUtil.hasEnableOldAdmin() ? CacheMrg.getType4AdminGroupUser() : CacheMrg.getType4AdminUserOld();
        CacheMrg.clearCache(type, key);
    }

    public static void removeCache(List<String> userIds) {
        String type = !PermCommonUtil.hasEnableOldAdmin() ? CacheMrg.getType4AdminGroupUser() : CacheMrg.getType4AdminUserOld();
        CacheMrg.clearCache(type, userIds.toArray(new String[0]));
    }

    public static void removeAllCache() {
        String type = !PermCommonUtil.hasEnableOldAdmin() ? CacheMrg.getType4AdminGroupUser() : CacheMrg.getType4AdminUserOld();
        CacheMrg.clearCache(type);
        type = CacheMrg.getType4AdminChargeOrgs();
        CacheMrg.clearCache(type);
    }
}

