/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.sql.Date;
import java.sql.ResultSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.BizRoleService;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.UserBizRoleCache;
import kd.bos.permission.cache.helper.OrgHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BizRoleFunPermService {
    private static Log log = LogFactory.getLog(BizRoleFunPermService.class);
    public static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_BizRoleFunPermService", (int)4);

    public static Set<Long> getUserBizRoleIDs(Long userId, boolean containUsrGrpQuery) {
        return BizRoleFunPermService.getUserBizRoleIDs(userId, containUsrGrpQuery, true);
    }

    public static Set<Long> getUserBizRoleIDs(Long userId, boolean containUsrGrpQuery, boolean useCache) {
        String cachedStr;
        Set<Long> resultSet = new HashSet<Long>(8);
        String cacheType = CacheMrg.getType4UserOwnBusiRoleIds();
        String cacheKey = String.valueOf(userId) + String.valueOf(containUsrGrpQuery);
        String string = cachedStr = useCache ? CacheMrg.getCache(cacheType, cacheKey) : null;
        if (StringUtils.isNotEmpty((String)cachedStr)) {
            Set bizRoleIdStrSet = (Set)SerializationUtils.fromJsonString((String)cachedStr, Set.class);
            if (null != bizRoleIdStrSet && !bizRoleIdStrSet.isEmpty()) {
                resultSet = bizRoleIdStrSet.stream().map(x -> Long.parseLong(x)).collect(Collectors.toSet());
            }
            return resultSet;
        }
        String sqlString = "select distinct pb.fid bizroleid from t_perm_bizrole pb inner join t_perm_userbizrole pub on pb.fid=pub.fbizroleid where pb.fenable = '1' and pub.fuserid=? ";
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        if (enableValidateTime) {
            sqlString = sqlString + " and ( now() between pub.fstarttime and pub.fendtime or (pub.fstarttime is null and pub.fendtime is null) or ( now() >= pub.fstarttime and pub.fendtime is null) or (pub.fstarttime is null and now() <=  pub.fendtime ))";
        }
        Object[] params = new Object[]{userId};
        Set bizRoleIDSet = (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlString, (Object[])params, rs -> {
            HashSet<Long> innerSet = new HashSet<Long>(8);
            while (rs.next()) {
                Long bizRoleId = rs.getLong("bizroleid");
                innerSet.add(bizRoleId);
            }
            return innerSet;
        });
        resultSet.addAll(bizRoleIDSet);
        if (containUsrGrpQuery) {
            resultSet.addAll(BizRoleFunPermService.getUserUsrGrpBizRoleIDs(userId));
        }
        CacheMrg.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(resultSet.stream().map(String::valueOf).collect(Collectors.toSet())));
        return resultSet;
    }

    public static Set<Long> getUserBizRoleIDs(Long userId) {
        return BizRoleFunPermService.getUserBizRoleIDs(userId, true);
    }

    private static Future<Set<Long>> getPermBizRoleIDs(final String appId, final String entityNum, final String permItemId, RequestContext requextContext) {
        Callable<Set<Long>> bizRoleIDsCallable = new Callable<Set<Long>>(){

            @Override
            public Set<Long> call() throws Exception {
                String sql = "select distinct pbp.fid bizroleid from t_perm_bizroleperm pbp  where pbp.fbizappid= ? and pbp.fentitytypeid= ? and pbp.fpermitemid=?";
                Object[] params = new Object[]{appId, entityNum, permItemId};
                return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                    public Set<Long> handle(ResultSet rs) throws Exception {
                        HashSet<Long> bizRoleIds = new HashSet<Long>(16);
                        while (rs.next()) {
                            Long bizRoleId = rs.getLong("bizroleid");
                            bizRoleIds.add(bizRoleId);
                        }
                        return bizRoleIds;
                    }
                });
            }
        };
        return pool.submit((Callable)bizRoleIDsCallable, requextContext);
    }

    private static Future<Set<Long>> getPermBizRoleIDsWithOrg(final Long orgId, final String orgView, final String appId, final String entityNum, final String permItemId, RequestContext requextContext) {
        Callable<Set<Long>> bizRoleIDsCallable = new Callable<Set<Long>>(){

            @Override
            public Set<Long> call() throws Exception {
                String[] suitableViewId = OrgHelper.getSuitableViewId(orgView);
                StringBuilder sql = new StringBuilder();
                sql.append(" SELECT DISTINCT PBP.FID BIZROLEID FROM T_PERM_BIZROLEPERM PBP INNER JOIN T_PERM_BIZROLEORG PBO ON PBP.FID=PBO.FID ").append(" INNER JOIN T_ORG_STRUCTURE OS ON OS.FORGID = PBO.FORGID ").append(" WHERE PBP.FBIZAPPID= ? AND PBP.FENTITYTYPEID= ? AND PBP.FPERMITEMID=? AND PBO.FORGID=? and PBO.FDIMTYPE='bos_org' AND OS.FVIEWID = ? ");
                Object[] params = new Object[]{appId, entityNum, permItemId, orgId, Long.valueOf(suitableViewId[1])};
                return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                    public Set<Long> handle(ResultSet rs) throws Exception {
                        HashSet<Long> bizRoleIds = new HashSet<Long>(16);
                        while (rs.next()) {
                            Long bizRoleId = rs.getLong("BIZROLEID");
                            bizRoleIds.add(bizRoleId);
                        }
                        return bizRoleIds;
                    }
                });
            }
        };
        return pool.submit((Callable)bizRoleIDsCallable, requextContext);
    }

    private static Future<Set<Long>> getPermBizRoleIDsWithSupOrg(final List<Long> supOrgIds, final String appId, final String entityNum, final String permItemId, RequestContext requextContext) {
        Callable<Set<Long>> bizRoleIDsCallable = new Callable<Set<Long>>(){

            @Override
            public Set<Long> call() throws Exception {
                if (supOrgIds == null || supOrgIds.isEmpty()) {
                    return new HashSet<Long>(16);
                }
                StringBuilder sqlSB = new StringBuilder("SELECT DISTINCT PBP.FID BIZROLEID FROM T_PERM_BIZROLEPERM PBP INNER JOIN T_PERM_BIZROLEORG PBO ON PBP.FID=PBO.FID");
                sqlSB.append(" WHERE PBP.FBIZAPPID= ? AND PBP.FENTITYTYPEID= ? AND PBP.FPERMITEMID=? AND PBO.FISINCLUDESUBORG='1' and PBO.FDIMTYPE='bos_org' AND  PBO.FORGID IN (");
                for (int i = 0; i < supOrgIds.size(); ++i) {
                    sqlSB.append('\'').append(supOrgIds.get(i)).append("',");
                }
                sqlSB.deleteCharAt(sqlSB.length() - 1);
                sqlSB.append(')');
                Object[] params = new Object[]{appId, entityNum, permItemId};
                return (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                    public Set<Long> handle(ResultSet rs) throws Exception {
                        HashSet<Long> bizRoleIds = new HashSet<Long>(16);
                        while (rs.next()) {
                            Long bizRoleId = rs.getLong("BIZROLEID");
                            bizRoleIds.add(bizRoleId);
                        }
                        return bizRoleIds;
                    }
                });
            }
        };
        return pool.submit((Callable)bizRoleIDsCallable, requextContext);
    }

    private static Future<Set<String>> getCommRoleIDs(final String appId, final String entityNum, final String permItemId, RequestContext requextContext) {
        Callable<Set<String>> roleIDsCallable = new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                String sql = "select distinct rpd.froleid from t_perm_rolepermdetial rpd  where rpd.fbizappid= ? and rpd.fentitytypeid= ? and rpd.fpermitemid=?";
                Object[] params = new Object[]{appId, entityNum, permItemId};
                Set commRoleIDs = (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

                    public Set<String> handle(ResultSet rs) throws Exception {
                        HashSet<String> roleIds = new HashSet<String>(16);
                        while (rs.next()) {
                            String roleId = rs.getString("froleid");
                            roleIds.add(roleId);
                        }
                        return roleIds;
                    }
                });
                if (commRoleIDs.isEmpty()) {
                    return commRoleIDs;
                }
                ArrayList commRoleList = new ArrayList(commRoleIDs.size());
                commRoleList.addAll(commRoleIDs);
                StringBuilder roleEnableSB = new StringBuilder("SELECT FID FROM T_PERM_ROLE");
                roleEnableSB.append(" WHERE FID IN (");
                for (int i = 0; i < commRoleList.size(); ++i) {
                    roleEnableSB.append('\'').append((String)commRoleList.get(i)).append("',");
                }
                roleEnableSB.deleteCharAt(roleEnableSB.length() - 1);
                roleEnableSB.append(" ) AND FENABLE='1'");
                return (Set)DB.query((DBRoute)DBRoute.permission, (String)roleEnableSB.toString(), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

                    public Set<String> handle(ResultSet rs) throws Exception {
                        HashSet<String> enableRoleIds = new HashSet<String>(16);
                        while (rs.next()) {
                            String roleId = rs.getString("FID");
                            enableRoleIds.add(roleId);
                        }
                        return enableRoleIds;
                    }
                });
            }
        };
        return pool.submit((Callable)roleIDsCallable, requextContext);
    }

    private static Future<Set<Long>> getOrgBizRoleIDs(final Long orgId, final String orgView, final List<String> commRoleIdList, RequestContext requextContext) {
        Callable<Set<Long>> bizRoleIDsCallable = new Callable<Set<Long>>(){

            @Override
            public Set<Long> call() throws Exception {
                if (orgId == null || commRoleIdList == null || commRoleIdList.isEmpty()) {
                    return new HashSet<Long>(16);
                }
                String[] suitableViewId = OrgHelper.getSuitableViewId(orgView);
                StringBuilder sqlSB = new StringBuilder("SELECT DISTINCT PBO.FID BIZROLEID FROM T_PERM_BIZROLEORG PBO INNER JOIN T_PERM_BIZROLECOMROLE PBC ON PBO.FID=PBC.FID");
                sqlSB.append(" INNER JOIN T_ORG_STRUCTURE OS ON OS.FORGID = PBO.FORGID");
                sqlSB.append(" WHERE PBO.FORGID=").append(orgId);
                sqlSB.append(" and PBO.FDIMTYPE='bos_org' ");
                sqlSB.append(" AND OS.FVIEWID = ").append(Long.valueOf(suitableViewId[1]));
                sqlSB.append(" AND PBC.FROLEID IN (");
                for (int i = 0; i < commRoleIdList.size(); ++i) {
                    sqlSB.append('\'').append((String)commRoleIdList.get(i)).append("',");
                }
                sqlSB.deleteCharAt(sqlSB.length() - 1);
                sqlSB.append(" )");
                return (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                    public Set<Long> handle(ResultSet rs) throws Exception {
                        HashSet<Long> bizRoleIds = new HashSet<Long>(16);
                        while (rs.next()) {
                            Long bizRoleId = rs.getLong("BIZROLEID");
                            bizRoleIds.add(bizRoleId);
                        }
                        return bizRoleIds;
                    }
                });
            }
        };
        return pool.submit((Callable)bizRoleIDsCallable, requextContext);
    }

    @Deprecated
    public static int cacheCheckPermissionWithOrg(long userId, long orgId, String appId, String entityNum, String permItemId) {
        return BizRoleFunPermService.cacheCheckPermissionWithOrg(userId, orgId, "15", appId, entityNum, permItemId);
    }

    public static int cacheCheckPermissionWithOrg(long userId, long orgId, String orgView, String appId, String entityNum, String permItemId) {
        CharSequence[] keyArr = new String[]{"cacheCheckPermissionWithOrg", userId + "", orgId + "", orgView, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4BizRoleFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = BizRoleFunPermService.checkPermissionWithOrg(userId, orgId, orgView, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4BizRoleFunPermService(), key, hasPermission + "");
        BizRoleFunPermService.resetCacheExp(key, hasPermission + "", userId);
        return hasPermission;
    }

    private static int checkPermissionWithOrg(final long userId, long orgId, String orgView, String appId, String entityNum, String permItemId) {
        Callable<Set<Long>> userBizRoleIDsCallable = new Callable<Set<Long>>(){

            @Override
            public Set<Long> call() throws Exception {
                return BizRoleFunPermService.getUserBizRoleIDs(userId);
            }
        };
        Future userBizRoleIDsFuture = pool.submit((Callable)userBizRoleIDsCallable, RequestContext.get());
        Future<Set<Long>> permBizRoleIdFuture = BizRoleFunPermService.getPermBizRoleIDsWithOrg(orgId, orgView, appId, entityNum, permItemId, RequestContext.get());
        Future<Set<String>> permRoleIdsFuture = BizRoleFunPermService.getCommRoleIDs(appId, entityNum, permItemId, RequestContext.get());
        List superOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgView, (long)orgId);
        Future<Set<Long>> supPermBizRoleIdFuture = BizRoleFunPermService.getPermBizRoleIDsWithSupOrg(superOrgIds, appId, entityNum, permItemId, RequestContext.get());
        try {
            Set<Long> orgPermBizRoleIdSet;
            Set userBizRoleIDSet = (Set)userBizRoleIDsFuture.get();
            if (userBizRoleIDSet.isEmpty()) {
                return 0;
            }
            Set<Long> permBizRoleIDSet = permBizRoleIdFuture.get();
            if (!permBizRoleIDSet.isEmpty() && permBizRoleIDSet.stream().anyMatch(x -> userBizRoleIDSet.contains(x))) {
                return 1;
            }
            Set<Long> supPermBizRoleIDSet = supPermBizRoleIdFuture.get();
            if (!supPermBizRoleIDSet.isEmpty() && supPermBizRoleIDSet.stream().anyMatch(x -> userBizRoleIDSet.contains(x))) {
                return 1;
            }
            Set<String> permRoleIdSet = permRoleIdsFuture.get();
            if (permRoleIdSet.isEmpty()) {
                return 0;
            }
            ArrayList<String> commRoleIdList = new ArrayList<String>(permRoleIdSet.size());
            commRoleIdList.addAll(permRoleIdSet);
            Future<Set<Long>> orgPermBizRoleIdFuture = BizRoleFunPermService.getOrgBizRoleIDs(orgId, orgView, commRoleIdList, RequestContext.get());
            if (superOrgIds != null && !superOrgIds.isEmpty()) {
                int i;
                StringBuilder sqlSB = new StringBuilder("SELECT DISTINCT PBO.FID BIZROLEID FROM T_PERM_BIZROLEORG PBO INNER JOIN T_PERM_BIZROLECOMROLE PBC ON PBO.FID=PBC.FID");
                sqlSB.append(" WHERE PBO.FISINCLUDESUBORG='1' and PBO.FDIMTYPE='bos_org' AND  PBO.FORGID IN (");
                for (i = 0; i < superOrgIds.size(); ++i) {
                    sqlSB.append('\'').append(superOrgIds.get(i)).append("',");
                }
                sqlSB.deleteCharAt(sqlSB.length() - 1);
                sqlSB.append(" )");
                sqlSB.append(" AND  PBC.FROLEID IN (");
                for (i = 0; i < commRoleIdList.size(); ++i) {
                    sqlSB.append('\'').append((String)commRoleIdList.get(i)).append("',");
                }
                sqlSB.deleteCharAt(sqlSB.length() - 1);
                sqlSB.append(" )");
                Set supPermBizRoleIdSet = (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                    public Set<Long> handle(ResultSet rs) throws Exception {
                        HashSet<Long> bizRoleIds = new HashSet<Long>(16);
                        while (rs.next()) {
                            Long bizRoleId = rs.getLong("BIZROLEID");
                            bizRoleIds.add(bizRoleId);
                        }
                        return bizRoleIds;
                    }
                });
                if (!supPermBizRoleIdSet.isEmpty()) {
                    if (supPermBizRoleIdSet.stream().anyMatch(userBizRoleIDSet::contains)) {
                        return 1;
                    }
                }
            }
            if (!(orgPermBizRoleIdSet = orgPermBizRoleIdFuture.get()).isEmpty()) {
                if (orgPermBizRoleIdSet.stream().anyMatch(userBizRoleIDSet::contains)) {
                    return 1;
                }
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return 0;
        }
        return 0;
    }

    private static void resetCacheExp(String cacheKey, String cacheValue, long userId) {
        ThreadPools.executeOnceIncludeRequestContext((String)"BizRoleFunPermService_resetCacheExp", () -> {
            String sql = "SELECT MIN(PUB.FSTARTTIME) MIN_STARTTIME FROM T_PERM_USERBIZROLE PUB WHERE PUB.FUSERID=? AND NOW() < PUB.FSTARTTIME";
            Object[] params = new Object[]{userId};
            java.util.Date minStartDate = (java.util.Date)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<java.util.Date>(){

                public java.util.Date handle(ResultSet rs) throws Exception {
                    Date minStartTime = null;
                    while (rs.next()) {
                        minStartTime = rs.getDate("MIN_STARTTIME");
                    }
                    return minStartTime;
                }
            });
            String minEndTimeSql = "SELECT MIN(PUB.FENDTIME) MIN_ENDTIME FROM T_PERM_USERBIZROLE PUB WHERE PUB.FUSERID=? AND NOW() < PUB.FENDTIME";
            java.util.Date minEndDate = (java.util.Date)DB.query((DBRoute)DBRoute.permission, (String)minEndTimeSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<java.util.Date>(){

                public java.util.Date handle(ResultSet rs) throws Exception {
                    Date minEndDate = null;
                    while (rs.next()) {
                        minEndDate = rs.getDate("MIN_ENDTIME");
                    }
                    return minEndDate;
                }
            });
            List<java.util.Date> dateList = Arrays.asList(minStartDate, minEndDate);
            Optional<java.util.Date> minDate = dateList.stream().filter(x -> x != null).min((o1, o2) -> o1.compareTo((java.util.Date)o2));
            minDate.ifPresent(d -> {
                Long expLongTime = d.getTime() - Instant.now().toEpochMilli();
                Integer expInt = (expLongTime = Long.valueOf(expLongTime / 1000L)).intValue();
                if (expInt <= 0) {
                    CacheMrg.putCache(CacheMrg.getType4BizRoleFunPermService(), cacheKey, cacheValue, 1);
                } else if (expInt > 0 && expInt < CacheMrg.getExpireTime()) {
                    CacheMrg.putCache(CacheMrg.getType4BizRoleFunPermService(), cacheKey, cacheValue, expInt);
                }
            });
        });
    }

    public static int cacheCheckPermissionWithOutOrg(long userId, String appId, String entityNum, String permItemId) {
        CharSequence[] keyarr = new String[]{"cacheCheckPermissionWithOutOrg", userId + "", appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyarr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4BizRoleFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = BizRoleFunPermService.checkPermissionWithOutOrg(userId, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4BizRoleFunPermService(), key, hasPermission + "");
        BizRoleFunPermService.resetCacheExp(key, hasPermission + "", userId);
        return hasPermission;
    }

    private static int checkPermissionWithOutOrg(long userId, String appId, String entityNum, String permItemId) {
        Future<Set<Long>> permBizRoleIdFuture = BizRoleFunPermService.getPermBizRoleIDs(appId, entityNum, permItemId, RequestContext.get());
        Future<Set<String>> permRoleIdsFuture = BizRoleFunPermService.getCommRoleIDs(appId, entityNum, permItemId, RequestContext.get());
        try {
            Set<Long> userBizRoleIDSet = BizRoleFunPermService.getUserBizRoleIDs(userId);
            if (userBizRoleIDSet.isEmpty()) {
                return 0;
            }
            Set<Long> permBizRoleIDSet = permBizRoleIdFuture.get();
            if (!permBizRoleIDSet.isEmpty() && permBizRoleIDSet.stream().anyMatch(x -> userBizRoleIDSet.contains(x))) {
                return 1;
            }
            Set<String> permRoleIdSet = permRoleIdsFuture.get();
            if (permRoleIdSet.isEmpty()) {
                return 0;
            }
            ArrayList<String> commRoleIdList = new ArrayList<String>(permRoleIdSet.size());
            commRoleIdList.addAll(permRoleIdSet);
            StringBuilder sqlSB = new StringBuilder("SELECT DISTINCT PBC.FID BIZROLEID FROM T_PERM_BIZROLECOMROLE PBC WHERE ");
            sqlSB.append(" PBC.FROLEID IN (");
            for (int i = 0; i < commRoleIdList.size(); ++i) {
                sqlSB.append('\'').append((String)commRoleIdList.get(i)).append("',");
            }
            sqlSB.deleteCharAt(sqlSB.length() - 1);
            sqlSB.append(" )");
            Set comRolePermBizRoleIdSet = (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                public Set<Long> handle(ResultSet rs) throws Exception {
                    HashSet<Long> bizRoleIds = new HashSet<Long>(16);
                    while (rs.next()) {
                        Long bizRoleId = rs.getLong("BIZROLEID");
                        bizRoleIds.add(bizRoleId);
                    }
                    return bizRoleIds;
                }
            });
            if (!comRolePermBizRoleIdSet.isEmpty() && comRolePermBizRoleIdSet.stream().anyMatch(x -> userBizRoleIDSet.contains(x))) {
                return 1;
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return 0;
        }
        return 0;
    }

    public static int cacheCheckPermissionWithDim(long userId, long dimId, String dimType, String appId, String entityNum, String permItemId) {
        CharSequence[] keyArr = new String[]{"cacheCheckPermissionWithDim", userId + "", dimId + "", dimType, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4BizRoleFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = BizRoleFunPermService.checkPermissionWithDim(userId, dimId, dimType, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4BizRoleFunPermService(), key, hasPermission + "");
        BizRoleFunPermService.resetCacheExp(key, hasPermission + "", userId);
        return hasPermission;
    }

    private static int checkPermissionWithDim(long userId, long dimId, String dimType, String appId, String entityNum, String permItemId) {
        dimType = PermCommonUtil.getSuitableDimType(dimType)[1];
        Future<Set<Long>> permBizRoleIdFuture = BizRoleFunPermService.getPermBizRoleIDsWithDim(dimId, dimType, appId, entityNum, permItemId, RequestContext.get());
        Future<Set<String>> permRoleIdsFuture = BizRoleFunPermService.getCommRoleIDs(appId, entityNum, permItemId, RequestContext.get());
        try {
            Set<Long> userBizRoleIDSet = BizRoleFunPermService.getUserBizRoleIDs(userId);
            if (userBizRoleIDSet.isEmpty()) {
                return 0;
            }
            Set<Long> permBizRoleIDSet = permBizRoleIdFuture.get();
            if (!permBizRoleIDSet.isEmpty() && permBizRoleIDSet.stream().anyMatch(x -> userBizRoleIDSet.contains(x))) {
                return 1;
            }
            Set<String> permRoleIdSet = permRoleIdsFuture.get();
            if (permRoleIdSet.isEmpty()) {
                return 0;
            }
            ArrayList<String> commRoleIdList = new ArrayList<String>(permRoleIdSet.size());
            commRoleIdList.addAll(permRoleIdSet);
            StringBuilder sqlSB = new StringBuilder("SELECT DISTINCT PBO.FID BIZROLEID FROM T_PERM_BIZROLEORG PBO INNER JOIN T_PERM_BIZROLECOMROLE PBC ON PBO.FID=PBC.FID");
            sqlSB.append(" WHERE PBO.FORGID= ? AND PBO.FDIMTYPE= ? ");
            sqlSB.append(" AND PBC.FROLEID IN (");
            for (int i = 0; i < commRoleIdList.size(); ++i) {
                sqlSB.append('\'').append((String)commRoleIdList.get(i)).append("',");
            }
            sqlSB.deleteCharAt(sqlSB.length() - 1);
            sqlSB.append(" )");
            Set comrolePermBizRoleIdSet = (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (Object[])new Object[]{dimId, dimType}, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                public Set<Long> handle(ResultSet rs) throws Exception {
                    HashSet<Long> bizRoleIds = new HashSet<Long>(16);
                    while (rs.next()) {
                        Long bizRoleId = rs.getLong("BIZROLEID");
                        bizRoleIds.add(bizRoleId);
                    }
                    return bizRoleIds;
                }
            });
            if (!comrolePermBizRoleIdSet.isEmpty() && comrolePermBizRoleIdSet.stream().anyMatch(x -> userBizRoleIDSet.contains(x))) {
                return 1;
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return 0;
        }
        return 0;
    }

    private static Future<Set<Long>> getPermBizRoleIDsWithDim(final long dimId, String dimType, final String appId, final String entityNum, final String permItemId, RequestContext requextContext) {
        final String realDimType = PermCommonUtil.getSuitableDimType(dimType)[1];
        Callable<Set<Long>> bizRoleIDsCallable = new Callable<Set<Long>>(){

            @Override
            public Set<Long> call() throws Exception {
                String sql = "SELECT DISTINCT PBP.FID BIZROLEID FROM T_PERM_BIZROLEPERM PBP INNER JOIN T_PERM_BIZROLEORG PBO ON PBP.FID=PBO.FID WHERE PBP.FBIZAPPID= ? AND PBP.FENTITYTYPEID= ? AND PBP.FPERMITEMID=? AND PBO.FORGID=? AND PBO.FDIMTYPE = ?";
                Object[] params = new Object[]{appId, entityNum, permItemId, dimId, realDimType};
                return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                    public Set<Long> handle(ResultSet rs) throws Exception {
                        HashSet<Long> bizRoleIds = new HashSet<Long>(16);
                        while (rs.next()) {
                            Long bizRoleId = rs.getLong("BIZROLEID");
                            bizRoleIds.add(bizRoleId);
                        }
                        return bizRoleIds;
                    }
                });
            }
        };
        return pool.submit((Callable)bizRoleIDsCallable, requextContext);
    }

    @Deprecated
    public static int cacheCheckDisPermWithOrg(long userId, long orgId, String appId, String entityNum, String permItemId) {
        return BizRoleFunPermService.cacheCheckDisPermWithOrg(userId, orgId, "15", appId, entityNum, permItemId);
    }

    public static int cacheCheckDisPermWithOrg(long userId, long orgId, String orgView, String appId, String entityNum, String permItemId) {
        CharSequence[] keyArr = new String[]{"cacheCheckDisPermWithOrg", userId + "", orgId + "", orgView, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4BizRoleFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = BizRoleFunPermService.checkDisPermWithOrg(userId, orgId, orgView, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4BizRoleFunPermService(), key, hasPermission + "");
        BizRoleFunPermService.resetCacheExp(key, hasPermission + "", userId);
        return hasPermission;
    }

    private static int checkDisPermWithOrg(final long userId, long orgId, String orgView, String appId, String entityNum, String permItemId) {
        Callable<Set<Long>> userBizRoleIDsCallable = new Callable<Set<Long>>(){

            @Override
            public Set<Long> call() throws Exception {
                return BizRoleFunPermService.getUserBizRoleIDs(userId);
            }
        };
        Future userBizRoleIDsFuture = pool.submit((Callable)userBizRoleIDsCallable, RequestContext.get());
        Future<Set<Long>> disPermBizRoleIdFuture = BizRoleFunPermService.getDisPermBizRoleIDsWithOrg(orgId, orgView, appId, entityNum, permItemId, RequestContext.get());
        List superOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgView, (long)orgId);
        Future<Set<Long>> supdisPermBizRoleIdFuture = BizRoleFunPermService.getDisPermBizRoleIDsWithSupOrg(superOrgIds, appId, entityNum, permItemId, RequestContext.get());
        try {
            Set userBizRoleIDSet = (Set)userBizRoleIDsFuture.get();
            if (userBizRoleIDSet.isEmpty()) {
                return 0;
            }
            Set<Long> dispermBizRoleIDSet = disPermBizRoleIdFuture.get();
            if (!dispermBizRoleIDSet.isEmpty() && dispermBizRoleIDSet.stream().anyMatch(x -> userBizRoleIDSet.contains(x))) {
                return 1;
            }
            Set<Long> supPermBizRoleIDSet = supdisPermBizRoleIdFuture.get();
            if (!supPermBizRoleIDSet.isEmpty() && supPermBizRoleIDSet.stream().anyMatch(x -> userBizRoleIDSet.contains(x))) {
                return 1;
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return 0;
        }
        return 0;
    }

    private static Future<Set<Long>> getDisPermBizRoleIDsWithOrg(final Long orgId, final String orgView, final String appId, final String entityNum, final String permItemId, RequestContext requextContext) {
        Callable<Set<Long>> bizRoleIDsCallable = new Callable<Set<Long>>(){

            @Override
            public Set<Long> call() throws Exception {
                String[] suitableViewId = OrgHelper.getSuitableViewId(orgView);
                StringBuilder sql = new StringBuilder();
                sql.append(" SELECT DISTINCT PBDP.FID BIZROLEID FROM T_PERM_BIZROLEDISPERM PBDP ").append(" INNER JOIN T_PERM_BIZROLEORG PBO ON PBDP.FID=PBO.FID ").append(" INNER JOIN T_ORG_STRUCTURE OS ON OS.FORGID = PBO.FORGID ").append(" WHERE PBDP.FBIZAPPID= ? AND PBDP.FENTITYTYPEID= ? AND PBDP.FPERMITEMID=? AND PBO.FORGID=? AND PBO.FDIMTYPE='bos_org' AND OS.FVIEWID = ? ");
                Object[] params = new Object[]{appId, entityNum, permItemId, orgId, Long.valueOf(suitableViewId[1])};
                return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                    public Set<Long> handle(ResultSet rs) throws Exception {
                        HashSet<Long> bizRoleIds = new HashSet<Long>(16);
                        while (rs.next()) {
                            Long bizRoleId = rs.getLong("BIZROLEID");
                            bizRoleIds.add(bizRoleId);
                        }
                        return bizRoleIds;
                    }
                });
            }
        };
        return pool.submit((Callable)bizRoleIDsCallable, requextContext);
    }

    private static Future<Set<Long>> getDisPermBizRoleIDsWithSupOrg(final List<Long> supOrgIds, final String appId, final String entityNum, final String permItemId, RequestContext requextContext) {
        Callable<Set<Long>> bizRoleIDsCallable = new Callable<Set<Long>>(){

            @Override
            public Set<Long> call() throws Exception {
                if (supOrgIds == null || supOrgIds.isEmpty()) {
                    return new HashSet<Long>(16);
                }
                StringBuilder sqlSB = new StringBuilder("SELECT DISTINCT PBDP.FID BIZROLEID FROM T_PERM_BIZROLEDISPERM PBDP INNER JOIN T_PERM_BIZROLEORG PBO ON PBDP.FID=PBO.FID");
                sqlSB.append(" WHERE PBDP.FBIZAPPID= ? AND PBDP.FENTITYTYPEID= ? AND PBDP.FPERMITEMID=? AND PBO.FISINCLUDESUBORG='1' and PBO.FDIMTYPE='bos_org' AND  PBO.FORGID IN (");
                for (int i = 0; i < supOrgIds.size(); ++i) {
                    sqlSB.append('\'').append(supOrgIds.get(i)).append("',");
                }
                sqlSB.deleteCharAt(sqlSB.length() - 1);
                sqlSB.append(')');
                Object[] params = new Object[]{appId, entityNum, permItemId};
                return (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                    public Set<Long> handle(ResultSet rs) throws Exception {
                        HashSet<Long> bizRoleIds = new HashSet<Long>(16);
                        while (rs.next()) {
                            Long bizRoleId = rs.getLong("BIZROLEID");
                            bizRoleIds.add(bizRoleId);
                        }
                        return bizRoleIds;
                    }
                });
            }
        };
        return pool.submit((Callable)bizRoleIDsCallable, requextContext);
    }

    public static int cacheCheckDisPermWithOutOrg(long userId, String appId, String entityNum, String permItemId) {
        CharSequence[] keyarr = new String[]{"cacheCheckDisPermWithOutOrg", userId + "", appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyarr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4BizRoleFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = BizRoleFunPermService.checkDisPermWithOutOrg(userId, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4BizRoleFunPermService(), key, hasPermission + "");
        BizRoleFunPermService.resetCacheExp(key, hasPermission + "", userId);
        return hasPermission;
    }

    private static int checkDisPermWithOutOrg(long userId, String appId, String entityNum, String permItemId) {
        Future<Set<Long>> disPermBizRoleIdFuture = BizRoleFunPermService.getDisPermBizRoleIDsWithOutOrg(appId, entityNum, permItemId, RequestContext.get());
        try {
            Set<Long> userBizRoleIDSet = BizRoleFunPermService.getUserBizRoleIDs(userId);
            if (userBizRoleIDSet.isEmpty()) {
                return 0;
            }
            Set<Long> dispermBizRoleIDSet = disPermBizRoleIdFuture.get();
            if (!dispermBizRoleIDSet.isEmpty() && dispermBizRoleIDSet.stream().anyMatch(x -> userBizRoleIDSet.contains(x))) {
                return 1;
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return 0;
    }

    private static Future<Set<Long>> getDisPermBizRoleIDsWithOutOrg(final String appId, final String entityNum, final String permItemId, RequestContext requextContext) {
        Callable<Set<Long>> bizRoleIDsCallable = new Callable<Set<Long>>(){

            @Override
            public Set<Long> call() throws Exception {
                String sql = "select distinct pbdp.fid bizroleid from t_perm_bizroledisperm pbdp where pbdp.fbizappid= ? and pbdp.fentitytypeid= ? and pbdp.fpermitemid=? ";
                Object[] params = new Object[]{appId, entityNum, permItemId};
                return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                    public Set<Long> handle(ResultSet rs) throws Exception {
                        HashSet<Long> bizRoleIds = new HashSet<Long>(16);
                        while (rs.next()) {
                            Long bizRoleId = rs.getLong("bizroleid");
                            bizRoleIds.add(bizRoleId);
                        }
                        return bizRoleIds;
                    }
                });
            }
        };
        return pool.submit((Callable)bizRoleIDsCallable, requextContext);
    }

    public static int cacheCheckDisPermWithDim(long userId, long dimId, String dimType, String appId, String entityNum, String permItemId) {
        CharSequence[] keyArr = new String[]{"cacheCheckDisPermWithDim", userId + "", dimId + "", dimType, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4BizRoleFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = BizRoleFunPermService.checkDisPermWithDim(userId, dimId, dimType, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4BizRoleFunPermService(), key, hasPermission + "");
        BizRoleFunPermService.resetCacheExp(key, hasPermission + "", userId);
        return hasPermission;
    }

    private static int checkDisPermWithDim(long userId, long dimId, String dimType, String appId, String entityNum, String permItemId) {
        Future<Set<Long>> disPermBizRoleIdFuture = BizRoleFunPermService.getDisPermBizRoleIDsWithDim(dimId, dimType, appId, entityNum, permItemId, RequestContext.get());
        try {
            Set<Long> userBizRoleIDSet = BizRoleFunPermService.getUserBizRoleIDs(userId);
            if (userBizRoleIDSet.isEmpty()) {
                return 0;
            }
            Set<Long> disPermBizRoleIDSet = disPermBizRoleIdFuture.get();
            if (!disPermBizRoleIDSet.isEmpty()) {
                if (disPermBizRoleIDSet.stream().anyMatch(userBizRoleIDSet::contains)) {
                    return 1;
                }
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return 0;
        }
        return 0;
    }

    private static Future<Set<Long>> getDisPermBizRoleIDsWithDim(final long dimId, String dimType, final String appId, final String entityNum, final String permItemId, RequestContext requextContext) {
        final String realDimType = PermCommonUtil.getSuitableDimType(dimType)[1];
        Callable<Set<Long>> bizRoleIDsCallable = new Callable<Set<Long>>(){

            @Override
            public Set<Long> call() throws Exception {
                String sql = "SELECT DISTINCT PBDP.FID BIZROLEID FROM T_PERM_BIZROLEDISPERM PBDP INNER JOIN T_PERM_BIZROLEORG PBO ON PBDP.FID=PBO.FID WHERE PBDP.FBIZAPPID= ? AND PBDP.FENTITYTYPEID= ? AND PBDP.FPERMITEMID=? AND PBO.FORGID=? AND PBO.FDIMTYPE = ?";
                Object[] params = new Object[]{appId, entityNum, permItemId, dimId, realDimType};
                return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

                    public Set<Long> handle(ResultSet rs) throws Exception {
                        HashSet<Long> bizRoleIds = new HashSet<Long>(16);
                        while (rs.next()) {
                            Long bizRoleId = rs.getLong("BIZROLEID");
                            bizRoleIds.add(bizRoleId);
                        }
                        return bizRoleIds;
                    }
                });
            }
        };
        return pool.submit((Callable)bizRoleIDsCallable, requextContext);
    }

    public static Map<Long, Boolean> getHasPermOrgs(long userId, String appId, String entityNum, String permItemId) {
        return BizRoleFunPermService.getHasPermOrgs(userId, appId, entityNum, permItemId, "bos_org");
    }

    public static Map<Long, Boolean> getHasPermOrgs(final long userId, String appId, String entityNum, String permItemId, String dimType) {
        dimType = StringUtils.isEmpty((String)dimType) ? "bos_org" : dimType;
        Callable<Set<Long>> userBizRoleIDsCallable = new Callable<Set<Long>>(){

            @Override
            public Set<Long> call() throws Exception {
                return BizRoleFunPermService.getUserBizRoleIDs(userId);
            }
        };
        Future userBizRoleIDsFuture = pool.submit((Callable)userBizRoleIDsCallable, RequestContext.get());
        Future<Set<String>> permRoleIdsFuture = BizRoleFunPermService.getCommRoleIDs(appId, entityNum, permItemId, RequestContext.get());
        ArrayList orgPermList = new ArrayList();
        String sql = "select distinct pbo.fid bizroleid,pbo.forgid orgid, pbo.fisincludesuborg hassub from t_perm_bizroleperm pbp inner join t_perm_bizroleorg pbo on pbp.fid=pbo.fid where pbp.fbizappid= ? and pbp.fentitytypeid= ? and pbp.fpermitemid=? and pbo.fdimtype= ? ";
        Object[] params = new Object[]{appId, entityNum, permItemId, dimType};
        List bizRoleIdOrgPermList = (List)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList<Object[]> bizRoleIdOrgList = new ArrayList<Object[]>(32);
                while (rs.next()) {
                    Long bizRoleId = rs.getLong("bizroleid");
                    Long orgId = rs.getLong("orgid");
                    String hasSub = rs.getString("hassub");
                    Object[] obj = new Object[]{bizRoleId, orgId, hasSub.equals("1")};
                    bizRoleIdOrgList.add(obj);
                }
                return bizRoleIdOrgList;
            }
        });
        orgPermList.addAll(bizRoleIdOrgPermList);
        try {
            Set userBizRoleIDSet = (Set)userBizRoleIDsFuture.get();
            if (userBizRoleIDSet.isEmpty()) {
                return new HashMap<Long, Boolean>(8);
            }
            Set<String> permRoleIdSet = permRoleIdsFuture.get();
            if (!permRoleIdSet.isEmpty()) {
                ArrayList<String> commRoleIdList = new ArrayList<String>(permRoleIdSet.size());
                commRoleIdList.addAll(permRoleIdSet);
                StringBuilder sqlSB = new StringBuilder().append("select distinct pbo.fid bizroleid,pbo.forgid orgid, pbo.fisincludesuborg hassub from t_perm_bizroleorg pbo inner join t_perm_bizrolecomrole pbc").append(" on pbo.fid=pbc.fid where pbo.fdimtype=?");
                sqlSB.append(" and  pbc.froleid in (");
                for (int i = 0; i < commRoleIdList.size(); ++i) {
                    sqlSB.append('\'').append((String)commRoleIdList.get(i)).append("',");
                }
                sqlSB.deleteCharAt(sqlSB.length() - 1);
                sqlSB.append(" )");
                List commRoleOrgPermList = (List)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (Object[])new Object[]{dimType}, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

                    public List<Object[]> handle(ResultSet rs) throws Exception {
                        ArrayList<Object[]> commRoleOrgList = new ArrayList<Object[]>(32);
                        while (rs.next()) {
                            Long bizRoleId = rs.getLong("bizroleid");
                            Long orgId = rs.getLong("orgid");
                            String hasSub = rs.getString("hassub");
                            Object[] obj = new Object[]{bizRoleId, orgId, hasSub.equals("1")};
                            commRoleOrgList.add(obj);
                        }
                        return commRoleOrgList;
                    }
                });
                orgPermList.addAll(commRoleOrgPermList);
            }
            HashMap<Long, Boolean> returnMap = new HashMap<Long, Boolean>(32);
            orgPermList.stream().filter(obj -> userBizRoleIDSet.contains((Long)obj[0])).forEach(obj -> returnMap.put((Long)obj[1], (Boolean)obj[2]));
            return returnMap;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return new HashMap<Long, Boolean>(8);
        }
    }

    public static Map<Long, Boolean> getHasDisPermOrgs(long userId, String appId, String entityNum, String permItemId) {
        return BizRoleFunPermService.getHasDisPermOrgs(userId, appId, entityNum, permItemId, "bos_org");
    }

    public static Map<Long, Boolean> getHasDisPermOrgs(final long userId, String appId, String entityNum, String permItemId, String dimType) {
        dimType = StringUtils.isEmpty((String)dimType) ? "bos_org" : dimType;
        Callable<Set<Long>> userBizRoleIDsCallable = new Callable<Set<Long>>(){

            @Override
            public Set<Long> call() throws Exception {
                return BizRoleFunPermService.getUserBizRoleIDs(userId);
            }
        };
        Future userBizRoleIDsFuture = pool.submit((Callable)userBizRoleIDsCallable, RequestContext.get());
        String sql = "select distinct pbo.fid bizroleid,pbo.forgid orgid, pbo.fisincludesuborg hassub from t_perm_bizroledisperm pbdp inner join t_perm_bizroleorg pbo on pbdp.fid=pbo.fid where pbdp.fbizappid= ? and pbdp.fentitytypeid= ? and pbdp.fpermitemid=? and pbo.fdimtype=?";
        Object[] params = new Object[]{appId, entityNum, permItemId, dimType};
        List bizRoleIdOrgdisPermList = (List)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList<Object[]> bizRoleIdOrgList = new ArrayList<Object[]>(32);
                while (rs.next()) {
                    Long bizRoleId = rs.getLong("bizroleid");
                    Long orgId = rs.getLong("orgid");
                    String hasSub = rs.getString("hassub");
                    Object[] obj = new Object[]{bizRoleId, orgId, hasSub.equals("1")};
                    bizRoleIdOrgList.add(obj);
                }
                return bizRoleIdOrgList;
            }
        });
        if (bizRoleIdOrgdisPermList == null || bizRoleIdOrgdisPermList.isEmpty()) {
            return new HashMap<Long, Boolean>(8);
        }
        try {
            Set userBizRoleIDSet = (Set)userBizRoleIDsFuture.get();
            if (userBizRoleIDSet.isEmpty()) {
                return new HashMap<Long, Boolean>(8);
            }
            HashMap<Long, Boolean> returnMap = new HashMap<Long, Boolean>(32);
            bizRoleIdOrgdisPermList.stream().filter(obj -> userBizRoleIDSet.contains((Long)obj[0])).forEach(obj -> returnMap.put((Long)obj[1], (Boolean)obj[2]));
            return returnMap;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return new HashMap<Long, Boolean>(8);
        }
    }

    public static Map<Long, Boolean> getUserHasPermDimObjs(long userId, String dimType) {
        return BizRoleFunPermService.getUserHasPermDimObjs(userId, null, dimType);
    }

    public static Map<Long, Boolean> getUserHasPermDimObjs(long userId, String appId, String dimType) {
        String bizroleIdStr = BizRoleService.getBizRolesByUserIDAndShiftToStr(userId);
        if (StringUtils.isEmpty((String)bizroleIdStr)) {
            return new HashMap<Long, Boolean>(0);
        }
        dimType = PermCommonUtil.getSuitableDimType(dimType)[1];
        Object[] params = new Object[]{dimType};
        String sqlString = "select distinct pbo.forgid orgid, pbo.fisincludesuborg hassub from t_perm_bizroleorg pbo ";
        if (StringUtils.isNotEmpty((String)appId)) {
            sqlString = sqlString + " left join t_perm_bizroleperm pbp on pbo.fid = pbp.fid  left join t_perm_bizrolecomrole pbc on pbc.fid = pbo.fid  left join t_perm_rolepermdetial rpd on pbc.froleid = rpd.froleid  where (pbp.fbizappid = ? or rpd.fbizappid = ? ) and ";
            params = new Object[]{appId, appId, dimType};
        } else {
            sqlString = sqlString + " where ";
        }
        sqlString = sqlString + " pbo.fdimtype = ? and pbo.fid in " + bizroleIdStr;
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sqlString, (Object[])params, rs -> {
            HashMap<Long, Boolean> returnMap = new HashMap<Long, Boolean>(32);
            while (rs.next()) {
                Long orgId = rs.getLong("orgid");
                String hasSub = rs.getString("hassub");
                Boolean hasSubValue = hasSub.equals("1");
                if (returnMap.containsKey(orgId)) {
                    returnMap.computeIfPresent(orgId, (k, v) -> hasSubValue != false || v != false);
                    continue;
                }
                returnMap.put(orgId, hasSubValue);
            }
            return returnMap;
        });
    }

    public static Set<String> hasPermMenuList(Long userId, final List<Object[]> menuAppEntityPermList) {
        if (menuAppEntityPermList == null || menuAppEntityPermList.isEmpty()) {
            return new HashSet<String>(16);
        }
        boolean isSingleBizRole = PermCommonUtil.isEnableSingleBizRole();
        Set<Object> bizRoleIdSet = new HashSet();
        if (isSingleBizRole) {
            String selBizRole = UserBizRoleCache.getSelBizRole(userId);
            if (!StringUtils.isEmpty((String)selBizRole)) {
                bizRoleIdSet.add(Long.valueOf(selBizRole));
            }
        } else {
            bizRoleIdSet = BizRoleFunPermService.getUserBizRoleIDs(userId);
        }
        if (bizRoleIdSet.isEmpty()) {
            return new HashSet<String>(16);
        }
        final Set<Object> finalBizRoleIdSet = bizRoleIdSet;
        Callable<Set<String>> addPermMenuIdSetCallable = new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                return BizRoleFunPermService.hasPermMenuListByAddedPerm(menuAppEntityPermList, finalBizRoleIdSet);
            }
        };
        Future addPermMenuIdSetFuture = pool.submit((Callable)addPermMenuIdSetCallable, RequestContext.get());
        Set<String> userComRoleIdSet = BizRoleService.getCommRoleIdsByUserID(userId);
        HashSet<String> menuIDByComRoleSet = new HashSet<String>(8);
        if (!userComRoleIdSet.isEmpty()) {
            StringBuilder comRoleIds = new StringBuilder("(");
            for (String comRoleId : userComRoleIdSet) {
                comRoleIds.append('\'').append(comRoleId).append("',");
            }
            comRoleIds.deleteCharAt(comRoleIds.length() - 1).append(')');
            StringBuilder sqlSB = new StringBuilder().append("SELECT RPD.FBIZAPPID||RPD.FENTITYTYPEID||RPD.FPERMITEMID as result ").append(" FROM T_PERM_ROLEPERMDETIAL RPD ").append(" WHERE RPD.FROLEID IN ").append((CharSequence)comRoleIds);
            Set appEntityPermSet = (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

                public Set<String> handle(ResultSet rs) throws Exception {
                    HashSet<String> res = new HashSet<String>(8);
                    while (rs.next()) {
                        res.add(rs.getString("result"));
                    }
                    return res;
                }
            });
            if (!appEntityPermSet.isEmpty()) {
                for (int i = 0; i < menuAppEntityPermList.size(); ++i) {
                    String app = String.valueOf(menuAppEntityPermList.get(i)[1]);
                    String entity = String.valueOf(menuAppEntityPermList.get(i)[2]);
                    String permItem = String.valueOf(menuAppEntityPermList.get(i)[3]);
                    if (!appEntityPermSet.contains(app + entity + permItem)) continue;
                    menuIDByComRoleSet.add(String.valueOf(menuAppEntityPermList.get(i)[0]));
                }
            }
        }
        HashSet<String> menuIdSet = new HashSet<String>();
        try {
            menuIdSet.addAll((Collection)addPermMenuIdSetFuture.get());
            menuIdSet.addAll(menuIDByComRoleSet);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return new HashSet<String>(16);
        }
        return menuIdSet;
    }

    public static Set<String> getUserAppEntPermItemStrSet(Long userId) {
        if (null == userId || 0L == userId) {
            return Collections.EMPTY_SET;
        }
        boolean isSingleBizRole = PermCommonUtil.isEnableSingleBizRole();
        Set<Object> bizRoleIdSet = new HashSet();
        if (isSingleBizRole) {
            String selBizRole = UserBizRoleCache.getSelBizRole(userId);
            if (!StringUtils.isEmpty((String)selBizRole)) {
                bizRoleIdSet.add(Long.valueOf(selBizRole));
            }
        } else {
            bizRoleIdSet = BizRoleFunPermService.getUserBizRoleIDs(userId);
        }
        if (bizRoleIdSet.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        final HashSet<String> finalSet = new HashSet<String>(8);
        final Set<Object> finalBizRoleIdSet = bizRoleIdSet;
        Callable<Set<String>> addPermMenuIdSetCallable = new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                return BizRoleFunPermService.hasPermMenuListByAddedPerm(finalBizRoleIdSet);
            }
        };
        Future addPermMenuIdSetFuture = pool.submit((Callable)addPermMenuIdSetCallable, RequestContext.get());
        Set<String> userComRoleIdSet = BizRoleService.getCommRoleIdsByUserID(userId);
        if (!userComRoleIdSet.isEmpty()) {
            StringBuilder comRoleIds = new StringBuilder("(");
            for (String comRoleId : userComRoleIdSet) {
                comRoleIds.append('\'').append(comRoleId).append("',");
            }
            comRoleIds.deleteCharAt(comRoleIds.length() - 1).append(')');
            StringBuilder sqlSB = new StringBuilder().append("SELECT RPD.FBIZAPPID||RPD.FENTITYTYPEID||RPD.FPERMITEMID as result ").append(" FROM T_PERM_ROLEPERMDETIAL RPD ").append(" WHERE RPD.FROLEID IN ").append((CharSequence)comRoleIds);
            DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Void>(){

                public Void handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        finalSet.add(rs.getString("result"));
                    }
                    return null;
                }
            });
        }
        try {
            finalSet.addAll((Collection)addPermMenuIdSetFuture.get());
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return new HashSet<String>(16);
        }
        return finalSet;
    }

    private static Set<String> hasPermMenuListByAddedPerm(List<Object[]> menuAppEntityPermList, Set<Long> bizRoleIDset) {
        if (menuAppEntityPermList == null || menuAppEntityPermList.isEmpty()) {
            return new HashSet<String>(16);
        }
        StringBuilder bizRoleStr = new StringBuilder("(");
        for (Long bizRoleId : bizRoleIDset) {
            bizRoleStr.append(bizRoleId).append(',');
        }
        bizRoleStr.deleteCharAt(bizRoleStr.length() - 1).append(')');
        StringBuilder sqlSB = new StringBuilder().append("SELECT PBP.FBIZAPPID||PBP.FENTITYTYPEID||PBP.FPERMITEMID as result ").append(" FROM T_PERM_BIZROLEPERM PBP ").append(" WHERE PBP.FID in ").append((CharSequence)bizRoleStr);
        Set appEntityPermSet = (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> appEntityPermSet = new HashSet<String>(8);
                while (rs.next()) {
                    String result = rs.getString("result");
                    appEntityPermSet.add(result);
                }
                return appEntityPermSet;
            }
        });
        HashSet<String> menuIdSet = new HashSet<String>();
        if (!appEntityPermSet.isEmpty()) {
            for (Object[] objects : menuAppEntityPermList) {
                String app = String.valueOf(objects[1]);
                String entity = String.valueOf(objects[2]);
                String permItem = String.valueOf(objects[3]);
                if (!appEntityPermSet.contains(app + entity + permItem)) continue;
                menuIdSet.add(String.valueOf(objects[0]));
            }
        }
        return menuIdSet;
    }

    private static Set<String> hasPermMenuListByAddedPerm(Set<Long> bizRoleIDset) {
        if (bizRoleIDset == null || bizRoleIDset.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        StringBuilder bizRoleStr = new StringBuilder("(");
        for (Long bizRoleId : bizRoleIDset) {
            bizRoleStr.append(bizRoleId).append(',');
        }
        bizRoleStr.deleteCharAt(bizRoleStr.length() - 1).append(')');
        StringBuilder sqlSB = new StringBuilder().append("SELECT PBP.FBIZAPPID||PBP.FENTITYTYPEID||PBP.FPERMITEMID as result ").append(" FROM T_PERM_BIZROLEPERM PBP ").append(" WHERE PBP.FID in ").append((CharSequence)bizRoleStr);
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> appEntityPermSet = new HashSet<String>(8);
                while (rs.next()) {
                    String result = rs.getString("result");
                    appEntityPermSet.add(result);
                }
                return appEntityPermSet;
            }
        });
    }

    public static Set<String> hasDisPermMenuList(Long userId, List<Object[]> menuAppEntityPermList) {
        if (menuAppEntityPermList == null || menuAppEntityPermList.isEmpty()) {
            return new HashSet<String>(16);
        }
        boolean isSingleBizRole = PermCommonUtil.isEnableSingleBizRole();
        Set<Object> bizRoleIdSet = new HashSet();
        if (isSingleBizRole) {
            String selBizRole = UserBizRoleCache.getSelBizRole(userId);
            if (!StringUtils.isEmpty((String)selBizRole)) {
                bizRoleIdSet.add(Long.valueOf(selBizRole));
            }
        } else {
            bizRoleIdSet = BizRoleFunPermService.getUserBizRoleIDs(userId);
        }
        if (bizRoleIdSet.isEmpty()) {
            return new HashSet<String>(16);
        }
        StringBuilder bizRoleStr = new StringBuilder("(");
        for (Long l : bizRoleIdSet) {
            bizRoleStr.append(l).append(',');
        }
        bizRoleStr.deleteCharAt(bizRoleStr.length() - 1).append(')');
        StringBuilder sqlSB = new StringBuilder().append("SELECT PBDP.FBIZAPPID||PBDP.FENTITYTYPEID||PBDP.FPERMITEMID as result ").append(" FROM T_PERM_BIZROLEDISPERM PBDP").append(" WHERE FID in ").append((CharSequence)bizRoleStr);
        Set set = (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> appEntityPermSet = new HashSet<String>(8);
                while (rs.next()) {
                    String result = rs.getString("result");
                    appEntityPermSet.add(result);
                }
                return appEntityPermSet;
            }
        });
        HashSet<String> menuIdSet = new HashSet<String>();
        if (!set.isEmpty()) {
            for (Object[] objects : menuAppEntityPermList) {
                String app = String.valueOf(objects[1]);
                String entity = String.valueOf(objects[2]);
                String permItem = String.valueOf(objects[3]);
                if (!set.contains(app + entity + permItem)) continue;
                menuIdSet.add(String.valueOf(objects[0]));
            }
        }
        return menuIdSet;
    }

    public static Set<String> getDisUserAppEntPermItemStrSet(Long userId) {
        if (null == userId || 0L == userId) {
            return Collections.emptySet();
        }
        boolean isSingleBizRole = PermCommonUtil.isEnableSingleBizRole();
        Set<Object> bizRoleIdSet = new HashSet();
        if (isSingleBizRole) {
            String selBizRole = UserBizRoleCache.getSelBizRole(userId);
            if (!StringUtils.isEmpty((String)selBizRole)) {
                bizRoleIdSet.add(Long.valueOf(selBizRole));
            }
        } else {
            bizRoleIdSet = BizRoleFunPermService.getUserBizRoleIDs(userId);
        }
        if (bizRoleIdSet.isEmpty()) {
            return new HashSet<String>(16);
        }
        StringBuilder bizRoleStr = new StringBuilder("(");
        for (Long l : bizRoleIdSet) {
            bizRoleStr.append(l).append(',');
        }
        bizRoleStr.deleteCharAt(bizRoleStr.length() - 1).append(')');
        StringBuilder sqlSB = new StringBuilder();
        sqlSB.append("select pbdp.fbizappid||pbdp.fentitytypeid||pbdp.fpermitemid as result ");
        sqlSB.append(" from t_perm_bizroledisperm pbdp");
        sqlSB.append(" where fid in ").append((CharSequence)bizRoleStr);
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> appEntityPermSet = new HashSet<String>(8);
                while (rs.next()) {
                    String result = rs.getString("result");
                    appEntityPermSet.add(result);
                }
                return appEntityPermSet;
            }
        });
    }

    public static Map<Long, String> cacheGetHasPermDimObj(long userId, String dimType, String appId, String entityNum, String permItemId) {
        Map<Long, String> bizRoleHasPermOrgs = new HashMap<Long, String>(16);
        List<String> orgInfos = new ArrayList(10);
        CharSequence[] keyArr = new String[]{"cacheGetHasPermDimObj", userId + "", dimType, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4BizRoleFunPermService(), key);
        if (cacheValue != null) {
            orgInfos = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            if (orgInfos != null) {
                for (String orgInfo : orgInfos) {
                    String[] arr = orgInfo.split("_");
                    bizRoleHasPermOrgs.put(Long.valueOf(arr[0]), arr[1]);
                }
            }
            return bizRoleHasPermOrgs;
        }
        Object[] bizRoleCommonRoleParams = new Object[]{appId, entityNum, permItemId};
        String bizRoleExtraSql = " SELECT BP.FID FROM T_PERM_BIZROLEPERM BP WHERE BP.FBIZAPPID = ? AND BP.FENTITYTYPEID = ? AND BP.FPERMITEMID = ? ";
        final Set hasPermBizRoleIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)bizRoleExtraSql, (Object[])bizRoleCommonRoleParams, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> hasPermBizRoleIds = new HashSet<Long>(16);
                while (rs.next()) {
                    hasPermBizRoleIds.add(rs.getLong("FID"));
                }
                return hasPermBizRoleIds;
            }
        });
        String bizRoleCommonRoleSql = " SELECT BC.FID FROM T_PERM_BIZROLECOMROLE BC  INNER JOIN T_PERM_ROLE R ON BC.FROLEID = R.FID  INNER JOIN T_PERM_ROLEPERMDETIAL RPD ON BC.FROLEID = RPD.FROLEID  WHERE R.FENABLE = '1' AND RPD.FBIZAPPID = ? AND RPD.FENTITYTYPEID = ? AND RPD.FPERMITEMID = ? ";
        Set hasRolePermBizRoleIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)bizRoleCommonRoleSql, (Object[])bizRoleCommonRoleParams, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> hasPermBizRoleIds = new HashSet<Long>(16);
                while (rs.next()) {
                    hasPermBizRoleIds.add(rs.getLong("FID"));
                }
                return hasPermBizRoleIds;
            }
        });
        hasPermBizRoleIds.addAll(hasRolePermBizRoleIds);
        String bizRolesIDStr = BizRoleService.getBizRolesByUserIDAndShiftToStr(userId);
        if (!StringUtils.isEmpty((String)bizRolesIDStr)) {
            String userBizRoleSql = " SELECT BO.FID, BO.FORGID, BO.FISINCLUDESUBORG FROM T_PERM_BIZROLEORG BO  WHERE BO.FDIMTYPE = ? AND BO.FID IN " + bizRolesIDStr;
            Object[] userBizRoleParams = new Object[]{dimType};
            bizRoleHasPermOrgs = (Map)DB.query((DBRoute)DBRoute.permission, (String)userBizRoleSql, (Object[])userBizRoleParams, (ResultSetHandler)new ResultSetHandler<Map<Long, String>>(){

                public Map<Long, String> handle(ResultSet rs) throws Exception {
                    HashMap<Long, String> hasPermOrg = new HashMap<Long, String>(16);
                    while (rs.next()) {
                        Long bizRoleId = rs.getLong("FID");
                        Long orgId = rs.getLong("FORGID");
                        String isIncludesuborg = rs.getString("FISINCLUDESUBORG");
                        if (!hasPermBizRoleIds.contains(bizRoleId)) continue;
                        hasPermOrg.put(orgId, isIncludesuborg);
                    }
                    return hasPermOrg;
                }
            });
        }
        for (Map.Entry entry : bizRoleHasPermOrgs.entrySet()) {
            orgInfos.add(entry.getKey() + "_" + (String)entry.getValue());
        }
        String hasPermission = SerializationUtils.toJsonString(orgInfos);
        CacheMrg.putCache(CacheMrg.getType4BizRoleFunPermService(), key, hasPermission);
        BizRoleFunPermService.resetCacheExp(key, hasPermission, userId);
        return bizRoleHasPermOrgs;
    }

    public static Map<Long, String> cacheGetDisPermDimObj(long userId, String dimType, String appId, String entityNum, String permItemId) {
        Map<Long, String> bizRoledisPermOrgs = new HashMap<Long, String>(16);
        List<String> orgInfos = new ArrayList(10);
        CharSequence[] keyArr = new String[]{"cacheGetDisPermDimObj", userId + "", dimType, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4BizRoleFunPermService(), key);
        if (cacheValue != null) {
            orgInfos = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            if (orgInfos != null) {
                for (String orgInfo : orgInfos) {
                    String[] arr = orgInfo.split("_");
                    bizRoledisPermOrgs.put(Long.valueOf(arr[0]), arr[1]);
                }
            }
            return bizRoledisPermOrgs;
        }
        String bizRoleDisPermSql = " SELECT BDP.FID FROM T_PERM_BIZROLEDISPERM BDP WHERE BDP.FBIZAPPID = ? AND BDP.FENTITYTYPEID = ? AND BDP.FPERMITEMID = ? ";
        Object[] bizRoleDisPermParams = new Object[]{appId, entityNum, permItemId};
        final Set disPermBizRoleIds = (Set)DB.query((DBRoute)DBRoute.permission, (String)bizRoleDisPermSql, (Object[])bizRoleDisPermParams, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> bizRoleIds = new HashSet<Long>(16);
                while (rs.next()) {
                    bizRoleIds.add(rs.getLong("FID"));
                }
                return bizRoleIds;
            }
        });
        String bizRolesIDStr = BizRoleService.getBizRolesByUserIDAndShiftToStr(userId);
        if (!StringUtils.isEmpty((String)bizRolesIDStr)) {
            String userBizRoleSql = " SELECT BO.FID, BO.FORGID, BO.FISINCLUDESUBORG FROM T_PERM_BIZROLEORG BO  WHERE BO.FDIMTYPE = ? AND BO.FID IN " + bizRolesIDStr;
            Object[] userBizRoleParams = new Object[]{dimType};
            bizRoledisPermOrgs = (Map)DB.query((DBRoute)DBRoute.permission, (String)userBizRoleSql, (Object[])userBizRoleParams, (ResultSetHandler)new ResultSetHandler<Map<Long, String>>(){

                public Map<Long, String> handle(ResultSet rs) throws Exception {
                    HashMap<Long, String> disPermOrg = new HashMap<Long, String>(16);
                    while (rs.next()) {
                        Long bizRoleId = rs.getLong("FID");
                        Long orgId = rs.getLong("FORGID");
                        String isIncludesuborg = rs.getString("FISINCLUDESUBORG");
                        if (!disPermBizRoleIds.contains(bizRoleId)) continue;
                        disPermOrg.put(orgId, isIncludesuborg);
                    }
                    return disPermOrg;
                }
            });
        }
        for (Map.Entry entry : bizRoledisPermOrgs.entrySet()) {
            orgInfos.add(entry.getKey() + "_" + (String)entry.getValue());
        }
        String hasPermission = SerializationUtils.toJsonString(orgInfos);
        CacheMrg.putCache(CacheMrg.getType4BizRoleFunPermService(), key, hasPermission);
        BizRoleFunPermService.resetCacheExp(key, hasPermission, userId);
        return bizRoledisPermOrgs;
    }

    public static Set<Long> getUserUsrGrpBizRoleIDs(Long userId) {
        String sql = "select ugb.fbizroleid from t_sec_usergroupstaff ugs join t_perm_usrgrpbizrole ugb on (ugs.fusergroupid=ugb.fusrgrpid) where ugs.fuserid =?";
        Object[] params = new Object[]{userId};
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, rs -> {
            HashSet<Long> bizRoleIds = new HashSet<Long>(16);
            while (rs.next()) {
                Long bizRoleId = rs.getLong("fbizroleid");
                bizRoleIds.add(bizRoleId);
            }
            return bizRoleIds;
        });
    }
}

