/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.BizRoleInfo;
import kd.bos.permission.cache.BizRoleFunPermService;
import kd.bos.permission.cache.UserHasPermDimObjCache;
import kd.bos.permission.cache.UserHasPermOrgCache;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class BizRoleService {
    private static final String DESCRIPTION = "description";
    private static final String SYS_TYPE = "bos-permission-cache";
    private static final String ERRORCODE_1 = "BizRoleService_bizRoleAssignFuncPerm";
    private static final String ERRORCODE_2 = "BizRoleService_bizRoleDisFuncPerm";
    private static final String ERRORCODE_3 = "delBizRoleById";
    private static final Log logger = LogFactory.getLog(BizRoleService.class);

    private static String getMessage() {
        return ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u4e0d\u5b58\u5728", (String)"BizRoleService_0", (String)SYS_TYPE, (Object[])new Object[0]);
    }

    private static String getMessage1() {
        return ResManager.loadKDString((String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_1", (String)SYS_TYPE, (Object[])new Object[0]);
    }

    private static String getMessage2() {
        return ResManager.loadKDString((String)"bizRoleId\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_2", (String)SYS_TYPE, (Object[])new Object[0]);
    }

    private static String getMessage3() {
        return ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25", (String)"BizRoleService_3", (String)SYS_TYPE, (Object[])new Object[0]);
    }

    private static String getMessage4() {
        return ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_4", (String)SYS_TYPE, (Object[])new Object[0]);
    }

    private static String getErrorMessage1() {
        return ResManager.loadKDString((String)"\u4e3a\u7528\u6237\u5206\u914d\u4e1a\u52a1\u89d2\u8272\u4e2d\u7684\u8865\u5145\u6743\u9650\u5931\u8d25", (String)"BizRoleService_5", (String)SYS_TYPE, (Object[])new Object[0]);
    }

    private static String getErrorMessage2() {
        return ResManager.loadKDString((String)"\u7528\u6237\u5206\u914d\u901a\u7528\u89d2\u8272\u7684\u6743\u9650\u5931\u8d25", (String)"BizRoleService_6", (String)SYS_TYPE, (Object[])new Object[0]);
    }

    private static String getErrorMessage3() {
        return ResManager.loadKDString((String)"\u4e3a\u7528\u6237\u5206\u914d\u89d2\u8272\u4e2d\u7684\u6743\u9650\u5931\u8d25", (String)"BizRoleService_7", (String)SYS_TYPE, (Object[])new Object[0]);
    }

    private static String getErrorMessage4() {
        return ResManager.loadKDString((String)"\u4e3a\u7528\u6237\u5206\u914d\u7981\u7528\u6743\u9650\u5931\u8d25", (String)"BizRoleService_8", (String)SYS_TYPE, (Object[])new Object[0]);
    }

    private static String getErrorMessage5() {
        return ResManager.loadKDString((String)"\u4e3a\u7528\u6237\u5206\u914d\u4e1a\u52a1\u89d2\u8272\u4e2d\u7684\u7981\u7528\u6743\u9650\u5931\u8d25", (String)"BizRoleService_9", (String)SYS_TYPE, (Object[])new Object[0]);
    }

    private static String getErrorMessage6() {
        return ResManager.loadKDString((String)"\u4e3a\u7528\u6237\u5206\u914d\u8865\u5145\u6743\u9650\u5931\u8d25", (String)"BizRoleService_10", (String)SYS_TYPE, (Object[])new Object[0]);
    }

    private static String getErrorMessage7() {
        return ResManager.loadKDString((String)"\u5220\u9664\u4e1a\u52a1\u89d2\u8272\u4e0e\u4eba\u5458\u7684\u7ed1\u5b9a\u5173\u7cfb\u5931\u8d25", (String)"BizRoleService_11", (String)SYS_TYPE, (Object[])new Object[0]);
    }

    private static String getErrorMessage8() {
        return ResManager.loadKDString((String)"\u5220\u9664\u4e1a\u52a1\u89d2\u8272\u5931\u8d25", (String)"BizRoleService_12", (String)SYS_TYPE, (Object[])new Object[0]);
    }

    public static BizRoleInfo[] queryBizRoles(QFilter q) {
        String selFields = "id" + "," + "number" + "," + "name" + "," + "usertype" + "," + DESCRIPTION + "," + "role" + "," + "org" + "," + "isincludesuborg" + "," + "dimtype";
        DynamicObject[] bizRoleDObjs = BusinessDataServiceHelper.load((String)"perm_bizrole", (String)selFields, (QFilter[])new QFilter[]{q});
        if (bizRoleDObjs == null || bizRoleDObjs.length == 0) {
            return null;
        }
        return (BizRoleInfo[])Stream.of(bizRoleDObjs).map(x -> {
            BizRoleInfo bizRoleInfo = new BizRoleInfo();
            bizRoleInfo.setId(Long.valueOf(x.getLong("id")));
            bizRoleInfo.setNum(x.getString("number"));
            bizRoleInfo.setLocaleName((ILocaleString)new LocaleString(Lang.get().toString(), x.getString("name")));
            bizRoleInfo.setUserType(x.getString("usertype"));
            bizRoleInfo.setDescription(x.getString(DESCRIPTION));
            List<Object> commonRoleList = new ArrayList(16);
            DynamicObjectCollection commroleObjCollection = x.getDynamicObjectCollection("bizrolecomrole");
            if (commroleObjCollection != null && !commroleObjCollection.isEmpty()) {
                commonRoleList = commroleObjCollection.stream().map(roleObj -> {
                    BizRoleInfo.CommonRole commonRole = new BizRoleInfo.CommonRole();
                    commonRole.setCommroleId(roleObj.getString("role.id"));
                    return commonRole;
                }).collect(Collectors.toList());
            }
            bizRoleInfo.setCommonRoleList(commonRoleList);
            List<Object> bizRoleOrgList = new ArrayList(16);
            DynamicObjectCollection bizRoleOrgObjCollection = x.getDynamicObjectCollection("bizroleorg");
            if (bizRoleOrgObjCollection != null && !bizRoleOrgObjCollection.isEmpty()) {
                bizRoleOrgList = bizRoleOrgObjCollection.stream().map(bizRoleOrgObj -> {
                    BizRoleInfo.BizRoleOrg bizRoleOrg = new BizRoleInfo.BizRoleOrg();
                    bizRoleOrg.setOrgId(Long.valueOf(bizRoleOrgObj.getLong("org.id")));
                    bizRoleOrg.setIncludeSub(bizRoleOrgObj.getBoolean("isincludesuborg"));
                    bizRoleOrg.setDimType(bizRoleOrgObj.getString("dimtype"));
                    return bizRoleOrg;
                }).collect(Collectors.toList());
            }
            bizRoleInfo.setBizRoleOrgList(bizRoleOrgList);
            return bizRoleInfo;
        }).toArray(BizRoleInfo[]::new);
    }

    public static BizRoleInfo getBizRoleInfoById(Long bizRoleId) {
        String selFields = "id" + "," + "number" + "," + "name" + "," + "usertype" + "," + DESCRIPTION + "," + "role" + "," + "org" + "," + "isincludesuborg" + "," + "dimtype";
        DynamicObject bizRoleObject = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)"perm_bizrole", (String)selFields);
        if (bizRoleObject == null) {
            return null;
        }
        BizRoleInfo bizRoleInfo = new BizRoleInfo();
        bizRoleInfo.setId(Long.valueOf(bizRoleObject.getLong("id")));
        bizRoleInfo.setNum(bizRoleObject.getString("number"));
        bizRoleInfo.setLocaleName((ILocaleString)new LocaleString(Lang.get().toString(), bizRoleObject.getString("name")));
        bizRoleInfo.setUserType(bizRoleObject.getString("usertype"));
        bizRoleInfo.setDescription(bizRoleObject.getString(DESCRIPTION));
        List<Object> commonRoleList = new ArrayList(16);
        DynamicObjectCollection commroleObjCollection = bizRoleObject.getDynamicObjectCollection("bizrolecomrole");
        if (commroleObjCollection != null && !commroleObjCollection.isEmpty()) {
            commonRoleList = commroleObjCollection.stream().map(roleObj -> {
                BizRoleInfo.CommonRole commonRole = new BizRoleInfo.CommonRole();
                commonRole.setCommroleId(roleObj.getString("role.id"));
                return commonRole;
            }).collect(Collectors.toList());
        }
        bizRoleInfo.setCommonRoleList(commonRoleList);
        List<Object> bizRoleOrgList = new ArrayList(16);
        DynamicObjectCollection bizRoleOrgObjCollection = bizRoleObject.getDynamicObjectCollection("bizroleorg");
        if (bizRoleOrgObjCollection != null && !bizRoleOrgObjCollection.isEmpty()) {
            bizRoleOrgList = bizRoleOrgObjCollection.stream().map(bizRoleOrgObj -> {
                BizRoleInfo.BizRoleOrg bizRoleOrg = new BizRoleInfo.BizRoleOrg();
                bizRoleOrg.setOrgId(Long.valueOf(bizRoleOrgObj.getLong("org.id")));
                bizRoleOrg.setIncludeSub(bizRoleOrgObj.getBoolean("isincludesuborg"));
                bizRoleOrg.setDimType(bizRoleOrgObj.getString("dimtype"));
                return bizRoleOrg;
            }).collect(Collectors.toList());
        }
        bizRoleInfo.setBizRoleOrgList(bizRoleOrgList);
        return bizRoleInfo;
    }

    public static List<BizRoleInfo.BizRolePerm> getBizRolePermByBizRoleId(Long bizRoleId) {
        List<Object> bizRolePermList = new ArrayList<BizRoleInfo.BizRolePerm>(16);
        DynamicObject bizRoleObject = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)"perm_bizrole", (String)"permitem,entitytype,bizapp");
        if (bizRoleObject == null) {
            return bizRolePermList;
        }
        DynamicObjectCollection permObjCollection = bizRoleObject.getDynamicObjectCollection("bizroleperm");
        if (permObjCollection != null && !permObjCollection.isEmpty()) {
            bizRolePermList = permObjCollection.stream().map(permObj -> {
                DynamicObject permItemObj = permObj.getDynamicObject("permitem");
                DynamicObject entityObj = permObj.getDynamicObject("entitytype");
                DynamicObject appObj = permObj.getDynamicObject("bizapp");
                if (permItemObj != null && entityObj != null && appObj != null) {
                    BizRoleInfo.BizRolePerm bzrPerm = new BizRoleInfo.BizRolePerm();
                    bzrPerm.setPermitemId(permItemObj.getString("id"));
                    bzrPerm.setEntitytypeid(entityObj.getString("id"));
                    bzrPerm.setBizappid(appObj.getString("id"));
                    return bzrPerm;
                }
                return null;
            }).filter(x -> x != null).collect(Collectors.toList());
        }
        return bizRolePermList;
    }

    public static List<BizRoleInfo.BizRoleDisPerm> getBizRoleDisPermByBizRoleId(Long bizRoleId) {
        List<Object> bizRoleDisPermList = new ArrayList<BizRoleInfo.BizRoleDisPerm>(16);
        DynamicObject bizRoleObject = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)"perm_bizrole", (String)"permitemforbid,entitytypeforbid,bizappforbid");
        if (bizRoleObject == null) {
            return bizRoleDisPermList;
        }
        DynamicObjectCollection disPermObjCollection = bizRoleObject.getDynamicObjectCollection("bizroledisperm");
        if (disPermObjCollection != null && !disPermObjCollection.isEmpty()) {
            bizRoleDisPermList = disPermObjCollection.stream().map(disPermObj -> {
                BizRoleInfo.BizRoleDisPerm bzDisPerm = new BizRoleInfo.BizRoleDisPerm();
                bzDisPerm.setPermitemId(disPermObj.getString("permitemforbid.id"));
                bzDisPerm.setEntitytypeid(disPermObj.getString("entitytypeforbid.id"));
                bzDisPerm.setBizappid(disPermObj.getString("bizappforbid.id"));
                return bzDisPerm;
            }).collect(Collectors.toList());
        }
        return bizRoleDisPermList;
    }

    public static List<Long> getBizRolesByUserID(Long userId) {
        return new LinkedList<Long>(BizRoleFunPermService.getUserBizRoleIDs(userId));
    }

    public static String getBizRolesByUserIDAndShiftToStr(Long userId) {
        List<Long> bizRoleIDs = BizRoleService.getBizRolesByUserID(userId);
        if (bizRoleIDs.isEmpty()) {
            return "";
        }
        StringBuilder bizRoleIDBuilder = new StringBuilder("( ");
        for (Long bizRoleID : bizRoleIDs) {
            bizRoleIDBuilder.append(" '").append(bizRoleID).append("',");
        }
        bizRoleIDBuilder.deleteCharAt(bizRoleIDBuilder.length() - 1).append(" )");
        return bizRoleIDBuilder.toString();
    }

    public static Set<String> getCommRoleIdsByUserID(Long userId) {
        String bizroleIdStr = BizRoleService.getBizRolesByUserIDAndShiftToStr(userId);
        if (StringUtils.isEmpty((String)bizroleIdStr)) {
            return new HashSet<String>(0);
        }
        StringBuilder sqlSB = new StringBuilder().append("select pbc.froleid roleid from t_perm_bizrolecomrole pbc ").append(" inner join t_perm_role r on r.fid=pbc.froleid").append(" where r.fenable='1' and pbc.fid in ").append(bizroleIdStr);
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), rs -> {
            HashSet<String> commRoleIds = new HashSet<String>(16);
            while (rs.next()) {
                String roleId = rs.getString("roleid");
                commRoleIds.add(roleId);
            }
            return commRoleIds;
        });
    }

    public static Set<String> getCommRoleIdsByUserIDAndOrgId(Long userId, Long orgId) {
        String bizroleIdStr = BizRoleService.getBizRolesByUserIDAndShiftToStr(userId);
        if (StringUtils.isEmpty((String)bizroleIdStr)) {
            return new HashSet<String>(0);
        }
        StringBuilder sqlSB = new StringBuilder().append("SELECT DISTINCT PBC.FROLEID ROLEID FROM T_PERM_BIZROLECOMROLE PBC ").append(" INNER JOIN T_PERM_ROLE R ON R.FID=PBC.FROLEID").append(" INNER JOIN T_PERM_BIZROLEORG PBO ON PBC.FID=PBO.FID").append(" WHERE R.FENABLE='1' AND PBO.FORGID=? AND PBC.FID IN ").append(bizroleIdStr);
        Object[] params = new Object[]{orgId};
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (Object[])params, rs -> {
            HashSet<String> commRoleIds = new HashSet<String>(16);
            while (rs.next()) {
                String bizRoleId = rs.getString("ROLEID");
                commRoleIds.add(bizRoleId);
            }
            return commRoleIds;
        });
    }

    public static Set<String> getCommRoleIdsByUserIDAndDimId(Long userId, Long dimId, String dimType) {
        String bizroleIdStr = BizRoleService.getBizRolesByUserIDAndShiftToStr(userId);
        if (StringUtils.isEmpty((String)bizroleIdStr)) {
            return new HashSet<String>(0);
        }
        StringBuilder sqlSB = new StringBuilder().append("select distinct pbc.froleid roleid from t_perm_bizrolecomrole pbc ").append(" inner join t_perm_role r on r.fid=pbc.froleid");
        if (dimId != null && dimId != 0L || StringUtils.isNotEmpty((String)dimType)) {
            sqlSB.append(" inner join t_perm_bizroleorg pbo on pbc.fid=pbo.fid");
        }
        sqlSB.append(" where r.fenable='1' and pbc.fid in ").append(bizroleIdStr);
        if (dimId != null && dimId != 0L) {
            sqlSB.append(" and pbo.forgid=").append(dimId);
        }
        if (IsoDimHelper.addDimTypeFilter(dimType)) {
            sqlSB.append(" and pbo.fdimtype='").append(dimType).append('\'');
        }
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), rs -> {
            HashSet<String> commRoleIds = new HashSet<String>(16);
            while (rs.next()) {
                String bizRoleId = rs.getString("roleid");
                commRoleIds.add(bizRoleId);
            }
            return commRoleIds;
        });
    }

    public static Set<String> getCommRoleIdsByUserIDAndDimIds(Long userId, List<Long> dimIds, String dimType) {
        String bizroleIdStr = BizRoleService.getBizRolesByUserIDAndShiftToStr(userId);
        if (StringUtils.isEmpty((String)bizroleIdStr)) {
            return new HashSet<String>(0);
        }
        StringBuilder sqlSB = new StringBuilder().append("select distinct pbc.froleid roleid from t_perm_bizrolecomrole pbc ").append(" inner join t_perm_role r on r.fid=pbc.froleid");
        if (dimIds != null && !dimIds.isEmpty() || StringUtils.isNotEmpty((String)dimType)) {
            sqlSB.append(" inner join t_perm_bizroleorg pbo on pbc.fid=pbo.fid");
        }
        sqlSB.append(" where r.fenable='1' and pbc.fid in ").append(bizroleIdStr);
        if (dimIds != null && !dimIds.isEmpty()) {
            sqlSB.append(" and pbo.forgid in (");
            for (Long dimId : dimIds) {
                sqlSB.append('\'').append(dimId).append("',");
            }
            sqlSB.deleteCharAt(sqlSB.length() - 1);
            sqlSB.append(')');
        }
        if (IsoDimHelper.addDimTypeFilter(dimType)) {
            sqlSB.append(" and pbo.fdimtype='").append(dimType).append('\'');
        }
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), rs -> {
            HashSet<String> commRoleIds = new HashSet<String>(16);
            while (rs.next()) {
                String bizRoleId = rs.getString("roleid");
                commRoleIds.add(bizRoleId);
            }
            return commRoleIds;
        });
    }

    public static Set<String> getCommRoleIdsByUserIDAndDimIdWithSup(Long userId, List<Long> superiorOrg, String dimType) {
        String bizroleIdStr = BizRoleService.getBizRolesByUserIDAndShiftToStr(userId);
        if (StringUtils.isEmpty((String)bizroleIdStr)) {
            return new HashSet<String>(0);
        }
        if (superiorOrg == null || superiorOrg.isEmpty()) {
            return new HashSet<String>(16);
        }
        StringBuilder sqlSB = new StringBuilder().append("select distinct pbc.froleid roleid from t_perm_bizrolecomrole pbc ").append(" inner join t_perm_role r on r.fid=pbc.froleid").append(" inner join t_perm_bizroleorg pbo on pbc.fid=pbo.fid").append(" where r.fenable='1' and pbc.fid in ").append(bizroleIdStr);
        if (!CollectionUtils.isEmpty(superiorOrg)) {
            List dimIds = superiorOrg.stream().map(String::valueOf).collect(Collectors.toList());
            String dimIdsStr = String.join((CharSequence)"','", dimIds);
            sqlSB.append(" and pbo.forgid in ('").append(dimIdsStr).append("')");
        }
        if (IsoDimHelper.addDimTypeFilter(dimType)) {
            sqlSB.append(" and pbo.fdimtype='").append(dimType).append('\'');
        }
        sqlSB.append(" and pbo.fisincludesuborg='1'");
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), rs -> {
            HashSet<String> commRoleIds = new HashSet<String>(16);
            while (rs.next()) {
                String bizRoleId = rs.getString("roleid");
                commRoleIds.add(bizRoleId);
            }
            return commRoleIds;
        });
    }

    public static Map<String, Map<Long, Boolean>> getComRoleDimObj(Long userId) {
        return BizRoleService.getComRoleDimObj(userId, null);
    }

    public static Map<String, Map<Long, Boolean>> getComRoleDimObj(Long userId, String dimType) {
        String bizroleIdStr = BizRoleService.getBizRolesByUserIDAndShiftToStr(userId);
        if (StringUtils.isEmpty((String)bizroleIdStr)) {
            return new HashMap<String, Map<Long, Boolean>>(0);
        }
        ArrayList<String> paramList = new ArrayList<String>(10);
        StringBuilder sqlSB = new StringBuilder().append("select pbc.froleid roleid,pbo.forgid orgid,pbo.fisincludesuborg isincludesub from t_perm_bizrolecomrole pbc ").append(" inner join t_perm_role r on r.fid=pbc.froleid").append(" inner join t_perm_bizroleorg pbo on pbc.fid=pbo.fid").append(" where r.fenable='1' and pbc.fid in ").append(bizroleIdStr);
        if (StringUtils.isNotEmpty((String)dimType)) {
            sqlSB.append(" and pbo.fdimtype = ? ");
            paramList.add(dimType);
        }
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), rs -> {
            HashMap<String, Map> returmMap = new HashMap<String, Map>(16);
            while (rs.next()) {
                String bizRoleId = rs.getString("roleid");
                Long orgId = rs.getLong("orgId");
                String isincludesub = rs.getString("isincludesub");
                Boolean hasSub = isincludesub.equals("1");
                if (hasSub.booleanValue()) {
                    returmMap.computeIfAbsent(bizRoleId, k -> new HashMap(16)).put(orgId, hasSub);
                    continue;
                }
                returmMap.computeIfAbsent(bizRoleId, k -> new HashMap(16)).putIfAbsent(orgId, hasSub);
            }
            return returmMap;
        });
    }

    public static List<Long> getUsersByBizRoleID(Long bizRoleId) {
        HashSet<Long> userIdSet = new HashSet<Long>(8);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"BizRoleService.getUsersByBizRoleID", (String)"perm_userbizrole", (String)"user.id", (QFilter[])new QFilter[]{new QFilter("bizrole", "=", (Object)bizRoleId)}, (String)"user.id asc");){
            while (queryDataSet.hasNext()) {
                Row row = queryDataSet.next();
                userIdSet.add(row.getLong("user.id"));
            }
        }
        String sql = "select ugs.fuserid userid from t_sec_usergroupstaff ugs join t_perm_usrgrpbizrole ugb on (ugs.fusergroupid=ugb.fusrgrpid) where ugb.fbizroleid =?";
        Object[] params = new Object[]{bizRoleId};
        DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, rs -> {
            while (rs.next()) {
                Long userId = rs.getLong("userid");
                userIdSet.add(userId);
            }
            return null;
        });
        return new ArrayList<Long>(userIdSet);
    }

    public static List<Long> getUsersByBizRoleNum(String bizRoleNum) {
        HashSet<Long> userIds = new HashSet<Long>();
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"BizRoleService.getUsersByRoleNum", (String)"perm_userbizrole", (String)"user.id", (QFilter[])new QFilter[]{new QFilter("bizrole.number", "=", (Object)bizRoleNum)}, (String)"user.id asc");){
            while (queryDataSet.hasNext()) {
                Row row = queryDataSet.next();
                userIds.add(row.getLong("user.id"));
            }
        }
        ArrayList<Long> userIdsList = new ArrayList<Long>(userIds);
        String sql = "select ugs.fuserid userid from t_sec_usergroupstaff ugs join t_perm_usrgrpbizrole ugb on (ugs.fusergroupid=ugb.fusrgrpid)  join t_perm_bizrole b on b.fid = ugb.fbizroleid where b.fnumber = ?";
        Object[] params = new Object[]{bizRoleNum};
        Set userIdsSet = (Set)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, rs -> {
            HashSet<Long> result = new HashSet<Long>(16);
            while (rs.next()) {
                Long userId = rs.getLong("userid");
                result.add(userId);
            }
            return result;
        });
        userIdsList.addAll(userIdsSet);
        return userIdsList;
    }

    public static boolean newBizRole(BizRoleInfo bizRoleInfo, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (bizRoleInfo == null) {
            processInfo.append(ResManager.loadKDString((String)"bizRoleInfo\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_13", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        ILocaleString localeName = bizRoleInfo.getLocaleName();
        if (localeName == null) {
            processInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_14", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        String userType = bizRoleInfo.getUserType();
        if (StringUtils.isEmpty((String)userType)) {
            processInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u201c\u9002\u7528\u7528\u6237\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_15", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (bizRoleInfo.getCommonRoleList() == null || bizRoleInfo.getCommonRoleList().isEmpty() || bizRoleInfo.getCommonRoleList().stream().anyMatch(x -> StringUtils.isEmpty((String)x.getCommroleId()) || !QueryServiceHelper.exists((String)"perm_role", (Object)x.getCommroleId()))) {
            processInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u5173\u8054\u7684\u901a\u7528\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u89d2\u8272\u5bf9\u8c61\u5fc5\u987b\u5b58\u5728", (String)"BizRoleService_16", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (bizRoleInfo.getBizRoleOrgList() == null || bizRoleInfo.getBizRoleOrgList().isEmpty() || bizRoleInfo.getBizRoleOrgList().stream().anyMatch(x -> x.getOrgId() == null || x.getOrgId() == 0L)) {
            processInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u5173\u8054\u7684\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_17", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject bizRoleDObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_bizrole");
        String num = CodeRuleServiceHelper.getNumber((String)"perm_bizrole", (DynamicObject)bizRoleDObj, null);
        if (StringUtils.isEmpty((String)num)) {
            num = ORM.create().genStringId("perm_bizrole");
        }
        DynamicObjectCollection bizRoleCommRoleDoc = bizRoleDObj.getDynamicObjectCollection("bizrolecomrole");
        bizRoleInfo.getCommonRoleList().stream().forEach(x -> {
            DynamicObject bizRoleCommRoleRow = new DynamicObject(bizRoleCommRoleDoc.getDynamicObjectType());
            bizRoleCommRoleRow.set("role", (Object)x.getCommroleId());
            bizRoleCommRoleDoc.add((Object)bizRoleCommRoleRow);
        });
        DynamicObjectCollection bizRoleOrgDoc = bizRoleDObj.getDynamicObjectCollection("bizroleorg");
        bizRoleInfo.getBizRoleOrgList().stream().forEach(x -> {
            DynamicObject bizRoleOrgRow = new DynamicObject(bizRoleOrgDoc.getDynamicObjectType());
            bizRoleOrgRow.set("org", (Object)x.getOrgId());
            bizRoleOrgRow.set("isincludesuborg", (Object)x.isIncludeSub());
            bizRoleOrgRow.set("dimtype", (Object)x.getDimType());
            bizRoleOrgDoc.add((Object)bizRoleOrgRow);
        });
        bizRoleDObj.set("number", (Object)num);
        bizRoleDObj.set("name", (Object)localeName);
        bizRoleDObj.set("usertype", (Object)bizRoleInfo.getUserType());
        bizRoleDObj.set(DESCRIPTION, (Object)(bizRoleInfo.getDescription() == null ? " " : bizRoleInfo.getDescription()));
        bizRoleDObj.set("bizrolecomrole", (Object)bizRoleCommRoleDoc);
        bizRoleDObj.set("bizroleorg", (Object)bizRoleOrgDoc);
        bizRoleDObj.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        bizRoleDObj.set("createtime", (Object)new Date());
        bizRoleDObj.set("status", (Object)"C");
        bizRoleDObj.set("enable", (Object)"1");
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"perm_bizrole", (DynamicObject[])new DynamicObject[]{bizRoleDObj}, (OperateOption)OperateOption.create());
        if (executeOperate.isSuccess()) {
            processInfo.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"BizRoleService_18", (String)SYS_TYPE, (Object[])new Object[0]));
            bizRoleInfo.setId((Long)executeOperate.getSuccessPkIds().get(0));
            return true;
        }
        processInfo.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"BizRoleService_19", (String)SYS_TYPE, (Object[])new Object[0]));
        BizRoleService.recordErrorMessage(processInfo, executeOperate);
        return false;
    }

    private static void recordErrorMessage(StringBuilder processInfo, OperationResult executeOperate) {
        processInfo.append(": ").append(executeOperate.getMessage()).append(' ');
        for (OperateErrorInfo opErrInfo : executeOperate.getAllErrorInfo()) {
            processInfo.append(opErrInfo.getErrorCode()).append(',').append(opErrInfo.getErrorLevel()).append(',').append(opErrInfo.getMessage()).append('\n');
        }
        for (ValidateResult validateResults : executeOperate.getValidateResult().getValidateErrors()) {
            for (OperateErrorInfo opErrInfo : validateResults.getAllErrorInfo()) {
                processInfo.append(opErrInfo.getErrorCode()).append(',').append(opErrInfo.getErrorLevel()).append(',').append(opErrInfo.getMessage()).append('\n');
            }
        }
    }

    public static boolean modifyBizRole(BizRoleInfo bizRoleInfo, StringBuilder processInfo) {
        String description;
        String userType;
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (bizRoleInfo == null) {
            processInfo.append(ResManager.loadKDString((String)"bizRoleInfo\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_13", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject bizRoleObj = BusinessDataServiceHelper.loadSingle((Object)bizRoleInfo.getId(), (String)"perm_bizrole");
        if (bizRoleObj == null) {
            processInfo.append(BizRoleService.getMessage());
            return false;
        }
        ILocaleString localeName = bizRoleInfo.getLocaleName();
        if (localeName != null) {
            bizRoleObj.set("name", (Object)localeName);
        }
        if (StringUtils.isNotEmpty((String)(userType = bizRoleInfo.getUserType()))) {
            bizRoleObj.set("usertype", (Object)bizRoleInfo.getUserType());
        }
        if (StringUtils.isNotEmpty((String)(description = bizRoleInfo.getDescription()))) {
            bizRoleObj.set(DESCRIPTION, (Object)description);
        }
        bizRoleObj.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
        bizRoleObj.set("modifytime", (Object)new Date());
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"perm_bizrole", (DynamicObject[])new DynamicObject[]{bizRoleObj}, (OperateOption)OperateOption.create());
        if (executeOperate.isSuccess()) {
            processInfo.append(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"BizRoleService_20", (String)SYS_TYPE, (Object[])new Object[0]));
            return true;
        }
        processInfo.append(ResManager.loadKDString((String)"\u66f4\u65b0\u4e1a\u52a1\u89d2\u8272\u5931\u8d25", (String)"BizRoleService_21", (String)SYS_TYPE, (Object[])new Object[0]));
        BizRoleService.recordErrorMessage(processInfo, executeOperate);
        return false;
    }

    public static boolean modifyBizRoleCommRoles(Long bizRoleId, List<BizRoleInfo.CommonRole> commonRoleList, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (bizRoleId == null) {
            processInfo.append(ResManager.loadKDString((String)"bizRoleInfo\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_13", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (commonRoleList == null || commonRoleList.isEmpty() || commonRoleList.stream().anyMatch(x -> StringUtils.isEmpty((String)x.getCommroleId()) || !QueryServiceHelper.exists((String)"perm_role", (Object)x.getCommroleId()))) {
            processInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u5173\u8054\u7684\u901a\u7528\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u89d2\u8272\u5bf9\u8c61\u5fc5\u987b\u5b58\u5728", (String)"BizRoleService_16", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject bizRoleObj = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)"perm_bizrole");
        if (bizRoleObj == null) {
            processInfo.append(BizRoleService.getMessage());
            return false;
        }
        List<Long> userIds = BizRoleService.getUsersByBizRoleID(bizRoleId);
        try (TXHandle h1 = TX.required();){
            if (userIds != null && !userIds.isEmpty()) {
                DynamicObjectCollection bizRoleCommRoleDoc = bizRoleObj.getDynamicObjectCollection("bizrolecomrole");
                bizRoleCommRoleDoc.clear();
                for (BizRoleInfo.CommonRole commonRole : commonRoleList) {
                    DynamicObject bizRoleCommRoleRow = new DynamicObject(bizRoleCommRoleDoc.getDynamicObjectType());
                    bizRoleCommRoleRow.set("role", (Object)commonRole.getCommroleId());
                    bizRoleCommRoleDoc.add((Object)bizRoleCommRoleRow);
                }
            }
            bizRoleObj.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
            bizRoleObj.set("modifytime", (Object)new Date());
            OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"perm_bizrole", (DynamicObject[])new DynamicObject[]{bizRoleObj}, (OperateOption)OperateOption.create());
            if (executeOperate.isSuccess()) {
                processInfo.append(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"BizRoleService_20", (String)SYS_TYPE, (Object[])new Object[0]));
                boolean bl = true;
                return bl;
            }
            try {
                processInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u5173\u8054\u901a\u7528\u89d2\u8272\u5931\u8d25", (String)"BizRoleService_22", (String)SYS_TYPE, (Object[])new Object[0]));
                BizRoleService.recordErrorMessage(processInfo, executeOperate);
                throw new KDException(new ErrorCode("BizRoleService_modifyCommonRoles", BizRoleService.getErrorMessage1()), new Object[]{BizRoleService.getErrorMessage1()});
            }
            catch (Exception e) {
                h1.markRollback();
                processInfo.append(ResManager.loadKDString((String)"\u4fee\u6539\u4e8b\u52a1\u5931\u8d25", (String)"BizRoleService_23", (String)SYS_TYPE, (Object[])new Object[0]));
                boolean bl = false;
                return bl;
            }
        }
    }

    public static boolean modifyBizRoleOrgs(Long bizRoleId, List<BizRoleInfo.BizRoleOrg> bizRoleOrgList, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (bizRoleId == null) {
            processInfo.append(ResManager.loadKDString((String)"bizRoleInfo\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_13", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (bizRoleOrgList == null || bizRoleOrgList.isEmpty() || bizRoleOrgList.stream().anyMatch(x -> x.getOrgId() == null || x.getOrgId() == 0L)) {
            processInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u5173\u8054\u7684\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_17", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject bizRoleObj = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)"perm_bizrole");
        if (bizRoleObj == null) {
            processInfo.append(BizRoleService.getMessage());
            return false;
        }
        List<Long> userIds = BizRoleService.getUsersByBizRoleID(bizRoleId);
        try (TXHandle h1 = TX.required();){
            DynamicObjectCollection bizRoleOrgDoc = bizRoleObj.getDynamicObjectCollection("bizroleorg");
            bizRoleOrgDoc.clear();
            bizRoleOrgList.stream().forEach(x -> {
                DynamicObject bizRoleOrgRow = new DynamicObject(bizRoleOrgDoc.getDynamicObjectType());
                bizRoleOrgRow.set("org", (Object)x.getOrgId());
                bizRoleOrgRow.set("isincludesuborg", (Object)x.isIncludeSub());
                bizRoleOrgRow.set("dimtype", (Object)x.getDimType());
                bizRoleOrgDoc.add((Object)bizRoleOrgRow);
            });
            bizRoleObj.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
            bizRoleObj.set("modifytime", (Object)new Date());
            OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"perm_bizrole", (DynamicObject[])new DynamicObject[]{bizRoleObj}, (OperateOption)OperateOption.create());
            if (executeOperate.isSuccess()) {
                UserHasPermOrgCache.clearUserLoginOrgs(userIds);
                UserHasPermDimObjCache.removeCache(userIds);
                processInfo.append(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"BizRoleService_20", (String)SYS_TYPE, (Object[])new Object[0]));
                if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
                    try {
                        FormConfigFactory.cancelShowFormRights(userIds);
                    }
                    catch (Exception ex) {
                        logger.warn("[clearDynamicCache]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Throwable)ex);
                    }
                }
                boolean bl = true;
                return bl;
            }
            try {
                processInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u5173\u8054\u7ec4\u7ec7\u5931\u8d25", (String)"BizRoleService_24", (String)SYS_TYPE, (Object[])new Object[0]));
                BizRoleService.recordErrorMessage(processInfo, executeOperate);
                throw new KDException(new ErrorCode("BizRoleService_modifyBizRoleOrgs", BizRoleService.getErrorMessage1()), new Object[]{BizRoleService.getErrorMessage1()});
            }
            catch (Exception e) {
                h1.markRollback();
                processInfo.append(ResManager.loadKDString((String)"\u4fee\u6539\u4e8b\u52a1\u5931\u8d25", (String)"BizRoleService_23", (String)SYS_TYPE, (Object[])new Object[0]));
                boolean bl = false;
                return bl;
            }
        }
    }

    public static boolean bizRoleAssignFuncPerm(Long bizRoleId, List<BizRoleInfo.BizRolePerm> bizRolePermList, boolean addOrRemove, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (bizRoleId == null) {
            processInfo.append(BizRoleService.getMessage2());
            return false;
        }
        if (bizRolePermList == null || bizRolePermList.isEmpty() || bizRolePermList.stream().anyMatch(x -> StringUtils.isEmpty((String)x.getBizappid()) || StringUtils.isEmpty((String)x.getEntitytypeid()) || StringUtils.isEmpty((String)x.getPermitemId()))) {
            processInfo.append(ResManager.loadKDString((String)"BizRolePerm\u4e2d\u5e94\u7528ID\uff0c\u5b9e\u4f53\u7f16\u7801\u548c\u6743\u9650\u9879ID\u5747\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_25", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject bizRoleObj = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)"perm_bizrole");
        if (bizRoleObj == null) {
            processInfo.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4e1a\u52a1\u89d2\u8272", (String)"BizRoleService_26", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection bizRolePermDoc = bizRoleObj.getDynamicObjectCollection("bizroleperm");
        DynamicObjectCollection bizRoleOrgDoc = bizRoleObj.getDynamicObjectCollection("bizroleorg");
        ArrayList userFunpermList = new ArrayList();
        bizRolePermList.stream().forEach(x -> {
            if (addOrRemove) {
                boolean permExist = bizRolePermDoc.stream().anyMatch(y -> {
                    String existAppid = y.getString("bizapp_id");
                    String existEntitytypeId = y.getString("entitytype_id");
                    String existPermitemId = y.getString("permitem_id");
                    return x.getBizappid().equals(existAppid) && x.getEntitytypeid().equals(existEntitytypeId) && x.getPermitemId().equals(existPermitemId);
                });
                if (!permExist) {
                    DynamicObject bizRolePermRow = new DynamicObject(bizRolePermDoc.getDynamicObjectType());
                    bizRolePermRow.set("bizapp", (Object)x.getBizappid());
                    bizRolePermRow.set("entitytype", (Object)x.getEntitytypeid());
                    bizRolePermRow.set("permitem", (Object)x.getPermitemId());
                    bizRolePermDoc.add((Object)bizRolePermRow);
                    userFunpermList.add(x);
                }
            } else {
                Iterator ite = bizRolePermDoc.iterator();
                while (ite.hasNext()) {
                    DynamicObject bizRolePermObj = (DynamicObject)ite.next();
                    String existAppid = bizRolePermObj.getString("bizapp_id");
                    String existEntitytypeId = bizRolePermObj.getString("entitytype_id");
                    String existPermitemId = bizRolePermObj.getString("permitem_id");
                    if (!x.getBizappid().equals(existAppid) || !x.getEntitytypeid().equals(existEntitytypeId) || !x.getPermitemId().equals(existPermitemId)) continue;
                    ite.remove();
                    userFunpermList.add(x);
                }
            }
        });
        bizRoleObj.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
        bizRoleObj.set("modifytime", (Object)new Date());
        List<Long> userIds = BizRoleService.getUsersByBizRoleID(bizRoleId);
        HashMap<String, Map> appEntityPermItemMap = new HashMap<String, Map>(16);
        for (BizRoleInfo.BizRolePerm bizRolePerm : userFunpermList) {
            appEntityPermItemMap.computeIfAbsent(bizRolePerm.getBizappid(), k -> new HashMap(16)).computeIfAbsent(bizRolePerm.getEntitytypeid(), k -> new ArrayList(16)).add(bizRolePerm.getPermitemId());
        }
        try (TXHandle h1 = TX.required();){
            OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"perm_bizrole", (DynamicObject[])new DynamicObject[]{bizRoleObj}, (OperateOption)OperateOption.create());
            if (executeOperate.isSuccess()) {
                processInfo.append(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"BizRoleService_20", (String)SYS_TYPE, (Object[])new Object[0]));
                UserHasPermOrgCache.clearUserLoginOrgs(userIds);
                UserHasPermDimObjCache.removeCache(userIds);
                if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
                    try {
                        FormConfigFactory.cancelShowFormRights(userIds);
                    }
                    catch (Exception ex) {
                        logger.warn("[clearDynamicCache]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Throwable)ex);
                    }
                }
                boolean bl = true;
                return bl;
            }
            try {
                processInfo.append(BizRoleService.getMessage3());
                BizRoleService.recordErrorMessage(processInfo, executeOperate);
                throw new KDException(new ErrorCode(ERRORCODE_1, BizRoleService.getErrorMessage1()), new Object[]{BizRoleService.getErrorMessage1()});
            }
            catch (Exception e) {
                h1.markRollback();
                boolean bl = false;
                return bl;
            }
        }
    }

    public static boolean bizRoleDisFuncPerm(Long bizRoleId, List<BizRoleInfo.BizRoleDisPerm> bizRoleDisPermList, boolean addOrRemove, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (bizRoleId == null) {
            processInfo.append(BizRoleService.getMessage2());
            return false;
        }
        if (bizRoleDisPermList == null || bizRoleDisPermList.isEmpty() || bizRoleDisPermList.stream().anyMatch(x -> StringUtils.isEmpty((String)x.getBizappid()) || StringUtils.isEmpty((String)x.getEntitytypeid()) || StringUtils.isEmpty((String)x.getPermitemId()))) {
            processInfo.append(ResManager.loadKDString((String)"BizRoleDisPerm\u4e2d\u5e94\u7528ID\uff0c\u5b9e\u4f53\u7f16\u7801\u548c\u6743\u9650\u9879ID\u5747\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_27", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject bizRoleObj = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)"perm_bizrole");
        if (bizRoleObj == null) {
            processInfo.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4e1a\u52a1\u89d2\u8272", (String)"BizRoleService_26", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection bizRoleDisPermDoc = bizRoleObj.getDynamicObjectCollection("bizroledisperm");
        DynamicObjectCollection bizRoleOrgDoc = bizRoleObj.getDynamicObjectCollection("bizroleorg");
        ArrayList userFunDispermList = new ArrayList();
        bizRoleDisPermList.stream().forEach(x -> {
            if (addOrRemove) {
                boolean permExist = bizRoleDisPermDoc.stream().anyMatch(y -> {
                    String existAppid = y.getString("bizappforbid_id");
                    String existEntitytypeId = y.getString("entitytypeforbid_id");
                    String existPermitemId = y.getString("permitemforbid_id");
                    return x.getBizappid().equals(existAppid) && x.getEntitytypeid().equals(existEntitytypeId) && x.getPermitemId().equals(existPermitemId);
                });
                if (!permExist) {
                    DynamicObject bizRoleDisPermRow = new DynamicObject(bizRoleDisPermDoc.getDynamicObjectType());
                    bizRoleDisPermRow.set("bizappforbid", (Object)x.getBizappid());
                    bizRoleDisPermRow.set("entitytypeforbid", (Object)x.getEntitytypeid());
                    bizRoleDisPermRow.set("permitemforbid", (Object)x.getPermitemId());
                    bizRoleDisPermDoc.add((Object)bizRoleDisPermRow);
                    userFunDispermList.add(x);
                }
            } else {
                Iterator ite = bizRoleDisPermDoc.iterator();
                while (ite.hasNext()) {
                    DynamicObject bizRoleDisPermObj = (DynamicObject)ite.next();
                    String existAppid = bizRoleDisPermObj.getString("bizappforbid_id");
                    String existEntitytypeId = bizRoleDisPermObj.getString("entitytypeforbid_id");
                    String existPermitemId = bizRoleDisPermObj.getString("permitemforbid_id");
                    if (!x.getBizappid().equals(existAppid) || !x.getEntitytypeid().equals(existEntitytypeId) || !x.getPermitemId().equals(existPermitemId)) continue;
                    ite.remove();
                    userFunDispermList.add(x);
                }
            }
        });
        bizRoleObj.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
        bizRoleObj.set("modifytime", (Object)new Date());
        List<Long> userIds = BizRoleService.getUsersByBizRoleID(bizRoleId);
        HashMap<String, Map> appEntityPermItemMap = new HashMap<String, Map>(16);
        for (BizRoleInfo.BizRoleDisPerm bizRoleDisPerm : userFunDispermList) {
            appEntityPermItemMap.computeIfAbsent(bizRoleDisPerm.getBizappid(), k -> new HashMap(16)).computeIfAbsent(bizRoleDisPerm.getEntitytypeid(), k -> new ArrayList(16)).add(bizRoleDisPerm.getPermitemId());
        }
        try (TXHandle h1 = TX.required();){
            boolean saveOrRemoveUserDisFuncPermResult = true;
            if (userIds != null && !userIds.isEmpty() && !userFunDispermList.isEmpty()) {
                block17: for (DynamicObject row : bizRoleOrgDoc) {
                    Long dimObjId = row.getLong("org_id");
                    String dimType = row.getString("dimtype");
                    ArrayList<Long> orgIdList = null;
                    for (Long userId : userIds) {
                        orgIdList = new ArrayList<Long>(16);
                        orgIdList.add(dimObjId);
                        boolean disFunPermResult = PermissionServiceHelper.userDisFuncPerm((Long)userId, (String)dimType, orgIdList, appEntityPermItemMap, (boolean)addOrRemove, (String)"3", (Long)bizRoleId);
                        if (disFunPermResult) continue;
                        saveOrRemoveUserDisFuncPermResult = false;
                        break block17;
                    }
                }
            }
            if (!saveOrRemoveUserDisFuncPermResult) {
                processInfo.append(BizRoleService.getMessage3());
                throw new KDException(new ErrorCode(ERRORCODE_2, BizRoleService.getErrorMessage5()), new Object[]{BizRoleService.getErrorMessage5()});
            }
            OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"perm_bizrole", (DynamicObject[])new DynamicObject[]{bizRoleObj}, (OperateOption)OperateOption.create());
            if (executeOperate.isSuccess()) {
                processInfo.append(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"BizRoleService_20", (String)SYS_TYPE, (Object[])new Object[0]));
                UserHasPermOrgCache.clearUserLoginOrgs(userIds);
                UserHasPermDimObjCache.removeCache(userIds);
                if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
                    try {
                        FormConfigFactory.cancelShowFormRights(userIds);
                    }
                    catch (Exception ex) {
                        logger.warn("[clearDynamicCache]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Throwable)ex);
                    }
                }
                boolean bl = true;
                return bl;
            }
            try {
                processInfo.append(BizRoleService.getMessage3());
                BizRoleService.recordErrorMessage(processInfo, executeOperate);
                throw new KDException(new ErrorCode(ERRORCODE_2, BizRoleService.getErrorMessage5()), new Object[]{BizRoleService.getErrorMessage1()});
            }
            catch (Exception e) {
                h1.markRollback();
                boolean bl = false;
                return bl;
            }
        }
    }

    public static boolean userBundleBizRole(Long userId, Map<Long, Object[]> assignInfo, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (userId == null) {
            processInfo.append(BizRoleService.getMessage1());
            return false;
        }
        if (assignInfo == null || assignInfo.isEmpty()) {
            processInfo.append(ResManager.loadKDString((String)"\u89d2\u8272\u7ed1\u5b9a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_28", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        LinkedList<Long> bizRoleIds = new LinkedList<Long>(BizRoleFunPermService.getUserBizRoleIDs(userId, false, false));
        Throwable throwable = null;
        try (TXHandle h1 = TX.required();){
            long currUserId = RequestContext.get().getCurrUserId();
            Date curTime = new Date();
            assignInfo.forEach((k, v) -> {
                if (!bizRoleIds.contains(k)) {
                    DynamicObject newDObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userbizrole");
                    newDObj.set("user", (Object)userId);
                    newDObj.set("bizrole", k);
                    Object[] bizTimeObj = new Object[3];
                    bizTimeObj[0] = userId;
                    if (v != null && ((Object[])v).length > 0 && v[0] != null) {
                        newDObj.set("starttime", v[0]);
                        bizTimeObj[1] = v[0];
                    }
                    if (v != null && ((Object[])v).length > 1 && v[1] != null) {
                        newDObj.set("endtime", v[1]);
                        bizTimeObj[2] = v[1];
                    }
                    newDObj.set("creator", (Object)currUserId);
                    newDObj.set("createtime", (Object)curTime);
                    newDObj.set("modifier", (Object)currUserId);
                    newDObj.set("modifytime", (Object)curTime);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDObj});
                }
            });
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            h1.markRollback();
            processInfo.append(ResManager.loadKDString((String)"\u7528\u6237\u7ed1\u5b9a\u4e1a\u52a1\u89d2\u8272\u5931\u8d25", (String)"BizRoleService_29", (String)SYS_TYPE, (Object[])new Object[0]));
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public static boolean userUnBundleBizRole(Long userId, Set<Long> bizRoleIds, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (userId == null) {
            processInfo.append(BizRoleService.getMessage1());
            return false;
        }
        if (bizRoleIds == null || bizRoleIds.isEmpty()) {
            processInfo.append(ResManager.loadKDString((String)"\u89d2\u8272\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_30", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        List<Long> existBizRoleIds = BizRoleService.getBizRolesByUserID(userId);
        Throwable throwable = null;
        try (TXHandle h1 = TX.required();){
            bizRoleIds.stream().forEach(x -> {
                if (existBizRoleIds.contains(x)) {
                    DeleteServiceHelper.delete((String)"perm_userbizrole", (QFilter[])new QFilter[]{new QFilter("user.id", "=", (Object)userId).and(new QFilter("bizrole.id", "=", x))});
                }
            });
            UserHasPermOrgCache.clearUserLoginOrgs(userId);
            UserHasPermDimObjCache.removeCache(userId);
            if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
                try {
                    ArrayList<Long> userIds = new ArrayList<Long>(10);
                    userIds.add(userId);
                    FormConfigFactory.cancelShowFormRights(userIds);
                }
                catch (Exception ex) {
                    logger.warn("[clearDynamicCache]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Throwable)ex);
                }
            }
            boolean ex = true;
            return ex;
        }
        catch (Exception e) {
            h1.markRollback();
            processInfo.append(ResManager.loadKDString((String)"\u7528\u6237\u89e3\u9664\u4e1a\u52a1\u89d2\u8272\u5931\u8d25", (String)"BizRoleService_31", (String)SYS_TYPE, (Object[])new Object[0]));
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public static boolean bizRoleBundleUser(Long bizRoleId, Map<Long, Object[]> assignInfo, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (bizRoleId == null) {
            processInfo.append(BizRoleService.getMessage4());
            return false;
        }
        if (assignInfo == null || assignInfo.isEmpty()) {
            processInfo.append(ResManager.loadKDString((String)"\u89d2\u8272\u7ed1\u5b9a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_28", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        List<Long> existUserIds = BizRoleService.getUsersByBizRoleID(bizRoleId);
        ArrayList insertUserList = new ArrayList(16);
        ArrayList<Long> insertUserIdList = new ArrayList<Long>(16);
        ArrayList forInsertObjs = new ArrayList(16);
        assignInfo.forEach((k, v) -> {
            if (!existUserIds.contains(k)) {
                DynamicObject newDObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_userbizrole");
                newDObj.set("user", k);
                newDObj.set("bizrole", (Object)bizRoleId);
                Object[] userIdTime = new Object[3];
                userIdTime[0] = k;
                if (v != null && ((Object[])v).length > 0 && v[0] != null) {
                    newDObj.set("starttime", v[0]);
                    userIdTime[1] = v[0];
                }
                if (v != null && ((Object[])v).length > 1 && v[1] != null) {
                    newDObj.set("endtime", v[1]);
                    userIdTime[2] = v[1];
                }
                forInsertObjs.add(newDObj);
                insertUserIdList.add((Long)k);
                insertUserList.add(userIdTime);
            }
        });
        Throwable throwable = null;
        try (TXHandle h1 = TX.required();){
            SaveServiceHelper.save((DynamicObject[])forInsertObjs.toArray(new DynamicObject[forInsertObjs.size()]));
            UserHasPermOrgCache.clearUserLoginOrgs(insertUserIdList);
            UserHasPermDimObjCache.removeAllCache();
            if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
                try {
                    FormConfigFactory.cancelShowFormRights(insertUserIdList);
                    FormConfigFactory.cancelShowFormDataRights(insertUserIdList);
                }
                catch (Exception ex) {
                    logger.warn("[clearDynamicCache]\u6e05\u9664\u9886\u57df\u7f13\u5b58", (Throwable)ex);
                }
            }
            boolean ex = true;
            return ex;
        }
        catch (Exception e) {
            h1.markRollback();
            processInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u7ed1\u5b9a\u7528\u6237\u5931\u8d25", (String)"BizRoleService_32", (String)SYS_TYPE, (Object[])new Object[0]));
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public static boolean bizRoleUnBundleUser(Long bizRoleId, Set<Long> userIds, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (bizRoleId == null) {
            processInfo.append(BizRoleService.getMessage4());
            return false;
        }
        if (userIds == null || userIds.isEmpty()) {
            processInfo.append(ResManager.loadKDString((String)"\u7528\u6237ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_33", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        List<Long> existUserIds = BizRoleService.getUsersByBizRoleID(bizRoleId);
        List<Long> deleteUserList = userIds.stream().filter(userId -> existUserIds.contains(userId)).collect(Collectors.toList());
        Throwable throwable = null;
        try (TXHandle h1 = TX.required();){
            deleteUserList.stream().forEach(x -> DeleteServiceHelper.delete((String)"perm_userbizrole", (QFilter[])new QFilter[]{new QFilter("user.id", "=", x).and(new QFilter("bizrole.id", "=", (Object)bizRoleId))}));
            UserHasPermOrgCache.clearUserLoginOrgs(deleteUserList);
            UserHasPermDimObjCache.removeAllCache();
            if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
                try {
                    FormConfigFactory.cancelShowFormRights(deleteUserList);
                    FormConfigFactory.cancelShowFormDataRights(deleteUserList);
                }
                catch (Exception ex) {
                    logger.warn("[clearDynamicCache]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Throwable)ex);
                }
            }
            boolean ex = true;
            return ex;
        }
        catch (Exception e) {
            h1.markRollback();
            processInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u89e3\u9664\u7528\u6237\u7ed1\u5b9a\u5931\u8d25", (String)"BizRoleService_34", (String)SYS_TYPE, (Object[])new Object[0]));
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public static boolean clearBizRoleUserBundingByBizRoleId(Long bizRoleId, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (bizRoleId == null) {
            processInfo.append(BizRoleService.getMessage4());
            return false;
        }
        List<Long> existUserIds = BizRoleService.getUsersByBizRoleID(bizRoleId);
        Throwable throwable = null;
        try (TXHandle h1 = TX.required();){
            DeleteServiceHelper.delete((String)"perm_userbizrole", (QFilter[])new QFilter[]{new QFilter("bizrole.id", "=", (Object)bizRoleId)});
            UserHasPermOrgCache.clearUserLoginOrgs(existUserIds);
            UserHasPermDimObjCache.removeAllCache();
            if (PermCommonUtil.isEnableAuthorityChangeNotice()) {
                try {
                    FormConfigFactory.cancelShowFormRights(existUserIds);
                    FormConfigFactory.cancelShowFormDataRights(existUserIds);
                }
                catch (Exception ex) {
                    logger.warn("[clearDynamicCache]\u6e05\u9664\u9886\u57df\u7f13\u5b58\u5f02\u5e38", (Throwable)ex);
                }
            }
            boolean ex = true;
            return ex;
        }
        catch (Exception e) {
            h1.markRollback();
            processInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272\u89e3\u9664\u5bf9\u5e94\u7684\u6240\u6709\u7528\u6237\u7ed1\u5b9a\u5931\u8d25", (String)"BizRoleService_35", (String)SYS_TYPE, (Object[])new Object[0]));
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public static boolean clearBizRoleUserBundingByUserId(Long userId, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (userId == null) {
            processInfo.append(BizRoleService.getMessage1());
            return false;
        }
        Throwable throwable = null;
        try (TXHandle h1 = TX.required();){
            DeleteServiceHelper.delete((String)"perm_userbizrole", (QFilter[])new QFilter[]{new QFilter("user.id", "=", (Object)userId)});
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            h1.markRollback();
            processInfo.append(ResManager.loadKDString((String)"\u7528\u6237\u89e3\u9664\u6240\u6709\u4e1a\u52a1\u89d2\u8272\u7ed1\u5b9a\u5931\u8d25", (String)"BizRoleService_36", (String)SYS_TYPE, (Object[])new Object[0]));
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public static boolean delBizRoleById(Long bizRoleId, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (bizRoleId == null) {
            processInfo.append(BizRoleService.getMessage2());
            return false;
        }
        DynamicObject bizRoleObj = BusinessDataServiceHelper.loadSingle((Object)bizRoleId, (String)"perm_bizrole");
        if (bizRoleObj == null) {
            processInfo.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u4ee5\u5220\u9664\u7684\u4e1a\u52a1\u89d2\u8272", (String)"BizRoleService_37", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        try (TXHandle h1 = TX.required();){
            boolean clearResult = BizRoleService.clearBizRoleUserBundingByBizRoleId(bizRoleId, processInfo);
            if (!clearResult) {
                throw new KDException(new ErrorCode(ERRORCODE_3, BizRoleService.getErrorMessage7()), new Object[]{BizRoleService.getErrorMessage7()});
            }
            OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"delete", (String)"perm_bizrole", (DynamicObject[])new DynamicObject[]{bizRoleObj}, (OperateOption)OperateOption.create());
            if (executeOperate.isSuccess()) {
                processInfo.append(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"BizRoleService_38", (String)SYS_TYPE, (Object[])new Object[0]));
                boolean bl = true;
                return bl;
            }
            try {
                processInfo.append(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"BizRoleService_39", (String)SYS_TYPE, (Object[])new Object[0]));
                BizRoleService.recordErrorMessage(processInfo, executeOperate);
                throw new KDException(new ErrorCode(ERRORCODE_3, BizRoleService.getErrorMessage8()), new Object[]{BizRoleService.getErrorMessage8()});
            }
            catch (Exception e) {
                h1.markRollback();
                processInfo.append(BizRoleService.getErrorMessage8());
                boolean bl = false;
                return bl;
            }
        }
    }

    public static boolean delBizRoleByNum(String number, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (number == null) {
            processInfo.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u89d2\u8272number\u4e0d\u80fd\u4e3a\u7a7a", (String)"BizRoleService_40", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject bizRoleObj = BusinessDataServiceHelper.loadSingle((String)"perm_bizrole", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (bizRoleObj == null) {
            processInfo.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u4ee5\u5220\u9664\u7684\u4e1a\u52a1\u89d2\u8272", (String)"BizRoleService_37", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        if ((bizRoleObj = BusinessDataServiceHelper.loadSingle((Object)bizRoleObj.getPkValue(), (String)"perm_bizrole")) == null) {
            processInfo.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u4ee5\u5220\u9664\u7684\u4e1a\u52a1\u89d2\u8272", (String)"BizRoleService_37", (String)SYS_TYPE, (Object[])new Object[0]));
            return false;
        }
        try (TXHandle h1 = TX.required();){
            boolean clearResult = BizRoleService.clearBizRoleUserBundingByBizRoleId(bizRoleObj.getLong("id"), processInfo);
            if (!clearResult) {
                throw new KDException(new ErrorCode("delBizRoleByNum", BizRoleService.getErrorMessage7()), new Object[]{BizRoleService.getErrorMessage7()});
            }
            OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"delete", (String)"perm_bizrole", (DynamicObject[])new DynamicObject[]{bizRoleObj}, (OperateOption)OperateOption.create());
            if (executeOperate.isSuccess()) {
                processInfo.append(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"BizRoleService_38", (String)SYS_TYPE, (Object[])new Object[0]));
                boolean bl = true;
                return bl;
            }
            try {
                processInfo.append(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"BizRoleService_39", (String)SYS_TYPE, (Object[])new Object[0]));
                BizRoleService.recordErrorMessage(processInfo, executeOperate);
                throw new KDException(new ErrorCode("delBizRoleByNum", BizRoleService.getErrorMessage8()), new Object[]{BizRoleService.getErrorMessage8()});
            }
            catch (Exception e) {
                h1.markRollback();
                processInfo.append(BizRoleService.getErrorMessage8());
                boolean bl = false;
                return bl;
            }
        }
    }
}

