/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import com.google.common.collect.Sets;
import java.sql.Date;
import java.sql.ResultSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class CommRoleFunPermService {
    private static final Log log = LogFactory.getLog(CommRoleFunPermService.class);

    @Deprecated
    public static int cacheCheckPermissionWithOrg(long userId, long orgId, String appId, String entityNum, String permItemId) {
        return CommRoleFunPermService.cacheCheckPermissionWithOrg(userId, orgId, "15", appId, entityNum, permItemId);
    }

    public static int cacheCheckPermissionWithOrg(long userId, long orgId, String orgView, String appId, String entityNum, String permItemId) {
        CharSequence[] keyArr = new String[]{"cacheCheckPermissionWithOrg", userId + "", orgId + "", orgView, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4CommRoleFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = CommRoleFunPermService.checkPermissionWithOrg(userId, orgId, orgView, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4CommRoleFunPermService(), key, hasPermission + "");
        CommRoleFunPermService.resetCacheExpWithOrg(key, hasPermission + "", userId, orgId, entityNum);
        return hasPermission;
    }

    private static int checkPermissionWithOrg(long userId, long orgId, String orgView, String appId, String entityNum, String permItemId) {
        Set roleIdSet;
        Set roleIdSet2;
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getRoleIdSet");
        commParam.put("userId", userId);
        commParam.put("dimTypeList", Collections.singletonList("bos_org"));
        commParam.put("appId", appId);
        commParam.put("entityNum", entityNum);
        commParam.put("permItemId", permItemId);
        commParam.put("dimIdList", Collections.singletonList(orgId));
        commParam.put("orgView", orgView);
        commParam.put("enable", "1");
        commParam.put("selectTSecUserGroupStaff", "1");
        commParam.put("selectTPermRolePermDetail", "1");
        if (StringUtils.isNotEmpty((String)orgView)) {
            commParam.put("selectTOrgStructure", "1");
        }
        commParam.put("selectTPermRole", "1");
        Map<String, Object> curOrgDimCommMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (!CollectionUtils.isEmpty(curOrgDimCommMap) && !CollectionUtils.isEmpty((Collection)(roleIdSet2 = (Set)curOrgDimCommMap.get("roleIdSet")))) {
            return 1;
        }
        List superOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgView, (long)orgId);
        if (CollectionUtils.isEmpty((Collection)superOrgIds)) {
            return 0;
        }
        commParam.put("dimIdList", superOrgIds);
        commParam.put("includeSub", "1");
        commParam.put("orgView", null);
        commParam.put("selectTOrgStructure", null);
        Map<String, Object> superOrgDimCommMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (!CollectionUtils.isEmpty(superOrgDimCommMap) && !CollectionUtils.isEmpty((Collection)(roleIdSet = (Set)superOrgDimCommMap.get("roleIdSet")))) {
            return 1;
        }
        return 0;
    }

    private static void resetCacheExpWithOrg(String cacheKey, String cacheValue, long userId, long orgId, String entityNum) {
        ThreadPools.executeOnceIncludeRequestContext((String)"CommRolePermissionService_cacheCheckPermissionWithOrg", () -> {
            List<Long> dimIdList = Collections.singletonList(orgId);
            java.util.Date minStartDate = UserHelper.getCommRoleMinStartTimeByUserId(userId, "bos_org", dimIdList, null);
            java.util.Date minEndDate = UserHelper.getCommRoleMinEndTimeByUserId(userId, "bos_org", dimIdList, null);
            String orgFunction = PermCommonUtil.getPermOrgFuncId(entityNum);
            List superOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgFunction, (long)orgId);
            java.util.Date minSupStartDate = null;
            java.util.Date minSupEndDate = null;
            if (superOrgIds != null && !superOrgIds.isEmpty()) {
                minSupStartDate = UserHelper.getCommRoleMinStartTimeByUserId(userId, "bos_org", superOrgIds, "1");
                minSupEndDate = UserHelper.getCommRoleMinEndTimeByUserId(userId, "bos_org", superOrgIds, "1");
            }
            List<java.util.Date> dateList = Arrays.asList(minStartDate, minEndDate, minSupStartDate, minSupEndDate);
            Optional<java.util.Date> minDate = dateList.stream().filter(x -> x != null).min((o1, o2) -> o1.compareTo((java.util.Date)o2));
            minDate.ifPresent(d -> {
                Long expLongTime = d.getTime() - Instant.now().toEpochMilli();
                Integer expInt = (expLongTime = Long.valueOf(expLongTime / 1000L)).intValue();
                if (expInt <= 0) {
                    CacheMrg.putCache(CacheMrg.getType4CommRoleFunPermService(), cacheKey, cacheValue, 1);
                } else if (expInt > 0 && expInt < CacheMrg.getExpireTime()) {
                    CacheMrg.putCache(CacheMrg.getType4CommRoleFunPermService(), cacheKey, cacheValue, expInt);
                }
            });
        });
    }

    public static int cacheCheckPermissionWithOutOrg(long userId, String appId, String entityNum, String permItemId) {
        CharSequence[] keyarr = new String[]{"cacheCheckPermissionWithOutOrg", userId + "", appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyarr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4CommRoleFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = CommRoleFunPermService.checkPermissionWithOutOrg(userId, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4CommRoleFunPermService(), key, hasPermission + "");
        CommRoleFunPermService.resetCacheExpWithOutOrg(key, hasPermission + "", userId, entityNum);
        return hasPermission;
    }

    private static int checkPermissionWithOutOrg(long userId, String appId, String entityNum, String permItemId) {
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getRoleIdSet");
        commParam.put("userId", userId);
        commParam.put("dimTypeList", new ArrayList(1));
        commParam.put("dimIdList", new ArrayList(1));
        commParam.put("appId", appId);
        commParam.put("entityNum", entityNum);
        commParam.put("permItemId", permItemId);
        commParam.put("enable", "1");
        commParam.put("selectTSecUserGroupStaff", "1");
        commParam.put("selectTPermRolePermDetail", "1");
        commParam.put("selectTPermRole", "1");
        Map<String, Object> commMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (CollectionUtils.isEmpty(commMap)) {
            return 0;
        }
        Set roleIdSet = (Set)commMap.get("roleIdSet");
        if (CollectionUtils.isEmpty((Collection)roleIdSet)) {
            return 0;
        }
        return 1;
    }

    private static void resetCacheExpWithOutOrg(String cacheKey, String cacheValue, long userId, String entityNum) {
        ThreadPools.executeOnceIncludeRequestContext((String)"CommRolePermissionService_cacheCheckPermissionWithOutOrg", () -> {
            java.util.Date minStartDate = UserHelper.getCommRoleMinStartTimeByUserId(userId, null, null, null);
            java.util.Date minEndDate = UserHelper.getCommRoleMinEndTimeByUserId(userId, null, null, null);
            List<java.util.Date> dateList = Arrays.asList(minStartDate, minEndDate);
            Optional<java.util.Date> minDate = dateList.stream().filter(x -> x != null).min((o1, o2) -> o1.compareTo((java.util.Date)o2));
            minDate.ifPresent(d -> {
                Long expLongTime = d.getTime() - Instant.now().toEpochMilli();
                Integer expInt = (expLongTime = Long.valueOf(expLongTime / 1000L)).intValue();
                if (expInt <= 0) {
                    CacheMrg.putCache(CacheMrg.getType4CommRoleFunPermService(), cacheKey, cacheValue, 1);
                } else if (expInt > 0 && expInt < CacheMrg.getExpireTime()) {
                    CacheMrg.putCache(CacheMrg.getType4CommRoleFunPermService(), cacheKey, cacheValue, expInt);
                }
            });
        });
    }

    public static int cacheCheckPermissionWithDim(long userId, long dimId, String dimType, String appId, String entityNum, String permItemId) {
        CharSequence[] keyArr = new String[]{"cacheCheckPermissionWithDim", userId + "", dimId + "", dimType, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4CommRoleFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = CommRoleFunPermService.checkPermissionWithDim(userId, dimId, dimType, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4CommRoleFunPermService(), key, hasPermission + "");
        CommRoleFunPermService.resetCacheExpWithDim(key, hasPermission + "", userId, dimId, dimType);
        return hasPermission;
    }

    private static int checkPermissionWithDim(long userId, long dimId, String dimType, String appId, String entityNum, String permItemId) {
        Set roleIdSet;
        dimType = PermCommonUtil.getSuitableDimType(dimType)[1];
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getRoleIdSet");
        commParam.put("userId", userId);
        commParam.put("dimTypeList", Collections.singletonList(dimType));
        commParam.put("appId", appId);
        commParam.put("entityNum", entityNum);
        commParam.put("permItemId", permItemId);
        commParam.put("dimIdList", Collections.singletonList(dimId));
        commParam.put("enable", "1");
        commParam.put("selectTSecUserGroupStaff", "1");
        commParam.put("selectTPermRolePermDetail", "1");
        commParam.put("selectTPermRole", "1");
        Map<String, Object> curOrgDimCommMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (!CollectionUtils.isEmpty(curOrgDimCommMap) && !CollectionUtils.isEmpty((Collection)(roleIdSet = (Set)curOrgDimCommMap.get("roleIdSet")))) {
            return 1;
        }
        return 0;
    }

    private static void resetCacheExpWithDim(String cacheKey, String cacheValue, long userId, long dimId, String dimType) {
        String realDimType = PermCommonUtil.getSuitableDimType(dimType)[1];
        ThreadPools.executeOnceIncludeRequestContext((String)"CommRolePermissionService_cacheCheckPermissionWithDim", () -> {
            String sql = "SELECT MIN(UR.FSTARTTIME) MIN_STARTTIME FROM T_PERM_ROLE R INNER JOIN T_PERM_USERROLE UR ON R.FID=UR.FROLEID WHERE UR.FUSERID=? AND UR.FORGID= ? AND UR.FDIMTYPE = ? AND R.FENABLE = '1' AND  NOW() < UR.FSTARTTIME";
            Object[] params = new Object[]{userId, dimId, realDimType};
            java.util.Date minStartDate = (java.util.Date)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<java.util.Date>(){

                public java.util.Date handle(ResultSet rs) throws Exception {
                    Date minStartTime = null;
                    while (rs.next()) {
                        minStartTime = rs.getDate("MIN_STARTTIME");
                    }
                    return minStartTime;
                }
            });
            String minEndTimeSql = "SELECT MIN(UR.FENDTIME) MIN_ENDTIME FROM T_PERM_ROLE R INNER JOIN T_PERM_USERROLE UR ON R.FID=UR.FROLEID WHERE UR.FUSERID=? AND UR.FORGID= ? AND UR.FDIMTYPE = ? AND R.FENABLE = '1' AND  NOW() < UR.FENDTIME";
            java.util.Date minEndDate = (java.util.Date)DB.query((DBRoute)DBRoute.permission, (String)minEndTimeSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<java.util.Date>(){

                public java.util.Date handle(ResultSet rs) throws Exception {
                    Date minEndDate = null;
                    while (rs.next()) {
                        minEndDate = rs.getDate("MIN_ENDTIME");
                    }
                    return minEndDate;
                }
            });
            List<java.util.Date> dateList = Arrays.asList(minStartDate, minEndDate);
            Optional<java.util.Date> minDate = dateList.stream().filter(x -> x != null).min((o1, o2) -> o1.compareTo((java.util.Date)o2));
            minDate.ifPresent(d -> {
                Long expLongTime = d.getTime() - Instant.now().toEpochMilli();
                Integer expInt = (expLongTime = Long.valueOf(expLongTime / 1000L)).intValue();
                if (expInt <= 0) {
                    CacheMrg.putCache(CacheMrg.getType4CommRoleFunPermService(), cacheKey, cacheValue, 1);
                } else if (expInt > 0 && expInt < CacheMrg.getExpireTime()) {
                    CacheMrg.putCache(CacheMrg.getType4CommRoleFunPermService(), cacheKey, cacheValue, expInt);
                }
            });
        });
    }

    public static Set<String> hasPermMenuList(Long userId, List<Object[]> menuAppEntityPermList) {
        if (menuAppEntityPermList == null || menuAppEntityPermList.isEmpty()) {
            return new HashSet<String>(16);
        }
        Set<String> comRoleIdSet = UserHelper.getJustCommRoleIdSetByUserId(userId);
        if (comRoleIdSet == null || comRoleIdSet.isEmpty()) {
            return new HashSet<String>(1);
        }
        StringBuilder comRoleStr = new StringBuilder("(");
        for (String comRoleId : comRoleIdSet) {
            comRoleStr.append("'").append(comRoleId).append("',");
        }
        comRoleStr.deleteCharAt(comRoleStr.length() - 1).append(')');
        StringBuilder sqlSB = new StringBuilder().append("select CONCAT(CONCAT(fbizappid,fentitytypeid),fpermitemid) as result").append(" from t_perm_rolepermdetial ").append(" where froleid in ").append((CharSequence)comRoleStr);
        Set appEntityPermSet = (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> appEntityPermSet = new HashSet<String>(8);
                while (rs.next()) {
                    String result = rs.getString("result");
                    appEntityPermSet.add(result);
                }
                return appEntityPermSet;
            }
        });
        HashSet<String> menuIdSet = new HashSet<String>();
        if (!appEntityPermSet.isEmpty()) {
            for (Object[] objects : menuAppEntityPermList) {
                String app = String.valueOf(objects[1]);
                String entity = String.valueOf(objects[2]);
                String permItem = String.valueOf(objects[3]);
                if (!appEntityPermSet.contains(app + entity + permItem)) continue;
                menuIdSet.add(String.valueOf(objects[0]));
            }
        }
        return menuIdSet;
    }

    public static Set<String> getUserAppEntPermItemStrSet(Long userId) {
        if (null == userId || 0L == userId) {
            return Collections.EMPTY_SET;
        }
        Set<String> comRoleIdSet = UserHelper.getJustCommRoleIdSetByUserId(userId);
        if (comRoleIdSet == null || comRoleIdSet.isEmpty()) {
            return new HashSet<String>(1);
        }
        StringBuilder comRoleStr = new StringBuilder("(");
        for (String comRoleId : comRoleIdSet) {
            comRoleStr.append("'").append(comRoleId).append("',");
        }
        comRoleStr.deleteCharAt(comRoleStr.length() - 1).append(')');
        StringBuilder sqlSB = new StringBuilder().append("select CONCAT(CONCAT(fbizappid,fentitytypeid),fpermitemid) as result").append(" from t_perm_rolepermdetial ").append(" where froleid in ").append((CharSequence)comRoleStr);
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> appEntityPermSet = new HashSet<String>(8);
                while (rs.next()) {
                    String result = rs.getString("result");
                    appEntityPermSet.add(result);
                }
                return appEntityPermSet;
            }
        });
    }

    @Deprecated
    private static Set<String> getCommonRoleIDsByUserId(Long userId) {
        return UserHelper.getJustCommRoleIdSetByUserId(userId);
    }

    public static Map<Long, String> cacheGetHasPermDimObj(long userId, String dimType, String appId, String entityNum, String permItemId) {
        Map<Long, String> commonRoleHasPermOrgs = new HashMap<Long, String>(16);
        List<String> orgInfos = new ArrayList(10);
        CharSequence[] keyArr = new String[]{"cacheGetHasPermDimObj", userId + "", dimType, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4CommRoleFunPermService(), key);
        if (cacheValue != null) {
            orgInfos = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            if (orgInfos != null) {
                for (String orgInfo : orgInfos) {
                    String[] arr = orgInfo.split("_");
                    commonRoleHasPermOrgs.put(Long.valueOf(arr[0]), arr[1]);
                }
            }
            return commonRoleHasPermOrgs;
        }
        HashMap<String, Object> commParam = new HashMap<String, Object>(2);
        commParam.put("userId", userId);
        commParam.put("dimTypeSet", Sets.newHashSet((Object[])new String[]{dimType}));
        commParam.put("appId", appId);
        commParam.put("entityNum", entityNum);
        commParam.put("permItemId", permItemId);
        commParam.put("enable", "1");
        commParam.put("enableValidateTime", PermCommonUtil.isEnableValidateTime());
        commParam.put("needQueryRpd", true);
        commonRoleHasPermOrgs = PermRoleHelper.getGetHasPermDimObj(commParam);
        if (null == commonRoleHasPermOrgs || commonRoleHasPermOrgs.isEmpty()) {
            return commonRoleHasPermOrgs;
        }
        for (Map.Entry<Long, String> entry : commonRoleHasPermOrgs.entrySet()) {
            orgInfos.add(entry.getKey() + "_" + entry.getValue());
        }
        String hasPermission = SerializationUtils.toJsonString(orgInfos);
        CacheMrg.putCache(CacheMrg.getType4CommRoleFunPermService(), key, hasPermission);
        CommRoleFunPermService.resetCacheExpWithOutOrg(key, hasPermission, userId, entityNum);
        return commonRoleHasPermOrgs;
    }
}

