/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.DataRule;
import kd.bos.permission.api.DataRuleResult;
import kd.bos.permission.api.DataRuleSingleResult;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.DataRuleCache;
import kd.bos.permission.cache.UserBizRoleCache;
import kd.bos.permission.cache.UserRoleCache;
import kd.bos.permission.cache.model.PermBizRoleOrg;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class DataPermissionCache {
    private static Log logger = LogFactory.getLog(DataPermissionCache.class);
    private static final String PROP_RULE = "rule";
    private static final String SYSTEM_TYPE = "bos-permission-cache";

    private static String buildKey(String objectId, String objectType, Long orgId) {
        return String.format("%s_%s_%s", objectId, objectType, orgId);
    }

    private static String buildKeyWithOrg(Long userId, String appId, String entityNum) {
        return String.format("dataPermWithOrg_%s_%s_%s", userId, appId, entityNum);
    }

    private static String buildKeyWithoutOrg(Long userId, String appId, String entityNum, List<Long> orgIds) {
        if (orgIds == null || orgIds.size() == 0) {
            return DataPermissionCache.buildKeyWithoutOrg(userId, appId, entityNum);
        }
        return String.format("dataPermWithoutOrg_%s_%s_%s_%s", userId, appId, entityNum, Arrays.toString(orgIds.toArray()));
    }

    private static String buildKeyWithoutOrg(Long userId, String appId, String entityNum) {
        return String.format("dataPermWithoutOrg_%s_%s_%s", userId, appId, entityNum);
    }

    public static List<DataRule> getDataRule(String objectId, String objectType, Long orgId, String appId, String entityNum) {
        String type = CacheMrg.getType4DataPermObj();
        String key = DataPermissionCache.buildKey(objectId, objectType, orgId);
        List<String> dataPermIdList = null;
        String value = CacheMrg.getCache(type, key);
        if (CacheMrg.isLoaded(value)) {
            if (CacheMrg.isData(value)) {
                dataPermIdList = PermCommonUtil.str2List(value);
            }
        } else {
            dataPermIdList = DataPermissionCache.loadCache(type, key, objectId, objectType, orgId);
        }
        List<DataRule> ruleList = null;
        if (dataPermIdList != null) {
            ruleList = DataPermissionCache.loadDataPermCache(dataPermIdList, appId, entityNum);
        }
        if (ruleList == null || ruleList.size() == 0) {
            return new ArrayList<DataRule>();
        }
        return ruleList;
    }

    private static List<String> loadCache(String type, String key, String objectId, String objectType, Long orgId) {
        String sql = null;
        Object[] params = null;
        if (objectType.equals("0")) {
            sql = "select distinct t1.FDATAPERMID from T_PERM_USERDATAPERM t1 inner join T_PERM_DATAPERM t2 on t1.FDATAPERMID = t2.FID where t1.FUSERID = ? and t1.FORGID = ? ";
            params = new SqlParameter[]{new SqlParameter(":FUSERID", -5, (Object)Long.parseLong(objectId)), new SqlParameter(":FORGID", -5, (Object)orgId)};
        } else {
            sql = "select distinct t1.FDATAPERMID from T_PERM_ROLEDATAPERM t1 inner join T_PERM_DATAPERM t2 on t1.FDATAPERMID = t2.FID where t1.FROLEID = ?  ";
            params = new SqlParameter[]{new SqlParameter(":FROLEID", 12, (Object)objectId)};
        }
        List dataPermIdList = (List)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> retList = new ArrayList<String>();
                if (rs.next()) {
                    retList.add(rs.getString("FDATAPERMID"));
                }
                return retList;
            }
        });
        if (dataPermIdList != null && dataPermIdList.size() > 0) {
            CacheMrg.putCache(type, key, PermCommonUtil.list2Str(dataPermIdList));
        } else {
            CacheMrg.loaded(type, key);
        }
        return dataPermIdList;
    }

    private static List<DataRule> loadDataPermCache(List<String> dataPermIdList, String appId, String entityNum) {
        ArrayList<DataRule> ruleList = new ArrayList<DataRule>();
        for (String dataPermId : dataPermIdList) {
            String key;
            DataRule dataRule = null;
            String type = CacheMrg.getType4DataPerm();
            String value = CacheMrg.getCache(type, key = dataPermId + "_" + appId + "_" + entityNum);
            if (CacheMrg.isLoaded(value)) {
                if (CacheMrg.isData(value)) {
                    dataRule = new DataRule();
                    dataRule.setId(dataPermId);
                    dataRule.setFilterConditionJson(value);
                }
            } else {
                dataRule = DataPermissionCache.reLoadDataPermCache(dataPermId, appId, entityNum);
            }
            if (dataRule == null) continue;
            ruleList.add(dataRule);
        }
        return ruleList;
    }

    private static DataRule reLoadDataPermCache(String dataPermId, String appId, String entityNum) {
        String type = CacheMrg.getType4DataPerm();
        StringBuilder sbSql = new StringBuilder().append("select t1.FRULE from T_PERM_DATAPERMENTRY t1 ").append(" where t1.FID = ? and t1.FENTITYTYPEID = ? ").append(" and t1.FBIZAPPID = ? ");
        String sql = sbSql.toString();
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)dataPermId), new SqlParameter(":FENTITYTYPEID", 12, (Object)entityNum), new SqlParameter(":FBIZAPPID", 12, (Object)appId)};
        String ruleJson = (String)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String result = null;
                if (rs.next()) {
                    result = rs.getString("FRULE");
                }
                return result;
            }
        });
        DataRule dataRule = null;
        String key = dataPermId + "_" + appId + "_" + entityNum;
        if (StringUtils.isNotEmpty((String)ruleJson)) {
            dataRule = new DataRule();
            dataRule.setId(dataPermId);
            dataRule.setFilterConditionJson(ruleJson);
            CacheMrg.putCache(type, key, ruleJson);
        } else {
            CacheMrg.loaded(type, key);
        }
        return dataRule;
    }

    public static void removeUserRoleCache(String objectId, String objectType, Long orgId) {
        String type = CacheMrg.getType4DataPermObj();
        String key = DataPermissionCache.buildKey(objectId, objectType, orgId);
        CacheMrg.clearCache(type, key);
    }

    public static void removeDataPermCache(String dataPermId) {
        String type = CacheMrg.getType4DataPerm();
        CacheMrg.clearCacheByPrekey(type, dataPermId + "_");
    }

    @SdkInternal
    public static void removeAllCache() {
        CacheMrg.clearCache(CacheMrg.getType4DataPermObj());
        CacheMrg.clearCache(CacheMrg.getType4DataPerm());
        CacheMrg.clearCache(CacheMrg.getType4DataRuleObj());
        CacheMrg.clearCache(CacheMrg.getType4DataRule());
        CacheMrg.clearCache(CacheMrg.getType4CustomDataRule());
    }

    private static DataRuleResult loadDataPermWithOrgs(long pUserId, String pAppId, String pEntityNum) {
        String ruleJson;
        String roleId;
        DataRuleResult drr = new DataRuleResult();
        String dimTypeNum = PermCommonUtil.getDimTypeNumByEntityNum(pEntityNum);
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimTypeNum);
        ArrayList<String> dimTypes = new ArrayList<String>();
        dimTypes.add(suitableDimType[0]);
        dimTypes.add(suitableDimType[1]);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)pEntityNum);
        String checkPermOrgKey = PermCommonUtil.getCheckPermOrg(dataEntityType);
        if (StringUtils.isEmpty((String)checkPermOrgKey)) {
            drr.setNeedDimCtrl(false);
        }
        HashMap<String, Set<Long>> roleOrgMap = new HashMap<String, Set<Long>>();
        HashSet<String> forQueryRoleIds = new HashSet<String>();
        HashMap<Long, Boolean> userRoleInculueSubMap = new HashMap<Long, Boolean>();
        DataPermissionCache.getCurUserRoleByCommRole(pUserId, dimTypes, roleOrgMap, forQueryRoleIds, userRoleInculueSubMap);
        DataPermissionCache.getCurUserRoleByBizRole(pUserId, suitableDimType, roleOrgMap, forQueryRoleIds, userRoleInculueSubMap);
        DynamicObjectCollection userDataPermDoc = DataPermissionCache.loadUserDataPermWithDimObj(pUserId, pAppId, pEntityNum, drr);
        if (CollectionUtils.isEmpty((Collection)userDataPermDoc) && CollectionUtils.isEmpty(forQueryRoleIds)) {
            return null;
        }
        if (CollectionUtils.isEmpty(forQueryRoleIds)) {
            return drr;
        }
        DynamicObjectCollection roleDataPermDoc = DataPermissionCache.getCurUserRoleDataPerm(pAppId, pEntityNum, forQueryRoleIds);
        if (null == roleDataPermDoc || roleDataPermDoc.isEmpty()) {
            return drr;
        }
        HashMap<String, String> roleRuleMap = new HashMap<String, String>();
        for (DynamicObject dObj : roleDataPermDoc) {
            roleId = dObj.getString("role");
            ruleJson = dObj.getString(PROP_RULE);
            roleRuleMap.put(roleId, ruleJson);
        }
        for (Map.Entry entry : roleOrgMap.entrySet()) {
            roleId = (String)entry.getKey();
            ruleJson = (String)roleRuleMap.get(roleId);
            if (StringUtils.isEmpty((String)ruleJson)) continue;
            DataRuleSingleResult drsr = new DataRuleSingleResult();
            drsr.setFilterJson(ruleJson);
            HashMap<Long, Boolean> dimObjIncludeSubInfo = new HashMap<Long, Boolean>();
            Set dimObjIdsSet = (Set)entry.getValue();
            for (Long dimObjId : dimObjIdsSet) {
                Boolean includeSub = (Boolean)userRoleInculueSubMap.get(dimObjId);
                if (includeSub == null) {
                    dimObjIncludeSubInfo.put(dimObjId, Boolean.FALSE);
                    continue;
                }
                dimObjIncludeSubInfo.put(dimObjId, includeSub);
            }
            drsr.setDimObjIncludeSubInfo(dimObjIncludeSubInfo);
            drr.getSingleResultList().add(drsr);
        }
        return drr;
    }

    private static DynamicObjectCollection getCurUserRoleDataPerm(String pAppId, String pEntityNum, Set<String> forQueryRoleIds) {
        StringBuilder selectedFields = new StringBuilder("id").append(",").append("role").append(",").append("datapermid.entitytypelist.rule").append(" rule");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("datapermid.entitytypelist.entitytype", "=", (Object)pEntityNum));
        filterList.add(new QFilter("role", "in", forQueryRoleIds));
        if (StringUtils.isNotEmpty((String)pAppId)) {
            filterList.add(new QFilter("datapermid.entitytypelist.bizapp", "=", (Object)pAppId));
        }
        return QueryServiceHelper.query((String)"perm_roledataperm", (String)selectedFields.toString(), (QFilter[])filterList.toArray(new QFilter[0]));
    }

    private static void getCurUserRoleByCommRole(long pUserId, List<String> dimTypes, Map<String, Set<Long>> roleOrgMap, Set<String> forQueryRoleIds, Map<Long, Boolean> userRoleInculueSubMap) {
        StringBuilder selectedFields = new StringBuilder("id").append(",").append("org").append(",").append("role").append(",").append("includesuborg");
        DynamicObjectCollection roleDoc = QueryServiceHelper.query((String)"perm_userrole", (String)selectedFields.toString(), (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)pUserId), new QFilter("dimtype", "in", dimTypes), new QFilter("role.enable", "=", (Object)"1")});
        DynamicObject[] col = BusinessDataServiceHelper.load((String)"bos_usergroupstaff", (String)"usergroup", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)pUserId)});
        ArrayList<Long> usrGrpList = new ArrayList<Long>(col.length);
        for (DynamicObject dynamicObject : col) {
            DynamicObject userGroup = dynamicObject.getDynamicObject("usergroup");
            if (userGroup == null) continue;
            usrGrpList.add(userGroup.getLong("id"));
        }
        if (!usrGrpList.isEmpty()) {
            DynamicObjectCollection usrGrpRoleDoc = QueryServiceHelper.query((String)"perm_usrgrprole", (String)"dimid org,role,includesub includesuborg", (QFilter[])new QFilter[]{new QFilter("usrgrpid", "in", usrGrpList), new QFilter("dimtype", "in", dimTypes), new QFilter("role.enable", "=", (Object)"1")});
            roleDoc.addAll((Collection)usrGrpRoleDoc);
        }
        for (DynamicObject roleDObj : roleDoc) {
            Long orgId = roleDObj.getLong("org");
            String roleId = roleDObj.getString("role");
            boolean includeSub = roleDObj.getBoolean("includesuborg");
            Boolean preIncludeSub = userRoleInculueSubMap.get(orgId);
            if (null == preIncludeSub) {
                userRoleInculueSubMap.put(orgId, includeSub);
            } else if (Boolean.FALSE.equals(preIncludeSub)) {
                userRoleInculueSubMap.put(orgId, includeSub);
            }
            forQueryRoleIds.add(roleId);
            roleOrgMap.computeIfAbsent(roleId, k -> new HashSet()).add(orgId);
        }
    }

    private static void getCurUserRoleByBizRole(long pUserId, final String[] suitableDimType, final Map<String, Set<Long>> roleOrgMap, final Set<String> forQueryRoleIds, final Map<Long, Boolean> userRoleInculueSubMap) {
        final HashMap busiRoleMap = new HashMap(640);
        final HashSet busiRoleIdSet = new HashSet(640);
        StringBuilder sql_1 = new StringBuilder().append("select a.fid, a.forgid, a.fisincludesuborg, a.fdimtype from t_perm_bizroleorg a ").append(" inner join t_perm_userbizrole b on a.fid = b.fbizroleid ").append(" where b.fuserid = ? ");
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        if (enableValidateTime) {
            sql_1.append(" AND ( NOW() BETWEEN b.fstarttime AND b.fendtime OR (b.fstarttime IS NULL AND b.fendtime IS NULL)").append(" OR ( now() >= b.fstarttime AND b.fendtime IS NULL) OR (b.fstarttime IS NULL AND now() <=  b.fendtime )").append(')');
        }
        Object[] params_1 = new Object[]{pUserId};
        DB.query((DBRoute)DBRoute.permission, (String)sql_1.toString(), (Object[])params_1, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String dimtype = rs.getString("fdimtype");
                    if (StringUtils.isEmpty((String)dimtype) || !suitableDimType[0].equals(dimtype) && !suitableDimType[1].equals(dimtype)) continue;
                    Long busiRoleId = rs.getLong("fid");
                    Long orgId = rs.getLong("forgid");
                    boolean includeSub = rs.getBoolean("fisincludesuborg");
                    PermBizRoleOrg permBizRoleOrg = new PermBizRoleOrg(busiRoleId, orgId, includeSub, dimtype);
                    busiRoleMap.computeIfAbsent(busiRoleId, k -> new LinkedList()).add(permBizRoleOrg);
                    busiRoleIdSet.add(busiRoleId);
                }
                return null;
            }
        });
        StringBuilder sql = new StringBuilder("select ugb.fbizroleid,bo.forgid,bo.fisincludesuborg,bo.fdimtype ").append(" from t_sec_usergroupstaff ugs ").append(" join t_perm_usrgrpbizrole ugb on (ugs.fusergroupid=ugb.fusrgrpid) ").append(" join t_perm_bizroleorg bo on (bo.fid = ugb.fbizroleid) ").append(" where ugs.fuserid =? ");
        Object[] params = new Object[]{pUserId};
        DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params, rs -> {
            while (rs.next()) {
                String dimtype = rs.getString("fdimtype");
                if (StringUtils.isEmpty((String)dimtype) || !suitableDimType[0].equals(dimtype) && !suitableDimType[1].equals(dimtype)) continue;
                Long busiRoleId = rs.getLong("fbizroleid");
                Long orgId = rs.getLong("forgid");
                boolean includeSub = rs.getBoolean("fisincludesuborg");
                PermBizRoleOrg permBizRoleOrg = new PermBizRoleOrg(busiRoleId, orgId, includeSub, dimtype);
                busiRoleMap.computeIfAbsent(busiRoleId, k -> new LinkedList()).add(permBizRoleOrg);
                busiRoleIdSet.add(busiRoleId);
            }
            return null;
        });
        if (CollectionUtils.isEmpty(busiRoleMap)) {
            return;
        }
        String busiRoleIds = busiRoleIdSet.stream().map(String::valueOf).collect(Collectors.joining(","));
        StringBuilder sql_2 = new StringBuilder().append("select pbc.fid, pbc.froleid from  t_perm_bizrolecomrole  pbc ").append(" INNER JOIN t_perm_role r ON r.fid=pbc.froleid ").append(" where pbc.fid in(").append(busiRoleIds).append(") AND r.fenable='1' ");
        DB.query((DBRoute)DBRoute.permission, (String)sql_2.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    Long busiRoleId = rs.getLong("fid");
                    List permBizRoleOrgs = (List)busiRoleMap.get(busiRoleId);
                    if (null == permBizRoleOrgs || 0 == permBizRoleOrgs.size()) continue;
                    for (PermBizRoleOrg bizRoleOrg : permBizRoleOrgs) {
                        Long orgId = bizRoleOrg.getOrgId();
                        Boolean includeSub = bizRoleOrg.getIncludeSub();
                        Boolean preIncludeSub = (Boolean)userRoleInculueSubMap.get(orgId);
                        if (null == preIncludeSub) {
                            userRoleInculueSubMap.put(orgId, includeSub);
                        } else if (Boolean.FALSE.equals(preIncludeSub)) {
                            userRoleInculueSubMap.put(orgId, includeSub);
                        }
                        String roleId = rs.getString("froleid");
                        forQueryRoleIds.add(roleId);
                        roleOrgMap.computeIfAbsent(roleId, k -> new HashSet()).add(orgId);
                    }
                }
                return null;
            }
        });
    }

    private static DynamicObjectCollection loadUserDataPermWithDimObj(long pUserId, String pAppId, String pEntityNum, DataRuleResult drr) {
        String dimTypeNum = PermCommonUtil.getDimTypeNumByEntityNum(pEntityNum);
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimTypeNum);
        ArrayList<String> dimTypes = new ArrayList<String>();
        dimTypes.add(suitableDimType[0]);
        dimTypes.add(suitableDimType[1]);
        HashMap<String, Long> userDataPermOrgMap = new HashMap<String, Long>(16);
        StringBuilder selectedFields = new StringBuilder("id").append(",").append("org").append(",").append("dataperm");
        DynamicObjectCollection userDataPermDoc = QueryServiceHelper.query((String)"perm_userdataperm", (String)selectedFields.toString(), (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)pUserId), new QFilter("dimtype", "in", dimTypes)});
        HashSet<String> userDataPermIds = new HashSet<String>();
        HashMap<Long, Boolean> userDataPermIncludeSubInfo = new HashMap<Long, Boolean>();
        if (!CollectionUtils.isEmpty((Collection)userDataPermDoc)) {
            DynamicObjectCollection userPermDoc = QueryServiceHelper.query((String)"perm_userperm", (String)("org" + "," + "includesuborg"), (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)pUserId), new QFilter("dimtype", "in", dimTypes)});
            if (!CollectionUtils.isEmpty((Collection)userPermDoc)) {
                for (DynamicObject dObj : userPermDoc) {
                    Long orgId = dObj.getLong("org");
                    boolean isIncludeSub = dObj.getBoolean("includesuborg");
                    userDataPermIncludeSubInfo.put(orgId, isIncludeSub);
                }
            }
            for (DynamicObject dObj : userDataPermDoc) {
                String dataPermId = dObj.getString("dataperm");
                Long orgId = dObj.getLong("org");
                userDataPermIds.add(dataPermId);
                userDataPermOrgMap.put(dataPermId, orgId);
            }
            if (!userDataPermIds.isEmpty()) {
                DynamicObjectCollection dataPermDoc;
                selectedFields = new StringBuilder("id").append(",").append("entitytypelist.id").append(",").append("entitytypelist.rule").append(" rule");
                ArrayList<QFilter> filterList = new ArrayList<QFilter>();
                filterList.add(new QFilter("entitytypelist.entitytype", "=", (Object)pEntityNum));
                filterList.add(new QFilter("id", "in", userDataPermIds));
                if (StringUtils.isNotEmpty((String)pAppId)) {
                    filterList.add(new QFilter("entitytypelist.bizapp", "=", (Object)pAppId));
                }
                if ((dataPermDoc = QueryServiceHelper.query((String)"perm_dataperm", (String)selectedFields.toString(), (QFilter[])filterList.toArray(new QFilter[0]))) != null && !dataPermDoc.isEmpty()) {
                    for (int i = 0; i < dataPermDoc.size(); ++i) {
                        DynamicObject dObj = (DynamicObject)dataPermDoc.get(i);
                        String ruleJson = dObj.getString(PROP_RULE);
                        String dataPermId = dObj.getString("id");
                        DataRuleSingleResult drsr = new DataRuleSingleResult();
                        drsr.setFilterJson(ruleJson);
                        Long dimObjId = (Long)userDataPermOrgMap.get(dataPermId);
                        Boolean includeSub = (Boolean)userDataPermIncludeSubInfo.get(dimObjId);
                        HashMap<Long, Boolean> dimObjIncludeSubInfo = new HashMap<Long, Boolean>();
                        if (includeSub == null) {
                            dimObjIncludeSubInfo.put(dimObjId, Boolean.FALSE);
                        } else {
                            dimObjIncludeSubInfo.put(dimObjId, includeSub);
                        }
                        drsr.setDimObjIncludeSubInfo(dimObjIncludeSubInfo);
                        drr.getSingleResultList().add(drsr);
                    }
                }
            }
        }
        return userDataPermDoc;
    }

    public static QFilter getDataPermWithOrg(long pUserId, String pAppId, String pEntityNum) {
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        return DataPermissionCache.getDataPermWithOrg(pUserId, pAppId, pEntityNum, customParam);
    }

    public static QFilter getDataPermWithOrg(long pUserId, String pAppId, String pEntityNum, Map<String, Object> customParam) {
        boolean hasEnableOldDataRule = PermCommonUtil.hasEnableOldDataRule();
        if (hasEnableOldDataRule) {
            String type = CacheMrg.getType4DataPermObj();
            String buildKeyWithOrg = DataPermissionCache.buildKeyWithOrg(pUserId, pAppId, pEntityNum);
            QFilter result = null;
            DataRuleResult drr = null;
            String value = CacheMrg.getCache(type, buildKeyWithOrg);
            if (StringUtils.isEmpty((String)value)) {
                drr = DataPermissionCache.loadDataPermWithOrgs(pUserId, pAppId, pEntityNum);
                if (drr == null) {
                    CacheMrg.loaded(type, buildKeyWithOrg);
                    return null;
                }
                CacheMrg.putCache(type, buildKeyWithOrg, SerializationUtils.toJsonString((Object)drr));
            } else {
                if ("PERM_DATA_LOADED".equals(value) || "{}".equals(value)) {
                    return null;
                }
                drr = (DataRuleResult)SerializationUtils.fromJsonString((String)value, DataRuleResult.class);
            }
            boolean isNeedDimCtrlNow = StringUtils.isNotEmpty((String)PermCommonUtil.getCheckPermOrg(pEntityNum));
            if (drr != null && drr.isNeedDimCtrl() != isNeedDimCtrlNow) {
                drr = DataPermissionCache.loadDataPermWithOrgs(pUserId, pAppId, pEntityNum);
                if (drr == null) {
                    CacheMrg.loaded(type, buildKeyWithOrg);
                    return null;
                }
                CacheMrg.putCache(type, buildKeyWithOrg, SerializationUtils.toJsonString((Object)drr));
            }
            result = PermCommonUtil.convertDataRuleResultToQFilter(drr, pUserId, pAppId, pEntityNum);
            boolean hasEnablePropCollapse = PermCommonUtil.hasEnablePropCollapse();
            if (hasEnablePropCollapse && result != null) {
                String filterInfo = String.format(ResManager.loadKDString((String)"\u539f\u59cb\u7684\u6570\u636e\u89c4\u5219\uff08\u65e7\uff09: %1$s [userId:%2$s, appId:%3$s, entityNum:%4$s]", (String)"DataPermissionCache_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), result.toCurrentString(), pUserId, pAppId, pEntityNum);
                logger.info(filterInfo);
                HashMap<String, QFilter> convertRuleRowMap = new HashMap<String, QFilter>();
                result = PermCommonUtil.convertQFilter(pEntityNum, result, convertRuleRowMap);
                String filterInfoAfter = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u540e\u7684\u6570\u636e\u89c4\u5219\uff08\u65e7\uff09: %1$s [userId:%2$s, appId:%3$s, entityNum:%4$s]", (String)"DataPermissionCache_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), result.toCurrentString(), pUserId, pAppId, pEntityNum);
                logger.info(filterInfoAfter);
            }
            return result;
        }
        return DataRuleCache.getDataRule(pUserId, pAppId, pEntityNum, "47150e89000000ac", customParam);
    }

    private static String loadDataPermWithoutOrg(long pUserId, String pAppId, String pEntityNum, List<Long> pOrgIds) {
        DynamicObjectCollection dynamicObjectCollection;
        String ruleJson;
        String dimTypeNum = PermCommonUtil.getDimTypeNumByEntityNum(pEntityNum);
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimTypeNum);
        ArrayList<String> dimTypes = new ArrayList<String>();
        dimTypes.add(suitableDimType[0]);
        dimTypes.add(suitableDimType[1]);
        HashSet<Long> checkRuleOrgIdsInUserPerm = new HashSet<Long>();
        HashSet allSuperiorOrgs = new HashSet();
        String permOrgFuncId = "";
        boolean hasLoadAllSuperOrg = false;
        if (!CollectionUtils.isEmpty(pOrgIds)) {
            HashSet<Long> orgIncludeSubSet = new HashSet<Long>();
            DynamicObjectCollection userDataPermDoc = QueryServiceHelper.query((String)"perm_userdataperm", (String)"org", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)pUserId), new QFilter("dimtype", "in", dimTypes)});
            if (!CollectionUtils.isEmpty((Collection)userDataPermDoc)) {
                ArrayList<Long> orgIdsInUserDataPerm = new ArrayList<Long>();
                for (DynamicObject userDataPermRow : userDataPermDoc) {
                    long orgId = userDataPermRow.getLong("org");
                    orgIdsInUserDataPerm.add(orgId);
                }
                DynamicObjectCollection userPermDoc = QueryServiceHelper.query((String)"perm_userperm", (String)("org" + "," + "includesuborg"), (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)pUserId), new QFilter("dimtype", "in", dimTypes), new QFilter("org", "in", orgIdsInUserDataPerm)});
                if (!CollectionUtils.isEmpty((Collection)userPermDoc)) {
                    boolean ifFoundOrgIdInUserPerm = false;
                    for (DynamicObject dynamicObject : userPermDoc) {
                        Long orgId = dynamicObject.getLong("org");
                        boolean isIncludeSub = dynamicObject.getBoolean("includesuborg");
                        if (pOrgIds.contains(orgId)) {
                            ifFoundOrgIdInUserPerm = true;
                            checkRuleOrgIdsInUserPerm.add(orgId);
                        }
                        if (!isIncludeSub) continue;
                        orgIncludeSubSet.add(orgId);
                    }
                    if (!CollectionUtils.isEmpty(orgIncludeSubSet)) {
                        permOrgFuncId = PermCommonUtil.getPermOrgFuncId(pEntityNum);
                        for (Long l : pOrgIds) {
                            List tempSuperiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)permOrgFuncId, (long)l);
                            allSuperiorOrgs.addAll(tempSuperiorOrgs);
                        }
                        hasLoadAllSuperOrg = true;
                        allSuperiorOrgs.retainAll(orgIncludeSubSet);
                        checkRuleOrgIdsInUserPerm.addAll(allSuperiorOrgs);
                    }
                }
            }
        }
        QFilter[] qArr = null;
        if (CollectionUtils.isEmpty(pOrgIds)) {
            qArr = new QFilter[]{new QFilter("user", "=", (Object)pUserId), new QFilter("dimtype", "in", dimTypes)};
        } else if (!CollectionUtils.isEmpty(checkRuleOrgIdsInUserPerm)) {
            qArr = new QFilter[]{new QFilter("user", "=", (Object)pUserId), new QFilter("dimtype", "in", dimTypes), new QFilter("org", "in", checkRuleOrgIdsInUserPerm)};
        }
        StringBuilder sbSelectedFields = new StringBuilder("id").append(",").append("dataperm");
        String selectedFields = sbSelectedFields.toString();
        ArrayList<String> dataRuleStrList = new ArrayList<String>();
        if (qArr != null) {
            DynamicObjectCollection dynamicObjectCollection2;
            DynamicObjectCollection userDataPermDoc = QueryServiceHelper.query((String)"perm_userdataperm", (String)selectedFields, (QFilter[])qArr);
            HashSet<String> dataPermIds = new HashSet<String>();
            if (!CollectionUtils.isEmpty((Collection)userDataPermDoc)) {
                for (DynamicObject dObj : userDataPermDoc) {
                    String dataPermId = dObj.getString("dataperm");
                    dataPermIds.add(dataPermId);
                }
            }
            if (!CollectionUtils.isEmpty(dataPermIds) && !CollectionUtils.isEmpty((Collection)(dynamicObjectCollection2 = QueryServiceHelper.query((String)"perm_dataperm", (String)(selectedFields = (sbSelectedFields = new StringBuilder("id").append(",").append("entitytypelist.id").append(",").append("entitytypelist.rule").append(" rule")).toString()), (QFilter[])new QFilter[]{new QFilter("entitytypelist.bizapp", "=", (Object)pAppId), new QFilter("entitytypelist.entitytype", "=", (Object)pEntityNum), new QFilter("id", "in", dataPermIds)})))) {
                for (int i = 0; i < dynamicObjectCollection2.size(); ++i) {
                    DynamicObject dObj = (DynamicObject)dynamicObjectCollection2.get(i);
                    ruleJson = dObj.getString(PROP_RULE);
                    dataRuleStrList.add(ruleJson);
                }
            }
        }
        DynamicObjectCollection userRoleDoc = null;
        Set<Object> roleIds = new HashSet();
        if (PermCommonUtil.isEnableSingleBizRole()) {
            String string = UserBizRoleCache.getSelBizRole(pUserId);
            if (StringUtils.isNotEmpty((String)string) && !CollectionUtils.isEmpty((Collection)(userRoleDoc = QueryServiceHelper.query((String)"perm_bizrole", (String)"bizrolecomrole.role role,bizroleorg.org org, bizroleorg.isincludesuborg includesuborg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(string)), new QFilter("bizroleorg.dimtype", "in", dimTypes), new QFilter("bizrolecomrole.ISENABLE", "=", (Object)"1")})))) {
                if (!CollectionUtils.isEmpty(pOrgIds) && !hasLoadAllSuperOrg) {
                    permOrgFuncId = PermCommonUtil.getPermOrgFuncId(pEntityNum);
                    for (Long orgId : pOrgIds) {
                        List tempSuperiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)permOrgFuncId, (long)orgId);
                        if (CollectionUtils.isEmpty((Collection)tempSuperiorOrgs)) continue;
                        allSuperiorOrgs.addAll(tempSuperiorOrgs);
                    }
                }
                for (DynamicObject dObj : userRoleDoc) {
                    Long curOrgId = dObj.getLong("org");
                    String roleId = dObj.getString("role");
                    boolean includeSubOrg = dObj.getBoolean("includesuborg");
                    if (!CollectionUtils.isEmpty(pOrgIds)) {
                        if (pOrgIds.contains(curOrgId)) {
                            roleIds.add(roleId);
                            continue;
                        }
                        if (!allSuperiorOrgs.contains(curOrgId) || !includeSubOrg) continue;
                        roleIds.add(roleId);
                        continue;
                    }
                    roleIds.add(roleId);
                }
            }
        } else {
            roleIds = UserRoleCache.getRolesByUserId(pUserId, pOrgIds, (String)dimTypes.get(1));
        }
        if (!CollectionUtils.isEmpty(roleIds) && !CollectionUtils.isEmpty((Collection)(dynamicObjectCollection = QueryServiceHelper.query((String)"perm_roledataperm", (String)(selectedFields = (sbSelectedFields = new StringBuilder("id").append(",").append("datapermid.entitytypelist.rule").append(" rule")).toString()), (QFilter[])new QFilter[]{new QFilter("datapermid.entitytypelist.bizapp", "=", (Object)pAppId), new QFilter("datapermid.entitytypelist.entitytype", "=", (Object)pEntityNum), new QFilter("role", "in", roleIds)})))) {
            for (DynamicObject dObj : dynamicObjectCollection) {
                ruleJson = dObj.getString(PROP_RULE);
                dataRuleStrList.add(ruleJson);
            }
        }
        if (dataRuleStrList.isEmpty()) {
            return null;
        }
        return JSONObject.toJSONString(dataRuleStrList);
    }

    public static QFilter getDataPermWithoutOrg(long pUserId, String pAppId, String pEntityNum) {
        return DataPermissionCache.getDataPermWithoutOrg(pUserId, pAppId, pEntityNum, null);
    }

    public static QFilter getDataPermWithoutOrg(long pUserId, String pAppId, String pEntityNum, List<Long> pDimObjIds) {
        boolean hasEnableOldDataRule = PermCommonUtil.hasEnableOldDataRule();
        if (hasEnableOldDataRule) {
            String type = CacheMrg.getType4DataPermObj();
            String buildKeyWithoutOrg = DataPermissionCache.buildKeyWithoutOrg(pUserId, pAppId, pEntityNum, pDimObjIds);
            QFilter result = null;
            String value = CacheMrg.getCache(type, buildKeyWithoutOrg);
            if (StringUtils.isEmpty((String)value)) {
                value = DataPermissionCache.loadDataPermWithoutOrg(pUserId, pAppId, pEntityNum, pDimObjIds);
                if (StringUtils.isNotEmpty((String)value) && !"[]".equals(value)) {
                    CacheMrg.putCache(type, buildKeyWithoutOrg, value);
                } else {
                    CacheMrg.loaded(type, buildKeyWithoutOrg);
                }
            }
            if (StringUtils.isEmpty((String)value) || "[]".equals(value) || "PERM_DATA_LOADED".equals(value)) {
                logger.info("DataPermission.getDataPermWithoutOrg \u67e5\u65e0\u89c4\u5219");
                return null;
            }
            List dataRuleStrList = (List)JSONObject.parseObject((String)value, List.class);
            int allDataRuleCount = dataRuleStrList.size();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)pEntityNum);
            for (int i = 0; i < allDataRuleCount; ++i) {
                String ruleStr = (String)dataRuleStrList.get(i);
                if (StringUtils.isEmpty((String)ruleStr)) continue;
                QFilter curFilter = PermCommonUtil.getQFilterFromFilterGridJsonStr(entityType, ruleStr);
                if (i == 0) {
                    if (curFilter == null) continue;
                    result = curFilter.copy();
                    continue;
                }
                if (result != null) {
                    result = result.or(curFilter);
                    continue;
                }
                if (curFilter == null) continue;
                result = curFilter.copy();
            }
            boolean hasEnablePropCollapse = PermCommonUtil.hasEnablePropCollapse();
            if (hasEnablePropCollapse && result != null) {
                String orgIdsArrayInfo = "";
                if (pDimObjIds != null && !pDimObjIds.isEmpty()) {
                    orgIdsArrayInfo = Arrays.toString(pDimObjIds.toArray());
                }
                String filterInfo = String.format(ResManager.loadKDString((String)"\u539f\u59cb\u7684\u6570\u636e\u89c4\u5219\uff08\u65e7\uff09: %1$s [userId:%2$s, appId:%3$s, entityNum:%4$s, orgIds:%5$s]", (String)"DataPermissionCache_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), result.toCurrentString(), pUserId, pAppId, pEntityNum, orgIdsArrayInfo);
                logger.info(filterInfo);
                HashMap<String, QFilter> convertRuleRowMap = new HashMap<String, QFilter>();
                result = PermCommonUtil.convertQFilter(pEntityNum, result, convertRuleRowMap);
                String filterInfoAfter = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u540e\u7684\u6570\u636e\u89c4\u5219\uff08\u65e7\uff09: %1$s [userId:%2$s, appId:%3$s, entityNum:%4$s, orgIds:%5$s]", (String)"DataPermissionCache_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), result.toCurrentString(), pUserId, pAppId, pEntityNum, orgIdsArrayInfo);
                logger.info(filterInfoAfter);
            }
            return result;
        }
        return DataRuleCache.getDataRuleWithoutDim(pUserId, pAppId, pEntityNum, "47150e89000000ac", pDimObjIds);
    }

    public static DataRuleResult loadUserDataPermWithoutDimObj(long pUserId, String pAppId, String pEntityNum, List<Long> dimObjIds) {
        return DataPermissionCache.loadUserDataPermWithoutDimObj(pUserId, pAppId, pEntityNum, dimObjIds, "15");
    }

    public static DataRuleResult loadUserDataPermWithoutDimObj(long pUserId, String pAppId, String pEntityNum, List<Long> dimObjIds, String orgViewNum) {
        DataRuleResult drr = new DataRuleResult();
        StringBuilder sbSelectedFields = new StringBuilder("id").append(",").append("dataperm").append(",").append("org").append(",").append("includesuborg");
        String selectedFields = sbSelectedFields.toString();
        String dimTypeNum = PermCommonUtil.getDimTypeNumByEntityNum(pEntityNum);
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimTypeNum);
        QFilter[] noOrgQFilters = new QFilter[]{new QFilter("user", "=", (Object)pUserId), new QFilter("dimtype", "in", Arrays.asList(suitableDimType[0], suitableDimType[1]))};
        Object userDataPermDoc = null;
        DynamicObjectCollection userDataPermDocNoOrg = QueryServiceHelper.query((String)"perm_userdataperm", (String)selectedFields, (QFilter[])noOrgQFilters);
        if (dimObjIds == null || dimObjIds.isEmpty()) {
            userDataPermDoc = userDataPermDocNoOrg;
        } else {
            QFilter[] orgQFilters;
            DynamicObjectCollection userDataPermDocWithOrg;
            Map allSupOrgMap;
            boolean hasIncludeSub = false;
            if (!CollectionUtils.isEmpty((Collection)userDataPermDocNoOrg)) {
                for (DynamicObject dObj : userDataPermDocNoOrg) {
                    boolean includeSub = dObj.getBoolean("includesuborg");
                    if (!includeSub) continue;
                    hasIncludeSub = true;
                    break;
                }
            }
            Iterator userDataPermDocSupOrg = null;
            if (hasIncludeSub && (allSupOrgMap = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgViewNum, dimObjIds)) != null && !allSupOrgMap.isEmpty()) {
                Collection allSupOrgMapValues = allSupOrgMap.values();
                ArrayList allSupOrgIds = new ArrayList();
                for (List list : allSupOrgMapValues) {
                    allSupOrgIds.addAll(list);
                }
                if (allSupOrgIds != null && !allSupOrgIds.isEmpty()) {
                    QFilter[] supOrgQFilters = new QFilter[]{new QFilter("user", "=", (Object)pUserId), new QFilter("dimtype", "in", Arrays.asList(suitableDimType[0], suitableDimType[1])), new QFilter("org", "in", allSupOrgIds), new QFilter("includesuborg", "=", (Object)Character.valueOf('1'))};
                    userDataPermDocSupOrg = QueryServiceHelper.query((String)"perm_userdataperm", (String)selectedFields, (QFilter[])supOrgQFilters);
                }
            }
            if ((userDataPermDocWithOrg = QueryServiceHelper.query((String)"perm_userdataperm", (String)selectedFields, (QFilter[])(orgQFilters = new QFilter[]{new QFilter("user", "=", (Object)pUserId), new QFilter("dimtype", "in", Arrays.asList(suitableDimType[0], suitableDimType[1])), new QFilter("org", "in", dimObjIds)}))) == null || userDataPermDocWithOrg.isEmpty()) {
                userDataPermDoc = userDataPermDocSupOrg;
            } else {
                if (userDataPermDocSupOrg != null && !userDataPermDocSupOrg.isEmpty()) {
                    userDataPermDocWithOrg.addAll((Collection)((Object)userDataPermDocSupOrg));
                }
                userDataPermDoc = userDataPermDocWithOrg;
            }
        }
        ArrayList<String> dataPermIds = new ArrayList<String>();
        if (null != userDataPermDoc && !userDataPermDoc.isEmpty()) {
            DynamicObjectCollection dataPermDoc;
            for (DynamicObject dObj : userDataPermDoc) {
                String dataPermId = dObj.getString("dataperm");
                dataPermIds.add(dataPermId);
            }
            if (!CollectionUtils.isEmpty(dataPermIds) && !CollectionUtils.isEmpty((Collection)(dataPermDoc = QueryServiceHelper.query((String)"perm_dataperm", (String)(selectedFields = (sbSelectedFields = new StringBuilder("id").append(",").append("entitytypelist.id").append(",").append("entitytypelist.rule").append(" rule")).toString()), (QFilter[])new QFilter[]{new QFilter("entitytypelist.bizapp", "=", (Object)pAppId), new QFilter("entitytypelist.entitytype", "=", (Object)pEntityNum), new QFilter("id", "in", dataPermIds)})))) {
                for (int i = 0; i < dataPermDoc.size(); ++i) {
                    DynamicObject dObj = (DynamicObject)dataPermDoc.get(i);
                    String ruleJson = dObj.getString(PROP_RULE);
                    DataRuleSingleResult sr = new DataRuleSingleResult();
                    sr.setFilterJson(ruleJson);
                    drr.getSingleResultList().add(sr);
                }
            }
        }
        drr.setNeedDimCtrl(false);
        return drr;
    }

    public static DataRuleResult loadUserDataPermWithDimObj(long pUserId, String pAppId, String pEntityNum) {
        DynamicObjectCollection userDataPermDoc;
        DataRuleResult drr = new DataRuleResult();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)pEntityNum);
        String checkPermOrgKey = PermCommonUtil.getCheckPermOrg(dataEntityType);
        if (StringUtils.isEmpty((String)checkPermOrgKey)) {
            drr.setNeedDimCtrl(false);
        }
        if (CollectionUtils.isEmpty((Collection)(userDataPermDoc = DataPermissionCache.loadUserDataPermWithDimObj(pUserId, pAppId, pEntityNum, drr)))) {
            return null;
        }
        return drr;
    }
}

