/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginCall;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.DataRuleResult;
import kd.bos.permission.api.DataRuleSingleResult;
import kd.bos.permission.api.ext.IDataRuleExt;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.DataPermissionCache;
import kd.bos.permission.cache.UserRoleCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.EntityMapHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.OperationHelper;
import kd.bos.permission.cache.model.CustomPermServInfo;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.enums.AssignModEnum;
import kd.bos.permission.model.AssignDataRulesInfo;
import kd.bos.permission.model.DataRuleInfo;
import kd.bos.permission.model.DataRulesInfo;
import kd.bos.permission.model.EntDataRuleInfo;
import kd.bos.permission.model.OverAllDataRuleInfo;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.NewDrPerm;
import kd.bos.permission.model.perm.NewDrPrPerm;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class DataRuleCache {
    public static final String VALUE_INCLUDESUB = "includeSub";
    @Deprecated
    public static final String DATARULE_APPLYSCOPE_ENT = "1";
    @Deprecated
    public static final String DATARULE_APPLYSCOPE_APP = "2";
    @Deprecated
    public static final String DATARULE_APPLYSCOPE_CLOUD = "3";
    @Deprecated
    public static final String DATARULE_APPLYSCOPE_OVERALL = "4";
    private static final String SYSTEM_TYPE = "bos-permission-cache";
    private static final String ENTRYENTITY = "entryentity";
    private static final String DIMTYPENUM = "dimtypenum";
    private static final String DIMTYPE = "dimtype";
    private static final String DIMOBJ = "dimobj";
    private static final String DIMOBJ_ID = "dimobj_id";
    private static final String ISINCLUDESUB = "isincludesub";
    public static final String METHOD_GET_DATA_RULE = "getDataRule";
    public static final String METHOD_GET_DATA_RULE_SCRIPT = "getDataRuleScript";
    public static final String METHOD_GETDATARULEFORBDPROP = "getDataRuleForBdProp";
    public static final String METHOD_GETMULBDPROPKEYSBYHASSETDATARULE = "getMulBdPropKeysByHasSetDataRule";
    private static final String MESSAGE_3 = " %s [userId:%s, appId:%s, entityNum:%s, permItemId:%s]";
    private static final String CUSTOMPARAM_ISLOOKUP = "isLookUp";
    private static final String CUSTOMPARAM_USEORGID = "UseOrgId";
    private static final String DATARULE_SCRIPT_EVERTRUE = "1=1";
    private static final String DATARULE_SCRIPT_EVERFALSE = "1!=1";
    private static final String CUSTOMPARAM_DATARULE_EXTDATAENTSET = "DataRule_CustParam_ExtendDataEntitySet";
    private static final String CUSTOMPARAM_DATARULE_QFILTER = "DataRule_CustomParam_QFilter";
    public static final String ERRCODE_DATARULE_NOTSUPPORT_NOTVIEW_MULBD = "ERR_DATARULE_NOT_SUPPORTED_NOTVIEW_MULBD";
    private static Log logger = LogFactory.getLog(DataRuleCache.class);

    private static String getInfoNoResult() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355 %s \u540c\u65f6\u5b58\u5728\u4ee5\u4e0b\u60c5\u51b5\u5bfc\u81f4\u67e5\u4e0d\u51fa\u6570\u636e\uff1a", (String)"DataRuleCache_0", (String)SYSTEM_TYPE, (Object[])new Object[0]) + ResManager.loadKDString((String)"1\u3001\u5f00\u542f\u4e86\u201c\u5f3a\u5236\u4f7f\u7528\u6570\u636e\u89c4\u5219\u201d\u7684\u53c2\u6570\uff1b ", (String)"DataRuleCache_1", (String)SYSTEM_TYPE, (Object[])new Object[0]) + ResManager.loadKDString((String)"2\u3001\u67d0\u4e2a\u201c\u5168\u5c40\u7ba1\u63a7\u7ef4\u5ea6\u201d\u7684\u5c5e\u6027\u6ca1\u6709\u914d\u7f6e\u5168\u5c40\u89c4\u5219\uff1b", (String)"DataRuleCache_2", (String)SYSTEM_TYPE, (Object[])new Object[0]) + ResManager.loadKDString((String)"3\u3001\u4e0d\u5b58\u5728\u5177\u4f53\u8868\u5355\u4e0a\u914d\u7f6e\u7684\u6570\u636e\u89c4\u5219\u3002", (String)"DataRuleCache_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }

    private static String getMessage1(String appNum) {
        return String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4e1a\u52a1\u5e94\u7528\uff08%1$s\uff09 ", (String)"DataRuleCache_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), appNum);
    }

    public static boolean newDataRule(DataRuleInfo dataRuleInfo) {
        return DataRuleCache.newDataRule(dataRuleInfo, "", null);
    }

    public static boolean newDataRule(DataRuleInfo dataRuleInfo, String assignMode) {
        return DataRuleCache.newDataRule(dataRuleInfo, assignMode, null);
    }

    public static boolean newDataRule(DataRuleInfo dataRuleInfo, StringBuilder processInfo) {
        return DataRuleCache.newDataRule(dataRuleInfo, "", processInfo);
    }

    public static boolean newDataRule(DataRuleInfo dataRuleInfo, String assignMode, StringBuilder processInfo) {
        String lsName;
        QFilter numberOrNameUniqueFilter;
        boolean existDataRule;
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (dataRuleInfo == null) {
            processInfo.append(ResManager.loadKDString((String)"dataRuleInfo\u4e0d\u80fd\u4e3a\u7a7a", (String)"DataRuleCache_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        if (dataRuleInfo.getId() != null) {
            processInfo.append(ResManager.loadKDString((String)"dataRuleInfo\u7684ID\u4e0d\u5e94\u8be5\u9884\u8bbe\u503c\uff0c\u4e0d\u5e94\u4f20\u5165\u5df2\u7ecf\u5b58\u5728\u7684\u6570\u636e\u89c4\u5219\u65b9\u6848\u5bf9\u8c61\u3002", (String)"DataRuleCache_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        String number = dataRuleInfo.getNumber();
        ILocaleString name = dataRuleInfo.getName();
        String appId = dataRuleInfo.getAppId();
        String entNum = dataRuleInfo.getEntityNum();
        if (number == null || name == null || entNum == null) {
            processInfo.append(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5fc5\u5f55\u5c5e\u6027\uff1a \u7f16\u7801\uff0c\u540d\u79f0, \u5b9e\u4f53\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        FilterCondition rule = dataRuleInfo.getRule();
        boolean isDetail = dataRuleInfo.isDetail();
        List permItemsDataRuleList = dataRuleInfo.getPermItemsDataRule();
        List bdPropsDataRuleList = dataRuleInfo.getBdPropsDataRule();
        if (isDetail) {
            if (!CollectionUtils.isEmpty((Collection)permItemsDataRuleList) || !CollectionUtils.isEmpty((Collection)bdPropsDataRuleList)) {
                processInfo.append(ResManager.loadKDString((String)"isdetail\u4e3atrue\u65f6\uff0c\u4e0d\u80fd\u914d\u7f6e\u6743\u9650\u9879\u7684\u89c4\u5219\uff0c\u6216\u8005\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u7684\u89c4\u5219\u3002\u9664\u975e\u4e3afalse\u3002", (String)"DataRuleCache_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (rule == null) {
                processInfo.append(ResManager.loadKDString((String)"\u660e\u7ec6\u65b9\u6848\u7684\u89c4\u5219\uff08rule\uff09\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
        }
        if (!isDetail) {
            DataRuleInfo dataRule;
            if (CollectionUtils.isEmpty((Collection)permItemsDataRuleList) && CollectionUtils.isEmpty((Collection)bdPropsDataRuleList)) {
                processInfo.append(ResManager.loadKDString((String)"isdetail\u4e3afalse\u65f6\uff0c\u6743\u9650\u9879\u7684\u89c4\u5219\u548c\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u7684\u89c4\u5219\u914d\u7f6e\u4e0d\u80fd\u90fd\u4e3a\u7a7a\u3002\u9664\u975e\u4e3atrue\u3002", (String)"DataRuleCache_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (!CollectionUtils.isEmpty((Collection)permItemsDataRuleList)) {
                for (DataRuleInfo.PermItemsDataRule pidr : permItemsDataRuleList) {
                    String permItemId = pidr.getPermItemId();
                    if (StringUtils.isEmpty((String)permItemId)) {
                        processInfo.append(ResManager.loadKDString((String)"\u6743\u9650\u9879ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        return false;
                    }
                    dataRule = pidr.getDataRule();
                    if (dataRule != null && dataRule.getId() != null) continue;
                    processInfo.append(ResManager.loadKDString((String)"\u6743\u9650\u9879\u7684\u6570\u636e\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002\u5fc5\u987b\u5df2\u4fdd\u5b58\u3002", (String)"DataRuleCache_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return false;
                }
            }
            if (!CollectionUtils.isEmpty((Collection)bdPropsDataRuleList)) {
                for (DataRuleInfo.BdPropsDataRule bpdr : bdPropsDataRuleList) {
                    String bdPropKey = bpdr.getPropKey();
                    if (StringUtils.isEmpty((String)bdPropKey)) {
                        processInfo.append(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u7684\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        return false;
                    }
                    dataRule = bpdr.getDataRule();
                    if (dataRule != null && dataRule.getId() != null) continue;
                    processInfo.append(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u7684\u6570\u636e\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return false;
                }
            }
        }
        if ((existDataRule = QueryServiceHelper.exists((String)"perm_datarule", (QFilter[])new QFilter[]{numberOrNameUniqueFilter = new QFilter("number", "=", (Object)number).or(new QFilter("name", "=", (Object)(lsName = name.getLocaleValue())))})) && AssignModEnum.ASSIGNMODE_REPLACE.getCode().equals(assignMode)) {
            DeleteServiceHelper.delete((String)"perm_datarule", (QFilter[])new QFilter[]{numberOrNameUniqueFilter});
        }
        if (existDataRule && !AssignModEnum.ASSIGNMODE_REPLACE.getCode().equals(assignMode)) {
            processInfo.append(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u7f16\u7801\u6216\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DataRuleCache_16", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        Long curUserId = Long.valueOf(RequestContext.get().getUserId());
        DynamicObject dataRuleObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_datarule");
        dataRuleObj.set("number", (Object)number);
        dataRuleObj.set("name", (Object)name);
        dataRuleObj.set("bizapp", (Object)appId);
        dataRuleObj.set("entity", (Object)entNum);
        dataRuleObj.set("description", (Object)dataRuleInfo.getDescription());
        dataRuleObj.set("isdetail", (Object)isDetail);
        if (rule != null) {
            String filterJson = rule.getFilter();
            if (StringUtils.isEmpty((String)filterJson)) {
                filterJson = SerializationUtils.toJsonString((Object)rule);
            }
            dataRuleObj.set("rule", (Object)filterJson);
        }
        dataRuleObj.set("enable", (Object)DATARULE_APPLYSCOPE_ENT);
        dataRuleObj.set("status", (Object)"C");
        dataRuleObj.set("creator", (Object)curUserId);
        dataRuleObj.set("createtime", (Object)new Date());
        if (!isDetail) {
            DynamicObjectType rowType;
            if (!CollectionUtils.isEmpty((Collection)permItemsDataRuleList)) {
                DynamicObjectCollection permItemsDataRuleDoc = dataRuleObj.getDynamicObjectCollection(ENTRYENTITY);
                rowType = permItemsDataRuleDoc.getDynamicObjectType();
                for (DataRuleInfo.PermItemsDataRule pidr : permItemsDataRuleList) {
                    DynamicObject permItemsDataRuleRow = new DynamicObject(rowType);
                    permItemsDataRuleRow.set("permitem", (Object)pidr.getPermItemId());
                    permItemsDataRuleRow.set("datarule", (Object)pidr.getDataRule().getId());
                    permItemsDataRuleDoc.add((Object)permItemsDataRuleRow);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)bdPropsDataRuleList)) {
                DynamicObjectCollection bdPropDataRuleDoc = dataRuleObj.getDynamicObjectCollection("entryentity_prop");
                rowType = bdPropDataRuleDoc.getDynamicObjectType();
                for (DataRuleInfo.BdPropsDataRule bpdr : bdPropsDataRuleList) {
                    DynamicObject bdPropDataRuleRow = new DynamicObject(rowType);
                    bdPropDataRuleRow.set("propent", (Object)bpdr.getPropEntNum());
                    bdPropDataRuleRow.set("propkey", (Object)bpdr.getPropKey());
                    bdPropDataRuleRow.set("propdatarule", (Object)bpdr.getDataRule().getId());
                    bdPropDataRuleDoc.add((Object)bdPropDataRuleRow);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataRuleObj});
        dataRuleInfo.setId((Long)dataRuleObj.getPkValue());
        return true;
    }

    public static boolean delDataRule(QFilter[] qfilters, StringBuilder processInfo) {
        boolean existsInRoleDataRule;
        Serializable dataRuleId;
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (qfilters == null || qfilters.length == 0) {
            processInfo.append(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        ArrayList<Long> dataRuleIds = new ArrayList<Long>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(DataRuleCache.class.getName() + ".delDataRule"), (String)"perm_datarule", (String)"id", (QFilter[])qfilters, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                dataRuleId = row.getLong("id");
                if (dataRuleId == null) continue;
                dataRuleIds.add(row.getLong("id"));
            }
        }
        if (CollectionUtils.isEmpty(dataRuleIds)) {
            processInfo.append(ResManager.loadKDString((String)"\u67e5\u65e0\u6570\u636e\uff0c\u672a\u5220\u9664\u4efb\u4f55\u6570\u636e\u3002", (String)"DataRuleCache_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT COUNT (A.FDATARULESID) FROM T_PERM_ROLEDATARULES A INNER JOIN T_PERM_DATARULES_ENTRY C ON A.FDATARULESID = C.FID WHERE", new Object[0]);
        sqlBuilder.appendIn("C.FDATARULEID", dataRuleIds);
        Long countRuleID = 0L;
        DataSet ds = DB.queryDataSet((String)(DataRuleCache.class.getName() + ".delDataRule_queryRoleDataRules"), (DBRoute)DBRoute.permission, (SqlBuilder)sqlBuilder);
        dataRuleId = null;
        try {
            if (ds.hasNext()) {
                Row row = ds.next();
                countRuleID = row.getLong(0);
            }
        }
        catch (Throwable throwable) {
            dataRuleId = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (dataRuleId != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)dataRuleId).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        boolean bl = existsInRoleDataRule = countRuleID > 0L;
        if (existsInRoleDataRule) {
            processInfo.append(ResManager.loadKDString((String)"\u5168\u90e8\u6216\u90e8\u5206\u5f85\u5220\u9664\u6570\u636e\u89c4\u5219\u65b9\u4e2d\u5df2\u88ab\u67d0\u4e9b\u89d2\u8272\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"DataRuleCache_20", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        int count = DeleteServiceHelper.delete((String)"perm_datarule", (QFilter[])qfilters);
        if (count == 0) {
            processInfo.append(ResManager.loadKDString((String)"\u67e5\u65e0\u6570\u636e\uff0c\u672a\u5220\u9664\u4efb\u4f55\u6570\u636e\u3002", (String)"DataRuleCache_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        processInfo.append(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DataRuleCache_21", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        return true;
    }

    public static boolean modifyDataRule(Long oldDataRuleId, DataRuleInfo newDataRuleInfo) {
        return DataRuleCache.modifyDataRule(oldDataRuleId, newDataRuleInfo, null);
    }

    public static boolean modifyDataRule(Long oldDataRuleId, DataRuleInfo newDataRuleInfo, StringBuilder processInfo) {
        Boolean enable;
        FilterCondition fc;
        String number;
        ILocaleString name;
        String desp;
        String appId;
        DynamicObject oldDataRule;
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (oldDataRuleId == null || newDataRuleInfo == null) {
            processInfo.append(ResManager.loadKDString((String)"\u5f85\u67e5\u6570\u636e\u89c4\u5219 \u6216 \u65b0\u4fee\u6539\u7684\u89c4\u5219\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_22", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        try {
            oldDataRule = BusinessDataServiceHelper.loadSingle((Object)oldDataRuleId, (String)"perm_datarule");
        }
        catch (Exception e) {
            String errorInfo = ResManager.loadKDString((String)"\u5f85\u66f4\u65b0\u7684\u6570\u636e\u89c4\u5219\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"DataRuleCache_23", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            logger.warn(errorInfo, (Throwable)e);
            processInfo.append(errorInfo);
            return false;
        }
        boolean isDetailRule4New = newDataRuleInfo.isDetail();
        boolean isDetailRule4Old = oldDataRule.getBoolean("isdetail");
        List newPermItemsDataRuleList = newDataRuleInfo.getPermItemsDataRule();
        List newBdPropsDataRuleList = newDataRuleInfo.getBdPropsDataRule();
        if (!isDetailRule4New) {
            if (isDetailRule4Old) {
                processInfo.append(ResManager.loadKDString((String)"\u5f85\u4fee\u6539\u7684\u6570\u636e\u89c4\u5219\u662f\u660e\u7ec6\u89c4\u5219\uff0c\u548c\u9884\u671f\u4fee\u6539\u7684\u975e\u660e\u7ec6\u89c4\u5219\u60c5\u51b5\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"DataRuleCache_24", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            if (!CollectionUtils.isEmpty((Collection)newPermItemsDataRuleList)) {
                for (DataRuleInfo.PermItemsDataRule permItemRowNew : newPermItemsDataRuleList) {
                    String permItemIdNew = permItemRowNew.getPermItemId();
                    if (StringUtils.isEmpty((String)permItemIdNew)) {
                        processInfo.append(ResManager.loadKDString((String)"newDataRuleInfo\u9884\u671f\u4fee\u6539\u7684\u6743\u9650\u9879ID\u4e3a\u7a7a\uff0c\u53ef\u80fd\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u8c03\u6574", (String)"DataRuleCache_25", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        return false;
                    }
                    DataRuleInfo dri = permItemRowNew.getDataRule();
                    if (dri == null) {
                        processInfo.append(ResManager.loadKDString((String)"newDataRuleInfo\u9884\u671f\u4fee\u6539\u7684\u6743\u9650\u9879\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bf7\u8c03\u6574", (String)"DataRuleCache_26", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        return false;
                    }
                    if (dri.isDetail()) continue;
                    processInfo.append(ResManager.loadKDString((String)"newDataRuleInfo\u9884\u671f\u4fee\u6539\u7684\u6743\u9650\u9879\u89c4\u5219\u4e0d\u662f\u660e\u7ec6\u65b9\u6848\uff0c\u53ef\u80fd\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u8c03\u6574", (String)"DataRuleCache_27", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return false;
                }
            }
            if (!CollectionUtils.isEmpty((Collection)newBdPropsDataRuleList)) {
                for (DataRuleInfo.BdPropsDataRule bdPropRuleRow : newBdPropsDataRuleList) {
                    String propKey = bdPropRuleRow.getPropKey();
                    String propEntNum = bdPropRuleRow.getPropEntNum();
                    if (StringUtils.isEmpty((String)propKey)) {
                        processInfo.append(ResManager.loadKDString((String)"newDataRuleInfo\u9884\u671f\u4fee\u6539\u7684\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u6807\u8bc6\u4e3a\u7a7a\uff0c\u53ef\u80fd\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u8c03\u6574", (String)"DataRuleCache_28", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        return false;
                    }
                    if (StringUtils.isEmpty((String)propEntNum)) {
                        processInfo.append(ResManager.loadKDString((String)"newDataRuleInfo\u9884\u671f\u4fee\u6539\u7684\u57fa\u7840\u8d44\u6599\u5bf9\u5e94\u4e1a\u52a1\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u53ef\u80fd\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u8c03\u6574", (String)"DataRuleCache_29", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        return false;
                    }
                    DataRuleInfo dri = bdPropRuleRow.getDataRule();
                    if (dri == null) {
                        processInfo.append(ResManager.loadKDString((String)"newDataRuleInfo\u9884\u671f\u4fee\u6539\u7684\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u7684\u89c4\u5219\u4e3a\u7a7a\uff0c\u8bf7\u8c03\u6574", (String)"DataRuleCache_30", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        return false;
                    }
                    if (dri.isDetail()) continue;
                    processInfo.append(ResManager.loadKDString((String)"newDataRuleInfo\u9884\u671f\u4fee\u6539\u7684\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u7684\u89c4\u5219\u4e0d\u662f\u660e\u7ec6\u65b9\u6848\uff0c\u53ef\u80fd\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u8c03\u6574", (String)"DataRuleCache_31", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return false;
                }
            }
        }
        if (StringUtils.isNotEmpty((String)(appId = newDataRuleInfo.getAppId()))) {
            oldDataRule.set("bizapp", (Object)appId);
        }
        if (StringUtils.isNotEmpty((String)(desp = newDataRuleInfo.getDescription()))) {
            oldDataRule.set("description", (Object)desp);
        }
        if ((name = newDataRuleInfo.getName()) != null) {
            oldDataRule.set("name", (Object)name);
        }
        if (StringUtils.isNotEmpty((String)(number = newDataRuleInfo.getNumber()))) {
            oldDataRule.set("number", (Object)number);
        }
        if ((fc = newDataRuleInfo.getRule()) != null) {
            oldDataRule.set("rule", (Object)fc.getFilter());
        }
        if ((enable = newDataRuleInfo.isEnable()) != null) {
            if (enable.booleanValue()) {
                oldDataRule.set("enable", (Object)DATARULE_APPLYSCOPE_ENT);
            } else {
                oldDataRule.set("enable", (Object)"0");
            }
        }
        if (!isDetailRule4New) {
            DynamicObjectCollection oldPropDoc;
            Long dataRuleId;
            DynamicObjectCollection oldPermItemRuleDoc;
            if (!CollectionUtils.isEmpty((Collection)newPermItemsDataRuleList)) {
                oldPermItemRuleDoc = oldDataRule.getDynamicObjectCollection(ENTRYENTITY);
                ArrayList<Object> forDelPermItemRowOld = new ArrayList<Object>(8);
                for (Object permItemRowOld : oldPermItemRuleDoc) {
                    String permItemIdOld = permItemRowOld.getString("permitem.id");
                    dataRuleId = permItemRowOld.getLong("datarule_id");
                    if (StringUtils.isEmpty((String)permItemIdOld) || dataRuleId == null || dataRuleId == 0L) continue;
                    boolean oldfoundInNew = false;
                    for (Iterator permItemRowNew : newPermItemsDataRuleList) {
                        String permItemIdNew = permItemRowNew.getPermItemId();
                        DataRuleInfo driNew = permItemRowNew.getDataRule();
                        if (!permItemIdOld.equals(permItemIdNew) || !dataRuleId.equals(driNew.getId())) continue;
                        permItemRowOld.set("datarule", (Object)driNew.getId());
                        oldfoundInNew = true;
                        break;
                    }
                    if (oldfoundInNew) continue;
                    forDelPermItemRowOld.add(permItemRowOld);
                }
                ArrayList forAddPermItemRow = new ArrayList(8);
                for (DataRuleInfo.PermItemsDataRule permItemRowNew : newPermItemsDataRuleList) {
                    String permItemIdNew = permItemRowNew.getPermItemId();
                    Long dataRuleId2 = permItemRowNew.getDataRule().getId();
                    boolean newFoundInOld = false;
                    for (DynamicObject permItemRowOld : oldPermItemRuleDoc) {
                        String permItemIdOld = permItemRowOld.getString("permitem.id");
                        Long dataRuleIdOld = permItemRowOld.getLong("datarule_id");
                        if (StringUtils.isEmpty((String)permItemIdOld) || dataRuleIdOld == null || dataRuleIdOld == 0L || !permItemIdOld.equals(permItemIdNew) || !dataRuleIdOld.equals(dataRuleId2)) continue;
                        newFoundInOld = true;
                        break;
                    }
                    if (newFoundInOld) continue;
                    forAddPermItemRow.add(permItemRowNew);
                }
                if (!CollectionUtils.isEmpty(forDelPermItemRowOld)) {
                    oldPermItemRuleDoc.removeAll(forDelPermItemRowOld);
                }
                if (!CollectionUtils.isEmpty((Collection)forAddPermItemRow)) {
                    Object permItemRowOld;
                    permItemRowOld = forAddPermItemRow.iterator();
                    while (permItemRowOld.hasNext()) {
                        DataRuleInfo.PermItemsDataRule permItemsDataRule = (DataRuleInfo.PermItemsDataRule)permItemRowOld.next();
                        DynamicObject permItemNewRow = new DynamicObject(oldPermItemRuleDoc.getDynamicObjectType());
                        permItemNewRow.set("permitem", (Object)permItemsDataRule.getPermItemId());
                        permItemNewRow.set("datarule", (Object)permItemsDataRule.getDataRule().getId());
                        oldPermItemRuleDoc.add((Object)permItemNewRow);
                    }
                }
            } else {
                oldPermItemRuleDoc = oldDataRule.getDynamicObjectCollection(ENTRYENTITY);
                if (!CollectionUtils.isEmpty((Collection)oldPermItemRuleDoc)) {
                    oldPermItemRuleDoc.clear();
                }
            }
            if (!CollectionUtils.isEmpty((Collection)newBdPropsDataRuleList)) {
                oldPropDoc = oldDataRule.getDynamicObjectCollection("entryentity_prop");
                ArrayList<DynamicObject> forDelRow = new ArrayList<DynamicObject>(8);
                for (DynamicObject oldPropRow : oldPropDoc) {
                    String propKeyOld = oldPropRow.getString("propkey");
                    dataRuleId = oldPropRow.getLong("propdatarule_id");
                    if (StringUtils.isEmpty((String)propKeyOld) || dataRuleId == null || dataRuleId == 0L) continue;
                    boolean oldfoundInNew = false;
                    for (DataRuleInfo.BdPropsDataRule bdPropsRuleNew : newBdPropsDataRuleList) {
                        String propKeyNew = bdPropsRuleNew.getPropKey();
                        DataRuleInfo dri = bdPropsRuleNew.getDataRule();
                        if (!propKeyOld.equals(propKeyNew) || !dataRuleId.equals(dri.getId())) continue;
                        oldPropRow.set("propdatarule", (Object)dri.getId());
                        oldfoundInNew = true;
                        break;
                    }
                    if (oldfoundInNew) continue;
                    forDelRow.add(oldPropRow);
                }
                ArrayList<DataRuleInfo.BdPropsDataRule> forAddRow = new ArrayList<DataRuleInfo.BdPropsDataRule>(8);
                for (DataRuleInfo.BdPropsDataRule newRow : newBdPropsDataRuleList) {
                    String propKeyNew = newRow.getPropKey();
                    Long ruleIdNew = newRow.getDataRule().getId();
                    boolean newFoundInOld = false;
                    for (DynamicObject oldRow : oldPropDoc) {
                        String propKeyOld = oldRow.getString("propkey");
                        Long dataRuleId3 = oldRow.getLong("propdatarule_id");
                        if (StringUtils.isEmpty((String)propKeyOld) || dataRuleId3 == null || dataRuleId3 == 0L || !propKeyOld.equals(propKeyNew) || !dataRuleId3.equals(ruleIdNew)) continue;
                        newFoundInOld = true;
                        break;
                    }
                    if (newFoundInOld) continue;
                    forAddRow.add(newRow);
                }
                if (!CollectionUtils.isEmpty(forDelRow)) {
                    oldPropDoc.removeAll(forDelRow);
                }
                if (!CollectionUtils.isEmpty(forAddRow)) {
                    for (DataRuleInfo.BdPropsDataRule newRow : forAddRow) {
                        DynamicObject propRuleNewRow = new DynamicObject(oldPropDoc.getDynamicObjectType());
                        propRuleNewRow.set("propkey", (Object)newRow.getPropKey());
                        propRuleNewRow.set("propent", (Object)newRow.getPropEntNum());
                        propRuleNewRow.set("propdatarule", (Object)newRow.getDataRule().getId());
                        oldPropDoc.add((Object)propRuleNewRow);
                    }
                }
            } else {
                oldPropDoc = oldDataRule.getDynamicObjectCollection("entryentity_prop");
                if (!CollectionUtils.isEmpty((Collection)oldPropDoc)) {
                    oldPropDoc.clear();
                }
            }
        }
        oldDataRule.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{oldDataRule});
        newDataRuleInfo.setId((Long)oldDataRule.getPkValue());
        return true;
    }

    public static DataRuleInfo[] queryDataRule(QFilter[] qfilters) {
        return DataRuleCache.queryDataRule(qfilters, null);
    }

    public static DataRuleInfo[] queryDataRule(QFilter[] qfilters, StringBuilder processInfo) {
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (qfilters == null || qfilters.length == 0) {
            processInfo.append(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return new DataRuleInfo[0];
        }
        String selProps = "bizapp" + ',' + "description" + ',' + "entity" + ',' + "isdetail" + ',' + "rule" + ',' + "datarule" + ',' + "permitem" + ',' + "propkey" + ',' + "propent" + ',' + "propdatarule";
        ArrayList<QFilter> qFilterLists = new ArrayList<QFilter>(Arrays.asList(qfilters));
        qFilterLists.add(new QFilter("enable", "=", (Object)DATARULE_APPLYSCOPE_ENT));
        DynamicObject[] loadArr = BusinessDataServiceHelper.load((String)"perm_datarule", (String)selProps, (QFilter[])qFilterLists.toArray(new QFilter[qFilterLists.size()]));
        if (loadArr == null || loadArr.length == 0) {
            processInfo.append(ResManager.loadKDString((String)"\u67e5\u65e0\u6570\u636e\u3002", (String)"DataRuleCache_32", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return new DataRuleInfo[0];
        }
        ArrayList<DataRuleInfo> result = new ArrayList<DataRuleInfo>(loadArr.length);
        for (DynamicObject loadDataRuleObj : loadArr) {
            DataRuleInfo dri = new DataRuleInfo();
            String appId = loadDataRuleObj.getString("bizapp.id");
            if (StringUtils.isNotEmpty((String)appId)) {
                dri.setAppId(appId);
            }
            dri.setDescription(loadDataRuleObj.getString("description"));
            boolean isDetail = loadDataRuleObj.getBoolean("isdetail");
            dri.setDetail(loadDataRuleObj.getBoolean("isdetail"));
            String entityNum = loadDataRuleObj.getString("entity.id");
            if (StringUtils.isNotEmpty((String)entityNum)) {
                dri.setEntityNum(entityNum);
            }
            dri.setId((Long)loadDataRuleObj.getPkValue());
            dri.setName(loadDataRuleObj.getLocaleString("name"));
            dri.setNumber(loadDataRuleObj.getString("number"));
            if (isDetail) {
                String ruleJson = loadDataRuleObj.getString("rule");
                if (StringUtils.isNotEmpty((String)ruleJson)) {
                    FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)loadDataRuleObj.getString("rule"), FilterCondition.class);
                    dri.setRule(filterCondition);
                }
            } else {
                DynamicObjectCollection bdPropsDataRule;
                FilterCondition filterCondition;
                String ruleJson;
                boolean enableDataRule;
                DynamicObjectCollection permItemsDataRule = loadDataRuleObj.getDynamicObjectCollection(ENTRYENTITY);
                if (!CollectionUtils.isEmpty((Collection)permItemsDataRule)) {
                    ArrayList<DataRuleInfo.PermItemsDataRule> permItemsDataRuleList = new ArrayList<DataRuleInfo.PermItemsDataRule>(permItemsDataRule.size());
                    for (DynamicObject row : permItemsDataRule) {
                        DataRuleInfo.PermItemsDataRule pidr = new DataRuleInfo.PermItemsDataRule();
                        DynamicObject permItemObj = row.getDynamicObject("permitem");
                        if (permItemObj != null) {
                            pidr.setPermItemId((String)permItemObj.getPkValue());
                        }
                        DynamicObject permItemDataRuleObj = row.getDynamicObject("datarule");
                        DataRuleInfo permItemDataRuleInfo = new DataRuleInfo();
                        if (permItemDataRuleObj == null) continue;
                        boolean permItemDataRuleIsDetail = permItemDataRuleObj.getBoolean("isdetail");
                        if (!permItemDataRuleIsDetail) {
                            processInfo.append(ResManager.loadKDString((String)"\u53d1\u73b0\u6743\u9650\u9879\u5206\u914d\u7684\u65b9\u6848\u4e0d\u662f\u660e\u7ec6\u65b9\u6848\uff0c\u53ef\u80fd\u6570\u636e\u6709\u95ee\u9898\u9700\u8981\u4fee\u590d\u3002", (String)"DataRuleCache_33", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                            return new DataRuleInfo[0];
                        }
                        enableDataRule = permItemDataRuleObj.getBoolean("enable");
                        if (!enableDataRule) continue;
                        permItemDataRuleInfo.setDetail(permItemDataRuleIsDetail);
                        permItemDataRuleInfo.setNumber(permItemDataRuleObj.getString("number"));
                        permItemDataRuleInfo.setId(Long.valueOf(permItemDataRuleObj.getLong("id")));
                        permItemDataRuleInfo.setName(permItemDataRuleObj.getLocaleString("name"));
                        permItemDataRuleInfo.setAppId(permItemDataRuleObj.getString("bizapp.id"));
                        permItemDataRuleInfo.setDescription(permItemDataRuleObj.getString("description"));
                        permItemDataRuleInfo.setEntityNum(permItemDataRuleObj.getString("entity.id"));
                        permItemDataRuleInfo.setEnable(Boolean.valueOf(enableDataRule));
                        ruleJson = permItemDataRuleObj.getString("rule");
                        if (!StringUtils.isNotEmpty((String)ruleJson)) continue;
                        filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)ruleJson, FilterCondition.class);
                        permItemDataRuleInfo.setRule(filterCondition);
                        pidr.setDataRule(permItemDataRuleInfo);
                        permItemsDataRuleList.add(pidr);
                    }
                    dri.setPermItemsDataRule(permItemsDataRuleList);
                }
                if (!CollectionUtils.isEmpty((Collection)(bdPropsDataRule = loadDataRuleObj.getDynamicObjectCollection("entryentity_prop")))) {
                    ArrayList<DataRuleInfo.BdPropsDataRule> bdPropsDataRuleList = new ArrayList<DataRuleInfo.BdPropsDataRule>(bdPropsDataRule.size());
                    for (DynamicObject row : bdPropsDataRule) {
                        DataRuleInfo.BdPropsDataRule bpdr = new DataRuleInfo.BdPropsDataRule();
                        bpdr.setPropKey(row.getString("propkey"));
                        bpdr.setPropEntNum(row.getString("propent.id"));
                        DynamicObject bdpropsDataRuleObj = row.getDynamicObject("propdatarule");
                        DataRuleInfo bdPropsDataRuleInfo = new DataRuleInfo();
                        if (bdpropsDataRuleObj == null) continue;
                        boolean bdPropsDataRuleIsDetail = bdpropsDataRuleObj.getBoolean("isdetail");
                        if (!bdPropsDataRuleIsDetail) {
                            processInfo.append(ResManager.loadKDString((String)"\u53d1\u73b0\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u7684\u65b9\u6848\u4e0d\u662f\u660e\u7ec6\u65b9\u6848\uff0c\u53ef\u80fd\u6570\u636e\u6709\u95ee\u9898\u9700\u8981\u4fee\u590d\u3002", (String)"DataRuleCache_34", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                            return new DataRuleInfo[0];
                        }
                        enableDataRule = bdpropsDataRuleObj.getBoolean("enable");
                        if (!enableDataRule) continue;
                        bdPropsDataRuleInfo.setDetail(true);
                        bdPropsDataRuleInfo.setNumber(bdpropsDataRuleObj.getString("number"));
                        bdPropsDataRuleInfo.setId(Long.valueOf(bdpropsDataRuleObj.getLong("id")));
                        bdPropsDataRuleInfo.setName(bdpropsDataRuleObj.getLocaleString("name"));
                        bdPropsDataRuleInfo.setAppId(bdpropsDataRuleObj.getString("bizapp.id"));
                        bdPropsDataRuleInfo.setDescription(bdpropsDataRuleObj.getString("description"));
                        bdPropsDataRuleInfo.setEntityNum(bdpropsDataRuleObj.getString("entity.id"));
                        bdPropsDataRuleInfo.setEnable(Boolean.valueOf(enableDataRule));
                        ruleJson = bdpropsDataRuleObj.getString("rule");
                        if (!StringUtils.isNotEmpty((String)ruleJson)) continue;
                        filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)ruleJson, FilterCondition.class);
                        bdPropsDataRuleInfo.setRule(filterCondition);
                        bpdr.setDataRule(bdPropsDataRuleInfo);
                        bdPropsDataRuleList.add(bpdr);
                    }
                    dri.setBdPropsDataRule(bdPropsDataRuleList);
                }
            }
            result.add(dri);
        }
        return result.toArray(new DataRuleInfo[result.size()]);
    }

    @Deprecated
    public static DataRulesInfo queryUserDatatRules(Long userId) {
        DataRulesInfo dri = new DataRulesInfo();
        return dri;
    }

    @Deprecated
    public static AssignDataRulesInfo queryUserDataRules(Long userId, String pAppId, String pEntityNum) {
        AssignDataRulesInfo adri = new AssignDataRulesInfo();
        return adri;
    }

    @Deprecated
    public static AssignDataRulesInfo queryUserDataRules(Long userId) {
        return DataRuleCache.queryUserDataRules(userId, "", "");
    }

    @Deprecated
    public static DataRulesInfo queryUserDataRules(Long userId, Long dimObjId, String dimType) {
        return DataRuleCache.queryUserDataRules(userId, dimObjId, dimType, false);
    }

    @Deprecated
    public static DataRulesInfo queryUserDataRules(Long userId, Long dimObjId, String dimType, boolean isIncludeSub) {
        DataRulesInfo drsi = new DataRulesInfo();
        return drsi;
    }

    @Deprecated
    public static DataRulesInfo queryRoleDatatRules(String roleId) {
        return DataRuleCache.queryCommonRoleDataRules(roleId);
    }

    public static Map<String, DataRulesInfo> queryCommonRoleDataRules(Collection<String> pComRoleIds) {
        return DataRuleCache.queryCommonRoleDataRules(pComRoleIds, false);
    }

    public static Map<String, DataRulesInfo> queryCommonRoleDataRules(Collection<String> pComRoleIds, boolean queryDisable) {
        if (CollectionUtils.isEmpty(pComRoleIds)) {
            return new HashMap<String, DataRulesInfo>();
        }
        if (!PermCommonUtil.hasEnableRoleDataRuleNewModel()) {
            return DataRuleCache.queryCommonRoleDataRulesDeprecated(pComRoleIds, queryDisable);
        }
        HashMap<String, DataRulesInfo> comRoleIdsAndDataRulesInfo = new HashMap<String, DataRulesInfo>(8);
        StringBuilder selectDataRulePermItem = new StringBuilder().append("select rdr.froleid roleid, ").append(" rdr.fappid appid, rdr.fentitynum entitynum, '' propkey, '' propentnum, rdr.fpermitemid permitemid, ").append(" dr.fid dataruleid, dr.frule drrule, dr.fenable drenable ").append(" from t_perm_roledatarule rdr ").append(" join t_perm_datarule dr on (rdr.fdataruleid = dr.fid ");
        if (!queryDisable) {
            selectDataRulePermItem.append(" and dr.fenable = '1' ");
        }
        selectDataRulePermItem.append(" ) ");
        selectDataRulePermItem.append(" where rdr.froleid in(").append(ListUtil.getSqlList(pComRoleIds)).append(")");
        StringBuilder selectDataRuleProp = new StringBuilder().append("select rdrp.froleid roleid, ").append(" rdrp.fappid appid, rdrp.fentitynum entitynum, ").append(" rdrp.fpropkey propkey, rdrp.fpropentnum propentnum, '' permitemid, ").append(" dr.fid dataruleid, dr.frule drrule, dr.fenable drenable ").append(" from t_perm_roledatarule_prop rdrp ").append(" join t_perm_datarule dr on (rdrp.fdataruleid = dr.fid ");
        if (!queryDisable) {
            selectDataRuleProp.append(" and dr.fenable = '1' ");
        }
        selectDataRuleProp.append(" ) ");
        selectDataRuleProp.append(" where rdrp.froleid in(").append(ListUtil.getSqlList(pComRoleIds)).append(")");
        try (DataSet selectDataRulePermItemDS = DB.queryDataSet((String)"DataRuleCache_queryCommonRoleDataRules_selectDataRuleEntryDS", (DBRoute)DBRoute.permission, (String)selectDataRulePermItem.toString());
             DataSet selectDataRulePropDS = DB.queryDataSet((String)"DataRuleCache_queryCommonRoleDataRules_selectDataRulePropDS", (DBRoute)DBRoute.permission, (String)selectDataRuleProp.toString());
             DataSet finalDS = selectDataRulePermItemDS.union(selectDataRulePropDS).orderBy(new String[]{"roleid", "appid", "entitynum", "permitemid"});){
            String roleId = "";
            String appId = "";
            String entityNum = "";
            EntDataRuleInfo entDataRuleInfo = null;
            while (finalDS.hasNext()) {
                FilterCondition filterCondition;
                DataRuleInfo dataRuleInfo;
                Row data = finalDS.next();
                String roleIdTemp = data.getString("roleid");
                String appIdTemp = data.getString("appid");
                String entityNumTemp = data.getString("entitynum");
                String permItemId = data.getString("permitemid");
                String propKey = data.getString("propkey");
                String propentNum = data.getString("propentnum");
                String rule = data.getString("drrule");
                Long dataRuleId = data.getLong("dataruleid");
                Boolean enable = data.getBoolean("drenable");
                boolean bEnable = false;
                if (enable != null) {
                    bEnable = enable;
                }
                boolean isAdd = false;
                boolean roleChange = false;
                if (!roleId.equals(roleIdTemp)) {
                    roleId = roleIdTemp;
                    roleChange = true;
                    comRoleIdsAndDataRulesInfo.computeIfAbsent(roleIdTemp, k -> new DataRulesInfo());
                }
                DataRulesInfo dRsInfo = (DataRulesInfo)comRoleIdsAndDataRulesInfo.get(roleIdTemp);
                if (!appId.equals(appIdTemp) || !entityNum.equals(entityNumTemp) || roleChange) {
                    appId = appIdTemp;
                    entityNum = entityNumTemp;
                    entDataRuleInfo = new EntDataRuleInfo();
                    entDataRuleInfo.setAppId(appId);
                    entDataRuleInfo.setEntityNum(entityNum);
                    isAdd = true;
                }
                if (StringUtils.isNotEmpty((String)permItemId) && entDataRuleInfo != null) {
                    EntDataRuleInfo.PermItemsDataRule permItemsDataRule = new EntDataRuleInfo.PermItemsDataRule();
                    permItemsDataRule.setPermItemId(permItemId);
                    dataRuleInfo = new DataRuleInfo();
                    dataRuleInfo.setEntityNum(entityNumTemp);
                    dataRuleInfo.setAppId(appIdTemp);
                    filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rule, FilterCondition.class);
                    dataRuleInfo.setRule(filterCondition);
                    dataRuleInfo.setId(dataRuleId);
                    dataRuleInfo.setEnable(Boolean.valueOf(bEnable));
                    permItemsDataRule.setDataRule(dataRuleInfo);
                    entDataRuleInfo.getPermItemsDataRule().add(permItemsDataRule);
                }
                if (StringUtils.isNotEmpty((String)propKey) && entDataRuleInfo != null) {
                    EntDataRuleInfo.BdPropsDataRule bdPropsDataRule = new EntDataRuleInfo.BdPropsDataRule();
                    bdPropsDataRule.setPropKey(propKey);
                    bdPropsDataRule.setPropEntNum(propentNum);
                    dataRuleInfo = new DataRuleInfo();
                    dataRuleInfo.setEntityNum(propentNum);
                    dataRuleInfo.setEnable(Boolean.TRUE);
                    filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rule, FilterCondition.class);
                    dataRuleInfo.setRule(filterCondition);
                    dataRuleInfo.setId(dataRuleId);
                    bdPropsDataRule.setDataRule(dataRuleInfo);
                    entDataRuleInfo.getBdPropsDataRule().add(bdPropsDataRule);
                }
                if (!isAdd) continue;
                dRsInfo.getEntDataRuleInfos().add(entDataRuleInfo);
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return comRoleIdsAndDataRulesInfo;
    }

    @Deprecated
    private static Map<String, DataRulesInfo> queryCommonRoleDataRulesDeprecated(Collection<String> pComRoleIds, boolean queryDisable) {
        HashMap<String, DataRulesInfo> comRoleIdsAndDataRulesInfo = new HashMap<String, DataRulesInfo>(8);
        StringBuilder selectDataRuleEntry = new StringBuilder().append("select rdrs.froleid roleid, drs.fid drsid, drs.fnumber drsnum, drs.fname drsname, ").append(" drse.fbizappid appid, drse.fentitynum entitynum, drse.fdataruleid drse_dataruleid, ").append(" '' propkey, '' propentnum, dre.fpermitemid permitemid, dr.fid dataruleid, dr.frule ").append("from t_perm_roledatarules rdrs ").append("join t_perm_datarules drs on (rdrs.fdatarulesid = drs.fid) ").append("join t_perm_datarules_entry drse on (drs.fid = drse.fid) ").append("join t_perm_datarule_entry dre on (drse.fdataruleid = dre.fid) ").append("join t_perm_datarule dr on (dre.fdataruleid = dr.fid and dr.fisdetail = '1' ");
        if (!queryDisable) {
            selectDataRuleEntry.append(" and dr.fenable = '1' ");
        }
        selectDataRuleEntry.append(" ) ");
        selectDataRuleEntry.append(" where rdrs.froleid in(").append(ListUtil.getSqlList(pComRoleIds)).append(")");
        StringBuilder selectDataRuleProp = new StringBuilder().append("select rdrs.froleid roleid, drs.fid drsid, drs.fnumber drsnum, drs.fname drsname, ").append(" drse.fbizappid appid, drse.fentitynum entitynum, drse.fdataruleid drse_dataruleid, ").append(" drp.fpropkey propkey, drp.fpropentnum propentnum, '' permitemid, dr.fid dataruleid, dr.frule").append(" from t_perm_roledatarules rdrs ").append("join t_perm_datarules drs on (rdrs.fdatarulesid = drs.fid) ").append("join t_perm_datarules_entry drse on (drs.fid = drse.fid)").append("join t_perm_datarule_prop drp on (drse.fdataruleid = drp.fid) ").append("join t_perm_datarule dr on (drp.fdataruleid = dr.fid and dr.fisdetail = '1' ");
        if (!queryDisable) {
            selectDataRuleProp.append(" and dr.fenable = '1' ");
        }
        selectDataRuleProp.append(" ) ");
        selectDataRuleProp.append(" where rdrs.froleid in(").append(ListUtil.getSqlList(pComRoleIds)).append(")");
        try (DataSet selectDataRuleEntryDS = DB.queryDataSet((String)"DataRuleCache_queryCommonRoleDataRulesDeprecated_selectDataRuleEntryDS", (DBRoute)DBRoute.permission, (String)selectDataRuleEntry.toString());
             DataSet selectDataRulePropDS = DB.queryDataSet((String)"DataRuleCache_queryCommonRoleDataRulesDeprecated_selectDataRulePropDS", (DBRoute)DBRoute.permission, (String)selectDataRuleProp.toString());
             DataSet finalDS = selectDataRuleEntryDS.union(selectDataRulePropDS).orderBy(new String[]{"roleid", "appid", "entitynum", "permitemid"});){
            String roleId = "";
            String appId = "";
            String entityNum = "";
            DataRulesInfo.DataRulesEntryInfo entryInfos = null;
            while (finalDS.hasNext()) {
                FilterCondition filterCondition;
                DataRuleInfo dataRuleInfo;
                Row data = finalDS.next();
                String roleIdTemp = data.getString("roleid");
                String datarulesNum = data.getString("drsnum");
                String datarulesName = data.getString("drsname");
                String appIdTemp = data.getString("appid");
                String entityNumTemp = data.getString("entitynum");
                String propKey = data.getString("propkey");
                String propentNum = data.getString("propentnum");
                String permItemId = data.getString("permitemid");
                String rule = data.getString("frule");
                Long dataRuleId = data.getLong("dataruleid");
                Long dataRulesId = data.getLong("drsid");
                Long drse_dataruleid = data.getLong("drse_dataruleid");
                boolean isAdd = false;
                boolean roleChange = false;
                if (!roleId.equals(roleIdTemp)) {
                    roleId = roleIdTemp;
                    roleChange = true;
                    comRoleIdsAndDataRulesInfo.computeIfAbsent(roleIdTemp, k -> new DataRulesInfo());
                }
                DataRulesInfo dRsInfo = (DataRulesInfo)comRoleIdsAndDataRulesInfo.get(roleIdTemp);
                if (!appId.equals(appIdTemp) || !entityNum.equals(entityNumTemp) || roleChange) {
                    appId = appIdTemp;
                    entityNum = entityNumTemp;
                    DataRuleInfo dataRuleInfo2 = new DataRuleInfo();
                    dataRuleInfo2.setId(drse_dataruleid);
                    dataRuleInfo2.setNumber(datarulesNum);
                    dataRuleInfo2.setName((ILocaleString)new LocaleString(datarulesName));
                    dataRuleInfo2.setEntityNum(entityNumTemp);
                    dataRuleInfo2.setAppId(appIdTemp);
                    dataRuleInfo2.setDetail(false);
                    entryInfos = new DataRulesInfo.DataRulesEntryInfo();
                    isAdd = true;
                    entryInfos.setDataRule(dataRuleInfo2);
                    entryInfos.setEntityNum(entityNumTemp);
                    entryInfos.setAppId(appIdTemp);
                }
                if (StringUtils.isNotEmpty((String)permItemId) && entryInfos != null) {
                    DataRuleInfo.PermItemsDataRule permItemsDataRule = new DataRuleInfo.PermItemsDataRule();
                    permItemsDataRule.setPermItemId(permItemId);
                    permItemsDataRule.setEntityNum(entityNumTemp);
                    dataRuleInfo = new DataRuleInfo();
                    dataRuleInfo.setEntityNum(entityNumTemp);
                    dataRuleInfo.setAppId(appIdTemp);
                    filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rule, FilterCondition.class);
                    dataRuleInfo.setRule(filterCondition);
                    dataRuleInfo.setId(dataRuleId);
                    dataRuleInfo.setEnable(Boolean.TRUE);
                    permItemsDataRule.setDataRule(dataRuleInfo);
                    entryInfos.getDataRule().getPermItemsDataRule().add(permItemsDataRule);
                }
                if (StringUtils.isNotEmpty((String)propKey) && entryInfos != null) {
                    DataRuleInfo.BdPropsDataRule bdPropsDataRule = new DataRuleInfo.BdPropsDataRule();
                    bdPropsDataRule.setPropKey(propKey);
                    bdPropsDataRule.setPropEntNum(propentNum);
                    dataRuleInfo = new DataRuleInfo();
                    dataRuleInfo.setEntityNum(propentNum);
                    dataRuleInfo.setEnable(Boolean.TRUE);
                    filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)rule, FilterCondition.class);
                    dataRuleInfo.setRule(filterCondition);
                    dataRuleInfo.setId(dataRuleId);
                    bdPropsDataRule.setDataRule(dataRuleInfo);
                    entryInfos.getDataRule().getBdPropsDataRule().add(bdPropsDataRule);
                }
                if (!isAdd) continue;
                dRsInfo.setId(dataRulesId);
                dRsInfo.getEntryInfos().add(entryInfos);
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return comRoleIdsAndDataRulesInfo;
    }

    @Deprecated
    public static DataRulesInfo queryCommonRoleDataRules(String pComRoleId) {
        DynamicObject roleDataRulesObj = BusinessDataServiceHelper.loadSingle((String)"perm_roledatarules", (String)"datarules", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)pComRoleId)});
        if (roleDataRulesObj == null) {
            return null;
        }
        DynamicObject dataRulesObj = roleDataRulesObj.getDynamicObject("datarules");
        if (dataRulesObj == null) {
            return null;
        }
        DynamicObjectCollection entryDoc = (dataRulesObj = BusinessDataServiceHelper.loadSingle((Object)dataRulesObj.getPkValue(), (String)"perm_datarules", (String)"id,bizapp,entity,datarule,modifier,modifytime,creator,createtime,number,name")).getDynamicObjectCollection(ENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)entryDoc)) {
            return null;
        }
        DataRulesInfo dataRulesInfo = new DataRulesInfo();
        dataRulesInfo.setId((Long)dataRulesObj.getPkValue());
        dataRulesInfo.setNumber(dataRulesObj.getString("number"));
        dataRulesInfo.setName(dataRulesObj.getLocaleString("name"));
        ArrayList<DataRulesInfo.DataRulesEntryInfo> entryInfos = new ArrayList<DataRulesInfo.DataRulesEntryInfo>(8);
        for (DynamicObject rowObj : entryDoc) {
            DataRulesInfo.DataRulesEntryInfo drei = new DataRulesInfo.DataRulesEntryInfo();
            drei.setAppId(rowObj.getString("bizapp_id"));
            drei.setEntityNum(rowObj.getString("entity_id"));
            Long dataRuleId = rowObj.getLong("datarule_id");
            StringBuilder processInfo = new StringBuilder();
            Object[] queryDataRule = DataRuleCache.queryDataRule(new QFilter[]{new QFilter("id", "=", (Object)dataRuleId)}, processInfo);
            if (ArrayUtils.isNotEmpty((Object[])queryDataRule)) {
                drei.setDataRule((DataRuleInfo)queryDataRule[0]);
            }
            entryInfos.add(drei);
        }
        dataRulesInfo.setEntryInfos(entryInfos);
        return dataRulesInfo;
    }

    @Deprecated
    public static boolean userAssignDataRules(Long userId, DataRulesInfo dataRulesInfo, String assignMode) {
        return DataRuleCache.userAssignDataRules(userId, dataRulesInfo, assignMode, null);
    }

    @Deprecated
    public static boolean userAssignDataRules(Long userId, DataRulesInfo dataRulesInfo, String assignMode, StringBuilder processInfo) {
        return false;
    }

    @Deprecated
    public static boolean userAssignDataRules(Long userId, AssignDataRulesInfo assignDataRulesInfo, String assignMode, StringBuilder processInfo) {
        return false;
    }

    @Deprecated
    public static boolean roleAssignDataRules(String roleId, DataRulesInfo dataRulesInfo, String assignMode, StringBuilder processInfo) {
        DynamicObject dataRulesObj;
        List entryInfos;
        if (processInfo == null) {
            processInfo = new StringBuilder();
        }
        if (roleId == null) {
            processInfo.append(ResManager.loadKDString((String)"roleId\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_35", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        boolean isAdd = true;
        if (AssignModEnum.ASSIGNMODE_CANCEL.getCode().equals(assignMode)) {
            isAdd = false;
        }
        if (isAdd) {
            if (dataRulesInfo == null) {
                processInfo.append(ResManager.loadKDString((String)"\u5206\u914d\u6570\u636e\u89c4\u5219\u65f6\uff0cdataRulesInfo\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_36", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            entryInfos = dataRulesInfo.getEntryInfos();
            if (CollectionUtils.isEmpty((Collection)entryInfos)) {
                processInfo.append(ResManager.loadKDString((String)"\u5206\u914d\u6570\u636e\u89c4\u5219\u65f6\uff0cdataRulesInfo\u7684\u5206\u5f55entryInfos\u4e0d\u80fd\u90fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_37", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
            for (DataRulesInfo.DataRulesEntryInfo drei : entryInfos) {
                DataRuleInfo dri = drei.getDataRule();
                if (dri == null) {
                    processInfo.append(ResManager.loadKDString((String)"\u5206\u914d\u6570\u636e\u89c4\u5219\u65f6\uff0c\u53d1\u73b0\u5168\u90e8\u6216\u90e8\u5206\u5b9e\u4f53\u7684\u6570\u636e\u89c4\u5219\u4fe1\u606f\uff08DataRuleInfo\uff09\u4e3a\u7a7a\u3002", (String)"DataRuleCache_38", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    return false;
                }
                if (!dri.isDetail()) continue;
                processInfo.append(ResManager.loadKDString((String)"\u5206\u914d\u6570\u636e\u89c4\u5219\u65f6\uff0c\u53d1\u73b0\u5168\u90e8\u6216\u90e8\u5206\u5b9e\u4f53\u7684\u6570\u636e\u89c4\u5219\u4fe1\u606f\uff08DataRuleInfo\uff09\u662f\u660e\u7ec6\u65b9\u6848\uff0c\u5e94\u4e3a\u975e\u660e\u7ec6\uff0c\u8bf7\u8c03\u6574\u3002", (String)"DataRuleCache_39", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
        } else if (dataRulesInfo != null && CollectionUtils.isEmpty((Collection)(entryInfos = dataRulesInfo.getEntryInfos()))) {
            processInfo.append(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u6570\u636e\u89c4\u5219\u65f6\uff0c\u5982\u679c\u6307\u5b9a\u4e86dataRulesInfo\uff0c\u5206\u5f55entryInfos\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_40", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        Date now = new Date();
        DynamicObject roleDataRuleObj = BusinessDataServiceHelper.loadSingle((String)"perm_roledatarules", (String)"id,datarules,role,modifier,modifytime,createtime,creator", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (isAdd) {
            ILocaleString name;
            DynamicObjectType rowType;
            DynamicObjectCollection entDoc;
            dataRulesObj = null;
            if (roleDataRuleObj == null) {
                roleDataRuleObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_roledatarules");
                roleDataRuleObj.set("role", (Object)roleId);
                dataRulesObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_datarules");
                entDoc = dataRulesObj.getDynamicObjectCollection(ENTRYENTITY);
                rowType = entDoc.getDynamicObjectType();
                List entryInfos2 = dataRulesInfo.getEntryInfos();
                for (DataRulesInfo.DataRulesEntryInfo drei : entryInfos2) {
                    DynamicObject rowObj = new DynamicObject(rowType);
                    rowObj.set("bizapp", (Object)drei.getAppId());
                    rowObj.set("entity", (Object)drei.getEntityNum());
                    DataRuleInfo dri = drei.getDataRule();
                    if (dri == null) continue;
                    Long dataRuleId = dri.getId();
                    if (dataRuleId == null) {
                        StringBuilder newDataRuleProcessInfo = new StringBuilder();
                        DataRuleCache.newDataRule(dri, newDataRuleProcessInfo);
                        dataRuleId = dri.getId();
                    } else {
                        StringBuilder modifyDataRuleProcessInfo = new StringBuilder();
                        DataRuleCache.modifyDataRule(dataRuleId, dri, modifyDataRuleProcessInfo);
                    }
                    rowObj.set("datarule", (Object)dataRuleId);
                    entDoc.add((Object)rowObj);
                }
                dataRulesObj.set("creator", (Object)userId);
                dataRulesObj.set("createtime", (Object)now);
                dataRulesObj.set("status", (Object)"C");
                dataRulesObj.set("enable", (Object)DATARULE_APPLYSCOPE_ENT);
                roleDataRuleObj.set("creator", (Object)userId);
                roleDataRuleObj.set("createtime", (Object)now);
            } else {
                dataRulesObj = roleDataRuleObj.getDynamicObject("datarules");
                dataRulesObj = BusinessDataServiceHelper.loadSingle((Object)dataRulesObj.getPkValue(), (String)"perm_datarules", (String)"id,bizapp,entity,datarule,modifier,modifytime,creator,createtime,number,name");
                entDoc = dataRulesObj.getDynamicObjectCollection(ENTRYENTITY);
                rowType = entDoc.getDynamicObjectType();
                List entryInfos3 = dataRulesInfo.getEntryInfos();
                if (AssignModEnum.ASSIGNMODE_REPLACE.getCode().equals(assignMode)) {
                    entDoc.clear();
                    for (DataRulesInfo.DataRulesEntryInfo drei : entryInfos3) {
                        DynamicObject rowObj = new DynamicObject(rowType);
                        rowObj.set("bizapp", (Object)drei.getAppId());
                        rowObj.set("entity", (Object)drei.getEntityNum());
                        DataRuleInfo dri = drei.getDataRule();
                        if (dri == null) continue;
                        Long dataRuleId = dri.getId();
                        if (dataRuleId == null) {
                            StringBuilder newDataRuleProcessInfo = new StringBuilder();
                            DataRuleCache.newDataRule(dri, newDataRuleProcessInfo);
                            dataRuleId = dri.getId();
                        } else {
                            StringBuilder modifyDataRuleProcessInfo = new StringBuilder();
                            DataRuleCache.modifyDataRule(dataRuleId, dri, modifyDataRuleProcessInfo);
                        }
                        rowObj.set("datarule", (Object)dataRuleId);
                        entDoc.add((Object)rowObj);
                    }
                } else if (AssignModEnum.ASSIGNMODE_INCREMENT.getCode().equals(assignMode)) {
                    for (DataRulesInfo.DataRulesEntryInfo drei : entryInfos3) {
                        String appIdNew = drei.getAppId();
                        String entNumNew = drei.getEntityNum();
                        DataRuleInfo dri = drei.getDataRule();
                        if (dri == null) continue;
                        Long dataRuleId = dri.getId();
                        if (dataRuleId == null) {
                            StringBuilder newDataRuleProcessInfo = new StringBuilder();
                            boolean newDataRule = DataRuleCache.newDataRule(dri, newDataRuleProcessInfo);
                            if (!newDataRule) {
                                processInfo.append((CharSequence)newDataRuleProcessInfo);
                                return false;
                            }
                            dataRuleId = dri.getId();
                        } else {
                            StringBuilder modifyDataRuleProcessInfo = new StringBuilder();
                            boolean modifyDataRule = DataRuleCache.modifyDataRule(dataRuleId, dri, modifyDataRuleProcessInfo);
                            if (!modifyDataRule) {
                                processInfo.append((CharSequence)modifyDataRuleProcessInfo);
                                return false;
                            }
                        }
                        boolean newFindInOld = false;
                        for (DynamicObject rowObj : entDoc) {
                            String appIdOld = rowObj.getString("bizapp.id");
                            String entNumOld = rowObj.getString("entity.id");
                            if (StringUtils.isEmpty((String)appIdOld) || StringUtils.isEmpty((String)entNumOld) || !appIdOld.equals(appIdNew) || !entNumOld.equals(entNumNew)) continue;
                            rowObj.set("datarule", (Object)dataRuleId);
                            newFindInOld = true;
                            break;
                        }
                        if (newFindInOld) continue;
                        DynamicObject rowObj = new DynamicObject(rowType);
                        rowObj.set("bizapp", (Object)drei.getAppId());
                        rowObj.set("entity", (Object)drei.getEntityNum());
                        rowObj.set("datarule", (Object)dataRuleId);
                        entDoc.add((Object)rowObj);
                    }
                    dataRulesObj.set("modifier", (Object)userId);
                    dataRulesObj.set("modifytime", (Object)now);
                }
                roleDataRuleObj.set("modifier", (Object)userId);
                roleDataRuleObj.set("modifytime", (Object)now);
            }
            String number = dataRulesInfo.getNumber();
            if (StringUtils.isNotEmpty((String)number)) {
                dataRulesObj.set("number", (Object)number);
            }
            if ((name = dataRulesInfo.getName()) != null) {
                dataRulesObj.set("name", (Object)name);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataRulesObj});
            roleDataRuleObj.set("datarules", dataRulesObj.getPkValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{roleDataRuleObj});
        } else {
            if (roleDataRuleObj == null) {
                processInfo.append(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u9700\u8981\u5220\u9664\u7684\u8bb0\u5f55\u3002", (String)"DataRuleCache_41", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return true;
            }
            dataRulesObj = roleDataRuleObj.getDynamicObject("datarules");
            if ((dataRulesObj = BusinessDataServiceHelper.loadSingle((Object)dataRulesObj.getPkValue(), (String)"perm_datarules", (String)"id,bizapp,entity,datarule,modifier,modifytime,creator,createtime,number,name")) == null) {
                DeleteServiceHelper.delete((String)"perm_roledatarules", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)roleId)});
                processInfo.append(ResManager.loadKDString((String)"\u53d1\u73b0\u6570\u636e\u89c4\u5219\u96c6\u5408\u7684\u5f15\u7528\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"DataRuleCache_42", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return true;
            }
            DynamicObjectCollection entDoc = dataRulesObj.getDynamicObjectCollection(ENTRYENTITY);
            if (CollectionUtils.isEmpty((Collection)entDoc)) {
                DeleteServiceHelper.delete((String)"perm_datarules", (QFilter[])new QFilter[]{new QFilter("id", "=", dataRulesObj.getPkValue())});
            }
            if (dataRulesInfo == null) {
                DeleteServiceHelper.delete((String)"perm_roledatarules", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)roleId)});
                processInfo.append(ResManager.loadKDString((String)"\u89d2\u8272\u4e0b\u6240\u6709\u6570\u636e\u89c4\u5219\u6e05\u7a7a\u6210\u529f\u3002", (String)"DataRuleCache_43", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return true;
            }
            List entryInfos4 = dataRulesInfo.getEntryInfos();
            Iterator iter = entDoc.iterator();
            while (iter.hasNext()) {
                DynamicObject entRow = (DynamicObject)iter.next();
                for (DataRulesInfo.DataRulesEntryInfo dataRulesEntryInfo : entryInfos4) {
                    String appId1 = entRow.getString("bizapp.id");
                    String entityNum1 = entRow.getString("entity.id");
                    if (StringUtils.isEmpty((String)appId1) || StringUtils.isEmpty((String)entityNum1)) {
                        iter.remove();
                        continue;
                    }
                    String appId2 = dataRulesEntryInfo.getAppId();
                    String entityNum2 = dataRulesEntryInfo.getEntityNum();
                    if (!appId1.equals(appId2) || !entityNum1.equals(entityNum2)) continue;
                    iter.remove();
                }
            }
            TXHandle h = TX.required();
            Object object = null;
            try {
                try {
                    if (CollectionUtils.isEmpty((Collection)entDoc)) {
                        DeleteServiceHelper.delete((String)"perm_datarules", (QFilter[])new QFilter[]{new QFilter("id", "=", dataRulesObj.getPkValue())});
                        DeleteServiceHelper.delete((String)"perm_roledatarules", (QFilter[])new QFilter[]{new QFilter("role", "=", (Object)roleId)});
                    } else {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataRulesObj});
                    }
                }
                catch (Exception e) {
                    logger.warn("\u89d2\u8272\u6570\u636e\u89c4\u5219\u4fdd\u5b58\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
                    h.markRollback();
                    boolean bl = false;
                    if (h != null) {
                        if (object != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (h != null) {
                    if (object != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        return true;
    }

    public static PermResult roleAssignDataRule(String roleId, List<NewDrPerm> permItemDataRules, AssignModEnum assignMode) {
        Object uniqueStr;
        if (roleId == null) {
            return PermResult.fail((String)ResManager.loadKDString((String)"roleId\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_35", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        boolean isAdd = true;
        if (AssignModEnum.ASSIGNMODE_CANCEL.equals((Object)assignMode)) {
            isAdd = false;
        }
        if (isAdd) {
            if (permItemDataRules == null || permItemDataRules.isEmpty()) {
                return PermResult.fail((String)ResManager.loadKDString((String)"permItemDataRules\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_55", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            HashSet uniqueStrSet = new HashSet(8);
            for (NewDrPerm newDrPerm : permItemDataRules) {
                String appId = newDrPerm.getAppId();
                String entNum = newDrPerm.getEntityNumber();
                String permItemId = newDrPerm.getPermItemId();
                Long dataRuleId = newDrPerm.getDataRuleId();
                if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entNum) || StringUtils.isEmpty((String)permItemId) || dataRuleId == null || dataRuleId == 0L) {
                    return PermResult.fail((String)ResManager.loadKDString((String)"\u5165\u53c2permItemDataRules\u4e2d\u7684\u5143\u7d20\u7684\u5e94\u7528ID\uff0c\u5b9e\u4f53\u7f16\u7801\uff0c\u6743\u9650\u9879ID\u6216\u6570\u636e\u89c4\u5219\u65b9\u6848ID\u90fd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_56", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                uniqueStr = appId + entNum + permItemId + dataRuleId;
                boolean alreadyContainFlag = uniqueStrSet.add(uniqueStr);
                if (alreadyContainFlag) continue;
                return PermResult.fail((String)ResManager.loadKDString((String)"\u5165\u53c2permItemDataRules\u4e2d\u7684\u5143\u7d20\u7684\u5e94\u7528ID\uff0c\u5b9e\u4f53\u7f16\u7801\uff0c\u6743\u9650\u9879ID\u548c\u6570\u636e\u89c4\u5219\u65b9\u6848ID\u7684\u7ec4\u5408\u4e0d\u80fd\u91cd\u590d\u3002", (String)"DataRuleCache_64", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        } else if (permItemDataRules != null && !permItemDataRules.isEmpty()) {
            for (NewDrPerm newDrPerm : permItemDataRules) {
                String appId = newDrPerm.getAppId();
                String entNum = newDrPerm.getEntityNumber();
                String permItemId = newDrPerm.getPermItemId();
                if (!StringUtils.isEmpty((String)appId) && !StringUtils.isEmpty((String)entNum) && !StringUtils.isEmpty((String)permItemId)) continue;
                return PermResult.fail((String)ResManager.loadKDString((String)"\u5165\u53c2permItemDataRules\u4e2d\u7684\u5143\u7d20\u7684\u5e94\u7528ID\uff0c\u5b9e\u4f53\u7f16\u7801\uff0c\u6216\u6743\u9650\u9879ID\u90fd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_57", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
        TXHandle h = TX.required();
        Object object = null;
        try {
            PermResult forNewList;
            Date now = new Date();
            long userId = RequestContext.get().getCurrUserId();
            OperateOption operOpt = OperateOption.create();
            DynamicObject[] roleDataRuleObjArr = BusinessDataServiceHelper.load((String)"perm_roledatarule", (String)"role, app, entity, permitem, datarule, creator, createtime, modifier, modifytime", (QFilter[])new QFilter("role", "=", (Object)roleId).toArray());
            if (AssignModEnum.ASSIGNMODE_REPLACE.equals((Object)assignMode)) {
                uniqueStr = OperationServiceHelper.executeOperate((String)"delete", (String)"perm_roledatarule", (DynamicObject[])roleDataRuleObjArr, (OperateOption)operOpt);
            }
            if (isAdd) {
                boolean bl;
                forNewList = new ArrayList(8);
                HashMap<DynamicObject, NewDrPerm> forUpdateMap = new HashMap<DynamicObject, NewDrPerm>(8);
                for (NewDrPerm newDrPerm : permItemDataRules) {
                    String pAppId = newDrPerm.getAppId();
                    String string = newDrPerm.getEntityNumber();
                    String pPermItemId = newDrPerm.getPermItemId();
                    Long pDataRuleId = newDrPerm.getDataRuleId();
                    boolean foundSameFlag = false;
                    boolean foundFlag = false;
                    if (roleDataRuleObjArr != null && roleDataRuleObjArr.length != 0) {
                        for (DynamicObject roleDataRuleObj : roleDataRuleObjArr) {
                            boolean matchKeyFieldFlag;
                            String appId = roleDataRuleObj.getString("app_id");
                            String entityNum = roleDataRuleObj.getString("entity_id");
                            String permItemId = roleDataRuleObj.getString("permitem_id");
                            Long dataRuleId = roleDataRuleObj.getLong("datarule_id");
                            boolean bl2 = matchKeyFieldFlag = Objects.equals(pAppId, appId) && Objects.equals(string, entityNum) && Objects.equals(pPermItemId, permItemId);
                            if (matchKeyFieldFlag && Objects.equals(pDataRuleId, dataRuleId)) {
                                foundSameFlag = true;
                                foundFlag = true;
                                break;
                            }
                            if (!matchKeyFieldFlag) continue;
                            forUpdateMap.put(roleDataRuleObj, newDrPerm);
                            foundFlag = true;
                        }
                        if (foundSameFlag) continue;
                    }
                    if (foundFlag) continue;
                    forNewList.add(newDrPerm);
                }
                ArrayList<DynamicObject> allForInsertObjs = new ArrayList<DynamicObject>(8);
                for (Object newDr : forNewList) {
                    String string = newDr.getAppId();
                    String pEntNum = newDr.getEntityNumber();
                    String pPermItemId = newDr.getPermItemId();
                    Long pDataRuleId = newDr.getDataRuleId();
                    DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_roledatarule");
                    newObj.set("role", (Object)roleId);
                    newObj.set("app", (Object)string);
                    newObj.set("entity", (Object)pEntNum);
                    newObj.set("permitem", (Object)pPermItemId);
                    newObj.set("datarule", (Object)pDataRuleId);
                    newObj.set("creator", (Object)userId);
                    newObj.set("createtime", (Object)now);
                    allForInsertObjs.add(newObj);
                }
                ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(8);
                for (Map.Entry entry : forUpdateMap.entrySet()) {
                    DynamicObject updateObj = (DynamicObject)entry.getKey();
                    NewDrPerm newDr = (NewDrPerm)entry.getValue();
                    String pAppId = newDr.getAppId();
                    String pEntNum = newDr.getEntityNumber();
                    String pPermItemId = newDr.getPermItemId();
                    Long pDataRuleId = newDr.getDataRuleId();
                    updateObj.set("app", (Object)pAppId);
                    updateObj.set("entity", (Object)pEntNum);
                    updateObj.set("permitem", (Object)pPermItemId);
                    updateObj.set("datarule", (Object)pDataRuleId);
                    updateObj.set("modifier", (Object)userId);
                    updateObj.set("modifytime", (Object)now);
                    arrayList.add(updateObj);
                }
                boolean insertObjsNotEmptyFlag = !CollectionUtils.isEmpty(allForInsertObjs);
                boolean bl3 = bl = !CollectionUtils.isEmpty(arrayList);
                if (insertObjsNotEmptyFlag || bl) {
                    PermResult permResult;
                    OperationResult opResult = null;
                    if (insertObjsNotEmptyFlag) {
                        opResult = OperationServiceHelper.executeOperate((String)"save", (String)"perm_roledatarule", (DynamicObject[])allForInsertObjs.toArray(new DynamicObject[allForInsertObjs.size()]), (OperateOption)operOpt);
                    }
                    if (opResult != null && !opResult.isSuccess()) {
                        permResult = OperationHelper.returnPermResultByOpResult(opResult);
                        return permResult;
                    }
                    if (bl) {
                        opResult = OperationServiceHelper.executeOperate((String)"save", (String)"perm_roledatarule", (DynamicObject[])arrayList.toArray(new DynamicObject[arrayList.size()]), (OperateOption)operOpt);
                    }
                    permResult = OperationHelper.returnPermResultByOpResult(opResult);
                    return permResult;
                }
                PermResult permResult = PermResult.ok((Object)"No data to add or update.");
                return permResult;
            }
            if (roleDataRuleObjArr == null || roleDataRuleObjArr.length == 0) {
                forNewList = PermResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u901a\u7528\u89d2\u8272\u65e0\u4efb\u4f55\u6743\u9650\u9879\u4e0b\u7684\u6570\u636e\u89c4\u5219\u914d\u7f6e\u3002", (String)"DataRuleCache_58", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return forNewList;
            }
            if (permItemDataRules == null || permItemDataRules.isEmpty()) {
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"delete", (String)"perm_roledatarule", (DynamicObject[])roleDataRuleObjArr, (OperateOption)operOpt);
                PermResult forUpdateMap = OperationHelper.returnPermResultByOpResult(opResult);
                return forUpdateMap;
            }
            ArrayList<DynamicObject> forDeleteObjs = new ArrayList<DynamicObject>(8);
            for (NewDrPerm permItemDataRule : permItemDataRules) {
                String string = permItemDataRule.getAppId();
                String pEntNum = permItemDataRule.getEntityNumber();
                String string2 = permItemDataRule.getPermItemId();
                for (DynamicObject roleDataRuleObj : roleDataRuleObjArr) {
                    boolean matchKeyFieldFlag;
                    String appId = roleDataRuleObj.getString("app_id");
                    String entityNum = roleDataRuleObj.getString("entity_id");
                    String permItemId = roleDataRuleObj.getString("permitem_id");
                    boolean bl = matchKeyFieldFlag = Objects.equals(string, appId) && Objects.equals(pEntNum, entityNum) && Objects.equals(string2, permItemId);
                    if (!matchKeyFieldFlag) continue;
                    forDeleteObjs.add(roleDataRuleObj);
                }
            }
            if (!forDeleteObjs.isEmpty()) {
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"delete", (String)"perm_roledatarule", (DynamicObject[])forDeleteObjs.toArray(new DynamicObject[forDeleteObjs.size()]), (OperateOption)operOpt);
                PermResult permResult = OperationHelper.returnPermResultByOpResult(opResult);
                return permResult;
            }
            PermResult permResult = PermResult.fail((String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u5220\u9664\u7684\u6570\u636e\u89c4\u5219\u3002", (String)"DataRuleCache_59", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return permResult;
        }
        catch (Exception e) {
            h.markRollback();
            logger.error((Throwable)e);
            PermResult permResult = PermResult.fail((String)e.getMessage());
            return permResult;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (h != null) {
                if (object != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    h.close();
                }
            }
        }
    }

    public static PermResult roleAssignDataRuleProp(String roleId, List<NewDrPrPerm> bdPropDataRules, AssignModEnum assignMode) {
        Long dataRuleId;
        if (roleId == null) {
            return PermResult.fail((String)ResManager.loadKDString((String)"roleId\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_35", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        boolean isAdd = true;
        if (AssignModEnum.ASSIGNMODE_CANCEL.equals((Object)assignMode)) {
            isAdd = false;
        }
        if (isAdd) {
            if (bdPropDataRules == null || bdPropDataRules.isEmpty()) {
                return PermResult.fail((String)ResManager.loadKDString((String)"\u5165\u53c2bdPropDataRules\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_60", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            HashSet uniqueStrSet = new HashSet(8);
            for (NewDrPrPerm newDrPr : bdPropDataRules) {
                String appId = newDrPr.getAppId();
                String entNum = newDrPr.getEntityNumber();
                String propKey = newDrPr.getPropKey();
                String propEntNum = newDrPr.getPropEntNum();
                dataRuleId = newDrPr.getDataRuleId();
                if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entNum) || StringUtils.isEmpty((String)propKey) || StringUtils.isEmpty((String)propEntNum) || dataRuleId == null || dataRuleId == 0L) {
                    return PermResult.fail((String)ResManager.loadKDString((String)"\u5165\u53c2bdPropDataRules\u4e2d\u7684\u5143\u7d20\u7684\u5e94\u7528ID\uff0c\u5b9e\u4f53\u7f16\u7801\uff0c\u5c5e\u6027key\uff0c \u5c5e\u6027\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u6216\u6570\u636e\u89c4\u5219\u65b9\u6848ID\u90fd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_61", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                }
                String uniqueStr = appId + entNum + propKey + dataRuleId;
                boolean alreadyContainFlag = uniqueStrSet.add(uniqueStr);
                if (alreadyContainFlag) continue;
                return PermResult.fail((String)ResManager.loadKDString((String)"\u5165\u53c2bdPropDataRules\u4e2d\u7684\u5143\u7d20\u7684\u5e94\u7528ID\uff0c\u5b9e\u4f53\u7f16\u7801\uff0c\u5c5e\u6027key\u548c\u6570\u636e\u89c4\u5219\u65b9\u6848ID\u7684\u7ec4\u5408\u4e0d\u80fd\u91cd\u590d\u3002", (String)"DataRuleCache_62", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        } else if (bdPropDataRules != null && !bdPropDataRules.isEmpty()) {
            for (NewDrPrPerm newDrPrPerm : bdPropDataRules) {
                String appId = newDrPrPerm.getAppId();
                String entNum = newDrPrPerm.getEntityNumber();
                String propKey = newDrPrPerm.getPropKey();
                if (!StringUtils.isEmpty((String)appId) && !StringUtils.isEmpty((String)entNum) && !StringUtils.isEmpty((String)propKey)) continue;
                return PermResult.fail((String)ResManager.loadKDString((String)"\u5165\u53c2bdPropDataRules\u4e2d\u7684\u5143\u7d20\u7684\u5e94\u7528ID\uff0c\u5b9e\u4f53\u7f16\u7801\uff0c\u6216\u5c5e\u6027key\u90fd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataRuleCache_63", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
        TXHandle h = TX.required();
        Object object = null;
        try {
            Object forUpdateMap;
            PermResult forNewList;
            Date now = new Date();
            long userId = RequestContext.get().getCurrUserId();
            OperateOption operOpt = OperateOption.create();
            DynamicObject[] roleDataRulePropObjArr = BusinessDataServiceHelper.load((String)"perm_roledatarule_prop", (String)"role, app, entity, propkey, propentity, datarule, creator, createtime, modifier, modifytime", (QFilter[])new QFilter("role", "=", (Object)roleId).toArray());
            if (AssignModEnum.ASSIGNMODE_REPLACE.equals((Object)assignMode)) {
                dataRuleId = OperationServiceHelper.executeOperate((String)"delete", (String)"perm_roledatarule_prop", (DynamicObject[])roleDataRulePropObjArr, (OperateOption)operOpt);
            }
            if (isAdd) {
                boolean bl;
                forNewList = new ArrayList(8);
                forUpdateMap = new HashMap(8);
                for (NewDrPrPerm newDrPrPerm : bdPropDataRules) {
                    String pAppId = newDrPrPerm.getAppId();
                    String string = newDrPrPerm.getEntityNumber();
                    String pPropKey = newDrPrPerm.getPropKey();
                    Long pDataRuleId = newDrPrPerm.getDataRuleId();
                    boolean foundSameFlag = false;
                    boolean foundFlag = false;
                    if (roleDataRulePropObjArr != null && roleDataRulePropObjArr.length != 0) {
                        for (DynamicObject roleDataRuleObj : roleDataRulePropObjArr) {
                            boolean matchKeyFieldFlag;
                            String appId = roleDataRuleObj.getString("app_id");
                            String entityNum = roleDataRuleObj.getString("entity_id");
                            String propKey = roleDataRuleObj.getString("propkey");
                            Long dataRuleId2 = roleDataRuleObj.getLong("datarule_id");
                            boolean bl2 = matchKeyFieldFlag = Objects.equals(pAppId, appId) && Objects.equals(string, entityNum) && Objects.equals(pPropKey, propKey);
                            if (matchKeyFieldFlag && Objects.equals(pDataRuleId, dataRuleId2)) {
                                foundSameFlag = true;
                                foundFlag = true;
                                break;
                            }
                            if (!matchKeyFieldFlag) continue;
                            forUpdateMap.put(roleDataRuleObj, newDrPrPerm);
                            foundFlag = true;
                        }
                        if (foundSameFlag) continue;
                    }
                    if (foundFlag) continue;
                    forNewList.add(newDrPrPerm);
                }
                ArrayList<DynamicObject> allForInsertObjs = new ArrayList<DynamicObject>(8);
                for (Object newDr : forNewList) {
                    String string = newDr.getAppId();
                    String pEntNum = newDr.getEntityNumber();
                    String pPropKey = newDr.getPropKey();
                    String pPropEntNum = newDr.getPropEntNum();
                    Long pDataRuleId = newDr.getDataRuleId();
                    DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_roledatarule_prop");
                    newObj.set("role", (Object)roleId);
                    newObj.set("app", (Object)string);
                    newObj.set("entity", (Object)pEntNum);
                    newObj.set("propkey", (Object)pPropKey);
                    newObj.set("propentity", (Object)pPropEntNum);
                    newObj.set("datarule", (Object)pDataRuleId);
                    newObj.set("creator", (Object)userId);
                    newObj.set("createtime", (Object)now);
                    allForInsertObjs.add(newObj);
                }
                ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(8);
                for (Map.Entry entry : forUpdateMap.entrySet()) {
                    DynamicObject updateObj = (DynamicObject)entry.getKey();
                    NewDrPrPerm newDrPr = (NewDrPrPerm)entry.getValue();
                    String pAppId = newDrPr.getAppId();
                    String pEntNum = newDrPr.getEntityNumber();
                    String pPropKey = newDrPr.getPropKey();
                    String pPropEntNum = newDrPr.getPropEntNum();
                    Long pDataRuleId = newDrPr.getDataRuleId();
                    updateObj.set("app", (Object)pAppId);
                    updateObj.set("entity", (Object)pEntNum);
                    updateObj.set("propkey", (Object)pPropKey);
                    updateObj.set("propentity", (Object)pPropEntNum);
                    updateObj.set("datarule", (Object)pDataRuleId);
                    updateObj.set("modifier", (Object)userId);
                    updateObj.set("modifytime", (Object)now);
                    arrayList.add(updateObj);
                }
                boolean insertObjsNotEmptyFlag = !CollectionUtils.isEmpty(allForInsertObjs);
                boolean bl3 = bl = !CollectionUtils.isEmpty(arrayList);
                if (insertObjsNotEmptyFlag || bl) {
                    PermResult permResult;
                    OperationResult opResult = null;
                    if (insertObjsNotEmptyFlag) {
                        opResult = OperationServiceHelper.executeOperate((String)"save", (String)"perm_roledatarule_prop", (DynamicObject[])allForInsertObjs.toArray(new DynamicObject[allForInsertObjs.size()]), (OperateOption)operOpt);
                    }
                    if (opResult != null && !opResult.isSuccess()) {
                        permResult = OperationHelper.returnPermResultByOpResult(opResult);
                        return permResult;
                    }
                    if (bl) {
                        opResult = OperationServiceHelper.executeOperate((String)"save", (String)"perm_roledatarule_prop", (DynamicObject[])arrayList.toArray(new DynamicObject[arrayList.size()]), (OperateOption)operOpt);
                    }
                    permResult = OperationHelper.returnPermResultByOpResult(opResult);
                    return permResult;
                }
                PermResult permResult = PermResult.ok((Object)"No data to add or update.");
                return permResult;
            }
            if (roleDataRulePropObjArr == null || roleDataRulePropObjArr.length == 0) {
                forNewList = PermResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u901a\u7528\u89d2\u8272\u65e0\u4efb\u4f55\u5c5e\u6027\u4e0b\u7684\u6570\u636e\u89c4\u5219\u914d\u7f6e\u3002", (String)"DataRuleCache_65", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return forNewList;
            }
            if (bdPropDataRules == null || bdPropDataRules.isEmpty()) {
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"delete", (String)"perm_roledatarule", (DynamicObject[])roleDataRulePropObjArr, (OperateOption)operOpt);
                forUpdateMap = OperationHelper.returnPermResultByOpResult(opResult);
                return forUpdateMap;
            }
            ArrayList<DynamicObject> forDeleteObjs = new ArrayList<DynamicObject>(8);
            for (NewDrPrPerm bdPropDataRule : bdPropDataRules) {
                String string = bdPropDataRule.getAppId();
                String pEntNum = bdPropDataRule.getEntityNumber();
                String string2 = bdPropDataRule.getPropKey();
                for (DynamicObject roleDataRulePropObj : roleDataRulePropObjArr) {
                    boolean matchKeyFieldFlag;
                    String appId = roleDataRulePropObj.getString("app_id");
                    String entityNum = roleDataRulePropObj.getString("entity_id");
                    String propKey = roleDataRulePropObj.getString("propkey");
                    boolean bl = matchKeyFieldFlag = Objects.equals(string, appId) && Objects.equals(pEntNum, entityNum) && Objects.equals(string2, propKey);
                    if (!matchKeyFieldFlag) continue;
                    forDeleteObjs.add(roleDataRulePropObj);
                }
            }
            if (!forDeleteObjs.isEmpty()) {
                OperationResult opResult = OperationServiceHelper.executeOperate((String)"delete", (String)"perm_roledatarule_prop", (DynamicObject[])forDeleteObjs.toArray(new DynamicObject[forDeleteObjs.size()]), (OperateOption)operOpt);
                PermResult permResult = OperationHelper.returnPermResultByOpResult(opResult);
                return permResult;
            }
            PermResult permResult = PermResult.fail((String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u5220\u9664\u7684\u6570\u636e\u89c4\u5219\u3002", (String)"DataRuleCache_59", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return permResult;
        }
        catch (Exception e) {
            h.markRollback();
            logger.error((Throwable)e);
            PermResult permResult = PermResult.fail((String)e.getMessage());
            return permResult;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (h != null) {
                if (object != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    h.close();
                }
            }
        }
    }

    public static QFilter getDataRule(long userId, String appId, String entityNum, String permItemId, Map<String, Object> customParam) {
        CustomPermServInfo customServInfo = CustomPermServInfo.getCustPermServInfo(appId, customParam);
        if (customServInfo != null) {
            boolean skipPlatformImp = customServInfo.isSkipPlatformImp();
            boolean isAnd = customServInfo.isAnd();
            String appNum = customServInfo.getAppNum();
            Object customResult = null;
            try {
                customParam.remove(CUSTOMPARAM_DATARULE_EXTDATAENTSET);
                customResult = DataRuleCache.invokeBizMethod(customServInfo, METHOD_GET_DATA_RULE, userId, appId, entityNum, permItemId, customParam);
                QFilter customQFilter = (QFilter)customResult;
                if (skipPlatformImp) {
                    return customQFilter;
                }
                QFilter standardResult = DataRuleCache.getDataRuleWithExtPluginAndCustQFilter(userId, appId, entityNum, permItemId, null, customParam);
                if (standardResult == null) {
                    return customQFilter;
                }
                if (customQFilter == null) {
                    return standardResult;
                }
                QFilter finalQFilter = null;
                finalQFilter = isAnd ? standardResult.and(customQFilter) : standardResult.or(customQFilter);
                return finalQFilter;
            }
            catch (Exception e) {
                String errorMsg = DataRuleCache.getMessage1(appNum) + ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e\u89c4\u5219(getDataRule)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6ce8\u518c\u7684\u670d\u52a1\u662f\u5426\u6b63\u786e\u3002", (String)"DataRuleCache_44", (String)SYSTEM_TYPE, (Object[])new Object[0]) + e.getMessage();
                logger.warn(errorMsg);
            }
        }
        QFilter finalFilter = DataRuleCache.getDataRuleWithExtPlugin(customParam, userId, appId, entityNum, permItemId);
        return finalFilter;
    }

    public static QFilter getDataRuleWithExtPlugin(Map<String, Object> customParam, long userId, String appId, String entityNum, String permItemId) {
        QFilter orgnlQFilter;
        QFilter finalFilter = orgnlQFilter = DataRuleCache.getDataRule(customParam, userId, appId, entityNum, permItemId);
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IDataRuleExt.class, (String)"kd.bos.permission.api.ext.IDataRuleExt", null);
            PluginCall call = p -> {
                QFilter q;
                if (p != null && (q = p.getDataRuleFilterByBaseData(Long.valueOf(userId), appId, entityNum, permItemId, customParam)) != null) {
                    return q;
                }
                return null;
            };
            List pluginResults = pluginProxy.callReplaceIfPresent(call);
            if (pluginResults != null && !pluginResults.isEmpty()) {
                for (QFilter tempFilter : pluginResults) {
                    if (tempFilter == null) continue;
                    if (finalFilter == null) {
                        finalFilter = tempFilter;
                        continue;
                    }
                    finalFilter.and(tempFilter);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return finalFilter;
    }

    public static QFilter getDataRule(long userId, String appId, String entityNum, String permItemId) {
        HashMap<String, Object> customParam = new HashMap<String, Object>(8);
        return DataRuleCache.getDataRuleWithExtPlugin(customParam, userId, appId, entityNum, permItemId);
    }

    public static QFilter getDataRule(Map<String, Object> customParam, long userId, String appId, String entityNum, String permItemId) {
        boolean existMulBdPropAtNotViewPerm;
        Map<String, String> entOriAppIdMap;
        HashMap<String, Object> extAppAndOrgnlAppRelParamMap;
        Map<String, String> extAppOrgnlAppMap;
        if (userId == 0L || StringUtils.isEmpty((String)entityNum)) {
            return null;
        }
        if (null == customParam) {
            extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
            extAppAndOrgnlAppRelParamMap = new HashMap<String, Object>(8);
            extAppAndOrgnlAppRelParamMap.put("entityNumList", Lists.newArrayList((Object[])new String[]{entityNum}));
            extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
            entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
            customParam = new HashMap<String, Object>(8);
            customParam.put("entOriAppIdMap", entOriAppIdMap);
            customParam.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        } else {
            if (!customParam.containsKey("extAppOrgnlAppMap")) {
                customParam.put("extAppOrgnlAppMap", AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1)));
            }
            if (!customParam.containsKey("entOriAppIdMap")) {
                extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
                extAppAndOrgnlAppRelParamMap = new HashMap(8);
                extAppAndOrgnlAppRelParamMap.put("entityNumList", Lists.newArrayList((Object[])new String[]{entityNum}));
                extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
                entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
                customParam.put("entOriAppIdMap", entOriAppIdMap);
            }
        }
        Long useDimObj = customParam.isEmpty() ? null : (Long)customParam.get(CUSTOMPARAM_USEORGID);
        String type = CacheMrg.getType4DataRuleObj();
        appId = PermCommonUtil.getAppIdFromSuspectedAppNum(appId);
        String checkPermAppId = PermCommonUtil.getCheckPermAppId(appId, entityNum, customParam);
        ArrayList<Long> dimObjIds = new ArrayList<Long>();
        if (useDimObj != null && useDimObj != 0L) {
            dimObjIds.add(useDimObj);
        }
        String key = DataRuleCache.buildCacheKey(METHOD_GET_DATA_RULE, userId, checkPermAppId, entityNum, permItemId, dimObjIds);
        QFilter resultFilter = null;
        DataRuleResult drr = null;
        String value = CacheMrg.getCache(type, key);
        boolean needLoad = false;
        if (CacheMrg.isLoaded(value)) {
            if (CacheMrg.isData(value)) {
                drr = (DataRuleResult)SerializationUtils.fromJsonString((String)value, DataRuleResult.class);
            }
        } else {
            needLoad = true;
        }
        String checkPermDimObjFieldKey = PermCommonUtil.getCheckPermDimObjFieldKey(entityNum);
        boolean isNeedDimCtrlNow = StringUtils.isNotEmpty((String)checkPermDimObjFieldKey);
        if (needLoad) {
            drr = DataRuleCache.loadDataRule(userId, checkPermAppId, entityNum, permItemId, customParam, checkPermDimObjFieldKey);
            if (drr == null) {
                CacheMrg.loaded(type, key);
                return null;
            }
            CacheMrg.putCache(type, key, SerializationUtils.toJsonString((Object)drr));
        }
        if (drr != null && drr.isNeedDimCtrl() != isNeedDimCtrlNow) {
            drr = DataRuleCache.loadDataRule(userId, checkPermAppId, entityNum, permItemId, customParam, checkPermDimObjFieldKey);
            if (drr == null) {
                CacheMrg.loaded(type, key);
                return null;
            }
            CacheMrg.putCache(type, key, SerializationUtils.toJsonString((Object)drr));
        }
        if (existMulBdPropAtNotViewPerm = DataRuleCache.existMulBdPropInQFilterAtNotViewPerm(resultFilter = PermCommonUtil.convertDataRuleResultToQFilter(drr, userId, appId, entityNum), entityNum, permItemId)) {
            String notSupportMsg = DataRuleCache.getMulDataRuleNotSupportMsg(permItemId);
            throw new KDException(new ErrorCode(ERRCODE_DATARULE_NOTSUPPORT_NOTVIEW_MULBD, notSupportMsg), new Object[0]);
        }
        boolean hasEnablePropCollapse = PermCommonUtil.hasEnablePropCollapse();
        if (hasEnablePropCollapse && resultFilter != null) {
            String filterInfo = String.format(ResManager.loadKDString((String)"\u539f\u59cb\u7684\u6570\u636e\u89c4\u5219\uff08\u65b0\uff09\uff1a %1$s [userId:%2$s, appId:%3$s, entityNum:%4$s, permItemId:%5$s]", (String)"DataRuleCache_45", (String)SYSTEM_TYPE, (Object[])new Object[0]), resultFilter.toCurrentString(), userId, appId, entityNum, permItemId);
            logger.info(filterInfo);
            resultFilter = PermCommonUtil.convertQFilter(entityNum, resultFilter);
            String filterInfoAfter = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u540e\u7684\u6570\u636e\u89c4\u5219\uff08\u65b0\uff09: %1$s [userId:%2$s, appId:%3$s, entityNum:%4$s,permItemId:%5$s]", (String)"DataRuleCache_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), resultFilter.toCurrentString(), userId, appId, entityNum, permItemId);
            logger.info(filterInfoAfter);
        }
        return resultFilter;
    }

    public static String buildCacheKey(String method, long userId, String appId, String entityNum, String permItemId) {
        return String.format("%s_%s_%s_%s_%s", method, String.valueOf(userId), appId, entityNum, permItemId);
    }

    public static String buildCacheKey(String method, long userId, String appId, String entityNum) {
        return String.format("%s_%s_%s_%s", method, String.valueOf(userId), appId, entityNum);
    }

    private static String buildCacheKey(String method, long userId, String appId, String entityNum, String permItemId, List<Long> dimObjIds) {
        String dimObjIdsInfo = "";
        dimObjIdsInfo = dimObjIds != null && !dimObjIds.isEmpty() ? Arrays.toString(dimObjIds.toArray()) : "null";
        return String.format("%s_%s_%s_%s_%s_%s", method, String.valueOf(userId), appId, entityNum, permItemId, dimObjIds);
    }

    public static String buildCacheKey(String method, long userId, String appId, String entityNum, String propKey, String permItemId, List<Long> dimObjIds, boolean booleanValue) {
        String dimObjIdsInfo = "";
        dimObjIdsInfo = dimObjIds != null && !dimObjIds.isEmpty() ? Arrays.toString(dimObjIds.toArray()) : "null";
        return String.format("%s_%s_%s_%s_%s_%s_%s_%s", method, String.valueOf(userId), appId, entityNum, propKey, permItemId, dimObjIdsInfo, booleanValue);
    }

    private static DataRuleResult loadDataRule(long userId, String appId, String entityNum, String permItemId, Map<String, Object> customParam, String checkPermDimObjFieldKey) {
        if (StringUtils.isEmpty((String)permItemId)) {
            permItemId = "empty";
        }
        if (StringUtils.isNotEmpty((String)checkPermDimObjFieldKey)) {
            return DataRuleCache.loadDataRuleWithDim(userId, appId, entityNum, permItemId);
        }
        Boolean isLookUp = (Boolean)customParam.get(CUSTOMPARAM_ISLOOKUP);
        Long useDimObj = (Long)customParam.get(CUSTOMPARAM_USEORGID);
        boolean needDimControl = PermCommonUtil.needDimControl(entityNum);
        boolean isBaseDataType = EntityMetadataCache.getDataEntityType((String)entityNum) instanceof BasedataEntityType;
        if (isBaseDataType && Boolean.TRUE.equals(isLookUp) && !needDimControl) {
            ArrayList<Long> dimObjIds = new ArrayList<Long>();
            if (useDimObj != null && useDimObj != 0L) {
                dimObjIds.add(useDimObj);
            }
            return DataRuleCache.loadDataRuleWithoutDim(userId, appId, entityNum, permItemId, dimObjIds);
        }
        return DataRuleCache.loadDataRuleWithoutDim(userId, appId, entityNum, permItemId);
    }

    private static DataRuleResult loadUserDataRuleWithDimObj(long userId, String appId, String entityNum, String permItemId, String dimType) {
        DataRuleResult drr = new DataRuleResult();
        String checkPermOrgKey = PermCommonUtil.getCheckPermDimObjFieldKey(entityNum);
        if (StringUtils.isEmpty((String)checkPermOrgKey)) {
            drr.setNeedDimCtrl(false);
        }
        String queryUserDataRuleSql = "select fdimtype, fdimid, fisincludesub, fdataruleid " + "from t_perm_userdatarule " + "where fuserid = ? and fappid = ? and fentitynum = ? and fpermitemid = ? and fdimtype = ? ";
        HashSet allDataRuleIds = new HashSet();
        ArrayList dimResult = new ArrayList();
        DB.query((DBRoute)DBRoute.permission, (String)queryUserDataRuleSql, (Object[])new Object[]{userId, appId, entityNum, permItemId, dimType}, rs -> {
            while (rs.next()) {
                Long dimId = rs.getLong("fdimid");
                Boolean isIncludeSub = rs.getBoolean("fisincludesub");
                Long dataRuleId = rs.getLong("fdataruleid");
                allDataRuleIds.add(dataRuleId.toString());
                dimResult.add(new Object[]{dimId, isIncludeSub, dataRuleId});
            }
            return null;
        });
        if (allDataRuleIds.isEmpty()) {
            return drr;
        }
        String allDataRuleIdStr = String.join((CharSequence)",", allDataRuleIds);
        String queryDataRuleSql = "select fid, frule from t_perm_datarule where fenable ='1' and fid in(" + allDataRuleIdStr + ")";
        HashMap ruleMap = new HashMap();
        DB.query((DBRoute)DBRoute.permission, (String)queryDataRuleSql, null, rs -> {
            while (rs.next()) {
                String jsonRule = rs.getString("frule");
                Long dataRuleId = rs.getLong("fid");
                ruleMap.put(dataRuleId, jsonRule);
            }
            return null;
        });
        for (Object[] arr : dimResult) {
            String jsonRule = (String)ruleMap.get(arr[2]);
            DataRuleSingleResult drsr = new DataRuleSingleResult();
            drsr.setFilterJson(jsonRule);
            HashMap<Long, Boolean> dimObjIncludeSubInfo = new HashMap<Long, Boolean>();
            dimObjIncludeSubInfo.put((Long)arr[0], (Boolean)arr[1]);
            drsr.setDimObjIncludeSubInfo(dimObjIncludeSubInfo);
            drr.getSingleResultList().add(drsr);
        }
        return drr;
    }

    private static DataRuleResult loadDataRuleWithDim(long userId, String appId, String entityNum, String permItemId) {
        Set<String> roleIds;
        DataRuleResult userDataPermResult = null;
        boolean hasEnableOldDataRule = PermCommonUtil.hasEnableOldDataRule();
        String formDimType = PermCommonUtil.getDimTypeByEntityNum(entityNum);
        if (hasEnableOldDataRule) {
            if (permItemId.equals("47150e89000000ac")) {
                userDataPermResult = DataPermissionCache.loadUserDataPermWithDimObj(userId, appId, entityNum);
            }
        } else {
            userDataPermResult = DataRuleCache.loadUserDataRuleWithDimObj(userId, appId, entityNum, permItemId, formDimType);
        }
        if (CollectionUtils.isEmpty(roleIds = UserRoleCache.getRolesByUserId(userId))) {
            return userDataPermResult;
        }
        Map<String, Map<Long, Boolean>> roleDimObjAssignMapSimple = UserRoleCache.getRoleDimObjAssignMapSimple(userId, formDimType);
        DataRuleResult drr = new DataRuleResult();
        drr.setNeedDimCtrl(true);
        List singleResultList = drr.getSingleResultList();
        Map<String, DataRulesInfo> roleDataRulesInfoMap = DataRuleCache.queryCommonRoleDataRules(roleIds);
        boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        block0: for (String roleId : roleIds) {
            DataRulesInfo queryRoleDataRules = roleDataRulesInfoMap.get(roleId);
            if (queryRoleDataRules == null) continue;
            if (hasEnableRoleDataRuleNewModel) {
                List entDataRuleInfos = queryRoleDataRules.getEntDataRuleInfos();
                if (CollectionUtils.isEmpty((Collection)entDataRuleInfos)) continue;
                for (EntDataRuleInfo edri : entDataRuleInfos) {
                    List pidrList;
                    if (edri == null) continue;
                    String edriAppId = edri.getAppId();
                    String edriEntityNum = edri.getEntityNum();
                    if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)edriAppId) || StringUtils.isEmpty((String)edriEntityNum) || !appId.equals(edriAppId) || !entityNum.equals(edriEntityNum) || CollectionUtils.isEmpty((Collection)(pidrList = edri.getPermItemsDataRule()))) continue;
                    boolean foundPermItem = false;
                    for (EntDataRuleInfo.PermItemsDataRule pidr : pidrList) {
                        if (pidr == null || !permItemId.equals(pidr.getPermItemId())) continue;
                        Map<Long, Boolean> dimObjInfo = roleDimObjAssignMapSimple.get(roleId);
                        DataRuleSingleResult drsr = new DataRuleSingleResult();
                        drsr.setDimObjIncludeSubInfo(dimObjInfo);
                        FilterCondition fc = pidr.getDataRule().getRule();
                        String filterJson = fc.getFilter();
                        if (StringUtils.isEmpty((String)filterJson) && StringUtils.isEmpty((String)(filterJson = SerializationUtils.toJsonString((Object)fc)))) continue;
                        drsr.setFilterJson(filterJson);
                        singleResultList.add(drsr);
                        foundPermItem = true;
                        break;
                    }
                    if (!foundPermItem) continue;
                    continue block0;
                }
                continue;
            }
            List entryInfos = queryRoleDataRules.getEntryInfos();
            if (CollectionUtils.isEmpty((Collection)entryInfos)) continue;
            for (DataRulesInfo.DataRulesEntryInfo drei : entryInfos) {
                List pidrList;
                DataRuleInfo dataRule;
                if (drei == null) continue;
                String dreiAppId = drei.getAppId();
                String dreiEntityNum = drei.getEntityNum();
                if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)dreiAppId) || StringUtils.isEmpty((String)dreiEntityNum) || !appId.equals(dreiAppId) || !entityNum.equals(dreiEntityNum) || (dataRule = drei.getDataRule()) == null || CollectionUtils.isEmpty((Collection)(pidrList = dataRule.getPermItemsDataRule()))) continue;
                boolean foundPermItem = false;
                for (DataRuleInfo.PermItemsDataRule pidr : pidrList) {
                    if (pidr == null || !permItemId.equals(pidr.getPermItemId())) continue;
                    Map<Long, Boolean> dimObjInfo = roleDimObjAssignMapSimple.get(roleId);
                    DataRuleSingleResult drsr = new DataRuleSingleResult();
                    drsr.setDimObjIncludeSubInfo(dimObjInfo);
                    FilterCondition fc = pidr.getDataRule().getRule();
                    String filterJson = fc.getFilter();
                    if (StringUtils.isEmpty((String)filterJson) && StringUtils.isEmpty((String)(filterJson = SerializationUtils.toJsonString((Object)fc)))) continue;
                    drsr.setFilterJson(filterJson);
                    singleResultList.add(drsr);
                    foundPermItem = true;
                    break;
                }
                if (!foundPermItem) continue;
                continue block0;
            }
        }
        if (userDataPermResult != null) {
            List userDataPermSingleResultList = userDataPermResult.getSingleResultList();
            if (!CollectionUtils.isEmpty((Collection)userDataPermSingleResultList)) {
                drr.getSingleResultList().addAll(userDataPermSingleResultList);
            }
        } else if (singleResultList.isEmpty()) {
            return null;
        }
        return drr;
    }

    private static DataRuleResult loadDataRuleWithoutDim(long userId, String appId, String entityNum, String permItemId) {
        return DataRuleCache.loadDataRuleWithoutDim(userId, appId, entityNum, permItemId, null);
    }

    private static DataRuleResult loadDataRuleWithoutDim(long userId, String appId, String entityNum, String permItemId, List<Long> dimObjIds) {
        return DataRuleCache.loadDataRuleWithoutDim(userId, appId, entityNum, permItemId, dimObjIds, "15");
    }

    private static DataRuleResult loadDataRuleWithoutDim(long userId, String appId, String entityNum, String permItemId, List<Long> dimObjIds, String orgViewNum) {
        if (StringUtils.isEmpty((String)permItemId)) {
            permItemId = "empty";
        }
        DataRuleResult drr = new DataRuleResult();
        drr.setNeedDimCtrl(false);
        DataRuleResult userDataPermResult = null;
        boolean hasEnableOldDataRule = PermCommonUtil.hasEnableOldDataRule();
        if (hasEnableOldDataRule) {
            if (permItemId.equals("47150e89000000ac")) {
                userDataPermResult = DataPermissionCache.loadUserDataPermWithoutDimObj(userId, appId, entityNum, dimObjIds, orgViewNum);
            }
        } else {
            userDataPermResult = DataRuleCache.loadUserDataRuleWithoutDimObj(userId, appId, entityNum, permItemId, dimObjIds, orgViewNum);
        }
        if (userDataPermResult == null) {
            return null;
        }
        String dimTypeEntType = PermCommonUtil.getDimTypeByEntityNum(entityNum, true);
        Set<String> roleIds = UserRoleCache.getRolesByUserId(userId, dimObjIds, dimTypeEntType, orgViewNum);
        if (CollectionUtils.isEmpty(roleIds)) {
            return userDataPermResult;
        }
        ArrayList<FilterCondition> filterCondsFromRole = new ArrayList<FilterCondition>(8);
        Map<String, DataRulesInfo> roleDataRulesInfoMap = DataRuleCache.queryCommonRoleDataRules(roleIds);
        boolean hasEnableRoleDrNewMdl = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        for (String roleId : roleIds) {
            DataRulesInfo queryRoleDataRules = roleDataRulesInfoMap.get(roleId);
            if (queryRoleDataRules == null) continue;
            if (hasEnableRoleDrNewMdl) {
                List entDataRuleInfos = queryRoleDataRules.getEntDataRuleInfos();
                if (CollectionUtils.isEmpty((Collection)entDataRuleInfos)) continue;
                for (EntDataRuleInfo edri : entDataRuleInfos) {
                    List pidrList;
                    if (edri == null || !Objects.equals(appId, edri.getAppId()) || !Objects.equals(entityNum, edri.getEntityNum()) || CollectionUtils.isEmpty((Collection)(pidrList = edri.getPermItemsDataRule()))) continue;
                    for (EntDataRuleInfo.PermItemsDataRule pidr : pidrList) {
                        if (pidr == null || !Objects.equals(permItemId, pidr.getPermItemId()) || pidr.getDataRule() == null) continue;
                        FilterCondition fc = pidr.getDataRule().getRule();
                        filterCondsFromRole.add(fc);
                    }
                }
                continue;
            }
            List entryInfos = queryRoleDataRules.getEntryInfos();
            if (CollectionUtils.isEmpty((Collection)entryInfos)) continue;
            for (DataRulesInfo.DataRulesEntryInfo drei : entryInfos) {
                List pidrList;
                DataRuleInfo dataRule;
                if (drei == null || !Objects.equals(appId, drei.getAppId()) || !Objects.equals(entityNum, drei.getEntityNum()) || (dataRule = drei.getDataRule()) == null || CollectionUtils.isEmpty((Collection)(pidrList = dataRule.getPermItemsDataRule()))) continue;
                for (DataRuleInfo.PermItemsDataRule pidr : pidrList) {
                    if (pidr == null || !Objects.equals(permItemId, pidr.getPermItemId()) || pidr.getDataRule() == null) continue;
                    FilterCondition fc = pidr.getDataRule().getRule();
                    filterCondsFromRole.add(fc);
                }
            }
        }
        for (FilterCondition fc : filterCondsFromRole) {
            if (fc == null) continue;
            String filterJson = fc.getFilter();
            if (StringUtils.isEmpty((String)filterJson)) {
                filterJson = SerializationUtils.toJsonString((Object)fc);
            }
            if (StringUtils.isEmpty((String)filterJson)) continue;
            DataRuleSingleResult drsr = new DataRuleSingleResult();
            drsr.setFilterJson(filterJson);
            drr.getSingleResultList().add(drsr);
        }
        if (userDataPermResult != null) {
            drr.getSingleResultList().addAll(userDataPermResult.getSingleResultList());
        }
        return drr;
    }

    private static DataRuleResult loadUserDataRuleWithoutDimObj(long userId, String appId, String entityNum, String permItemId, List<Long> dimObjIds, String orgViewNum) {
        DataRuleResult drr = new DataRuleResult();
        drr.setNeedDimCtrl(false);
        List<Object> dimObjIdsNewParam = new ArrayList(8);
        if (dimObjIds != null && !dimObjIds.isEmpty()) {
            dimObjIdsNewParam = new ArrayList<Long>(dimObjIds);
            dimObjIdsNewParam = dimObjIdsNewParam.stream().filter(p -> p != null && !p.equals(0L)).collect(Collectors.toList());
        }
        String dimTypeNum = PermCommonUtil.getDimTypeNumByEntityNum(entityNum);
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimTypeNum, true);
        String dimTypeEntNum = suitableDimType[1];
        StringBuilder sbQueryUserDataRuleSql = new StringBuilder().append("select fdimid, fisincludesub, fdataruleid ").append(" from t_perm_userdatarule ").append(" where fuserid = ? and fappid = ? and fentitynum = ? and fpermitemid = ? ");
        if (IsoDimHelper.addDimTypeFilter(dimTypeEntNum)) {
            sbQueryUserDataRuleSql.append(" and fdimtype = '").append(dimTypeEntNum).append("' ");
        }
        HashMap includeSubDimInfo = new HashMap();
        HashMap notIncludeSubDimInfo = new HashMap();
        HashSet<String> matchDataRuleIds = new HashSet<String>();
        DB.query((DBRoute)DBRoute.permission, (String)sbQueryUserDataRuleSql.toString(), (Object[])new Object[]{userId, appId, entityNum, permItemId}, rs -> {
            while (rs.next()) {
                Long dimId = rs.getLong("fdimid");
                Boolean isIncludeSub = rs.getBoolean("fisincludesub");
                Long dataRuleId = rs.getLong("fdataruleid");
                if (Boolean.TRUE.equals(isIncludeSub)) {
                    includeSubDimInfo.put(dimId, dataRuleId);
                } else {
                    notIncludeSubDimInfo.put(dimId, dataRuleId);
                }
                matchDataRuleIds.add(dataRuleId.toString());
            }
            return null;
        });
        if (includeSubDimInfo.isEmpty() && notIncludeSubDimInfo.isEmpty()) {
            return drr;
        }
        if (dimObjIdsNewParam != null && !dimObjIdsNewParam.isEmpty()) {
            Map allSupOrgMap;
            matchDataRuleIds.clear();
            if (!notIncludeSubDimInfo.isEmpty()) {
                Set notIncludeSubDimIds = notIncludeSubDimInfo.keySet();
                notIncludeSubDimIds.retainAll(dimObjIdsNewParam);
                for (Long dataRuleId : notIncludeSubDimInfo.values()) {
                    if (dataRuleId == null || dataRuleId.equals(0L)) continue;
                    matchDataRuleIds.add(dataRuleId.toString());
                }
            }
            if (!includeSubDimInfo.isEmpty() && (allSupOrgMap = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgViewNum, dimObjIdsNewParam)) != null && !allSupOrgMap.isEmpty()) {
                Collection allSupOrgMapValues = allSupOrgMap.values();
                HashSet<Object> allSupOrgIds = new HashSet<Object>();
                for (List list : allSupOrgMapValues) {
                    allSupOrgIds.addAll(list);
                }
                allSupOrgIds.addAll(dimObjIdsNewParam);
                if (allSupOrgIds != null && !allSupOrgIds.isEmpty()) {
                    Set includeSubDimIds = includeSubDimInfo.keySet();
                    includeSubDimIds.retainAll(allSupOrgIds);
                    for (Long dataRuleId : includeSubDimInfo.values()) {
                        if (dataRuleId == null || dataRuleId.equals(0L)) continue;
                        matchDataRuleIds.add(dataRuleId.toString());
                    }
                }
            }
        }
        if (matchDataRuleIds.isEmpty()) {
            return drr;
        }
        String matchDataRuleIdStr = String.join((CharSequence)",", matchDataRuleIds);
        String queryDataRuleSql = "select fid, frule from t_perm_datarule where fenable ='1' and fid in(" + matchDataRuleIdStr + ")";
        DB.query((DBRoute)DBRoute.permission, (String)queryDataRuleSql, null, rs -> {
            while (rs.next()) {
                String jsonRule = rs.getString("frule");
                DataRuleSingleResult drsr = new DataRuleSingleResult();
                drsr.setFilterJson(jsonRule);
                drr.getSingleResultList().add(drsr);
            }
            return null;
        });
        return drr;
    }

    public static void removeCache(long userId, String appId, String entityNum, String permItemId) {
        String type = CacheMrg.getType4DataRuleObj();
        String key = DataRuleCache.buildCacheKey(METHOD_GET_DATA_RULE, userId, appId, entityNum, permItemId);
        CacheMrg.clearCache(type, key);
        String custType = CacheMrg.getType4CustomDataRule();
        CacheMrg.clearCache(custType, key);
    }

    public static void removeAllCache() {
        CacheMrg.clearCache(CacheMrg.getType4DataRuleObj());
        CacheMrg.clearCache(CacheMrg.getType4DataRule());
        CacheMrg.clearCache(CacheMrg.getType4CustomDataRule());
    }

    public static void removeCacheForBdProp(long userId, String appId, String entityNum, String propKey) {
        String type = CacheMrg.getType4DataRuleObj();
        String key = DataRuleCache.buildCacheKey(METHOD_GETDATARULEFORBDPROP, userId, appId, entityNum, propKey);
        CacheMrg.clearCache(type, key);
        String custType = CacheMrg.getType4CustomDataRule();
        CacheMrg.clearCache(custType, key);
    }

    public static QFilter getDataRuleForBdProp(long userId, String appId, String entityNum, String propKey, String permItemId, List<Long> dimObjIds, boolean needLoadBdEntTypeDataRule, Map<String, Object> customParam) {
        CustomPermServInfo customServInfo;
        if (customParam == null) {
            customParam = new HashMap<String, Object>(8);
        }
        if ((customServInfo = CustomPermServInfo.getCustPermServInfo(appId, customParam)) != null && StringUtils.isNotEmpty((String)customServInfo.getAppId())) {
            boolean skipPlatformImp = customServInfo.isSkipPlatformImp();
            boolean isAnd = customServInfo.isAnd();
            String appNum = customServInfo.getAppNum();
            Object customResult = null;
            customParam.remove(CUSTOMPARAM_DATARULE_EXTDATAENTSET);
            try {
                if (dimObjIds != null && !dimObjIds.isEmpty()) {
                    try {
                        customResult = DataRuleCache.invokeBizMethod(customServInfo, METHOD_GETDATARULEFORBDPROP, userId, appId, entityNum, propKey, permItemId, dimObjIds, customParam);
                    }
                    catch (Exception e) {
                        logger.warn((Throwable)e);
                        customResult = DataRuleCache.invokeBizMethod(customServInfo, METHOD_GETDATARULEFORBDPROP, userId, appId, entityNum, propKey, permItemId, customParam);
                    }
                } else {
                    customResult = DataRuleCache.invokeBizMethod(customServInfo, METHOD_GETDATARULEFORBDPROP, userId, appId, entityNum, propKey, permItemId, customParam);
                }
                QFilter customQFilter = (QFilter)customResult;
                if (skipPlatformImp) {
                    return customQFilter;
                }
                QFilter standardResult = DataRuleCache.getDataRuleForBdProp(userId, appId, entityNum, propKey, permItemId, dimObjIds, needLoadBdEntTypeDataRule);
                if (standardResult == null) {
                    return customQFilter;
                }
                if (customQFilter == null) {
                    return standardResult;
                }
                QFilter finalQFilter = null;
                finalQFilter = isAnd ? standardResult.and(customQFilter) : standardResult.or(customQFilter);
                return finalQFilter;
            }
            catch (Exception e) {
                String errorMsg = DataRuleCache.getMessage1(appNum) + ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e\u89c4\u5219(getDataRuleForBdProp)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6ce8\u518c\u7684\u670d\u52a1\u662f\u5426\u6b63\u786e\u3002", (String)"DataRuleCache_46", (String)SYSTEM_TYPE, (Object[])new Object[0]) + e.getMessage();
                logger.warn(errorMsg);
            }
        }
        return DataRuleCache.getDataRuleForBdPropWithCustParam(userId, appId, entityNum, propKey, permItemId, dimObjIds, needLoadBdEntTypeDataRule, customParam);
    }

    public static QFilter getDataRuleForBdProp(long userId, String appId, IDataEntityType dataEntityType, String propKey, String permItemId, List<Long> dimObjIds, boolean needLoadBdEntTypeDataRule, Map<String, Object> customParam) {
        if (customParam == null) {
            customParam = new HashMap<String, Object>(8);
        }
        String entityNum = dataEntityType.getName();
        CustomPermServInfo customServInfo = CustomPermServInfo.getCustPermServInfo(appId, customParam);
        if (customServInfo != null && StringUtils.isNotEmpty((String)customServInfo.getAppId())) {
            boolean skipPlatformImp = customServInfo.isSkipPlatformImp();
            boolean isAnd = customServInfo.isAnd();
            String appNum = customServInfo.getAppNum();
            Object customResult = null;
            customParam.remove(CUSTOMPARAM_DATARULE_EXTDATAENTSET);
            try {
                if (dimObjIds != null && !dimObjIds.isEmpty()) {
                    try {
                        customResult = DataRuleCache.invokeBizMethod(customServInfo, METHOD_GETDATARULEFORBDPROP, userId, appId, entityNum, propKey, permItemId, dimObjIds, customParam);
                    }
                    catch (Exception e) {
                        logger.debug("DataRuleCache.getDataRuleForBdProp customResult error.", (Object)e);
                        customResult = DataRuleCache.invokeBizMethod(customServInfo, METHOD_GETDATARULEFORBDPROP, userId, appId, entityNum, propKey, permItemId, customParam);
                    }
                } else {
                    customResult = DataRuleCache.invokeBizMethod(customServInfo, METHOD_GETDATARULEFORBDPROP, userId, appId, entityNum, propKey, permItemId, customParam);
                }
                QFilter customQFilter = (QFilter)customResult;
                if (skipPlatformImp) {
                    return customQFilter;
                }
                QFilter standardResult = DataRuleCache.getDataRuleForBdProp(userId, appId, entityNum, propKey, permItemId, dimObjIds, needLoadBdEntTypeDataRule);
                if (standardResult == null) {
                    return customQFilter;
                }
                if (customQFilter == null) {
                    return standardResult;
                }
                QFilter finalQFilter = null;
                finalQFilter = isAnd ? standardResult.and(customQFilter) : standardResult.or(customQFilter);
                return finalQFilter;
            }
            catch (Exception e) {
                String errorMsg = DataRuleCache.getMessage1(appNum) + ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e\u89c4\u5219(getDataRuleForBdProp)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6ce8\u518c\u7684\u670d\u52a1\u662f\u5426\u6b63\u786e\u3002", (String)"DataRuleCache_46", (String)SYSTEM_TYPE, (Object[])new Object[0]) + e.getMessage();
                logger.warn(errorMsg);
            }
        }
        return DataRuleCache.getDataRuleForBdPropWithCustParam(userId, appId, dataEntityType, propKey, permItemId, dimObjIds, needLoadBdEntTypeDataRule, customParam);
    }

    public static QFilter getDataRuleForBdProp(long userId, String appId, String entityNum, String propKey, String permItemId, List<Long> dimObjIds, boolean needLoadBdEntTypeDataRule) {
        return DataRuleCache.getDataRuleForBdPropWithCustParam(userId, appId, entityNum, propKey, permItemId, dimObjIds, needLoadBdEntTypeDataRule, null);
    }

    private static QFilter getDataRuleForBdPropWithCustParam(long userId, String appId, String entityNum, String propKey, String permItemId, List<Long> dimObjIds, boolean needLoadBdEntTypeDataRule, Map<String, Object> customParam) {
        entityNum = FormMetadataCache.getFormConfig((String)entityNum).getEntityTypeId();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        return DataRuleCache.getDataRuleForBdPropWithCustParam(userId, appId, (IDataEntityType)dataEntityType, propKey, permItemId, dimObjIds, needLoadBdEntTypeDataRule, customParam);
    }

    private static QFilter getDataRuleForBdPropWithCustParam(long userId, String appId, IDataEntityType dataEntityType, String propKey, String permItemId, List<Long> dimObjIds, boolean needLoadBdEntTypeDataRule, Map<String, Object> customParam) {
        if (userId == 0L || dataEntityType == null || StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)dataEntityType.getName()) || StringUtils.isEmpty((String)propKey)) {
            return null;
        }
        String entityNum = dataEntityType.getName();
        String realAppId = PermCommonUtil.getAppIdFromSuspectedAppNum(appId);
        String[] entityAppArr = EntityMapHelper.changeCheckPermEntity(entityNum, realAppId);
        entityNum = entityAppArr[0];
        boolean hasEnableOldDataRule = PermCommonUtil.hasEnableOldDataRule();
        if (hasEnableOldDataRule) {
            return null;
        }
        entityNum = FormMetadataCache.getFormConfig((String)entityNum).getEntityTypeId();
        String[] arrPropKeys = propKey.split("\\.");
        String firstKey = arrPropKeys[0];
        String secKey = "";
        if (arrPropKeys.length > 1) {
            secKey = arrPropKeys[1];
        }
        MainEntityType met = (MainEntityType)dataEntityType;
        IDataEntityProperty property = met.findProperty(firstKey);
        if (!(met instanceof QueryEntityType)) {
            if (!(property instanceof BasedataProp || property instanceof MulBasedataProp || property instanceof RefBillProp)) {
                return null;
            }
            if (arrPropKeys.length > 2 && !(property instanceof MulBasedataProp)) {
                return null;
            }
        }
        dimObjIds = DataRuleCache.processElementType(dimObjIds);
        String type = CacheMrg.getType4DataRuleObj();
        String key = DataRuleCache.buildCacheKey(METHOD_GETDATARULEFORBDPROP, userId, realAppId, entityNum, propKey, permItemId, dimObjIds, needLoadBdEntTypeDataRule);
        DataRuleResult drr = null;
        String value = DataRuleCache.getDataRuleForBdPropByThreadCache(type, key);
        boolean needLoad = false;
        if (CacheMrg.isLoaded(value)) {
            if (CacheMrg.isData(value)) {
                drr = (DataRuleResult)SerializationUtils.fromJsonString((String)value, DataRuleResult.class);
            }
        } else {
            needLoad = true;
        }
        if (needLoad) {
            drr = DataRuleCache.loadDataRuleForBdProp(userId, realAppId, dataEntityType, propKey, dimObjIds);
            if (drr == null) {
                CacheMrg.loaded(type, key);
            } else {
                CacheMrg.putCache(type, key, SerializationUtils.toJsonString((Object)drr));
            }
        }
        QFilter bdDataRuleFilter = null;
        String bdPropEntNum = null;
        IDataEntityProperty idep = null;
        if (met instanceof QueryEntityType) {
            if (propKey.contains(".")) {
                idep = (IDataEntityProperty)met.getAllFields().get(firstKey);
                if (idep instanceof JoinProperty) {
                    MainEntityType subEntType;
                    QueryEntityType qet = (QueryEntityType)met;
                    List allSubEntTypes = qet.getAllJoinEntityType();
                    Iterator iterator = allSubEntTypes.iterator();
                    while (iterator.hasNext() && (!firstKey.equals((subEntType = (MainEntityType)iterator.next()).getName()) || (idep = subEntType.getProperty(secKey)) == null)) {
                    }
                } else {
                    idep = (IDataEntityProperty)met.getAllFields().get(firstKey);
                }
            } else {
                idep = (IDataEntityProperty)met.getAllFields().get(propKey);
            }
        } else {
            if (propKey.contains(".")) {
                propKey = propKey.substring(0, propKey.indexOf(46));
            }
            idep = (IDataEntityProperty)met.getAllFields().get(propKey);
        }
        if (idep != null) {
            if (idep instanceof BasedataProp) {
                bdPropEntNum = ((BasedataProp)idep).getBaseEntityId();
            } else if (idep instanceof MulBasedataProp) {
                bdPropEntNum = ((MulBasedataProp)idep).getBaseEntityId();
            } else if (idep instanceof RefBillProp) {
                bdPropEntNum = ((RefBillProp)idep).getBillEntityId();
            }
            if (idep instanceof ItemClassProp && !CollectionUtils.isEmpty(customParam) && StringUtils.isNotEmpty((String)((String)customParam.get("itemClassType")))) {
                bdPropEntNum = (String)customParam.get("itemClassType");
            }
        }
        if (drr != null) {
            bdDataRuleFilter = PermCommonUtil.convertDataRuleResultToQFilter(drr, userId, realAppId, bdPropEntNum);
        }
        QFilter viewDataRuleFilter = null;
        if (needLoadBdEntTypeDataRule) {
            String orgViewNum = PermCommonUtil.getUseOrgViewNum(entityNum, firstKey);
            viewDataRuleFilter = DataRuleCache.getDataRuleWithoutDim(userId, realAppId, bdPropEntNum, "47150e89000000ac", dimObjIds, orgViewNum);
        }
        QFilter resultFilter = null;
        resultFilter = viewDataRuleFilter != null ? viewDataRuleFilter.and(bdDataRuleFilter) : bdDataRuleFilter;
        boolean hasEnablePropCollapse = PermCommonUtil.hasEnablePropCollapse();
        if (hasEnablePropCollapse && resultFilter != null) {
            String filterInfo = String.format(ResManager.loadKDString((String)"\u539f\u59cb\u7684\u6570\u636e\u89c4\u5219\uff08\u65b0\uff09\uff1a %1$s [userId:%2$s, appId:%3$s, entityNum:%4$s, propKey:%5$s]", (String)"DataRuleCache_53", (String)SYSTEM_TYPE, (Object[])new Object[0]), resultFilter.toCurrentString(), userId, realAppId, entityNum, propKey);
            logger.info(filterInfo);
            HashMap<String, QFilter> convertRuleRowMap = new HashMap<String, QFilter>(8);
            resultFilter = PermCommonUtil.convertQFilter(bdPropEntNum, resultFilter, convertRuleRowMap);
            String filterInfoAfter = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u540e\u7684\u6570\u636e\u89c4\u5219\uff08\u65b0\uff09: %1$s [userId:%2$s, appId:%3$s, entityNum:%4$s,propKey:%5$s]", (String)"DataRuleCache_54", (String)SYSTEM_TYPE, (Object[])new Object[0]), resultFilter.toCurrentString(), userId, realAppId, entityNum, propKey);
            logger.info(filterInfoAfter);
        }
        return resultFilter;
    }

    private static String getDataRuleForBdPropByThreadCache(String type, String key) {
        String treadCacheKey = String.format("%s%s%s%s", "METHOD_GETDATARULEFORBDPROP_1", RequestContext.get().getAccountId(), type, key);
        Map threadCacheMap = (Map)ThreadCache.get((Object)treadCacheKey, () -> {
            HashMap<String, String> map = new HashMap<String, String>(8);
            String value = CacheMrg.getCache(type, key);
            if (null == value) {
                return map;
            }
            map.put("vv", value);
            return map;
        });
        return (String)threadCacheMap.get("vv");
    }

    private static DataRuleResult loadDataRuleForBdProp(long userId, String appId, IDataEntityType dataEntityType, String propKey, List<Long> dimObjIds) {
        Set<String> roleIds;
        if (dataEntityType == null || StringUtils.isEmpty((String)dataEntityType.getName()) || StringUtils.isEmpty((String)propKey) || propKey.startsWith("\\.") || propKey.endsWith("\\.")) {
            return null;
        }
        MainEntityType met = (MainEntityType)dataEntityType;
        String entityNum = met.getName();
        String[] entityAppArr = EntityMapHelper.changeCheckPermEntity(entityNum, appId);
        entityNum = entityAppArr[0];
        String[] arrPropKeys = propKey.split("\\.");
        String firstKey = arrPropKeys[0];
        String secKey = "";
        if (arrPropKeys.length > 1) {
            secKey = arrPropKeys[1];
        }
        IDataEntityProperty idep = null;
        if (met instanceof QueryEntityType) {
            if (propKey.contains(".")) {
                idep = (IDataEntityProperty)met.getAllFields().get(firstKey);
                if (idep instanceof JoinProperty) {
                    MainEntityType subEntType;
                    QueryEntityType qet = (QueryEntityType)met;
                    List allSubEntTypes = qet.getAllJoinEntityType();
                    Iterator iterator = allSubEntTypes.iterator();
                    while (iterator.hasNext() && (!firstKey.equals((subEntType = (MainEntityType)iterator.next()).getName()) || (idep = subEntType.getProperty(secKey)) == null)) {
                    }
                } else {
                    idep = (IDataEntityProperty)met.getAllFields().get(firstKey);
                }
            } else {
                idep = (IDataEntityProperty)met.getAllFields().get(propKey);
            }
        } else {
            if (propKey.contains(".")) {
                propKey = propKey.substring(0, propKey.indexOf(46));
            }
            idep = (IDataEntityProperty)met.getAllFields().get(propKey);
        }
        if (idep == null) {
            logger.warn("DataRuleCache: entityNum:" + entityNum + ", propKey:" + propKey + ", \u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u5bf9\u8c61\u3002");
            return null;
        }
        if (!(idep instanceof BasedataProp || idep instanceof MulBasedataProp || idep instanceof RefBillProp)) {
            logger.warn("DataRuleCache: entityNum:" + entityNum + ", propKey:" + propKey + " \u4e0d\u662f\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u6216\u5355\u636e\u5c5e\u6027\uff0c\u53ef\u80fd\u6570\u636e\u6709\u95ee\u9898\uff0c\u8bf7\u6ce8\u610f\u68c0\u67e5\u3002");
            return null;
        }
        ArrayList<String> filterJsons = new ArrayList<String>(8);
        DataRuleResult drr = new DataRuleResult();
        drr.setNeedDimCtrl(false);
        List singleResultList = drr.getSingleResultList();
        String dimTypeEntType = PermCommonUtil.getDimTypeByEntityNum(entityNum);
        List<String> userBdPropRoleJsons = DataRuleCache.queryUserDataRuleForBdProp(userId, dimObjIds, dimTypeEntType, appId, entityNum, propKey);
        if (userBdPropRoleJsons != null && !userBdPropRoleJsons.isEmpty()) {
            filterJsons.addAll(userBdPropRoleJsons);
        }
        if (!CollectionUtils.isEmpty(roleIds = UserRoleCache.getRolesByUserId(userId, dimObjIds, dimTypeEntType))) {
            Map<String, DataRulesInfo> roleDataRulesInfoMap = DataRuleCache.queryCommonRoleDataRules(roleIds);
            boolean hasEnableRoleDataRuleNewMdl = PermCommonUtil.hasEnableRoleDataRuleNewModel();
            for (String roleId : roleIds) {
                DataRulesInfo queryCommonRoleDataRules = roleDataRulesInfoMap.get(roleId);
                if (queryCommonRoleDataRules == null) continue;
                if (hasEnableRoleDataRuleNewMdl) {
                    List edriList = queryCommonRoleDataRules.getEntDataRuleInfos();
                    if (CollectionUtils.isEmpty((Collection)edriList)) continue;
                    block2: for (EntDataRuleInfo edri : edriList) {
                        List bpdrList;
                        if (edri == null || !appId.equals(edri.getAppId()) || !entityNum.equals(edri.getEntityNum()) || CollectionUtils.isEmpty((Collection)(bpdrList = edri.getBdPropsDataRule()))) continue;
                        for (EntDataRuleInfo.BdPropsDataRule bpdr : bpdrList) {
                            String filterJson;
                            if (bpdr == null || !firstKey.equals(bpdr.getPropKey()) && !(firstKey + "." + secKey).equals(bpdr.getPropKey()) && !propKey.equals(bpdr.getPropKey())) continue;
                            FilterCondition fc = bpdr.getDataRule().getRule();
                            if (fc == null || !StringUtils.isEmpty((String)(filterJson = fc.getFilter()))) continue block2;
                            filterJson = SerializationUtils.toJsonString((Object)fc);
                            if (StringUtils.isEmpty((String)filterJson)) continue;
                            filterJsons.add(filterJson);
                            continue block2;
                        }
                    }
                    continue;
                }
                List entryInfos = queryCommonRoleDataRules.getEntryInfos();
                if (CollectionUtils.isEmpty((Collection)entryInfos)) continue;
                block4: for (DataRulesInfo.DataRulesEntryInfo drei : entryInfos) {
                    List bpdrList;
                    DataRuleInfo dataRule;
                    if (drei == null || !appId.equals(drei.getAppId()) || !entityNum.equals(drei.getEntityNum()) || (dataRule = drei.getDataRule()) == null || CollectionUtils.isEmpty((Collection)(bpdrList = dataRule.getBdPropsDataRule()))) continue;
                    for (DataRuleInfo.BdPropsDataRule bpdr : bpdrList) {
                        String filterJson;
                        if (bpdr == null || !firstKey.equals(bpdr.getPropKey()) && !(firstKey + "." + secKey).equals(bpdr.getPropKey()) && !propKey.equals(bpdr.getPropKey())) continue;
                        FilterCondition fc = bpdr.getDataRule().getRule();
                        if (fc == null || !StringUtils.isEmpty((String)(filterJson = fc.getFilter()))) continue block4;
                        filterJson = SerializationUtils.toJsonString((Object)fc);
                        if (StringUtils.isEmpty((String)filterJson)) continue;
                        filterJsons.add(filterJson);
                        continue block4;
                    }
                }
            }
        }
        for (String filterJson : filterJsons) {
            DataRuleSingleResult drsr = new DataRuleSingleResult();
            if (StringUtils.isEmpty((String)filterJson)) continue;
            drsr.setFilterJson(filterJson);
            singleResultList.add(drsr);
        }
        if (singleResultList.isEmpty()) {
            return null;
        }
        return drr;
    }

    private static List<String> queryUserDataRuleForBdProp(long userId, List<Long> dimObjIds, String dimTypeEntNum, String appId, String entityNum, String propKey) {
        ArrayList<String> result = new ArrayList<String>();
        List<Object> dimObjIdsNewParam = new ArrayList(8);
        if (dimObjIds != null && !dimObjIds.isEmpty()) {
            dimObjIdsNewParam = new ArrayList<Long>(dimObjIds);
            dimObjIdsNewParam = dimObjIdsNewParam.stream().filter(p -> p != null && !p.equals(0L)).collect(Collectors.toList());
        }
        StringBuilder sbQueryUserDataRuleSql = new StringBuilder().append("select fdimid, fisincludesub, fdataruleid ").append(" from t_perm_userdatarule_prop ").append(" where fuserid = ? and fappid = ? and fentitynum = ? and fpropkey = ? ");
        if (StringUtils.isNotEmpty((String)dimTypeEntNum)) {
            sbQueryUserDataRuleSql.append(" and fdimtype = '").append(dimTypeEntNum).append("' ");
        }
        HashMap includeSubDimInfo = new HashMap();
        HashMap notIncludeSubDimInfo = new HashMap();
        HashSet<String> matchDataRuleIds = new HashSet<String>();
        DB.query((DBRoute)DBRoute.permission, (String)sbQueryUserDataRuleSql.toString(), (Object[])new Object[]{userId, appId, entityNum, propKey}, rs -> {
            while (rs.next()) {
                Long dimId = rs.getLong("fdimid");
                Boolean isIncludeSub = rs.getBoolean("fisincludesub");
                Long dataRuleId = rs.getLong("fdataruleid");
                if (Boolean.TRUE.equals(isIncludeSub)) {
                    includeSubDimInfo.put(dimId, dataRuleId);
                } else {
                    notIncludeSubDimInfo.put(dimId, dataRuleId);
                }
                matchDataRuleIds.add(dataRuleId.toString());
            }
            return null;
        });
        if (includeSubDimInfo.isEmpty() && notIncludeSubDimInfo.isEmpty()) {
            return result;
        }
        if (dimObjIdsNewParam != null && !dimObjIdsNewParam.isEmpty()) {
            Map allSupOrgMap;
            matchDataRuleIds.clear();
            if (!notIncludeSubDimInfo.isEmpty()) {
                Set notIncludeSubDimIds = notIncludeSubDimInfo.keySet();
                notIncludeSubDimIds.retainAll(dimObjIdsNewParam);
                for (Long dataRuleId : notIncludeSubDimInfo.values()) {
                    if (dataRuleId == null || dataRuleId.equals(0L)) continue;
                    matchDataRuleIds.add(dataRuleId.toString());
                }
            }
            String orgViewNum = PermCommonUtil.getUseOrgViewNum(entityNum, propKey);
            if (!includeSubDimInfo.isEmpty() && (allSupOrgMap = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgViewNum, dimObjIdsNewParam)) != null && !allSupOrgMap.isEmpty()) {
                Collection allSupOrgMapValues = allSupOrgMap.values();
                HashSet<Object> allSupOrgIds = new HashSet<Object>();
                for (List list : allSupOrgMapValues) {
                    allSupOrgIds.addAll(list);
                }
                allSupOrgIds.addAll(dimObjIdsNewParam);
                if (allSupOrgIds != null && !allSupOrgIds.isEmpty()) {
                    Set includeSubDimIds = includeSubDimInfo.keySet();
                    includeSubDimIds.retainAll(allSupOrgIds);
                    for (Long dataRuleId : includeSubDimInfo.values()) {
                        if (dataRuleId == null || dataRuleId.equals(0L)) continue;
                        matchDataRuleIds.add(dataRuleId.toString());
                    }
                }
            }
        }
        if (matchDataRuleIds != null && !matchDataRuleIds.isEmpty()) {
            String matchDataRuleIdStr = String.join((CharSequence)",", matchDataRuleIds);
            String queryDataRuleSql = "select fid, frule from t_perm_datarule where fenable='1' and fid in(" + matchDataRuleIdStr + ")";
            DB.query((DBRoute)DBRoute.permission, (String)queryDataRuleSql, null, rs -> {
                while (rs.next()) {
                    String jsonRule = rs.getString("frule");
                    if (!StringUtils.isNotEmpty((String)jsonRule)) continue;
                    result.add(jsonRule);
                }
                return null;
            });
        }
        return result;
    }

    private static Set<String> queryMulBdPropKeysFromUserDataRule(long userId, String appId, String entityNum, Set<String> allMulBdPropKeys, Map<String, Set<String>> allMulBdPropTypeMap) {
        HashSet<String> bdPropKeys = new HashSet<String>(8);
        if (allMulBdPropKeys == null || allMulBdPropKeys.isEmpty()) {
            return bdPropKeys;
        }
        StringBuilder sbQueryUserDataRulePropSql = new StringBuilder().append("select fpropkey ").append(" from t_perm_userdatarule_prop ").append(" where fuserid = ? and fappid = ? and fentitynum = ? ");
        DB.query((DBRoute)DBRoute.permission, (String)sbQueryUserDataRulePropSql.toString(), (Object[])new Object[]{userId, appId, entityNum}, rs -> {
            while (rs.next()) {
                String propKey = rs.getString("fpropkey");
                bdPropKeys.add(propKey);
            }
            return null;
        });
        bdPropKeys.retainAll(allMulBdPropKeys);
        if (allMulBdPropTypeMap != null && !allMulBdPropTypeMap.isEmpty()) {
            StringBuilder sbQueryUserDataRuleSql = new StringBuilder().append("select distinct fentitynum ").append(" from t_perm_userdatarule ").append(" where fuserid = ? and fpermitemid = '").append("47150e89000000ac").append("' ");
            DB.query((DBRoute)DBRoute.permission, (String)sbQueryUserDataRuleSql.toString(), (Object[])new Object[]{userId}, rs -> {
                while (rs.next()) {
                    Set tempPropKeys;
                    String propEntityNum = rs.getString("fentitynum");
                    if (StringUtils.isEmpty((String)propEntityNum) || (tempPropKeys = (Set)allMulBdPropTypeMap.get(propEntityNum)) == null || tempPropKeys.isEmpty()) continue;
                    bdPropKeys.addAll(tempPropKeys);
                }
                return null;
            });
        }
        return bdPropKeys;
    }

    public static QFilter getDataRuleWithoutDim(long userId, String appId, String entityNum, String permItemId, List<Long> dimObjIds) {
        HashMap<String, Object> customParam = new HashMap<String, Object>(8);
        CustomPermServInfo customServInfo = CustomPermServInfo.getCustPermServInfo(appId, customParam);
        if (customServInfo != null && StringUtils.isNotEmpty((String)customServInfo.getAppId())) {
            boolean skipPlatformImp = customServInfo.isSkipPlatformImp();
            boolean isAnd = customServInfo.isAnd();
            String appNum = customServInfo.getAppNum();
            Object customResult = null;
            customParam.remove(CUSTOMPARAM_DATARULE_EXTDATAENTSET);
            try {
                customResult = DataRuleCache.invokeBizMethod(customServInfo, "getDataRuleWithoutDim", userId, appId, entityNum, permItemId, dimObjIds, customParam);
                QFilter customQFilter = (QFilter)customResult;
                if (skipPlatformImp) {
                    return customQFilter;
                }
                QFilter standardResult = DataRuleCache.getDataRuleWithoutDim(userId, appId, entityNum, permItemId, dimObjIds, "15");
                if (standardResult == null) {
                    return customQFilter;
                }
                if (customQFilter == null) {
                    return standardResult;
                }
                QFilter finalQFilter = null;
                finalQFilter = isAnd ? standardResult.and(customQFilter) : standardResult.or(customQFilter);
                return finalQFilter;
            }
            catch (Exception e) {
                String errorMsg = DataRuleCache.getMessage1(appNum) + ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e\u89c4\u5219(getDataRuleWithoutDim)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6ce8\u518c\u7684\u670d\u52a1\u662f\u5426\u6b63\u786e\u3002", (String)"DataRuleCache_67", (String)SYSTEM_TYPE, (Object[])new Object[0]) + e.getMessage();
                logger.warn(errorMsg);
            }
        }
        return DataRuleCache.getDataRuleWithoutDim(userId, appId, entityNum, permItemId, dimObjIds, "15");
    }

    public static QFilter getDataRuleWithoutDim(long userId, String appId, String entityNum, String permItemId, List<Long> dimObjIds, String orgViewNum) {
        boolean existMulBdPropAtNotViewPerm;
        if (userId == 0L || StringUtils.isEmpty((String)entityNum)) {
            return null;
        }
        if (StringUtils.isEmpty((String)permItemId)) {
            permItemId = "empty";
        }
        String type = CacheMrg.getType4DataRuleObj();
        appId = PermCommonUtil.getAppIdFromSuspectedAppNum(appId);
        String checkPermAppId = PermCommonUtil.getCheckPermAppId(appId, entityNum);
        String key = DataRuleCache.buildCacheKey("getDataRuleWithoutDim", userId, checkPermAppId, entityNum, permItemId, dimObjIds);
        QFilter resultFilter = null;
        DataRuleResult drr = null;
        String value = DataRuleCache.getDataRuleWithoutDimByThreadCache(type, key);
        boolean needLoad = false;
        if (CacheMrg.isLoaded(value)) {
            if (CacheMrg.isData(value)) {
                drr = (DataRuleResult)SerializationUtils.fromJsonString((String)value, DataRuleResult.class);
            }
        } else {
            needLoad = true;
        }
        if (needLoad) {
            drr = DataRuleCache.loadDataRuleWithoutDim(userId, checkPermAppId, entityNum, permItemId, dimObjIds, orgViewNum);
            if (drr == null) {
                CacheMrg.loaded(type, key);
                return null;
            }
            CacheMrg.putCache(type, key, SerializationUtils.toJsonString((Object)drr));
        }
        if (existMulBdPropAtNotViewPerm = DataRuleCache.existMulBdPropInQFilterAtNotViewPerm(resultFilter = PermCommonUtil.convertDataRuleResultToQFilter(drr, userId, appId, entityNum), entityNum, permItemId)) {
            String notSupportMsg = DataRuleCache.getMulDataRuleNotSupportMsg(permItemId);
            throw new KDException(new ErrorCode(ERRCODE_DATARULE_NOTSUPPORT_NOTVIEW_MULBD, notSupportMsg), new Object[0]);
        }
        boolean hasEnablePropCollapse = PermCommonUtil.hasEnablePropCollapse();
        if (hasEnablePropCollapse && resultFilter != null) {
            String filterInfo = String.format(ResManager.loadKDString((String)"\u539f\u59cb\u7684\u6570\u636e\u89c4\u5219\uff08\u65b0\uff09\uff1a %1$s [userId:%2$s, appId:%3$s, entityNum:%4$s, permItemId:%5$s]", (String)"DataRuleCache_45", (String)SYSTEM_TYPE, (Object[])new Object[0]), resultFilter.toCurrentString(), userId, appId, entityNum, permItemId);
            logger.info(filterInfo);
            resultFilter = PermCommonUtil.convertQFilter(entityNum, resultFilter);
            String filterInfoAfter = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u540e\u7684\u6570\u636e\u89c4\u5219\uff08\u65b0\uff09: %1$s [userId:%2$s, appId:%3$s, entityNum:%4$s,permItemId:%5$s]", (String)"DataRuleCache_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), resultFilter.toCurrentString(), userId, appId, entityNum, permItemId);
            logger.info(filterInfoAfter);
        }
        return resultFilter;
    }

    private static String getDataRuleWithoutDimByThreadCache(String type, String key) {
        String treadCacheKey = String.format("%s%s%s%s", "getDataRuleWithoutDimByThreadCache_", RequestContext.get().getAccountId(), type, key);
        Map threadCacheMap = (Map)ThreadCache.get((Object)treadCacheKey, () -> {
            HashMap<String, String> map = new HashMap<String, String>(8);
            String value = CacheMrg.getCache(type, key);
            if (null == value) {
                return map;
            }
            map.put("vv", value);
            return map;
        });
        return (String)threadCacheMap.get("vv");
    }

    public static QFilter getDataRuleWithoutDim(long userId, String appId, String entityNum, String permItemId, List<Long> dimObjIds, Map<String, Object> customParam) {
        CustomPermServInfo customServInfo = CustomPermServInfo.getCustPermServInfo(appId, customParam);
        if (customServInfo != null && StringUtils.isNotEmpty((String)customServInfo.getAppId())) {
            boolean skipPlatformImp = customServInfo.isSkipPlatformImp();
            boolean isAnd = customServInfo.isAnd();
            String appNum = customServInfo.getAppNum();
            Object customResult = null;
            customParam.remove(CUSTOMPARAM_DATARULE_EXTDATAENTSET);
            try {
                customResult = DataRuleCache.invokeBizMethod(customServInfo, "getDataRuleWithoutDim", userId, appId, entityNum, permItemId, dimObjIds, customParam);
                QFilter customQFilter = (QFilter)customResult;
                if (skipPlatformImp) {
                    return customQFilter;
                }
                QFilter standardResult = DataRuleCache.getDataRuleWithoutDim(userId, appId, entityNum, permItemId, dimObjIds, "15");
                if (standardResult == null) {
                    return customQFilter;
                }
                if (customQFilter == null) {
                    return standardResult;
                }
                QFilter finalQFilter = null;
                finalQFilter = isAnd ? standardResult.and(customQFilter) : standardResult.or(customQFilter);
                return finalQFilter;
            }
            catch (Exception e) {
                String errorMsg = DataRuleCache.getMessage1(appNum) + ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e\u89c4\u5219(getDataRule)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6ce8\u518c\u7684\u670d\u52a1\u662f\u5426\u6b63\u786e\u3002", (String)"DataRuleCache_44", (String)SYSTEM_TYPE, (Object[])new Object[0]) + e.getMessage();
                logger.warn(errorMsg);
            }
        }
        return DataRuleCache.getDataRuleWithoutDim(userId, appId, entityNum, permItemId, dimObjIds, "15");
    }

    public static Map<Object, Boolean> matchDataRule(long userId, String appId, String entityNum, String permItemId, Object[] pkIds, Map<String, Object> customParam) {
        if (pkIds == null || pkIds.length == 0) {
            return null;
        }
        QFilter[] idsFilter = new QFilter[]{new QFilter("id", "in", Arrays.asList(pkIds))};
        return DataRuleCache.matchDataRule(userId, appId, entityNum, permItemId, idsFilter, customParam);
    }

    public static Boolean matchDataRule(long userId, String appId, String entityNum, String permItemId, Object pkId, Map<String, Object> customParam) {
        Map<Object, Boolean> matchDataRuleMap = DataRuleCache.matchDataRule(userId, appId, entityNum, permItemId, new Object[]{pkId}, customParam);
        if (matchDataRuleMap == null || matchDataRuleMap.size() == 0) {
            return Boolean.TRUE;
        }
        Boolean matchResult = matchDataRuleMap.values().iterator().next();
        return matchResult;
    }

    private static String getCustomDataRuleScript(CustomPermServInfo customServInfo, Long userId, String appId, String entityNum, String permItemId, Map<String, Object> customParam) {
        boolean skipPlatformImp = customServInfo.isSkipPlatformImp();
        boolean isAnd = customServInfo.isAnd();
        String appNum = customServInfo.getAppNum();
        Object customResult = null;
        try {
            customParam.remove(CUSTOMPARAM_DATARULE_EXTDATAENTSET);
            customResult = DataRuleCache.invokeBizMethod(customServInfo, METHOD_GET_DATA_RULE_SCRIPT, userId, appId, entityNum, permItemId, customParam);
            String customResultStr = (String)customResult;
            if (skipPlatformImp) {
                return customResultStr;
            }
            String standardResult = DataRuleCache.getDataRuleScript(userId, appId, entityNum, permItemId);
            if (StringUtils.isEmpty((String)standardResult)) {
                return customResultStr;
            }
            if (StringUtils.isEmpty((String)customResultStr)) {
                return standardResult;
            }
            String finalResultStr = "";
            finalResultStr = isAnd ? standardResult + " and (" + customResultStr + ") " : standardResult + " or (" + customResultStr + ") ";
            return finalResultStr;
        }
        catch (Exception e) {
            String errorMsg = DataRuleCache.getMessage1(appNum) + ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e\u89c4\u5219(getDataRuleScript)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6ce8\u518c\u670d\u52a1\u4fe1\u606f\u662f\u5426\u6b63\u786e\u3002", (String)"DataRuleCache_47", (String)SYSTEM_TYPE, (Object[])new Object[0]) + e.getMessage();
            logger.warn(errorMsg);
            return "";
        }
    }

    public static String getDataRuleScript(Long userId, String appId, String entityNum, String permItemId) {
        String dataRuleScript;
        String resultScript = null;
        if (userId == 0L || StringUtils.isEmpty((String)entityNum)) {
            return DATARULE_SCRIPT_EVERFALSE;
        }
        String tableNameInDB = EntityMetadataCache.getDataEntityType((String)entityNum).getAlias();
        if (StringUtils.isEmpty((String)tableNameInDB)) {
            return DATARULE_SCRIPT_EVERTRUE;
        }
        boolean hasEnableOldDataRule = PermCommonUtil.hasEnableOldDataRule();
        if (hasEnableOldDataRule) {
            return DATARULE_SCRIPT_EVERTRUE;
        }
        if (StringUtils.isEmpty((String)permItemId)) {
            permItemId = "empty";
        }
        String type = CacheMrg.getType4DataRuleObj();
        appId = PermCommonUtil.getAppIdFromSuspectedAppNum(appId);
        String checkPermAppId = PermCommonUtil.getCheckPermAppId(appId, entityNum);
        String key = DataRuleCache.buildCacheKey(METHOD_GET_DATA_RULE_SCRIPT, userId, checkPermAppId, entityNum, permItemId);
        DataRuleResult drr = null;
        String value = CacheMrg.getCache(type, key);
        boolean needLoad = false;
        if (CacheMrg.isLoaded(value)) {
            if (CacheMrg.isData(value)) {
                drr = (DataRuleResult)SerializationUtils.fromJsonString((String)value, DataRuleResult.class);
            }
        } else {
            needLoad = true;
        }
        String checkPermDimObjFieldKey = PermCommonUtil.getCheckPermDimObjFieldKey(entityNum);
        boolean isNeedDimCtrlNow = StringUtils.isNotEmpty((String)checkPermDimObjFieldKey);
        if (needLoad) {
            drr = DataRuleCache.loadDataRule(userId, checkPermAppId, entityNum, permItemId, new HashMap<String, Object>(1), checkPermDimObjFieldKey);
            if (drr == null) {
                CacheMrg.loaded(type, key);
                return null;
            }
            CacheMrg.putCache(type, key, SerializationUtils.toJsonString((Object)drr));
        }
        if (drr != null && drr.isNeedDimCtrl() != isNeedDimCtrlNow) {
            drr = DataRuleCache.loadDataRule(userId, checkPermAppId, entityNum, permItemId, new HashMap<String, Object>(1), checkPermDimObjFieldKey);
            if (drr == null) {
                CacheMrg.loaded(type, key);
                return null;
            }
            CacheMrg.putCache(type, key, SerializationUtils.toJsonString((Object)drr));
        }
        if (StringUtils.isNotEmpty((String)(dataRuleScript = PermCommonUtil.convertDataRuleResultToScript(drr, userId, appId, entityNum)))) {
            String filterInfo = String.format(ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219Script\uff1a %1$s [userId:%2$s, appId:%3$s, entityNum:%4$s,permItemId:%5$s]", (String)"DataRuleCache_48", (String)SYSTEM_TYPE, (Object[])new Object[0]), dataRuleScript, userId, appId, entityNum, permItemId);
            logger.info(filterInfo);
        }
        resultScript = StringUtils.isEmpty((String)dataRuleScript) ? DATARULE_SCRIPT_EVERTRUE : dataRuleScript;
        if (DataRuleCache.existMulBdPropInScript(entityNum, dataRuleScript)) {
            String notSupportMsg = DataRuleCache.getMulDataRuleNotSupportMsg(permItemId);
            throw new KDException(new ErrorCode(ERRCODE_DATARULE_NOTSUPPORT_NOTVIEW_MULBD, notSupportMsg), new Object[0]);
        }
        return resultScript;
    }

    public static String getDataRuleScript(Long userId, String appId, String entityNum, String permItemId, Map<String, Object> customParam) {
        String checkPermAppId = PermCommonUtil.getCheckPermAppId2(appId = PermCommonUtil.getAppIdFromSuspectedAppNum(appId), entityNum);
        CustomPermServInfo customServInfo = CustomPermServInfo.getCustPermServInfo(checkPermAppId, customParam);
        if (customServInfo != null) {
            return DataRuleCache.getCustomDataRuleScript(customServInfo, userId, checkPermAppId, entityNum, permItemId, customParam);
        }
        StringBuilder sbResultScript = new StringBuilder();
        String orgnlDataRuleScript = DataRuleCache.getDataRuleScript(userId, checkPermAppId, entityNum, permItemId);
        if (StringUtils.isNotEmpty((String)orgnlDataRuleScript)) {
            sbResultScript.append(orgnlDataRuleScript);
        }
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IDataRuleExt.class, (String)"kd.bos.permission.api.ext.IDataRuleExt", null);
            PluginCall call = p -> {
                String script;
                if (p != null && StringUtils.isNotEmpty((String)(script = p.getDataRuleScriptByBaseData(userId, checkPermAppId, entityNum, permItemId, customParam)))) {
                    return script;
                }
                return "";
            };
            List pluginResults = pluginProxy.callReplaceIfPresent(call);
            if (pluginResults != null && !pluginResults.isEmpty()) {
                for (String tempScript : pluginResults) {
                    if (StringUtils.isEmpty((String)tempScript)) continue;
                    sbResultScript.append(" and ").append(tempScript);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return sbResultScript.toString();
    }

    public static Map<Object, Boolean> matchDataRule(long userId, String appId, String entityNum, String permItemId, QFilter[] qFilters, Map<String, Object> customParam) {
        CustomPermServInfo customServInfo = CustomPermServInfo.getCustPermServInfo(appId, customParam);
        if (customServInfo != null) {
            boolean skipPlatformImp = customServInfo.isSkipPlatformImp();
            boolean isAnd = customServInfo.isAnd();
            String appNum = customServInfo.getAppNum();
            Object customResult = null;
            try {
                customParam.remove(CUSTOMPARAM_DATARULE_EXTDATAENTSET);
                customResult = DataRuleCache.invokeBizMethod(customServInfo, "matchDataRule", userId, appId, entityNum, permItemId, qFilters, customParam);
                HashMap<Object, Boolean> customResultMap = (HashMap<Object, Boolean>)customResult;
                if (CollectionUtils.isEmpty((Map)customResultMap)) {
                    customResultMap = new HashMap<Object, Boolean>(8);
                }
                if (skipPlatformImp) {
                    return customResultMap;
                }
                Map<Object, Boolean> standardResult = DataRuleCache.matchDataRuleInBatch(userId, appId, entityNum, permItemId, qFilters);
                if (CollectionUtils.isEmpty(standardResult)) {
                    return customResultMap;
                }
                if (CollectionUtils.isEmpty(customResultMap)) {
                    return standardResult;
                }
                for (Map.Entry<Object, Boolean> entry : standardResult.entrySet()) {
                    Boolean customResultValue;
                    Object key = entry.getKey();
                    Boolean value = entry.getValue();
                    if (value == null) {
                        value = Boolean.FALSE;
                    }
                    if ((customResultValue = (Boolean)customResultMap.get(key)) == null) continue;
                    Boolean newValue = null;
                    newValue = isAnd ? Boolean.valueOf(value != false && customResultValue != false) : Boolean.valueOf(value != false || customResultValue != false);
                    customResultMap.put(key, newValue);
                    standardResult.put(key, newValue);
                }
                standardResult.putAll(customResultMap);
                return standardResult;
            }
            catch (Exception e) {
                String errorMsg = DataRuleCache.getMessage1(appNum) + ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e\u89c4\u5219(matchDataRule)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6ce8\u518c\u7684\u670d\u52a1\u662f\u5426\u6b63\u786e\u3002", (String)"DataRuleCache_49", (String)SYSTEM_TYPE, (Object[])new Object[0]) + e.getMessage();
                logger.warn(errorMsg);
            }
        }
        return DataRuleCache.matchDataRuleInBatch(userId, appId, entityNum, permItemId, qFilters);
    }

    public static Map<Object, Boolean> matchDataRuleInBatch(long userId, String appId, String entityNum, String permItemId, QFilter[] qFilters) {
        return DataRuleCache.matchDataRuleInBatch(userId, appId, entityNum, permItemId, qFilters, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Object, Boolean> matchDataRuleInBatch(long userId, String appId, String entityNum, String permItemId, QFilter[] qFilters, List<Long> dimObjIds) {
        void var14_29;
        void var16_40;
        HashMap<Object, Boolean> resultMap = new HashMap<Object, Boolean>(8);
        if (userId == 0L || StringUtils.isEmpty((String)entityNum)) {
            return new HashMap<Object, Boolean>(8);
        }
        String tableNameInDB = EntityMetadataCache.getDataEntityType((String)entityNum).getAlias();
        if (StringUtils.isEmpty((String)tableNameInDB)) {
            return new HashMap<Object, Boolean>(8);
        }
        if (ArrayUtils.isEmpty((Object[])qFilters)) {
            return new HashMap<Object, Boolean>(8);
        }
        boolean orgnlExists = QueryServiceHelper.exists((String)entityNum, (QFilter[])qFilters);
        if (!orgnlExists) {
            return new HashMap<Object, Boolean>(8);
        }
        for (QFilter qFilter : qFilters) {
            if (qFilter == null) continue;
            String string = qFilter.getProperty();
            String qfComp = qFilter.getCP();
            Object object = qFilter.getValue();
            if (!"id".equals(string)) continue;
            if ("=".equals(qfComp)) {
                resultMap.put(object, Boolean.FALSE);
            }
            if (!"in".equals(qfComp) || !(object instanceof Collection)) continue;
            for (Object qfValueEle : (Collection)object) {
                resultMap.put(qfValueEle, Boolean.FALSE);
            }
        }
        boolean hasEnableOldDataRule = PermCommonUtil.hasEnableOldDataRule();
        boolean foundExistNotIdFilter = false;
        if (hasEnableOldDataRule) {
            ArrayList<Object> idsInFilter = new ArrayList<Object>(8);
            for (QFilter qFilter : qFilters) {
                if (!qFilter.getProperty().equals("id") || !qFilter.getCP().equals("=")) {
                    foundExistNotIdFilter = true;
                    break;
                }
                idsInFilter.add(qFilter.getValue());
            }
            if (foundExistNotIdFilter) {
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entityNum, (String)"id", (QFilter[])qFilters);
                for (DynamicObject doc : dynamicObjectCollection) {
                    resultMap.put(doc.get("id"), Boolean.TRUE);
                }
            } else {
                for (Object e : idsInFilter) {
                    resultMap.put(e, Boolean.TRUE);
                }
            }
            return resultMap;
        }
        if (StringUtils.isEmpty((String)permItemId)) {
            permItemId = "empty";
        }
        HashSet<Object> idsInCurDataRows = new HashSet<Object>(8);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entityNum, (String)"id", (QFilter[])qFilters);
        for (DynamicObject doc : dynamicObjectCollection) {
            idsInCurDataRows.add(doc.get("id"));
        }
        QFilter[] qFilterArray = qFilters;
        int doc = qFilterArray.length;
        boolean bl = false;
        while (var16_40 < doc) {
            QFilter qf = qFilterArray[var16_40];
            if (qf != null) {
                String qfPropKey = qf.getProperty();
                String string = qf.getCP();
                Object qfValue = qf.getValue();
                if ("id".equals(qfPropKey)) {
                    if ("=".equals(string)) {
                        idsInCurDataRows.add(qfValue);
                    }
                    if ("in".equals(string) && qfValue instanceof Collection) {
                        idsInCurDataRows.addAll((Collection)qfValue);
                    }
                }
            }
            ++var16_40;
        }
        Object var14_26 = null;
        if (dimObjIds == null || dimObjIds.isEmpty()) {
            QFilter qFilter = DataRuleCache.getDataRuleWithExtPluginAndCustQFilter(userId, appId, entityNum, permItemId, qFilters, null);
        } else {
            QFilter qFilter = DataRuleCache.getDataRuleWithoutDim(userId, appId, entityNum, permItemId, dimObjIds);
        }
        if (var14_29 != null) {
            ArrayList<QFilter> qList = new ArrayList<QFilter>(Arrays.asList(qFilters));
            qList.add((QFilter)var14_29);
            qFilters = qList.toArray(new QFilter[qList.size()]);
            ArrayList<Object> arrayList = new ArrayList<Object>(8);
            DynamicObjectCollection filterDataRows = QueryServiceHelper.query((String)entityNum, (String)"id", (QFilter[])qFilters);
            for (DynamicObject dynamicObject : filterDataRows) {
                arrayList.add(dynamicObject.get("id"));
            }
            idsInCurDataRows.removeAll(arrayList);
            for (Object e : idsInCurDataRows) {
                resultMap.put(e, Boolean.FALSE);
            }
            for (Object e : filterDataRows) {
                if (e == null) continue;
                resultMap.put(((DynamicObject)e).get("id"), Boolean.TRUE);
            }
        } else {
            for (Object e : idsInCurDataRows) {
                resultMap.put(e, Boolean.TRUE);
            }
        }
        return resultMap;
    }

    private static boolean existMulBdPropInQFilterAtNotViewPerm(QFilter pQFilter, String entityNum, String permItemId) {
        if (pQFilter == null) {
            return false;
        }
        QFilter copyFilter = pQFilter.copy();
        if ("47150e89000000ac".equals(permItemId)) {
            return false;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        ArrayList list = new ArrayList(8);
        copyFilter.trans(q -> {
            list.add(q);
            return q;
        });
        boolean existMulBdProp = false;
        for (QFilter q2 : list) {
            IDataEntityProperty secVarProp;
            String secPropKey;
            IDataEntityProperty firstVarProp;
            String firstPropKey;
            String[] propPartArr;
            String propKey = q2.getProperty();
            if (StringUtils.isEmpty((String)propKey) || (propPartArr = propKey.split("\\.")) == null || propPartArr.length == 0 || StringUtils.isEmpty((String)(firstPropKey = propPartArr[0])) || (firstVarProp = dataEntityType.findProperty(firstPropKey)) == null) continue;
            if (firstVarProp instanceof MulBasedataProp) {
                existMulBdProp = true;
                break;
            }
            if (!(firstVarProp instanceof EntryProp) || propPartArr.length < 2 || StringUtils.isEmpty((String)(secPropKey = propPartArr[1])) || (secVarProp = dataEntityType.findProperty(secPropKey)) == null || !(secVarProp instanceof MulBasedataProp)) continue;
            existMulBdProp = true;
            break;
        }
        return existMulBdProp;
    }

    public static boolean matchDataRule(long userId, String appId, String entityNum, String permItemId, QFilter[] qFilters) {
        QFilter dataRuleFilter;
        boolean hasEnableOldDataRule = PermCommonUtil.hasEnableOldDataRule();
        if (hasEnableOldDataRule) {
            return true;
        }
        if (userId == 0L || StringUtils.isEmpty((String)entityNum)) {
            return false;
        }
        String tableNameInDB = EntityMetadataCache.getDataEntityType((String)entityNum).getAlias();
        if (StringUtils.isEmpty((String)tableNameInDB)) {
            return true;
        }
        if (ArrayUtils.isEmpty((Object[])qFilters)) {
            return true;
        }
        boolean orgnlExists = QueryServiceHelper.exists((String)entityNum, (QFilter[])qFilters);
        if (!orgnlExists) {
            return true;
        }
        if (StringUtils.isEmpty((String)permItemId)) {
            permItemId = "empty";
        }
        if ((dataRuleFilter = DataRuleCache.getDataRuleWithExtPluginAndCustQFilter(userId, appId, entityNum, permItemId, qFilters, null)) != null) {
            ArrayList<QFilter> qList = new ArrayList<QFilter>(Arrays.asList(qFilters));
            qList.add(dataRuleFilter);
            qFilters = qList.toArray(new QFilter[qList.size()]);
            boolean exists = QueryServiceHelper.exists((String)entityNum, (QFilter[])qFilters);
            return exists;
        }
        return true;
    }

    private static QFilter getDataRuleWithExtPluginAndCustQFilter(long userId, String appId, String entityNum, String permItemId, QFilter[] qFilters, Map<String, Object> customParam) {
        if (customParam == null) {
            customParam = new HashMap<String, Object>(8);
        }
        if (qFilters != null) {
            customParam.putIfAbsent(CUSTOMPARAM_DATARULE_QFILTER, qFilters);
        }
        QFilter dataRuleFilter = DataRuleCache.getDataRuleWithExtPlugin(customParam, userId, appId, entityNum, permItemId);
        return dataRuleFilter;
    }

    public static Map<Object, Boolean> matchDataRuleWithoutDim(Long userId, String appId, String entityNum, String permItemId, QFilter[] qFilters, List<Long> dimObjIds) {
        HashMap<String, Object> customParam = new HashMap<String, Object>(16);
        return DataRuleCache.matchDataRuleWithoutDim(userId, appId, entityNum, permItemId, qFilters, dimObjIds, customParam);
    }

    public static Map<Object, Boolean> matchDataRuleWithoutDim(Long userId, String appId, String entityNum, String permItemId, QFilter[] qFilters, List<Long> dimObjIds, Map<String, Object> customParam) {
        CustomPermServInfo customServInfo = CustomPermServInfo.getCustPermServInfo(appId, customParam);
        if (customServInfo != null) {
            boolean skipPlatformImp = customServInfo.isSkipPlatformImp();
            boolean isAnd = customServInfo.isAnd();
            String appNum = customServInfo.getAppNum();
            Object customResult = null;
            try {
                customParam.remove(CUSTOMPARAM_DATARULE_EXTDATAENTSET);
                customResult = DataRuleCache.invokeBizMethod(customServInfo, "matchDataRuleWithoutDim", userId, appId, entityNum, permItemId, qFilters, customParam);
                Map customResultMap = (Map)customResult;
                if (skipPlatformImp) {
                    return customResultMap;
                }
                Map<Object, Boolean> standardResult = DataRuleCache.matchDataRuleInBatch(userId, appId, entityNum, permItemId, qFilters, dimObjIds);
                if (CollectionUtils.isEmpty(standardResult)) {
                    return customResultMap;
                }
                if (CollectionUtils.isEmpty((Map)customResultMap)) {
                    return standardResult;
                }
                for (Map.Entry<Object, Boolean> entry : standardResult.entrySet()) {
                    Boolean customResultValue;
                    Object key = entry.getKey();
                    Boolean value = entry.getValue();
                    if (value == null) {
                        value = Boolean.FALSE;
                    }
                    if ((customResultValue = (Boolean)customResultMap.get(key)) == null) continue;
                    Boolean newValue = null;
                    newValue = isAnd ? Boolean.valueOf(value != false && customResultValue != false) : Boolean.valueOf(value != false || customResultValue != false);
                    customResultMap.put(key, newValue);
                    standardResult.put(key, newValue);
                }
                standardResult.putAll(customResultMap);
                return standardResult;
            }
            catch (Exception e) {
                String errorMsg = DataRuleCache.getMessage1(appNum) + ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e\u89c4\u5219(matchDataRule)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6ce8\u518c\u670d\u52a1\u4fe1\u606f\u662f\u5426\u6b63\u786e\u3002", (String)"DataRuleCache_50", (String)SYSTEM_TYPE, (Object[])new Object[0]) + e.getMessage();
                logger.warn(errorMsg);
            }
        }
        return DataRuleCache.matchDataRuleInBatch(userId, appId, entityNum, permItemId, qFilters, dimObjIds);
    }

    @Deprecated
    public static boolean userOverAllDataRulesMoveToHis() {
        return DataRuleCache.userOverAllDataRulesMoveToHis(null);
    }

    @Deprecated
    public static boolean userOverAllDataRulesMoveToHis(Long userId) {
        return DataRuleCache.userOverAllDataRulesMoveToHis(userId, null);
    }

    @Deprecated
    public static boolean userOverAllDataRulesMoveToHis(Long userId, List<DynamicObject> forMoveToHisList) {
        return false;
    }

    @Deprecated
    public static boolean userAssignOverAllDataRules(Long userId, List<OverAllDataRuleInfo> ovrallDataRuleList, String assignMode, StringBuilder processInfo) {
        return false;
    }

    @Deprecated
    public static String getUserOverAllDataRulesJson(Long userId, String pDimensiontype) {
        return "";
    }

    @Deprecated
    public static Map<String, QFilter> getUserOverAllDataRules(Long userId) {
        return new HashMap<String, QFilter>();
    }

    @Deprecated
    public static Object[] getUserOverAllDataRulesInfo(Long userId) {
        return null;
    }

    @Deprecated
    public static boolean hasConfigSomeOverAllDataRule(Long userId, String entityNum) {
        return false;
    }

    @Deprecated
    public static boolean isOvrAllDataRuleMandatoryConfig(Long userId, String entityNum) {
        return false;
    }

    @Deprecated
    public static QFilter getUserOverAllDataRules(Long userId, String dimensionId) {
        return null;
    }

    @Deprecated
    public static QFilter getUserOverAllDataRules(Long userId, String billEntityNum, String dimensionId, String pPropKey) {
        return null;
    }

    @Deprecated
    public static QFilter getUserOverAllDataRules(Long userId, String billEntityNum, String dimensionId, String pPropKey, QFilter userOverAllDataRules) {
        return null;
    }

    @Deprecated
    public static QFilter getUserOverAllDataRulesFilter(Long userId, String billEntityNum) {
        return null;
    }

    public static void copyUserDataRule(long sourceUserId, long targetUserId) {
        DataRuleCache.copyUserPermItemDataRule(sourceUserId, targetUserId);
        DataRuleCache.copyUserBdPropDataRule(sourceUserId, targetUserId);
    }

    private static void copyUserPermItemDataRule(long sourceUserId, long targetUserId) {
        String queryUserDataRuleSql = "select fid, fdimtype, fdimid, fappid, fentitynum, fpermitemid, fdataruleid, fisincludesub " + "from t_perm_userdatarule " + "where fuserid = ? ";
        ArrayList srcParamList = new ArrayList();
        DB.query((DBRoute)DBRoute.permission, (String)queryUserDataRuleSql, (Object[])new Object[]{sourceUserId}, rs -> {
            while (rs.next()) {
                String dimType = rs.getString("fdimtype");
                Long dimId = rs.getLong("fdimid");
                String appid = rs.getString("fappid");
                String entityNum = rs.getString("fentitynum");
                String permItemId = rs.getString("fpermitemid");
                Long dataRuleId = rs.getLong("fdataruleid");
                String includeSub = rs.getString("fisincludesub");
                srcParamList.add(new Object[]{dimType, dimId, appid, entityNum, permItemId, dataRuleId, includeSub});
            }
            return null;
        });
        if (srcParamList.isEmpty()) {
            return;
        }
        HashMap tarUserInfos = new HashMap();
        DB.query((DBRoute)DBRoute.permission, (String)queryUserDataRuleSql, (Object[])new Object[]{targetUserId}, rs -> {
            while (rs.next()) {
                Long pkId = rs.getLong("fid");
                String dimType = rs.getString("fdimtype");
                Long dimId = rs.getLong("fdimid");
                String appid = rs.getString("fappid");
                String entityNum = rs.getString("fentitynum");
                String permItemId = rs.getString("fpermitemid");
                tarUserInfos.put(pkId, new Object[]{dimType, dimId, appid, entityNum, permItemId});
            }
            return null;
        });
        HashSet<Long> forDeletePkIdTar = new HashSet<Long>();
        block11: for (Map.Entry tarEntry : tarUserInfos.entrySet()) {
            Long pkTarId = (Long)tarEntry.getKey();
            Object[] tarArr = (Object[])tarEntry.getValue();
            String tarDimType = (String)tarArr[0];
            Long tarDimId = (Long)tarArr[1];
            String tarAppid = (String)tarArr[2];
            String tarEntityNum = (String)tarArr[3];
            String tarPermItemId = (String)tarArr[4];
            if (StringUtils.isEmpty((String)tarDimType) || StringUtils.isEmpty((String)tarAppid) || StringUtils.isEmpty((String)tarEntityNum) || StringUtils.isEmpty((String)tarPermItemId) || tarDimId == null || tarDimId.equals(0L)) continue;
            for (Object[] srcArr : srcParamList) {
                String srcDimType = (String)srcArr[0];
                Long srcDimId = (Long)srcArr[1];
                String srcAppid = (String)srcArr[2];
                String srcEntityNum = (String)srcArr[3];
                String srcPermItemId = (String)srcArr[4];
                if (!tarDimType.equals(srcDimType) || !tarDimId.equals(srcDimId) || !tarAppid.equals(srcAppid) || !tarEntityNum.equals(srcEntityNum) || !tarPermItemId.equals(srcPermItemId)) continue;
                forDeletePkIdTar.add(pkTarId);
                continue block11;
            }
        }
        int newInsertCount = srcParamList.size();
        long[] newTarPkIds = DB.genLongIds((String)"t_perm_userdatarule", (int)newInsertCount);
        long curUserId = RequestContext.get().getCurrUserId();
        try (TXHandle h = TX.required();){
            try {
                if (!forDeletePkIdTar.isEmpty()) {
                    Set forDelPkStrIdTar = forDeletePkIdTar.stream().map(String::valueOf).collect(Collectors.toSet());
                    String delPkIdStrs = String.join((CharSequence)",", forDelPkStrIdTar);
                    String deleteSql = "delete from t_perm_userdatarule where fid in(" + delPkIdStrs + ")";
                    DB.execute((DBRoute)DBRoute.permission, (String)deleteSql);
                }
                String insertCopyDataRuleSql = "INSERT INTO t_perm_userdatarule (" + " fid, fuserid, fappid, fentitynum, fpermitemid, fdataruleid, " + " fdimid, fisincludesub, fdimtype, fcreatetime, fcreatorid) " + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ArrayList<Object[]> newSrcParamList = new ArrayList<Object[]>(8);
                for (int i = 0; i < srcParamList.size(); ++i) {
                    Object[] srcArr = (Object[])srcParamList.get(i);
                    String srcDimType = (String)srcArr[0];
                    Long srcDimId = (Long)srcArr[1];
                    String srcAppid = (String)srcArr[2];
                    String srcEntityNum = (String)srcArr[3];
                    String srcPermItemId = (String)srcArr[4];
                    Long srcDataRuleId = (Long)srcArr[5];
                    String srcIncludeSub = (String)srcArr[6];
                    long newPkId = newTarPkIds[i];
                    newSrcParamList.add(new Object[]{newPkId, targetUserId, srcAppid, srcEntityNum, srcPermItemId, srcDataRuleId, srcDimId, srcIncludeSub, srcDimType, new Date(), curUserId});
                }
                DB.executeBatch((DBRoute)DBRoute.permission, (String)insertCopyDataRuleSql, newSrcParamList);
            }
            catch (Exception e) {
                h.markRollback();
                logger.warn("DataRuleCache.copyUserDataRule error", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
    }

    private static void copyUserBdPropDataRule(long sourceUserId, long targetUserId) {
        String queryUserDataRuleSql = "select fid, fdimtype, fdimid, fappid, fentitynum, fpropkey, fpropentnum, fdataruleid, fisincludesub " + " from t_perm_userdatarule_prop " + " where fuserid = ? ";
        ArrayList srcParamList = new ArrayList();
        DB.query((DBRoute)DBRoute.permission, (String)queryUserDataRuleSql, (Object[])new Object[]{sourceUserId}, rs -> {
            while (rs.next()) {
                String dimType = rs.getString("fdimtype");
                Long dimId = rs.getLong("fdimid");
                String appid = rs.getString("fappid");
                String entityNum = rs.getString("fentitynum");
                String propKey = rs.getString("fpropkey");
                String propEntNum = rs.getString("fpropentnum");
                Long dataRuleId = rs.getLong("fdataruleid");
                String includeSub = rs.getString("fisincludesub");
                srcParamList.add(new Object[]{dimType, dimId, appid, entityNum, propKey, propEntNum, dataRuleId, includeSub});
            }
            return null;
        });
        if (srcParamList.isEmpty()) {
            return;
        }
        HashMap tarUserInfos = new HashMap();
        DB.query((DBRoute)DBRoute.permission, (String)queryUserDataRuleSql, (Object[])new Object[]{targetUserId}, rs -> {
            while (rs.next()) {
                Long pkId = rs.getLong("fid");
                String dimType = rs.getString("fdimtype");
                Long dimId = rs.getLong("fdimid");
                String appid = rs.getString("fappid");
                String entityNum = rs.getString("fentitynum");
                String propKey = rs.getString("fpropkey");
                tarUserInfos.put(pkId, new Object[]{dimType, dimId, appid, entityNum, propKey});
            }
            return null;
        });
        HashSet<Long> forDeletePkIdTar = new HashSet<Long>();
        block11: for (Map.Entry tarEntry : tarUserInfos.entrySet()) {
            Long pkTarId = (Long)tarEntry.getKey();
            Object[] tarArr = (Object[])tarEntry.getValue();
            String tarDimType = (String)tarArr[0];
            Long tarDimId = (Long)tarArr[1];
            String tarAppid = (String)tarArr[2];
            String tarEntityNum = (String)tarArr[3];
            String tarPropKey = (String)tarArr[4];
            if (StringUtils.isEmpty((String)tarDimType) || StringUtils.isEmpty((String)tarAppid) || StringUtils.isEmpty((String)tarEntityNum) || StringUtils.isEmpty((String)tarPropKey) || tarDimId == null || tarDimId.equals(0L)) continue;
            for (Object[] srcArr : srcParamList) {
                String srcDimType = (String)srcArr[0];
                Long srcDimId = (Long)srcArr[1];
                String srcAppid = (String)srcArr[2];
                String srcEntityNum = (String)srcArr[3];
                String srcPropKey = (String)srcArr[4];
                if (!tarDimType.equals(srcDimType) || !tarDimId.equals(srcDimId) || !tarAppid.equals(srcAppid) || !tarEntityNum.equals(srcEntityNum) || !tarPropKey.equals(srcPropKey)) continue;
                forDeletePkIdTar.add(pkTarId);
                continue block11;
            }
        }
        int newInsertCount = srcParamList.size();
        long[] newTarPkIds = DB.genLongIds((String)"t_perm_userdatarule_prop", (int)newInsertCount);
        long curUserId = RequestContext.get().getCurrUserId();
        try (TXHandle h = TX.required();){
            try {
                if (!forDeletePkIdTar.isEmpty()) {
                    Set forDelPkStrIdTar = forDeletePkIdTar.stream().map(String::valueOf).collect(Collectors.toSet());
                    String delPkIdStrs = String.join((CharSequence)",", forDelPkStrIdTar);
                    String deleteSql = "delete from t_perm_userdatarule_prop where fid in(" + delPkIdStrs + ")";
                    DB.execute((DBRoute)DBRoute.permission, (String)deleteSql);
                }
                String insertCopyDataRuleSql = "INSERT INTO t_perm_userdatarule_prop (" + " fid, fuserid, fappid, fentitynum, fpropkey, fpropentnum, fdataruleid, " + " fdimid, fisincludesub, fdimtype, fcreatetime, fcreatorid) " + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ArrayList<Object[]> newSrcParamList = new ArrayList<Object[]>(8);
                for (int i = 0; i < srcParamList.size(); ++i) {
                    Object[] srcArr = (Object[])srcParamList.get(i);
                    String srcDimType = (String)srcArr[0];
                    Long srcDimId = (Long)srcArr[1];
                    String srcAppid = (String)srcArr[2];
                    String srcEntityNum = (String)srcArr[3];
                    String srcPropKey = (String)srcArr[4];
                    String srcPropEntNum = (String)srcArr[5];
                    Long srcDataRuleId = (Long)srcArr[6];
                    String srcIncludeSub = (String)srcArr[7];
                    long newPkId = newTarPkIds[i];
                    newSrcParamList.add(new Object[]{newPkId, targetUserId, srcAppid, srcEntityNum, srcPropKey, srcPropEntNum, srcDataRuleId, srcDimId, srcIncludeSub, srcDimType, new Date(), curUserId});
                }
                DB.executeBatch((DBRoute)DBRoute.permission, (String)insertCopyDataRuleSql, newSrcParamList);
            }
            catch (Exception e) {
                h.markRollback();
                logger.warn("DataRuleCache.copyUserBdPropDataRule error", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
    }

    public static Map<String, Object> getAblePkIdsForMulBdProp(long userId, String appId, IDataEntityType dataEntityType, String mulBaseDataPropKey, List<Object> selectedPkIds, List<Long> dimObjIds, Map<String, Object> customParam) {
        boolean selectPkIdsIsEmpty;
        ArrayList<Object> newSelectedPkIds = null;
        if (selectedPkIds != null) {
            newSelectedPkIds = new ArrayList<Object>(selectedPkIds);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        ArrayList ablePkIds = new ArrayList();
        String entityNum = dataEntityType.getName();
        String realAppId = PermCommonUtil.getAppIdFromSuspectedAppNum(appId);
        String checkPermAppId = PermCommonUtil.getCheckPermAppId(realAppId, entityNum);
        QFilter dataRuleQFilter = DataRuleCache.getDataRuleForBdProp(userId, checkPermAppId, dataEntityType, mulBaseDataPropKey, "47150e89000000ac", dimObjIds, true, customParam);
        if (dataRuleQFilter == null) {
            resultMap.put("key", "disabled");
            resultMap.put("items", ablePkIds);
            return resultMap;
        }
        IDataEntityProperty mulBaseDataProp = ((MainEntityType)dataEntityType).findProperty(mulBaseDataPropKey);
        if (mulBaseDataProp == null) {
            logger.warn("mulBaseDataPropKey:" + mulBaseDataPropKey + " can't find!");
            resultMap.put("key", "disabled");
            resultMap.put("items", ablePkIds);
            return resultMap;
        }
        String mulBdTypeKey = ((MulBasedataProp)mulBaseDataProp).getBaseEntityId();
        MainEntityType mulBdType = EntityMetadataCache.getDataEntityType((String)mulBdTypeKey);
        QFilter idFilter = null;
        QFilter matchFilter = dataRuleQFilter;
        boolean bl = selectPkIdsIsEmpty = newSelectedPkIds == null || newSelectedPkIds.isEmpty();
        if (!selectPkIdsIsEmpty) {
            Object pkId;
            int i;
            if (mulBdType.getPrimaryKey() instanceof LongProp) {
                for (i = 0; i < newSelectedPkIds.size(); ++i) {
                    pkId = newSelectedPkIds.get(i);
                    if (pkId == null || pkId instanceof Long) continue;
                    newSelectedPkIds.set(i, Long.valueOf(pkId.toString()));
                }
            } else if (mulBdType.getPrimaryKey() instanceof VarcharProp) {
                for (i = 0; i < newSelectedPkIds.size(); ++i) {
                    pkId = newSelectedPkIds.get(i);
                    if (pkId == null || pkId instanceof String) continue;
                    newSelectedPkIds.set(i, pkId.toString());
                }
            } else {
                logger.error("The primary key type of mulBaseDataProp is invalid!");
            }
            idFilter = new QFilter("id", "in", newSelectedPkIds);
            matchFilter = matchFilter.and(idFilter);
        }
        DynamicObjectCollection idDoc = QueryServiceHelper.query((String)mulBdTypeKey, (String)"id", (QFilter[])new QFilter[]{matchFilter});
        ArrayList<Object> matchIds = new ArrayList<Object>(10);
        if (idDoc != null && !idDoc.isEmpty()) {
            for (DynamicObject dObj : idDoc) {
                Object idObj = dObj.get("id");
                if (idObj == null) continue;
                matchIds.add(idObj);
            }
        }
        if (!selectPkIdsIsEmpty) {
            if (!matchIds.isEmpty()) {
                newSelectedPkIds.removeAll(matchIds);
            }
            resultMap.put("key", "disabled");
            resultMap.put("items", newSelectedPkIds);
            return resultMap;
        }
        DynamicObjectCollection notMatchIdDoc = QueryServiceHelper.query((String)mulBdTypeKey, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "not in", matchIds)});
        ArrayList<Object> notMatchIds = new ArrayList<Object>(10);
        if (notMatchIdDoc != null && !notMatchIdDoc.isEmpty()) {
            for (DynamicObject dObj : notMatchIdDoc) {
                Object idObj = dObj.get("id");
                if (idObj == null) continue;
                notMatchIds.add(idObj);
            }
        }
        resultMap.put("key", "disabled");
        resultMap.put("items", notMatchIds);
        return resultMap;
    }

    public static List<Object> getHasPermPkIdsForMulBdProp(long userId, String appId, IDataEntityType dataEntityType, String mulBaseDataPropKey, List<Object> selectedPkIds, List<Long> dimObjIds, Map<String, Object> customParam) {
        QFilter dataRuleQFilter = DataRuleCache.getDataRuleForBdProp(userId, appId, dataEntityType, mulBaseDataPropKey, "47150e89000000ac", dimObjIds, true, customParam);
        if (dataRuleQFilter == null) {
            if (selectedPkIds == null || selectedPkIds.isEmpty()) {
                return null;
            }
            return selectedPkIds;
        }
        IDataEntityProperty mulBaseDataProp = ((MainEntityType)dataEntityType).findProperty(mulBaseDataPropKey);
        if (mulBaseDataProp == null) {
            logger.warn("mulBaseDataPropKey:" + mulBaseDataPropKey + " can't find!");
            return null;
        }
        String mulBdType = ((MulBasedataProp)mulBaseDataProp).getBaseEntityId();
        DynamicObjectCollection idDoc = QueryServiceHelper.query((String)mulBdType, (String)"id", (QFilter[])new QFilter[]{dataRuleQFilter});
        ArrayList<Object> ids = new ArrayList<Object>(10);
        if (idDoc != null && !idDoc.isEmpty()) {
            for (DynamicObject dObj : idDoc) {
                Object idObj = dObj.get("id");
                if (idObj == null) continue;
                ids.add(idObj);
            }
        }
        if (selectedPkIds == null || selectedPkIds.isEmpty()) {
            return ids;
        }
        ArrayList<Object> newSelectedPkIds = new ArrayList<Object>(selectedPkIds);
        newSelectedPkIds.retainAll(ids);
        return newSelectedPkIds;
    }

    public static List<Object> getNoPermPkIdsForMulBdProp(long userId, String appId, IDataEntityType dataEntityType, String mulBaseDataPropKey, List<Object> selectedPkIds, List<Long> dimObjIds, Map<String, Object> customParam) {
        QFilter dataRuleQFilter = DataRuleCache.getDataRuleForBdProp(userId, appId, dataEntityType, mulBaseDataPropKey, "47150e89000000ac", dimObjIds, true, customParam);
        if (dataRuleQFilter == null) {
            if (selectedPkIds == null || selectedPkIds.isEmpty()) {
                return null;
            }
            return new ArrayList<Object>(8);
        }
        IDataEntityProperty mulBaseDataProp = ((MainEntityType)dataEntityType).findProperty(mulBaseDataPropKey);
        if (mulBaseDataProp == null) {
            logger.warn("mulBaseDataPropKey:" + mulBaseDataPropKey + " can't find!");
            return null;
        }
        String mulBdType = ((MulBasedataProp)mulBaseDataProp).getBaseEntityId();
        DynamicObjectCollection idDoc = QueryServiceHelper.query((String)mulBdType, (String)"id", (QFilter[])new QFilter[]{dataRuleQFilter});
        ArrayList<Object> ids = new ArrayList<Object>(10);
        if (idDoc != null && !idDoc.isEmpty()) {
            for (DynamicObject dObj : idDoc) {
                Object idObj = dObj.get("id");
                if (idObj == null) continue;
                ids.add(idObj);
            }
        }
        if (selectedPkIds == null || selectedPkIds.isEmpty()) {
            DynamicObjectCollection noPermIdDoc = QueryServiceHelper.query((String)mulBdType, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "not in", ids)});
            ArrayList<Object> noPermIds = new ArrayList<Object>(10);
            if (noPermIdDoc != null && !noPermIdDoc.isEmpty()) {
                for (DynamicObject dObj : noPermIdDoc) {
                    Object idObj = dObj.get("id");
                    if (idObj == null) continue;
                    noPermIds.add(idObj);
                }
            }
            return noPermIds;
        }
        ArrayList<Object> newSelectedPkIds = new ArrayList<Object>(selectedPkIds);
        newSelectedPkIds.removeAll(ids);
        return newSelectedPkIds;
    }

    public static Set<String> getMulBdPropKeysByHasSetDataRule(long userId, String appId, String entityNum, Map<String, Object> customParam) {
        CustomPermServInfo customServInfo;
        if (customParam == null) {
            customParam = new HashMap<String, Object>(8);
        }
        if ((customServInfo = CustomPermServInfo.getCustPermServInfo(appId = PermCommonUtil.getAppIdFromSuspectedAppNum(appId), customParam)) != null && StringUtils.isNotEmpty((String)customServInfo.getAppId())) {
            boolean skipPlatformImp = customServInfo.isSkipPlatformImp();
            boolean isAnd = customServInfo.isAnd();
            String appNum = customServInfo.getAppNum();
            Object customResult = null;
            customParam.remove(CUSTOMPARAM_DATARULE_EXTDATAENTSET);
            try {
                customResult = DataRuleCache.invokeBizMethod(customServInfo, METHOD_GETMULBDPROPKEYSBYHASSETDATARULE, userId, appId, entityNum, customParam);
                Set propKeys = (Set)customResult;
                return propKeys;
            }
            catch (Exception e) {
                String errorMsg = DataRuleCache.getMessage1(appNum) + ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e\u89c4\u5219(getMulBdPropKeysByHasSetDataRule)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6ce8\u518c\u7684\u670d\u52a1\u662f\u5426\u6b63\u786e\u3002", (String)"DataRuleCache_51", (String)SYSTEM_TYPE, (Object[])new Object[0]) + e.getMessage();
                logger.warn(errorMsg);
            }
        }
        return DataRuleCache.getMulBdPropKeysByHasSetDataRuleWithCustomParam(userId, appId, entityNum, customParam);
    }

    private static Set<String> getMulBdPropKeysByHasSetDataRuleWithCustomParam(long userId, String appId, String entityNum, Map<String, Object> customParam) {
        String key;
        Set<String> mulBdPropKeys = new HashSet<String>(8);
        if (userId == 0L || StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entityNum)) {
            return mulBdPropKeys;
        }
        String[] entityAppArr = EntityMapHelper.changeCheckPermEntity(entityNum, appId);
        entityNum = entityAppArr[0];
        boolean hasEnableOldDataRule = PermCommonUtil.hasEnableOldDataRule();
        if (hasEnableOldDataRule) {
            return mulBdPropKeys;
        }
        String realAppId = PermCommonUtil.getAppIdFromSuspectedAppNum(appId);
        entityNum = FormMetadataCache.getFormConfig((String)entityNum).getEntityTypeId();
        String type = CacheMrg.getType4DataRuleObj();
        String value = CacheMrg.getCache(type, key = DataRuleCache.buildCacheKey(METHOD_GETMULBDPROPKEYSBYHASSETDATARULE, userId, realAppId, entityNum));
        if (CacheMrg.isLoaded(value)) {
            mulBdPropKeys = (Set)SerializationUtils.fromJsonString((String)value, Set.class);
            if (mulBdPropKeys == null) {
                mulBdPropKeys = new HashSet(8);
            }
        } else {
            mulBdPropKeys = DataRuleCache.loadMulBdPropKeysByHasSetDataRule(userId, realAppId, entityNum);
            if (mulBdPropKeys == null) {
                mulBdPropKeys = new HashSet(8);
            }
            CacheMrg.putCache(type, key, SerializationUtils.toJsonString(mulBdPropKeys));
        }
        return mulBdPropKeys;
    }

    private static Set<String> loadMulBdPropKeysByHasSetDataRule(long userId, String appId, String entityNum) {
        HashSet<String> mulBdPropKeys = new HashSet<String>(8);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        Map allFields = dataEntityType.getAllFields();
        if (allFields == null || allFields.isEmpty()) {
            return new HashSet<String>(8);
        }
        Iterator iterator = allFields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            IDataEntityProperty prop = (IDataEntityProperty)entry.getValue();
            if (prop instanceof MulBasedataProp) continue;
            iterator.remove();
        }
        Map allMulBadataProps = allFields;
        if (allMulBadataProps.isEmpty()) {
            return new HashSet<String>(8);
        }
        Set<String> allMulBadataPropKeys = allMulBadataProps.keySet();
        HashMap<String, Set<String>> allMulBdPropTypeMap = new HashMap<String, Set<String>>();
        for (Map.Entry entry : allMulBadataProps.entrySet()) {
            String propKey = (String)entry.getKey();
            IDataEntityProperty prop = (IDataEntityProperty)entry.getValue();
            String bdPropEntNum = ((MulBasedataProp)prop).getBaseEntityId();
            allMulBdPropTypeMap.computeIfAbsent(bdPropEntNum, k -> new HashSet()).add(propKey);
        }
        Set<String> mulBdPropKeysFromUserDataRule = DataRuleCache.queryMulBdPropKeysFromUserDataRule(userId, appId, entityNum, allMulBadataPropKeys, allMulBdPropTypeMap);
        Set<String> mulBdPropKeysFromRoleDataRule = DataRuleCache.queryMulBdPropKeysFromRoleDataRule(userId, appId, entityNum, allMulBadataPropKeys, allMulBdPropTypeMap);
        mulBdPropKeys.addAll(mulBdPropKeysFromUserDataRule);
        mulBdPropKeys.addAll(mulBdPropKeysFromRoleDataRule);
        return mulBdPropKeys;
    }

    private static Set<String> queryMulBdPropKeysFromRoleDataRule(long userId, String appId, String entityNum, Set<String> allMulBadataPropKeys, Map<String, Set<String>> allMulBdPropTypeMap) {
        HashSet<String> bdPropKeys = new HashSet<String>(8);
        if (allMulBadataPropKeys == null || allMulBadataPropKeys.isEmpty() || allMulBdPropTypeMap == null || allMulBdPropTypeMap.isEmpty()) {
            return new HashSet<String>(8);
        }
        Set<String> bdTypeSet = allMulBdPropTypeMap.keySet();
        Set<String> roleIds = UserRoleCache.getRolesByUserId(userId);
        if (!CollectionUtils.isEmpty(roleIds)) {
            Map<String, DataRulesInfo> roleDataRulesInfoMap = DataRuleCache.queryCommonRoleDataRules(roleIds);
            for (String roleId : roleIds) {
                List entryInfos;
                DataRulesInfo queryCommonRoleDataRules = roleDataRulesInfoMap.get(roleId);
                if (queryCommonRoleDataRules == null || CollectionUtils.isEmpty((Collection)(entryInfos = queryCommonRoleDataRules.getEntryInfos()))) continue;
                for (DataRulesInfo.DataRulesEntryInfo drei : entryInfos) {
                    List bpdrList;
                    List permItemsList;
                    DataRuleInfo dataRule;
                    String tempEntityNum;
                    if (drei == null || StringUtils.isEmpty((String)(tempEntityNum = drei.getEntityNum())) || (dataRule = drei.getDataRule()) == null) continue;
                    if (bdTypeSet.contains(tempEntityNum) && (permItemsList = dataRule.getPermItemsDataRule()) != null && !permItemsList.isEmpty()) {
                        for (DataRuleInfo.PermItemsDataRule pidr : permItemsList) {
                            String propEntityNum;
                            Set<String> tempPropKeys;
                            if (pidr == null || !"47150e89000000ac".equals(pidr.getPermItemId()) || (tempPropKeys = allMulBdPropTypeMap.get(propEntityNum = pidr.getEntityNum())) == null || tempPropKeys.isEmpty()) continue;
                            bdPropKeys.addAll(tempPropKeys);
                        }
                    }
                    if (!tempEntityNum.equals(entityNum) || (bpdrList = dataRule.getBdPropsDataRule()) == null || bpdrList.isEmpty()) continue;
                    for (DataRuleInfo.BdPropsDataRule bpdr : bpdrList) {
                        String propKey;
                        if (bpdr == null || StringUtils.isEmpty((String)(propKey = bpdr.getPropKey())) || !allMulBadataPropKeys.contains(propKey)) continue;
                        bdPropKeys.add(propKey);
                    }
                }
            }
        }
        return bdPropKeys;
    }

    public static boolean existsMulBdPropDataRule(long userId, String appId, IDataEntityType dataEntityType, String mulBdPropKey, Map<String, Object> customParam) {
        if (StringUtils.isEmpty((String)mulBdPropKey)) {
            return false;
        }
        String entityNum = dataEntityType.getName();
        Set<String> propKeys = DataRuleCache.getMulBdPropKeysByHasSetDataRule(userId, appId, entityNum, customParam);
        if (propKeys == null || propKeys.isEmpty()) {
            return false;
        }
        return propKeys.contains(mulBdPropKey);
    }

    private static List<Long> processElementType(List<Long> dimObjIds) {
        if (!CollectionUtils.isEmpty(dimObjIds)) {
            ArrayList<Long> newDimObjIds = new ArrayList<Long>(8);
            for (Long obj : dimObjIds) {
                if (obj instanceof Integer) {
                    Integer intDimObjId = (Integer)((Object)obj);
                    newDimObjIds.add(Long.valueOf(String.valueOf(intDimObjId)));
                    continue;
                }
                if (obj instanceof Long) {
                    newDimObjIds.add(obj);
                    continue;
                }
                if (!(obj instanceof String)) continue;
                newDimObjIds.add(Long.valueOf((String)((Object)obj)));
            }
            return newDimObjIds;
        }
        return dimObjIds;
    }

    private static String getMulDataRuleNotSupportMsg(String permItemId) {
        return String.format(ResManager.loadKDString((String)"\u5f53\u6570\u636e\u89c4\u5219\u65b9\u6848\u5305\u62ec\u201c\u591a\u9009\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u201d\u7684\u5b57\u6bb5\u65f6\uff0c\u8be5\u65b9\u6848\u4ec5\u652f\u6301\u3010\u67e5\u8be2\u3011\u6743\u9650\u7684\u9a8c\u6743\u3002\u8bf7\u5148\u89e3\u9664\u6743\u9650\u9879\u3010%1$s\u3011\u4e0e\u76f8\u5173\u6570\u636e\u89c4\u5219\u65b9\u6848\u7684\u5173\u7cfb\u3002", (String)"DataRuleCache_52", (String)SYSTEM_TYPE, (Object[])new Object[0]), DataRuleCache.getPermItemName(permItemId));
    }

    private static String getPermItemName(String permItemId) {
        String permItemName = "";
        if (StringUtils.isNotEmpty((String)permItemId)) {
            DynamicObject permItemDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)permItemId, (String)"perm_permitem");
            permItemName = null == permItemDyn ? permItemId : permItemDyn.getString("name");
        }
        return permItemName;
    }

    private static boolean existMulBdPropInScript(String entityNum, String dataRuleScript) {
        BOSExpression bosExp;
        Set vars;
        if (StringUtils.isNotEmpty((String)dataRuleScript) && (vars = (bosExp = new BOSExpression(dataRuleScript)).getVars()) != null && !vars.isEmpty()) {
            boolean existMulBdPropInScript = false;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
            for (String var : vars) {
                IDataEntityProperty secVarProp;
                IDataEntityProperty firstVarProp;
                String[] varPartArr;
                if (StringUtils.isEmpty((String)var) || (varPartArr = var.split("\\.")) == null || varPartArr.length == 0 || (firstVarProp = dataEntityType.findProperty(varPartArr[0])) == null) continue;
                if (firstVarProp instanceof MulBasedataProp) {
                    existMulBdPropInScript = true;
                    break;
                }
                if (!(firstVarProp instanceof EntryProp) || (secVarProp = dataEntityType.findProperty(varPartArr[1])) == null || !(secVarProp instanceof MulBasedataProp)) continue;
                existMulBdPropInScript = true;
                break;
            }
            if (existMulBdPropInScript) {
                return true;
            }
        }
        return false;
    }

    private static Object invokeBizMethod(CustomPermServInfo customServInfo, String methodName, Object ... params) {
        String servFactory = customServInfo.getServiceFactory();
        String servName = customServInfo.getServiceName();
        String appNum = customServInfo.getAppNum();
        String servAppNum = customServInfo.getServAppNum();
        String cloudNumLowerCase = customServInfo.getCloudNumLowerCase();
        Object customResult = DispatchServiceHelper.invokeBizService((String)cloudNumLowerCase, (String)servAppNum, (String)servName, (String)methodName, (Object[])params);
        return customResult;
    }
}

