/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.property.OrgProp;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.FieldControlRuleDto;
import kd.bos.permission.api.FieldControlRuleField;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.permission.api.RoleInfo;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.RoleCache;
import kd.bos.permission.cache.UserBizRoleCache;
import kd.bos.permission.cache.UserRoleCache;
import kd.bos.permission.cache.helper.DirectAuthorizeHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.model.CustomPermServInfo;
import kd.bos.permission.cache.model.FieldPermissionInfo;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.enums.EnumsFieldPermCtrlMode;
import kd.bos.permission.model.PermRes;
import kd.bos.permission.model.perm.UserDimFieldPerm;
import kd.bos.permission.model.perm.req.field.FieldControlRules2RuleReq;
import kd.bos.permission.model.perm.req.field.GetFieldControlRulesReq;
import kd.bos.permission.model.perm.req.field.GetUserDimFieldPermReq;
import kd.bos.permission.model.perm.resp.field.GetUserDimFieldPermResp;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class FieldPermissionCache {
    private static Log logger = LogFactory.getLog(FieldPermissionCache.class);
    private static final String PARAM_FORGID = ":FORGID";
    private static final String PARAM_FUSERID = ":FUSERID";
    private static final String PARAM_FDIMTYPE = ":FDIMTYPE";
    private static final String PARAM_FENTITYTYPEID = ":FENTITYTYPEID";
    private static final String PARAM_FBIZAPPID = ":FBIZAPPID";
    private static final String EMPTY_FIELDPERM = "empty_fieldperm";
    private static final String KEY_ISINCLUDESUBORG = "isincludesuborg";

    private static String getMessage1() {
        return ResManager.loadKDString((String)"\u8c03\u7528\u4e1a\u52a1\u5e94\u7528", (String)"FieldPermissionCache_0", (String)"bos-permission-cache", (Object[])new Object[0]) + "\uff08";
    }

    private static String buildKey(String objectId, String objectType) {
        return String.format("%s_%s", objectId, objectType);
    }

    private static String buildKey(String methodName, Long pUserId, String pAppId, String pEntityNum) {
        return String.format("%s_%s_%s_%s", methodName, String.valueOf(pUserId), pAppId, pEntityNum);
    }

    private static String buildKey(String methodName, Long pUserId, Long orgId, String pAppId, String pEntityNum) {
        return String.format("%s_%s_%s_%s_%s", methodName, String.valueOf(pUserId), String.valueOf(orgId), pAppId, pEntityNum);
    }

    public static void removeRoleFieldPerm(String roleId) {
        String fieldPermObjType = CacheMrg.getType4FieldPermObj();
        String key = FieldPermissionCache.buildKey(roleId, "1");
        String fieldPermId = CacheMrg.getCache(fieldPermObjType, key);
        CacheMrg.clearCache(fieldPermObjType, key);
        if (kd.bos.util.StringUtils.isNotEmpty((String)fieldPermId)) {
            String fieldPermType = CacheMrg.getType4FieldPerm();
            List<String> cacheKeyListByPreKey = CacheMrg.getCacheKeyListByPrefixKey(fieldPermType, fieldPermId);
            for (String cacheKey : cacheKeyListByPreKey) {
                CacheMrg.clearCache(fieldPermType, cacheKey);
            }
        }
    }

    private static String getOrgFunc(String entityNum) {
        DynamicProperty property;
        String orgFunc = "15";
        PermissionControlType permCtrlType = FormHelper.getPermissionControlType(entityNum);
        String dataDimensionFieldKey = permCtrlType.getDataDimensionField();
        if (kd.bos.util.StringUtils.isEmpty((String)dataDimensionFieldKey)) {
            dataDimensionFieldKey = EntityMetadataCache.getDataEntityType((String)entityNum).getMainOrg();
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)dataDimensionFieldKey) && (property = EntityMetadataCache.getDataEntityType((String)entityNum).getProperty(dataDimensionFieldKey)) instanceof OrgProp && kd.bos.util.StringUtils.isEmpty((String)(orgFunc = ((OrgProp)property).getOrgFunc()))) {
            orgFunc = "15";
        }
        return orgFunc;
    }

    public static List<FieldControlRule> getFieldRuleNew(String objectId, String objectType, String appId, String entityNum) {
        List<String> fieldPermIdLst = null;
        String type = CacheMrg.getType4FieldPermObj();
        String orgFunc = FieldPermissionCache.getOrgFunc(entityNum);
        String value = null;
        String key = FieldPermissionCache.buildKey(objectId, objectType);
        String superiorOrgKey = FieldPermissionCache.buildKey(objectId, orgFunc);
        Long orgId = Long.parseLong(objectId.substring(objectId.indexOf(95) + 1));
        List newSuperiorOrg = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgFunc, (long)orgId);
        String oldSuperiorOrgStr = CacheMrg.getCache(type, superiorOrgKey);
        if (kd.bos.util.StringUtils.isNotEmpty((String)oldSuperiorOrgStr)) {
            List oldSuperiorOrg = SerializationUtils.fromJsonStringToList((String)CacheMrg.getCache(type, superiorOrgKey), Long.class);
            if (newSuperiorOrg.containsAll(oldSuperiorOrg) && oldSuperiorOrg.containsAll(newSuperiorOrg)) {
                value = CacheMrg.getCache(type, key);
            }
        } else {
            CacheMrg.putCache(type, superiorOrgKey, SerializationUtils.toJsonString((Object)newSuperiorOrg));
        }
        if (CacheMrg.isLoaded(value)) {
            if (CacheMrg.isData(value)) {
                fieldPermIdLst = PermCommonUtil.str2List(value);
            }
        } else {
            PermissionControlType permCtrlType = FormHelper.getPermissionControlType(entityNum);
            fieldPermIdLst = FieldPermissionCache.loadCacheNew(type, key, objectId, objectType, orgFunc, permCtrlType.getDimension());
        }
        List<FieldControlRule> ruleList = null;
        if (fieldPermIdLst != null) {
            ruleList = FieldPermissionCache.loadFieldCache(fieldPermIdLst, appId, entityNum, objectType);
        }
        return ruleList;
    }

    private static List<String> loadCacheNew(String type, String key, String objectId, final String objectType, String orgFunc, String dimension) {
        List superiorOrgs;
        StringBuilder sbSql = null;
        Object[] params = null;
        Long userId = Long.parseLong(objectId.substring(0, objectId.indexOf(95)));
        Long orgId = Long.parseLong(objectId.substring(objectId.indexOf(95) + 1));
        if (objectType.equals("0")) {
            sbSql = new StringBuilder("select distinct FFIELDPERMID from T_PERM_USERFIELDPERM where FUSERID = ? and FDIMTYPE = ? ");
            if (orgId != null && orgId != 0L && orgFunc == null) {
                sbSql.append(" and FORGID = ? ");
                params = new SqlParameter[3];
                params[2] = new SqlParameter(PARAM_FORGID, -5, (Object)orgId);
            } else if (orgId != null && orgId != 0L && orgFunc != null) {
                superiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgFunc, (long)orgId);
                StringBuilder param = new StringBuilder("(").append(orgId);
                if (superiorOrgs != null && !superiorOrgs.isEmpty()) {
                    for (Long superiorOrgId : superiorOrgs) {
                        param.append(',').append(superiorOrgId);
                    }
                }
                param.append(')');
                sbSql = new StringBuilder("select distinct FFIELDPERMID from T_PERM_USERFIELDPERM ufp ").append(" INNER JOIN T_PERM_USERPERM up ON up.fuserid = ufp.fuserid ").append(" where ufp.FUSERID = ? and ufp.FDIMTYPE = ? AND (up.FISINCLUDESUBORG = '1' OR ufp.FORGID = ?) ");
                sbSql.append(" and ufp.FORGID in ").append((CharSequence)param);
                params = new SqlParameter[3];
                params[2] = new SqlParameter(PARAM_FORGID, -5, (Object)orgId);
            } else {
                params = new SqlParameter[]{new SqlParameter(PARAM_FUSERID, -5, (Object)userId), new SqlParameter(PARAM_FDIMTYPE, 12, (Object)dimension)};
            }
        } else {
            dimension = PermCommonUtil.getSuitableDimType(dimension)[1];
            superiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgFunc, (long)orgId);
            StringBuilder param = new StringBuilder("(").append(orgId);
            if (superiorOrgs != null && !superiorOrgs.isEmpty()) {
                for (Long superiorOrgId : superiorOrgs) {
                    param.append(',').append(superiorOrgId);
                }
            }
            param.append(")))");
            if (PermCommonUtil.isEnableSingleBizRole()) {
                String selBizRoleId = UserBizRoleCache.getSelBizRole(userId);
                if (kd.bos.util.StringUtils.isNotEmpty((String)selBizRoleId)) {
                    sbSql = new StringBuilder("SELECT DISTINCT FFIELDPERMID,FINHERITMODE FROM t_perm_rolefieldperm rfp ").append(" INNER JOIN t_perm_bizrolecomrole brcr ON (brcr.fid = ? AND brcr.FROLEID = rfp.FROLEID) ");
                    params = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)Long.valueOf(selBizRoleId))};
                } else {
                    sbSql = null;
                }
            } else {
                sbSql = new StringBuilder("SELECT DISTINCT FFIELDPERMID,FINHERITMODE FROM T_PERM_ROLEFIELDPERM rfp ").append(" INNER JOIN T_PERM_USERROLE up ON (up.FROLEID = rfp.FROLEID AND up.FUSERID = ?) ").append(" WHERE up.FDIMTYPE = ? ").append(" AND (up.FORGID = ? OR (up.FISINCLUDESUBORG = '1' AND up.FORGID IN").append((CharSequence)param);
                params = new SqlParameter[]{new SqlParameter(PARAM_FUSERID, 12, (Object)userId), new SqlParameter(PARAM_FDIMTYPE, 12, (Object)dimension), new SqlParameter(PARAM_FORGID, -5, (Object)orgId)};
            }
        }
        List fieldPermIds = null;
        if (sbSql != null) {
            fieldPermIds = (List)DB.query((DBRoute)DBRoute.permission, (String)sbSql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                public List<String> handle(ResultSet rs) throws SQLException {
                    ArrayList<String> retList = new ArrayList<String>(20);
                    while (rs.next()) {
                        String fieldPermId = rs.getString("FFIELDPERMID");
                        if (objectType.equals("1")) {
                            fieldPermId = fieldPermId + "_" + rs.getString("FINHERITMODE");
                        }
                        retList.add(fieldPermId);
                    }
                    return retList;
                }
            });
        }
        if (fieldPermIds != null && fieldPermIds.size() > 0) {
            CacheMrg.putCache(type, key, PermCommonUtil.list2Str(fieldPermIds));
        } else {
            CacheMrg.loaded(type, key);
        }
        return fieldPermIds;
    }

    public static List<FieldControlRule> getFieldRule(String objectId, String objectType, String appId, String entityNum) {
        DynamicProperty property;
        List<String> fieldPermIdLst = null;
        String type = CacheMrg.getType4FieldPermObj();
        String key = FieldPermissionCache.buildKey(objectId, objectType);
        String value = CacheMrg.getCache(type, key);
        PermissionControlType permCtrlType = FormHelper.getPermissionControlType(entityNum);
        String dataDimensionFieldKey = permCtrlType.getDataDimensionField();
        if (kd.bos.util.StringUtils.isEmpty((String)dataDimensionFieldKey)) {
            dataDimensionFieldKey = EntityMetadataCache.getDataEntityType((String)entityNum).getMainOrg();
        }
        String orgFunc = "15";
        if (kd.bos.util.StringUtils.isNotEmpty((String)dataDimensionFieldKey) && (property = EntityMetadataCache.getDataEntityType((String)entityNum).getProperty(dataDimensionFieldKey)) instanceof OrgProp && kd.bos.util.StringUtils.isEmpty((String)(orgFunc = ((OrgProp)property).getOrgFunc()))) {
            orgFunc = "15";
        }
        if (CacheMrg.isLoaded(value)) {
            if (CacheMrg.isData(value)) {
                fieldPermIdLst = PermCommonUtil.str2List(value);
            }
        } else {
            fieldPermIdLst = FieldPermissionCache.loadCache(type, key, objectId, objectType, orgFunc, permCtrlType.getDimension());
        }
        List<FieldControlRule> ruleList = null;
        if (fieldPermIdLst != null) {
            ruleList = FieldPermissionCache.loadFieldCache(fieldPermIdLst, appId, entityNum, objectType);
        }
        return ruleList;
    }

    private static List<String> loadCache(String type, String key, String objectId, final String objectType, String orgFunc, String dimension) {
        StringBuilder sbSql = null;
        Object[] params = null;
        if (objectType.equals("0")) {
            sbSql = new StringBuilder("select distinct FFIELDPERMID from T_PERM_USERFIELDPERM where FUSERID = ? and FDIMTYPE = ? ");
            Long userId = Long.parseLong(objectId.substring(0, objectId.indexOf(95)));
            Long orgId = Long.parseLong(objectId.substring(objectId.indexOf(95) + 1, objectId.length()));
            if (orgId != null && orgId != 0L && orgFunc == null) {
                sbSql.append(" and FORGID = ? ");
                params = new SqlParameter[3];
                params[2] = new SqlParameter(PARAM_FORGID, -5, (Object)orgId);
            } else if (orgId != null && orgId != 0L && orgFunc != null) {
                List superiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgFunc, (long)orgId);
                StringBuilder param = new StringBuilder("(").append(orgId);
                if (superiorOrgs != null && !superiorOrgs.isEmpty()) {
                    for (Long superiorOrgId : superiorOrgs) {
                        param.append(',').append(superiorOrgId);
                    }
                }
                param.append(')');
                sbSql = new StringBuilder("select distinct FFIELDPERMID from T_PERM_USERFIELDPERM ufp ").append(" INNER JOIN T_PERM_USERPERM up ON up.fuserid = ufp.fuserid ").append(" where ufp.FUSERID = ? and ufp.FDIMTYPE = ? AND (up.FISINCLUDESUBORG = '1' OR ufp.FORGID = ?) ");
                sbSql.append(" and ufp.FORGID in ").append((CharSequence)param);
                params = new SqlParameter[3];
                params[2] = new SqlParameter(PARAM_FORGID, -5, (Object)orgId);
            } else {
                params = new SqlParameter[]{new SqlParameter(PARAM_FUSERID, -5, (Object)userId), new SqlParameter(PARAM_FDIMTYPE, 12, (Object)dimension)};
            }
        } else {
            sbSql = new StringBuilder("select distinct FFIELDPERMID,FINHERITMODE from T_PERM_ROLEFIELDPERM where FROLEID = ? ");
            params = new SqlParameter[]{new SqlParameter(":FROLEID", 12, (Object)objectId)};
        }
        List fieldPermIds = (List)DB.query((DBRoute)DBRoute.permission, (String)sbSql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> retList = new ArrayList<String>(20);
                while (rs.next()) {
                    String fieldPermId = rs.getString("FFIELDPERMID");
                    if (objectType.equals("1")) {
                        fieldPermId = fieldPermId + "_" + rs.getString("FINHERITMODE");
                    }
                    retList.add(fieldPermId);
                }
                return retList;
            }
        });
        if (fieldPermIds != null && fieldPermIds.size() > 0) {
            CacheMrg.putCache(type, key, PermCommonUtil.list2Str(fieldPermIds));
        } else {
            CacheMrg.loaded(type, key);
        }
        return fieldPermIds;
    }

    private static List<FieldControlRule> loadFieldCache(List<String> fieldPermIdList, String appId, String entityNum, String objectType) {
        ArrayList<FieldControlRule> ruleList = new ArrayList<FieldControlRule>();
        for (String fieldPermId : fieldPermIdList) {
            String type = CacheMrg.getType4FieldPerm();
            String inheritMode = null;
            if (objectType.equals("1")) {
                String[] vals = fieldPermId.split("_");
                if (vals == null || vals.length == 0) continue;
                fieldPermId = vals[0];
                if (vals.length == 2) {
                    inheritMode = vals[1];
                }
            }
            String key = fieldPermId + "_" + appId + "_" + entityNum;
            FieldControlRule rule = null;
            String value = CacheMrg.getCache(type, key);
            if (CacheMrg.isLoaded(value)) {
                if (CacheMrg.isData(value)) {
                    rule = (FieldControlRule)JSON.parseObject((String)value, FieldControlRule.class);
                }
            } else {
                rule = FieldPermissionCache.reloadFieldCache(fieldPermId, appId, entityNum);
            }
            if (rule == null) continue;
            rule.setInheritMode(inheritMode);
            ruleList.add(rule);
        }
        return ruleList;
    }

    public static void removeCache(String fieldPermId) {
        String type = CacheMrg.getType4FieldPerm();
        CacheMrg.clearCacheByPrekey(type, fieldPermId + "_");
    }

    public static void removeCache(Long userId, Long orgId, String objectType) {
        String type = CacheMrg.getType4FieldPermObj();
        String objectId = userId + "_" + orgId;
        String key = FieldPermissionCache.buildKey(objectId, objectType);
        CacheMrg.clearCacheByPrekey(type, key);
    }

    public static FieldControlRule reloadFieldCache(String fieldPermId, String appId, String entityNum) {
        if (kd.bos.util.StringUtils.isEmpty((String)appId)) {
            appId = PermCommonUtil.getCheckPermAppId(appId, entityNum);
        }
        String sql = "select FENTRYID,FFIELDNAME,FCONTROLMODE from T_PERM_FIELDPERMDETAIL where FID = ? and FENTITYTYPEID = ? and FBIZAPPID = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", 12, (Object)fieldPermId), new SqlParameter(PARAM_FENTITYTYPEID, 12, (Object)entityNum), new SqlParameter(PARAM_FBIZAPPID, 12, (Object)appId)};
        List listData = (List)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Set<String>>>(){

            public List<Set<String>> handle(ResultSet rs) throws SQLException {
                HashSet<String> cantReads = new HashSet<String>(20);
                HashSet<String> cantWrites = new HashSet<String>(20);
                String controlMode = null;
                String fieldName = null;
                while (rs.next()) {
                    controlMode = rs.getString("FCONTROLMODE");
                    fieldName = rs.getString("FFIELDNAME");
                    if (controlMode.equals("10")) {
                        cantReads.add(fieldName);
                        continue;
                    }
                    if (!controlMode.equals("20")) continue;
                    cantWrites.add(fieldName);
                }
                ArrayList<Set<String>> listData = new ArrayList<Set<String>>();
                listData.add(cantReads);
                listData.add(cantWrites);
                return listData;
            }
        });
        String type = CacheMrg.getType4FieldPerm();
        FieldControlRule rule = null;
        String key = fieldPermId + "_" + appId + "_" + entityNum;
        if (((Set)listData.get(0)).size() > 0 || ((Set)listData.get(1)).size() > 0) {
            rule = new FieldControlRule();
            rule.setId(fieldPermId);
            rule.setCanNotReadFields((Set)listData.get(0));
            rule.setCanNotWriteFields((Set)listData.get(1));
            String detailJsonStr = JSON.toJSONString((Object)rule);
            CacheMrg.putCache(type, key, detailJsonStr);
        } else {
            CacheMrg.loaded(type, key);
        }
        return rule;
    }

    public static void removeAllCache() {
        String fieldPermObjType = CacheMrg.getType4FieldPermObj();
        String fieldPermType = CacheMrg.getType4FieldPerm();
        CacheMrg.clearCache(fieldPermObjType);
        CacheMrg.clearCache(fieldPermType);
    }

    private static FieldControlRule loadFieldRulesSum(long pUserId, String pAppId, String pEntityNum) {
        String condition;
        String fieldName;
        DynamicObjectCollection roleFieldPermDoc;
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        CustomPermServInfo customServInfo = CustomPermServInfo.getCustPermServInfo(pAppId, customParam);
        if (customServInfo != null) {
            String appNum = customServInfo.getAppNum();
            Object customResult = null;
            try {
                customResult = FieldPermissionCache.invokeBizMethod(customServInfo, "getFieldRulesSum", pUserId, pAppId, pEntityNum, customParam);
                FieldControlRule fcr = (FieldControlRule)customResult;
                return fcr;
            }
            catch (Exception e) {
                String errorMsg = FieldPermissionCache.getMessage1() + appNum + "\uff09" + ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u5b57\u6bb5\u6743\u9650(getFieldRulesSum)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6ce8\u518c\u7684\u670d\u52a1\u662f\u5426\u6b63\u786e\u3002", (String)"FieldPermissionCache_1", (String)"bos-permission-cache", (Object[])new Object[0]) + e.getMessage();
                logger.warn(errorMsg);
            }
        }
        FieldControlRule fieldControlRule = null;
        StringBuilder sbSelectedFields = new StringBuilder("id").append(",").append("fieldperm.fieldrule.id").append(",").append("fieldperm.fieldrule.fieldname").append(" fieldname").append(",").append("fieldperm.fieldrule.rowcondition").append(" condition");
        String selectedFields = sbSelectedFields.toString();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("fieldperm.fieldrule.entitytype", "=", (Object)pEntityNum));
        filters.add(new QFilter("user", "=", (Object)pUserId));
        if (kd.bos.util.StringUtils.isNotEmpty((String)pAppId)) {
            filters.add(new QFilter("fieldperm.fieldrule.bizapp", "=", (Object)pAppId));
        }
        DynamicObjectCollection userFieldPermDoc = QueryServiceHelper.query((String)"perm_userfieldperm", (String)selectedFields, (QFilter[])filters.toArray(new QFilter[0]));
        HashMap<String, String> fieldCondMap = new HashMap<String, String>();
        if (userFieldPermDoc != null && userFieldPermDoc.size() > 0) {
            for (DynamicObject dObj : userFieldPermDoc) {
                String fieldName2 = dObj.getString("fieldname");
                String condition2 = dObj.getString("condition");
                String oldCond = (String)fieldCondMap.get(fieldName2);
                if ("0".equals(oldCond) || "20".equals(oldCond) && "10".equals(condition2)) continue;
                fieldCondMap.put(fieldName2, condition2);
            }
        }
        Set<String> roleIds = RoleCache.getRolesByUserId(pUserId);
        sbSelectedFields = new StringBuilder("id").append(",").append("fieldperm.fieldrule.fieldname").append(" fieldname").append(",").append("fieldperm.fieldrule.rowcondition").append(" condition");
        selectedFields = sbSelectedFields.toString();
        filters = new ArrayList();
        filters.add(new QFilter("fieldperm.fieldrule.entitytype", "=", (Object)pEntityNum));
        filters.add(new QFilter("role", "in", roleIds));
        if (kd.bos.util.StringUtils.isNotEmpty((String)pAppId)) {
            filters.add(new QFilter("fieldperm.fieldrule.bizapp", "=", (Object)pAppId));
        }
        if ((roleFieldPermDoc = QueryServiceHelper.query((String)"perm_rolefieldperm", (String)selectedFields, (QFilter[])filters.toArray(new QFilter[0]))) != null && roleFieldPermDoc.size() > 0) {
            for (DynamicObject dObj : roleFieldPermDoc) {
                fieldName = dObj.getString("fieldname");
                condition = dObj.getString("condition");
                String oldCond = (String)fieldCondMap.get(fieldName);
                if ("0".equals(oldCond) || "20".equals(oldCond) && condition.equals("10")) continue;
                fieldCondMap.put(fieldName, condition);
            }
        }
        if (!fieldCondMap.isEmpty()) {
            fieldControlRule = new FieldControlRule();
            fieldControlRule.setCanNotReadFields(new HashSet());
            fieldControlRule.setCanNotWriteFields(new HashSet());
            for (Map.Entry entry : fieldCondMap.entrySet()) {
                fieldName = (String)entry.getKey();
                condition = (String)entry.getValue();
                if (condition == null || condition.equals("0")) continue;
                if (condition.equals("20")) {
                    fieldControlRule.getCanNotWriteFields().add(fieldName);
                    continue;
                }
                if (!condition.equals("10")) continue;
                fieldControlRule.getCanNotReadFields().add(fieldName);
            }
        }
        return fieldControlRule;
    }

    public static FieldControlRule getFieldRulesSum(long pUserId, String pAppId, String pEntityNum) {
        String type = CacheMrg.getType4FieldPermObj();
        String buildKey = FieldPermissionCache.buildKey("getFieldRulesSum", pUserId, pAppId, pEntityNum);
        FieldControlRule result = null;
        Map tempResult = null;
        String value = CacheMrg.getCache(type, buildKey);
        if (value == null) {
            result = FieldPermissionCache.loadFieldRulesSum(pUserId, pAppId, pEntityNum);
            if (result != null) {
                CacheMrg.putCache(type, buildKey, SerializationUtils.toJsonString((Object)result));
            } else {
                CacheMrg.putCache(type, buildKey, "");
            }
        } else if (kd.bos.util.StringUtils.isEmpty((String)value)) {
            result = null;
        } else {
            tempResult = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            if (tempResult != null && !tempResult.isEmpty()) {
                result = FieldPermissionCache.fromMapToFieldControlRule(tempResult);
            }
        }
        return result;
    }

    private static FieldControlRules loadFieldControlRules(long pUserId, String pAppId, String pEntityNum) {
        logger.debug("[loadFieldControlRules]\u5165\u53c2: userId:{}, appId:{}, entityNum:{}", new Object[]{pUserId, pAppId, pEntityNum});
        String type = CacheMrg.getType4FieldPerm();
        String userFieldPermRedisKey = pUserId + "_" + pAppId + "_" + pEntityNum + "_fieldperm_detail";
        FieldControlRules fieldControlRules = new FieldControlRules();
        ArrayList<FieldPermissionInfo> fieldPermOrgs = null;
        HashMap<String, Map<Long, Map<Boolean, FieldControlRule>>> fieldControlRuleMap = new HashMap<String, Map<Long, Map<Boolean, FieldControlRule>>>(16);
        HashMap<String, Set<Long>> dimTypeIdMap = new HashMap<String, Set<Long>>(8);
        String fieldPermCache = CacheMrg.getCache(type, userFieldPermRedisKey);
        logger.debug("[loadFieldControlRules]\u7f13\u5b58\u83b7\u53d6\u7528\u6237(id = {}), \u5b57\u6bb5\u6743\u9650\u4fe1\u606f\uff1a type = {}, key = {}, value = {}", new Object[]{pUserId, type, userFieldPermRedisKey, fieldPermCache});
        if (fieldPermCache != null && !EMPTY_FIELDPERM.equals(fieldPermCache)) {
            fieldPermOrgs = SerializationUtils.fromJsonStringToList((String)fieldPermCache, FieldPermissionInfo.class);
            for (FieldPermissionInfo fieldPermOrg : fieldPermOrgs) {
                long dimId = fieldPermOrg.getOrgId();
                dimTypeIdMap.computeIfAbsent(fieldPermOrg.getDimType(), k -> new HashSet(8)).add(dimId);
                Map dimTypeDimIdMap = fieldControlRuleMap.computeIfAbsent(fieldPermOrg.getDimType(), k -> new HashMap(8));
                Map includeSubMap = dimTypeDimIdMap.computeIfAbsent(dimId, k -> new HashMap(8));
                includeSubMap.put(fieldPermOrg.getIncludeSubOrg(), fieldPermOrg.getFieldControlRule());
                dimTypeDimIdMap.put(dimId, includeSubMap);
            }
        } else {
            if (EMPTY_FIELDPERM.equals(fieldPermCache)) {
                return fieldControlRules;
            }
            HashMap<String, Object> customParam = new HashMap<String, Object>();
            CustomPermServInfo customServInfo = CustomPermServInfo.getCustPermServInfo(pAppId, customParam);
            if (customServInfo != null) {
                boolean skipPlatformImp = customServInfo.isSkipPlatformImp();
                boolean isAnd = customServInfo.isAnd();
                String appNum = customServInfo.getAppNum();
                Object customResult = null;
                try {
                    customResult = FieldPermissionCache.invokeBizMethod(customServInfo, "getFieldControlRules", pUserId, pAppId, pEntityNum, customParam);
                    FieldControlRules fcrs = (FieldControlRules)customResult;
                    return fcrs;
                }
                catch (Exception e) {
                    String errorMsg = FieldPermissionCache.getMessage1() + appNum + "\uff09" + ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u5b57\u6bb5\u6743\u9650(getFieldControlRule)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6ce8\u518c\u7684\u670d\u52a1\u662f\u5426\u6b63\u786e\u3002", (String)"FieldPermissionCache_2", (String)"bos-permission-cache", (Object[])new Object[0]) + e.getMessage();
                    logger.warn(errorMsg);
                }
            }
            String dimTypeForFieldPerm = FieldPermissionCache.getDimTypeForFieldPerm(pEntityNum);
            GetUserDimFieldPermReq req = new GetUserDimFieldPermReq((Set)Sets.newHashSet((Object[])new Long[]{pUserId}), (Set)Sets.newHashSet((Object[])new String[]{pAppId}), (Set)Sets.newHashSet((Object[])new String[]{pEntityNum}), (Set)(IsoDimHelper.addDimTypeFilter(dimTypeForFieldPerm) ? Sets.newHashSet((Object[])new String[]{dimTypeForFieldPerm}) : null), null, null, null, Integer.valueOf(1));
            Map<String, String> permCtrlTypeBigMap = IsoDimHelper.permCtrlTypeBigMap();
            HashMap<String, Map<String, Set<String>>> entItemClassFieldMap = new HashMap<String, Map<String, Set<String>>>(8);
            GetUserDimFieldPermResp directUserDimFieldPermResp = DirectAuthorizeHelper.getUserDimFieldPermResp(req, entItemClassFieldMap);
            Set directUdfpSet = directUserDimFieldPermResp.getUdfpSet();
            Map<String, Map<Long, Map<String, Object>>> userFieldPermMap = FieldPermissionCache.getDimTypeDimIdFieldPermMap(directUdfpSet, dimTypeIdMap, permCtrlTypeBigMap);
            GetUserDimFieldPermResp comRoleUserDimFieldPermResp = PermRoleHelper.getUserDimFieldPermResp(req, entItemClassFieldMap);
            Set comRoleUdfpSet = comRoleUserDimFieldPermResp.getUdfpSet();
            Map<String, Map<Long, Map<String, Object>>> roleFieldPermMap = FieldPermissionCache.getDimTypeDimIdFieldPermMap(comRoleUdfpSet, dimTypeIdMap, permCtrlTypeBigMap);
            if (null == dimTypeIdMap || dimTypeIdMap.isEmpty()) {
                CacheMrg.putCache(type, userFieldPermRedisKey, EMPTY_FIELDPERM);
                logger.debug("[loadFieldControlRules]\u6570\u636e\u5e93\u83b7\u53d6\u7528\u6237(id = " + pUserId + ") \u5b57\u6bb5\u6743\u9650\u4fe1\u606f\u6210\u529f\u5e76\u8bbe\u7f6e\u7f13\u5b58[END]\uff1a type = " + type + ", key = " + userFieldPermRedisKey + ", value = " + EMPTY_FIELDPERM);
                return fieldControlRules;
            }
            fieldPermOrgs = new ArrayList<FieldPermissionInfo>(10);
            FieldPermissionCache.mergeFielPerm(fieldPermOrgs, fieldControlRuleMap, dimTypeIdMap, userFieldPermMap, roleFieldPermMap);
            String value = SerializationUtils.toJsonString(fieldPermOrgs);
            logger.debug("[loadFieldControlRules]\u6570\u636e\u5e93\u83b7\u53d6\u7528\u6237(id = " + pUserId + ") \u5b57\u6bb5\u6743\u9650\u4fe1\u606f\u6210\u529f\u5e76\u8bbe\u7f6e\u7f13\u5b58\uff1a type = " + type + ", key = " + userFieldPermRedisKey + ", value = " + value);
            CacheMrg.putCache(type, userFieldPermRedisKey, value);
        }
        String orgFunc = FieldPermissionCache.getOrgFunc(pEntityNum);
        for (Map.Entry dimTypeId : dimTypeIdMap.entrySet()) {
            String dimType = (String)dimTypeId.getKey();
            Set dimIdSet = (Set)dimTypeId.getValue();
            if (kd.bos.util.StringUtils.isEmpty((String)dimType) || null == dimIdSet || dimIdSet.isEmpty()) continue;
            Map dimTypeDimIdMap = fieldControlRuleMap.computeIfAbsent(dimType, k -> new HashMap(8));
            for (Long orgId : dimIdSet) {
                FieldControlRuleDto fieldControlRuleDto;
                Map includeSubMap = dimTypeDimIdMap.computeIfAbsent(orgId, k -> new HashMap(8));
                FieldControlRule only = (FieldControlRule)includeSubMap.get(Boolean.FALSE);
                FieldControlRule include = (FieldControlRule)includeSubMap.get(Boolean.TRUE);
                if (only != null) {
                    fieldControlRuleDto = new FieldControlRuleDto();
                    fieldControlRuleDto.setFieldControlRule(only);
                    fieldControlRuleDto.setDimType(dimType);
                    fieldControlRuleDto.setMainOrgId(orgId);
                    fieldControlRuleDto.setIncludeSubOrg(false);
                    fieldControlRules.getFieldControlRuleDtos().add(fieldControlRuleDto);
                }
                if (!IsoDimHelper.checkOrgDim(dimType) || include == null) continue;
                fieldControlRuleDto = new FieldControlRuleDto();
                List superiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgFunc, (long)orgId);
                if (!CollectionUtils.isEmpty((Collection)superiorOrgs)) {
                    for (Long select : dimIdSet) {
                        Map booleanFieldControlRuleMap;
                        FieldControlRule rule;
                        if (!superiorOrgs.contains(select) || (rule = (FieldControlRule)(booleanFieldControlRuleMap = dimTypeDimIdMap.computeIfAbsent(select, k -> new HashMap(8))).get(Boolean.TRUE)) == null) continue;
                        include.getCanNotWriteFields().addAll(rule.getCanNotWriteFields());
                        include.getCanNotReadFields().addAll(rule.getCanNotReadFields());
                    }
                }
                fieldControlRuleDto.setFieldControlRule(include);
                fieldControlRuleDto.setDimType(dimType);
                fieldControlRuleDto.setMainOrgId(orgId);
                fieldControlRuleDto.setIncludeSubOrg(true);
                ArrayList<Long> orgIds = new ArrayList<Long>(1);
                orgIds.add(orgId);
                List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgFunc, orgIds, (boolean)false, (boolean)true);
                fieldControlRuleDto.setSubOrgId(allSubordinateOrgs);
                fieldControlRules.getFieldControlRuleDtos().add(fieldControlRuleDto);
            }
        }
        return fieldControlRules;
    }

    private static String getDimTypeForFieldPerm(String pEntityNum) {
        String dimTypeByEntNumSmall = "bos_objecttype";
        try {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)pEntityNum);
            PermissionControlType permissionControlType = null == dataEntityType ? null : dataEntityType.getPermissionControlType();
            boolean isControlFunction = null == permissionControlType ? false : permissionControlType.isControlFunction();
            String dimension = null == permissionControlType ? "" : permissionControlType.getDimension();
            String dataDimensionField = null == permissionControlType ? "" : permissionControlType.getDataDimensionField();
            String mainOrg = "";
            if (dataEntityType != null) {
                mainOrg = dataEntityType.getMainOrg();
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)mainOrg)) {
                dimTypeByEntNumSmall = "bos_org";
            } else if (isControlFunction && kd.bos.util.StringUtils.isNotEmpty((String)dimension) && kd.bos.util.StringUtils.isNotEmpty((String)dataDimensionField)) {
                String[] dimTypeInfo = PermCommonUtil.getSuitableDimType(dimension, true);
                dimTypeByEntNumSmall = dimTypeInfo[1];
            }
        }
        catch (Exception e) {
            logger.warn("FieldPermissionCache.getDimTypeForFieldPerm, error.", (Object)pEntityNum, (Object)e);
        }
        return dimTypeByEntNumSmall;
    }

    private static void mergeFielPerm(List<FieldPermissionInfo> fieldPermOrgs, Map<String, Map<Long, Map<Boolean, FieldControlRule>>> fieldControlRuleMap, Map<String, Set<Long>> dimTypeIdMap, Map<String, Map<Long, Map<String, Object>>> userFieldPermMap, Map<String, Map<Long, Map<String, Object>>> roleFieldPermMap) {
        for (Map.Entry<String, Set<Long>> dimTypeId : dimTypeIdMap.entrySet()) {
            String dimType = dimTypeId.getKey();
            Set<Long> dimIdSet = dimTypeId.getValue();
            if (kd.bos.util.StringUtils.isEmpty((String)dimType) || null == dimIdSet || dimIdSet.isEmpty()) continue;
            Map dimTypeDimIdMap = fieldControlRuleMap.computeIfAbsent(dimType, k -> new HashMap(8));
            for (Long dimId : dimIdSet) {
                Map<String, Object> roleData;
                Map includeSubMap = dimTypeDimIdMap.computeIfAbsent(dimId, k -> new HashMap(8));
                Map<Long, Map<String, Object>> userDimIdDataMap = userFieldPermMap.get(dimType);
                Map<String, Object> userData = null == userDimIdDataMap || userDimIdDataMap.isEmpty() || CollectionUtils.isEmpty(userDimIdDataMap.get(dimId)) ? null : userDimIdDataMap.get(dimId);
                Map<Long, Map<String, Object>> roleDimIdDataMap = roleFieldPermMap.get(dimType);
                Map<String, Object> map = roleData = null == roleDimIdDataMap || roleDimIdDataMap.isEmpty() || CollectionUtils.isEmpty(roleDimIdDataMap.get(dimId)) ? null : roleDimIdDataMap.get(dimId);
                if (userData != null && !userData.isEmpty()) {
                    boolean userIsincludesuborg = (Boolean)userData.get(KEY_ISINCLUDESUBORG);
                    FieldControlRule userRule = (FieldControlRule)userData.get("rule");
                    includeSubMap.put(userIsincludesuborg, userRule);
                    if (roleData != null && !roleData.isEmpty()) {
                        boolean roleIsincludesuborg = (Boolean)roleData.get(KEY_ISINCLUDESUBORG);
                        FieldControlRule roleRule = (FieldControlRule)roleData.get("rule");
                        if (userIsincludesuborg != roleIsincludesuborg) {
                            includeSubMap.put(roleIsincludesuborg, roleRule);
                            FieldPermissionInfo fieldPermissionInfoRole = new FieldPermissionInfo();
                            fieldPermissionInfoRole.setDimType(dimType);
                            fieldPermissionInfoRole.setOrgId(dimId);
                            fieldPermissionInfoRole.setIncludeSubOrg(roleIsincludesuborg);
                            fieldPermissionInfoRole.setFieldControlRule(roleRule);
                            fieldPermOrgs.add(fieldPermissionInfoRole);
                            FieldPermissionInfo fieldPermissionInfoUser = new FieldPermissionInfo();
                            fieldPermissionInfoUser.setDimType(dimType);
                            fieldPermissionInfoUser.setOrgId(dimId);
                            fieldPermissionInfoUser.setIncludeSubOrg(userIsincludesuborg);
                            fieldPermissionInfoUser.setFieldControlRule(userRule);
                            fieldPermOrgs.add(fieldPermissionInfoUser);
                            continue;
                        }
                        userRule.getCanNotReadFields().addAll(roleRule.getCanNotReadFields());
                        userRule.getCanNotWriteFields().addAll(roleRule.getCanNotWriteFields());
                        FieldPermissionInfo fieldPermissionInfoUser = new FieldPermissionInfo();
                        fieldPermissionInfoUser.setDimType(dimType);
                        fieldPermissionInfoUser.setOrgId(dimId);
                        fieldPermissionInfoUser.setIncludeSubOrg(userIsincludesuborg);
                        fieldPermissionInfoUser.setFieldControlRule(userRule);
                        fieldPermOrgs.add(fieldPermissionInfoUser);
                        continue;
                    }
                    FieldPermissionInfo fieldPermissionInfoUser = new FieldPermissionInfo();
                    fieldPermissionInfoUser.setDimType(dimType);
                    fieldPermissionInfoUser.setOrgId(dimId);
                    fieldPermissionInfoUser.setIncludeSubOrg(userIsincludesuborg);
                    fieldPermissionInfoUser.setFieldControlRule(userRule);
                    fieldPermOrgs.add(fieldPermissionInfoUser);
                    continue;
                }
                if (roleData == null) {
                    return;
                }
                boolean roleIsincludesuborg = (Boolean)roleData.get(KEY_ISINCLUDESUBORG);
                FieldControlRule roleRule = (FieldControlRule)roleData.get("rule");
                includeSubMap.put(roleIsincludesuborg, roleRule);
                FieldPermissionInfo fieldPermissionInfoRole = new FieldPermissionInfo();
                fieldPermissionInfoRole.setDimType(dimType);
                fieldPermissionInfoRole.setOrgId(dimId);
                fieldPermissionInfoRole.setIncludeSubOrg(roleIsincludesuborg);
                fieldPermissionInfoRole.setFieldControlRule(roleRule);
                fieldPermOrgs.add(fieldPermissionInfoRole);
            }
        }
    }

    private static Map<String, Map<Long, Map<String, Object>>> getDimTypeDimIdFieldPermMap(Set<UserDimFieldPerm> udfpSet, Map<String, Set<Long>> dimTypeIdMap, Map<String, String> permCtrlTypeBigMap) {
        if (null == udfpSet || udfpSet.isEmpty()) {
            return new HashMap<String, Map<Long, Map<String, Object>>>(1);
        }
        HashMap<String, Map<Long, Map<String, Object>>> result = new HashMap<String, Map<Long, Map<String, Object>>>(16);
        String tempDimType = null;
        Long tempDimId = null;
        FieldControlRule rule = null;
        List collect = udfpSet.stream().sorted(Comparator.comparing(x -> x.getDimType() + x.getDimId())).collect(Collectors.toList());
        for (UserDimFieldPerm one : collect) {
            String dimTypeSmall = one.getDimType();
            String dimType = permCtrlTypeBigMap.get(dimTypeSmall);
            if (kd.bos.util.StringUtils.isEmpty((String)dimType)) continue;
            Long dimId = one.getDimId();
            if (!Objects.equals(dimType, tempDimType) || !dimId.equals(tempDimId)) {
                tempDimType = dimType;
                tempDimId = dimId;
                dimTypeIdMap.computeIfAbsent(dimType, k -> new HashSet(16)).add(dimId);
                Map data = result.computeIfAbsent(dimType, k -> new HashMap(16)).computeIfAbsent(dimId, k -> new HashMap(8));
                rule = new FieldControlRule();
                rule.setCanNotReadFields(new HashSet(16));
                rule.setCanNotWriteFields(new HashSet(16));
                data.put("rule", rule);
                data.put(KEY_ISINCLUDESUBORG, one.getIncludeSub() != false ? Boolean.TRUE : Boolean.FALSE);
            }
            String fieldName = one.getFieldName();
            String controlMode = one.getControlMode();
            if (controlMode.equals(EnumsFieldPermCtrlMode.FORBID_VIEW.getType())) {
                rule.getCanNotReadFields().add(fieldName);
                continue;
            }
            if (!controlMode.equals(EnumsFieldPermCtrlMode.FORBID_EDIT.getType())) continue;
            rule.getCanNotWriteFields().add(fieldName);
        }
        return result;
    }

    public static FieldControlRule getFieldControlRule(GetFieldControlRulesReq req) {
        try {
            Long userId = req.getUserId();
            String appId = req.getAppId();
            String entNum = req.getEntNum();
            Long dimId = req.getDimId();
            StringBuilder key = new StringBuilder();
            key.append(userId);
            key.append("_").append(appId);
            key.append("_").append(entNum);
            key.append("_").append(dimId);
            key.append("_").append("oneFieldControlRule");
            String keyStr = key.toString();
            String cacheType = CacheMrg.getType4FieldPerm();
            String cacheKey = keyStr;
            String cachedStr = CacheMrg.getCache(cacheType, cacheKey);
            if (kd.bos.util.StringUtils.isEmpty((String)cachedStr)) {
                FieldControlRules fieldControlRules = FieldPermissionCache.loadFieldControlRules(userId, appId, entNum);
                if (null == fieldControlRules) {
                    FieldControlRule fieldControlRule = new FieldControlRule();
                    fieldControlRule = new FieldControlRule();
                    fieldControlRule.setCanNotReadRuleFields(new ArrayList());
                    fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
                    fieldControlRule.setCanNotReadFields(new HashSet());
                    fieldControlRule.setCanNotWriteFields(new HashSet());
                    CacheMrg.putCache(cacheType, cacheKey, SerializationUtils.toJsonString((Object)fieldControlRule));
                    return fieldControlRule;
                }
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entNum);
                PermissionControlType permissionControlType = null == dataEntityType ? null : dataEntityType.getPermissionControlType();
                String dimension = null == permissionControlType ? "" : permissionControlType.getDimension();
                String dataDimensionField = null == permissionControlType ? "" : permissionControlType.getDataDimensionField();
                String mainOrg = null == dataEntityType ? "" : dataEntityType.getMainOrg();
                HashMap<String, FieldControlRule> map = new HashMap<String, FieldControlRule>(8);
                String pkValue = String.valueOf(dimId);
                FieldPermissionCache.fullFieldControlRules2RuleMap(map, fieldControlRules, mainOrg, dimension, dataDimensionField, null, dimId, pkValue);
                FieldControlRule fieldControlRule = (FieldControlRule)map.get(pkValue);
                CacheMrg.putCache(cacheType, cacheKey, SerializationUtils.toJsonString((Object)fieldControlRule));
                return fieldControlRule;
            }
            return (FieldControlRule)SerializationUtils.fromJsonString((String)cachedStr, FieldControlRule.class);
        }
        catch (Exception e) {
            logger.warn("FieldPermissionCache.getFieldControlRule error\uff0c reqStr\uff1a{}", (Object)JSON.toJSONString((Object)req), (Object)e);
            FieldControlRule fieldControlRule = new FieldControlRule();
            fieldControlRule = new FieldControlRule();
            fieldControlRule.setCanNotReadRuleFields(new ArrayList());
            fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
            fieldControlRule.setCanNotReadFields(new HashSet());
            fieldControlRule.setCanNotWriteFields(new HashSet());
            return fieldControlRule;
        }
    }

    public static FieldControlRules getFieldControlRules(long pUserId, String pAppId, String pEntityNum) {
        try {
            FieldControlRules fieldControlRules = FieldPermissionCache.loadFieldControlRules(pUserId, pAppId, pEntityNum);
            return fieldControlRules;
        }
        catch (Exception e) {
            logger.warn("FieldPermissionCache.getFieldControlRules:" + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static PermRes<Map<String, FieldControlRule>> fieldControlRules2RuleMap(FieldControlRules2RuleReq req) {
        HashMap<String, FieldControlRule> map = new HashMap<String, FieldControlRule>(8);
        try {
            DynamicObjectCollection doc = req.getDoc();
            if (null == doc || doc.isEmpty()) {
                return new PermRes(0, "ok", map);
            }
            FieldControlRules fieldControlRules = req.getFieldControlRules();
            if (null == fieldControlRules) {
                FieldControlRule fieldControlRule = null;
                for (DynamicObject dyn : doc) {
                    Object pkValue = dyn.getPkValue();
                    if (null == pkValue) continue;
                    fieldControlRule = new FieldControlRule();
                    fieldControlRule.setCanNotReadRuleFields(new ArrayList());
                    fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
                    fieldControlRule.setCanNotReadFields(new HashSet());
                    fieldControlRule.setCanNotWriteFields(new HashSet());
                    map.put(String.valueOf(pkValue), fieldControlRule);
                }
                return new PermRes(0, "ok", map);
            }
            String mainOrg = req.getMainOrg();
            String dimension = req.getDimension();
            String dataDimensionField = req.getDataDimensionField();
            for (DynamicObject dyn : doc) {
                Object pkValue = dyn.getPkValue();
                if (null == pkValue) continue;
                FieldPermissionCache.fullFieldControlRules2RuleMap(map, fieldControlRules, mainOrg, dimension, dataDimensionField, dyn, null, String.valueOf(pkValue));
            }
            return new PermRes(0, "ok", map);
        }
        catch (Exception e) {
            logger.warn("FieldPermissionCache.fieldControlRules2RuleMap error.", (Throwable)e);
            return new PermRes(-1, "error", map);
        }
    }

    private static void fullFieldControlRules2RuleMap(Map<String, FieldControlRule> map, FieldControlRules fieldControlRules, String mainOrg, String dimension, String dataDimensionField, DynamicObject dyn, Long dimId, String pkValue) {
        if (null != dimId && dimId >= 0L) {
            pkValue = String.valueOf(dimId);
        }
        FieldControlRule fieldControlRule = null;
        if (kd.bos.util.StringUtils.isNotEmpty((String)mainOrg)) {
            FieldPermissionCache.wrapMainOrgFieldControlRule(map, fieldControlRules, mainOrg, dyn, dimId, pkValue);
            return;
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)dimension) && kd.bos.util.StringUtils.isNotEmpty((String)dataDimensionField)) {
            FieldPermissionCache.wrapDimTypeFieldControlRule(map, fieldControlRules, dimension, dataDimensionField, dyn, dimId, pkValue);
            return;
        }
        if (kd.bos.util.StringUtils.isEmpty((String)dimension) || kd.bos.util.StringUtils.isEmpty((String)dataDimensionField)) {
            fieldControlRule = new FieldControlRule();
            fieldControlRule.setCanNotReadRuleFields(new ArrayList());
            fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
            fieldControlRule.setCanNotReadFields(new HashSet());
            fieldControlRule.setCanNotWriteFields(new HashSet());
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp = listField.getFieldControlRule();
                if (temp == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
            map.put(pkValue, fieldControlRule);
            return;
        }
        fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        map.put(pkValue, fieldControlRule);
    }

    private static void wrapMainOrgFieldControlRule(Map<String, FieldControlRule> map, FieldControlRules fieldControlRules, String mainOrg, DynamicObject dyn, Long dimId, String pkValue) {
        FieldControlRule fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        if (null != dimId && dimId >= 0L) {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp;
                String dimType = listField.getDimType();
                if (kd.bos.util.StringUtils.isEmpty((String)dimType) || !Objects.equals("DIM_ORG", dimType) || !Objects.equals(listField.getMainOrgId(), dimId) && (!listField.getIncludeSubOrg() || !listField.getSubOrgId().contains(dimId)) || (temp = listField.getFieldControlRule()) == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
            map.put(pkValue, fieldControlRule);
            return;
        }
        if (null != dyn && kd.bos.util.StringUtils.isNotEmpty((String)pkValue)) {
            long orgId = FieldPermissionCache.getMainOrgId(dyn, mainOrg);
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp;
                String dimType = listField.getDimType();
                if (kd.bos.util.StringUtils.isEmpty((String)dimType) || !Objects.equals("DIM_ORG", dimType) || !Objects.equals(listField.getMainOrgId(), orgId) && (!listField.getIncludeSubOrg() || !listField.getSubOrgId().contains(orgId)) || (temp = listField.getFieldControlRule()) == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
            map.put(pkValue, fieldControlRule);
            return;
        }
    }

    private static void wrapDimTypeFieldControlRule(Map<String, FieldControlRule> map, FieldControlRules fieldControlRules, String dimension, String dataDimensionField, DynamicObject dyn, Long dimId, String pkValue) {
        FieldControlRule fieldControlRule = new FieldControlRule();
        fieldControlRule.setCanNotReadRuleFields(new ArrayList());
        fieldControlRule.setCanNotWriteRuleFields(new ArrayList());
        fieldControlRule.setCanNotReadFields(new HashSet());
        fieldControlRule.setCanNotWriteFields(new HashSet());
        if (null != dimId && dimId >= 0L) {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp;
                String dimType = listField.getDimType();
                if (kd.bos.util.StringUtils.isEmpty((String)dimType) || !Objects.equals(dimension, dimType)) continue;
                if (Objects.equals(0L, dimId)) {
                    temp = listField.getFieldControlRule();
                    if (temp == null) continue;
                    fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                    fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                    fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                    fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
                    continue;
                }
                if (!Objects.equals(listField.getMainOrgId(), dimId) && (!listField.getIncludeSubOrg() || !listField.getSubOrgId().contains(dimId)) || (temp = listField.getFieldControlRule()) == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
            map.put(pkValue, fieldControlRule);
            return;
        }
        if (null != dyn && kd.bos.util.StringUtils.isNotEmpty((String)pkValue)) {
            for (FieldControlRuleDto listField : fieldControlRules.getFieldControlRuleDtos()) {
                FieldControlRule temp;
                String dimType = listField.getDimType();
                if (kd.bos.util.StringUtils.isEmpty((String)dimType) || !Objects.equals(dimension, dimType)) continue;
                if (Objects.equals("0", pkValue)) {
                    FieldControlRule temp2 = listField.getFieldControlRule();
                    if (temp2 == null) continue;
                    fieldControlRule.getCanNotReadRuleFields().addAll(temp2.getCanNotReadRuleFields());
                    fieldControlRule.getCanNotWriteRuleFields().addAll(temp2.getCanNotWriteRuleFields());
                    fieldControlRule.getCanNotReadFields().addAll(temp2.getCanNotReadFields());
                    fieldControlRule.getCanNotWriteFields().addAll(temp2.getCanNotWriteFields());
                    continue;
                }
                Object value = null;
                try {
                    boolean containsProperty = dyn.containsProperty(dataDimensionField + "_id");
                    if (!containsProperty) continue;
                    value = dyn.get(dataDimensionField + "_id");
                }
                catch (Exception e) {
                    Log logger = LogFactory.getLog(FieldEdit.class);
                    logger.warn("FieldPermissionCache.wrapDimTypeFieldControlRule error ", (Throwable)e);
                    continue;
                }
                if (null == value || !Objects.equals(listField.getMainOrgId(), value) && (!listField.getIncludeSubOrg() || !listField.getSubOrgId().contains(value)) || (temp = listField.getFieldControlRule()) == null) continue;
                fieldControlRule.getCanNotReadRuleFields().addAll(temp.getCanNotReadRuleFields());
                fieldControlRule.getCanNotWriteRuleFields().addAll(temp.getCanNotWriteRuleFields());
                fieldControlRule.getCanNotReadFields().addAll(temp.getCanNotReadFields());
                fieldControlRule.getCanNotWriteFields().addAll(temp.getCanNotWriteFields());
            }
            map.put(pkValue, fieldControlRule);
            return;
        }
    }

    private static long getMainOrgId(DynamicObject dyn, String mainOrg) {
        long orgId = -1L;
        if (null == dyn || StringUtils.isEmpty((CharSequence)mainOrg)) {
            return orgId;
        }
        Object orgObj = dyn.get(mainOrg);
        if (orgObj == null) {
            return orgId;
        }
        if (orgObj instanceof DynamicObject) {
            return Long.parseLong(String.valueOf(((DynamicObject)orgObj).getPkValue()));
        }
        if (orgObj instanceof Long) {
            return (Long)orgObj;
        }
        return orgId;
    }

    private static FieldControlRule loadFieldControlRuleOriginal(long userId, long orgId, String appId, String entityNum) {
        List<RoleInfo> roles;
        DynamicProperty property;
        PermissionControlType permCtrlType;
        String dataDimensionFieldKey;
        List<FieldControlRule> userFieldRules;
        ArrayList<FieldControlRule> allRuleList = new ArrayList<FieldControlRule>();
        String objectId = userId + "_" + orgId;
        if (kd.bos.util.StringUtils.isEmpty((String)appId)) {
            appId = PermCommonUtil.getCheckPermAppId(appId, entityNum);
        }
        if ((userFieldRules = FieldPermissionCache.getFieldRule(objectId, "0", appId, entityNum)) != null && userFieldRules.size() > 0) {
            allRuleList.addAll(userFieldRules);
        }
        if (kd.bos.util.StringUtils.isEmpty((String)(dataDimensionFieldKey = (permCtrlType = FormHelper.getPermissionControlType(entityNum)).getDataDimensionField()))) {
            dataDimensionFieldKey = EntityMetadataCache.getDataEntityType((String)entityNum).getMainOrg();
        }
        String orgFunc = "15";
        if (kd.bos.util.StringUtils.isNotEmpty((String)dataDimensionFieldKey) && (property = EntityMetadataCache.getDataEntityType((String)entityNum).getProperty(dataDimensionFieldKey)) instanceof OrgProp && kd.bos.util.StringUtils.isEmpty((String)(orgFunc = ((OrgProp)property).getOrgFunc()))) {
            orgFunc = "15";
        }
        if ((roles = UserRoleCache.getUserRolesIncludeSuperior(userId, orgId, orgFunc, permCtrlType.getDimension())) != null) {
            for (RoleInfo role : roles) {
                List<FieldControlRule> roleRules = FieldPermissionCache.getFieldRule(role.getId(), "1", appId, entityNum);
                if (roleRules == null || roleRules.size() <= 0) continue;
                allRuleList.addAll(roleRules);
            }
        }
        if (!allRuleList.isEmpty()) {
            if (allRuleList.size() == 1) {
                return (FieldControlRule)allRuleList.get(0);
            }
            HashSet canNotReadFields = new HashSet(20);
            HashSet canNotWriteFields = new HashSet(20);
            for (FieldControlRule rule2 : allRuleList) {
                canNotReadFields.addAll(rule2.getCanNotReadFields());
                canNotWriteFields.addAll(rule2.getCanNotWriteFields());
            }
            FieldControlRule retRule = new FieldControlRule();
            retRule.setCanNotReadFields(canNotReadFields);
            retRule.setCanNotWriteFields(canNotWriteFields);
            return retRule;
        }
        return null;
    }

    private static FieldControlRule loadFieldControlRule(long userId, long orgId, String appId, String entityNum) {
        assert (entityNum != null);
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        CustomPermServInfo customServInfo = CustomPermServInfo.getCustPermServInfo(appId, customParam);
        if (customServInfo != null) {
            boolean skipPlatformImp = customServInfo.isSkipPlatformImp();
            boolean isAnd = customServInfo.isAnd();
            String appNum = customServInfo.getAppNum();
            Object customResult = null;
            try {
                customResult = FieldPermissionCache.invokeBizMethod(customServInfo, "getFieldControlRule", userId, orgId, appId, entityNum, customParam);
                FieldControlRule fcr = (FieldControlRule)customResult;
                return fcr;
            }
            catch (Exception e) {
                String errorMsg = FieldPermissionCache.getMessage1() + appNum + "\uff09" + ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6269\u5c55\u6570\u636e\u89c4\u5219(getFieldControlRule)\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6ce8\u518c\u7684\u670d\u52a1\u662f\u5426\u6b63\u786e\u3002", (String)"FieldPermissionCache_3", (String)"bos-permission-cache", (Object[])new Object[0]) + e.getMessage();
                logger.warn(errorMsg);
            }
        }
        return FieldPermissionCache.loadFieldControlRuleOriginal(userId, orgId, appId, entityNum);
    }

    public static FieldControlRule getFieldControlRule(long userId, long orgId, String appId, String entityNum) {
        String type = CacheMrg.getType4FieldPermObj();
        String buildKey = FieldPermissionCache.buildKey("getFieldControlRule", userId, orgId, appId, entityNum);
        FieldControlRule result = null;
        Map tempResult = null;
        String value = CacheMrg.getCache(type, buildKey);
        if (value == null) {
            result = FieldPermissionCache.loadFieldControlRule(userId, orgId, appId, entityNum);
            if (result != null) {
                CacheMrg.putCache(type, buildKey, SerializationUtils.toJsonString((Object)result));
            } else {
                CacheMrg.putCache(type, buildKey, "");
            }
        } else if (kd.bos.util.StringUtils.isEmpty((String)value)) {
            result = null;
        } else {
            tempResult = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            if (tempResult != null && !tempResult.isEmpty()) {
                result = FieldPermissionCache.fromMapToFieldControlRule(tempResult);
            }
        }
        return result;
    }

    @Deprecated
    private static Map<Long, FieldControlRule> loadAllFieldControlRule(long pUserId, String pAppId, String pEntityNum) {
        DynamicObjectCollection doc;
        String PROP_ORG = "org";
        String PROP_BIZAPP = "fieldperm.fieldrule.bizapp";
        String PROP_ENTITYTYPE = "fieldperm.fieldrule.entitytype";
        String PROP_USER = "user";
        String UserFieldPermEntityType = "perm_userfieldperm";
        HashMap<Long, FieldControlRule> fcrMap = null;
        StringBuilder sbSelectedFields = new StringBuilder("id").append(",").append(PROP_ORG);
        String selectedFields = sbSelectedFields.toString();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(PROP_ENTITYTYPE, "=", (Object)pEntityNum));
        filters.add(new QFilter(PROP_USER, "=", (Object)pUserId));
        if (kd.bos.util.StringUtils.isNotEmpty((String)pAppId)) {
            filters.add(new QFilter(PROP_BIZAPP, "=", (Object)pAppId));
        }
        if ((doc = QueryServiceHelper.query((String)UserFieldPermEntityType, (String)selectedFields, (QFilter[])filters.toArray(new QFilter[0]))) != null && doc.size() > 0) {
            fcrMap = new HashMap<Long, FieldControlRule>();
            for (DynamicObject dObj : doc) {
                Long orgId = dObj.getLong(PROP_ORG);
                FieldControlRule fcr = FieldPermissionCache.getFieldControlRule(pUserId, orgId, pAppId, pEntityNum);
                fcrMap.put(orgId, fcr);
            }
        }
        return fcrMap;
    }

    @Deprecated
    public static Map<Long, FieldControlRule> getAllFieldControlRule(long pUserId, String pAppId, String pEntityNum) {
        String value;
        String type = CacheMrg.getType4FieldPermObj();
        String buildKey = FieldPermissionCache.buildKey("getAllFieldControlRule", pUserId, pAppId, pEntityNum);
        Map tempResult = null;
        Map<Long, FieldControlRule> result = null;
        if (kd.bos.util.StringUtils.isEmpty((String)pAppId)) {
            pAppId = PermCommonUtil.getCheckPermAppId(pAppId, pEntityNum);
        }
        if ((value = CacheMrg.getCache(type, buildKey)) == null) {
            result = FieldPermissionCache.loadAllFieldControlRule(pUserId, pAppId, pEntityNum);
            if (result != null) {
                CacheMrg.putCache(type, buildKey, SerializationUtils.toJsonString(result));
            } else {
                CacheMrg.putCache(type, buildKey, "");
            }
        } else if (kd.bos.util.StringUtils.isEmpty((String)value)) {
            result = null;
        } else {
            tempResult = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            if (tempResult != null && !tempResult.isEmpty()) {
                result = new HashMap<Long, FieldControlRule>();
                for (Map.Entry entry : tempResult.entrySet()) {
                    String key = (String)entry.getKey();
                    Map map = (Map)entry.getValue();
                    if (map == null || map.isEmpty()) continue;
                    FieldControlRule fcr = FieldPermissionCache.fromMapToFieldControlRule(map);
                    result.put(Long.valueOf(key), fcr);
                }
            }
        }
        return result;
    }

    public static FieldControlRule fromMapToFieldControlRule(Map<String, Object> map) {
        FieldControlRule result = new FieldControlRule();
        result.setId((String)map.get("id"));
        result.setCanNotWriteFields(new HashSet((List)map.get("canNotWriteFields")));
        result.setCanNotReadFields(new HashSet((List)map.get("canNotReadFields")));
        List canNotWriteRuleList = (List)map.get("canNotWriteRuleFields");
        ArrayList<FieldControlRuleField> tempCanNotWriteRuleList = null;
        if (!CollectionUtils.isEmpty((Collection)canNotWriteRuleList)) {
            tempCanNotWriteRuleList = new ArrayList<FieldControlRuleField>(canNotWriteRuleList.size());
            for (Map canNotWriteRule : canNotWriteRuleList) {
                FieldControlRuleField fcrf = FieldPermissionCache.fromMapToFieldControlRuleField(canNotWriteRule);
                tempCanNotWriteRuleList.add(fcrf);
            }
            result.setCanNotWriteRuleFields(tempCanNotWriteRuleList);
        }
        List canNotReadRuleList = (List)map.get("canNotReadRuleFields");
        ArrayList<FieldControlRuleField> tempCanNotReadRuleList = null;
        if (!CollectionUtils.isEmpty((Collection)canNotReadRuleList)) {
            tempCanNotReadRuleList = new ArrayList<FieldControlRuleField>(canNotReadRuleList.size());
            for (Map canNotReadRule : canNotReadRuleList) {
                FieldControlRuleField fcrf = FieldPermissionCache.fromMapToFieldControlRuleField(canNotReadRule);
                tempCanNotReadRuleList.add(fcrf);
            }
            result.setCanNotReadRuleFields(tempCanNotReadRuleList);
        }
        return result;
    }

    public static FieldControlRuleField fromMapToFieldControlRuleField(Map<String, Object> map) {
        FieldControlRuleField result = new FieldControlRuleField();
        result.setField((String)map.get("field"));
        return result;
    }

    private static Object invokeBizMethod(CustomPermServInfo customServInfo, String methodName, Object ... params) {
        String servName = customServInfo.getServiceName();
        String servAppNum = customServInfo.getServAppNum();
        String cloudNumLowerCase = customServInfo.getCloudNumLowerCase();
        Object customResult = DispatchServiceHelper.invokeBizService((String)cloudNumLowerCase, (String)servAppNum, (String)servName, (String)methodName, (Object[])params);
        return customResult;
    }
}

