/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterObject;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.DataRule;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.UserRoleCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.UserGroupHelper;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class OperationRuleObjCache {
    private static final Log logger = LogFactory.getLog(OperationRuleObjCache.class);
    private static final String SPLIT_STR = "_split_";
    private static final String CACHEKEY = "script_%s_%s_%s_%s";

    @SdkInternal
    public static void removeAllCache() {
        CacheMrg.clearCache(CacheMrg.getType4OperationRuleObj());
    }

    public static Object queryOperationRule(Long userId, String appId, String entityNum, String operationKey, StringBuilder sbNotMatchTips, boolean returnQFilter) {
        logger.debug("[queryOperationRule]\u6210\u529f\u8c03\u7528\u63a5\u53e3 \u5165\u53c2userId = " + userId + ", appId = " + appId + ", entityNum = " + entityNum + ", operationKey = " + operationKey + ", returnQFilter = " + returnQFilter);
        if (userId == null) {
            userId = Long.parseLong(RequestContext.get().getUserId());
        }
        if (sbNotMatchTips != null) {
            sbNotMatchTips.setLength(0);
        }
        String cacheKey = String.format("%s_%s_%s_%s", userId, appId, entityNum, operationKey);
        String type4OperationRuleObj = CacheMrg.getType4OperationRuleObj();
        String cache = CacheMrg.getCache(type4OperationRuleObj, cacheKey);
        Object resultFilter = null;
        if (CacheMrg.isNotLoaded(cache)) {
            cache = CacheMrg.getCache(type4OperationRuleObj, cacheKey);
            if (CacheMrg.isNotLoaded(cache)) {
                resultFilter = OperationRuleObjCache.loadOperationRule(userId, appId, entityNum, operationKey, sbNotMatchTips, returnQFilter);
                if (!returnQFilter) {
                    return resultFilter;
                }
            } else {
                logger.debug("[queryOperationRule]\u8bfb\u53d6\u7f13\u5b58\u6210\u529f type = " + type4OperationRuleObj + ", key = " + cacheKey + ", value = " + cache);
                resultFilter = OperationRuleObjCache.reloadOperationRuleFromCache(cache, userId, appId, entityNum, operationKey, sbNotMatchTips, returnQFilter);
            }
        } else {
            logger.debug("[queryOperationRule]\u8bfb\u53d6\u7f13\u5b58\u6210\u529f type = " + type4OperationRuleObj + ", key = " + cacheKey + ", value = " + cache);
            resultFilter = OperationRuleObjCache.reloadOperationRuleFromCache(cache, userId, appId, entityNum, operationKey, sbNotMatchTips, returnQFilter);
        }
        if (!returnQFilter) {
            return resultFilter;
        }
        boolean hasEnablePropCollapse = PermCommonUtil.hasEnablePropCollapse();
        if (hasEnablePropCollapse && resultFilter != null) {
            String originalFilterInfo = ResManager.loadKDString((String)"\u539f\u59cb\u7279\u6b8a\u6570\u636e\u6743\u9650", (String)"OperationRuleObjCache_0", (String)"bos-permission-cache", (Object[])new Object[0]);
            logger.debug(originalFilterInfo + OperationRuleObjCache.logMessage(userId, appId, entityNum, operationKey, resultFilter.toString()));
            resultFilter = PermCommonUtil.convertQFilter(entityNum, (QFilter)resultFilter);
            String processedFilterInfo = ResManager.loadKDString((String)"\u5904\u7406\u540e\u7684\u7279\u6b8a\u6570\u636e\u6743\u9650", (String)"OperationRuleObjCache_1", (String)"bos-permission-cache", (Object[])new Object[0]);
            logger.debug(processedFilterInfo + OperationRuleObjCache.logMessage(userId, appId, entityNum, operationKey, resultFilter.toString()));
        }
        return resultFilter;
    }

    private static Object reloadOperationRuleFromCache(String cache, Long userId, String appId, String entityNum, String operationKey, StringBuilder sbNotMatchTips, boolean returnQFilter) {
        if (CacheMrg.isData(cache)) {
            String[] arrSplitCache = cache.split(SPLIT_STR);
            if (arrSplitCache.length > 2) {
                boolean isExcept;
                String opRuleJson = arrSplitCache[0];
                String opRuleObjId = arrSplitCache[1];
                String opRuleId = arrSplitCache[2];
                String opRuleNameJson = arrSplitCache[3];
                Map opRuleNameMap = (Map)SerializationUtils.fromJsonString((String)opRuleNameJson, Map.class);
                String opRuleName = (String)opRuleNameMap.get(RequestContext.get().getLang().name());
                if (kd.bos.util.StringUtils.isEmpty((String)opRuleName) && kd.bos.util.StringUtils.isEmpty((String)(opRuleName = (String)opRuleNameMap.get("GLang")))) {
                    opRuleName = (String)opRuleNameMap.get("zh_CN");
                }
                if (sbNotMatchTips != null) {
                    sbNotMatchTips.append(opRuleName);
                }
                if (isExcept = OperationRuleObjCache.isExceptOrNot(userId, opRuleObjId)) {
                    if (!returnQFilter) {
                        return null;
                    }
                    return new QFilter("1", "=", (Object)1);
                }
                if (!returnQFilter) {
                    DataRule dataRule = new DataRule();
                    dataRule.setId(opRuleId);
                    dataRule.setName(opRuleName);
                    dataRule.setFilterConditionJson(opRuleJson);
                    return dataRule;
                }
                FilterCondition fc = OperationRuleObjCache.replaceDirectorChargeOrg(userId, appId, entityNum, operationKey, opRuleJson, null);
                return OperationRuleObjCache.changeIntoQFilter(entityNum, fc, appId, opRuleName);
            }
            OperationRuleObjCache.removeAllCache();
            return OperationRuleObjCache.loadOperationRule(userId, appId, entityNum, operationKey, sbNotMatchTips, returnQFilter);
        }
        return null;
    }

    private static String logMessage(Long userId, String appId, String entityNum, String operationKey, String resultFilter) {
        return String.format("[appId:%s, entityNum:%s, operationKey:%s, userId:%s]: %s ", appId, entityNum, operationKey, userId, resultFilter);
    }

    private static Object loadOperationRule(Long userId, String appId, String entityNum, String operationKey, StringBuilder sbNotMatchTips, boolean returnQFilter) {
        Object resultFilter = null;
        String type4OperationRuleObj = CacheMrg.getType4OperationRuleObj();
        StringBuilder queryOperationIdSqlBuffer = new StringBuilder();
        String localeId = RequestContext.get().getLang().toString();
        queryOperationIdSqlBuffer.append("SELECT opro.fid opruleobjid, opr.fid ruleid, opr.fname rulename_def, oprl.fname rulename, opr.frule oprule ").append("FROM t_perm_operationruleobj opro ").append("INNER JOIN t_perm_operationrule opr ").append("ON opro.foperationruleid = opr.fid ").append("LEFT JOIN t_perm_operationrule_l oprl ").append("ON (opr.fid = oprl.fid AND oprl.flocaleid = '").append(localeId).append("')").append("WHERE opro.fentitytypeid = ? ").append("AND opro.fbizappid   = ? ").append("AND opr.foperationkey = ? ").append("AND opro.fobjenabled = '1' ");
        Object[] params = new Object[]{entityNum, appId, operationKey};
        resultFilter = DB.query((DBRoute)DBRoute.basedata, (String)queryOperationIdSqlBuffer.toString(), (Object[])params, resultSet -> {
            String cacheKey = String.format("%s_%s_%s_%s", userId, appId, entityNum, operationKey);
            if (resultSet.next()) {
                String opRuleId = resultSet.getString("ruleid");
                String opRuleName = resultSet.getString("rulename");
                opRuleName = opRuleName == null ? resultSet.getString("rulename_def") : opRuleName;
                String opRuleObjId = resultSet.getString("opruleobjid");
                String opRuleJson = resultSet.getString("oprule");
                opRuleJson = PermCommonUtil.replaceBackSlach(opRuleJson);
                boolean isExcept = OperationRuleObjCache.isExceptOrNot(userId, opRuleObjId);
                if (isExcept) {
                    if (!returnQFilter) {
                        logger.debug("[queryOperationRule]\u8bfb\u53d6\u6570\u636e\u5e93\u914d\u7f6e\u6210\u529f\u5e76\u6ee1\u8db3\u4f8b\u5916\u8bbe\u7f6e\uff0c\u8fd4\u56denull");
                        return null;
                    }
                    logger.debug("[queryOperationRule]\u8bfb\u53d6\u6570\u636e\u5e93\u914d\u7f6e\u6210\u529f\u5e76\u6ee1\u8db3\u4f8b\u5916\u8bbe\u7f6e\uff0c\u8fd4\u56deQFilter 1 = 1");
                    return new QFilter("1", "=", (Object)1);
                }
                String cacheValue = OperationRuleObjCache.loadOpRuleAndPutInCache(cacheKey, opRuleId, opRuleObjId, sbNotMatchTips, false);
                if (!returnQFilter) {
                    DataRule dataRule = new DataRule();
                    dataRule.setId(opRuleId);
                    dataRule.setName(opRuleName);
                    dataRule.setFilterConditionJson(opRuleJson);
                    return dataRule;
                }
                FilterCondition fc = OperationRuleObjCache.replaceDirectorChargeOrg(userId, appId, entityNum, operationKey, opRuleJson, null);
                return OperationRuleObjCache.changeIntoQFilter(entityNum, fc, appId, opRuleName);
            }
            logger.debug("[queryOperationRule]\u8bfb\u53d6\u6570\u636e\u5e93\u914d\u7f6e\u6210\u529f\u4f46\u6ca1\u6709\u76f8\u5173\u914d\u7f6e\uff0c\u5e76\u8bbe\u7f6e\u7f13\u5b58 type = " + type4OperationRuleObj + ", key = " + cacheKey + ", value = PERM_DATA_LOADED");
            CacheMrg.loaded(type4OperationRuleObj, cacheKey);
            return null;
        });
        return resultFilter;
    }

    private static String loadOpRuleAndPutInCache(String cacheKey, String opRuleId, String opRuleObjId, StringBuilder sbNotMatchTips, boolean ifLoadScript) {
        String type4OpRuleObj = CacheMrg.getType4OperationRuleObj();
        Object[] opRuleObjs = BusinessDataServiceHelper.load((String)"perm_operationrule", (String)"id,name, rule", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)opRuleId)});
        if (ArrayUtils.isEmpty((Object[])opRuleObjs)) {
            CacheMrg.loaded(type4OpRuleObj, cacheKey);
            return null;
        }
        Object row = opRuleObjs[0];
        String opRuleStr = row.getString("rule");
        ILocaleString lsOpRuleName = row.getLocaleString("name");
        String opRuleName = row.getString("name");
        opRuleStr = PermCommonUtil.replaceBackSlach(opRuleStr);
        if (sbNotMatchTips == null) {
            sbNotMatchTips = new StringBuilder();
        }
        sbNotMatchTips.append(opRuleName);
        String cacheValue = null;
        cacheValue = ifLoadScript ? opRuleStr + SPLIT_STR + opRuleObjId + SPLIT_STR + SerializationUtils.toJsonString((Object)lsOpRuleName) : opRuleStr + SPLIT_STR + opRuleObjId + SPLIT_STR + opRuleId + SPLIT_STR + SerializationUtils.toJsonString((Object)lsOpRuleName);
        logger.debug("[queryOperationRule]\u8bfb\u53d6\u6570\u636e\u5e93\u914d\u7f6e\u6210\u529f\u5e76\u8bbe\u7f6e\u7f13\u5b58 type = " + type4OpRuleObj + ", key = " + cacheKey + ", value = " + cacheValue);
        CacheMrg.putCache(type4OpRuleObj, cacheKey, cacheValue);
        return cacheValue;
    }

    private static QFilter changeIntoQFilter(String entityNum, FilterCondition fc, String appId, String opRuleName) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        String opRuleStr = SerializationUtils.toJsonString((Object)fc);
        logger.debug("[changeIntoQFilter]\u57fa\u7840\u83b7\u53d6\u7279\u6b8a\u6570\u636e\u6743\u9650\u914d\u7f6e\u4fe1\u606f\uff1a entityNum = '" + entityNum + "', FilterCondition = " + opRuleStr);
        OperationRuleObjCache.checkFormEntityFieldsExists(dataEntityType, fc, appId, opRuleName);
        return PermCommonUtil.getQFilterFromFilterGridJsonStr(dataEntityType, opRuleStr);
    }

    private static void checkFormEntityFieldsExists(MainEntityType dataType, FilterCondition fc, String appId, String opRuleName) {
        List filterRows = fc.getFilterRow();
        Iterator filterRowIterator = filterRows.iterator();
        HashMap<String, MainEntityType> cachedDataTypes = new HashMap<String, MainEntityType>();
        cachedDataTypes.put(dataType.getName(), dataType);
        while (filterRowIterator.hasNext()) {
            SimpleFilterRow simpleFilterRow = (SimpleFilterRow)filterRowIterator.next();
            OperationRuleObjCache.checkFormEntityFieldExists(dataType, simpleFilterRow.getFieldName(), String.valueOf(simpleFilterRow.getCompareType()), simpleFilterRow.getEntityNumber(), cachedDataTypes, appId, opRuleName);
        }
    }

    private static void checkFormEntityFieldExists(MainEntityType dataType, String fieldName, String compare, String entityNumber, Map<String, MainEntityType> cachedDataTypes, String appId, String opRuleName) {
        if (StringUtils.isBlank((CharSequence)fieldName) || StringUtils.isBlank((CharSequence)compare)) {
            return;
        }
        FilterObject filterObject = new FilterObject(dataType, true);
        FilterField filterField = FilterBuilder.getFilterField((FilterObject)filterObject, (String)fieldName);
        if (null != filterField) {
            return;
        }
        MainEntityType fieldEntityType = dataType;
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            if (null == cachedDataTypes.get(entityNumber)) {
                fieldEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                cachedDataTypes.put(entityNumber, fieldEntityType);
            } else {
                fieldEntityType = cachedDataTypes.get(entityNumber);
            }
        }
        if (null == (filterField = FilterBuilder.getFilterField((MainEntityType)fieldEntityType, (String)fieldName))) {
            String appName = AppHelper.getMetaAppInfo(appId).getName().getLocaleValue();
            String entityName = dataType.getDisplayName().getLocaleValue();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7279\u6b8a\u6570\u636e\u6743\u9650\u89c4\u5219\u9a8c\u8bc1\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6761\u4ef6\u89c4\u5219\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u88ab\u5220\u9664\u3002\u89c4\u5219\u8def\u5f84\uff1a%1$s - %2$s - %3$s\u3002\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", (String)"OperationRuleObjCache_2", (String)"bos-permission-cache", (Object[])new Object[0]), appName, entityName, opRuleName));
        }
    }

    private static boolean isExceptOrNot(long userId, String opRuleObjId) {
        if (OperationRuleObjCache.checkExceptUser(opRuleObjId, userId).booleanValue()) {
            return true;
        }
        if (OperationRuleObjCache.checkExceptUsrGrp(opRuleObjId, userId).booleanValue()) {
            return true;
        }
        return OperationRuleObjCache.checkExceptRole(opRuleObjId, userId);
    }

    private static Boolean checkExceptUser(String opRuleObjId, Long userId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fuserid");
        sb.append(" from t_perm_exceptuser a");
        sb.append(" inner join t_perm_operationruleobj b on b.fid = a.foperationruleobjid");
        sb.append(" where b.fid = ? and b.fobjenabled = '1' ");
        sb.append(" and a.fuserid = ? ");
        Object[] params = new Object[]{opRuleObjId, userId};
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, rs -> {
            if (rs.next()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
    }

    private static Boolean checkExceptUsrGrp(String opRuleObjId, Long userId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("userId", userId);
        Set<Long> usrGrpIdSet = UserGroupHelper.getUsrGrpIdSet(paramMap);
        HashSet opRuleObjUsrGrpIdSet = new HashSet(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fusergroupid");
        sb.append(" from t_perm_oprexusrgrp a");
        sb.append(" inner join t_perm_operationruleobj b on b.fid = a.foperationruleobjid");
        sb.append(" where b.fid = ? and b.fobjenabled = '1' ");
        Object[] params = new Object[]{opRuleObjId};
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, rs -> {
            while (rs.next()) {
                opRuleObjUsrGrpIdSet.add(rs.getLong("fusergroupid"));
            }
            return null;
        });
        Set<Long> intersection = ListUtil.intersection(usrGrpIdSet, opRuleObjUsrGrpIdSet);
        return null != intersection && !intersection.isEmpty() && intersection.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    private static boolean ifFirstOrgProp(String fieldKey, Map<String, IDataEntityProperty> allFields) {
        try {
            String[] arrFieldKey = fieldKey.split("\\.");
            if (arrFieldKey == null || arrFieldKey.length == 0) {
                return false;
            }
            BasedataProp property = null;
            if (arrFieldKey.length == 2) {
                fieldKey = arrFieldKey[0];
                property = (BasedataProp)allFields.get(fieldKey);
                if (property == null) {
                    return false;
                }
                return property instanceof OrgProp;
            }
            if (arrFieldKey.length == 3) {
                return false;
            }
            return false;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return false;
        }
    }

    private static boolean ifOrgProp(String fieldKey, Map<String, IDataEntityProperty> allFields) {
        try {
            String[] arrFieldKey = fieldKey.split("\\.");
            if (arrFieldKey == null || arrFieldKey.length == 0) {
                return false;
            }
            BasedataProp property = null;
            if (arrFieldKey.length == 2) {
                fieldKey = arrFieldKey[0];
                property = (BasedataProp)allFields.get(fieldKey);
                if (property == null) {
                    return false;
                }
                return property instanceof OrgProp;
            }
            if (arrFieldKey.length == 3) {
                fieldKey = arrFieldKey[0];
                property = (BasedataProp)allFields.get(fieldKey);
                if (property == null) {
                    return false;
                }
                RefEntityType complexType = (RefEntityType)property.getComplexType();
                if (complexType == null) {
                    return false;
                }
                String secFieldKey = arrFieldKey[1];
                if (secFieldKey == null) {
                    return false;
                }
                IDataEntityProperty idep = complexType.findProperty(secFieldKey);
                if (secFieldKey.equals(idep.getName())) {
                    return idep instanceof OrgProp;
                }
            }
            return false;
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return false;
        }
    }

    private static FilterCondition replaceDirectorChargeOrg(Long userId, String appId, String entityNum, String operationKey, String operationRuleJson, String opRuleObjId) {
        String compType_MyChargeDept = "106";
        String compType_MyChargeDeptAndSub = "109";
        String compType_MyDept = "112";
        String compType_MyDeptAndSub = "113";
        String compType_include_17 = "17";
        String compType_include = "111";
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        operationRuleJson = PermCommonUtil.replaceBackSlach(operationRuleJson);
        Map allFields = dataEntityType.getAllFields();
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)operationRuleJson, FilterCondition.class);
        List filterList = fc.getFilterRow();
        HashMap comTypeOrgIdMap = new HashMap(8);
        for (SimpleFilterRow sfr : filterList) {
            String fieldName;
            String compType = sfr.getCompareType();
            String fieldKey = sfr.getFieldName();
            boolean isOrgSpecialCompType = "106".equals(compType) || "109".equals(compType) || "112".equals(compType) || "113".equals(compType);
            if (!isOrgSpecialCompType) continue;
            HashSet orgIdSet = (HashSet)comTypeOrgIdMap.get(compType);
            if (orgIdSet == null) {
                orgIdSet = new HashSet(8);
                List orgIds = new ArrayList(8);
                if ("106".equals(compType)) {
                    if (!OperationRuleObjCache.ifOrgProp(fieldKey, allFields)) continue;
                    orgIds = UserServiceHelper.getInchargeOrgs((long)userId, (boolean)false);
                } else if ("109".equals(compType)) {
                    orgIds = UserServiceHelper.getInchargeOrgs((long)userId, (boolean)true);
                } else if ("112".equals(compType)) {
                    orgIds = UserServiceHelper.getOrgsUserJoin((long)userId);
                } else if ("113".equals(compType)) {
                    orgIds = UserServiceHelper.getOrgsUserJoin((long)userId);
                    orgIds = OrgServiceHelper.getAllSubordinateOrgs(orgIds, (boolean)true);
                }
                if ("106".equals(compType) || "109".equals(compType)) {
                    List<Long> assignChargeOrgIds = null;
                    assignChargeOrgIds = kd.bos.util.StringUtils.isNotEmpty((String)opRuleObjId) ? OperationRuleObjCache.getDirectorChargeOrgs(opRuleObjId, userId) : OperationRuleObjCache.getDirectorChargeOrgs(appId, entityNum, operationKey, userId);
                    if ("109".equals(compType)) {
                        assignChargeOrgIds = OrgServiceHelper.getAllSubordinateOrgs(assignChargeOrgIds, (boolean)true);
                    }
                    if (assignChargeOrgIds != null) {
                        orgIds.addAll(assignChargeOrgIds);
                    }
                }
                orgIdSet.addAll(orgIds);
                comTypeOrgIdMap.put(compType, orgIdSet);
            }
            ArrayList<FilterValue> valueList = new ArrayList<FilterValue>();
            if (orgIdSet != null && !orgIdSet.isEmpty()) {
                for (Long orgId : orgIdSet) {
                    FilterValue fv = new FilterValue();
                    fv.setId(Uuid16.create().toString());
                    fv.setValue((Object)String.valueOf(orgId));
                    valueList.add(fv);
                }
            } else {
                FilterValue fv = new FilterValue();
                fv.setId(Uuid16.create().toString());
                fv.setValue((Object)String.valueOf("-1"));
                valueList.add(fv);
            }
            sfr.setValue(valueList);
            if (OperationRuleObjCache.ifFirstOrgProp(fieldKey, allFields)) {
                sfr.setCompareType("111");
            } else {
                sfr.setCompareType("17");
            }
            if (!(fieldName = sfr.getFieldName()).contains(".")) continue;
            fieldName = fieldName.substring(0, fieldName.lastIndexOf(46)) + ".id";
            sfr.setFieldName(fieldName);
        }
        if (fc != null) {
            logger.warn("OperationRuleObjeCache.replaceDirectorChargeOrgs:" + SerializationUtils.toJsonString((Object)fc));
        }
        return fc;
    }

    private static boolean checkExceptRole(String opRuleObjId, Long userId) {
        Set<String> roleIds = UserRoleCache.getRolesByUserId(userId);
        HashSet opRuleObjRoleIdSet = new HashSet(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.froleid");
        sb.append(" from t_perm_oprexrole a");
        sb.append(" inner join t_perm_operationruleobj b on b.fid = a.foperationruleobjid");
        sb.append(" where b.fid = ? and b.fobjenabled = '1' ");
        Object[] params = new Object[]{opRuleObjId};
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, rs -> {
            while (rs.next()) {
                opRuleObjRoleIdSet.add(rs.getString("froleid"));
            }
            return null;
        });
        Set<String> intersection = ListUtil.intersection(roleIds, opRuleObjRoleIdSet);
        return null != intersection && !intersection.isEmpty() && intersection.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    private static List<Long> getDirectorChargeOrgs(String opruleObjId, Long userID) {
        ArrayList<Long> inchargeOrgs = new ArrayList<Long>(20);
        String selectFields = "id, org.id";
        QFilter opruleObjIdFilter = new QFilter("operationruleobj.id", "=", (Object)opruleObjId);
        QFilter directorFilter = new QFilter("director.id", "=", (Object)userID);
        QFilter[] filters = new QFilter[]{opruleObjIdFilter, directorFilter};
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"perm_director", (String)selectFields, (QFilter[])filters);
        Collection dObjs = loadFromCache.values();
        if (!CollectionUtils.isEmpty(dObjs)) {
            for (DynamicObject dObj : dObjs) {
                Long orgId = dObj.getLong("org_id");
                inchargeOrgs.add(orgId);
            }
            return inchargeOrgs;
        }
        return inchargeOrgs;
    }

    private static List<Long> getDirectorChargeOrgs(String appId, String entityNum, String operateKey, Long userID) {
        ArrayList<Long> inchargeOrgs = new ArrayList<Long>(20);
        String selectFields = "id, org.id";
        QFilter entityFilter = new QFilter("operationruleobj.entitytype.id", "=", (Object)entityNum);
        QFilter operateTypeFilter = new QFilter("operationruleobj.operationrule.operation_key", "=", (Object)operateKey);
        QFilter objenabledFilter = new QFilter("operationruleobj.objenabled", "=", (Object)"1");
        QFilter directorFilter = new QFilter("director.id", "=", (Object)userID);
        QFilter appFilter = new QFilter("operationruleobj.bizapp.id", "=", (Object)appId);
        QFilter[] filters = new QFilter[]{entityFilter, operateTypeFilter, objenabledFilter, directorFilter, appFilter};
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"perm_director", (String)selectFields, (QFilter[])filters);
        Collection dObjs = loadFromCache.values();
        if (CollectionUtils.isEmpty(dObjs)) {
            QFilter[] filters2 = new QFilter[]{entityFilter, operateTypeFilter, objenabledFilter, directorFilter};
            Map loadFromCache2 = BusinessDataServiceHelper.loadFromCache((String)"perm_director", (String)selectFields, (QFilter[])filters2);
            Collection dObjs2 = loadFromCache2.values();
            if (CollectionUtils.isEmpty(dObjs2)) {
                return inchargeOrgs;
            }
            for (DynamicObject director : dObjs) {
                Long orgId = director.getLong("org_id");
                inchargeOrgs.add(orgId);
            }
            return inchargeOrgs;
        }
        for (DynamicObject director : dObjs) {
            Long orgId = director.getLong("org_id");
            inchargeOrgs.add(orgId);
        }
        return inchargeOrgs;
    }

    public static String getSpecialDataPermScript(String appId, String entityNum, String operationKey, StringBuilder sbNotMatchTips) {
        logger.debug("[getSpecialDataPermScript]\u8c03\u7528\u63a5\u53e3 \u5165\u53c2appId = " + appId + ", entityNum = " + entityNum + ", operationKey = " + operationKey);
        appId = PermCommonUtil.getAppIdFromSuspectedAppNum(appId);
        appId = PermCommonUtil.getCheckPermAppId_old(appId, entityNum);
        entityNum = FormMetadataCache.getFormConfig((String)entityNum).getEntityTypeId();
        long userId = RequestContext.get().getCurrUserId();
        if (sbNotMatchTips != null) {
            sbNotMatchTips.setLength(0);
        }
        String cacheKey = String.format(CACHEKEY, userId, appId, entityNum, operationKey);
        String type4OpRuleObj = CacheMrg.getType4OperationRuleObj();
        String cache = CacheMrg.getCache(type4OpRuleObj, cacheKey);
        String resultScript = null;
        if (!CacheMrg.isNotLoaded(cache)) {
            if (CacheMrg.isData(cache)) {
                return OperationRuleObjCache.resetScriptFromCache(cache, appId, entityNum, operationKey, sbNotMatchTips);
            }
            return "1=1";
        }
        cache = OperationRuleObjCache.loadSpecialDataPermRuleFromDB(userId, appId, entityNum, operationKey, sbNotMatchTips);
        resultScript = OperationRuleObjCache.resetScriptFromCache(cache, appId, entityNum, operationKey, sbNotMatchTips);
        return resultScript;
    }

    private static String resetScriptFromCache(String cache, String appId, String entityNum, String operationKey, StringBuilder sbNotMatchTips) {
        if (sbNotMatchTips != null) {
            sbNotMatchTips.setLength(0);
        } else {
            sbNotMatchTips = new StringBuilder(8);
        }
        if (CacheMrg.isData(cache)) {
            String[] arrSplitCache = cache.split(SPLIT_STR);
            String opRuleJson = arrSplitCache[0];
            String opRuleObjId = arrSplitCache[1];
            String opRuleNameJson = arrSplitCache[2];
            Map opRuleNameMap = (Map)SerializationUtils.fromJsonString((String)opRuleNameJson, Map.class);
            String opRuleName = (String)opRuleNameMap.get(RequestContext.get().getLang().name());
            if (kd.bos.util.StringUtils.isEmpty((String)opRuleName) && kd.bos.util.StringUtils.isEmpty((String)(opRuleName = (String)opRuleNameMap.get("GLang")))) {
                opRuleName = (String)opRuleNameMap.get("zh_CN");
            }
            sbNotMatchTips.append(opRuleName);
            long userId = RequestContext.get().getCurrUserId();
            boolean isExcept = OperationRuleObjCache.isExceptOrNot(userId, opRuleObjId);
            if (isExcept) {
                return "1=1";
            }
            FilterCondition fc = OperationRuleObjCache.replaceDirectorChargeOrg(userId, null, entityNum, null, opRuleJson, opRuleObjId);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
            String scriptFromJson = PermCommonUtil.getDataRuleScriptFromFilterCond(dataEntityType, fc);
            return scriptFromJson;
        }
        return "1=1";
    }

    private static String loadSpecialDataPermRuleFromDB(Long userId, String appId, String entityNum, String operationKey, StringBuilder sbNotMatchTips) {
        String type4OpRuleObj = CacheMrg.getType4OperationRuleObj();
        StringBuilder sbSql = new StringBuilder();
        String localeId = RequestContext.get().getLang().toString();
        sbSql.append("SELECT opro.fid opruleobjid, opr.fid ruleid, opr.fname rulename_def,oprl.fname rulename ").append("FROM t_perm_operationruleobj opro ").append("INNER JOIN t_perm_operationrule opr ").append("ON opro.foperationruleid = opr.fid ").append("LEFT JOIN t_perm_operationrule_l oprl ").append("ON (opr.fid = oprl.fid AND oprl.flocaleid = '").append(localeId).append("') ").append("WHERE opro.fentitytypeid = ? ").append("AND opro.fbizappid   = ? ").append("AND opr.foperationkey = ? ").append("AND opro.fobjenabled = '1' ");
        Object[] params = new Object[]{entityNum, appId, operationKey};
        return (String)DB.query((DBRoute)DBRoute.basedata, (String)sbSql.toString(), (Object[])params, rs -> {
            String cacheKey = String.format(CACHEKEY, userId, appId, entityNum, operationKey);
            if (rs.next()) {
                String opRuleId = rs.getString("ruleid");
                String opRuleName = rs.getString("rulename");
                opRuleName = opRuleName == null ? rs.getString("rulename_def") : opRuleName;
                String opRuleObjId = rs.getString("opruleobjid");
                return OperationRuleObjCache.loadOpRuleAndPutInCache(cacheKey, opRuleId, opRuleObjId, sbNotMatchTips, true);
            }
            logger.debug("[loadSpecialDataPermRuleFromDB]\u8bfb\u53d6\u6570\u636e\u5e93\u914d\u7f6e\u6210\u529f\u4f46\u6ca1\u6709\u76f8\u5173\u914d\u7f6e\uff0c\u5e76\u8bbe\u7f6e\u7f13\u5b58 type = " + type4OpRuleObj + ", key = " + cacheKey + ", value = PERM_DATA_LOADED");
            CacheMrg.loaded(type4OpRuleObj, cacheKey);
            return "PERM_DATA_LOADED";
        });
    }

    public static Map<Object, Boolean> checkOperationRule(Long userId, String formNum, String operationKey, List<Object> pkIds, StringBuilder sbNotMatchTips) {
        if (sbNotMatchTips == null) {
            sbNotMatchTips = new StringBuilder(8);
        }
        HashMap<Object, Boolean> result = new HashMap<Object, Boolean>(8);
        if (userId == null || kd.bos.util.StringUtils.isEmpty((String)formNum) || kd.bos.util.StringUtils.isEmpty((String)operationKey) || pkIds == null || pkIds.isEmpty()) {
            return result;
        }
        for (Object pkId : pkIds) {
            result.put(pkId, Boolean.FALSE);
        }
        String entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
        HashSet<String> allCheckPermAppIds = new HashSet<String>(8);
        Map<String, String> extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel();
        String originalAppId = BizAppServiceHelp.getAppIdByFormNum((String)entityNum);
        originalAppId = extAppOrgnlAppMap.get(originalAppId);
        allCheckPermAppIds.add(originalAppId);
        PermissionControlType permissionControlType = FormHelper.getPermissionControlType(entityNum);
        List publishAppIds = permissionControlType.getPublishApps();
        if (publishAppIds != null && !publishAppIds.isEmpty()) {
            allCheckPermAppIds.addAll(publishAppIds);
        }
        StringBuilder queryMenuSql = new StringBuilder("select app.fid appid ").append(" from t_meta_menuruntime mr ").append(" inner join t_meta_bizapp app on(app.fnumber = mr.fappid) ").append(" where fformid = ? ");
        Set menuAppIds = (Set)DB.query((DBRoute)DBRoute.meta, (String)queryMenuSql.toString(), (Object[])new Object[]{formNum}, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> set = new HashSet<String>(8);
                while (rs.next()) {
                    String appId = rs.getString("appid");
                    set.add(appId);
                }
                return set;
            }
        });
        allCheckPermAppIds.addAll(menuAppIds);
        if (allCheckPermAppIds.isEmpty()) {
            logger.warn("OperationRuleObjCache.checkOperationRule: checkPermAppId Not Found!");
            return result;
        }
        QFilter allSpecialDataPermFilters = null;
        StringBuilder tempNotMatchTips = null;
        for (String checkPermAppId : allCheckPermAppIds) {
            if (kd.bos.util.StringUtils.isEmpty((String)checkPermAppId)) continue;
            checkPermAppId = PermCommonUtil.getAppIdFromSuspectedAppNum(checkPermAppId);
            checkPermAppId = PermCommonUtil.getCheckPermAppId_old(checkPermAppId, entityNum);
            tempNotMatchTips = new StringBuilder();
            QFilter filter = (QFilter)OperationRuleObjCache.queryOperationRule(userId, checkPermAppId, entityNum, operationKey, tempNotMatchTips, true);
            if (sbNotMatchTips.length() != 0) {
                sbNotMatchTips.append(",");
            }
            sbNotMatchTips.append((CharSequence)tempNotMatchTips);
            if (filter != null) {
                if (allSpecialDataPermFilters == null) {
                    allSpecialDataPermFilters = filter;
                    continue;
                }
                allSpecialDataPermFilters.or(filter);
                continue;
            }
            allSpecialDataPermFilters = null;
            break;
        }
        if (allSpecialDataPermFilters == null) {
            for (Object pkId : pkIds) {
                result.put(pkId, Boolean.TRUE);
            }
            return result;
        }
        allSpecialDataPermFilters.and(new QFilter("id", "in", pkIds));
        DynamicObject[] dObjArr = BusinessDataServiceHelper.load((String)entityNum, (String)"id", (QFilter[])allSpecialDataPermFilters.toArray());
        if (dObjArr != null && dObjArr.length != 0) {
            for (DynamicObject dObj : dObjArr) {
                Object pkId;
                if (dObj == null || (pkId = dObj.get("id")) == null) continue;
                result.put(pkId, Boolean.TRUE);
            }
        }
        return result;
    }
}

