/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.RoleInfo;
import kd.bos.permission.cache.UserRoleCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class RoleCache {
    private static final String LOADED_KEY = "LOADED";
    private static final String SYSTEM_TYPE = "bos-permission-cache";

    public static RoleInfo getRoleInfoById(String roleId) {
        if (StringUtils.isEmpty((String)roleId)) {
            return null;
        }
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add(roleId);
        List<RoleInfo> roleInfos = RoleCache.getRoleInfoByIds(roleIds);
        if (roleInfos == null || roleInfos.isEmpty()) {
            return null;
        }
        return roleInfos.get(0);
    }

    public static List<RoleInfo> getRoleInfoByIds(List<String> roleIds) {
        ArrayList<RoleInfo> result = new ArrayList<RoleInfo>();
        if (roleIds == null || roleIds.isEmpty()) {
            return null;
        }
        String selFields = "number" + "," + "name" + "," + "bizdomain" + "," + "enable" + "," + "remark" + "," + "roletype" + "," + "createadmingrp" + "," + "usescope" + "," + "issystem";
        DynamicObject[] roleArr = BusinessDataServiceHelper.load((String)"perm_role", (String)selFields, (QFilter[])new QFilter[]{new QFilter("id", "in", roleIds)});
        if (roleArr == null || roleArr.length == 0) {
            return null;
        }
        for (DynamicObject role : roleArr) {
            if (role == null) continue;
            String bizAppId = "";
            DynamicObject bizApp = role.getDynamicObject("bizdomain");
            if (bizApp != null) {
                bizAppId = bizApp.getString("id");
            }
            RoleInfo roleInfo = new RoleInfo();
            roleInfo.setId((String)role.getPkValue());
            roleInfo.setNum(role.getString("number"));
            roleInfo.setLocaleName(role.getLocaleString("name"));
            roleInfo.setName(role.getString("name"));
            roleInfo.setBizAppId(bizAppId);
            roleInfo.setEnable(role.getBoolean("enable"));
            roleInfo.setRemarkLocale(role.getLocaleString("remark"));
            roleInfo.setRemark(role.getString("remark"));
            roleInfo.setType(role.getString("roletype"));
            roleInfo.setCreateAdminGrp(role.getString("createadmingrp"));
            roleInfo.setUseScope(role.getString("usescope"));
            roleInfo.setSystem(role.getBoolean("issystem"));
            result.add(roleInfo);
        }
        return result;
    }

    @Deprecated
    public static Set<String> getRolesByUserId(Long userId) {
        return UserRoleCache.getRolesByUserId(userId, null, null);
    }

    @Deprecated
    public static Set<String> getRolesByUserId(Long userId, List<Long> dimObjIds, String dimType) {
        return UserRoleCache.getRolesByUserId(userId, dimObjIds, dimType);
    }

    @Deprecated
    public static Set<String> getRolesByUserId(Long userId, List<Long> dimObjIds, String dimType, boolean containRole, boolean containBizRole) {
        return UserRoleCache.getRolesByUserId(userId, dimObjIds, dimType, containRole, containBizRole);
    }

    @Deprecated
    public static List<RoleInfo> getRoleInfos(long userId, long orgId) {
        return UserRoleCache.getRoleInfos(userId, orgId);
    }

    @Deprecated
    public static Set<String> getRoles(Long pUserId, Long pOrgId) {
        return UserRoleCache.getRoles(pUserId, pOrgId, null);
    }

    @Deprecated
    public static Set<String> getRoles(Long pUserId, Long pOrgId, String orgViewId) {
        return UserRoleCache.getRoles(pUserId, pOrgId, orgViewId);
    }

    @Deprecated
    public static Set<String> getRoles(Long pUserId, List<Long> pOrgIds, String pOrgViewId) {
        return UserRoleCache.getRoles(pUserId, pOrgIds, pOrgViewId);
    }

    @Deprecated
    public static Map<Long, Set<String>> getOrgRoleAssignMap(Long pUserId) {
        return UserRoleCache.getOrgRoleAssignMap(pUserId);
    }

    @Deprecated
    public static List<Long> getUsersByRoleId(String roleId) {
        return UserRoleCache.getUsersByRoleId(roleId);
    }

    @Deprecated
    public static List<Long> getUsersByRoleNum(String roleNum) {
        return UserRoleCache.getUsersByRoleNum(roleNum);
    }

    @Deprecated
    public static Map<String, Set<Long>> getRoleOrgAssignMap(Long pUserId) {
        return UserRoleCache.getRoleOrgAssignMap(pUserId);
    }

    @Deprecated
    public static Map<String, Map<Long, Boolean>> getRoleDimObjAssignMapSimple(Long pUserId) {
        return UserRoleCache.getRoleDimObjAssignMapSimple(pUserId);
    }

    public static boolean newRole(RoleInfo roleInfo, StringBuilder processInfo) {
        ILocaleString remarkLocale;
        DynamicObject group;
        String groupId;
        String useScope;
        String createAdminGrp;
        if (roleInfo == null) {
            processInfo.append(ResManager.loadKDString((String)"roleInfo\u4e0d\u80fd\u4e3a\u7a7a", (String)"RoleCache_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject roleDObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_role");
        String num = roleInfo.getNum();
        if (!StringUtils.isNotEmpty((String)num)) {
            processInfo.append(ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"RoleCache_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        roleDObj.set("number", (Object)roleInfo.getNum());
        ILocaleString localeName = roleInfo.getLocaleName();
        if (localeName == null) {
            String name = roleInfo.getName();
            if (StringUtils.isNotEmpty((String)name)) {
                localeName = new LocaleString(Lang.get().toString(), name);
            } else {
                processInfo.append(ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"RoleCache_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return false;
            }
        }
        roleDObj.set("name", (Object)localeName);
        String type = roleInfo.getType();
        if (!StringUtils.isNotEmpty((String)type)) {
            processInfo.append(ResManager.loadKDString((String)"\u201c\u9002\u7528\u7528\u6237\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"RoleCache_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        roleDObj.set("roletype", (Object)type);
        String newRoleId = roleInfo.getId();
        if (StringUtils.isNotEmpty((String)newRoleId)) {
            roleDObj.set("id", (Object)newRoleId);
        }
        if (StringUtils.isNotEmpty((String)(createAdminGrp = roleInfo.getCreateAdminGrp()))) {
            roleDObj.set("createadmingrp", (Object)createAdminGrp);
        }
        roleDObj.set("usescope", (Object)(StringUtils.isEmpty((String)(useScope = roleInfo.getUseScope())) ? "2" : useScope));
        String bizAppId = roleInfo.getBizAppId();
        if (StringUtils.isNotEmpty((String)bizAppId)) {
            roleDObj.set("bizdomain", (Object)bizAppId);
        }
        if (StringUtils.isNotEmpty((String)(groupId = roleInfo.getGroupId())) && (group = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"perm_rolegroup")) != null) {
            roleDObj.set("group", (Object)group);
        }
        if ((remarkLocale = roleInfo.getRemarkLocale()) == null) {
            String remark = roleInfo.getRemark();
            if (StringUtils.isNotEmpty((String)remark)) {
                roleDObj.set("remark", (Object)remark);
            }
        } else {
            roleDObj.set("remark", (Object)remarkLocale);
        }
        boolean isSystem = roleInfo.isSystem();
        roleDObj.set("issystem", (Object)isSystem);
        Long creatorid = Long.parseLong(RequestContext.get().getUserId());
        roleDObj.set("creator", (Object)creatorid);
        roleDObj.set("createtime", (Object)new Date());
        roleDObj.set("status", (Object)"C");
        boolean enable = roleInfo.isEnable();
        if (enable) {
            roleDObj.set("enable", (Object)"1");
        } else {
            roleDObj.set("enable", (Object)"0");
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("skipCheckDataPermission", String.valueOf(true));
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"perm_role", (DynamicObject[])new DynamicObject[]{roleDObj}, (OperateOption)option);
        if (executeOperate.isSuccess()) {
            processInfo.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"RoleCache_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            roleInfo.setId((String)executeOperate.getSuccessPkIds().get(0));
            return true;
        }
        processInfo.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25: ", (String)"RoleCache_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        processInfo.append(executeOperate.getMessage()).append(' ');
        for (OperateErrorInfo opErrInfo : executeOperate.getAllErrorInfo()) {
            processInfo.append(opErrInfo.getErrorCode()).append(',').append(opErrInfo.getErrorLevel()).append(',').append(opErrInfo.getMessage()).append('\n');
        }
        for (ValidateResult validateResults : executeOperate.getValidateResult().getValidateErrors()) {
            for (OperateErrorInfo opErrInfo : validateResults.getAllErrorInfo()) {
                processInfo.append(opErrInfo.getErrorCode()).append(',').append(opErrInfo.getErrorLevel()).append(',').append(opErrInfo.getMessage()).append('\n');
            }
        }
        return false;
    }

    public static boolean modifyRole(RoleInfo roleInfo, StringBuilder processInfo) {
        ILocaleString remarkLocale;
        DynamicObject group;
        String groupId;
        String bizAppId;
        String useScope;
        String createAdminGrp;
        String type;
        String name;
        ILocaleString localeName;
        if (roleInfo == null) {
            processInfo.append(ResManager.loadKDString((String)"roleInfo\u4e0d\u80fd\u4e3a\u7a7a", (String)"RoleCache_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        String roleId = roleInfo.getId();
        if (StringUtils.isEmpty((String)roleId)) {
            processInfo.append(ResManager.loadKDString((String)"\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a", (String)"RoleCache_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        DynamicObject roleDObj = BusinessDataServiceHelper.loadSingle((Object)roleId, (String)"perm_role");
        String roleNum = roleInfo.getNum();
        if (StringUtils.isNotEmpty((String)roleNum)) {
            roleDObj.set("number", (Object)roleNum);
        }
        if ((localeName = roleInfo.getLocaleName()) == null && StringUtils.isNotEmpty((String)(name = roleInfo.getName()))) {
            localeName = new LocaleString(Lang.get().toString(), name);
        }
        if (localeName != null) {
            roleDObj.set("name", (Object)localeName);
        }
        if (StringUtils.isNotEmpty((String)(type = roleInfo.getType()))) {
            roleDObj.set("roletype", (Object)type);
        }
        if (StringUtils.isNotEmpty((String)(createAdminGrp = roleInfo.getCreateAdminGrp()))) {
            roleDObj.set("createadmingrp", (Object)createAdminGrp);
        }
        if (StringUtils.isNotEmpty((String)(useScope = roleInfo.getUseScope()))) {
            roleDObj.set("usescope", (Object)useScope);
        }
        if (StringUtils.isNotEmpty((String)(bizAppId = roleInfo.getBizAppId()))) {
            roleDObj.set("bizdomain", (Object)bizAppId);
        }
        if (StringUtils.isNotEmpty((String)(groupId = roleInfo.getGroupId())) && (group = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"perm_rolegroup")) != null) {
            roleDObj.set("group", (Object)group);
        }
        if ((remarkLocale = roleInfo.getRemarkLocale()) == null) {
            String remark = roleInfo.getRemark();
            if (StringUtils.isNotEmpty((String)remark)) {
                roleDObj.set("remark", (Object)remark);
            }
        } else {
            roleDObj.set("remark", (Object)remarkLocale);
        }
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        roleDObj.set("modifier", (Object)userId);
        roleDObj.set("modifytime", (Object)new Date());
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("skipCheckDataPermission", String.valueOf(true));
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"save", (String)"perm_role", (DynamicObject[])new DynamicObject[]{roleDObj}, (OperateOption)option);
        if (executeOperate.isSuccess()) {
            processInfo.append(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"RoleCache_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return true;
        }
        processInfo.append(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25: ", (String)"RoleCache_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        for (OperateErrorInfo opErrInfo : executeOperate.getAllErrorInfo()) {
            processInfo.append(opErrInfo.getErrorCode()).append(',').append(opErrInfo.getErrorLevel()).append(',').append(opErrInfo.getMessage()).append('\n');
        }
        for (ValidateResult validateResults : executeOperate.getValidateResult().getValidateErrors()) {
            for (OperateErrorInfo opErrInfo : validateResults.getAllErrorInfo()) {
                processInfo.append(opErrInfo.getErrorCode()).append(',').append(opErrInfo.getErrorLevel()).append(',').append(opErrInfo.getMessage()).append('\n');
            }
        }
        return false;
    }

    public static boolean deleteRole(RoleInfo roleInfo, StringBuilder processInfo) {
        if (roleInfo == null) {
            processInfo.append(ResManager.loadKDString((String)"roleInfo\u4e0d\u80fd\u4e3a\u7a7a", (String)"RoleCache_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        String roleId = roleInfo.getId();
        String roleNum = roleInfo.getNum();
        if (StringUtils.isEmpty((String)roleId) && StringUtils.isEmpty((String)roleNum)) {
            processInfo.append(ResManager.loadKDString((String)"\u89d2\u8272ID\u6216\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"RoleCache_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        QFilter qFilter = null;
        if (StringUtils.isNotEmpty((String)roleId)) {
            qFilter = new QFilter("id", "=", (Object)roleId);
        } else if (StringUtils.isNotEmpty((String)roleNum)) {
            qFilter = new QFilter("number", "=", (Object)roleNum);
        }
        DynamicObject roleDObj = BusinessDataServiceHelper.loadSingle((String)"perm_role", (String)"id , number, enable, issystem ", (QFilter[])new QFilter[]{qFilter});
        if (roleDObj == null) {
            processInfo.append(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u4ee5\u5220\u9664\u7684\u89d2\u8272", (String)"RoleCache_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        String id = roleDObj.getString("id");
        OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"delete", (String)"perm_role", (Object[])new Object[]{id}, (OperateOption)OperateOption.create());
        if (executeOperate.isSuccess()) {
            processInfo.append(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"RoleCache_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return true;
        }
        processInfo.append(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25: ", (String)"RoleCache_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        processInfo.append(executeOperate.getMessage()).append(' ');
        for (OperateErrorInfo opErrInfo : executeOperate.getAllErrorInfo()) {
            processInfo.append(opErrInfo.getErrorCode()).append(',').append(opErrInfo.getErrorLevel()).append(',').append(opErrInfo.getMessage()).append('\n');
        }
        for (ValidateResult validateResults : executeOperate.getValidateResult().getValidateErrors()) {
            for (OperateErrorInfo opErrInfo : validateResults.getAllErrorInfo()) {
                processInfo.append(opErrInfo.getErrorCode()).append(',').append(opErrInfo.getErrorLevel()).append(',').append(opErrInfo.getMessage()).append('\n');
            }
        }
        return false;
    }

    public static RoleInfo[] queryRoles(QFilter q) {
        String selProp = "id" + "," + "bizdomain" + "," + "enable" + "," + "group" + "," + "issystem" + "," + "name" + "," + "number" + "," + "remark" + "," + "status" + "," + "createadmingrp" + "," + "usescope" + "," + "roletype";
        DynamicObject[] roleDObjs = BusinessDataServiceHelper.load((String)"perm_role", (String)selProp, (QFilter[])new QFilter[]{q});
        if (roleDObjs == null || roleDObjs.length == 0) {
            return null;
        }
        RoleInfo[] roleInfos = new RoleInfo[roleDObjs.length];
        for (int i = 0; i < roleDObjs.length; ++i) {
            DynamicObject roleObj = roleDObjs[i];
            DynamicObject roleGroupObj = roleObj.getDynamicObject("group");
            DynamicObject bizAppObj = roleObj.getDynamicObject("bizdomain");
            RoleInfo roleInfo = new RoleInfo();
            if (bizAppObj != null) {
                roleInfo.setBizAppId((String)bizAppObj.getPkValue());
            }
            roleInfo.setEnable(roleObj.getBoolean("enable"));
            if (roleGroupObj != null) {
                roleInfo.setGroupId((String)roleGroupObj.getPkValue());
            }
            roleInfo.setId(roleObj.getString("id"));
            roleInfo.setLocaleName(roleObj.getLocaleString("name"));
            roleInfo.setNum(roleObj.getString("number"));
            roleInfo.setRemark(roleObj.getString("remark"));
            roleInfo.setSystem(roleObj.getBoolean("issystem"));
            roleInfo.setCreateAdminGrp(roleObj.getString("createadmingrp"));
            roleInfo.setUseScope(roleObj.getString("usescope"));
            roleInfo.setType(roleObj.getString("roletype"));
            roleInfos[i] = roleInfo;
        }
        return roleInfos;
    }

    public static boolean roleAssignFuncPerm(String roleId, Map<String, Map<String, List<String>>> appEntityPermItemMap, boolean addOrRemove, StringBuilder processInfo) {
        if (StringUtils.isEmpty((String)roleId)) {
            processInfo.append(ResManager.loadKDString((String)"roleId\u4e0d\u80fd\u4e3a\u7a7a", (String)"RoleCache_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        String selProp = "id" + "," + "bizapp" + "," + "entity" + "," + "permitem" + "," + "droleid";
        DynamicObject[] rolePermDoc = BusinessDataServiceHelper.load((String)"perm_roleperm", (String)selProp, (QFilter[])new QFilter[]{new QFilter("roleid", "=", (Object)roleId)});
        DynamicObject rolePermObj = null;
        if (rolePermDoc != null && rolePermDoc.length > 0) {
            rolePermObj = rolePermDoc[0];
        } else {
            rolePermObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_roleperm");
            rolePermObj.set("roleid", (Object)roleId);
        }
        DynamicObjectCollection permItemCol = rolePermObj.getDynamicObjectCollection("roleperm");
        DynamicObject permItemObj = null;
        DynamicObjectType entryType = permItemCol.getDynamicObjectType();
        if (addOrRemove) {
            for (Object dObj : permItemCol) {
                List<String> list;
                String string = dObj.getString("bizapp.id");
                String entityNum = dObj.getString("entity.id");
                String permItemId = dObj.getString("permitem.id");
                Map<String, List<String>> entPermItemMap = appEntityPermItemMap.get(string);
                if (entPermItemMap == null || CollectionUtils.isEmpty(list = entPermItemMap.get(entityNum)) || !list.contains(permItemId)) continue;
                list.remove(permItemId);
                if (list.size() != 0) continue;
                entPermItemMap.remove(entityNum);
                if (entPermItemMap.size() != 0) continue;
                appEntityPermItemMap.remove(string);
            }
            HashMap<String, List> appEntity = new HashMap<String, List>();
            for (Map.Entry entry : appEntityPermItemMap.entrySet()) {
                String appId = (String)entry.getKey();
                Map entityPermItemMap = (Map)entry.getValue();
                for (Map.Entry entry2 : entityPermItemMap.entrySet()) {
                    String entityNum = (String)entry2.getKey();
                    List permItemIds = (List)entry2.getValue();
                    for (String permItemId : permItemIds) {
                        permItemObj = new DynamicObject(entryType);
                        permItemObj.set("bizapp", (Object)appId);
                        permItemObj.set("entity", (Object)entityNum);
                        permItemObj.set("permitem", (Object)permItemId);
                        permItemObj.set("droleid", (Object)roleId);
                        permItemCol.add((Object)permItemObj);
                    }
                    appEntity.computeIfAbsent(appId, k -> new ArrayList()).add(entityNum);
                }
            }
        } else {
            Iterator iterator = permItemCol.iterator();
            while (iterator.hasNext()) {
                List<String> list;
                DynamicObject oldPermItemObj = (DynamicObject)iterator.next();
                String string = oldPermItemObj.getString("bizapp.id");
                String entityNum = oldPermItemObj.getString("entity.id");
                String permItemId = oldPermItemObj.getString("permitem.id");
                Map<String, List<String>> entPermItemMap = appEntityPermItemMap.get(string);
                if (entPermItemMap == null || CollectionUtils.isEmpty(list = entPermItemMap.get(entityNum)) || !list.contains(permItemId)) continue;
                iterator.remove();
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rolePermObj});
        processInfo.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"RoleCache_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        PermissionServiceHelper.clearAllCache();
        return true;
    }
}

