/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class SuperUserCache {
    private static Log logger = LogFactory.getLog(SuperUserCache.class);
    private static final String SUPER_USER_KEY = "SuperUserInfo";

    @SdkInternal
    public static boolean isSuperUser(long userId) {
        try {
            RequestContext rc = RequestContext.get();
            String key = String.format("%s%s%s", "isSuperUser_", rc.getAccountId(), userId);
            Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>(8);
                boolean superUserPri = SuperUserCache.isSuperUserPri(userId);
                map.put("superUserPri", superUserPri);
                return map;
            });
            return (Boolean)threadCacheMap.get("superUserPri");
        }
        catch (Exception e) {
            logger.warn("[SuperUserCache]\u83b7\u53d6\u7528\u6237\u8d85\u7ea7\u7ba1\u7406\u5458\u4fe1\u606f\u5f02\u5e38,userId:{}", (Object)userId, (Object)e);
            return false;
        }
    }

    private static boolean isSuperUserPri(long userId) {
        String type = CacheMrg.getType4SuperUser();
        String key = SUPER_USER_KEY + userId;
        String superUserCache = CacheMrg.getCache(type, key);
        String result = "0";
        result = StringUtils.isEmpty((String)superUserCache) ? SuperUserCache.loadCache(type, key, userId) : superUserCache;
        return StringUtils.isNotEmpty((String)result) && Objects.equals("1", result);
    }

    private static String loadCache(String type, String key, long userId) {
        String result = "0";
        DLock dl = null;
        try {
            dl = DLock.create((String)("loadSuperUserInfo" + userId));
            dl.lock();
            if (Objects.equals(userId, 0L)) {
                CacheMrg.putCache(type, key, result);
                String string = result;
                return string;
            }
            result = CacheMrg.getCache(type, key);
            if (StringUtils.isNotEmpty((String)result)) {
                String string = result;
                return string;
            }
            String sql = "SELECT fuserid FROM T_PERM_SUPERUSER WHERE fuserid=? ";
            result = (String)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])new Object[]{userId}, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws SQLException {
                    if (rs.next()) {
                        return "1";
                    }
                    return "0";
                }
            });
        }
        catch (Exception e) {
            logger.warn("[SuperUserCache]\u521d\u59cb\u5316\u8d85\u7ea7\u7ba1\u7406\u5458\u4fe1\u606f\u5f02\u5e38,userId:{}", (Object)userId, (Object)e);
            throw e;
        }
        finally {
            if (dl != null) {
                dl.unlock();
            }
        }
        CacheMrg.putCache(type, key, result);
        return result;
    }

    public static void putCache(String userId) {
        String type = CacheMrg.getType4SuperUser();
        String key = SUPER_USER_KEY + userId;
        CacheMrg.putCache(type, key, "1");
    }

    public static void removeCache(String userId) {
        String type = CacheMrg.getType4SuperUser();
        String key = SUPER_USER_KEY + userId;
        CacheMrg.clearCache(type, key);
    }
}

