/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.framework.gray.GrayStrategy;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.PermissionService;
import kd.bos.permission.cache.AdminPermCache;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.SuperUserCache;
import kd.bos.permission.cache.UserAppPermService;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.PermGrayHelper;
import kd.bos.permission.cache.util.AdminUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.perm.req.GetPermLevelHashReq;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UserAppCache {
    public static final String SYS_CLOUD_ID = "83bfebc800000bac";
    public static final String BASESERVICE_BIZAPPID = "83bfebc8000037ac";
    public static final String CONFIGURATIONTOOL_BIZAPPID = "18XR3MJ0W0ET";
    public static final String BASEDATA_BIZAPPID = "0efa1992000000ac";
    public static final String SYSTEMMANAGEMENT_BIZAPPID = "18XSXYEL8//U";
    public static final String DATA_HASLOADED = "DATA_LOADED";
    private static final String PARAMKEY_ALLUSERAPPIDS = "allUserAppIds";

    public static void putCache(Long userId, List<String> appIdList) {
        UserAppCache.putCache(userId, appIdList, CacheMrg.getExpireTime());
    }

    public static void putCache(Long userId, List<String> appIdList, int remainExpireTime) {
        CacheMrg.putCache(CacheMrg.getType4UserApp(), String.valueOf(userId), CollectionUtils.isEmpty(appIdList) ? DATA_HASLOADED : SerializationUtils.toJsonString(appIdList), remainExpireTime);
    }

    public static void putCache(String cacheKey, List<String> appIdList, Integer remainExpireTime) {
        CacheMrg.putCache(CacheMrg.getType4UserApp(), cacheKey, CollectionUtils.isEmpty(appIdList) ? DATA_HASLOADED : SerializationUtils.toJsonString(appIdList), null == remainExpireTime ? CacheMrg.getExpireTime() : remainExpireTime);
    }

    public static List<String> getCache(Long pUserID) {
        return UserAppCache.getCache(new GetPermLevelHashReq(pUserID, null, null, true));
    }

    public static List<String> getCache(GetPermLevelHashReq req) {
        Long pUserID = req.getUserId();
        if (StringUtils.isNotEmpty((String)req.getAppId())) {
            String realAppId = PermCommonUtil.getAppIdFromSuspectedAppNum(req.getAppId());
            req.setAppId(realAppId);
        }
        String appId = req.getAppId();
        String cacheKey = pUserID + "_" + appId;
        String userBizAppsJson = CacheMrg.getCache(CacheMrg.getType4UserApp(), cacheKey);
        if (DATA_HASLOADED.equals(userBizAppsJson)) {
            return new ArrayList<String>();
        }
        if (StringUtils.isEmpty((String)userBizAppsJson)) {
            Object[] results = UserAppCache.loadIntoCache(req);
            List resultList = (List)results[0];
            Integer remainExpireTime = (Integer)results[1];
            if (remainExpireTime == null) {
                UserAppCache.putCache(cacheKey, (List<String>)resultList, null);
            } else {
                UserAppCache.putCache(cacheKey, (List<String>)resultList, remainExpireTime);
            }
            return resultList;
        }
        return (List)SerializationUtils.fromJsonString((String)userBizAppsJson, List.class);
    }

    public static void removeCache(Long userId) {
        CacheMrg.clearCache(CacheMrg.getType4UserApp(), String.valueOf(userId));
    }

    public static void removeUserAppCache() {
        CacheMrg.clearCache(CacheMrg.getType4UserApp());
    }

    public static void removeCache(Long[] arrUserIds) {
        if (arrUserIds == null || arrUserIds.length == 0) {
            return;
        }
        String[] strUserId = new String[arrUserIds.length];
        for (int i = 0; i < arrUserIds.length; ++i) {
            strUserId[i] = String.valueOf(arrUserIds[i]);
        }
        CacheMrg.clearCache(CacheMrg.getType4UserApp(), strUserId);
    }

    public static void removeCache(List<Long> userIds) {
        Long[] arrUserIds = userIds.toArray(new Long[0]);
        UserAppCache.removeCache(arrUserIds);
    }

    @Deprecated
    public static Object[] loadIntoCache(Long pUserID) {
        return UserAppCache.loadIntoCache(new GetPermLevelHashReq(pUserID, null, null, true));
    }

    public static Object[] loadIntoCache(GetPermLevelHashReq req) {
        HashSet<String> bizAppIdSet = new HashSet<String>();
        Long pUserID = req.getUserId();
        if (pUserID.equals(10L)) {
            bizAppIdSet.add("0XWTKVOQW+ML");
            return new Object[]{new ArrayList(bizAppIdSet), null};
        }
        String adminType_superAdmin = "10";
        PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        boolean enableOldAdmin = PermCommonUtil.hasEnableOldAdmin();
        paramMap.put("enableOldAdmin", enableOldAdmin);
        String type4Admin = enableOldAdmin ? CacheMrg.getType4AdminUserOld() : CacheMrg.getType4AdminGroupUser();
        paramMap.put("type4Admin", type4Admin);
        String strAdminInfo = CacheMrg.getCache(type4Admin, String.valueOf(pUserID));
        paramMap.put("strAdminInfo", strAdminInfo);
        String type4HasEnableOldAdmin = CacheMrg.getType4HasEnableOldAdmin();
        paramMap.put("type4HasEnableOldAdmin", type4HasEnableOldAdmin);
        List<String> allUserAppIds = PermCommonUtil.getAllUserAppIds();
        paramMap.put(PARAMKEY_ALLUSERAPPIDS, allUserAppIds);
        boolean enableSysAuthority = PermCommonUtil.isEnableSysAuthority();
        List<String> allSysAppIds = AdminSchemeHelper.queryAllSysApp(false, false);
        boolean isAdminUser = permService.isAdminUserWithParaMap(pUserID.longValue(), "", paramMap);
        if (isAdminUser) {
            List<String> adminHasPermAppIds = AdminPermCache.getHasPermAppIds(pUserID, paramMap);
            bizAppIdSet.addAll(adminHasPermAppIds);
            if (permService.isAdminUserWithParaMap(pUserID.longValue(), adminType_superAdmin, paramMap) && !AdminUtil.isAllowAdminBizOperate()) {
                return new Object[]{new ArrayList(bizAppIdSet), null};
            }
        } else if (!enableSysAuthority && allSysAppIds != null && !allSysAppIds.isEmpty()) {
            allUserAppIds.removeAll(allSysAppIds);
        }
        if (SuperUserCache.isSuperUser(pUserID)) {
            List allAppIdSet = BizAppServiceHelp.getSysAppsId();
            if (!enableSysAuthority && allSysAppIds != null && !allSysAppIds.isEmpty()) {
                allAppIdSet.removeAll(allSysAppIds);
                if (isAdminUser) {
                    allAppIdSet.addAll(allUserAppIds);
                }
            }
            bizAppIdSet.addAll(allAppIdSet);
            Map map = GrayStrategy.getUserAppGroup((String)RequestContext.get().getUserId(), (String)RequestContext.get().getAccountId());
            ArrayList grayAppNums = new ArrayList();
            if (map != null && !map.isEmpty()) {
                grayAppNums.addAll(map.keySet());
            }
            for (String grayAppNum : grayAppNums) {
                AppInfo grayAppInfo = PermGrayHelper.findGrayAppInfoByNum(grayAppNum);
                if (grayAppInfo == null) continue;
                bizAppIdSet.add(grayAppInfo.getId());
            }
            return new Object[]{new ArrayList(bizAppIdSet), null};
        }
        bizAppIdSet.addAll(allUserAppIds);
        boolean justPermItem = req.isJustPermItem();
        if (justPermItem) {
            Map<String, Map<String, Set<String>>> curUserHasPermInfoMap = UserAppPermService.getAppPermWithOutOrg(pUserID);
            if (null != curUserHasPermInfoMap && !curUserHasPermInfoMap.isEmpty()) {
                Set<String> userBizApps = curUserHasPermInfoMap.keySet();
                bizAppIdSet.addAll(userBizApps);
            }
        } else {
            Set<String> userBizApps = UserAppPermService.getAppPermWithOutOrg(req);
            if (null != userBizApps && !userBizApps.isEmpty()) {
                bizAppIdSet.addAll(userBizApps);
            }
        }
        int remainExpireTime = UserAppPermService.getAppCacheExp(pUserID);
        if (remainExpireTime == 0) {
            return new Object[]{new ArrayList(bizAppIdSet), null};
        }
        return new Object[]{new ArrayList(bizAppIdSet), remainExpireTime};
    }

    public static void removeUserAppConfig(Long userId) {
        UserConfigServiceHelper.clearSetting((long)userId, (String)"appPersonalList");
    }
}

