/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.sql.ResultSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.BizRoleFunPermService;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.UserBizRoleCache;
import kd.bos.permission.cache.helper.DirectAuthorizeHelper;
import kd.bos.permission.cache.helper.DirectDisFunHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.perm.PermLevelHash;
import kd.bos.permission.model.perm.req.GetPermLevelHashReq;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UserAppPermService {
    private static Log log = LogFactory.getLog(UserAppPermService.class);
    public static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_UserAppPermService", (int)4);

    public static Map<String, Map<String, Set<String>>> getAppPermWithOutOrg(final long userId) {
        if (!PermCommonUtil.isEnableSingleBizRole()) {
            Callable<Map<String, Map<String, Set<String>>>> userDirectAssignPermCallable = new Callable<Map<String, Map<String, Set<String>>>>(){

                @Override
                public Map<String, Map<String, Set<String>>> call() throws Exception {
                    return DirectAuthorizeHelper.getUserDirectAssignPermWithOutOrg(userId);
                }
            };
            Future userDirectAssignPermFuture = pool.submit((Callable)userDirectAssignPermCallable, RequestContext.get());
            Callable<Map<String, Map<String, Set<String>>>> commRolePermCallable = new Callable<Map<String, Map<String, Set<String>>>>(){

                @Override
                public Map<String, Map<String, Set<String>>> call() throws Exception {
                    return UserAppPermService.getCommRoleAppPermWithOutOrg(userId);
                }
            };
            Future commRolePermFuture = pool.submit((Callable)commRolePermCallable, RequestContext.get());
            Set<Long> bizRoleIds = BizRoleFunPermService.getUserBizRoleIDs(userId);
            Map<String, Map<String, Set<String>>> bizRolePermMap = UserAppPermService.getBizRolePermWithOutOrg(userId, bizRoleIds);
            Map<String, Map<String, Set<String>>> returnPermMap = new HashMap<String, Map<String, Set<String>>>(64);
            try {
                Map userDirectAssianPermMap = (Map)userDirectAssignPermFuture.get();
                if (userDirectAssianPermMap != null && !userDirectAssianPermMap.isEmpty()) {
                    returnPermMap = userDirectAssianPermMap;
                }
                UserAppPermService.mergePerm(bizRolePermMap, returnPermMap);
                Map commRolePermMap = (Map)commRolePermFuture.get();
                UserAppPermService.mergePerm(commRolePermMap, returnPermMap);
                return returnPermMap;
            }
            catch (Exception e) {
                log.warn(Arrays.toString(e.getStackTrace()));
                return new HashMap<String, Map<String, Set<String>>>(64);
            }
        }
        HashSet<Long> bizRoleIds = new HashSet<Long>(1);
        String selBizRole = UserBizRoleCache.getSelBizRole(userId);
        if (StringUtils.isEmpty((String)selBizRole)) {
            return new HashMap<String, Map<String, Set<String>>>(64);
        }
        bizRoleIds.add(Long.valueOf(selBizRole));
        Map<String, Map<String, Set<String>>> bizRolePermMap = UserAppPermService.getBizRolePermWithOutOrg(userId, bizRoleIds);
        HashMap<String, Map<String, Set<String>>> returnPermMap = new HashMap<String, Map<String, Set<String>>>(64);
        UserAppPermService.mergePerm(bizRolePermMap, returnPermMap);
        return returnPermMap;
    }

    public static Set<String> getAppPermWithOutOrg(GetPermLevelHashReq req) {
        Map<String, Object> permLevelHashParaMap = UserAppPermService.getPermLevelHashParaMap(req);
        return UserAppPermService.merge2GetAppIdSet(permLevelHashParaMap);
    }

    private static Set<String> merge2GetAppIdSet(Map<String, Object> paraMap) {
        String key;
        Map oneFuncDimMap;
        boolean justPermItem;
        List addList = null == paraMap.get("addPermLevelHashList") ? null : (List)paraMap.get("addPermLevelHashList");
        List removeList = null == paraMap.get("removePermLevelHashList") ? null : (List)paraMap.get("removePermLevelHashList");
        GetPermLevelHashReq req = null == paraMap.get("getPermLevelHashReq") ? null : (GetPermLevelHashReq)paraMap.get("getPermLevelHashReq");
        boolean queriedHasIncludeSub = null == paraMap.get("queriedHasIncludeSub") ? false : (Boolean)paraMap.get("queriedHasIncludeSub");
        HashMap<String, Set> resultMap = new HashMap<String, Set>(8);
        boolean bl = justPermItem = req != null && req.isJustPermItem();
        if (null != addList && !addList.isEmpty()) {
            for (PermLevelHash one : addList) {
                if (null == one || null == one.getFuncDimMap() || one.getFuncDimMap().isEmpty()) continue;
                oneFuncDimMap = one.getFuncDimMap();
                for (Map.Entry oneFuncDim : oneFuncDimMap.entrySet()) {
                    key = (String)oneFuncDim.getKey();
                    if (justPermItem) {
                        resultMap.put(key, null);
                        continue;
                    }
                    if (queriedHasIncludeSub) {
                        resultMap.put(key, null);
                        continue;
                    }
                    Set value = (Set)oneFuncDim.getValue();
                    resultMap.computeIfAbsent(key, k -> new HashSet(8)).addAll(value);
                }
            }
        }
        if (!justPermItem && null != removeList && !removeList.isEmpty()) {
            for (PermLevelHash one : removeList) {
                if (null == one || null == one.getFuncDimMap() || one.getFuncDimMap().isEmpty()) continue;
                oneFuncDimMap = one.getFuncDimMap();
                for (Map.Entry oneFuncDim : oneFuncDimMap.entrySet()) {
                    key = (String)oneFuncDim.getKey();
                    if (justPermItem) {
                        resultMap.remove(key);
                        continue;
                    }
                    if (queriedHasIncludeSub) {
                        resultMap.remove(key);
                        continue;
                    }
                    Set vvSet = (Set)resultMap.get(key);
                    if (null == vvSet || vvSet.isEmpty()) continue;
                    vvSet.removeAll((Collection)oneFuncDim.getValue());
                    resultMap.put(key, vvSet);
                }
            }
        }
        if (null == resultMap || resultMap.isEmpty()) {
            return new HashSet<String>(8);
        }
        HashSet<String> appIdSet = new HashSet<String>(8);
        for (Map.Entry result : resultMap.entrySet()) {
            String[] split;
            String key2 = (String)result.getKey();
            if (StringUtils.isEmpty((String)key2) || null == (split = key2.split("@@")) || !Objects.equals(3, split.length)) continue;
            if (justPermItem) {
                appIdSet.add(split[0]);
                continue;
            }
            if (queriedHasIncludeSub) {
                appIdSet.add(split[0]);
                continue;
            }
            Set value = (Set)result.getValue();
            if (null == value || value.isEmpty() || appIdSet.contains(split[0])) continue;
            appIdSet.add(split[0]);
        }
        return appIdSet;
    }

    private static Map<String, Object> getPermLevelHashParaMap(final GetPermLevelHashReq req) {
        Set<Long> bizRoleIds;
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        ArrayList<PermLevelHash> addPermLevelHashList = new ArrayList<PermLevelHash>(8);
        ArrayList<PermLevelHash> removePermLevelHashList = new ArrayList<PermLevelHash>(8);
        paraMap.put("addPermLevelHashList", addPermLevelHashList);
        paraMap.put("removePermLevelHashList", removePermLevelHashList);
        paraMap.put("queriedHasIncludeSub", false);
        paraMap.put("getPermLevelHashReq", req);
        Long userId = req.getUserId();
        if (!PermCommonUtil.isEnableSingleBizRole()) {
            bizRoleIds = BizRoleFunPermService.getUserBizRoleIDs(userId);
            req.setBusiRoleIdSet(bizRoleIds);
        } else {
            bizRoleIds = new HashSet<Long>(8);
            String selBizRole = UserBizRoleCache.getSelBizRole(userId);
            if (StringUtils.isNotEmpty((String)selBizRole)) {
                bizRoleIds.add(Long.valueOf(selBizRole));
                req.setBusiRoleIdSet(bizRoleIds);
            }
        }
        Callable<PermLevelHash> busiRoleDisPermCallable = new Callable<PermLevelHash>(){

            @Override
            public PermLevelHash call() throws Exception {
                return PermBusiRoleHelper.getDisPermLevelHash(req);
            }
        };
        Future busiRoleDisPermFuture = pool.submit((Callable)busiRoleDisPermCallable, RequestContext.get());
        Callable<PermLevelHash> busiRoleCommRolePermLevelHashCallable = new Callable<PermLevelHash>(){

            @Override
            public PermLevelHash call() throws Exception {
                return PermBusiRoleHelper.getCommRolePermLevelHash(req);
            }
        };
        Future busiRoleCommRolePermLevelHashFuture = pool.submit((Callable)busiRoleCommRolePermLevelHashCallable, RequestContext.get());
        Callable<PermLevelHash> busiRoleBcPermLevelHashCallable = new Callable<PermLevelHash>(){

            @Override
            public PermLevelHash call() throws Exception {
                return PermBusiRoleHelper.getBcPermLevelHash(req);
            }
        };
        Future busiRoleBcPermLevelHashFuture = pool.submit((Callable)busiRoleBcPermLevelHashCallable, RequestContext.get());
        if (!PermCommonUtil.isEnableSingleBizRole()) {
            Callable<PermLevelHash> userDirectAssignPermCallable = new Callable<PermLevelHash>(){

                @Override
                public PermLevelHash call() throws Exception {
                    return DirectAuthorizeHelper.getPermLevelHash(req);
                }
            };
            Future userDirectAssignPermFuture = pool.submit((Callable)userDirectAssignPermCallable, RequestContext.get());
            Callable<PermLevelHash> userDirectDisPermCallable = new Callable<PermLevelHash>(){

                @Override
                public PermLevelHash call() throws Exception {
                    return DirectDisFunHelper.getPermLevelHash(req);
                }
            };
            Future userDirectDisPermFuture = pool.submit((Callable)userDirectDisPermCallable, RequestContext.get());
            Callable<PermLevelHash> commRolePermCallable = new Callable<PermLevelHash>(){

                @Override
                public PermLevelHash call() throws Exception {
                    return PermRoleHelper.getPermLevelHash(req);
                }
            };
            Future commRolePermFuture = pool.submit((Callable)commRolePermCallable, RequestContext.get());
            try {
                PermLevelHash busiRoleDisPermLevelHash;
                PermLevelHash userDisPermLevelHash;
                PermLevelHash busiRoleBcPermLevelHash;
                PermLevelHash busiRoleCommRolePermLevelHash;
                PermLevelHash commRolePermLevelHash;
                PermLevelHash userDirectPermLevelHash = (PermLevelHash)userDirectAssignPermFuture.get();
                if (null != userDirectPermLevelHash.getFuncDimMap() && !userDirectPermLevelHash.getFuncDimMap().isEmpty()) {
                    addPermLevelHashList.add(userDirectPermLevelHash);
                }
                if (null != (commRolePermLevelHash = (PermLevelHash)commRolePermFuture.get()).getFuncDimMap() && !commRolePermLevelHash.getFuncDimMap().isEmpty()) {
                    addPermLevelHashList.add(commRolePermLevelHash);
                }
                if (null != (busiRoleCommRolePermLevelHash = (PermLevelHash)busiRoleCommRolePermLevelHashFuture.get()).getFuncDimMap() && !busiRoleCommRolePermLevelHash.getFuncDimMap().isEmpty()) {
                    addPermLevelHashList.add(busiRoleCommRolePermLevelHash);
                }
                if (null != (busiRoleBcPermLevelHash = (PermLevelHash)busiRoleBcPermLevelHashFuture.get()).getFuncDimMap() && !busiRoleBcPermLevelHash.getFuncDimMap().isEmpty()) {
                    addPermLevelHashList.add(busiRoleBcPermLevelHash);
                }
                if (null != (userDisPermLevelHash = (PermLevelHash)userDirectDisPermFuture.get()).getFuncDimMap() && !userDisPermLevelHash.getFuncDimMap().isEmpty()) {
                    removePermLevelHashList.add(userDisPermLevelHash);
                }
                if (null != (busiRoleDisPermLevelHash = (PermLevelHash)busiRoleDisPermFuture.get()).getFuncDimMap() && !busiRoleDisPermLevelHash.getFuncDimMap().isEmpty()) {
                    removePermLevelHashList.add(busiRoleDisPermLevelHash);
                }
                boolean queriedHasIncludeSub = userDirectPermLevelHash.isHasIncludeSub() || commRolePermLevelHash.isHasIncludeSub() || busiRoleCommRolePermLevelHash.isHasIncludeSub() || busiRoleBcPermLevelHash.isHasIncludeSub() || userDisPermLevelHash.isHasIncludeSub() || busiRoleDisPermLevelHash.isHasIncludeSub();
                paraMap.put("addPermLevelHashList", addPermLevelHashList);
                paraMap.put("removePermLevelHashList", removePermLevelHashList);
                paraMap.put("queriedHasIncludeSub", queriedHasIncludeSub);
                return paraMap;
            }
            catch (Exception e) {
                log.warn("UserAppPermService.getPermLevelHashParaMap error", (Throwable)e);
                return paraMap;
            }
        }
        try {
            PermLevelHash busiRoleDisPermLevelHash;
            PermLevelHash busiRoleBcPermLevelHash;
            PermLevelHash busiRoleCommRolePermLevelHash = (PermLevelHash)busiRoleCommRolePermLevelHashFuture.get();
            if (null != busiRoleCommRolePermLevelHash.getFuncDimMap() && !busiRoleCommRolePermLevelHash.getFuncDimMap().isEmpty()) {
                addPermLevelHashList.add(busiRoleCommRolePermLevelHash);
            }
            if (null != (busiRoleBcPermLevelHash = (PermLevelHash)busiRoleBcPermLevelHashFuture.get()).getFuncDimMap() && !busiRoleBcPermLevelHash.getFuncDimMap().isEmpty()) {
                addPermLevelHashList.add(busiRoleBcPermLevelHash);
            }
            if (null != (busiRoleDisPermLevelHash = (PermLevelHash)busiRoleDisPermFuture.get()).getFuncDimMap() && !busiRoleDisPermLevelHash.getFuncDimMap().isEmpty()) {
                removePermLevelHashList.add(busiRoleDisPermLevelHash);
            }
            boolean queriedHasIncludeSub = busiRoleCommRolePermLevelHash.isHasIncludeSub() || busiRoleBcPermLevelHash.isHasIncludeSub() || busiRoleDisPermLevelHash.isHasIncludeSub();
            paraMap.put("addPermLevelHashList", addPermLevelHashList);
            paraMap.put("removePermLevelHashList", removePermLevelHashList);
            paraMap.put("queriedHasIncludeSub", queriedHasIncludeSub);
            return paraMap;
        }
        catch (Exception e) {
            log.warn("UserAppPermService.getPermLevelHashParaMap single busirole error", (Throwable)e);
            return paraMap;
        }
    }

    private static void removeDisFunPerm(Map<String, Map<String, Set<String>>> returnPermMap, Map<String, Map<String, Set<String>>> map) {
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        for (Map.Entry<String, Map<String, Set<String>>> disPermEntry : map.entrySet()) {
            String appId = disPermEntry.getKey();
            Map<String, Set<String>> returnEntNumPermItemMap = returnPermMap.get(appId);
            if (returnEntNumPermItemMap != null) {
                Map<String, Set<String>> entNumPermItemMap = disPermEntry.getValue();
                for (Map.Entry<String, Set<String>> disEntityEntry : entNumPermItemMap.entrySet()) {
                    Set<String> disPermItemSet = disEntityEntry.getValue();
                    Set<String> returnPermItemSet = returnEntNumPermItemMap.get(disEntityEntry.getKey());
                    if (returnPermItemSet != null && !returnPermItemSet.isEmpty()) {
                        returnPermItemSet.removeAll(disPermItemSet);
                    }
                    if (returnPermItemSet != null && !returnPermItemSet.isEmpty()) continue;
                    returnEntNumPermItemMap.remove(disEntityEntry.getKey());
                }
            }
            if (returnEntNumPermItemMap != null && !returnEntNumPermItemMap.isEmpty()) continue;
            returnPermMap.remove(appId);
        }
    }

    private static void mergePerm(Map<String, Map<String, Set<String>>> map, Map<String, Map<String, Set<String>>> returnPermMap) {
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        for (Map.Entry<String, Map<String, Set<String>>> entry : map.entrySet()) {
            String appId = entry.getKey();
            Map<String, Set<String>> entNumPermItemMap = entry.getValue();
            Map<String, Set<String>> returnEntNumPermItemMap = returnPermMap.get(appId);
            if (returnEntNumPermItemMap == null) {
                returnPermMap.put(appId, entNumPermItemMap);
                continue;
            }
            entNumPermItemMap.forEach((entityNum, permItemList) -> returnEntNumPermItemMap.merge((String)entityNum, (Set<String>)permItemList, (returnPermItemList, permItemList2) -> {
                returnPermItemList.addAll(permItemList2);
                return returnPermItemList;
            }));
        }
    }

    @Deprecated
    public static Map<String, Map<String, Set<String>>> getCommRoleAppPermWithOutOrg(long userId) {
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getRoleIdSet");
        commParam.put("userId", userId);
        commParam.put("enable", "1");
        commParam.put("selectTPermRole", "1");
        commParam.put("selectTSecUserGroupStaff", "1");
        Map<String, Object> curOrgDimCommMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (CollectionUtils.isEmpty(curOrgDimCommMap)) {
            return new HashMap<String, Map<String, Set<String>>>(1);
        }
        Set commRoleIds = (Set)curOrgDimCommMap.get("roleIdSet");
        if (CollectionUtils.isEmpty((Collection)commRoleIds)) {
            return new HashMap<String, Map<String, Set<String>>>(1);
        }
        if (commRoleIds == null || commRoleIds.isEmpty()) {
            return new HashMap<String, Map<String, Set<String>>>();
        }
        ArrayList commRoleIdList = new ArrayList();
        commRoleIdList.addAll(commRoleIds);
        StringBuilder sqlSB = new StringBuilder("SELECT DISTINCT RPD.FBIZAPPID,RPD.FENTITYTYPEID,RPD.FPERMITEMID ");
        sqlSB.append(" FROM T_PERM_ROLEPERMDETIAL RPD ");
        sqlSB.append(" WHERE RPD.FROLEID IN (");
        for (int i = 0; i < commRoleIdList.size(); ++i) {
            sqlSB.append('\'').append((String)commRoleIdList.get(i)).append("',");
        }
        sqlSB.deleteCharAt(sqlSB.length() - 1);
        sqlSB.append(" )");
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Set<String>>>>(){

            public Map<String, Map<String, Set<String>>> handle(ResultSet rs) throws Exception {
                HashMap<String, Map<String, Set<String>>> map = new HashMap<String, Map<String, Set<String>>>(32);
                while (rs.next()) {
                    String appId = rs.getString("FBIZAPPID");
                    String entNum = rs.getString("FENTITYTYPEID");
                    String permItemID = rs.getString("FPERMITEMID");
                    if (!StringUtils.isNotEmpty((String)appId) || !StringUtils.isNotEmpty((String)entNum) || !StringUtils.isNotEmpty((String)permItemID)) continue;
                    map.computeIfAbsent(appId, k -> new HashMap(32)).computeIfAbsent(entNum, k -> new HashSet(16)).add(permItemID);
                }
                return map;
            }
        });
    }

    @Deprecated
    public static Map<String, Map<String, Set<String>>> getBizRolePermWithOutOrg(long userId, Set<Long> bizRoleIds) {
        return UserAppPermService.getBizRolePermWithOutOrg(new GetPermLevelHashReq(Long.valueOf(userId), null, bizRoleIds, true));
    }

    @Deprecated
    public static Map<String, Map<String, Set<String>>> getBizRolePermWithOutOrg(GetPermLevelHashReq req) {
        Map bizCommRolePermMap;
        final Set bizRoleIds = req.getBusiRoleIdSet();
        if (bizRoleIds == null || bizRoleIds.isEmpty()) {
            return new HashMap<String, Map<String, Set<String>>>();
        }
        Callable<Map<String, Map<String, Set<String>>>> bizRoleDirectAssignPermCallable = new Callable<Map<String, Map<String, Set<String>>>>(){

            @Override
            public Map<String, Map<String, Set<String>>> call() throws Exception {
                return UserAppPermService.getBizRoleDirectAssignPermPermWithOutOrg(bizRoleIds);
            }
        };
        Future bizRoleDirectAssignPermFuture = pool.submit((Callable)bizRoleDirectAssignPermCallable, RequestContext.get());
        Map returnPermMap = bizCommRolePermMap = UserAppPermService.getBizRoleCommRolePermWithOutOrg(bizRoleIds);
        try {
            Map bizRoleDirectAssignPerm = (Map)bizRoleDirectAssignPermFuture.get();
            if (returnPermMap == null || returnPermMap.isEmpty()) {
                returnPermMap = bizRoleDirectAssignPerm;
            } else {
                UserAppPermService.mergePerm(bizRoleDirectAssignPerm, returnPermMap);
            }
        }
        catch (Exception e) {
            log.warn(Arrays.toString(e.getStackTrace()));
        }
        return returnPermMap;
    }

    private static Map<String, Map<String, Set<String>>> getBizRoleDisPermPermWithOutOrg(Set<Long> bizRoleIds) {
        if (bizRoleIds == null || bizRoleIds.isEmpty()) {
            return new HashMap<String, Map<String, Set<String>>>(8);
        }
        ArrayList<Long> bizRoleIdList = new ArrayList<Long>();
        bizRoleIdList.addAll(bizRoleIds);
        StringBuilder sqlSB = new StringBuilder("SELECT DISTINCT PBDP.FBIZAPPID,PBDP.FENTITYTYPEID,PBDP.FPERMITEMID FROM T_PERM_BIZROLEDISPERM PBDP ");
        sqlSB.append(" WHERE PBDP.FID IN (");
        for (int i = 0; i < bizRoleIdList.size(); ++i) {
            sqlSB.append('\'').append(bizRoleIdList.get(i)).append("',");
        }
        sqlSB.deleteCharAt(sqlSB.length() - 1);
        sqlSB.append(" )");
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Set<String>>>>(){

            public Map<String, Map<String, Set<String>>> handle(ResultSet rs) throws Exception {
                HashMap<String, Map<String, Set<String>>> disPermMap = new HashMap<String, Map<String, Set<String>>>(64);
                while (rs.next()) {
                    String appId = rs.getString("FBIZAPPID");
                    String entNum = rs.getString("FENTITYTYPEID");
                    String permItemID = rs.getString("FPERMITEMID");
                    if (!StringUtils.isNotEmpty((String)appId) || !StringUtils.isNotEmpty((String)entNum) || !StringUtils.isNotEmpty((String)permItemID)) continue;
                    disPermMap.computeIfAbsent(appId, k -> new HashMap(64)).computeIfAbsent(entNum, k -> new HashSet(10)).add(permItemID);
                }
                return disPermMap;
            }
        });
    }

    @Deprecated
    private static Map<String, Map<String, Set<String>>> getBizRoleDirectAssignPermPermWithOutOrg(Set<Long> bizRoleIds) {
        if (bizRoleIds == null || bizRoleIds.isEmpty()) {
            return new HashMap<String, Map<String, Set<String>>>(8);
        }
        ArrayList<Long> bizRoleIdList = new ArrayList<Long>();
        bizRoleIdList.addAll(bizRoleIds);
        StringBuilder sqlSB = new StringBuilder("SELECT PBP.FBIZAPPID, PBP.FENTITYTYPEID, PBP.FPERMITEMID FROM T_PERM_BIZROLEPERM PBP ");
        sqlSB.append(" WHERE  PBP.FID IN (");
        for (int i = 0; i < bizRoleIdList.size(); ++i) {
            sqlSB.append('\'').append(bizRoleIdList.get(i)).append("',");
        }
        sqlSB.deleteCharAt(sqlSB.length() - 1);
        sqlSB.append(" )");
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Set<String>>>>(){

            public Map<String, Map<String, Set<String>>> handle(ResultSet rs) throws Exception {
                HashMap<String, Map<String, Set<String>>> disPermMap = new HashMap<String, Map<String, Set<String>>>(32);
                while (rs.next()) {
                    String appId = rs.getString("FBIZAPPID");
                    String entNum = rs.getString("FENTITYTYPEID");
                    String permItemID = rs.getString("FPERMITEMID");
                    if (!StringUtils.isNotEmpty((String)appId) || !StringUtils.isNotEmpty((String)entNum) || !StringUtils.isNotEmpty((String)permItemID)) continue;
                    disPermMap.computeIfAbsent(appId, k -> new HashMap(64)).computeIfAbsent(entNum, k -> new HashSet(10)).add(permItemID);
                }
                return disPermMap;
            }
        });
    }

    @Deprecated
    private static Map<String, Map<String, Set<String>>> getBizRoleCommRolePermWithOutOrg(Set<Long> bizRoleIds) {
        if (bizRoleIds == null || bizRoleIds.isEmpty()) {
            return new HashMap<String, Map<String, Set<String>>>(8);
        }
        ArrayList<Long> bizRoleIdList = new ArrayList<Long>();
        bizRoleIdList.addAll(bizRoleIds);
        StringBuilder sqlSB = new StringBuilder("SELECT DISTINCT PBC.FROLEID ROLEID FROM T_PERM_ROLE PR INNER JOIN T_PERM_BIZROLECOMROLE PBC ON PR.FID=PBC.FROLEID");
        sqlSB.append(" WHERE PR.FENABLE='1' ");
        sqlSB.append(" AND  PBC.FID IN (");
        for (int i = 0; i < bizRoleIdList.size(); ++i) {
            sqlSB.append('\'').append(bizRoleIdList.get(i)).append("',");
        }
        sqlSB.deleteCharAt(sqlSB.length() - 1);
        sqlSB.append(" )");
        List commonRoleIds = (List)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> commonRoleId = new ArrayList<String>(50);
                while (rs.next()) {
                    String roleId = rs.getString("ROLEID");
                    if (roleId == null) continue;
                    commonRoleId.add(roleId);
                }
                return commonRoleId;
            }
        });
        if (commonRoleIds == null || commonRoleIds.isEmpty()) {
            return new HashMap<String, Map<String, Set<String>>>(8);
        }
        sqlSB = new StringBuilder("SELECT DISTINCT RPD.FBIZAPPID,RPD.FENTITYTYPEID,RPD.FPERMITEMID ");
        sqlSB.append(" FROM T_PERM_ROLEPERMDETIAL RPD ");
        sqlSB.append(" WHERE  RPD.FROLEID IN (");
        for (int i = 0; i < commonRoleIds.size(); ++i) {
            sqlSB.append('\'').append((String)commonRoleIds.get(i)).append("',");
        }
        sqlSB.deleteCharAt(sqlSB.length() - 1);
        sqlSB.append(" )");
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Set<String>>>>(){

            public Map<String, Map<String, Set<String>>> handle(ResultSet rs) throws Exception {
                HashMap<String, Map<String, Set<String>>> map = new HashMap<String, Map<String, Set<String>>>(32);
                while (rs.next()) {
                    String appId = rs.getString("FBIZAPPID");
                    String entNum = rs.getString("FENTITYTYPEID");
                    String permItemID = rs.getString("FPERMITEMID");
                    if (!StringUtils.isNotEmpty((String)appId) || !StringUtils.isNotEmpty((String)entNum) || !StringUtils.isNotEmpty((String)permItemID)) continue;
                    map.computeIfAbsent(appId, k -> new HashMap(64)).computeIfAbsent(entNum, k -> new HashSet(10)).add(permItemID);
                }
                return map;
            }
        });
    }

    @Deprecated
    public static Map<String, Map<String, Set<String>>> getUserDirectAssignPermWithOutOrg(long userId) {
        return DirectAuthorizeHelper.getUserDirectAssignPermWithOutOrg(userId);
    }

    @Deprecated
    public static Map<String, Map<String, Set<String>>> getUserDisPermWithOutOrg(long userId) {
        StringBuilder sqlSB = new StringBuilder().append("SELECT DISTINCT DFP.FBIZAPPID DFP_APPID, DFP.FENTITYTYPEID DFP_ENTNUM, DFP.FPERMITEMID DFP_PERMITEMID").append(" FROM T_PERM_DISFUNPERM DFP").append(" WHERE DFP.FUSERID = ? ");
        Object[] params = new Object[]{userId};
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Set<String>>>>(){

            public Map<String, Map<String, Set<String>>> handle(ResultSet rs) throws Exception {
                HashMap<String, Map<String, Set<String>>> map = new HashMap<String, Map<String, Set<String>>>(32);
                while (rs.next()) {
                    String appId = rs.getString("DFP_APPID");
                    String entNum = rs.getString("DFP_ENTNUM");
                    String permItemID = rs.getString("DFP_PERMITEMID");
                    if (!StringUtils.isNotEmpty((String)appId) || !StringUtils.isNotEmpty((String)entNum) || !StringUtils.isNotEmpty((String)permItemID)) continue;
                    map.computeIfAbsent(appId, k -> new HashMap(64)).computeIfAbsent(entNum, k -> new HashSet(10)).add(permItemID);
                }
                return map;
            }
        });
    }

    public static int getAppCacheExp(long userId) {
        if (!PermCommonUtil.isEnableValidateTime()) {
            return 0;
        }
        String bizMinStartSql = "SELECT MIN(PUB.FSTARTTIME) MIN_STARTTIME FROM T_PERM_USERBIZROLE PUB WHERE PUB.FUSERID=? AND NOW() < PUB.FSTARTTIME";
        Object[] params = new Object[]{userId};
        Date bizMinStartDate = null;
        Date bizMinEndDate = null;
        Date commRoleMinStartDate = null;
        Date commRoleMinEndDate = null;
        try {
            bizMinStartDate = (Date)DB.query((DBRoute)DBRoute.permission, (String)bizMinStartSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Date>(){

                public Date handle(ResultSet rs) throws Exception {
                    Date minStartTime = null;
                    while (rs.next()) {
                        String MIN_STARTTIME = rs.getString("MIN_STARTTIME");
                        minStartTime = StringUtils.isEmpty((String)MIN_STARTTIME) ? null : DateUtil.toDate(MIN_STARTTIME.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                    }
                    return minStartTime;
                }
            });
            String bizMinEndTimeSql = "SELECT MIN(PUB.FENDTIME) MIN_ENDTIME FROM T_PERM_USERBIZROLE PUB WHERE PUB.FUSERID=? AND NOW() < PUB.FENDTIME";
            bizMinEndDate = (Date)DB.query((DBRoute)DBRoute.permission, (String)bizMinEndTimeSql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Date>(){

                public Date handle(ResultSet rs) throws Exception {
                    Date minEndDate = null;
                    while (rs.next()) {
                        String MIN_ENDTIME = rs.getString("MIN_ENDTIME");
                        minEndDate = StringUtils.isEmpty((String)MIN_ENDTIME) ? null : DateUtil.toDate(MIN_ENDTIME.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                    }
                    return minEndDate;
                }
            });
            commRoleMinStartDate = UserHelper.getCommRoleMinStartTimeByUserId(userId, null, null, null);
            commRoleMinEndDate = UserHelper.getCommRoleMinEndTimeByUserId(userId, null, null, null);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        List<Date> dateList = Arrays.asList(bizMinStartDate, bizMinEndDate, commRoleMinStartDate, commRoleMinEndDate);
        Optional<Date> minDate = dateList.stream().filter(x -> x != null).min((o1, o2) -> o1.compareTo((Date)o2));
        Integer expTime = CacheMrg.getExpireTime();
        if (minDate.isPresent()) {
            Long expLongTime = minDate.get().getTime() - Instant.now().toEpochMilli();
            Integer expIntTime = (expLongTime = Long.valueOf(expLongTime / 1000L)).intValue();
            if (expIntTime <= 0) {
                expTime = 1;
            } else if (expIntTime > 0 && expIntTime < CacheMrg.getExpireTime()) {
                expTime = expIntTime;
            }
        }
        return expTime;
    }
}

