/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.BizRoleFunPermService;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UserBizRoleCache {
    private static final String PERM_USERDEFBIZROLE_ENTITY = "perm_userdefbizrole";
    private static final String BIZROLE = "bizrole";

    public static void setSelBizRole(Long pUserId, Long pBizRoleId) {
        if (pUserId == null || pUserId == 0L || pBizRoleId == null) {
            return;
        }
        String cacheType = CacheMrg.getType4UserBizRoleSel();
        CacheMrg.putCache(cacheType, pUserId.toString(), pBizRoleId.toString());
    }

    public static String getSelBizRole(Long pUserId) {
        if (pUserId == null || pUserId == 0L) {
            return "";
        }
        String cacheType = CacheMrg.getType4UserBizRoleSel();
        String cache = CacheMrg.getCache(cacheType, pUserId.toString());
        if (!StringUtils.isEmpty((String)cache)) {
            if ("PERM_DATA_LOADED".equals(cache)) {
                return "";
            }
            if (UserBizRoleCache.bizRoleStillAssign(pUserId, Long.valueOf(cache))) {
                return cache;
            }
        }
        if (StringUtils.isNotEmpty((String)(cache = UserBizRoleCache.getDefSelBizRole(pUserId)))) {
            CacheMrg.putCache(cacheType, pUserId.toString(), cache);
        } else {
            CacheMrg.putCache(cacheType, pUserId.toString(), "PERM_DATA_LOADED");
        }
        return cache;
    }

    public static void setUserDefBizRole(Long pUserId, Long pBizRoleId) {
        if (pUserId == null || pUserId == 0L || pBizRoleId == null) {
            return;
        }
        String cacheType = CacheMrg.getType4UserBizRoleDef();
        CacheMrg.putCache(cacheType, pUserId.toString(), pBizRoleId.toString());
        QFilter[] qFilters = new QFilter[]{new QFilter("user", "=", (Object)pUserId)};
        DeleteServiceHelper.delete((String)PERM_USERDEFBIZROLE_ENTITY, (QFilter[])qFilters);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)PERM_USERDEFBIZROLE_ENTITY);
        dynamicObject.set("user", (Object)pUserId);
        dynamicObject.set(BIZROLE, (Object)pBizRoleId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private static boolean bizRoleStillAssign(Long pUserId, Long pBizRoleId) {
        QFilter userFilter = new QFilter("user", "=", (Object)pUserId);
        QFilter bizRoleFilter = new QFilter(BIZROLE, "=", (Object)pBizRoleId);
        QFilter enableFilter = new QFilter("bizrole.enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{userFilter, bizRoleFilter, enableFilter};
        boolean userHasBizrole = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_userbizrole", (QFilter[])filters) != null;
        Set<Long> userUsrGrpBizRoleIDs = BizRoleFunPermService.getUserUsrGrpBizRoleIDs(pUserId);
        return userHasBizrole || userUsrGrpBizRoleIDs.contains(pBizRoleId);
    }

    public static String getDefSelBizRole(Long pUserId) {
        String defBizRole;
        if (pUserId == null || pUserId == 0L) {
            return "";
        }
        String cacheType = CacheMrg.getType4UserBizRoleDef();
        String cache = CacheMrg.getCache(cacheType, pUserId.toString());
        if (!StringUtils.isEmpty((String)cache)) {
            if (UserBizRoleCache.bizRoleStillAssign(pUserId, Long.valueOf(cache))) {
                return cache;
            }
            UserBizRoleCache.setSelBizRole(pUserId, null);
            UserBizRoleCache.setUserDefBizRole(pUserId, null);
            QFilter userFilter = new QFilter("user", "=", (Object)pUserId);
            QFilter bizRoleFilter = new QFilter(BIZROLE, "=", (Object)Long.valueOf(cache));
            QFilter[] qFilters = new QFilter[]{userFilter, bizRoleFilter};
            DeleteServiceHelper.delete((String)PERM_USERDEFBIZROLE_ENTITY, (QFilter[])qFilters);
        }
        if (!(defBizRole = UserBizRoleCache.getDefBizRoleFromDB(pUserId)).equals("") && UserBizRoleCache.bizRoleStillAssign(pUserId, Long.valueOf(defBizRole))) {
            UserBizRoleCache.setUserDefBizRole(pUserId, Long.valueOf(defBizRole));
            return defBizRole;
        }
        List<Long> userBizRoleIds = UserBizRoleCache.getUserBizRoles(pUserId);
        if (CollectionUtils.isEmpty(userBizRoleIds)) {
            return "";
        }
        String defBizRoleId = userBizRoleIds.get(0).toString();
        return defBizRoleId;
    }

    public static List<Long> getUserBizRoles(Long pUserId) {
        return new LinkedList<Long>(BizRoleFunPermService.getUserBizRoleIDs(pUserId));
    }

    private static String getDefBizRoleFromDB(Long pUserId) {
        QFilter[] filters = new QFilter[]{new QFilter("user", "=", (Object)pUserId)};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)PERM_USERDEFBIZROLE_ENTITY, (QFilter[])filters);
        if (dynamicObject != null) {
            Long bizRoleId = (Long)dynamicObject.get("bizrole.id");
            return bizRoleId.toString();
        }
        return "";
    }
}

