/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.helper.DirectAuthorizeHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UserDirectFunPermService {
    private static Log log = LogFactory.getLog(UserDirectFunPermService.class);

    @Deprecated
    public static int cacheCheckPermissionWithOrg(long userId, long orgId, String appId, String entityNum, String permItemId) {
        return UserDirectFunPermService.cacheCheckPermissionWithOrg(userId, orgId, "15", appId, entityNum, permItemId);
    }

    public static int cacheCheckPermissionWithOrg(long userId, long orgId, String orgView, String appId, String entityNum, String permItemId) {
        CharSequence[] keyArr = new String[]{"cacheCheckPermissionWithOrg", userId + "", orgId + "", orgView, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4UserDirectFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = DirectAuthorizeHelper.checkPermissionWithOrg(userId, orgId, orgView, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4UserDirectFunPermService(), key, hasPermission + "");
        return hasPermission;
    }

    @Deprecated
    private static int checkPermissionWithOrg(long userId, long orgId, String orgView, String appId, String entityNum, String permItemId) {
        return DirectAuthorizeHelper.checkPermissionWithOrg(userId, orgId, orgView, appId, entityNum, permItemId);
    }

    public static int cacheCheckPermissionWithOutOrg(long userId, String appId, String entityNum, String permItemId) {
        CharSequence[] keyarr = new String[]{"cacheCheckPermissionWithOutOrg", userId + "", appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyarr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4UserDirectFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = DirectAuthorizeHelper.checkPermissionWithOutOrg(userId, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4UserDirectFunPermService(), key, hasPermission + "");
        return hasPermission;
    }

    @Deprecated
    private static int checkPermissionWithOutOrg(long userId, String appId, String entityNum, String permItemId) {
        return DirectAuthorizeHelper.checkPermissionWithOutOrg(userId, appId, entityNum, permItemId);
    }

    public static int cacheCheckPermissionWithDim(long userId, long dimId, String dimType, String appId, String entityNum, String permItemId) {
        CharSequence[] keyArr = new String[]{"cacheCheckPermissionWithDim", userId + "", dimId + "", dimType, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4UserDirectFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = DirectAuthorizeHelper.checkPermissionWithDim(userId, dimId, dimType, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4UserDirectFunPermService(), key, hasPermission + "");
        return hasPermission;
    }

    @Deprecated
    private static int checkPermissionWithDim(long userId, long dimId, String dimType, String appId, String entityNum, String permItemId) {
        return DirectAuthorizeHelper.checkPermissionWithDim(userId, dimId, dimType, appId, entityNum, permItemId);
    }

    @Deprecated
    public static int cacheCheckDisPermWithOrg(long userId, long orgId, String appId, String entityNum, String permItemId) {
        return UserDirectFunPermService.cacheCheckDisPermWithOrg(userId, orgId, "15", appId, entityNum, permItemId);
    }

    public static int cacheCheckDisPermWithOrg(long userId, long orgId, String orgView, String appId, String entityNum, String permItemId) {
        CharSequence[] keyArr = new String[]{"cacheCheckDisPermWithOrg", userId + "", orgId + "", orgView, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4UserDirectFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = UserDirectFunPermService.checkDisPermWithOrg(userId, orgId, orgView, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4UserDirectFunPermService(), key, hasPermission + "");
        return hasPermission;
    }

    private static int checkDisPermWithOrg(long userId, long orgId, final String orgView, String appId, String entityNum, String permItemId) {
        String sql = "select forgid from t_perm_disfunperm dp where fuserid=? and forgid= ? and fdimtype='bos_org' and fbizappid= ? and fentitytypeid= ? and fpermitemid=?";
        Object[] params = new Object[]{userId, orgId, appId, entityNum, permItemId};
        Integer permRecord = (Integer)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                ArrayList<Long> orgIds = new ArrayList<Long>(10);
                while (rs.next()) {
                    orgIds.add(rs.getLong("forgid"));
                }
                List filterOrg = OrgUnitServiceHelper.filterOrgDuty(orgIds, (String)orgView);
                return filterOrg.size();
            }
        });
        if (permRecord > 0) {
            return 1;
        }
        List superOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgView, (long)orgId);
        if (superOrgIds == null || superOrgIds.isEmpty()) {
            return 0;
        }
        StringBuilder supsqlSB = new StringBuilder().append(" select count(dp.fid) record from t_perm_disfunperm dp ").append(" where dp.fuserid=? and dp.fdimtype='bos_org' and dp.fbizappid= ? and dp.fentitytypeid= ? and dp.fpermitemid=? and dp.fisincludesuborg='1'");
        supsqlSB.append(" and (dp.forgid=").append(superOrgIds.get(0));
        for (int i = 1; i < superOrgIds.size(); ++i) {
            supsqlSB.append(" or dp.forgid=").append(superOrgIds.get(i));
        }
        supsqlSB.append(')');
        Object[] supParams = new Object[]{userId, appId, entityNum, permItemId};
        permRecord = (Integer)DB.query((DBRoute)DBRoute.permission, (String)supsqlSB.toString(), (Object[])supParams, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                int record = 0;
                while (rs.next()) {
                    record = rs.getInt("record");
                }
                return record;
            }
        });
        if (permRecord > 0) {
            return 1;
        }
        return 0;
    }

    public static int cacheCheckDisPermWithOutOrg(long userId, String appId, String entityNum, String permItemId) {
        CharSequence[] keyarr = new String[]{"cacheCheckDisPermWithOutOrg", userId + "", appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyarr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4UserDirectFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = UserDirectFunPermService.checkDisPermWithOutOrg(userId, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4UserDirectFunPermService(), key, hasPermission + "");
        return hasPermission;
    }

    private static int checkDisPermWithOutOrg(long userId, String appId, String entityNum, String permItemId) {
        String sql = "select count(dp.fid) record from t_perm_disfunperm dp where dp.fuserid=? and dp.fbizappid= ? and dp.fentitytypeid= ? and dp.fpermitemid=?";
        Object[] params = new Object[]{userId, appId, entityNum, permItemId};
        Long permRecord = (Long)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                Long record = 0L;
                while (rs.next()) {
                    record = rs.getLong("record");
                }
                return record;
            }
        });
        if (permRecord > 0L) {
            return 1;
        }
        return 0;
    }

    public static int cacheCheckDisPermWithDim(long userId, long dimId, String dimType, String appId, String entityNum, String permItemId) {
        CharSequence[] keyArr = new String[]{"cacheCheckDisPermWithDim", userId + "", dimId + "", dimType, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4UserDirectFunPermService(), key);
        if (cacheValue != null) {
            return Integer.parseInt(cacheValue);
        }
        int hasPermission = UserDirectFunPermService.checkDisPermWithDim(userId, dimId, dimType, appId, entityNum, permItemId);
        CacheMrg.putCache(CacheMrg.getType4UserDirectFunPermService(), key, hasPermission + "");
        return hasPermission;
    }

    private static int checkDisPermWithDim(long userId, long dimId, String dimType, String appId, String entityNum, String permItemId) {
        dimType = PermCommonUtil.getSuitableDimType(dimType)[1];
        String sql = "SELECT COUNT(DP.FID) RECORD FROM T_PERM_DISFUNPERM DP WHERE DP.FUSERID=? and DP.FORGID= ? and DP.FDIMTYPE=? and DP.FBIZAPPID= ? and DP.FENTITYTYPEID= ? and DP.FPERMITEMID=?";
        Object[] params = new Object[]{userId, dimId, dimType, appId, entityNum, permItemId};
        Long permRecord = (Long)DB.query((DBRoute)DBRoute.permission, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                Long record = 0L;
                while (rs.next()) {
                    record = rs.getLong("RECORD");
                }
                return record;
            }
        });
        if (permRecord > 0L) {
            return 1;
        }
        return 0;
    }

    @Deprecated
    public static Set<String> hasPermMenuList(Long userID, List<Object[]> menuAppEntityPermList) {
        return DirectAuthorizeHelper.hasPermMenuList(userID, menuAppEntityPermList);
    }

    public static Set<String> hasDisPermMenuList(Long userID, List<Object[]> menuAppEntityPermList) {
        if (menuAppEntityPermList == null || menuAppEntityPermList.isEmpty()) {
            return new HashSet<String>(16);
        }
        StringBuilder sqlSB = new StringBuilder().append("SELECT CONCAT(CONCAT(DP.FBIZAPPID,DP.FENTITYTYPEID),DP.FPERMITEMID) as result ").append(" FROM T_PERM_DISFUNPERM DP WHERE DP.FUSERID=").append(userID);
        Set appEntityPermSet = (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> appEntityPermSet = new HashSet<String>(16);
                while (rs.next()) {
                    String result = rs.getString("result");
                    appEntityPermSet.add(result);
                }
                return appEntityPermSet;
            }
        });
        HashSet<String> menuIdSet = new HashSet<String>();
        if (!appEntityPermSet.isEmpty()) {
            for (Object[] objects : menuAppEntityPermList) {
                String app = String.valueOf(objects[1]);
                String entity = String.valueOf(objects[2]);
                String permItem = String.valueOf(objects[3]);
                if (!appEntityPermSet.contains(app + entity + permItem)) continue;
                menuIdSet.add(String.valueOf(objects[0]));
            }
        }
        return menuIdSet;
    }

    public static Set<String> getUserDisAppEntPermItemStrSet(Long userId) {
        if (null == userId || 0L == userId) {
            return Collections.EMPTY_SET;
        }
        StringBuilder sqlSB = new StringBuilder();
        sqlSB.append("select CONCAT(CONCAT(dp.fbizappid,dp.fentitytypeid),dp.fpermitemid) as result from t_perm_disfunperm dp where dp.fuserid=").append(userId);
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> appEntityPermSet = new HashSet<String>(16);
                while (rs.next()) {
                    String result = rs.getString("result");
                    appEntityPermSet.add(result);
                }
                return appEntityPermSet;
            }
        });
    }

    @Deprecated
    public static Map<Long, String> cacheGetHasPermDimObj(long userId, String dimType, String appId, String entityNum, String permItemId) {
        return DirectAuthorizeHelper.cacheGetHasPermDimObj(userId, dimType, appId, entityNum, permItemId);
    }

    public static Map<Long, String> cacheGetDisPermDimObj(long userId, String dimType, String appId, String entityNum, String permItemId) {
        Map<Long, String> userDisPermOrgs = new HashMap<Long, String>(16);
        List<String> orgInfos = new ArrayList(10);
        CharSequence[] keyArr = new String[]{"cacheGetDisPermDimObj", userId + "", dimType, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4UserDirectFunPermService(), key);
        if (cacheValue != null) {
            orgInfos = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            if (orgInfos != null) {
                for (String orgInfo : orgInfos) {
                    String[] arr = orgInfo.split("_");
                    userDisPermOrgs.put(Long.valueOf(arr[0]), arr[1]);
                }
            }
            return userDisPermOrgs;
        }
        String userDisPermSql = " SELECT DP.FORGID, DP.FISINCLUDESUBORG FROM T_PERM_DISFUNPERM DP  WHERE DP.FUSERID = ? AND DP.FDIMTYPE = ? AND DP.FBIZAPPID = ? AND DP.FENTITYTYPEID = ? AND DP.FPERMITEMID = ? ";
        Object[] userDisPermParams = new Object[]{userId, dimType, appId, entityNum, permItemId};
        userDisPermOrgs = (Map)DB.query((DBRoute)DBRoute.permission, (String)userDisPermSql, (Object[])userDisPermParams, (ResultSetHandler)new ResultSetHandler<Map<Long, String>>(){

            public Map<Long, String> handle(ResultSet rs) throws Exception {
                HashMap<Long, String> disPermOrg = new HashMap<Long, String>(16);
                while (rs.next()) {
                    disPermOrg.put(rs.getLong("FORGID"), rs.getString("FISINCLUDESUBORG"));
                }
                return disPermOrg;
            }
        });
        for (Map.Entry<Long, String> entry : userDisPermOrgs.entrySet()) {
            orgInfos.add(entry.getKey() + "_" + entry.getValue());
        }
        CacheMrg.putCache(CacheMrg.getType4UserDirectFunPermService(), key, SerializationUtils.toJsonString(orgInfos));
        return userDisPermOrgs;
    }
}

