/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.permission.api.HasPermDimObjResultImpl;
import kd.bos.permission.cache.BizRoleFunPermService;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.SuperUserCache;
import kd.bos.permission.cache.UserAppPermService;
import kd.bos.permission.cache.UserBizRoleCache;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.DirectAuthorizeHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UserHasPermDimObjCache {
    private static final Log log = LogFactory.getLog(UserHasPermDimObjCache.class);

    public static void putCache(String key, Map<String, String> hasPermDimObjsMap) {
        UserHasPermDimObjCache.putCache(key, hasPermDimObjsMap, CacheMrg.getExpireTime());
    }

    public static void putCache(String key, Map<String, String> hasPermDimObjsMap, Integer expireTime) {
        CacheMrg.putCache(CacheMrg.getHasPermDimObjs(), String.valueOf(key), SerializationUtils.toJsonString(hasPermDimObjsMap), expireTime);
    }

    @Deprecated
    public static Map<String, String> getCache(Long userId, String dimType, String appId, String entityNum, String permItemId) {
        return UserHasPermDimObjCache.getCache(userId, dimType, "15", appId, entityNum, permItemId);
    }

    public static Map<String, String> getCache(Long userId, String dimType, String orgView, String appId, String entityNum, String permItemId) {
        Map hasPermDimObjsMap;
        String hasPermMapStr = CacheMrg.getCache(CacheMrg.getHasPermDimObjs(), String.valueOf(userId) + "_" + dimType + "_" + orgView + "_" + appId + "_" + entityNum + "_" + permItemId);
        if (StringUtils.isNotEmpty((String)hasPermMapStr) && (hasPermDimObjsMap = (Map)SerializationUtils.fromJsonString((String)hasPermMapStr, Map.class)) != null) {
            return hasPermDimObjsMap;
        }
        return null;
    }

    public static Map<String, String> getCache(Long userId, String dimType, String orgView, boolean needFilterOrgView, String appId, String entityNum, String permItemId) {
        Map hasPermDimObjsMap;
        String key = String.valueOf(userId) + "_" + dimType + "_" + orgView + "_" + needFilterOrgView + "_" + appId + "_" + entityNum + "_" + permItemId;
        String hasPermMapStr = CacheMrg.getCache(CacheMrg.getHasPermDimObjs(), key);
        if (StringUtils.isNotEmpty((String)hasPermMapStr) && (hasPermDimObjsMap = (Map)SerializationUtils.fromJsonString((String)hasPermMapStr, Map.class)) != null) {
            return hasPermDimObjsMap;
        }
        return null;
    }

    public static void removeCache(Long userId) {
        CacheMrg.clearCacheByPrekey(CacheMrg.getHasPermDimObjs(), String.valueOf(userId));
    }

    public static void removeAllCache() {
        CacheMrg.clearCache(CacheMrg.getHasPermDimObjs());
    }

    public static void removeCache(Long[] arrUserIds) {
        if (arrUserIds == null || arrUserIds.length == 0) {
            return;
        }
        String[] strUserId = new String[arrUserIds.length];
        for (int i = 0; i < arrUserIds.length; ++i) {
            strUserId[i] = String.valueOf(arrUserIds[i]);
        }
        String hasPermDimObjsType = CacheMrg.getHasPermDimObjs();
        if (strUserId.length <= 50) {
            for (int i = 0; i < strUserId.length; ++i) {
                CacheMrg.clearCacheByPrekey(hasPermDimObjsType, strUserId[i]);
            }
        } else {
            CacheMrg.clearCache(hasPermDimObjsType);
        }
    }

    public static void removeCache(List<Long> userIds) {
        Long[] arrUserIds = userIds.toArray(new Long[0]);
        UserHasPermDimObjCache.removeCache(arrUserIds);
    }

    private static Object[] loadAllHasPermDimObjs(Long userId, String dimType, String orgView, String appId, String entityNum, String permItemId) {
        return UserHasPermDimObjCache.loadAllHasPermDimObjs(userId, dimType, orgView, true, appId, entityNum, permItemId);
    }

    private static Object[] loadAllHasPermDimObjs(Long userId, String dimType, String orgView, boolean needFilterOrgView, String appId, String entityNum, String permItemId) {
        ArrayList includeSubDisDimObjList;
        ArrayList arrayList;
        Long dimObjId;
        Boolean includeSub;
        if (userId == null || StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)permItemId)) {
            return null;
        }
        HasPermDimObjResultImpl hasPermDimObjResult = null;
        if (SuperUserCache.isSuperUser(userId) || PermissionServiceHelper.isAdminUser((long)userId, (String)"10") && PermCommonUtil.isInSysCloud(appId)) {
            hasPermDimObjResult = new HasPermDimObjResultImpl(true, new ArrayList(1));
            return new Object[]{hasPermDimObjResult, null};
        }
        Object[] dimTypeInfo = PermCommonUtil.getSuitableDimType(dimType);
        String dimTypeNum = dimTypeInfo[0];
        String dimEntNum = dimTypeInfo[1];
        String rootOrgIdStr = "";
        boolean existsRootOrgIncludeSub = false;
        boolean disfunperm_existsRootOrgIncludeSub = false;
        OrgTreeParam orgTreeParam = new OrgTreeParam();
        orgTreeParam.setOrgViewNumber(orgView);
        TreeNode treeNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)orgTreeParam);
        if (null != treeNode) {
            rootOrgIdStr = treeNode.getId();
        }
        Long rootOrgId = StringUtils.isEmpty((String)rootOrgIdStr) ? 0L : Long.parseLong(rootOrgIdStr);
        HashSet<Long> allHasDisPermDimObjIdSet = new HashSet<Long>(100);
        HashSet<Long> includeSubDisDimObjSet = new HashSet<Long>(100);
        HashMap<Long, Boolean> dimIdIncludesubDisMap = new HashMap<Long, Boolean>(8);
        StringBuilder disFunSql = new StringBuilder().append("SELECT forgid, fisincludesuborg ").append("from t_perm_disfunperm where fuserid = ? and fdimtype = ? ").append(" and fbizappid = ? and fentitytypeid = ? and fpermitemid = ? ");
        Object[] disFunParam = new Object[]{userId, dimEntNum, appId, entityNum, permItemId};
        DataSet ds = DB.queryDataSet((String)UserHasPermDimObjCache.class.getName(), (DBRoute)DBRoute.permission, (String)disFunSql.toString(), (Object[])disFunParam);
        Object object = null;
        try {
            Iterator iterator = ds.iterator();
            while (iterator != null && iterator.hasNext()) {
                Row data = (Row)iterator.next();
                Long dimObjId2 = data.getLong("forgid");
                allHasDisPermDimObjIdSet.add(dimObjId2);
                Boolean isIncludeSub = data.getBoolean("fisincludesuborg");
                if (isIncludeSub != null && isIncludeSub.booleanValue()) {
                    includeSubDisDimObjSet.add(dimObjId2);
                }
                if (null != dimIdIncludesubDisMap.get(dimObjId2) && Boolean.TRUE.equals(dimIdIncludesubDisMap.get(dimObjId2))) continue;
                dimIdIncludesubDisMap.put(dimObjId2, isIncludeSub);
                if (Objects.equals(0L, rootOrgId) || !Objects.equals(rootOrgId, dimObjId2) || !isIncludeSub.booleanValue() || !"bos_org".equals(dimEntNum)) continue;
                disfunperm_existsRootOrgIncludeSub = true;
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        Map<Long, Boolean> bizRoleDisDimObjMaps = BizRoleFunPermService.getHasDisPermOrgs(userId, appId, entityNum, permItemId, dimEntNum);
        if (bizRoleDisDimObjMaps != null && !bizRoleDisDimObjMaps.isEmpty()) {
            for (Map.Entry entry : bizRoleDisDimObjMaps.entrySet()) {
                Long dimObjId3 = (Long)entry.getKey();
                allHasDisPermDimObjIdSet.add(dimObjId3);
                Boolean isIncludeSub = (Boolean)entry.getValue();
                if (null != isIncludeSub && isIncludeSub.booleanValue()) {
                    includeSubDisDimObjSet.add(dimObjId3);
                }
                if (Objects.equals(0L, rootOrgId) || !Objects.equals(rootOrgId, dimObjId3) || !isIncludeSub.booleanValue()) continue;
                disfunperm_existsRootOrgIncludeSub = true;
            }
        }
        int remainExpireTime = UserAppPermService.getAppCacheExp(userId);
        if (disfunperm_existsRootOrgIncludeSub) {
            hasPermDimObjResult = new HasPermDimObjResultImpl(false, new ArrayList(1));
            return new Object[]{hasPermDimObjResult, remainExpireTime};
        }
        Map<Long, Boolean> map = DirectAuthorizeHelper.getUserPermDimIncludeMap(userId, dimTypeNum, appId, entityNum, permItemId);
        HashMap<String, Object> commParam = new HashMap<String, Object>(2);
        commParam.put("userId", userId);
        commParam.put("dimTypeSet", Sets.newHashSet((Object[])dimTypeInfo));
        commParam.put("appId", appId);
        commParam.put("entityNum", entityNum);
        commParam.put("permItemId", permItemId);
        commParam.put("enable", "1");
        commParam.put("enableValidateTime", PermCommonUtil.isEnableValidateTime());
        commParam.put("needQueryRpd", true);
        Map<Long, String> commonRoleHasPermOrgs = PermRoleHelper.getGetHasPermDimObj(commParam);
        Map<Long, Boolean> userBizRoleDimObjMaps = BizRoleFunPermService.getHasPermOrgs(userId, appId, entityNum, permItemId, dimEntNum);
        HashSet<Long> allHasPermDimObjIdSet = new HashSet<Long>(100);
        HashSet<Long> includeSubDimObjSet = new HashSet<Long>(100);
        for (Map.Entry<Long, Boolean> entry : map.entrySet()) {
            Long orgId = entry.getKey();
            includeSub = entry.getValue();
            allHasPermDimObjIdSet.add(orgId);
            if (includeSub.booleanValue()) {
                includeSubDimObjSet.add(orgId);
            }
            if (Objects.equals(0L, rootOrgId) || !Objects.equals(rootOrgId, orgId) || !includeSub.booleanValue()) continue;
            existsRootOrgIncludeSub = true;
        }
        for (Map.Entry<Long, Object> entry : commonRoleHasPermOrgs.entrySet()) {
            dimObjId = entry.getKey();
            String includeSubStr = (String)entry.getValue();
            Boolean includeSub2 = StringUtils.isEmpty((String)includeSubStr) || Objects.equals("0", includeSubStr) ? Boolean.FALSE : Boolean.TRUE;
            allHasPermDimObjIdSet.add(dimObjId);
            if (includeSub2.booleanValue()) {
                includeSubDimObjSet.add(dimObjId);
            }
            if (Objects.equals(0L, rootOrgId) || !Objects.equals(rootOrgId, dimObjId) || !includeSub2.booleanValue()) continue;
            existsRootOrgIncludeSub = true;
        }
        if (userBizRoleDimObjMaps != null & !userBizRoleDimObjMaps.isEmpty()) {
            for (Map.Entry<Long, Object> entry : userBizRoleDimObjMaps.entrySet()) {
                dimObjId = entry.getKey();
                includeSub = (Boolean)entry.getValue();
                allHasPermDimObjIdSet.add(dimObjId);
                if (includeSub.booleanValue()) {
                    includeSubDimObjSet.add(dimObjId);
                }
                if (Objects.equals(0L, rootOrgId) || !Objects.equals(rootOrgId, dimObjId) || !includeSub.booleanValue()) continue;
                existsRootOrgIncludeSub = true;
            }
        }
        List viewOfAllOrgIdsOfRootOrg = new ArrayList(1);
        if (existsRootOrgIncludeSub && dimEntNum.equals("bos_org")) {
            viewOfAllOrgIdsOfRootOrg = Objects.equals("47156aff000000ac", permItemId) ? OrgUnitServiceHelper.getAllOrg((String)orgView) : OrgUnitServiceHelper.getAllOrgByViewNumber((String)orgView, (boolean)true);
        }
        if (!CollectionUtils.isEmpty(arrayList = new ArrayList(includeSubDimObjSet)) && dimEntNum.equals("bos_org")) {
            if (existsRootOrgIncludeSub) {
                allHasPermDimObjIdSet.addAll(viewOfAllOrgIdsOfRootOrg);
            } else {
                List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgView, arrayList, (boolean)false, (boolean)true);
                allHasPermDimObjIdSet.addAll(allSubordinateOrgs);
            }
        }
        if (!CollectionUtils.isEmpty(includeSubDisDimObjList = new ArrayList(includeSubDisDimObjSet)) && dimEntNum.equals("bos_org")) {
            List allDisSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgView, includeSubDisDimObjList, (boolean)false, (boolean)true);
            allHasDisPermDimObjIdSet.addAll(allDisSubordinateOrgs);
        }
        allHasPermDimObjIdSet.removeAll(allHasDisPermDimObjIdSet);
        if (existsRootOrgIncludeSub && allHasDisPermDimObjIdSet.isEmpty() && !needFilterOrgView) {
            hasPermDimObjResult = new HasPermDimObjResultImpl(true, new ArrayList(1));
            return new Object[]{hasPermDimObjResult, remainExpireTime};
        }
        List allPermDimObjIdList = new ArrayList(allHasPermDimObjIdSet);
        if (needFilterOrgView && StringUtils.isNotEmpty((String)orgView) && ("DIM_ORG".equals(dimType) || "bos_org".equals(dimType))) {
            allPermDimObjIdList = OrgUnitServiceHelper.filterOrgDuty(allPermDimObjIdList, (String)orgView);
        }
        hasPermDimObjResult = new HasPermDimObjResultImpl(false, allPermDimObjIdList);
        return new Object[]{hasPermDimObjResult, remainExpireTime};
    }

    @Deprecated
    public static Map<String, HasPermDimObjResult> loadIntoCache(Long userId, String dimType, String appId, String entityNum, String permItemId) {
        return UserHasPermDimObjCache.loadIntoCache(userId, dimType, "15", appId, entityNum, permItemId);
    }

    public static Map<String, HasPermDimObjResult> loadIntoCache(Long userId, String dimType, String orgView, String appId, String entityNum, String permItemId) {
        return UserHasPermDimObjCache.loadIntoCache(userId, dimType, orgView, true, appId, entityNum, permItemId);
    }

    public static Map<String, HasPermDimObjResult> loadIntoCache(Long userId, String dimType, String orgView, boolean needFilterOrgView, String appId, String entityNum, String permItemId) {
        HashMap<String, HasPermDimObjResult> result = new HashMap<String, HasPermDimObjResult>(5);
        HashMap<String, String> map = new HashMap<String, String>();
        Object[] allHasPermInfos = UserHasPermDimObjCache.loadAllHasPermDimObjs(userId, dimType, orgView, needFilterOrgView, appId, entityNum, permItemId);
        if (allHasPermInfos == null || allHasPermInfos.length == 0 || allHasPermInfos[0] == null) {
            return result;
        }
        HasPermDimObjResult allHasPermDimObjs = (HasPermDimObjResult)allHasPermInfos[0];
        Integer remainExpireTime = (Integer)allHasPermInfos[1];
        map.put(dimType, ((HasPermDimObjResultImpl)allHasPermDimObjs).toSerializeStr());
        String key = String.valueOf(userId) + "_" + dimType + "_" + orgView + "_" + needFilterOrgView + "_" + appId + "_" + entityNum + "_" + permItemId;
        if (remainExpireTime == null || remainExpireTime == 0) {
            UserHasPermDimObjCache.putCache(key, map);
        } else {
            UserHasPermDimObjCache.putCache(key, map, remainExpireTime);
        }
        for (Map.Entry entry : map.entrySet()) {
            HasPermDimObjResult r = HasPermDimObjResultImpl.fromSerializeStr((String)((String)entry.getValue()));
            result.put((String)entry.getKey(), r);
        }
        return result;
    }

    public static HasPermDimObjResult getAllHasPermDimObjs(Long userId, String dimType, String appId, String entityNum, String permItemId) {
        return UserHasPermDimObjCache.getAllHasPermDimObjs(userId, dimType, null, appId, entityNum, permItemId);
    }

    private static HasPermDimObjResult getAllHasPermDimObjsBySingleBizRole(Long userId, String appId, String entityNum, String permItemId, String dimType) {
        if (SuperUserCache.isSuperUser(userId) || PermissionServiceHelper.isAdminUser((long)userId, (String)"10")) {
            ArrayList dimObjIdList = new ArrayList();
            HasPermDimObjResultImpl hasPermDimObjResult = new HasPermDimObjResultImpl(true, dimObjIdList);
            return hasPermDimObjResult;
        }
        String bizRoleId = UserBizRoleCache.getSelBizRole(userId);
        if (bizRoleId.equals("")) {
            return new HasPermDimObjResultImpl(false, new ArrayList());
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid from t_perm_bizroledisperm a ").append("where a.fid = ? ").append("and a.fbizappid = ? ").append("and a.fentitytypeid = ? ").append("and a.fpermitemid = ? ");
        Object[] filters = new Object[]{Long.valueOf(bizRoleId), appId, entityNum, permItemId};
        boolean isDisPerm = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])filters, ResultSet::next);
        if (isDisPerm) {
            return new HasPermDimObjResultImpl(false, new ArrayList());
        }
        sql.setLength(0);
        sql.append("select a.fid from t_perm_bizroleperm a ").append("where a.fid =? ").append("and a.fbizappid = ? ").append("and a.fentitytypeid = ? ").append("and a.fpermitemid = ? ");
        boolean isPerm = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])filters, ResultSet::next);
        if (!isPerm) {
            sql.setLength(0);
            sql.append("select a.froleid from t_perm_bizrolecomrole a ").append("join t_perm_role b on a.froleid=b.fid ").append("join t_perm_rolepermdetial d on b.fid=d.froleid ").append("where a.fid =? ").append("and b.fenable = '1' ").append("and d.fbizappid = ? ").append("and d.fentitytypeid = ? ").append("and d.fpermitemid = ? ");
            isPerm = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])filters, ResultSet::next);
            if (!isPerm) {
                return new HasPermDimObjResultImpl(false, new ArrayList());
            }
        }
        sql.setLength(0);
        sql.append("select a.forgid,a.fisincludesuborg from t_perm_bizroleorg a ").append("join t_perm_bizrole b on a.fid=b.fid ").append("where a.fid= ? ").append("and b.fenable = '1' ");
        filters = new Object[]{Long.valueOf(bizRoleId)};
        Map orgMap = (Map)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])filters, rs -> {
            HashMap<Long, String> ids = new HashMap<Long, String>(16);
            while (rs.next()) {
                Long id = rs.getLong(1);
                String isIncludeSubOrg = rs.getString(2);
                ids.put(id, isIncludeSubOrg);
            }
            return ids;
        });
        ArrayList userOrgs = new ArrayList();
        ArrayList orgIncludeSub = new ArrayList();
        for (Map.Entry org : orgMap.entrySet()) {
            if (((String)org.getValue()).equals("1")) {
                orgIncludeSub.add(org.getKey());
                continue;
            }
            userOrgs.add(org.getKey());
        }
        for (Long parentId : orgIncludeSub) {
            List childOrg = OrgViewServiceHelper.getChildOrgId((long)15L, (long)parentId, (boolean)true);
            userOrgs.addAll(childOrg);
        }
        return new HasPermDimObjResultImpl(false, userOrgs);
    }

    public static HasPermDimObjResult getAllHasPermDimObjs(Long userId, String appId, String entityNum, String permItemId) {
        return UserHasPermDimObjCache.getAllHasPermDimObjs(userId, "", appId, entityNum, permItemId);
    }

    public static HasPermDimObjResult getUserHasPermDimObjs(long userId, String dimType) {
        if (PermCommonUtil.isEnableSingleBizRole()) {
            List<Long> userOrgs = UserHasPermDimObjCache.getUserOrgsBySingleBizRole(userId);
            return new HasPermDimObjResultImpl(false, userOrgs);
        }
        return UserHasPermDimObjCache.getUserHasPermDimObjs(userId, "", dimType);
    }

    public static HasPermDimObjResult getUserHasPermDimObjs(long userId, String appId, String dimType) {
        AppInfo appInfo;
        if (userId == 0L) {
            return new HasPermDimObjResultImpl(false, new ArrayList(1));
        }
        if (SuperUserCache.isSuperUser(userId) || PermissionServiceHelper.isAdminUser((long)userId, (String)"10")) {
            return new HasPermDimObjResultImpl(true, new ArrayList(1));
        }
        if (StringUtils.isNotEmpty((String)appId) && (appInfo = AppHelper.getMetaAppInfo(appId)) != null && appInfo.isAllUserApp()) {
            return new HasPermDimObjResultImpl(true, new ArrayList(1));
        }
        if (StringUtils.isEmpty((String)dimType)) {
            dimType = "bos_org";
        }
        Object[] dimTypeInfo = PermCommonUtil.getSuitableDimType(dimType);
        HashSet<Long> allDimObjs = new HashSet<Long>(8);
        HashSet<Long> includeSubDimObjs = new HashSet<Long>(8);
        if (StringUtils.isNotEmpty((String)appId)) {
            appId = PermCommonUtil.getAppIdFromSuspectedAppNum(appId);
        }
        HashMap<String, Object> directParam = new HashMap<String, Object>(2);
        directParam.put("userId", userId);
        directParam.put("dimTypeInfo", dimTypeInfo);
        directParam.put("appId", appId);
        Map<String, Object> directDimIdsMap = DirectAuthorizeHelper.getDimIncludeSubInfoMap(directParam);
        if (!CollectionUtils.isEmpty(directDimIdsMap)) {
            allDimObjs.addAll((Set)directDimIdsMap.get("allDimObjs"));
            includeSubDimObjs.addAll((Set)directDimIdsMap.get("includeSubDimObjs"));
        }
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("userId", userId);
        commParam.put("dimTypeSet", Sets.newHashSet((Object[])dimTypeInfo));
        commParam.put("enable", "1");
        commParam.put("enableValidateTime", PermCommonUtil.isEnableValidateTime());
        if (StringUtils.isEmpty((String)appId)) {
            commParam.put("needQueryRpd", false);
        } else {
            commParam.put("needQueryRpd", true);
            commParam.put("appId", appId);
        }
        Map<Long, String> commonRoleHasPermOrgs = PermRoleHelper.getGetHasPermDimObj(commParam);
        if (null != commonRoleHasPermOrgs && !commonRoleHasPermOrgs.isEmpty()) {
            for (Map.Entry<Long, String> entry : commonRoleHasPermOrgs.entrySet()) {
                Long dimObjId = entry.getKey();
                String includeSubStr = entry.getValue();
                Boolean includeSub = StringUtils.isEmpty((String)includeSubStr) || Objects.equals("0", includeSubStr) ? Boolean.FALSE : Boolean.TRUE;
                allDimObjs.add(dimObjId);
                if (!includeSub.booleanValue()) continue;
                includeSubDimObjs.add(dimObjId);
            }
        }
        Map<Long, Boolean> bizRolepermDimObjMap = BizRoleFunPermService.getUserHasPermDimObjs(userId, appId, dimType);
        bizRolepermDimObjMap.forEach((k, v) -> {
            allDimObjs.add((Long)k);
            if (v.booleanValue()) {
                includeSubDimObjs.add((Long)k);
            }
        });
        if (!CollectionUtils.isEmpty(includeSubDimObjs)) {
            allDimObjs.addAll(UserHasPermDimObjCache.getSubDimObjs(dimType, new ArrayList<Long>(includeSubDimObjs)));
        }
        return new HasPermDimObjResultImpl(false, new ArrayList(allDimObjs));
    }

    private static List<Long> getUserOrgsBySingleBizRole(long userId) {
        String bizRoleId = UserBizRoleCache.getSelBizRole(userId);
        if (StringUtils.isEmpty((String)bizRoleId)) {
            return new ArrayList<Long>();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select a.forgid,a.fisincludesuborg from t_perm_bizroleorg a ").append("join t_perm_bizrole b on a.fid=b.fid ").append("where a.fid= ? ").append("and b.fenable = '1' ");
        Object[] filters = new Object[]{StringUtils.isEmpty((String)bizRoleId) ? 0L : Long.parseLong(bizRoleId)};
        Map orgMap = (Map)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])filters, rs -> {
            HashMap<Long, String> ids = new HashMap<Long, String>(16);
            while (rs.next()) {
                Long id = rs.getLong(1);
                String isIncludeSubOrg = rs.getString(2);
                ids.put(id, isIncludeSubOrg);
            }
            return ids;
        });
        ArrayList<Long> userOrgs = new ArrayList<Long>();
        ArrayList orgIncludeSub = new ArrayList();
        for (Map.Entry org : orgMap.entrySet()) {
            if (((String)org.getValue()).equals("1")) {
                orgIncludeSub.add(org.getKey());
                continue;
            }
            userOrgs.add((Long)org.getKey());
        }
        for (Long parentId : orgIncludeSub) {
            List childOrg = OrgViewServiceHelper.getChildOrgId((long)15L, (long)parentId, (boolean)true);
            userOrgs.addAll(childOrg);
        }
        return userOrgs;
    }

    private static List<Long> getSubDimObjs(String dimType, List<Long> includeSubDimObjs) {
        if ("bos_org".equals(dimType) || "DIM_ORG".equals(dimType)) {
            return OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", includeSubDimObjs, (boolean)false, (boolean)true);
        }
        return new ArrayList<Long>();
    }

    public static List<Long> getUserOrgs(long userId) {
        HasPermDimObjResult userHasPermDimObjs = UserHasPermDimObjCache.getUserHasPermDimObjs(userId, "DIM_ORG");
        if (userHasPermDimObjs.hasAllDimObjPerm()) {
            return PermCommonUtil.getAllOrgIds();
        }
        return userHasPermDimObjs.getHasPermDimObjs();
    }

    public static HasPermDimObjResult getAllHasPermDimObjs(Long userId, String dimType, String orgView, String appId, String entityNum, String permItemId) {
        return UserHasPermDimObjCache.getAllHasPermDimObjs(userId, dimType, orgView, true, appId, entityNum, permItemId);
    }

    public static HasPermDimObjResult getAllHasPermDimObjs(Long userId, String dimType, String orgView, boolean needFilterOrgView, String appId, String entityNum, String permItemId) {
        if (userId == null || StringUtils.isEmpty((String)entityNum) || StringUtils.isEmpty((String)permItemId)) {
            return null;
        }
        boolean validPermItemId = PermCommonUtil.isValidPermItemId(permItemId);
        if (!validPermItemId) {
            return new HasPermDimObjResultImpl(false, new ArrayList());
        }
        boolean hasBindingFunctionPerm = PermCommonUtil.hasBindingFunctionPerm(entityNum);
        if (!hasBindingFunctionPerm) {
            return new HasPermDimObjResultImpl(true, new ArrayList());
        }
        Set permissionItems = EntityMetadataCache.getPermissionItems((String)entityNum);
        if (permissionItems != null && !permissionItems.isEmpty() && !permissionItems.contains(permItemId)) {
            return new HasPermDimObjResultImpl(true, new ArrayList());
        }
        if (StringUtils.isEmpty((String)dimType)) {
            dimType = FormHelper.getPermissionControlType(entityNum).getDimension();
        }
        if (StringUtils.isEmpty((String)orgView)) {
            orgView = PermCommonUtil.getPermOrgViewScheme(entityNum);
        }
        appId = PermCommonUtil.getCheckPermAppId(appId, entityNum);
        if (PermCommonUtil.isEnableSingleBizRole()) {
            return UserHasPermDimObjCache.getAllHasPermDimObjsBySingleBizRole(userId, appId, entityNum, permItemId, dimType);
        }
        Map<String, String> cache = UserHasPermDimObjCache.getCache(userId, dimType, orgView, needFilterOrgView, appId, entityNum, permItemId);
        if (cache == null || cache.get(dimType) == null) {
            Map<String, HasPermDimObjResult> map = UserHasPermDimObjCache.loadIntoCache(userId, dimType, orgView, needFilterOrgView, appId, entityNum, permItemId);
            return map.get(dimType);
        }
        return HasPermDimObjResultImpl.fromSerializeStr((String)cache.get(dimType));
    }
}

