/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.SessionManager;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UserHasPermOrgCache {
    private static final Log logger = LogFactory.getLog(UserHasPermOrgCache.class);

    @Deprecated
    public static void clearUserLoginDefaultOrgs(Long userId) {
        UserHasPermOrgCache.clearUserLoginOrgs(userId);
    }

    @Deprecated
    public static void clearUserLoginDefaultOrgs(List<Long> userIds) {
        UserHasPermOrgCache.clearUserLoginOrgs(userIds);
    }

    public static void clearUserLoginOrgs(Long userId) {
        if (userId == null || userId == 0L) {
            return;
        }
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        UserHasPermOrgCache.clearUserLoginOrgs(userIds);
    }

    public static void clearUserLoginOrgs(Collection<Long> userIds) {
        UserHasPermOrgCache.markUserMayChangeLoginOrg(userIds);
    }

    public static void markUserMayChangeLoginOrg(Collection<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>(8);
        for (Long userId : userIds) {
            map.put(String.valueOf(userId), "1");
        }
        CacheMrg.putCache(CacheMrg.getType4UserMayChangeLoginOrg(), map);
    }

    public static void startChangeLoginOrgThread() {
        ThreadPools.executeOnceIncludeRequestContext((String)"UserHasPermOrgCache_changeLoginOrgThread", (Runnable)new Runnable(){

            @Override
            public void run() {
                String strUserId;
                Map<String, String> map = CacheMrg.getCache(CacheMrg.getType4UserMayChangeLoginOrg());
                Set<Long> allLoginUserIds = PermCommonUtil.getAllLoginUserIds();
                Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Long userId;
                    Map.Entry<String, String> entry = iterator.next();
                    strUserId = entry.getKey();
                    if (StringUtils.isEmpty((String)strUserId) || !allLoginUserIds.contains(userId = Long.valueOf(strUserId))) continue;
                    allLoginUserIds.remove(userId);
                    iterator.remove();
                    String processStatus = entry.getValue();
                    if (processStatus.equals("0")) continue;
                    UserHasPermOrgCache.processChangeLoginOrg(strUserId, processStatus);
                }
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String processStatus;
                    strUserId = entry.getKey();
                    if (StringUtils.isEmpty((String)strUserId) || (processStatus = entry.getValue()).equals("0")) continue;
                    UserHasPermOrgCache.processChangeLoginOrg(strUserId, processStatus);
                }
            }
        });
    }

    public static Long processChangeLoginOrg(String strUserId, String processStatus) {
        if (StringUtils.isEmpty((String)strUserId)) {
            return null;
        }
        if (StringUtils.isEmpty((String)processStatus)) {
            Map<String, String> map = CacheMrg.getCache(CacheMrg.getType4UserMayChangeLoginOrg());
            if (CollectionUtils.isEmpty(map)) {
                return null;
            }
            processStatus = map.get(strUserId);
            if (StringUtils.isEmpty((String)processStatus) || "0".equals(processStatus)) {
                return null;
            }
        }
        return UserHasPermOrgCache.processChangeLoginOrg(strUserId);
    }

    public static Long processChangeLoginOrg(String strUserId) {
        String cacheType = CacheMrg.getType4UserMayChangeLoginOrg();
        CacheMrg.putCache(cacheType, strUserId, "0");
        Long userId = Long.valueOf(strUserId);
        long curLoginOrgId = RequestContext.get().getOrgId();
        Long newOrgId = UserHasPermOrgCache.resetHasPermLoginOrg(userId, curLoginOrgId);
        CacheMrg.clearCache(cacheType, strUserId);
        return newOrgId;
    }

    public static Long resetHasPermLoginOrg(long userId, Long curLoginOrgId) {
        return UserHasPermOrgCache.resetHasPermLoginOrg(userId, curLoginOrgId, false);
    }

    public static Long resetHasPermLoginOrg(long userId, Long curLoginOrgId, boolean needProcessAllSessionLoginOrg) {
        Long newOrgId;
        boolean curLoginOrgIdIsValid;
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)userId, (boolean)false);
        boolean bl = curLoginOrgIdIsValid = curLoginOrgId != null && curLoginOrgId != 0L;
        if (hasPermOrgResult.hasAllOrgPerm()) {
            boolean hasBizUnitFun = true;
            if (curLoginOrgIdIsValid) {
                hasBizUnitFun = OrgUnitServiceHelper.checkOrgFunction((Long)curLoginOrgId, (String)"15");
            }
            if (!curLoginOrgIdIsValid || !hasBizUnitFun) {
                Long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                SessionManager.editSessionValue((String)RequestContext.get().getGlobalSessionId(), (String)"orgId", (String)String.valueOf(rootOrgId));
                return rootOrgId;
            }
            return curLoginOrgId;
        }
        List hasPermOrgIds = hasPermOrgResult.getHasPermOrgs();
        List hasPermOrgUnitIds = OrgUnitServiceHelper.filterOrgDuty((List)hasPermOrgIds, (String)"15");
        if (curLoginOrgIdIsValid) {
            if (hasPermOrgUnitIds.contains(curLoginOrgId)) {
                return null;
            }
            if (hasPermOrgUnitIds.isEmpty() && UserServiceHelper.getOrgsUserJoin((long)userId).contains(curLoginOrgId)) {
                return null;
            }
        }
        Long l = newOrgId = CollectionUtils.isEmpty((Collection)hasPermOrgUnitIds) ? Long.valueOf(0L) : (Long)Collections.min(hasPermOrgUnitIds);
        if (Objects.equals(0L, newOrgId)) {
            return newOrgId;
        }
        HashSet<String> sessionIdsForUpdateOrg = new HashSet<String>();
        if (needProcessAllSessionLoginOrg) {
            String accountId = RequestContext.get().getAccountId();
            Map sessionOrgByUserId = SessionManager.getSessionOrgByUserId((String)accountId, (String)String.valueOf(userId));
            for (Map.Entry sessinoOrgMapEntry : sessionOrgByUserId.entrySet()) {
                Long loginOrgId;
                String strLoginOrgId = (String)sessinoOrgMapEntry.getValue();
                if (StringUtils.isEmpty((String)strLoginOrgId) || Objects.equals(loginOrgId = Long.valueOf(strLoginOrgId), newOrgId) || hasPermOrgUnitIds.contains(loginOrgId)) continue;
                String sessionId = (String)sessinoOrgMapEntry.getKey();
                sessionIdsForUpdateOrg.add(sessionId);
            }
        } else {
            long curUserLoginOrgId = RequestContext.get().getOrgId();
            if (!Objects.equals(curUserLoginOrgId, newOrgId) && !hasPermOrgUnitIds.contains(curUserLoginOrgId)) {
                sessionIdsForUpdateOrg.add(RequestContext.get().getGlobalSessionId());
            }
        }
        if (sessionIdsForUpdateOrg.isEmpty()) {
            return null;
        }
        for (String sessionId : sessionIdsForUpdateOrg) {
            SessionManager.editSessionValue((String)sessionId, (String)"orgId", (String)String.valueOf(newOrgId));
        }
        return newOrgId;
    }
}

