/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.RoleInfo;
import kd.bos.permission.cache.BizRoleFunPermService;
import kd.bos.permission.cache.BizRoleService;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.RoleCache;
import kd.bos.permission.cache.UserBizRoleCache;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UserRoleCache {
    private static Log log = LogFactory.getLog(BizRoleFunPermService.class);
    public static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_UserRoleCache", (int)4);

    private static String buildCacheKey(long userId, long orgId) {
        return String.format("%s_%s", userId, orgId);
    }

    private static String buildCacheKey(long userId, long orgId, String orgFunc) {
        return String.format("%s_%s_%s", userId, orgId, orgFunc);
    }

    public static List<String> reloadUserRoles(final long userId, final long orgId) {
        ArrayList<String> roleList = new ArrayList<String>(100);
        Callable<Set<String>> bizComRoleIDsCallable = new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                return BizRoleService.getCommRoleIdsByUserIDAndOrgId(userId, orgId);
            }
        };
        Future bizComRoleIDsFuture = pool.submit((Callable)bizComRoleIDsCallable, RequestContext.get());
        Set<String> comRoleList = UserHelper.getCommRoleIds(userId, null, Collections.singletonList(orgId), null, null);
        roleList.addAll(comRoleList);
        try {
            Set bizComRoleIdSet = (Set)bizComRoleIDsFuture.get();
            bizComRoleIdSet.stream().forEach(x -> {
                if (!roleList.contains(x)) {
                    roleList.add((String)x);
                }
            });
        }
        catch (Exception e) {
            log.warn("bos-permission-cache_UserRoleCache_reloadUserRoles,\u83b7\u53d6\u4e1a\u52a1\u89d2\u8272\u5305\u542b\u7684\u901a\u7528\u89d2\u8272\u5f02\u5e38", (Throwable)e);
        }
        String type = CacheMrg.getType4UserRole();
        String key = UserRoleCache.buildCacheKey(userId, orgId);
        if (roleList.size() > 0) {
            CacheMrg.putCache(type, key, PermCommonUtil.list2Str(roleList));
        } else {
            CacheMrg.loaded(type, key);
        }
        return roleList;
    }

    public static List<RoleInfo> getUserRolesIncludeSuperior(long userId, long orgId, String orgFunc, String dimension) {
        ArrayList<RoleInfo> roleList = new ArrayList<RoleInfo>();
        List<String> roleIdList = UserRoleCache.loadUserRolesCache(userId, orgId, orgFunc, dimension);
        if (roleIdList != null) {
            for (String id : roleIdList) {
                RoleInfo roleInfo = RoleCache.getRoleInfoById(id);
                if (roleInfo == null) continue;
                roleList.add(roleInfo);
            }
        }
        return roleList;
    }

    private static List<String> loadUserRolesCache(long userId, long orgId, String orgFunc, String dimension) {
        List<String> roleList = null;
        String type = CacheMrg.getType4UserRole();
        String key = UserRoleCache.buildCacheKey(userId, orgId);
        String orgKey = UserRoleCache.buildCacheKey(userId, orgId, orgFunc);
        String val = null;
        dimension = PermCommonUtil.getSuitableDimType(dimension)[1];
        List newSuperiorOrg = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgFunc, (long)orgId);
        String oldSuperiorOrgStr = CacheMrg.getCache(type, orgKey);
        if (StringUtils.isNotEmpty((String)oldSuperiorOrgStr)) {
            List oldSuperiorOrg = SerializationUtils.fromJsonStringToList((String)CacheMrg.getCache(type, orgKey), Long.class);
            if (newSuperiorOrg.containsAll(oldSuperiorOrg) && oldSuperiorOrg.containsAll(newSuperiorOrg)) {
                val = CacheMrg.getCache(type, key);
            }
        } else {
            CacheMrg.putCache(type, orgKey, SerializationUtils.toJsonString((Object)newSuperiorOrg));
        }
        if (CacheMrg.isLoaded(val)) {
            if (CacheMrg.isData(val)) {
                roleList = PermCommonUtil.str2List(val);
            }
        } else {
            roleList = UserRoleCache.reloadUserRoles(userId, orgId, newSuperiorOrg, dimension);
        }
        return roleList;
    }

    public static List<String> reloadUserRoles(final long userId, final long orgId, final List<Long> superiorOrg, final String dimension) {
        Set roleIdSet;
        Callable<Set<String>> bizComRoleIDsCallable = new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                return BizRoleService.getCommRoleIdsByUserIDAndDimId(userId, orgId, dimension);
            }
        };
        Future bizComRoleIDsFuture = pool.submit((Callable)bizComRoleIDsCallable, RequestContext.get());
        Callable<Set<String>> supbizComRoleIDsCallable = new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                return BizRoleService.getCommRoleIdsByUserIDAndDimIdWithSup(userId, superiorOrg, dimension);
            }
        };
        Future supbizComRoleIDsFuture = pool.submit((Callable)supbizComRoleIDsCallable, RequestContext.get());
        HashSet finalRoleIdSet = new HashSet(8);
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getRoleIdSet");
        commParam.put("userId", userId);
        commParam.put("dimTypeList", IsoDimHelper.addDimTypeFilter(dimension) ? Collections.singletonList(dimension) : new ArrayList(1));
        commParam.put("dimIdList", Collections.singletonList(orgId));
        commParam.put("enable", "1");
        commParam.put("selectTSecUserGroupStaff", "1");
        commParam.put("selectTPermRole", "1");
        Map<String, Object> curOrgDimCommMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (!CollectionUtils.isEmpty(curOrgDimCommMap) && !CollectionUtils.isEmpty((Collection)(roleIdSet = (Set)curOrgDimCommMap.get("roleIdSet")))) {
            finalRoleIdSet.addAll(roleIdSet);
        }
        if (!CollectionUtils.isEmpty(superiorOrg)) {
            Set roleIdSet2;
            commParam.put("dimIdList", superiorOrg);
            commParam.put("includeSub", "1");
            commParam.put("orgView", null);
            Map<String, Object> superOrgDimCommMap = PermRoleHelper.getCommRoleInfoMap(commParam);
            if (!CollectionUtils.isEmpty(superOrgDimCommMap) && !CollectionUtils.isEmpty((Collection)(roleIdSet2 = (Set)superOrgDimCommMap.get("roleIdSet")))) {
                finalRoleIdSet.addAll(roleIdSet2);
            }
        }
        try {
            Set bizComRoleIdSet = (Set)bizComRoleIDsFuture.get();
            finalRoleIdSet.addAll(bizComRoleIdSet);
            Set supbizComRoleIdSet = (Set)supbizComRoleIDsFuture.get();
            finalRoleIdSet.addAll(supbizComRoleIdSet);
        }
        catch (Exception e) {
            log.warn("bos-permission-cache_UserRoleCache_reloadUserRoles_long userId,long orgId,List<Long> superiorOrg,String dimension,\u83b7\u53d6\u4e1a\u52a1\u89d2\u8272\u5305\u542b\u7684\u901a\u7528\u89d2\u8272\u5f02\u5e38", (Throwable)e);
        }
        ArrayList<String> finalRoleIdList = new ArrayList<String>(finalRoleIdSet);
        String type = CacheMrg.getType4UserRole();
        String key = UserRoleCache.buildCacheKey(userId, orgId);
        if (finalRoleIdSet.size() > 0) {
            CacheMrg.putCache(type, key, PermCommonUtil.list2Str(finalRoleIdList));
        } else {
            CacheMrg.loaded(type, key);
        }
        return finalRoleIdList;
    }

    public static Map<String, Map<Long, Boolean>> getRoleDimObjAssignMapSimple(Long pUserId) {
        return UserRoleCache.getRoleDimObjAssignMapSimple(pUserId, null);
    }

    public static Map<String, Map<Long, Boolean>> getRoleDimObjAssignMapSimple(final Long pUserId, final String dimType) {
        HashMap<String, Map<Long, Boolean>> roleOrgAssignMap;
        block8: {
            String roleId;
            Map roleDimIncludeSubMap;
            block7: {
                roleOrgAssignMap = new HashMap<String, Map<Long, Boolean>>();
                if (!PermCommonUtil.isEnableSingleBizRole()) break block7;
                String selBizRoleId = UserBizRoleCache.getSelBizRole(pUserId);
                if (!StringUtils.isNotEmpty((String)selBizRoleId)) break block8;
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
                qFilters.add(new QFilter("id", "=", (Object)Long.valueOf(selBizRoleId)));
                qFilters.add(new QFilter("bizrolecomrole.ISENABLE", "=", (Object)"1"));
                if (StringUtils.isNotEmpty((String)dimType)) {
                    qFilters.add(new QFilter("bizroleorg.dimtype", "=", (Object)dimType));
                }
                DynamicObjectCollection userRoleDoc = QueryServiceHelper.query((String)"perm_bizrole", (String)"bizrolecomrole.role role,bizroleorg.org org, bizroleorg.isincludesuborg includesuborg", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
                for (DynamicObject dObj : userRoleDoc) {
                    Long curOrgId = dObj.getLong("org");
                    String roleId2 = dObj.getString("role");
                    boolean includeSubOrg = dObj.getBoolean("includesuborg");
                    roleOrgAssignMap.computeIfAbsent(roleId2, k -> new HashMap()).put(curOrgId, includeSubOrg);
                }
                break block8;
            }
            Callable<Map<String, Map<Long, Boolean>>> bizComRoleMapCallable = new Callable<Map<String, Map<Long, Boolean>>>(){

                @Override
                public Map<String, Map<Long, Boolean>> call() throws Exception {
                    return BizRoleService.getComRoleDimObj(pUserId, dimType);
                }
            };
            Future bizComRoleMapFuture = pool.submit((Callable)bizComRoleMapCallable, RequestContext.get());
            HashMap<String, Object> commParam = new HashMap<String, Object>(8);
            commParam.put("queryType", "getRoleDimIncludeSubMap");
            commParam.put("userId", pUserId);
            commParam.put("dimTypeList", IsoDimHelper.addDimTypeFilter(dimType) ? Collections.singletonList(dimType) : new ArrayList(1));
            commParam.put("selectTSecUserGroupStaff", "1");
            Map<String, Object> commRoleInfoMap = PermRoleHelper.getCommRoleInfoMap(commParam);
            if (!CollectionUtils.isEmpty(commRoleInfoMap) && !CollectionUtils.isEmpty((Map)(roleDimIncludeSubMap = (Map)commRoleInfoMap.get("roleDimIncludeSubMap")))) {
                for (Map.Entry roleDimIncludeSub : roleDimIncludeSubMap.entrySet()) {
                    roleId = (String)roleDimIncludeSub.getKey();
                    Map dimIncludeSubMap = (Map)roleDimIncludeSub.getValue();
                    dimIncludeSubMap.forEach((k, v) -> {
                        if (v.booleanValue()) {
                            roleOrgAssignMap.computeIfAbsent(roleId, id -> new HashMap()).put(k, v);
                        } else {
                            roleOrgAssignMap.computeIfAbsent(roleId, id -> new HashMap()).putIfAbsent(k, v);
                        }
                    });
                }
            }
            try {
                Map bizComRoleMap = (Map)bizComRoleMapFuture.get();
                for (Map.Entry bizComRoleEntry : bizComRoleMap.entrySet()) {
                    roleId = (String)bizComRoleEntry.getKey();
                    Map orgIncluMap = (Map)bizComRoleEntry.getValue();
                    orgIncluMap.forEach((k, v) -> {
                        if (v.booleanValue()) {
                            roleOrgAssignMap.computeIfAbsent(roleId, id -> new HashMap()).put(k, v);
                        } else {
                            roleOrgAssignMap.computeIfAbsent(roleId, id -> new HashMap()).putIfAbsent(k, v);
                        }
                    });
                }
            }
            catch (Exception e) {
                log.warn("bos-permission-cache_UserRoleCache_getRoleDimObjAssignMapSimple,\u83b7\u53d6\u4e1a\u52a1\u89d2\u8272\u5305\u542b\u7684\u901a\u7528\u89d2\u8272\u5f02\u5e38", (Throwable)e);
            }
        }
        return roleOrgAssignMap;
    }

    public static Map<String, Set<Long>> getRoleOrgAssignMap(final Long pUserId) {
        String roleId;
        Map roleDimIncludeSubMap;
        HashMap<String, Set<Long>> roleOrgAssignMap = new HashMap<String, Set<Long>>();
        Callable<Map<String, Map<Long, Boolean>>> bizComRoleMapCallable = new Callable<Map<String, Map<Long, Boolean>>>(){

            @Override
            public Map<String, Map<Long, Boolean>> call() throws Exception {
                return BizRoleService.getComRoleDimObj(pUserId);
            }
        };
        Future bizComRoleMapFuture = pool.submit((Callable)bizComRoleMapCallable, RequestContext.get());
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getRoleDimIncludeSubMap");
        commParam.put("userId", pUserId);
        commParam.put("selectTSecUserGroupStaff", "1");
        Map<String, Object> commRoleInfoMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (!CollectionUtils.isEmpty(commRoleInfoMap) && !CollectionUtils.isEmpty((Map)(roleDimIncludeSubMap = (Map)commRoleInfoMap.get("roleDimIncludeSubMap")))) {
            for (Map.Entry roleDimIncludeSub : roleDimIncludeSubMap.entrySet()) {
                roleId = (String)roleDimIncludeSub.getKey();
                Map dimIncludeSubMap = (Map)roleDimIncludeSub.getValue();
                if (CollectionUtils.isEmpty((Map)dimIncludeSubMap)) continue;
                for (Map.Entry dimIncludeSub : dimIncludeSubMap.entrySet()) {
                    Long dimId = (Long)dimIncludeSub.getKey();
                    Boolean includeSub = (Boolean)dimIncludeSub.getValue();
                    roleOrgAssignMap.computeIfAbsent(roleId, k -> new HashSet()).add(dimId);
                    if (!includeSub.booleanValue()) continue;
                    List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), Collections.singletonList(dimId), (boolean)false, (boolean)true);
                    ((Set)roleOrgAssignMap.get(roleId)).addAll(allSubordinateOrgs);
                }
            }
        }
        try {
            Map bizComRoleMap = (Map)bizComRoleMapFuture.get();
            for (Map.Entry bizComRoleEntry : bizComRoleMap.entrySet()) {
                roleId = (String)bizComRoleEntry.getKey();
                Map orgIncluMap = (Map)bizComRoleEntry.getValue();
                orgIncluMap.forEach((k, v) -> {
                    roleOrgAssignMap.computeIfAbsent(roleId, id -> new HashSet()).add(k);
                    if (v.booleanValue()) {
                        ArrayList<Long> curOrgList = new ArrayList<Long>();
                        curOrgList.add((Long)k);
                        List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), curOrgList, (boolean)false, (boolean)true);
                        ((Set)roleOrgAssignMap.get(roleId)).addAll(allSubordinateOrgs);
                    }
                });
            }
        }
        catch (Exception e) {
            log.warn("bos-permission-cache_UserRoleCache_getRoleDimObjAssignMapSimple,\u83b7\u53d6\u4e1a\u52a1\u89d2\u8272\u5305\u542b\u7684\u901a\u7528\u89d2\u8272\u5f02\u5e38", (Throwable)e);
        }
        return roleOrgAssignMap;
    }

    @Deprecated
    public static Set<String> getComRolesByUserId(Long userId) {
        return UserHelper.getJustCommRoleIdSetByUserId(userId);
    }

    public static Set<String> getRolesByUserId(Long userId) {
        RequestContext rc = RequestContext.get();
        String key = String.format("%s%s%s", "getRolesByUserId_", rc.getAccountId(), userId);
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
            Set<String> roles = UserRoleCache.getRolesByUserIdPri(userId);
            if (null == roles) {
                return map;
            }
            map.put("roles", roles);
            return map;
        });
        return (Set)threadCacheMap.get("roles");
    }

    private static Set<String> getRolesByUserIdPri(final Long userId) {
        Set<String> resultSet = new HashSet<String>(8);
        try {
            String cacheType = CacheMrg.getType4UserOwnCommRoleIds();
            String cacheKey = String.valueOf(userId);
            String cachedStr = CacheMrg.getCache(cacheType, cacheKey);
            if (StringUtils.isNotEmpty((String)cachedStr)) {
                resultSet = (Set)SerializationUtils.fromJsonString((String)cachedStr, Set.class);
                return resultSet;
            }
            Callable<Set<String>> bizComRoleIDsCallable = new Callable<Set<String>>(){

                @Override
                public Set<String> call() throws Exception {
                    return BizRoleService.getCommRoleIdsByUserID(userId);
                }
            };
            Future bizComRoleIDsFuture = pool.submit((Callable)bizComRoleIDsCallable, RequestContext.get());
            Set<String> comRoleList = UserHelper.getJustCommRoleIdSetByUserId(userId);
            resultSet.addAll(comRoleList);
            resultSet.addAll((Collection)bizComRoleIDsFuture.get());
            CacheMrg.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(resultSet));
            return resultSet;
        }
        catch (Exception e) {
            log.warn("bos-permission-cache_UserRoleCache_reloadUserRoles,\u83b7\u53d6\u4e1a\u52a1\u89d2\u8272\u5305\u542b\u7684\u901a\u7528\u89d2\u8272\u5f02\u5e38", (Throwable)e);
            return resultSet;
        }
    }

    @Deprecated
    public static Set<String> getComRolesByUserIdAndDimtype(Long userId, String dimType) {
        return UserHelper.getCommRoleIds(userId, dimType, null, null, null);
    }

    public static Set<String> getRolesByUserIdAndDimtype(final Long userId, final String dimType) {
        Set<String> resultSet = new HashSet<String>(8);
        try {
            String cacheType = CacheMrg.getType4UserOwnCommRoleIds();
            String cacheKey = userId + "_" + dimType;
            String cachedStr = CacheMrg.getCache(cacheType, cacheKey);
            if (StringUtils.isNotEmpty((String)cachedStr)) {
                resultSet = (Set)SerializationUtils.fromJsonString((String)cachedStr, Set.class);
                return resultSet;
            }
            if (IsoDimHelper.addDimTypeFilter(dimType)) {
                Callable<Set<String>> bizComRoleIDsCallable = new Callable<Set<String>>(){

                    @Override
                    public Set<String> call() throws Exception {
                        return BizRoleService.getCommRoleIdsByUserIDAndDimId(userId, null, dimType);
                    }
                };
                Future bizComRoleIDsFuture = pool.submit((Callable)bizComRoleIDsCallable, RequestContext.get());
                Set<String> comRoleList = UserHelper.getCommRoleIds(userId, dimType, null, null, null);
                resultSet.addAll(comRoleList);
                resultSet.addAll((Collection)bizComRoleIDsFuture.get());
            } else {
                resultSet = UserRoleCache.getRolesByUserId(userId);
            }
            CacheMrg.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(resultSet));
            return resultSet;
        }
        catch (Exception e) {
            log.warn("UserRoleCache.getRolesByUserIdAndDimtype error", (Throwable)e);
            return resultSet;
        }
    }

    public static Set<String> getRolesByUserId(Long userId, List<Long> dimObjIds, String dimType) {
        return UserRoleCache.getRolesByUserId(userId, dimObjIds, dimType, "15");
    }

    public static Set<String> getRolesByUserId(final Long userId, List<Long> dimObjIds, String dimType, String orgViewNum) {
        HashSet<String> result = new HashSet<String>(100);
        List<Object> dimObjIdsTempParam = new ArrayList(8);
        if (dimObjIds != null && !dimObjIds.isEmpty()) {
            dimObjIdsTempParam = new ArrayList<Long>(dimObjIds);
            dimObjIdsTempParam = dimObjIdsTempParam.stream().filter(p -> p != null && !p.equals(0L)).collect(Collectors.toList());
        }
        final ArrayList dimObjIdsNewParam = dimObjIdsTempParam;
        if (PermCommonUtil.isEnableSingleBizRole()) {
            String bizRoleId = UserBizRoleCache.getSelBizRole(userId);
            if (StringUtils.isEmpty((String)bizRoleId)) {
                return new HashSet<String>();
            }
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            qFilterList.add(new QFilter("id", "=", (Object)Long.valueOf(bizRoleId)));
            Map resultMap = BusinessDataServiceHelper.loadFromCache((String)"perm_bizrole", (String)"bizrolecomrole.role", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
            if (CollectionUtils.isEmpty((Map)resultMap)) {
                result = new HashSet();
            } else {
                result = new HashSet(resultMap.size());
                for (DynamicObject dObj : resultMap.values()) {
                    DynamicObjectCollection doc = dObj.getDynamicObjectCollection("bizrolecomrole");
                    for (DynamicObject roleDObj : doc) {
                        result.add(roleDObj.getString("role.id"));
                    }
                }
            }
            return result;
        }
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimType, true);
        dimType = suitableDimType[1];
        if (dimObjIdsNewParam.isEmpty()) {
            return UserRoleCache.getRolesByUserIdAndDimtype(userId, dimType);
        }
        HashSet allSuperiorOrgs = new HashSet();
        Map orgMap = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgViewNum, dimObjIdsNewParam);
        for (Long orgId : dimObjIdsNewParam) {
            List tempSuperiorOrgs = (List)orgMap.get(orgId);
            if (CollectionUtils.isEmpty((Collection)tempSuperiorOrgs)) continue;
            allSuperiorOrgs.addAll(tempSuperiorOrgs);
        }
        final ArrayList<Long> allSupOrgList = new ArrayList<Long>();
        allSupOrgList.addAll(allSuperiorOrgs);
        final String finalDimType = dimType;
        Callable<Set<String>> bizComRoleSetCallable = new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                return BizRoleService.getCommRoleIdsByUserIDAndDimIds(userId, dimObjIdsNewParam, finalDimType);
            }
        };
        Future bizComRoleSetFuture = pool.submit((Callable)bizComRoleSetCallable, RequestContext.get());
        Callable<Set<String>> supbizComRoleSetCallable = new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                return BizRoleService.getCommRoleIdsByUserIDAndDimIdWithSup(userId, allSupOrgList, finalDimType);
            }
        };
        Future supbizComRoleSetFuture = pool.submit((Callable)supbizComRoleSetCallable, RequestContext.get());
        Callable<Set<String>> comRoleSetCallable = new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                return UserHelper.getCommRoleIds(userId, finalDimType, dimObjIdsNewParam, null, null);
            }
        };
        Future comRoleSetFuture = pool.submit((Callable)comRoleSetCallable, RequestContext.get());
        Set<String> supComRoleSet = UserRoleCache.getComRoleIdsByUserIDAndDimIdsWithSup(userId, allSupOrgList, finalDimType);
        try {
            result.addAll(supComRoleSet);
            result.addAll((Collection)bizComRoleSetFuture.get());
            result.addAll((Collection)supbizComRoleSetFuture.get());
            result.addAll((Collection)comRoleSetFuture.get());
        }
        catch (Exception e) {
            log.warn("bos-permission-cache_UserRoleCache_getRolesByUserId,\u83b7\u53d6\u4e1a\u52a1\u89d2\u8272\u5305\u542b\u7684\u901a\u7528\u89d2\u8272\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    private static Set<String> getComRoleIdsByUserIDAndDimIdsWithSup(Long userId, List<Long> superiorOrg, String dimType) {
        if (CollectionUtils.isEmpty(superiorOrg)) {
            return new HashSet<String>(1);
        }
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getRoleIdSet");
        commParam.put("userId", userId);
        commParam.put("dimTypeList", IsoDimHelper.addDimTypeFilter(dimType) ? Collections.singletonList(dimType) : new ArrayList(1));
        commParam.put("dimIdList", null != superiorOrg && !superiorOrg.isEmpty() ? new ArrayList(1) : superiorOrg);
        commParam.put("includeSub", "1");
        commParam.put("orgView", null);
        commParam.put("enable", "1");
        commParam.put("selectTSecUserGroupStaff", "1");
        commParam.put("selectTPermRole", "1");
        Map<String, Object> superOrgDimCommMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (CollectionUtils.isEmpty(superOrgDimCommMap)) {
            return new HashSet<String>(1);
        }
        Set roleIdSet = (Set)superOrgDimCommMap.get("roleIdSet");
        if (CollectionUtils.isEmpty((Collection)roleIdSet)) {
            return new HashSet<String>(1);
        }
        return (Set)superOrgDimCommMap.get("roleIdSet");
    }

    @Deprecated
    private static Set<String> getComRoleIdsByUserIDAndDimIds(Long userId, List<Long> dimIDs, String dimType) {
        return UserHelper.getCommRoleIds(userId, dimType, dimIDs, null, null);
    }

    public static Set<String> getRolesByUserId(final Long userId, final List<Long> dimObjIds, String dimType, boolean containRole, boolean containBizRole) {
        if (PermCommonUtil.isEnableSingleBizRole()) {
            String bizRoleId = UserBizRoleCache.getSelBizRole(userId);
            if (StringUtils.isEmpty((String)bizRoleId)) {
                return new HashSet<String>(1);
            }
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
            qFilterList.add(new QFilter("id", "=", (Object)Long.valueOf(bizRoleId)));
            Map resultMap = BusinessDataServiceHelper.loadFromCache((String)"perm_bizrole", (String)"bizrolecomrole.role", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
            if (CollectionUtils.isEmpty((Map)resultMap)) {
                return new HashSet<String>(1);
            }
            HashSet<String> result = new HashSet<String>(resultMap.size());
            for (DynamicObject dObj : resultMap.values()) {
                DynamicObjectCollection doc = dObj.getDynamicObjectCollection("bizrolecomrole");
                for (DynamicObject roleDObj : doc) {
                    result.add(roleDObj.getString("role.id"));
                }
            }
            return result;
        }
        if (!containRole && !containBizRole) {
            return new HashSet<String>(1);
        }
        HashSet<String> result = new HashSet<String>(100);
        HashSet allSuperiorOrgs = new HashSet();
        if (!CollectionUtils.isEmpty(dimObjIds)) {
            Map orgMap = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"15", dimObjIds);
            for (Long orgId : dimObjIds) {
                List tempSuperiorOrgs = (List)orgMap.get(orgId);
                if (CollectionUtils.isEmpty((Collection)tempSuperiorOrgs)) continue;
                allSuperiorOrgs.addAll(tempSuperiorOrgs);
            }
        }
        final ArrayList allSupOrgList = new ArrayList();
        allSupOrgList.addAll(allSuperiorOrgs);
        Future comRoleSetFuture = null;
        Future supComRoleSetFuture = null;
        Future bizComRoleSetFuture = null;
        Future supbizComRoleSetFuture = null;
        if ("DIM_NULL".equals(dimType)) {
            dimType = "bos_org";
        }
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimType);
        final String finalDimType = dimType = suitableDimType[1];
        if (containRole) {
            Callable<Set<String>> comRoleSetCallable = new Callable<Set<String>>(){

                @Override
                public Set<String> call() throws Exception {
                    return UserHelper.getCommRoleIds(userId, finalDimType, dimObjIds, null, null);
                }
            };
            comRoleSetFuture = pool.submit((Callable)comRoleSetCallable, RequestContext.get());
            Callable<Set<String>> supComRoleSetCallable = new Callable<Set<String>>(){

                @Override
                public Set<String> call() throws Exception {
                    return UserRoleCache.getComRoleIdsByUserIDAndDimIdsWithSup(userId, allSupOrgList, finalDimType);
                }
            };
            supComRoleSetFuture = pool.submit((Callable)supComRoleSetCallable, RequestContext.get());
        }
        if (containBizRole) {
            Callable<Set<String>> bizComRoleSetCallable = new Callable<Set<String>>(){

                @Override
                public Set<String> call() throws Exception {
                    return BizRoleService.getCommRoleIdsByUserIDAndDimIds(userId, dimObjIds, finalDimType);
                }
            };
            bizComRoleSetFuture = pool.submit((Callable)bizComRoleSetCallable, RequestContext.get());
            Callable<Set<String>> supbizComRoleSetCallable = new Callable<Set<String>>(){

                @Override
                public Set<String> call() throws Exception {
                    return BizRoleService.getCommRoleIdsByUserIDAndDimIdWithSup(userId, allSupOrgList, finalDimType);
                }
            };
            supbizComRoleSetFuture = pool.submit((Callable)supbizComRoleSetCallable, RequestContext.get());
        }
        try {
            if (comRoleSetFuture != null) {
                result.addAll((Collection)comRoleSetFuture.get());
            }
            if (supComRoleSetFuture != null) {
                result.addAll((Collection)supComRoleSetFuture.get());
            }
            if (bizComRoleSetFuture != null) {
                result.addAll((Collection)bizComRoleSetFuture.get());
            }
            if (supbizComRoleSetFuture != null) {
                result.addAll((Collection)supbizComRoleSetFuture.get());
            }
        }
        catch (Exception e) {
            log.warn("bos-permission-cache_UserRoleCache_getRolesByUserId,\u83b7\u53d6\u4e1a\u52a1\u89d2\u8272\u5305\u542b\u7684\u901a\u7528\u89d2\u8272\u5f02\u5e38", (Throwable)e);
        }
        return result;
    }

    public static List<RoleInfo> getRoleInfos(long userId, long orgId) {
        Set<String> roleIds = UserRoleCache.getRoles(userId, orgId);
        ArrayList<RoleInfo> roleList = new ArrayList<RoleInfo>();
        if (!CollectionUtils.isEmpty(roleIds)) {
            for (String id : roleIds) {
                RoleInfo roleInfo = RoleCache.getRoleInfoById(id);
                if (roleInfo == null) continue;
                roleList.add(roleInfo);
            }
        }
        return roleList;
    }

    public static Set<String> getRoles(Long pUserId, Long pOrgId) {
        return UserRoleCache.getRoles(pUserId, pOrgId, null);
    }

    public static Set<String> getRoles(Long pUserId, Long pOrgId, String orgViewId) {
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(pOrgId);
        return UserRoleCache.getRoles(pUserId, orgIds, orgViewId);
    }

    public static Set<String> getRoles(final Long pUserId, List<Long> pOrgIds, String pOrgViewId) {
        String roleId;
        Object roleDimIncludeSubMap;
        if (StringUtils.isEmpty((String)pOrgViewId)) {
            pOrgViewId = "15";
        }
        HashSet<String> result = new HashSet<String>();
        HashSet allSuperiorOrgs = new HashSet();
        Map orgMap_ = OrgUnitServiceHelper.getAllSuperiorOrgs((String)pOrgViewId, pOrgIds);
        for (Long orgId : pOrgIds) {
            List tempSuperiorOrgs = (List)orgMap_.get(orgId);
            if (CollectionUtils.isEmpty((Collection)tempSuperiorOrgs)) continue;
            allSuperiorOrgs.addAll(tempSuperiorOrgs);
        }
        Callable<Map<String, Map<Long, Boolean>>> bizComRoleMapCallable = new Callable<Map<String, Map<Long, Boolean>>>(){

            @Override
            public Map<String, Map<Long, Boolean>> call() throws Exception {
                return BizRoleService.getComRoleDimObj(pUserId);
            }
        };
        Future bizComRoleMapFuture = pool.submit((Callable)bizComRoleMapCallable, RequestContext.get());
        HashMap roleIdOrgIncludeSubMap = new HashMap(8);
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getRoleDimIncludeSubMap");
        commParam.put("userId", pUserId);
        commParam.put("enable", "1");
        commParam.put("selectTSecUserGroupStaff", "1");
        commParam.put("selectTPermRole", "1");
        Map<String, Object> commRoleInfoMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (!CollectionUtils.isEmpty(commRoleInfoMap) && !CollectionUtils.isEmpty((Map)(roleDimIncludeSubMap = (Map)commRoleInfoMap.get("roleDimIncludeSubMap")))) {
            for (Map.Entry roleDimIncludeSub : roleDimIncludeSubMap.entrySet()) {
                roleId = (String)roleDimIncludeSub.getKey();
                Map dimIncludeSubMap = (Map)roleDimIncludeSub.getValue();
                dimIncludeSubMap.forEach((k, v) -> {
                    if (v.booleanValue()) {
                        roleIdOrgIncludeSubMap.computeIfAbsent(roleId, id -> new HashMap()).put(k, v);
                    } else {
                        roleIdOrgIncludeSubMap.computeIfAbsent(roleId, id -> new HashMap()).putIfAbsent(k, v);
                    }
                });
            }
        }
        for (Map.Entry entry : roleIdOrgIncludeSubMap.entrySet()) {
            String roleId2 = (String)entry.getKey();
            Map orgMap = (Map)entry.getValue();
            if (!orgMap.keySet().stream().anyMatch(orgid -> pOrgIds.contains(orgid) || allSuperiorOrgs.contains(orgid) && (Boolean)orgMap.get(orgid) != false)) continue;
            result.add(roleId2);
        }
        try {
            Map bizRoleIdOrgIncludeSubMap = (Map)bizComRoleMapFuture.get();
            for (Map.Entry bizRoleOrgEntry : bizRoleIdOrgIncludeSubMap.entrySet()) {
                roleId = (String)bizRoleOrgEntry.getKey();
                Map orgMap = (Map)bizRoleOrgEntry.getValue();
                if (!orgMap.keySet().stream().anyMatch(orgid -> pOrgIds.contains(orgid) || allSuperiorOrgs.contains(orgid) && (Boolean)orgMap.get(orgid) != false)) continue;
                result.add(roleId);
            }
        }
        catch (Exception e) {
            log.warn("bos-permission-cache_UserRoleCache_getRoles,\u83b7\u53d6\u4e1a\u52a1\u89d2\u8272\u5305\u542b\u7684\u901a\u7528\u89d2\u8272\u5f02\u5e38bizRoleIdOrgIncludeSubMap", (Throwable)e);
        }
        return result;
    }

    public static Map<Long, Set<String>> getOrgRoleAssignMap(final Long pUserId) {
        String roleId;
        Map roleDimIncludeSubMap;
        Callable<Map<String, Map<Long, Boolean>>> bizComRoleMapCallable = new Callable<Map<String, Map<Long, Boolean>>>(){

            @Override
            public Map<String, Map<Long, Boolean>> call() throws Exception {
                return BizRoleService.getComRoleDimObj(pUserId);
            }
        };
        Future bizComRoleOrgMapFuture = pool.submit((Callable)bizComRoleMapCallable, RequestContext.get());
        HashMap<Long, Set<String>> orgRoleAssignMap = new HashMap<Long, Set<String>>();
        HashSet<Long> orgIncludeSubOrg = new HashSet<Long>();
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getRoleDimIncludeSubMap");
        commParam.put("userId", pUserId);
        commParam.put("selectTSecUserGroupStaff", "1");
        Map<String, Object> commRoleInfoMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (!CollectionUtils.isEmpty(commRoleInfoMap) && !CollectionUtils.isEmpty((Map)(roleDimIncludeSubMap = (Map)commRoleInfoMap.get("roleDimIncludeSubMap")))) {
            for (Map.Entry roleDimIncludeSub : roleDimIncludeSubMap.entrySet()) {
                roleId = (String)roleDimIncludeSub.getKey();
                Map dimIncludeSubMap = (Map)roleDimIncludeSub.getValue();
                if (CollectionUtils.isEmpty((Map)dimIncludeSubMap)) continue;
                for (Map.Entry dimIncludeSub : dimIncludeSubMap.entrySet()) {
                    Long dimId = (Long)dimIncludeSub.getKey();
                    Boolean includeSub = (Boolean)dimIncludeSub.getValue();
                    orgRoleAssignMap.computeIfAbsent(dimId, k -> new HashSet()).add(roleId);
                    if (!includeSub.booleanValue()) continue;
                    orgIncludeSubOrg.add(dimId);
                }
            }
        }
        try {
            Map bizComRoleOrgMap = (Map)bizComRoleOrgMapFuture.get();
            for (Map.Entry bizComRoleOrgEntry : bizComRoleOrgMap.entrySet()) {
                roleId = (String)bizComRoleOrgEntry.getKey();
                Map orgMap = (Map)bizComRoleOrgEntry.getValue();
                orgMap.forEach((k, v) -> {
                    orgRoleAssignMap.computeIfAbsent((Long)k, key -> new HashSet(10)).add(roleId);
                    if (v.booleanValue()) {
                        orgIncludeSubOrg.add((Long)k);
                    }
                });
            }
        }
        catch (Exception e) {
            log.warn("bos-permission-cache_UserRoleCache_getOrgRoleAssignMap,\u83b7\u53d6\u4e1a\u52a1\u89d2\u8272\u5305\u542b\u7684\u901a\u7528\u89d2\u8272\u4e0e\u7ec4\u7ec7\u7684map\u5f02\u5e38bizComRoleMapFuture", (Throwable)e);
        }
        for (Long curOrgId : orgIncludeSubOrg) {
            Set roleIds = (Set)orgRoleAssignMap.get(curOrgId);
            List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), Collections.singletonList(curOrgId), (boolean)false, (boolean)true);
            if (allSubordinateOrgs == null || allSubordinateOrgs.size() == 0) continue;
            for (Long subOrgId : allSubordinateOrgs) {
                orgRoleAssignMap.computeIfAbsent(subOrgId, k -> new HashSet()).addAll(roleIds);
            }
        }
        return orgRoleAssignMap;
    }

    public static List<Long> getUsersByRoleId(String roleId) {
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getUserIdSet");
        commParam.put("roleIdList", Collections.singletonList(roleId));
        commParam.put("selectTSecUserGroupStaff", "1");
        commParam.put("selectTPermRole", "1");
        Map<String, Object> commRoleInfoMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (CollectionUtils.isEmpty(commRoleInfoMap)) {
            return new ArrayList<Long>(1);
        }
        Set userIdSet = (Set)commRoleInfoMap.get("userIdSet");
        if (CollectionUtils.isEmpty((Collection)userIdSet)) {
            return new ArrayList<Long>(1);
        }
        return new ArrayList<Long>(userIdSet);
    }

    public static List<Long> getUsersByRoleNum(String roleNum) {
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getUserIdSet");
        commParam.put("roleNumberList", Collections.singletonList(roleNum));
        commParam.put("selectTSecUserGroupStaff", "1");
        commParam.put("selectTPermRole", "1");
        Map<String, Object> commRoleInfoMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (CollectionUtils.isEmpty(commRoleInfoMap)) {
            return new ArrayList<Long>(1);
        }
        Set userIdSet = (Set)commRoleInfoMap.get("userIdSet");
        if (CollectionUtils.isEmpty((Collection)userIdSet)) {
            return new ArrayList<Long>(1);
        }
        return new ArrayList<Long>(userIdSet);
    }
}

