/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.permission.model.perm.admingroup.AdmGrpFunperm;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AdminDomainHelper {
    private static final Log logger = LogFactory.getLog(AdminDomainHelper.class);

    public static Map<Long, Set<String>> getDomainIdAppIdSetMap(Set<Long> domainIdSet) {
        HashMap<Long, Set<String>> resultMap = new HashMap<Long, Set<String>>(8);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != domainIdSet && !domainIdSet.isEmpty()) {
            qFilterList.add(new QFilter("id", "in", domainIdSet));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AdminDomainHelper.getDomainIdAppIdSetMap", (String)"perm_admindomain", (String)"id, entryentity.app", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                resultMap.computeIfAbsent(row.getLong("id"), k -> new HashSet(8)).add(row.getString("entryentity.app"));
            }
        }
        return resultMap;
    }

    public static Map<Long, Set<AdmGrpFunperm>> getDomainIdAdmGrpFunpermSetMap(Set<Long> domainIdSet, AdmGroup curAdmGroup) {
        HashMap<Long, Set<AdmGrpFunperm>> map = new HashMap<Long, Set<AdmGrpFunperm>>(8);
        if (null == curAdmGroup) {
            curAdmGroup = new AdmGroup();
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != domainIdSet && !domainIdSet.isEmpty()) {
            qFilterList.add(new QFilter("id", "in", domainIdSet));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AdminDomainHelper.getDomainIdAdmGrpFunpermSetMap", (String)"perm_admindomain", (String)"id, entryentity.app_id, entryentity.app.number, entryentity.app.name, entryentity.entity_id, entryentity.entity.name, entryentity.permitem_id, entryentity.permitem.number, entryentity.permitem.name", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");){
            AdmGrpFunperm one = null;
            while (ds.hasNext()) {
                Row row = ds.next();
                Long adminGroupId = curAdmGroup.getId();
                String adminGroupNum = curAdmGroup.getNumber();
                String adminGroupName = curAdmGroup.getName();
                String app_id = row.getString("entryentity.app_id");
                String entitynum_id = row.getString("entryentity.entity_id");
                String permitem_id = row.getString("entryentity.permitem_id");
                one = new AdmGrpFunperm(row.getLong("id"), adminGroupId, adminGroupNum, adminGroupName, app_id, row.getString("entryentity.app.number"), row.getString("entryentity.app.name"), entitynum_id, row.getString("entryentity.entity.name"), permitem_id, row.getString("entryentity.permitem.number"), row.getString("entryentity.permitem.name"));
                map.computeIfAbsent(row.getLong("id"), k -> new HashSet(8)).add(one);
            }
        }
        return map;
    }
}

