/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.perm.AdmGroup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AdminGroupHelper {
    private static Log logger = LogFactory.getLog(AdminGroupHelper.class);

    public static Set<Long> getAdmOrgAddUserIds(Long adminGroupId) {
        Map<Long, Set<Long>> admOrgAddUserIdSetMap = AdminGroupHelper.getAdmOrgAddUserIdSetMap(Sets.newHashSet((Object[])new Long[]{adminGroupId}));
        return null == admOrgAddUserIdSetMap || null == admOrgAddUserIdSetMap.get(adminGroupId) ? new HashSet<Long>(0) : admOrgAddUserIdSetMap.get(adminGroupId);
    }

    public static Map<Long, Set<Long>> getAdmOrgAddUserIdSetMap(Set<Long> adminGroupIdSet) {
        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>(10);
        if (null != qfilterList && !qfilterList.isEmpty()) {
            qfilterList.add(new QFilter("usergroup", "in", adminGroupIdSet));
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AdminGroupHelper.getAdmOrgAddUserIdSetMap", (String)"perm_admingroupadduser", (String)"usergroup, user", (QFilter[])qfilterList.toArray(qfilterList.toArray(new QFilter[qfilterList.size()])), (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long adminGroupId = row.getLong("usergroup");
                Long userId = row.getLong("user");
                map.computeIfAbsent(adminGroupId, k -> new HashSet(8)).add(userId);
            }
        }
        return map;
    }

    public static Set<Long> getAdminUserIds(Long adminGroupId) {
        Map<Long, Set<Long>> map = AdminGroupHelper.getAdmGrpUserIdSetMap(Sets.newHashSet((Object[])new Long[]{adminGroupId}), false);
        return null == map || null == map.get(adminGroupId) ? new HashSet<Long>(0) : map.get(adminGroupId);
    }

    public static Map<Long, Set<Long>> getAdmGrpUserIdSetMap(Set<Long> adminGroupIdSet, boolean includeAdmGrpAdduser) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(8);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"AdminGroupHelper.getAdmGrpUserIdSetMap", (String)"perm_useradmingroup", (String)"usergroup, user", (QFilter[])new QFilter[]{new QFilter("usergroup", "in", adminGroupIdSet)}, (String)"");
        Object object = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                Long adminGroupId = row.getLong("usergroup");
                Long userId = row.getLong("user");
                map.computeIfAbsent(adminGroupId, k -> new HashSet(8)).add(userId);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (includeAdmGrpAdduser) {
            Map<Long, Set<Long>> admOrgAddUserIdSetMap = AdminGroupHelper.getAdmOrgAddUserIdSetMap(adminGroupIdSet);
            for (Map.Entry entry : admOrgAddUserIdSetMap.entrySet()) {
                map.computeIfAbsent((Long)entry.getKey(), (Function<Long, Set<Long>>)((Function<Long, Set>)k -> new HashSet(8))).addAll((Collection)entry.getValue());
            }
        }
        return map;
    }

    public static Set<Long> getAllAdminGrpIdSet() {
        StringBuilder sb = new StringBuilder();
        sb.append("select fid from t_perm_admingroup");
        return (Set)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> result = new HashSet<Long>(8);
                while (rs.next()) {
                    result.add(rs.getLong("fid"));
                }
                return result;
            }
        });
    }

    @Deprecated
    public static Map<Long, AdmGroup> getAdmGroupMap() {
        return AdminGroupHelper.getAdmGroupInfoMap(null);
    }

    public static Map<Long, AdmGroup> getAdmGroupInfoMap(Set<Long> admGrpIdSet) {
        DynamicObject[] perm_admingroups;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != admGrpIdSet && !admGrpIdSet.isEmpty()) {
            qFilterList.add(new QFilter("id", "in", admGrpIdSet));
        }
        if (null == (perm_admingroups = BusinessDataServiceHelper.load((String)"perm_admingroup", (String)"id, number, name, parent_id, level, isleaf, longnumber, adminscheme_id, admintype_id, isdomain, domain_id, description", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]))) || Objects.equals(0, perm_admingroups.length)) {
            return new HashMap<Long, AdmGroup>(1);
        }
        HashMap<Long, AdmGroup> map = new HashMap<Long, AdmGroup>(perm_admingroups.length);
        AdmGroup admGrp = null;
        for (DynamicObject one : perm_admingroups) {
            admGrp = new AdmGroup();
            long id = one.getLong("id");
            admGrp.setId(Long.valueOf(id));
            admGrp.setName(one.getString("name"));
            admGrp.setNumber(one.getString("number"));
            admGrp.setParent(Long.valueOf(one.getLong("parent_id")));
            admGrp.setLevel(Integer.valueOf(one.getInt("level")));
            admGrp.setLeaf(one.getBoolean("isleaf"));
            admGrp.setLongNum(one.getString("longnumber"));
            admGrp.setAdminScheme(Long.valueOf(one.getLong("adminscheme_id")));
            admGrp.setAdminType(Long.valueOf(one.getLong("admintype_id")));
            admGrp.setDomainGroup(one.getBoolean("isdomain"));
            admGrp.setDomain(Long.valueOf(one.getLong("domain_id")));
            admGrp.setDescription(one.getString("description"));
            map.put(id, admGrp);
        }
        return map;
    }

    public static Map<Long, Set<Long>> getGrpIdAllSuper(Set<Long> admGrpIdSet, boolean includeSelf) {
        String longnumber;
        DynamicObject[] perm_admingroups;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != admGrpIdSet && !admGrpIdSet.isEmpty()) {
            qFilterList.add(new QFilter("id", "in", admGrpIdSet));
        }
        if (null == (perm_admingroups = BusinessDataServiceHelper.load((String)"perm_admingroup", (String)"id, longnumber", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]))) || Objects.equals(0, perm_admingroups.length)) {
            return new HashMap<Long, Set<Long>>(0);
        }
        HashMap<Long, LinkedHashSet> grpIdLongNumSetMap = new HashMap<Long, LinkedHashSet>(perm_admingroups.length);
        block9: for (DynamicObject one : perm_admingroups) {
            long l = one.getLong("id");
            longnumber = one.getString("longnumber");
            if (0L == l || StringUtils.isEmpty((String)longnumber)) continue;
            if (includeSelf) {
                grpIdLongNumSetMap.computeIfAbsent(l, k -> new LinkedHashSet(8)).add(longnumber);
            }
            while (true) {
                if (-1 == longnumber.indexOf(46)) {
                    grpIdLongNumSetMap.computeIfAbsent(l, k -> new LinkedHashSet(8)).add(longnumber);
                    continue block9;
                }
                String parentLongNum = longnumber.substring(0, longnumber.lastIndexOf(46));
                if (StringUtils.isEmpty((String)parentLongNum)) continue block9;
                grpIdLongNumSetMap.computeIfAbsent(l, k -> new LinkedHashSet(8)).add(parentLongNum);
                longnumber = parentLongNum;
            }
        }
        Set longNumSet = grpIdLongNumSetMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (null == longNumSet || longNumSet.isEmpty()) {
            return new HashMap<Long, Set<Long>>(0);
        }
        HashMap<String, Long> longNumGrpIdMap = new HashMap<String, Long>(8);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"AdminGroupHelper.getGrpIdAllSuper", (String)"perm_admingroup", (String)"id, longnumber", (QFilter[])new QFilter[]{new QFilter("longnumber", "in", longNumSet)}, (String)"");
        Object object = null;
        try {
            while (ds.hasNext()) {
                Row row = ds.next();
                Long id = row.getLong("id");
                longnumber = row.getString("longnumber");
                longNumGrpIdMap.put(longnumber, id);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(perm_admingroups.length);
        for (Map.Entry entry : grpIdLongNumSetMap.entrySet()) {
            Long grpId = (Long)entry.getKey();
            Set longNums = (Set)entry.getValue();
            if (null == grpId || Objects.equals(0L, grpId) || null == longNums || longNums.isEmpty()) continue;
            for (String longNum : longNums) {
                Long id = (Long)longNumGrpIdMap.get(longNum);
                if (null == id || Objects.equals(0L, id)) continue;
                map.computeIfAbsent(grpId, k -> new HashSet(8)).add(id);
            }
        }
        return map;
    }

    public static Map<Long, Set<Long>> getBizunitOrOrgRangeMap(String viewType, Set<Long> admGroupIdSet) {
        String table = null;
        table = "01".equals(viewType) ? "t_perm_admingrouporg" : "t_perm_admingroupbizunit";
        StringBuilder sb = new StringBuilder();
        sb.append("select forgid, fusergroupid from ").append(table);
        sb.append(" where 1=1 ");
        if (null != admGroupIdSet && !admGroupIdSet.isEmpty()) {
            List admGroupIdList = admGroupIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            String admGroupIdListStr = String.join((CharSequence)",", admGroupIdList);
            sb.append(" and fusergroupid in (").append(admGroupIdListStr).append(")");
        }
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Map<Long, Set<Long>>>(){

            public Map<Long, Set<Long>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(8);
                while (rs.next()) {
                    Long orgId = rs.getLong("forgid");
                    Long fusergroupid = rs.getLong("fusergroupid");
                    map.computeIfAbsent(fusergroupid, k -> new HashSet(8)).add(orgId);
                }
                return map;
            }
        });
    }

    @Deprecated
    public static void checkUserAdminGroupPerm(String parentPageId, Long adminGroupId, String msg, OperationStatus operationStatus) {
        if (StringUtils.isEmpty((String)parentPageId) || null == adminGroupId || Objects.equals(0L, adminGroupId) || null == operationStatus) {
            throw new KDBizException(msg);
        }
        IFormView view = SessionManager.getCurrent().getViewNoPlugin(parentPageId);
        if (null == view) {
            throw new KDBizException(msg);
        }
        IPageCache pageCache = view.getPageCache();
        if (null == pageCache) {
            throw new KDBizException(msg);
        }
        String superiorGroupIds = pageCache.get("superiorGroupIds");
        String adminGroupCanSee = pageCache.get("adminGroupCanSee");
        if (StringUtils.isEmpty((String)superiorGroupIds) || StringUtils.isEmpty((String)adminGroupCanSee)) {
            throw new KDBizException(msg);
        }
        List superiorGroupId = (List)SerializationUtils.fromJsonString((String)superiorGroupIds, List.class);
        List adminGroupIdCanSee = (List)SerializationUtils.fromJsonString((String)adminGroupCanSee, List.class);
        if (null == superiorGroupId || superiorGroupId.isEmpty() || null == adminGroupIdCanSee || adminGroupIdCanSee.isEmpty()) {
            throw new KDBizException(msg);
        }
        Sets.SetView canGroupIdSet = new HashSet(8);
        if (OperationStatus.VIEW == operationStatus) {
            canGroupIdSet = new HashSet(adminGroupIdCanSee);
        } else if (OperationStatus.EDIT == operationStatus) {
            canGroupIdSet = Sets.difference(new HashSet(adminGroupIdCanSee), new HashSet(superiorGroupId));
        }
        if (null == canGroupIdSet || canGroupIdSet.isEmpty()) {
            throw new KDBizException(msg);
        }
        if (!canGroupIdSet.contains(adminGroupId)) {
            throw new KDBizException(msg);
        }
    }

    public static Map<String, Set<AdmGroup>> getAdminGrpMap(Set<String> idOrNumberOrNameSet, String keyType) {
        HashMap<String, Set<AdmGroup>> map = new HashMap<String, Set<AdmGroup>>(8);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("id", keyType)) {
            qFilterList.add(new QFilter("id", "in", idOrNumberOrNameSet.stream().map(Long::valueOf).collect(Collectors.toSet())));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("number", keyType)) {
            qFilterList.add(new QFilter("number", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("name", keyType)) {
            qFilterList.add(new QFilter("name", "in", idOrNumberOrNameSet));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AdminGroupHelper.getAdminGrpMap", (String)"perm_admingroup", (String)"id, number, name", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");){
            AdmGroup one = null;
            while (ds.hasNext()) {
                Row row = ds.next();
                one = new AdmGroup();
                Long id = row.getLong("id");
                String number = row.getString("number");
                String name = row.getString("name");
                one.setId(id);
                one.setNumber(number);
                one.setName(name);
                if (Objects.equals("id", keyType)) {
                    map.computeIfAbsent(String.valueOf(id), k -> new HashSet()).add(one);
                    continue;
                }
                if (Objects.equals("name", keyType)) {
                    map.computeIfAbsent(name, k -> new HashSet()).add(one);
                    continue;
                }
                if (!Objects.equals("number", keyType)) continue;
                map.computeIfAbsent(number, k -> new HashSet()).add(one);
            }
        }
        return map;
    }

    public static AdmGroup getNumSmallest(Set<String> nameSet) {
        if (null == nameSet || nameSet.isEmpty()) {
            return null;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("name", "in", nameSet));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"perm_admingroup", (String)"id, name, number", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"number asc", (int)1);
        if (null == doc || doc.isEmpty()) {
            return null;
        }
        DynamicObject dyn = (DynamicObject)doc.get(0);
        AdmGroup one = new AdmGroup();
        Long id = dyn.getLong("id");
        String number = dyn.getString("number");
        String name = dyn.getString("name");
        one.setId(id);
        one.setNumber(number);
        one.setName(name);
        return one;
    }

    public static Map<String, Set<AdmGroup>> getAdmGrpMap(Long userId, String keyType) {
        HashMap<String, Set<AdmGroup>> map = new HashMap<String, Set<AdmGroup>>(8);
        DynamicObject adminSchemeObj = QueryServiceHelper.queryOne((String)"perm_adminscheme", (String)"id", (QFilter[])new QFilter("enable", "=", (Object)Character.valueOf('1')).toArray());
        if (null == adminSchemeObj) {
            return map;
        }
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"perm_useradmingroup", (String)"usergroup.id, usergroup.name, usergroup.number", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId), new QFilter("usergroup.adminscheme", "=", (Object)adminSchemeObj.getLong("id"))});
        if (doc == null || doc.isEmpty()) {
            return map;
        }
        AdmGroup one = null;
        for (DynamicObject dyn : doc) {
            one = new AdmGroup();
            Long id = dyn.getLong("usergroup.id");
            String number = dyn.getString("usergroup.number");
            String name = dyn.getString("usergroup.name");
            one.setId(id);
            one.setNumber(number);
            one.setName(name);
            if (Objects.equals("name", keyType)) {
                map.computeIfAbsent(name, k -> new HashSet()).add(one);
                continue;
            }
            if (!Objects.equals("number", keyType)) continue;
            map.computeIfAbsent(number, k -> new HashSet()).add(one);
        }
        return map;
    }

    public static Map<String, Set<AdmGroup>> getAdmGrpF7Map(String keyType, Set<Long> excludeIdSet) {
        Map adminGroupIdMap;
        HashMap<String, Set<AdmGroup>> map = new HashMap<String, Set<AdmGroup>>(8);
        if (null == excludeIdSet) {
            excludeIdSet = new HashSet<Long>(8);
        }
        if ((adminGroupIdMap = BusinessDataServiceHelper.loadFromCache((String)"perm_admingroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("parent", "=", (Object)0), new QFilter("level", "=", (Object)1)})) != null && !adminGroupIdMap.isEmpty()) {
            excludeIdSet.addAll(adminGroupIdMap.keySet().stream().map(k -> (Long)k).collect(Collectors.toSet()));
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != excludeIdSet && !excludeIdSet.isEmpty()) {
            qFilterList.add(new QFilter("id", "not in", excludeIdSet));
        }
        DynamicObject[] dynArr = BusinessDataServiceHelper.load((String)"perm_admingroup", (String)"id, number, name", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
        AdmGroup one = null;
        for (DynamicObject dyn : dynArr) {
            one = new AdmGroup();
            Long id = dyn.getLong("id");
            String number = dyn.getString("number");
            String name = dyn.getString("name");
            one.setId(id);
            one.setNumber(number);
            one.setName(name);
            if (Objects.equals("name", keyType)) {
                map.computeIfAbsent(name, k -> new HashSet()).add(one);
                continue;
            }
            if (!Objects.equals("number", keyType)) continue;
            map.computeIfAbsent(number, k -> new HashSet()).add(one);
        }
        return map;
    }
}

