/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.AdminType;
import kd.bos.permission.model.perm.admingroup.AdmGrpFunperm;
import kd.bos.permission.model.perm.resp.admin.AdmGrpHasPermResp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AdminSchemeHelper {
    private static Log logger = LogFactory.getLog(AdminSchemeHelper.class);

    public static Long getCurEnableSchemeId() {
        DynamicObject curEnableScheme = AdminSchemeHelper.getCurEnableScheme();
        if (null == curEnableScheme) {
            return 0L;
        }
        return curEnableScheme.getLong("id");
    }

    public static Long getCurUserSchemeAdminType(Long curEnableSchemeId) {
        long currUserId = RequestContext.get().getCurrUserId();
        Long l = curEnableSchemeId = null == curEnableSchemeId ? AdminSchemeHelper.getCurEnableSchemeId() : curEnableSchemeId;
        if (null == curEnableSchemeId || Objects.equals(0L, curEnableSchemeId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u6570\u636e\u5f02\u5e38\u6216\u5143\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u91cd\u65b0\u5347\u7ea7\u7ba1\u7406\u5458\u6570\u636e\u3002", (String)"AdminSchemeHelper_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        }
        QFilter[] filters = new QFilter[]{new QFilter("user.id", "=", (Object)currUserId).and("usergroup.adminscheme.id", "=", (Object)curEnableSchemeId)};
        DynamicObject[] userAdminGroup = BusinessDataServiceHelper.load((String)"perm_useradmingroup", (String)"user,usergroup", (QFilter[])filters);
        Long adminType = null;
        try {
            adminType = (Long)userAdminGroup[0].getDynamicObject("usergroup").get("admintype.id");
        }
        catch (Exception e) {
            logger.warn("AdminSchemeHelper.getCurUserSchemeAdminType, \u83b7\u53d6\u7528\u6237\u6240\u5c5e\u7ba1\u7406\u5458\u7ec4\u5931\u8d25\uff1a", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u7ec4\u6570\u636e\u5f02\u5e38\u6216\u5143\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u91cd\u65b0\u5347\u7ea7\u7ba1\u7406\u5458\u6570\u636e\u3002", (String)"AdminSchemeHelper_0", (String)"bos-permission-cache", (Object[])new Object[0]));
        }
        return adminType;
    }

    public static Set<Long> getTransAndOtherAdminTypeUserIds(Long adminSchemeId, Long adminType) {
        final HashSet<Long> userIds = new HashSet<Long>(8);
        String schemeFilterSql = " SELECT DISTINCT uap.fuserid FROM t_perm_useradmingroup uap  INNER JOIN t_perm_admingroup ug ON uap.fadmingroupid = ug.fid  WHERE ug.fadminscheme = ? AND (ug.fadmintype != ? or (ug.fadmintype = ? and ug.flevel = 1)) ";
        DB.query((DBRoute)DBRoute.base, (String)schemeFilterSql, (Object[])new Object[]{adminSchemeId, adminType, adminType}, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    Long userId = rs.getLong("fuserid");
                    userIds.add(userId);
                }
                return null;
            }
        });
        return userIds;
    }

    public static DynamicObject getCurEnableScheme() {
        DynamicObject enableScheme = BusinessDataServiceHelper.loadSingle((String)"perm_adminscheme", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)});
        return enableScheme;
    }

    public static Set<String> getCurEnableSchemeAdminTypeSet(Long schemeId) {
        HashSet<String> set = new HashSet<String>(8);
        if (null == schemeId || Objects.equals(0L, schemeId)) {
            DynamicObject curEnableScheme = AdminSchemeHelper.getCurEnableScheme();
            if (null == curEnableScheme) {
                return set;
            }
            schemeId = curEnableScheme.getLong("id");
            if (null == schemeId || Objects.equals(0L, schemeId)) {
                return set;
            }
        }
        try (DataSet dataSet = DB.queryDataSet((String)"AdminSchemeHelper.getCurEnableSchemeAdminTypeSet", (DBRoute)DBRoute.basedata, (String)"select fadmintype from t_perm_adminschemeentry where fid = ? ", (Object[])new Object[]{schemeId});){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                set.add(row.getString("fadmintype"));
            }
        }
        return set;
    }

    public static Map<String, String> getAdminTypeUserNameMap(Set<String> adminTagSet) {
        if (adminTagSet == null || adminTagSet.isEmpty()) {
            return new HashMap<String, String>(8);
        }
        StringBuilder sql = new StringBuilder("select uat.fadmintag,uu.fusername ").append("from t_perm_useradmintag uat ").append("join t_sec_user_u uu on uat.fuserid = uu.fid ").append("where uat.fadmintag in ");
        StringBuilder whereStr = new StringBuilder("(");
        for (String adminTag : adminTagSet) {
            whereStr.append("'").append(adminTag).append("',");
            whereStr.append("'").append(adminTag).append(' ').append("',");
        }
        whereStr.deleteCharAt(whereStr.length() - 1).append(")");
        sql.append((CharSequence)whereStr);
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql.toString(), resultSet -> {
            HashMap<String, String> result = new HashMap<String, String>(8);
            while (resultSet.next()) {
                result.put(resultSet.getString("fadmintag").trim(), resultSet.getString("fusername"));
            }
            return result;
        });
    }

    public static boolean checkVirtualAdminPerm(AdminType adminType, String appId, String entityNum, Set<String> permItemSet) {
        if (!PermCommonUtil.isInSysCloud(appId) && !PermCommonUtil.isAdminDomainApp(appId)) {
            return false;
        }
        boolean superAdminStrategy = PermCommonUtil.isSuperAdminStrategy();
        if (superAdminStrategy && PermCommonUtil.isInSysCloud(appId)) {
            return true;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select count(1) cnt from t_perm_adminscheme ads");
        sql.append(" inner join t_perm_adminschemeentry ent on (ads.fid = ent.fid)");
        sql.append(" inner join t_perm_adminschemedetail dtl on(ent.fentryid = dtl.fentryid)");
        sql.append(" where ads.fenable = '1'");
        sql.append(" and ent.fadmintype = ? ");
        sql.append(" and dtl.fbizappid = ? ");
        sql.append(" and dtl.fentitynum = ? ");
        if (!CollectionUtils.isEmpty(permItemSet)) {
            String permItemsStr = String.join((CharSequence)"','", permItemSet);
            sql.append(" and dtl.fpermitemid in ('").append(permItemsStr).append("')");
        }
        Boolean exists = (Boolean)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{new SqlParameter(":fadmintype", -5, (Object)Long.valueOf(adminType.toString())), new SqlParameter(":fbizappid", 12, (Object)appId), new SqlParameter(":fentitynum", 12, (Object)entityNum)}, (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                int count;
                if (rs.next() && (count = rs.getInt("cnt")) >= 1) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        return exists;
    }

    public static Set<String> batchCheckVirtualAdminPerm(AdminType adminType, String appId, String entityNum, Set<String> permItemSet) {
        if (CollectionUtils.isEmpty(permItemSet)) {
            return new HashSet<String>(0);
        }
        boolean superAdminStrategy = PermCommonUtil.isSuperAdminStrategy();
        if (superAdminStrategy) {
            return permItemSet;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select dtl.fpermitemid permitemid from t_perm_adminscheme ads");
        sql.append(" inner join t_perm_adminschemeentry ent on (ads.fid = ent.fid)");
        sql.append(" inner join t_perm_adminschemedetail dtl on(ent.fentryid = dtl.fentryid)");
        sql.append(" where ads.fenable = '1'");
        sql.append(" and ent.fadmintype = ? ");
        sql.append(" and dtl.fbizappid = ? ");
        sql.append(" and dtl.fentitynum = ? ");
        String permItemsStr = String.join((CharSequence)"','", permItemSet);
        sql.append(" and dtl.fpermitemid in ('").append(permItemsStr).append("')");
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{new SqlParameter(":fadmintype", -5, (Object)Long.valueOf(adminType.toString())), new SqlParameter(":fbizappid", 12, (Object)appId), new SqlParameter(":fentitynum", 12, (Object)entityNum)}, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> result = new HashSet<String>(16);
                while (rs.next()) {
                    String permItemId = rs.getString("permitemid");
                    result.add(permItemId);
                }
                return result;
            }
        });
    }

    public static boolean isAllVirAdminBindedContact(Long adminSchemeId) {
        if (null == adminSchemeId || 0L == adminSchemeId) {
            return false;
        }
        final HashSet<Long> userIdSet = new HashSet<Long>(8);
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fuserid from t_perm_useradmintag a ");
        sql.append(" inner join t_perm_adminschemeentry b on (a.fadmintag = b.fadmintype || '' or a.fadmintag = b.fadmintype || ' ') ");
        sql.append(" where b.fid = ? ");
        DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{adminSchemeId}, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    userIdSet.add(rs.getLong("fuserid"));
                }
                return null;
            }
        });
        logger.debug("AdminSchemeHelper_isAllVirAdminBindedContact:adminScheme_userId:" + userIdSet);
        if (CollectionUtils.isEmpty(userIdSet)) {
            return false;
        }
        List<User> userInfoByIds = UserHelper.getUserInfoByIds(userIdSet, RequestContext.get().getLang().toString());
        logger.debug("AdminSchemeHelper_isAllVirAdminBindedContact, userInfoByIds:{}", (Object)(CollectionUtils.isEmpty(userInfoByIds) ? "" : JSON.toJSONString(userInfoByIds)));
        if (CollectionUtils.isEmpty(userInfoByIds)) {
            return false;
        }
        Optional<User> first = userInfoByIds.stream().filter(x -> StringUtils.isEmpty((String)x.getFphone().trim()) && StringUtils.isEmpty((String)x.getFemail().trim())).findFirst();
        return !first.isPresent();
    }

    public static String queryAllSysAppSqlStr(boolean returnNum, boolean includeSpecificApp) {
        return AdminSchemeHelper.queryAllSysAppSqlStr(returnNum, includeSpecificApp, false);
    }

    public static String queryAllSysAppSqlStr(boolean returnNum, boolean includeSpecificApp, boolean includeExt) {
        List<String> allSysAppList = AdminSchemeHelper.queryAllSysApp(returnNum, includeSpecificApp, includeExt);
        if (allSysAppList == null || allSysAppList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String appUniqueId : allSysAppList) {
            if (StringUtils.isEmpty((String)appUniqueId)) continue;
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append("'").append(appUniqueId).append("'");
        }
        return sb.toString();
    }

    public static String queryAllSysAppStr(boolean returnNum, boolean includeSpecificApp) {
        List<String> queryAllSysApp = AdminSchemeHelper.queryAllSysApp(returnNum, includeSpecificApp);
        String finalAppStr = String.join((CharSequence)",", queryAllSysApp);
        return finalAppStr;
    }

    public static List<String> queryAllSysApp(boolean returnNum, boolean includeSpecificApp) {
        ArrayList<String> finalList = new ArrayList<String>(8);
        ArrayList<String> appInSysServCloud = new ArrayList<String>(8);
        try {
            Map appMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("bizcloud", "=", (Object)"83bfebc800000bac"), new QFilter("type", "=", (Object)"0")});
            if (appMap != null && !appMap.isEmpty()) {
                for (DynamicObject appObj : appMap.values()) {
                    if (returnNum) {
                        appInSysServCloud.add(appObj.getString("number"));
                        continue;
                    }
                    appInSysServCloud.add(appObj.getString("id"));
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return finalList;
        }
        finalList.addAll(appInSysServCloud);
        List<String> appInBaseServCloud = AdminSchemeHelper.getSysAppInBaseServCloud(returnNum, includeSpecificApp);
        finalList.addAll(appInBaseServCloud);
        return finalList;
    }

    public static List<String> queryAllSysApp(boolean returnNum, boolean includeSpecificApp, boolean includeExt) {
        String key = String.format("%s%s%s%s%s", "queryAllSysApp_", RequestContext.get().getAccountId(), returnNum, includeSpecificApp, includeExt);
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>(8);
            List<String> list = AdminSchemeHelper.queryAllSysAppPri(returnNum, includeSpecificApp, includeExt);
            if (null == list) {
                return map;
            }
            map.put("queryAllSysApp_", list);
            return map;
        });
        return (List)threadCacheMap.get("queryAllSysApp_");
    }

    private static List<String> queryAllSysAppPri(boolean returnNum, boolean includeSpecificApp, boolean includeExt) {
        List<String> finalList = AdminSchemeHelper.queryAllSysApp(returnNum, includeSpecificApp);
        if (!returnNum && includeExt && finalList != null && !finalList.isEmpty()) {
            Map<String, Set<String>> ori2ExtAppIdMap = AppHelper.getOri2ExtAppIdMap(new HashSet<String>(finalList));
            HashSet<String> finalSet = new HashSet<String>(finalList);
            if (ori2ExtAppIdMap != null && !ori2ExtAppIdMap.isEmpty()) {
                for (String appId : finalList) {
                    Set<String> extAppIds;
                    if (StringUtils.isEmpty((String)appId) || (extAppIds = ori2ExtAppIdMap.get(appId)) == null || extAppIds.isEmpty()) continue;
                    finalSet.addAll(extAppIds);
                }
                finalList = new ArrayList<String>(finalSet);
            }
        }
        return finalList;
    }

    public static List<String> getSysAppInBaseServCloud(boolean returnNum, boolean includeSpecificApp) {
        ArrayList<String> list = new ArrayList<String>();
        if (returnNum) {
            list.add("base");
            list.add("secm");
            list.add("cts");
            list.add("customize");
            if (includeSpecificApp) {
                list.add("basedata");
                list.add("ladder");
            }
        } else {
            list.add("83bfebc8000037ac");
            list.add("0XWTKVOQW+ML");
            list.add("18XR3MJ0W0ET");
            list.add("3CB4=UTSOT52");
            if (includeSpecificApp) {
                list.add("0efa1992000000ac");
                list.add("15=QTSHP67U2");
            }
        }
        return list;
    }

    public static AdmGrpHasPermResp getVirtualAdminPerm(AdminType adminType, boolean mustQueryFunpermSet) {
        String key = String.format("%s%s%s%s", "getVirtualAdminPerm_", RequestContext.get().getAccountId(), adminType.toString(), mustQueryFunpermSet);
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            HashMap<String, AdmGrpHasPermResp> map = new HashMap<String, AdmGrpHasPermResp>(8);
            AdmGrpHasPermResp virtualAdminPermPri = AdminSchemeHelper.getVirtualAdminPermPri(adminType, mustQueryFunpermSet);
            if (null == virtualAdminPermPri) {
                return map;
            }
            map.put("getVirtualAdminPerm_", virtualAdminPermPri);
            return map;
        });
        return (AdmGrpHasPermResp)threadCacheMap.get("getVirtualAdminPerm_");
    }

    private static AdmGrpHasPermResp getVirtualAdminPermPri(AdminType adminType, boolean mustQueryFunpermSet) {
        AdmGrpHasPermResp resp = new AdmGrpHasPermResp();
        boolean superAdminStrategy = PermCommonUtil.isSuperAdminStrategy();
        final HashSet funpermSet = new HashSet(8);
        if (mustQueryFunpermSet) {
            StringBuilder sql = new StringBuilder();
            sql.append(" select dtl.fbizappid, dtl.fentitynum, dtl.fpermitemid from t_perm_adminscheme ads");
            sql.append(" inner join t_perm_adminschemeentry ent on ads.fid = ent.fid");
            sql.append(" inner join t_perm_adminschemedetail dtl on ent.fentryid = dtl.fentryid");
            sql.append(" where ads.fenable = '1'");
            sql.append(" and ent.fadmintype = ? ");
            DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{Long.valueOf(adminType.toString())}, (ResultSetHandler)new ResultSetHandler<Void>(){

                public Void handle(ResultSet rs) throws SQLException {
                    AdmGrpFunperm one = null;
                    while (rs.next()) {
                        one = new AdmGrpFunperm(null, null, null, null, rs.getString("fbizappid"), null, null, rs.getString("fentitynum"), null, rs.getString("fpermitemid"), null, null);
                        funpermSet.add(one);
                    }
                    return null;
                }
            });
        }
        resp.setFunpermSet(funpermSet);
        if (superAdminStrategy) {
            resp.setHasAllFunperm(true);
            return resp;
        }
        return resp;
    }

    private static Map<String, Set<Long>> getAdminTagUserIdSetMap() {
        HashMap<String, Set<Long>> adminTagUserIdSetMap = new HashMap<String, Set<Long>>(8);
        try (DataSet ds2 = QueryServiceHelper.queryDataSet((String)"AdminSchemeHelper.getAdminTagUserIdSetMap", (String)"perm_useradmintags", (String)"admintag, user", null, (String)"");){
            while (ds2.hasNext()) {
                Row row = ds2.next();
                String admintag = row.getString("admintag");
                if (StringUtils.isEmpty((String)admintag)) continue;
                Long userId = row.getLong("user");
                adminTagUserIdSetMap.computeIfAbsent(admintag.trim(), k -> new HashSet(8)).add(userId);
            }
        }
        return adminTagUserIdSetMap;
    }

    public static Map<Long, String> getUserAdminTagMap(Set<String> adminTags) {
        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>(10);
        if (null != adminTags && !adminTags.isEmpty()) {
            qfilterList.add(new QFilter("admintag", "in", adminTags));
        }
        HashMap<Long, String> map = new HashMap<Long, String>(8);
        try (DataSet ds2 = QueryServiceHelper.queryDataSet((String)"AdminSchemeHelper.getUserAdminTagMap", (String)"perm_useradmintags", (String)"admintag, user", (QFilter[])qfilterList.toArray(new QFilter[qfilterList.size()]), (String)"");){
            while (ds2.hasNext()) {
                Row row = ds2.next();
                String admintag = row.getString("admintag");
                Long userId = row.getLong("user");
                map.put(userId, null == admintag ? "" : admintag.trim());
            }
        }
        return map;
    }

    public static Map<Long, User> getUserMapOfCurSchemTag(Set<String> adminTagTypeSet, Set<String> entNumSet, Long adminSchemeId) {
        String inStr;
        Long enableAdminSchemeId;
        ArrayList<Object> paramList = new ArrayList<Object>(6);
        Map<String, Set<Long>> adminTagUserIdSetMap = AdminSchemeHelper.getAdminTagUserIdSetMap();
        StringBuilder sql1 = new StringBuilder();
        sql1.append("select a.fadmintype ");
        sql1.append(" from t_perm_adminschemeentry a ");
        Long l = enableAdminSchemeId = null == adminSchemeId ? AdminSchemeHelper.getCurEnableSchemeId() : adminSchemeId;
        if (586817719983145984L != enableAdminSchemeId) {
            sql1.append(" join t_perm_adminschemedetail b on a.fentryid = b.fentryid ");
        }
        sql1.append(" where a.fid = ? ");
        paramList.add(enableAdminSchemeId);
        if (586817719983145984L != enableAdminSchemeId && null != entNumSet && !entNumSet.isEmpty() && StringUtils.isNotEmpty((String)(inStr = SqlUtil.wrapInParam(entNumSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sql1.append(" and b.fentitynum in (").append(inStr).append(") ");
        }
        HashSet<Long> userIdSet = new HashSet<Long>(8);
        try (DataSet ds1 = DB.queryDataSet((String)"AdminSchemeHelper.getUserMapOfCurSchemTag", (DBRoute)DBRoute.permission, (String)sql1.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));){
            while (ds1.hasNext()) {
                String fadmintypeTrim;
                Set<Long> uIdSet;
                Row row = ds1.next();
                String fadmintype = row.getString("fadmintype");
                if (StringUtils.isEmpty((String)fadmintype) || null == (uIdSet = adminTagUserIdSetMap.get(fadmintypeTrim = fadmintype.trim())) || uIdSet.isEmpty()) continue;
                if (null == adminTagTypeSet || adminTagTypeSet.isEmpty()) {
                    userIdSet.addAll(uIdSet);
                    continue;
                }
                if (!adminTagTypeSet.contains(fadmintypeTrim)) continue;
                userIdSet.addAll(uIdSet);
            }
        }
        if (null == userIdSet || userIdSet.isEmpty()) {
            return new HashMap<Long, User>(0);
        }
        return UserHelper.getUserInfoMapByIds(userIdSet, RequestContext.get().getLang().name());
    }

    public static void updateUserEnableStatus(Set<String> adminTagTypeSet, String enableStr, Long adminSchemeId) {
        Map<Long, User> userMapOfCurSchemTag = AdminSchemeHelper.getUserMapOfCurSchemTag(adminTagTypeSet, null, adminSchemeId);
        if (null == userMapOfCurSchemTag || userMapOfCurSchemTag.isEmpty()) {
            return;
        }
        Set<Long> userIdSet = userMapOfCurSchemTag.keySet();
        if (null == userIdSet || userIdSet.isEmpty()) {
            return;
        }
        ArrayList<Object> paramList = new ArrayList<Object>(6);
        StringBuilder sql = new StringBuilder();
        sql.append("update t_sec_user set fenable = ? where 1=1 ");
        paramList.add(enableStr);
        String inStr = SqlUtil.wrapInParam(userIdSet.stream().map(x -> x).collect(Collectors.toSet()), paramList);
        if (StringUtils.isNotEmpty((String)inStr)) {
            sql.append(" and fid in (").append(inStr).append(") ");
        }
        DB.execute((DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));
    }

    public static void initTopAdminGroup(Long adminschemeId) {
        Object row;
        boolean enableOldAdmin = PermCommonUtil.hasEnableOldAdmin();
        if (enableOldAdmin || null == adminschemeId || Objects.equals(0L, adminschemeId)) {
            return;
        }
        HashSet<String> adminTypeSet = new HashSet<String>(8);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AdminSchemeHelper.initTopAdminGroup", (String)"perm_adminscheme", (String)"entryentity.admintype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)adminschemeId)}, null);){
            while (ds.hasNext()) {
                row = ds.next();
                adminTypeSet.add(row.getString("entryentity.admintype"));
            }
        }
        if (null == adminTypeSet || adminTypeSet.isEmpty()) {
            return;
        }
        HashSet<String> admGrpAdminTypeSet = new HashSet<String>(8);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AdminSchemeHelper.initTopAdminGroup", (String)"perm_admingroup", (String)"admintype", (QFilter[])new QFilter[]{new QFilter("adminscheme", "=", (Object)adminschemeId), new QFilter("admintype", "in", adminTypeSet.stream().map(x -> Integer.valueOf(x)).collect(Collectors.toSet())), new QFilter("level", "=", (Object)1)}, null).distinct();
        row = null;
        try {
            while (dataSet.hasNext()) {
                Row row2 = dataSet.next();
                admGrpAdminTypeSet.add(row2.getString("admintype"));
            }
        }
        catch (Throwable row2) {
            row = row2;
            throw row2;
        }
        finally {
            if (dataSet != null) {
                if (row != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable row2) {
                        ((Throwable)row).addSuppressed(row2);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        Sets.SetView difference = Sets.difference(adminTypeSet, admGrpAdminTypeSet);
        if (null == difference || difference.isEmpty()) {
            return;
        }
        Map<String, Set<Long>> adminTagUserIdSetMap = AdminSchemeHelper.getAdminTagUserIdSetMap();
        Set<Long> userIds = adminTagUserIdSetMap.values().stream().flatMap(x -> x.stream()).collect(Collectors.toSet());
        userIds.add(1L);
        userIds.add(2L);
        userIds.add(3L);
        RequestContext requestContext = RequestContext.get();
        String langStr = requestContext.getLang().name();
        Map<Long, User> userInfoMap = UserHelper.getUserInfoMapByIds(userIds, langStr, true);
        ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(10);
        HashMap<Long, Set> admGrpUserIdMap = new HashMap<Long, Set>(8);
        long[] newAdgFidArr = DB.genLongIds((String)"t_perm_admingroup", (int)difference.size());
        int idx = 0;
        Date curTime = new Date();
        long currUserId = requestContext.getCurrUserId();
        String fz = ConstantsHelper.getFz();
        for (String adminType : difference) {
            Set<Long> userIdSet = adminTagUserIdSetMap.get(adminType);
            if (null == userIdSet || userIdSet.isEmpty()) continue;
            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"perm_admingroup");
            long fid = newAdgFidArr[idx];
            dyn.set("id", (Object)fid);
            dyn.set("masterid", (Object)fid);
            String fnumber = AdminSchemeHelper.getFnumber(idx);
            dyn.set("number", (Object)fnumber);
            dyn.set("level", (Object)1);
            dyn.set("longnumber", (Object)fnumber);
            dyn.set("isleaf", (Object)"1");
            dyn.set("parent", (Object)0L);
            dyn.set("enable", (Object)"1");
            dyn.set("status", (Object)"C");
            dyn.set("creator", (Object)currUserId);
            dyn.set("createtime", (Object)curTime);
            dyn.set("modifier", (Object)currUserId);
            dyn.set("modifytime", (Object)curTime);
            Long adminTypeL = Long.valueOf(adminType);
            User adminTypeVirtualUser = userInfoMap.get(adminTypeL);
            LocaleString localeString = new LocaleString(langStr, (Object)new LocaleString(adminTypeVirtualUser.getFtruename() + fz));
            if (!Objects.equals(langStr, "en_US")) {
                OrmLocaleValue ftruenameLv = adminTypeVirtualUser.getFtruenameLv();
                String ftruename_enUS = ftruenameLv.get((Object)"en_US");
                String ftruename_GLang = ftruenameLv.get((Object)"GLang");
                String ftruename_zh_CN = ftruenameLv.get((Object)"zh_CN");
                String ftruename = StringUtils.isEmpty((String)ftruename_enUS) ? (StringUtils.isEmpty((String)ftruename_GLang) ? ftruename_zh_CN : ftruename_GLang) : ftruename_enUS;
                localeString.put("en_US", (Object)(ftruename + " group"));
            }
            dyn.set("name", (Object)localeString);
            dyn.set("adminscheme", (Object)adminschemeId);
            dyn.set("admintype", (Object)Integer.valueOf(adminType));
            dynList.add(dyn);
            User user = userInfoMap.get(userIdSet.stream().findFirst().get());
            Long userId = user.getFid();
            admGrpUserIdMap.computeIfAbsent(fid, k -> new HashSet(8)).add(userId);
            admGrpUserIdMap.computeIfAbsent(fid, k -> new HashSet(8)).add(adminTypeL);
            ++idx;
        }
        if (dynList.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])dynList.toArray(new DynamicObject[dynList.size()]));
        }
        ArrayList<DynamicObject> ugDynList = new ArrayList<DynamicObject>(10);
        if (null != admGrpUserIdMap && !admGrpUserIdMap.isEmpty()) {
            for (Map.Entry admGrpUserId : admGrpUserIdMap.entrySet()) {
                Set value = (Set)admGrpUserId.getValue();
                for (Long uid : value) {
                    DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"perm_useradmingroup");
                    dyn.set("user", (Object)uid);
                    dyn.set("usergroup", admGrpUserId.getKey());
                    ugDynList.add(dyn);
                }
            }
            if (ugDynList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])ugDynList.toArray(new DynamicObject[ugDynList.size()]));
            }
        }
    }

    private static String getFnumber(int i) {
        DateTimeFormatter fmTime = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
        LocalDateTime now = LocalDateTime.now();
        return now.format(fmTime) + i;
    }

    public static Set<Long> getNotOneBigSchemeEntryIdSet() {
        StringBuilder sb = new StringBuilder();
        sb.append("select b.fentryid, count(*) num from t_perm_adminscheme a ");
        sb.append(" inner join t_perm_adminschemeentry b on b.fid = a.fid ");
        sb.append(" inner join t_perm_adminschemedetail c on c.fentryid  = b.fentryid ");
        sb.append(" group by b.fentryid ");
        return (Set)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> fentryIdSet = new HashSet<Long>(8);
                while (rs.next()) {
                    int num = rs.getInt("num");
                    if (num <= 0) continue;
                    fentryIdSet.add(rs.getLong("fentryid"));
                }
                return fentryIdSet;
            }
        });
    }
}

