/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.MenuHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.PermLocalCacheUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.perm.App;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class AppHelper {
    private static Log log = LogFactory.getLog(AppHelper.class);
    private static Object getExtAppAndOrgnlAppRel_objectLock = new Object();

    @SdkInternal
    public static Map<String, String> getAppNumIdMap(Set<String> appNumSet) {
        StringBuilder sql = new StringBuilder("select fid, fnumber from t_meta_bizapp where 1=1 ");
        if (null != appNumSet && !appNumSet.isEmpty()) {
            String appNumSetStr = String.join((CharSequence)"','", appNumSet);
            sql.append(" and fnumber in ('").append(appNumSetStr).append("')");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            HashMap<String, String> result = new HashMap<String, String>(100);
            while (rs.next()) {
                String id = rs.getString("fid");
                String fnumber = rs.getString("fnumber");
                result.put(fnumber, id);
            }
            return result;
        });
    }

    @SdkInternal
    public static Map<String, Map<String, Object>> getAppInfoMap(Map<String, Object> paraMap) {
        Map<Object, DynamicObject> loadMap = AppHelper.queryAppInfo(paraMap);
        if (CollectionUtils.isEmpty(loadMap)) {
            return new HashMap<String, Map<String, Object>>(1);
        }
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(loadMap.size());
        HashMap<String, String> infoMap = null;
        for (Map.Entry<Object, DynamicObject> dd : loadMap.entrySet()) {
            Object key = dd.getKey();
            DynamicObject value = dd.getValue();
            if (null == key || null == value) continue;
            infoMap = new HashMap<String, String>();
            infoMap.put("id", value.getString("id"));
            infoMap.put("name", value.getString("name"));
            infoMap.put("number", value.getString("number"));
            map.put((String)key, infoMap);
        }
        return map;
    }

    @SdkInternal
    private static Map<Object, DynamicObject> queryAppInfo(Map<String, Object> paraMap) {
        Set appIdSet;
        Object appIdSetObj;
        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>(10);
        if (null != paraMap && !paraMap.isEmpty() && null != (appIdSetObj = paraMap.get("appIdSet")) && !(appIdSet = (Set)appIdSetObj).isEmpty()) {
            qfilterList.add(new QFilter("id", "in", (Object)appIdSet));
        }
        return BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id,name,number", (QFilter[])qfilterList.toArray(new QFilter[0]));
    }

    public static Map<String, String> getAllAppIdNameMap() {
        return AppHelper.getAllAppIdNameMap(null);
    }

    public static Map<String, String> getAllAppIdNameMap(Set<String> appIdSet) {
        HashMap oriAppIdNumMap = new HashMap(100);
        HashMap oriAppIdNameMap = new HashMap(100);
        if (null == appIdSet) {
            appIdSet = new HashSet<String>(1);
        }
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        String langStr = RequestContext.get().getLang().name();
        boolean isChineseLocale = "zh_CN".equals(langStr);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT a.fid, a.fmasterid, a.fnumber, ");
        if (isChineseLocale) {
            sb.append("b.fname appname");
        } else {
            sb.append("case when b.fname is null or b.fname='' or b.fname = ' ' ");
            sb.append("then b2.fname ");
            sb.append("else b.fname ");
            sb.append("end appname");
        }
        sb.append(" FROM t_meta_bizapp a ");
        sb.append(" LEFT JOIN t_meta_bizapp_l b on a.fid = b.fid and b.flocaleid = ? ");
        if (!isChineseLocale) {
            sb.append(" LEFT JOIN t_meta_bizapp_l b2 on (a.fid = b2.fid and b2.flocaleid = 'zh_CN') ");
        }
        paramList.add(langStr);
        sb.append(" where 1=1 ");
        String inStr = SqlUtil.wrapInParam(appIdSet.stream().map(x -> x).collect(Collectors.toSet()), paramList);
        if (StringUtils.isNotEmpty((String)inStr)) {
            sb.append(" and a.fid in (").append(inStr).append(") ");
        }
        sb.append("  order by a.finheritpath, a.fcreatedate ");
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), rs -> {
            while (rs.next()) {
                String id = rs.getString("fid");
                String masterId = rs.getString("fmasterid");
                String number = rs.getString("fnumber");
                String name = rs.getString("appname");
                String oriAppId = StringUtils.isEmpty((String)masterId) ? id : masterId;
                String appName = StringUtils.isEmpty((String)name) ? number : name;
                String oriNum = (String)oriAppIdNumMap.get(oriAppId);
                if (StringUtils.isEmpty((String)oriNum)) {
                    oriAppIdNumMap.put(oriAppId, number);
                }
                oriAppIdNameMap.put(oriAppId, appName);
            }
            return null;
        });
        sb.setLength(0);
        final HashMap oriAppNumRuntimeNameMap = new HashMap(100);
        sb.append("SELECT a.fappid, ");
        if (isChineseLocale) {
            sb.append("b.fname appname");
        } else {
            sb.append("case when b.fname is null or b.fname='' or b.fname = ' ' ");
            sb.append("then b2.fname ");
            sb.append("else b.fname ");
            sb.append("end appname");
        }
        sb.append(" from t_meta_appruntime a ");
        sb.append(" LEFT JOIN t_meta_appruntime_l b on (a.fappid = b.fappid and b.flocaleid = ?) ");
        if (!isChineseLocale) {
            sb.append(" LEFT JOIN t_meta_appruntime_l b2 on (a.fappid = b2.fappid and b2.flocaleid = 'zh_CN') ");
        }
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{langStr}, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String appNum = rs.getString("fappid");
                    String runtimeAppName = rs.getString("appname");
                    oriAppNumRuntimeNameMap.put(appNum, runtimeAppName);
                }
                return null;
            }
        });
        HashMap<String, String> map = new HashMap<String, String>(100);
        for (Map.Entry oriAppIdNum : oriAppIdNumMap.entrySet()) {
            String oriAppId = (String)oriAppIdNum.getKey();
            String appNum = (String)oriAppIdNum.getValue();
            String runtimeName = (String)oriAppNumRuntimeNameMap.get(appNum);
            String designName = (String)oriAppIdNameMap.get(oriAppId);
            map.put(oriAppId, StringUtils.isEmpty((String)runtimeName) ? designName : runtimeName);
        }
        return map;
    }

    @SdkInternal
    public static Map<String, String> getAllAppIdNumberMap() {
        String sql = "select fid, fnumber from t_meta_bizapp where ftype <> '2' ";
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
            HashMap<String, String> result = new HashMap<String, String>(100);
            while (rs.next()) {
                String id = rs.getString(1);
                String number = rs.getString(2);
                result.put(id, number);
            }
            return result;
        });
    }

    @Deprecated
    @SdkInternal
    public static Map<String, String> getAllAppNumberIdMap(Map<String, String> appIdNumMap) {
        if (appIdNumMap == null || appIdNumMap.isEmpty()) {
            String sql = "select fid, fnumber from t_meta_bizapp where ftype <> '2' ";
            return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, rs -> {
                HashMap<String, String> result = new HashMap<String, String>(100);
                while (rs.next()) {
                    String id = rs.getString(1);
                    String number = rs.getString(2);
                    result.put(number, id);
                }
                return result;
            });
        }
        HashMap<String, String> result = new HashMap<String, String>(8);
        for (Map.Entry<String, String> entry : appIdNumMap.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    @SdkInternal
    public static Map<String, String> getExtAppAndOrgnlAppRel() {
        return AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
    }

    @SdkInternal
    public static Map<String, String> getExtAppAndOrgnlAppRel(String appId) {
        if (StringUtils.isEmpty((String)appId)) {
            return AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
        }
        return AppHelper.getExtAppAndOrgnlAppRel(Sets.newHashSet((Object[])new String[]{appId}));
    }

    @SdkInternal
    public static Map<String, String> getExtAppAndOrgnlAppRel(Set<String> appIdSet) {
        return AppHelper.getExtAppAndOrgnlAppRel(appIdSet, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternal
    public static Map<String, String> getExtAppAndOrgnlAppRel(Set<String> appIdSet, boolean needRefreshCache) {
        try {
            if (needRefreshCache) {
                PermLocalCacheUtil.removeLocalCacheByKey("BS_PERM_LOCALCACHEKEY_GETEXTAPPANDORGNLAPPREL");
            }
            CacheConfigInfo info = new CacheConfigInfo();
            info.setTimeout(86400);
            info.setMaxItemSize(100000);
            Object localCacheV = PermLocalCacheUtil.getLocalCacheByKey("BS_PERM_LOCALCACHEKEY_GETEXTAPPANDORGNLAPPREL", info);
            if (null == localCacheV) {
                Object object = getExtAppAndOrgnlAppRel_objectLock;
                synchronized (object) {
                    localCacheV = PermLocalCacheUtil.getLocalCacheByKey("BS_PERM_LOCALCACHEKEY_GETEXTAPPANDORGNLAPPREL", info);
                    if (null == localCacheV) {
                        Map<String, String> resultMap = AppHelper.getExtAppAndOrgnlAppRelPrivate(null);
                        PermLocalCacheUtil.putLocalCache("BS_PERM_LOCALCACHEKEY_GETEXTAPPANDORGNLAPPREL", resultMap, info);
                        return resultMap;
                    }
                    return (Map)localCacheV;
                }
            }
            return (Map)localCacheV;
        }
        catch (Exception e) {
            log.debug("AppHelper.getExtAppAndOrgnlAppRel error.", (Object)e);
            return AppHelper.getExtAppAndOrgnlAppRelPrivate(null);
        }
    }

    @SdkInternal
    public static Map<String, String> getExtAppAndOrgnlAppRelPrivate(Set<String> appIdSet) {
        StringBuilder sql = new StringBuilder("select fid, fmasterid from t_meta_bizapp where 1=1 ");
        if (null != appIdSet && !appIdSet.isEmpty()) {
            String appIdStr = String.join((CharSequence)"','", appIdSet);
            sql.append(" and fid in ('").append(appIdStr).append("')");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            HashMap<String, String> result = new HashMap<String, String>(100);
            while (rs.next()) {
                String id = rs.getString("fid");
                String masterid = rs.getString("fmasterid");
                if (StringUtils.isEmpty((String)masterid)) {
                    result.put(id, id);
                    continue;
                }
                result.put(id, masterid);
            }
            return result;
        });
    }

    @SdkInternal
    public static Map<String, Set<String>> getOri2ExtAppIdMap(Set<String> appIdSet) {
        StringBuilder sql = new StringBuilder("select fid, fmasterid from t_meta_bizapp where 1=1 ");
        if (null != appIdSet && !appIdSet.isEmpty()) {
            String appIdStr = String.join((CharSequence)"','", appIdSet);
            sql.append(" and (fid in ('").append(appIdStr).append("')");
            sql.append(" or fmasterid in ('").append(appIdStr).append("'))");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            HashMap<String, Set> result = new HashMap<String, Set>(100);
            while (rs.next()) {
                String id = rs.getString("fid");
                String masterid = rs.getString("fmasterid");
                String key = StringUtils.isEmpty((String)masterid) ? id : masterid;
                result.computeIfAbsent(key, k -> new HashSet(8)).add(id);
            }
            return result;
        });
    }

    @SdkInternal
    public static Map<String, DynamicObject> getAllCloudMap() {
        return AppHelper.getAppIdCloudMap(null);
    }

    @SdkInternal
    private static Map<String, DynamicObject> getAppIdCloudMap(QFilter[] filters) {
        HashMap<String, DynamicObject> appInfoMap = new HashMap<String, DynamicObject>(8);
        DynamicObject dyn = null;
        DynamicObject bizcloud = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AppHelper.getAllCloudMap", (String)"bos_devportal_bizapp", (String)"id, bizcloud.id, bizcloud.name, bizcloud.number", (QFilter[])filters, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                String appId = row.getString("id");
                String cloudId = row.getString("bizcloud.id");
                String cloudNum = row.getString("bizcloud.number");
                String cloudName = row.getString("bizcloud.name");
                dyn = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_bizapp");
                bizcloud = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_bizcloud");
                bizcloud.set("id", (Object)cloudId);
                bizcloud.set("number", (Object)cloudNum);
                bizcloud.set("name", (Object)cloudName);
                dyn.set("id", (Object)appId);
                dyn.set("bizcloud", (Object)bizcloud);
                appInfoMap.put(appId, dyn);
            }
        }
        return appInfoMap;
    }

    public static Map<String, String> getAppCloudInfo(QFilter[] qFilters) {
        Map<String, DynamicObject> appIdCloudMap = AppHelper.getAppIdCloudMap(qFilters);
        if (CollectionUtils.isEmpty(appIdCloudMap)) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> map = new HashMap<String, String>(appIdCloudMap.size());
        for (Map.Entry<String, DynamicObject> m : appIdCloudMap.entrySet()) {
            String appId = m.getKey();
            DynamicObject appObject = m.getValue();
            String cloudId = appObject.getString("bizcloud.id");
            String cloudNumber = appObject.getString("bizcloud.number");
            String cloudName = appObject.getString("bizcloud.name");
            map.put(appId, cloudId + '|' + cloudNumber + '|' + cloudName);
        }
        return map;
    }

    @SdkInternal
    public static Map<String, DynamicObject> getCloudMap(List<String> appList) {
        QFilter[] qFilterArray;
        QFilter filter = null;
        if (null != appList && !appList.isEmpty()) {
            filter = new QFilter("id", "in", appList);
        }
        if (null == filter) {
            qFilterArray = new QFilter[]{};
        } else {
            QFilter[] qFilterArray2 = new QFilter[1];
            qFilterArray = qFilterArray2;
            qFilterArray2[0] = filter;
        }
        return AppHelper.getAppIdCloudMap(qFilterArray);
    }

    @SdkInternal
    public static DataSet getAppIdOriMapDataSet(Map<String, Object> paraMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("select fid, fmasterid from t_meta_bizapp");
        sb.append(" where 1=1");
        Algo algo = Algo.create((String)"AppHelper.getAppIdOriMapDataSet");
        ArrayList<Field> permFields = new ArrayList<Field>(2);
        permFields.add(new Field("appId", (DataType)DataType.StringType));
        permFields.add(new Field("oriAppId", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(permFields.toArray(new Field[0]));
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        try (DataSet ds = DB.queryDataSet((String)(AppHelper.class.getName() + ".getAppIdOriMapDataSet"), (DBRoute)DBRoute.meta, (String)sb.toString(), null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                String appId = row.getString("fid");
                String fmasterid = row.getString("fmasterid");
                builder.append(new Object[]{appId, StringUtils.isEmpty((String)fmasterid) || " ".equals(fmasterid) ? appId : fmasterid});
            }
        }
        return builder.build();
    }

    @SdkInternal
    public static DataSet getAppDataSet(Map<String, Object> paraMap) {
        final HashMap oriAppIdNumMap = new HashMap(100);
        final HashMap oriAppIdNameMap = new HashMap(100);
        final HashMap oriAppIdCloudIdMap = new HashMap(100);
        final HashMap oriAppIdAllUserMap = new HashMap(100);
        final HashMap oriAppIdDeployStatusMap = new HashMap(100);
        final HashMap oriAppSeqMap = new HashMap(100);
        String langStr = RequestContext.get().getLang().name();
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid, a.fmasterid, a.fnumber, a.fbizcloudid, a.falluserapp, a.fdeploystatus, a.fseq aseq, ");
        sb.append("case when b.fname is null or b.fname = '' or b.fname = ' ' ");
        sb.append("then b2.fname ");
        sb.append("else b.fname ");
        sb.append("end appname ");
        sb.append(" from t_meta_bizapp a ");
        sb.append(" left join t_meta_bizapp_l b on (a.fid = b.fid and b.flocaleid = ?) ");
        sb.append(" left join t_meta_bizapp_l b2 on (a.fid = b2.fid and b2.flocaleid = 'zh_CN') ");
        sb.append(" order by a.fcreatedate ");
        DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{langStr}, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String oriCloudId;
                    String id = rs.getString(1);
                    String masterId = rs.getString(2);
                    String number = rs.getString(3);
                    String fbizcloudid = rs.getString(4);
                    String falluserapp = rs.getString(5);
                    String fdeploystatus = rs.getString(6);
                    Long seq = rs.getLong(7);
                    String name = rs.getString(8);
                    String oriAppId = "";
                    oriAppId = StringUtils.isEmpty((String)masterId) || " ".equals(masterId) ? id : masterId;
                    String oriNum = (String)oriAppIdNumMap.get(oriAppId);
                    if (StringUtils.isEmpty((String)oriNum)) {
                        oriAppIdNumMap.put(oriAppId, number);
                    }
                    if (StringUtils.isEmpty((String)(oriCloudId = (String)oriAppIdCloudIdMap.get(oriAppId)))) {
                        oriAppIdCloudIdMap.put(oriAppId, fbizcloudid);
                    }
                    oriAppIdAllUserMap.put(oriAppId, falluserapp);
                    String oriDeploystatus = (String)oriAppIdDeployStatusMap.get(oriAppId);
                    if (StringUtils.isEmpty((String)oriDeploystatus)) {
                        oriAppIdDeployStatusMap.put(oriAppId, fdeploystatus);
                    }
                    oriAppIdNameMap.put(oriAppId, name);
                    oriAppSeqMap.put(oriAppId, seq);
                }
                return null;
            }
        });
        Algo algo = Algo.create((String)"AppHelper.getAppDataSet.algo");
        ArrayList<Field> permFields = new ArrayList<Field>(16);
        permFields.add(new Field("oriAppId", (DataType)DataType.StringType));
        permFields.add(new Field("oriAppNum", (DataType)DataType.StringType));
        permFields.add(new Field("appName", (DataType)DataType.StringType));
        permFields.add(new Field("fbizcloudid", (DataType)DataType.StringType));
        permFields.add(new Field("falluserapp", (DataType)DataType.StringType));
        permFields.add(new Field("fdeploystatus", (DataType)DataType.StringType));
        permFields.add(new Field("aseq", (DataType)DataType.LongType));
        RowMeta rowMeta = new RowMeta(permFields.toArray(new Field[0]));
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        for (Map.Entry oriAppIdNum : oriAppIdNumMap.entrySet()) {
            String oriAppId = (String)oriAppIdNum.getKey();
            String num = (String)oriAppIdNum.getValue();
            builder.append(new Object[]{oriAppId, num, oriAppIdNameMap.get(oriAppId), oriAppIdCloudIdMap.get(oriAppId), oriAppIdAllUserMap.get(oriAppId), oriAppIdDeployStatusMap.get(oriAppId), oriAppSeqMap.get(oriAppId)});
        }
        return builder.build();
    }

    @SdkInternal
    public static Map<String, Set<String>> getAllUserAppEntMap() {
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)"SELECT fappid, fentitynum FROM t_perm_alluserappent", (ResultSetHandler)new ResultSetHandler<Map<String, Set<String>>>(){

            public Map<String, Set<String>> handle(ResultSet rs) throws Exception {
                HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
                while (rs.next()) {
                    String fappid = rs.getString(1);
                    String fentitynum = rs.getString(2);
                    map.computeIfAbsent(fappid, k -> new HashSet()).add(fentitynum);
                }
                return map;
            }
        });
    }

    @SdkInternal
    public static Map<String, String> getCloudAppIdMap(Set<String> appIdSet) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fid, fbizcloudid from t_meta_bizapp where 1=1");
        if (null != appIdSet && !appIdSet.isEmpty()) {
            String appIdStr = String.join((CharSequence)"','", appIdSet);
            sql.append(" and fid in ('").append(appIdStr).append("')");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), rs -> {
            HashMap<String, String> result = new HashMap<String, String>(100);
            while (rs.next()) {
                String appId = rs.getString("fid");
                String cloudId = rs.getString("fbizcloudid");
                result.put(appId, cloudId);
            }
            return result;
        });
    }

    @SdkInternal
    public static Set<kd.bos.permission.cache.model.permbase.App> getOriAppSet(Set<String> cloudIdSet) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fid, fnumber from t_meta_bizapp ");
        sql.append(" where ftype <> '2' ");
        if (null != cloudIdSet && !cloudIdSet.isEmpty()) {
            String cloudIdSetStr = String.join((CharSequence)"','", cloudIdSet);
            sql.append(" and fbizcloudid in ('").append(cloudIdSetStr).append("')");
        }
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), rs -> {
            HashSet<kd.bos.permission.cache.model.permbase.App> result = new HashSet<kd.bos.permission.cache.model.permbase.App>(8);
            kd.bos.permission.cache.model.permbase.App app = null;
            while (rs.next()) {
                String fid = rs.getString("fid");
                String fnumber = rs.getString("fnumber");
                app = new kd.bos.permission.cache.model.permbase.App();
                app.setAppId(fid);
                app.setAppNumber(fnumber);
                result.add(app);
            }
            return result;
        });
    }

    @SdkInternal
    public static Map<String, kd.bos.permission.cache.model.permbase.App> getAppMap(Set<String> appIdSet) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid, a.fnumber, a.fseq, b.fname");
        sb.append(" from t_meta_bizapp a ");
        sb.append(" inner join t_meta_bizapp_l b on a.fid = b.fid and b.flocaleid = ? ");
        sb.append(" where 1=1 ");
        if (!CollectionUtils.isEmpty(appIdSet)) {
            String appIdSetStr = String.join((CharSequence)"','", appIdSet);
            sb.append(" and a.fid in('").append(appIdSetStr).append("')");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{RequestContext.get().getLang().name()}, (ResultSetHandler)new ResultSetHandler<Map<String, kd.bos.permission.cache.model.permbase.App>>(){

            public Map<String, kd.bos.permission.cache.model.permbase.App> handle(ResultSet rs) throws Exception {
                HashMap<String, kd.bos.permission.cache.model.permbase.App> resultMap = new HashMap<String, kd.bos.permission.cache.model.permbase.App>(8);
                kd.bos.permission.cache.model.permbase.App app = null;
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    String fnumber = rs.getString("fnumber");
                    int fseq = rs.getInt("fseq");
                    String fname = rs.getString("fname");
                    app = new kd.bos.permission.cache.model.permbase.App();
                    app.setAppId(fid);
                    app.setAppNumber(fnumber);
                    app.setAppSeq(fseq);
                    app.setAppName(fname);
                    resultMap.put(fid, app);
                }
                return resultMap;
            }
        });
    }

    @SdkInternal
    public static Set<String> getAppId(Set<String> appIdSet) {
        ArrayList<String> paramList = new ArrayList<String>(10);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid, a.fmasterid");
        sb.append(" from t_meta_bizapp a ");
        sb.append(" where 1=1 ");
        if (null != appIdSet && !appIdSet.isEmpty()) {
            sb.append(" and (a.fid in (").append(String.join((CharSequence)",", Collections.nCopies(appIdSet.size(), "?"))).append(") ");
            for (String one : appIdSet) {
                paramList.add(one);
            }
            sb.append(" or a.fmasterid in (").append(String.join((CharSequence)",", Collections.nCopies(appIdSet.size(), "?"))).append(")) ");
            for (String one : appIdSet) {
                paramList.add(one);
            }
        }
        return (Set)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> resultSet = new HashSet<String>(8);
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    String fmasterid = rs.getString("fmasterid");
                    if (StringUtils.isNotEmpty((String)fid)) {
                        resultSet.add(fid);
                    }
                    if (!StringUtils.isNotEmpty((String)fmasterid)) continue;
                    resultSet.add(fmasterid);
                }
                return resultSet;
            }
        });
    }

    @SdkInternal
    public static String getCurAppId(String opFormNum, String appNum) {
        String opAppId = "";
        if (StringUtils.isNotEmpty((String)appNum)) {
            AppInfo metaAppInfo = AppHelper.getMetaAppInfo(appNum);
            if (null == metaAppInfo) {
                return opAppId;
            }
            opAppId = metaAppInfo.getId();
        }
        opAppId = StringUtils.isEmpty((String)opAppId) ? BizAppServiceHelp.getAppIdByFormNum((String)opFormNum) : opAppId;
        return opAppId;
    }

    @SdkInternal
    public static Map<String, Set<App>> getAppMap(Set<String> idOrNumberOrNameSet, String keyType) {
        HashMap<String, Set<App>> map = new HashMap<String, Set<App>>(8);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("id", keyType)) {
            qFilterList.add(new QFilter("id", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("number", keyType)) {
            qFilterList.add(new QFilter("number", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("name", keyType)) {
            qFilterList.add(new QFilter("name", "in", idOrNumberOrNameSet));
        }
        App one = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AppHelper.getAppMap", (String)"bos_devportal_bizapp", (String)"id, number, name", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                one = new App();
                String id = row.getString("id");
                String number = row.getString("number");
                String name = row.getString("name");
                one.setAppId(id);
                one.setAppNumber(number);
                one.setAppName(name);
                if (Objects.equals("id", keyType)) {
                    map.computeIfAbsent(String.valueOf(id), k -> new HashSet()).add(one);
                    continue;
                }
                if (Objects.equals("name", keyType)) {
                    map.computeIfAbsent(name, k -> new HashSet()).add(one);
                    continue;
                }
                if (!Objects.equals("number", keyType)) continue;
                map.computeIfAbsent(number, k -> new HashSet()).add(one);
            }
        }
        return map;
    }

    @SdkInternal
    public static String getAppSeqStr(Map<String, AppInfo> allAppInfo, String paramAppSeq, String appNum) {
        AppInfo appInfo = allAppInfo.get(appNum);
        String appSeqStr = "0";
        if (appInfo != null) {
            Short seq = appInfo.getSeq();
            if (seq != null) {
                appSeqStr = seq.toString();
            }
        } else {
            appSeqStr = paramAppSeq;
        }
        if (StringUtils.isEmpty((String)appSeqStr)) {
            appSeqStr = "0";
        }
        return appSeqStr;
    }

    @SdkInternal
    public static AppInfo getMetaAppInfo(String curAppId) {
        AppInfo appInfo = null;
        try {
            appInfo = AppMetadataCache.getAppInfo((String)curAppId);
        }
        catch (Exception e) {
            log.debug("AppHelper.getMetaAppInfo, appInfo error, curAppId:{}", (Object)curAppId, (Object)e);
        }
        return appInfo;
    }

    public static boolean notNeedCheckPermForEntityInApp(String pCurViewAppId, String pEntityNum) {
        String realEntityNum;
        if (StringUtils.isEmpty((String)pCurViewAppId) || StringUtils.isEmpty((String)pEntityNum)) {
            return false;
        }
        String reaLAppId = "";
        try {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)pCurViewAppId);
            if (appInfo != null) {
                boolean allUserAppFlag = appInfo.isAllUserApp();
                if (!allUserAppFlag) {
                    return false;
                }
                reaLAppId = PermCommonUtil.getAppIdFromSuspectedAppNum(pCurViewAppId);
            }
        }
        catch (Exception e) {
            log.error("AppHelper.notNeedCheckPermForEntityInApp.reaLAppId error", (Throwable)e);
            return false;
        }
        try {
            realEntityNum = FormMetadataCache.getFormConfig((String)pEntityNum).getEntityTypeId();
        }
        catch (Exception e) {
            log.error("AppHelper.notNeedCheckPermForEntityInApp.realEntityNum error", (Throwable)e);
            return false;
        }
        Map<String, List<String>> checkPermAllUserAppEntMap = PermCommonUtil.getCheckPermAllUserAppEntMap();
        List<String> checkPermEntList = checkPermAllUserAppEntMap.get(reaLAppId);
        if (checkPermEntList != null && checkPermEntList.contains(pEntityNum)) {
            return false;
        }
        Map<String, String> extAppOrgnlAppMap = AppHelper.getExtAppAndOrgnlAppRel(new HashSet<String>(1));
        ArrayList<String> entityNums = new ArrayList<String>(8);
        entityNums.add(realEntityNum);
        HashMap<String, Object> extAppAndOrgnlAppRelParamMap = new HashMap<String, Object>(8);
        extAppAndOrgnlAppRelParamMap.put("entityNumList", entityNums);
        extAppAndOrgnlAppRelParamMap.put("extAppOrgnlAppMap", extAppOrgnlAppMap);
        extAppAndOrgnlAppRelParamMap.put("perm_formEntityNumMap", new HashMap(0));
        Map<String, String> entOriAppIdMap = FormHelper.getAppIdByFormNum(extAppAndOrgnlAppRelParamMap);
        String orgnlAppId = entOriAppIdMap.get(realEntityNum);
        if (Objects.equals(reaLAppId, orgnlAppId)) {
            return true;
        }
        Set<String> menuEntNums = MenuHelper.getMenuEntNums(reaLAppId, entityNums);
        if (menuEntNums != null && menuEntNums.contains(realEntityNum)) {
            return true;
        }
        Map<String, String> entPublishAppMap = PermCommonUtil.getMapInfoFromPublishApp(reaLAppId, entityNums);
        return entPublishAppMap != null && entPublishAppMap.containsKey(realEntityNum);
    }
}

