/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.model.permbase.App;
import kd.bos.permission.cache.model.permbase.Cloud;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class CloudHelper {
    private static Log logger = LogFactory.getLog(CloudHelper.class);

    public static Map<String, String> getCloudIdNameMap(QFilter[] qFilterArr) {
        HashMap<String, String> idAndNames = new HashMap<String, String>(10);
        try {
            Map entityNames = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)"id,name", (QFilter[])qFilterArr);
            if (entityNames == null) {
                return idAndNames;
            }
            for (Map.Entry dyn : entityNames.entrySet()) {
                String id = String.valueOf(dyn.getKey());
                DynamicObject value = (DynamicObject)dyn.getValue();
                if (null == value) continue;
                String name = value.getString("name");
                idAndNames.put(id, name);
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return idAndNames;
    }

    public static Map<String, String> getAllCloudIdNameMap() {
        return CloudHelper.getCloudIdNameMap(null);
    }

    public static Map<String, String> getCloudIdAndNum() {
        HashMap<String, String> result = new HashMap<String, String>(10);
        Map entityNames = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)"id,number", null);
        for (DynamicObject dObj : entityNames.values()) {
            result.put(dObj.getString("id"), dObj.getString("number"));
        }
        return result;
    }

    public static Map<String, String> getCloudIdAndNumMap(Set<String> cloudIdSet) {
        if (null == cloudIdSet || cloudIdSet.isEmpty()) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> result = new HashMap<String, String>(10);
        Map entityNames = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", cloudIdSet)});
        for (DynamicObject dObj : entityNames.values()) {
            result.put(dObj.getString("id"), dObj.getString("number"));
        }
        return result;
    }

    public static DataSet getCloudDataSet() {
        return CloudHelper.getCloudDataSet(true);
    }

    public static DataSet getCloudDataSet(boolean includeSys) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid cloudId, a.fnumber cloudNum, a.fseq cseq, ");
        sb.append("case when aL.fname is null or aL.fname = '' or aL.fname = ' ' ");
        sb.append("then aL2.fname ");
        sb.append("else aL.fname ");
        sb.append("end cloudName ");
        sb.append("from t_meta_bizcloud a ");
        sb.append("left join t_meta_bizcloud_l aL on (a.fid = aL.fid and aL.flocaleid  = ?) ");
        sb.append("left join t_meta_bizcloud_l aL2 on (a.fid = aL2.fid and aL2.flocaleid  = 'zh_CN') ");
        if (!includeSys) {
            sb.append("where a.fid not in('83bfebc800000bac') ");
        }
        return DB.queryDataSet((String)CloudHelper.class.getName(), (DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{RequestContext.get().getLang().name()});
    }

    public static Map<String, Set<App>> getCloudAppIdSetMap(QFilter[] qFilters) {
        Map appInfoMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id, number, name, bizcloud", (QFilter[])qFilters);
        if (CollectionUtils.isEmpty((Map)appInfoMap)) {
            return new HashMap<String, Set<App>>(1);
        }
        HashMap<String, Set<App>> map = new HashMap<String, Set<App>>(appInfoMap.size());
        App app = null;
        for (Map.Entry m : appInfoMap.entrySet()) {
            String appId = (String)m.getKey();
            DynamicObject appObject = (DynamicObject)m.getValue();
            String appNumber = appObject.getString("number");
            String appName = appObject.getString("name");
            String cloudId = appObject.getString("bizcloud.id");
            String cloudNumber = appObject.getString("bizcloud.number");
            String cloudName = appObject.getString("bizcloud.name");
            app = new App();
            app.setCloudId(cloudId);
            app.setCloudNumber(cloudNumber);
            app.setCloudName(cloudName);
            app.setAppId(appId);
            app.setAppNumber(appNumber);
            app.setAppName(appName);
            map.computeIfAbsent(cloudId, k -> new HashSet()).add(app);
        }
        return map;
    }

    public static Map<String, Cloud> getCloudMap(Set<String> appIdSet) {
        String langStr = RequestContext.get().getLang().name();
        boolean isChineseLang = "zh_CN".equals(langStr);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid appid, b.fid, b.fnumber, b.fseq, ");
        if (isChineseLang) {
            sb.append(" c.fname cloudname ");
        } else {
            sb.append("case when c.fname is null or c.fname='' or c.fname=' ' ");
            sb.append("then c2.fname ");
            sb.append("else c.fname ");
            sb.append("end cloudname ");
        }
        sb.append(" from t_meta_bizapp a ");
        sb.append(" inner join t_meta_bizcloud b on (a.fbizcloudid = b.fid) ");
        sb.append(" left join t_meta_bizcloud_l c on (c.fid = b.fid and c.flocaleid = ?) ");
        if (!isChineseLang) {
            sb.append(" left join t_meta_bizcloud_l c2 on (c2.fid = b.fid and c2.flocaleid = 'zh_CN') ");
        }
        sb.append(" where 1=1 ");
        if (!CollectionUtils.isEmpty(appIdSet)) {
            String appIdSetStr = String.join((CharSequence)"','", appIdSet);
            sb.append(" and a.fid in('").append(appIdSetStr).append("')");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])new Object[]{langStr}, (ResultSetHandler)new ResultSetHandler<Map<String, Cloud>>(){

            public Map<String, Cloud> handle(ResultSet rs) throws Exception {
                HashMap<String, Cloud> resultMap = new HashMap<String, Cloud>(8);
                Cloud cloud = null;
                while (rs.next()) {
                    String appid = rs.getString("appid");
                    String fid = rs.getString("fid");
                    String fnumber = rs.getString("fnumber");
                    int fseq = rs.getInt("fseq");
                    String fname = rs.getString("cloudname");
                    cloud = new Cloud();
                    cloud.setCloudId(fid);
                    cloud.setCloudNumber(fnumber);
                    cloud.setCloudSeq(fseq);
                    cloud.setCloudName(fname);
                    resultMap.put(appid, cloud);
                }
                return resultMap;
            }
        });
    }
}

