/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.cache.util.StrUtil;
import kd.bos.permission.enums.EnumsDataChangeType;
import kd.bos.permission.model.perm.DimNewDrPerm;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class DimNewDrPermHelper {
    private static Log log = LogFactory.getLog(DimNewDrPermHelper.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_DimNewDrPermHelper_Pool", (int)1);

    public static Map<String, Set<DimNewDrPerm>> getUserIdDimNewDrPermSetMap(Map<String, Object> paraMap) {
        Set userIdSet = (Set)paraMap.get("userIdSet");
        if (null == userIdSet || userIdSet.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        final Map allDrDetailMap = (Map)paraMap.get("allDrDetailMap");
        String userIdSetStr = String.join((CharSequence)",", userIdSet);
        StringBuilder sb = new StringBuilder();
        sb.append(" select fid, fuserid, fappid, fentitynum, fpermitemid, fdataruleid, fdimid, fisincludesub, fdimtype ");
        sb.append(" from t_perm_userdatarule ");
        sb.append(" where fuserid in (").append(userIdSetStr).append(") ");
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Map<String, Set<DimNewDrPerm>>>(){

            public Map<String, Set<DimNewDrPerm>> handle(ResultSet rs) throws Exception {
                HashMap<String, Set<DimNewDrPerm>> map = new HashMap<String, Set<DimNewDrPerm>>(8);
                DimNewDrPerm one = null;
                while (rs.next()) {
                    one = new DimNewDrPerm();
                    one.setAppId(rs.getString("fappid"));
                    one.setEntityId(rs.getString("fentitynum"));
                    one.setPermItemId(rs.getString("fpermitemid"));
                    long fdataruleid = rs.getLong("fdataruleid");
                    one.setDataRuleId(Long.valueOf(fdataruleid));
                    HashMap drDetailMap = (HashMap)allDrDetailMap.get(fdataruleid);
                    if (null == drDetailMap) {
                        drDetailMap = new HashMap(1);
                    }
                    one.setDataRuleName(null == drDetailMap ? " " : (String)drDetailMap.get("fname"));
                    one.setDimId(Long.valueOf(rs.getLong("fdimid")));
                    one.setIncludesuborg(rs.getString("fisincludesub"));
                    one.setDimType(rs.getString("fdimtype"));
                    map.computeIfAbsent(rs.getString("fuserid"), k -> new HashSet()).add(one);
                }
                return map;
            }
        });
    }

    public static Map<String, Object> compareMutiThread(Set<DimNewDrPerm> preRuleList, Set<DimNewDrPerm> afterRuleList) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("delDr", new LinkedList());
        map.put("addDr", new LinkedList());
        map.put("updateDr", new LinkedList());
        try {
            HashMap<String, Set> dimTypeDimIdSetMap = new HashMap<String, Set>(8);
            for (DimNewDrPerm one : preRuleList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            for (DimNewDrPerm one : afterRuleList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            if (null == dimTypeDimIdSetMap || dimTypeDimIdSetMap.isEmpty()) {
                return map;
            }
            List del = (List)map.get("delDr");
            List add = (List)map.get("addDr");
            List update = (List)map.get("updateDr");
            for (Map.Entry dimTypeDimIdSet : dimTypeDimIdSetMap.entrySet()) {
                Set preDimIdSet = (Set)dimTypeDimIdSet.getValue();
                int size = preDimIdSet.size();
                int m = SqlUtil.getBatchCount(2, size);
                CountDownLatch countDownLatch = new CountDownLatch(m);
                ArrayList<Future> futureList = new ArrayList<Future>(m);
                List listAvg = ListUtil.averageAssign(new ArrayList(preDimIdSet), m);
                for (int i = 0; i < listAvg.size(); ++i) {
                    List dimIds = listAvg.get(i);
                    List<DimNewDrPerm> oneThreadPreList = preRuleList.stream().filter(x -> dimIds.contains(x.getDimId())).collect(Collectors.toList());
                    List<DimNewDrPerm> oneThreadAfterList = afterRuleList.stream().filter(x -> dimIds.contains(x.getDimId())).collect(Collectors.toList());
                    futureList.add(pool.submit(DimNewDrPermHelper.diff(oneThreadPreList, oneThreadAfterList, countDownLatch)));
                }
                countDownLatch.await();
                if (CollectionUtils.isEmpty(futureList)) continue;
                for (Future future : futureList) {
                    try {
                        Map futureMap = (Map)future.get();
                        List futureDel = (List)futureMap.get("del");
                        List futureAdd = (List)futureMap.get("add");
                        List futureUpdate = (List)futureMap.get("update");
                        del.addAll(futureDel);
                        add.addAll(futureAdd);
                        update.addAll(futureUpdate);
                    }
                    catch (Exception e) {
                        log.warn("DimNewDrPermHelper.compareMutiThread --> error, preRuleList:{}, afterRuleList:{}", new Object[]{preRuleList, afterRuleList, e});
                        return map;
                    }
                }
            }
            return map;
        }
        catch (Exception e) {
            log.warn("DimNewDrPermHelper.compareMutiThread --> error, preRuleList:{}, afterRuleList:{}", new Object[]{preRuleList, afterRuleList, e});
            return map;
        }
    }

    private static Callable<Map<String, List<DimNewDrPerm>>> diff(final List<DimNewDrPerm> preList, final List<DimNewDrPerm> afterList, final CountDownLatch countDownLatch) {
        return new Callable<Map<String, List<DimNewDrPerm>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, List<DimNewDrPerm>> call() throws Exception {
                try {
                    Map<String, List<DimNewDrPerm>> map = DimNewDrPermHelper.compare(preList, afterList);
                    return map;
                }
                catch (Exception ex) {
                    log.warn("DimNewDrPermHelper.diff --> error, preList:{}, afterList:{}", new Object[]{preList, afterList, ex});
                    HashMap<String, List<DimNewDrPerm>> map = new HashMap<String, List<DimNewDrPerm>>(3);
                    map.put("del", Collections.EMPTY_LIST);
                    map.put("add", Collections.EMPTY_LIST);
                    map.put("update", Collections.EMPTY_LIST);
                    HashMap<String, List<DimNewDrPerm>> hashMap = map;
                    return hashMap;
                }
                finally {
                    if (null != countDownLatch) {
                        countDownLatch.countDown();
                    }
                }
            }
        };
    }

    public static Map<String, List<DimNewDrPerm>> compare(List<DimNewDrPerm> ldndpreList, List<DimNewDrPerm> ldndafterList) {
        HashMap<String, List<DimNewDrPerm>> map = new HashMap<String, List<DimNewDrPerm>>(3);
        List<DimNewDrPerm> delList_ = ListUtil.removeAll(ldndpreList, ldndafterList);
        CopyOnWriteArrayList<DimNewDrPerm> delList = new CopyOnWriteArrayList<DimNewDrPerm>(delList_);
        List<DimNewDrPerm> addList_ = ListUtil.removeAll(ldndafterList, ldndpreList);
        CopyOnWriteArrayList<DimNewDrPerm> addList = new CopyOnWriteArrayList<DimNewDrPerm>(addList_);
        ArrayList updateList = new ArrayList(8);
        delList.stream().forEach(x -> {
            Optional<DimNewDrPerm> first = addList.stream().filter(y -> Objects.equals(x.getCloudId(), y.getCloudId()) && Objects.equals(x.getAppId(), y.getAppId()) && Objects.equals(x.getEntityId(), y.getEntityId()) && Objects.equals(x.getPermItemId(), y.getPermItemId()) && Objects.equals(x.getDimType(), y.getDimType()) && Objects.equals(x.getDimId(), y.getDimId()) && Objects.equals(x.getIncludesuborg(), y.getIncludesuborg())).findFirst();
            if (first.isPresent()) {
                DimNewDrPerm ldnd = (DimNewDrPerm)addList.get(0);
                ldnd.setPreDataRuleId(x.getDataRuleId());
                ldnd.setPreDataRuleName(x.getDataRuleName());
                ldnd.setAfterDataRuleId(ldnd.getDataRuleId());
                ldnd.setAfterDataRuleName(ldnd.getDataRuleName());
                ldnd.setDataChangeType(EnumsDataChangeType.UPDATE);
                ldnd.setDataChangeTypeDesc(ConstantsHelper.getUpdate());
                ldnd.setOpDesc(ConstantsHelper.getUpdate() + ConstantsHelper.getDataRule());
                updateList.add(ldnd);
                delList.remove(x);
                addList.remove(ldnd);
            }
        });
        delList.stream().forEach(ldnd -> {
            ldnd.setPreDataRuleId(ldnd.getDataRuleId());
            ldnd.setPreDataRuleName(ldnd.getDataRuleName());
            ldnd.setAfterDataRuleId(Long.valueOf(0L));
            ldnd.setAfterDataRuleName(" ");
            ldnd.setDataChangeType(EnumsDataChangeType.DEL);
            ldnd.setDataChangeTypeDesc(ConstantsHelper.getDel());
            ldnd.setOpDesc(ConstantsHelper.getDel() + ConstantsHelper.getDataRule());
        });
        addList.stream().forEach(ldnd -> {
            ldnd.setPreDataRuleId(Long.valueOf(0L));
            ldnd.setPreDataRuleName(" ");
            ldnd.setAfterDataRuleId(ldnd.getDataRuleId());
            ldnd.setAfterDataRuleName(ldnd.getDataRuleName());
            ldnd.setDataChangeType(EnumsDataChangeType.ADD);
            ldnd.setDataChangeTypeDesc(ConstantsHelper.getAdd());
            ldnd.setOpDesc(ConstantsHelper.getAdd() + ConstantsHelper.getDataRule());
        });
        map.put("del", delList);
        map.put("add", addList);
        map.put("update", updateList);
        return map;
    }

    @Deprecated
    @SdkInternal
    public static void saveLogDiff2DB(List<DimNewDrPerm> diffList, Long fid, String langStr) {
        DimNewDrPermHelper.saveLogDiff2DB(diffList, fid, langStr, null);
    }

    @Deprecated
    @SdkInternal
    public static void saveLogDiff2DB(List<DimNewDrPerm> diffList, Long fid, String langStr, Map<String, Object> paraMap) {
        DimNewDrPermHelper.saveLogDiff2DB(diffList, fid, langStr, paraMap, null);
    }

    public static void saveLogDiff2DB(List<DimNewDrPerm> diffList, Long fid, String langStr, Map<String, Object> paraMap, Set<String> influenceEntNumSet) {
        HashMap<String, List> dimTypeRecordMap = new HashMap<String, List>(8);
        HashSet<String> appIdSet = new HashSet<String>(8);
        HashSet<String> entNumSet = new HashSet<String>(8);
        HashSet<String> permItemIdSet = new HashSet<String>(8);
        for (DimNewDrPerm one : diffList) {
            dimTypeRecordMap.computeIfAbsent(one.getDimType(), k -> new ArrayList(10)).add(one);
            appIdSet.add(one.getAppId());
            entNumSet.add(one.getEntityId());
            permItemIdSet.add(one.getPermItemId());
        }
        if (null == dimTypeRecordMap || dimTypeRecordMap.isEmpty()) {
            return;
        }
        if (null == paraMap) {
            paraMap = new HashMap<String, Object>(8);
            paraMap.put("includeDesc", ConstantsHelper.getInclude());
            paraMap.put("notIncludeDesc", ConstantsHelper.getNotInclude());
            paraMap.put("entPermCtrlTypeMap", IsoDimHelper.getEntPermCtrlTypeMap(null));
        }
        Map entPermCtrlTypeMap = (Map)paraMap.get("entPermCtrlTypeMap");
        String includeDesc = (String)paraMap.get("includeDesc");
        String notIncludeDesc = (String)paraMap.get("notIncludeDesc");
        Map<String, DynamicObject> appIdCloudMap = AppHelper.getCloudMap(new ArrayList<String>(appIdSet));
        Map<String, String> allAppIdNameMap = AppHelper.getAllAppIdNameMap(appIdSet);
        HashMap<String, Object> ent_paraMap = new HashMap<String, Object>(8);
        ent_paraMap.put("paramEntNumSet", entNumSet);
        Map<String, Entity> entNumEntMap = FormHelper.getEntNumEntMap(ent_paraMap);
        Map<String, PermItem> permItemMap = PermItemHelper.getPermItemMap(permItemIdSet);
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append("t_perm_log_diff_dimnewdr");
        sb.append("(fid, fperm_logid, fcloud_id, fcloud_name, fapp_id, fapp_name, fentity_id, fentity_name, fperm_item_id, fperm_item_name, fdim_id, fdim_number, fdim_name, finclude_suborg, finclude_suborg_desc, fdimtype, fdimtypedesc, fpre_data_ruleid, fpre_data_rulename, fafter_data_ruleid, fafter_data_rulename, fop_desc, fcreate_time, fdatachange_type, fdatachange_type_desc)");
        sb.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        int size = diffList.size();
        long[] ids = ID.genLongIds((int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        LocalDateTime curTime = LocalDateTime.now();
        Object[] obj = null;
        String cloudId = "";
        String cloudName = "";
        String dimNumber = "";
        String dimName = "";
        String dimTypeDesc = "";
        int i = 0;
        for (Map.Entry dimTypeRecord : dimTypeRecordMap.entrySet()) {
            String dimType = (String)dimTypeRecord.getKey();
            List recordList = (List)dimTypeRecord.getValue();
            if (StringUtils.isEmpty((String)dimType) || null == recordList || recordList.isEmpty()) continue;
            Set dimIdSet = recordList.stream().map(DimNewDrPerm::getDimId).collect(Collectors.toSet());
            Map<Long, Dim> dimMap = IsoDimHelper.getDimMap(new ArrayList<Long>(dimIdSet), dimType);
            for (DimNewDrPerm one : recordList) {
                String includesuborg;
                String appId = StrUtil.nullAbleStr(one.getAppId());
                DynamicObject cloudObj = appIdCloudMap.get(appId);
                if (null != cloudObj) {
                    cloudId = cloudObj.getString("bizcloud.id");
                    cloudName = cloudObj.getString("bizcloud.name");
                }
                String appName = StrUtil.nullAbleStr(allAppIdNameMap.get(appId));
                String entityNumber = StrUtil.nullAbleStr(one.getEntityId());
                Entity entity = entNumEntMap.get(entityNumber);
                String entityName = null == entity ? "" : entity.getEntityName();
                String permItemId = StrUtil.nullAbleStr(one.getPermItemId());
                PermItem permItem = permItemMap.get(permItemId);
                String permItemName = null == permItem ? "" : permItem.getPermItemName();
                Long dimId = one.getDimId();
                Dim dim = dimMap.get(dimId);
                if (null != dim) {
                    dimNumber = dim.getDimNumber();
                    dimName = dim.getDimName();
                }
                String includesuborgDesc = StringUtils.isEmpty((String)(includesuborg = StrUtil.nullAbleStr(one.getIncludesuborg()))) ? "" : ("1".equals(includesuborg) ? includeDesc : notIncludeDesc);
                String preDataRuleName = StrUtil.nullAbleStr(one.getPreDataRuleName());
                String afterDataRuleName = StrUtil.nullAbleStr(one.getAfterDataRuleName());
                String opDesc = StrUtil.nullAbleStr(one.getOpDesc());
                PermCtrlType permCtrlType = (PermCtrlType)entPermCtrlTypeMap.get(dimType);
                dimTypeDesc = null == permCtrlType ? " " : permCtrlType.getName();
                obj = new Object[]{ids[i], fid, cloudId, cloudName, appId, appName, entityNumber, entityName, permItemId, permItemName, dimId, dimNumber, dimName, includesuborg, includesuborgDesc, dimType, dimTypeDesc, one.getPreDataRuleId(), preDataRuleName, one.getAfterDataRuleId(), afterDataRuleName, opDesc, curTime, one.getDataChangeType().getType(), one.getDataChangeTypeDesc()};
                paramList.add(obj);
                if (null != influenceEntNumSet) {
                    influenceEntNumSet.add(entityNumber);
                }
                ++i;
            }
        }
        SqlUtil.syncInsert(paramList, sb.toString(), PermHelperConst.SQL_INSERT_BATCH_NUM_5000, DBRoute.log, true);
    }
}

