/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.UserHasPermDimObjCache;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.OrgHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.PermLevelHash;
import kd.bos.permission.model.perm.UserDimFieldPerm;
import kd.bos.permission.model.perm.req.GetPermLevelHashReq;
import kd.bos.permission.model.perm.req.UserDirectPermReq;
import kd.bos.permission.model.perm.req.UserPermCopyReq;
import kd.bos.permission.model.perm.req.field.GetUserDimFieldPermReq;
import kd.bos.permission.model.perm.resp.field.GetUserDimFieldPermResp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class DirectAuthorizeHelper {
    private static Log log = LogFactory.getLog(DirectAuthorizeHelper.class);
    private static ThreadPool fieldPermPool = ThreadPools.newFixedThreadPool((String)"Perm_DirectAuthorizeHelper_FieldPermPool", (int)4);

    public static Set<Long> getDirectUserId(String appId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct fuserid from t_perm_userpermdetail where fuserid > 0 and fbizappid = ?");
        HashSet<Long> result = new HashSet<Long>(8);
        try (DataSet ds = DB.queryDataSet((String)DirectAuthorizeHelper.class.getName(), (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{appId});){
            Iterator rowIterator = ds.iterator();
            while (null != rowIterator && rowIterator.hasNext()) {
                Row data = (Row)rowIterator.next();
                Long userId = data.getLong("fuserid");
                result.add(userId);
            }
        }
        return result;
    }

    public static Set<Long> getDirectDisFunUserId(String appId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fuserid from t_perm_disfunperm a");
        sql.append(" inner join t_perm_userpermdetail b on a.fuserid  = b.fuserid and a.fbizappid = b.fbizappid and a.fentitytypeid  = b.fentitytypeid and a.fpermitemid = b.fpermitemid");
        sql.append(" where a.fbizappid = ?");
        HashSet<Long> result = new HashSet<Long>(8);
        try (DataSet ds = DB.queryDataSet((String)DirectAuthorizeHelper.class.getName(), (DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])new Object[]{appId}).distinct();){
            Iterator rowIterator = ds.iterator();
            while (null != rowIterator && rowIterator.hasNext()) {
                Row data = (Row)rowIterator.next();
                Long userId = data.getLong("fuserid");
                result.add(userId);
            }
        }
        return result;
    }

    public static Map<String, Map<String, Set<String>>> getUserDirectAssignPermWithOutOrg(Long userId) {
        StringBuilder sqlSB = new StringBuilder().append("select distinct fbizappid, fentitytypeid, fpermitemid ").append(" from t_perm_userpermdetail").append(" where fuserid = ? and fbizappid > ' ' and fentitytypeid > ' ' and fpermitemid > ' ' and fdimid > 0 ");
        Object[] params = new Object[]{userId};
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Set<String>>>>(){

            public Map<String, Map<String, Set<String>>> handle(ResultSet rs) throws Exception {
                HashMap<String, Map<String, Set<String>>> map = new HashMap<String, Map<String, Set<String>>>(32);
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entNum = rs.getString("fentitytypeid");
                    String permItemID = rs.getString("fpermitemid");
                    if (!StringUtils.isNotEmpty((String)appId) || !StringUtils.isNotEmpty((String)entNum) || !StringUtils.isNotEmpty((String)permItemID)) continue;
                    map.computeIfAbsent(appId, k -> new HashMap(64)).computeIfAbsent(entNum, k -> new HashSet(10)).add(permItemID);
                }
                return map;
            }
        });
    }

    public static PermLevelHash getPermLevelHash(GetPermLevelHashReq req) {
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        StringBuilder sb = new StringBuilder();
        final boolean justPermItem = req.isJustPermItem();
        sb.append("select distinct fbizappid, fentitytypeid, fpermitemid ");
        if (!justPermItem) {
            sb.append(", fdimtype, fdimid, fisincludesub fincludesub ");
        }
        sb.append(" from t_perm_userpermdetail");
        sb.append(" where fuserid = ? ");
        Long userId = req.getUserId();
        paramList.add(userId);
        String appId = req.getAppId();
        if (StringUtils.isNotEmpty((String)appId)) {
            sb.append(" and fbizappid = ? ");
            paramList.add(appId);
        }
        return (PermLevelHash)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<PermLevelHash>(){

            public PermLevelHash handle(ResultSet rs) throws Exception {
                HashMap<String, Set> funcDimMap = new HashMap<String, Set>(8);
                boolean hasIncludeSub = false;
                String key = null;
                String value = null;
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entNum = rs.getString("fentitytypeid");
                    String permItemID = rs.getString("fpermitemid");
                    if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entNum) || StringUtils.isEmpty((String)permItemID)) continue;
                    key = appId + "@@" + entNum + "@@" + permItemID;
                    if (justPermItem && !funcDimMap.containsKey(key)) {
                        funcDimMap.put(key, new HashSet(1));
                        continue;
                    }
                    if (justPermItem) continue;
                    String fdimtype = rs.getString("fdimtype");
                    Long fdimid = rs.getLong("fdimid");
                    String fincludesub = rs.getString("fincludesub");
                    if (StringUtils.isEmpty((String)fdimtype) || null == fdimid || Objects.equals(0L, fdimid) || StringUtils.isEmpty((String)fincludesub)) continue;
                    if (Objects.equals("1", fincludesub)) {
                        hasIncludeSub = true;
                    }
                    value = fdimtype + "@@" + fdimid + "@@" + fincludesub;
                    funcDimMap.computeIfAbsent(key, k -> new HashSet(8)).add(value);
                }
                return new PermLevelHash(hasIncludeSub, funcDimMap);
            }
        });
    }

    public static Map<String, Set<String>> getUserDirectAppEntSetMap(Long userId) {
        StringBuilder sqlSB = new StringBuilder().append("select distinct fbizappid, fentitytypeid ").append(" from t_perm_userpermdetail").append(" where fuserid = ? and fbizappid > ' ' and fentitytypeid > ' ' and fpermitemid > ' ' and fdimid > 0 ");
        Object[] params = new Object[]{userId};
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Set<String>>>(){

            public Map<String, Set<String>> handle(ResultSet rs) throws Exception {
                HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(128);
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entNum = rs.getString("fentitytypeid");
                    if (!StringUtils.isNotEmpty((String)appId) || !StringUtils.isNotEmpty((String)entNum)) continue;
                    map.computeIfAbsent(appId, k -> new HashSet(64)).add(entNum);
                }
                return map;
            }
        });
    }

    public static Map<String, Map<String, List<String>>> getUserPermDetailByUser(Long userId) {
        StringBuilder sqlSB = new StringBuilder().append("select fbizappid, fentitytypeid, fpermitemid ").append(" from t_perm_userpermdetail").append(" where fuserid = ? and fbizappid > ' ' and fentitytypeid > ' ' and fpermitemid > ' ' and fdimid > 0 ");
        Object[] params = new Object[]{userId};
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, List<String>>>>(){

            public Map<String, Map<String, List<String>>> handle(ResultSet rs) throws Exception {
                HashMap<String, Map<String, List<String>>> map = new HashMap<String, Map<String, List<String>>>(32);
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entNum = rs.getString("fentitytypeid");
                    String permItemID = rs.getString("fpermitemid");
                    if (!StringUtils.isNotEmpty((String)appId) || !StringUtils.isNotEmpty((String)entNum) || !StringUtils.isNotEmpty((String)permItemID)) continue;
                    map.computeIfAbsent(appId, k -> new HashMap(16)).computeIfAbsent(entNum, k -> new ArrayList(10)).add(permItemID);
                }
                return map;
            }
        });
    }

    public static int checkPermissionWithOrg(Long userId, Long orgId, String orgView, String appId, String entityNum, String permItemId) {
        String[] suitableViewId = OrgHelper.getSuitableViewId(orgView);
        StringBuilder sql = new StringBuilder();
        sql.append("select count(distinct upd.fid) record").append(" from t_perm_userpermdetail upd").append(" inner join t_org_structure os on os.forgid = upd.fdimid").append(" where upd.fuserid = ? and upd.fbizappid= ? and upd.fentitytypeid= ? and upd.fpermitemid = ? ").append(" and upd.fdimid = ? and upd.fdimtype='bos_org' and os.fviewid = ? ");
        Object[] params = new Object[]{userId, appId, entityNum, permItemId, orgId, Long.valueOf(suitableViewId[1])};
        Long permRecord = (Long)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                Long record = 0L;
                while (rs.next()) {
                    record = rs.getLong("record");
                }
                return record;
            }
        });
        if (permRecord > 0L) {
            return 1;
        }
        List superOrgIds = OrgUnitServiceHelper.getAllSuperiorOrgs((String)orgView, (long)orgId);
        if (CollectionUtils.isEmpty((Collection)superOrgIds)) {
            return 0;
        }
        List superOrgIdList = superOrgIds.stream().map(String::valueOf).collect(Collectors.toList());
        String superOrgIdStr = String.join((CharSequence)",", superOrgIdList);
        StringBuilder supsqlSB = new StringBuilder().append("select count(distinct upd.fid) record").append(" from t_perm_userpermdetail upd").append(" inner join t_org_structure os on os.forgid = upd.fdimid").append(" where upd.fuserid = ? and upd.fbizappid= ? and upd.fentitytypeid= ? and upd.fpermitemid = ? ").append(" and upd.fdimid in (").append(superOrgIdStr).append(")").append(" and upd.fdimtype='bos_org' and upd.fisincludesub = '1' ");
        Object[] supParams = new Object[]{userId, appId, entityNum, permItemId};
        permRecord = (Long)DB.query((DBRoute)DBRoute.permission, (String)supsqlSB.toString(), (Object[])supParams, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                Long record = 0L;
                while (rs.next()) {
                    record = rs.getLong("record");
                }
                return record;
            }
        });
        if (permRecord > 0L) {
            return 1;
        }
        return 0;
    }

    public static int checkPermissionWithOutOrg(Long userId, String appId, String entityNum, String permItemId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(distinct fid) record from t_perm_userpermdetail");
        sql.append(" where fuserid = ? and fbizappid = ? and fentitytypeid = ? and fpermitemid = ? ");
        sql.append(" and fdimid > 0 ");
        Object[] params = new Object[]{userId, appId, entityNum, permItemId};
        Long permRecord = (Long)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                Long record = 0L;
                while (rs.next()) {
                    record = rs.getLong("record");
                }
                return record;
            }
        });
        if (permRecord > 0L) {
            return 1;
        }
        return 0;
    }

    public static int checkPermissionWithDim(Long userId, Long dimId, String dimType, String appId, String entityNum, String permItemId) {
        dimType = PermCommonUtil.getSuitableDimType(dimType)[1];
        StringBuilder sql = new StringBuilder();
        sql.append("select count(distinct fid) record from t_perm_userpermdetail");
        sql.append(" where fuserid = ? and fbizappid = ? and fentitytypeid = ? and fpermitemid = ? ");
        sql.append(" and fdimid = ? and fdimtype = ? ");
        Object[] params = new Object[]{userId, appId, entityNum, permItemId, dimId, dimType};
        Long permRecord = (Long)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                Long record = 0L;
                while (rs.next()) {
                    record = rs.getLong("record");
                }
                return record;
            }
        });
        if (permRecord > 0L) {
            return 1;
        }
        return 0;
    }

    public static Set<String> hasPermMenuList(Long userId, List<Object[]> menuAppEntityPermList) {
        if (menuAppEntityPermList == null || menuAppEntityPermList.isEmpty()) {
            return new HashSet<String>(16);
        }
        StringBuilder sqlSB = new StringBuilder().append("select CONCAT(CONCAT(fbizappid,fentitytypeid),fpermitemid) as res").append(" from t_perm_userpermdetail").append(" where fuserid = ? and fbizappid > ' ' and fentitytypeid > ' ' and fpermitemid > ' ' and fdimid > 0 ");
        Set result = (Set)DB.query((DBRoute)DBRoute.permission, (String)sqlSB.toString(), (Object[])new Object[]{userId}, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> result = new HashSet<String>(16);
                while (rs.next()) {
                    result.add(rs.getString("res"));
                }
                return result;
            }
        });
        HashSet<String> menuSet = new HashSet<String>(8);
        for (int i = 0; i < menuAppEntityPermList.size(); ++i) {
            Object[] objects = menuAppEntityPermList.get(i);
            String app = String.valueOf(objects[1]);
            String ent = String.valueOf(objects[2]);
            String perm = String.valueOf(objects[3]);
            if (!result.contains(app + ent + perm)) continue;
            menuSet.add(String.valueOf(objects[0]));
        }
        return menuSet;
    }

    public static Map<String, Set<String>> getUserAppEntPermItemStrMap(Set<Long> userIdSet) {
        if (null == userIdSet || userIdSet.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select fuserid, CONCAT(CONCAT(fbizappid,fentitytypeid),fpermitemid) as res");
        sb.append(" from t_perm_userpermdetail where 1=1 ");
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        String inStr = SqlUtil.wrapInParam(userIdSet.stream().map(x -> x).collect(Collectors.toSet()), paramList);
        if (StringUtils.isNotEmpty((String)inStr)) {
            sb.append(" and fuserid in (").append(inStr).append(") ");
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
        try (DataSet ds = DB.queryDataSet((String)"DirectAuthorizeHelper.getUserAppEntPermItemStrMap", (DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()])).distinct();){
            while (ds.hasNext()) {
                Row row = ds.next();
                map.computeIfAbsent(row.getString("fuserid"), k -> new HashSet(8)).add(row.getString("res"));
            }
        }
        return map;
    }

    public static Map<Long, String> cacheGetHasPermDimObj(Long userId, String dimType, String appId, String entityNum, String permItemId) {
        dimType = PermCommonUtil.getSuitableDimType(dimType)[1];
        Map<Long, String> directHasPermOrgs = new HashMap<Long, String>(16);
        List<String> orgInfos = new ArrayList(10);
        CharSequence[] keyArr = new String[]{"cacheGetHasPermDimObj", userId + "", dimType, appId, entityNum, permItemId};
        String key = String.join((CharSequence)"_", keyArr);
        String cacheValue = CacheMrg.getCache(CacheMrg.getType4UserDirectFunPermService(), key);
        if (cacheValue != null) {
            orgInfos = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
            if (orgInfos != null) {
                for (String orgInfo : orgInfos) {
                    String[] arr = orgInfo.split("_");
                    directHasPermOrgs.put(Long.valueOf(arr[0]), arr[1]);
                }
            }
            return directHasPermOrgs;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select fdimid, fisincludesub from t_perm_userpermdetail");
        sql.append(" where fuserid = ? and fbizappid = ? and fentitytypeid = ? and fpermitemid = ? ");
        sql.append(" and fdimid > 0 and fdimtype = ? ");
        Object[] params = new Object[]{userId, appId, entityNum, permItemId, dimType};
        directHasPermOrgs = (Map)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<Long, String>>(){

            public Map<Long, String> handle(ResultSet rs) throws Exception {
                HashMap<Long, String> hasPermOrg = new HashMap<Long, String>(16);
                while (rs.next()) {
                    hasPermOrg.put(rs.getLong("fdimid"), rs.getString("fisincludesub"));
                }
                return hasPermOrg;
            }
        });
        for (Map.Entry<Long, String> entry : directHasPermOrgs.entrySet()) {
            orgInfos.add(entry.getKey() + "_" + entry.getValue());
        }
        CacheMrg.putCache(CacheMrg.getType4UserDirectFunPermService(), key, SerializationUtils.toJsonString(orgInfos));
        return directHasPermOrgs;
    }

    public static Map<Long, Boolean> getUserPermDimIncludeMap(Long userId, String dimType, String appId, String entityNum, String permItemId) {
        dimType = PermCommonUtil.getSuitableDimType(dimType)[1];
        HashMap<Long, Boolean> userPermDimObjMaps = new HashMap<Long, Boolean>(8);
        StringBuilder userPermSql = new StringBuilder();
        userPermSql.append("select fdimid, fisincludesub from t_perm_userpermdetail");
        userPermSql.append(" where fuserid = ? and fbizappid = ? and fentitytypeid = ? and fpermitemid = ?");
        userPermSql.append(" and fdimid > 0 and fdimtype = ?");
        Object[] userPermParam = new Object[]{userId, appId, entityNum, permItemId, dimType};
        try (DataSet ds = DB.queryDataSet((String)UserHasPermDimObjCache.class.getName(), (DBRoute)DBRoute.permission, (String)userPermSql.toString(), (Object[])userPermParam);){
            Iterator rowIterator = ds.iterator();
            while (rowIterator != null && rowIterator.hasNext()) {
                Row data = (Row)rowIterator.next();
                Long dimObjId = data.getLong("fdimid");
                boolean includeSubDimObj = data.getBoolean("fisincludesub");
                userPermDimObjMaps.put(dimObjId, includeSubDimObj);
            }
        }
        return userPermDimObjMaps;
    }

    public static int queryDirectAssignPermSize(Long userId) {
        String querySql = "select count(*) assigncount from t_perm_userpermdetail where fuserid = ? and fbizappid > ' ' and fentitytypeid > ' ' and fpermitemid > ' ' and fdimid > 0 ";
        Integer assignPermCount = (Integer)DB.query((DBRoute)DBRoute.permission, (String)querySql, (Object[])new Object[]{userId}, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getInt(1);
                }
                return 0;
            }
        });
        return assignPermCount;
    }

    public static Long getCountByUserId(Long userId, String dimType) {
        return DirectAuthorizeHelper.getCountById(userId, dimType, "fuserid");
    }

    private static Long getCountById(Object id, String dimType, String queryFieldKey) {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) num from t_perm_userpermdetail where ").append(queryFieldKey).append(" = ? ");
        sql.append(" and fbizappid > ' ' and fentitytypeid > ' ' and fpermitemid > ' ' and fdimid > 0");
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(id);
        if (StringUtils.isNotEmpty((String)dimType)) {
            sql.append(" and fdimtype = ? ");
            paramList.add(dimType);
        }
        Object[] params = paramList.toArray(new Object[paramList.size()]);
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getLong("num");
                }
                return 0L;
            }
        });
    }

    public static Map<String, Object> getDimIncludeSubInfoMap(Map<String, Object> param) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("allDimObjs", new HashSet(8));
        resultMap.put("includeSubDimObjs", new HashSet(8));
        final Set allDimObjs = (Set)resultMap.get("allDimObjs");
        final Set includeSubDimObjs = (Set)resultMap.get("includeSubDimObjs");
        String[] dimTypeInfo = (String[])param.get("dimTypeInfo");
        String appId = (String)param.get("appId");
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct up.forgid, up.fisincludesuborg from t_perm_userperm up ");
        Object[] params = new Object[]{param.get("userId"), dimTypeInfo[0], dimTypeInfo[1]};
        if (StringUtils.isNotEmpty((String)appId)) {
            sb.append(" join t_perm_userpermdetail upd on up.fid=upd.fid ").append(" where upd.fbizappid = ? and ");
            params = new Object[]{appId, param.get("userId"), dimTypeInfo[0], dimTypeInfo[1]};
        } else {
            sb.append(" where ");
        }
        sb.append(" up.fuserid = ? and (up.fdimtype = ? or up.fdimtype = ?)");
        DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    Long orgId = rs.getLong("forgid");
                    allDimObjs.add(orgId);
                    if (!"1".equals(rs.getString("fisincludesuborg"))) continue;
                    includeSubDimObjs.add(orgId);
                }
                return null;
            }
        });
        return resultMap;
    }

    public static Map<String, Set<String>> getUserFunctionPerm(UserDirectPermReq req) {
        Long userId = req.getUserId();
        String dimType = req.getDimType();
        List dimIds = req.getDimIds();
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimType);
        dimType = suitableDimType[1];
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT fdimid, fisincludesub, fbizappid, fentitytypeid, fpermitemid FROM t_perm_userpermdetail ").append(" WHERE fuserid = ").append(userId).append(" AND fdimtype = '").append(dimType).append("' ");
        if (!CollectionUtils.isEmpty((Collection)dimIds)) {
            List list = dimIds.stream().map(String::valueOf).collect(Collectors.toList());
            String idString = String.join((CharSequence)",", list);
            sql.append(" AND fdimid IN (").append(idString).append(") ");
        }
        sql.append(" ORDER BY fdimid, fbizappid, fentitytypeid ");
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), rs -> {
            HashMap<String, Set> funcPerms = new HashMap<String, Set>(100);
            while (rs.next()) {
                String key = rs.getLong(1) + "|" + rs.getString(2);
                String value = rs.getString(3) + "|" + rs.getString(4) + "|" + rs.getString(5);
                funcPerms.computeIfAbsent(key, k -> new LinkedHashSet(16)).add(value);
            }
            return funcPerms;
        });
    }

    public static Map<String, Integer> getUserFuncPermMap(UserDirectPermReq req) {
        Long userId = req.getUserId();
        String dimType = req.getDimType();
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimType);
        dimType = suitableDimType[1];
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT fdimid, fisincludesub, fbizappid, fentitytypeid, fpermitemid FROM t_perm_userpermdetail ").append(" WHERE fuserid = ").append(userId).append(" AND fdimtype = '").append(dimType).append("' ");
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), rs -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>(16);
            StringBuilder sb = null;
            while (rs.next()) {
                sb = new StringBuilder();
                sb.append(rs.getLong(1)).append("|");
                sb.append(rs.getString(3)).append("|");
                sb.append(rs.getString(4)).append("|");
                sb.append(rs.getString(5));
                map.put(sb.toString(), 1);
            }
            return map;
        });
    }

    public static Set<String> getUserFuncPermSet(UserDirectPermReq req) {
        Long userId = req.getUserId();
        String dimType = req.getDimType();
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimType);
        dimType = suitableDimType[1];
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT fdimid, fisincludesub, fbizappid, fentitytypeid, fpermitemid FROM t_perm_userpermdetail ").append(" WHERE fuserid = ").append(userId).append(" AND fdimtype = '").append(dimType).append("' ");
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), rs -> {
            HashSet<String> set = new HashSet<String>(16);
            StringBuilder sb = null;
            while (rs.next()) {
                sb = new StringBuilder();
                sb.append(rs.getLong(1)).append("|");
                sb.append(rs.getString(3)).append("|");
                sb.append(rs.getString(4)).append("|");
                sb.append(rs.getString(5));
                set.add(sb.toString());
            }
            return set;
        });
    }

    public static Map<String, Set<String>> getUserDisFunctionPerm(UserDirectPermReq req) {
        Long userId = req.getUserId();
        String dimType = req.getDimType();
        List dimIds = req.getDimIds();
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimType);
        dimType = suitableDimType[1];
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT forgid, fisincludesuborg, fbizappid, fentitytypeid, fpermitemid FROM t_perm_disfunperm ").append(" WHERE fuserid = ").append(userId).append(" AND fdimtype = '").append(dimType).append("' ");
        if (!CollectionUtils.isEmpty((Collection)dimIds)) {
            List list = dimIds.stream().map(String::valueOf).collect(Collectors.toList());
            String idString = String.join((CharSequence)",", list);
            sql.append(" AND forgid IN (").append(idString).append(") ");
        }
        sql.append(" ORDER BY forgid, fbizappid, fentitytypeid ");
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), rs -> {
            HashMap<String, Set> funcPerms = new HashMap<String, Set>(100);
            while (rs.next()) {
                String key = rs.getLong(1) + "|" + rs.getString(2);
                String value = rs.getString(3) + "|" + rs.getString(4) + "|" + rs.getString(5);
                funcPerms.computeIfAbsent(key, k -> new LinkedHashSet(16)).add(value);
            }
            return funcPerms;
        });
    }

    public static Map<String, Map<String, Set<String>>> getUserFieldPerm(UserDirectPermReq req) {
        Long userId = req.getUserId();
        String dimType = req.getDimType();
        List dimIds = req.getDimIds();
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimType);
        dimType = suitableDimType[0];
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT a.forgid, a.fisincludesuborg, b.fbizappid, b.fentitytypeid, b.ffieldname, b.fcontrolmode FROM t_perm_userfieldperm a ").append(" INNER JOIN t_perm_fieldpermdetail b ON a.ffieldpermid = b.fid ").append(" WHERE a.fuserid = ").append(userId).append(" AND a.fdimtype = '").append(dimType).append("' ");
        if (!CollectionUtils.isEmpty((Collection)dimIds)) {
            List list = dimIds.stream().map(String::valueOf).collect(Collectors.toList());
            String idString = String.join((CharSequence)",", list);
            sql.append(" AND a.forgid IN (").append(idString).append(") ");
        }
        sql.append(" ORDER BY a.forgid, b.fbizappid, b.fentitytypeid ");
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), rs -> {
            HashMap<String, Map> funcPerms = new HashMap<String, Map>(100);
            while (rs.next()) {
                String orgInfo = rs.getLong(1) + "|" + rs.getString(2);
                String appEntity = rs.getString(3) + "|" + rs.getString(4);
                String fieldInfo = rs.getString(5) + "|" + rs.getString(6);
                funcPerms.computeIfAbsent(orgInfo, k -> new HashMap(16)).computeIfAbsent(appEntity, l -> new HashSet(16)).add(fieldInfo);
            }
            return funcPerms;
        });
    }

    public static PermResult copyUserPerm(UserPermCopyReq req) {
        try {
            StringBuilder msg = new StringBuilder();
            PermissionServiceHelper.copyUserPermission((long)req.getSourceUserId(), (List)req.getTargetUserIds(), (boolean)req.copyUserPerm(), (boolean)req.copyRole(), (boolean)req.copyBizRole(), (boolean)req.copyDisFuncPerm(), (StringBuilder)msg);
            return PermResult.ok();
        }
        catch (Exception e) {
            return PermResult.fail((String)e.getMessage());
        }
    }

    public static Map<String, Map<String, String>> getUserDirectAssignPermDim(Long userId) {
        StringBuilder sql = new StringBuilder().append("SELECT a.fid, a.forgid, a.fisincludesuborg, b.fbizobjectid, b.fseq, c.ffieldpermid, d.fdatapermid FROM t_perm_userperm a ").append("LEFT JOIN t_perm_ctrltype b ON b.fnumber = a.fdimtype ").append("LEFT JOIN t_perm_userfieldperm c ON (c.fuserid = a.fuserid AND c.forgid = a.forgid AND b.fnumber = c.fdimtype) ").append("LEFT JOIN t_perm_userdataperm d ON (d.fuserid = a.fuserid AND d.forgid = a.forgid AND d.fdimtype = a.fdimtype) ").append("WHERE a.fuserid = ").append(userId).append(" ORDER BY b.fseq, a.forgid ");
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), rs -> {
            LinkedHashMap<String, Map> result = new LinkedHashMap<String, Map>(16);
            StringBuilder value = new StringBuilder();
            while (rs.next()) {
                String dataPermId;
                String userPermId = rs.getString(1);
                if (StringUtils.isEmpty((String)userPermId)) {
                    userPermId = " ";
                }
                long dimId = rs.getLong(2);
                String includeSub = rs.getString(3);
                String dimType = rs.getString(4);
                if (StringUtils.isEmpty((String)dimType)) continue;
                String fieldPermId = rs.getString(6);
                if (StringUtils.isEmpty((String)fieldPermId)) {
                    fieldPermId = " ";
                }
                if (StringUtils.isEmpty((String)(dataPermId = rs.getString(7)))) {
                    dataPermId = " ";
                }
                value.append(dimId).append(",").append(includeSub).append(",0").append(",").append(userPermId).append(",").append(fieldPermId).append(",").append(dataPermId);
                result.computeIfAbsent(dimType, k -> new LinkedHashMap(16)).put(String.valueOf(dimId), value.toString());
                value.setLength(0);
            }
            return result;
        });
    }

    public static GetUserDimFieldPermResp getUserDimFieldPermResp(final GetUserDimFieldPermReq req, final Map<String, Map<String, Set<String>>> entItemClassFieldMap) {
        final String classMethodStr = "DirectAuthorizeHelper.getUserDimFieldPermResp";
        try {
            ArrayList<Future> futureList = new ArrayList<Future>(3);
            final CountDownLatch countDownLatch = new CountDownLatch(3);
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return DirectAuthorizeHelper.getUserDimFieldPermRespCall(DirectAuthorizeHelper.getUserDimFPSetByFieldTypeFps("DirectAuthorizeHelper.getUserDimFPSetByFieldTypeFps", req, entItemClassFieldMap), classMethodStr + ".getUserDimFPSetByFieldTypeFps.call error.", countDownLatch);
                }
            }));
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return DirectAuthorizeHelper.getUserDimFieldPermRespCall(DirectAuthorizeHelper.getUserDimFPSetByFieldFps("DirectAuthorizeHelper.getUserDimFPSetByFieldFps", req), classMethodStr + ".getUserDimFPSetByFieldFps.call error.", countDownLatch);
                }
            }));
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return DirectAuthorizeHelper.getUserDimFieldPermRespCall(DirectAuthorizeHelper.getUserDimFPSetByMx("DirectAuthorizeHelper.getUserDimFPSetByMx", req), classMethodStr + ".getUserDimFPSetByMx.call error.", countDownLatch);
                }
            }));
            countDownLatch.await();
            Integer returnType = req.getReturnType();
            GetUserDimFieldPermResp resp = new GetUserDimFieldPermResp();
            HashSet finalUdfpSet = new HashSet(8);
            for (int i = 0; i < futureList.size(); ++i) {
                try {
                    Future future = (Future)futureList.get(i);
                    GetUserDimFieldPermResp part = (GetUserDimFieldPermResp)future.get();
                    if (null == part) continue;
                    Set partUdfpSet = part.getUdfpSet();
                    if (!Objects.equals(1, returnType) || null == partUdfpSet || partUdfpSet.isEmpty()) continue;
                    finalUdfpSet.addAll(partUdfpSet);
                    continue;
                }
                catch (Exception e) {
                    log.warn("{}.futureList.for error", (Object)classMethodStr, (Object)e);
                }
            }
            resp.setUdfpSet(finalUdfpSet);
            return resp;
        }
        catch (Exception e) {
            log.warn("{} error", (Object)classMethodStr, (Object)e);
            return new GetUserDimFieldPermResp();
        }
    }

    private static GetUserDimFieldPermResp getUserDimFieldPermRespCall(GetUserDimFieldPermResp req, String errorMsg, CountDownLatch countDownLatch) {
        try {
            GetUserDimFieldPermResp getUserDimFieldPermResp = req;
            return getUserDimFieldPermResp;
        }
        catch (Exception e) {
            log.warn(errorMsg, (Throwable)e);
            throw e;
        }
        finally {
            if (null != countDownLatch) {
                countDownLatch.countDown();
            }
        }
    }

    private static GetUserDimFieldPermResp getUserDimFPSetByMx(String algoKey, GetUserDimFieldPermReq req) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        ArrayList<Object> paramList = new ArrayList<Object>(3);
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fuserid, c.fbizappid fappid, c.fentitytypeid fentnum, d.fbizobjectid fdimtype, a.forgid fdimid, a.fisincludesuborg fincludesub, c.ffieldname, c.fcontrolmode");
        sb.append(" from t_perm_userfieldperm a");
        sb.append(" inner join t_perm_fieldperm b on b.fid = a.ffieldpermid");
        sb.append(" inner join t_perm_fieldpermdetail c on c.fid = b.fid");
        sb.append(" inner join t_perm_ctrltype d on d.fnumber = a.fdimtype");
        sb.append(" where 1=1 ");
        Set userIdSet = req.getUserIdSet();
        if (null != userIdSet && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and a.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and c.fbizappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and c.fentitytypeid in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and d.fbizobjectid in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and a.forgid in (").append(dimIdListStr).append(")");
        }
        return DirectAuthorizeHelper.wrapUserDimFieldPermResult(req, "DirectAuthorizeHelper.getUserDimFPSetByMx", sb, paramList);
    }

    private static GetUserDimFieldPermResp getUserDimFPSetByFieldFps(String algoKey, GetUserDimFieldPermReq req) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        ArrayList<Object> paramList = new ArrayList<Object>(4);
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fuserid, a.fappid, a.fentnum, a.fdimtype, a.fdimid, a.fincludesub, c.ffieldname, c.fcontrolmode");
        sb.append(" from t_perm_userfieldscheme a");
        sb.append(" inner join t_perm_fieldscheme b on b.fid = a.ffieldpermschemeid");
        sb.append(" inner join t_perm_fieldschemed c on c.fid = b.fid");
        sb.append(" where b.ffieldfrom = ? and b.fenable = ? ");
        paramList.add("2");
        paramList.add("1");
        Set userIdSet = req.getUserIdSet();
        if (null != userIdSet && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and a.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and a.fappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and a.fentnum in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and a.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and a.fdimid in (").append(dimIdListStr).append(")");
        }
        return DirectAuthorizeHelper.wrapUserDimFieldPermResult(req, algoKey, sb, paramList);
    }

    private static GetUserDimFieldPermResp wrapUserDimFieldPermResult(GetUserDimFieldPermReq req, String algoKey, StringBuilder sb, List<Object> paramList) {
        GetUserDimFieldPermResp response = new GetUserDimFieldPermResp();
        try {
            HashSet<UserDimFieldPerm> udfpSet = null;
            Integer returnType = req.getReturnType();
            if (Objects.equals(1, returnType)) {
                udfpSet = new HashSet<UserDimFieldPerm>(8);
            }
            try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()])).distinct();){
                UserDimFieldPerm one = null;
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Long fuserid = row.getLong("fuserid");
                    String fappid = row.getString("fappid");
                    String fentnum = row.getString("fentnum");
                    String fdimtype = row.getString("fdimtype");
                    Long fdimid = row.getLong("fdimid");
                    String fincludesub = row.getString("fincludesub");
                    Boolean includeSub = StringUtils.isNotEmpty((String)fincludesub) && Objects.equals("1", fincludesub) ? Boolean.TRUE : Boolean.FALSE;
                    String ffieldname = row.getString("ffieldname");
                    String fcontrolmode = row.getString("fcontrolmode");
                    if (!Objects.equals(1, returnType)) continue;
                    one = new UserDimFieldPerm();
                    one.setUserId(fuserid);
                    one.setAppId(fappid);
                    one.setEntityNumber(fentnum);
                    one.setDimType(fdimtype);
                    one.setDimId(fdimid);
                    one.setIncludeSub(includeSub);
                    one.setFieldName(ffieldname);
                    one.setControlMode(fcontrolmode);
                    udfpSet.add(one);
                }
            }
            if (Objects.equals(1, returnType)) {
                response.setUdfpSet(udfpSet);
            }
        }
        catch (Exception e) {
            log.warn("DirectAuthorizeHelper.wrapUserDimFieldPermResult error", (Throwable)e);
        }
        return response;
    }

    private static GetUserDimFieldPermResp getUserDimFPSetByFieldTypeFps(String algoKey, GetUserDimFieldPermReq req, Map<String, Map<String, Set<String>>> entItemClassFieldMap) {
        GetUserDimFieldPermResp response = new GetUserDimFieldPermResp();
        try {
            List dimIdList;
            String dimIdListStr;
            Set dimIdSet;
            String dimTypeSetStr;
            Set dimTypeSet;
            String entityNumSetStr;
            Set entityNumSet;
            String appIdSetStr;
            Set appIdSet;
            List userIdList;
            String userIdStr;
            ArrayList<String> paramList = new ArrayList<String>(4);
            StringBuilder sb = new StringBuilder();
            sb.append("select distinct a.fuserid, a.fappid, a.fentnum, a.fdimtype, a.fdimid, a.fincludesub, b.fcontrolfieldtype, b.fcontrolmode");
            sb.append(" from t_perm_userfieldscheme a");
            sb.append(" inner join t_perm_fieldscheme b on b.fid = a.ffieldpermschemeid");
            sb.append(" where b.ffieldfrom = ? and b.fenable = ? ");
            paramList.add("1");
            paramList.add("1");
            Set userIdSet = req.getUserIdSet();
            if (null != userIdSet && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
                sb.append(" and a.fuserid in (").append(userIdStr).append(")");
            }
            if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
                sb.append(" and a.fappid in ('").append(appIdSetStr).append("')");
            }
            if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
                sb.append(" and a.fentnum in ('").append(entityNumSetStr).append("')");
            }
            if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
                sb.append(" and a.fdimtype in ('").append(dimTypeSetStr).append("')");
            }
            if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
                sb.append(" and a.fdimid in (").append(dimIdListStr).append(")");
            }
            HashSet<UserDimFieldPerm> udfpSet = null;
            UserDimFieldPerm one = null;
            Integer returnType = req.getReturnType();
            if (Objects.equals(1, returnType)) {
                udfpSet = new HashSet<UserDimFieldPerm>(8);
            }
            try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()])).distinct();
                 DataSet copy = ds.copy();){
                String fcontrolfieldtype;
                String fentnum;
                String fappid;
                Row row;
                while (copy.hasNext()) {
                    row = copy.next();
                    fappid = row.getString("fappid");
                    fentnum = row.getString("fentnum");
                    fcontrolfieldtype = row.getString("fcontrolfieldtype");
                    if (StringUtils.isEmpty((String)fcontrolfieldtype) || StringUtils.isEmpty((String)fentnum) || StringUtils.isEmpty((String)fappid) || !CollectionUtils.isEmpty(entItemClassFieldMap) || CollectionUtils.isEmpty((Collection)entityNumSet)) continue;
                    entItemClassFieldMap.putAll(FormHelper.getEntityItemClassFieldMap(entityNumSet));
                    break;
                }
                while (ds.hasNext()) {
                    Set<String> fieldNameSet;
                    Map<String, Set<String>> entityItemClassFieldMap;
                    row = ds.next();
                    fappid = row.getString("fappid");
                    fentnum = row.getString("fentnum");
                    fcontrolfieldtype = row.getString("fcontrolfieldtype");
                    if (StringUtils.isEmpty((String)fcontrolfieldtype) || StringUtils.isEmpty((String)fentnum) || StringUtils.isEmpty((String)fappid) || null == (entityItemClassFieldMap = entItemClassFieldMap.get(fentnum)) || entityItemClassFieldMap.isEmpty() || !entityItemClassFieldMap.containsKey(fcontrolfieldtype) || CollectionUtils.isEmpty(fieldNameSet = entityItemClassFieldMap.get(fcontrolfieldtype))) continue;
                    Long fuserid = row.getLong("fuserid");
                    String fdimtype = row.getString("fdimtype");
                    Long fdimid = row.getLong("fdimid");
                    String fincludesub = row.getString("fincludesub");
                    Boolean includeSub = StringUtils.isNotEmpty((String)fincludesub) && Objects.equals("1", fincludesub) ? Boolean.TRUE : Boolean.FALSE;
                    String fcontrolmode = row.getString("fcontrolmode");
                    for (String fieldName : fieldNameSet) {
                        if (!Objects.equals(1, returnType)) continue;
                        one = new UserDimFieldPerm();
                        one.setUserId(fuserid);
                        one.setAppId(fappid);
                        one.setEntityNumber(fentnum);
                        one.setDimType(fdimtype);
                        one.setDimId(fdimid);
                        one.setIncludeSub(includeSub);
                        one.setFieldName(fieldName);
                        one.setControlMode(fcontrolmode);
                        udfpSet.add(one);
                    }
                }
                if (Objects.equals(1, returnType)) {
                    response.setUdfpSet(udfpSet);
                }
            }
        }
        catch (Exception e) {
            log.warn("DirectAuthorizeHelper.getUserDimFPSetByFieldTypeFps error", (Throwable)e);
        }
        return response;
    }
}

