/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.model.UserDisFuncPerm;
import kd.bos.permission.model.perm.PermLevelHash;
import kd.bos.permission.model.perm.req.GetPermLevelHashReq;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class DirectDisFunHelper {
    private static Log log = LogFactory.getLog(DirectDisFunHelper.class);

    public static Map<String, List<UserDisFuncPerm>> getDimDisFunMap(Long userId, List<Long> dimIdList, String dimType) {
        List<UserDisFuncPerm> list = DirectDisFunHelper.getDimDisFunList(Collections.singletonList(userId), dimIdList, dimType, null);
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<String, List<UserDisFuncPerm>>(1);
        }
        return list.stream().collect(Collectors.groupingBy(x -> x.getForgid() + "_" + x.getFincludesub()));
    }

    public static List<UserDisFuncPerm> getDimDisFunList(List<Long> userIdList, List<Long> dimIdList, String dimType, List<String> includeSubList) {
        StringBuilder sql = new StringBuilder("select a.fuserid, a.forgid, a.fdimtype, a.fpermitemid, a.fentitytypeid, a.fbizappid, a.fisincludesuborg, a.fid ");
        sql.append(" from t_perm_disfunperm a");
        sql.append(" where 1=1 ");
        if (CollectionUtils.isEmpty(userIdList)) {
            sql.append(" and a.fuserid > 0");
        } else {
            List collect = userIdList.stream().map(String::valueOf).collect(Collectors.toList());
            String userIdStr = String.join((CharSequence)",", collect);
            sql.append(" and a.fuserid in ( ").append(userIdStr).append(" )");
        }
        if (CollectionUtils.isEmpty(dimIdList)) {
            sql.append(" and a.forgid > 0");
        } else {
            List dimIds = dimIdList.stream().map(String::valueOf).collect(Collectors.toList());
            String dimIdStr = String.join((CharSequence)",", dimIds);
            sql.append(" and a.forgid in ( ").append(dimIdStr).append(" )");
        }
        ArrayList<String> paramList = new ArrayList<String>(8);
        if (StringUtils.isNotEmpty((String)dimType)) {
            sql.append(" and a.fdimtype = ?");
            paramList.add(dimType);
        }
        if (CollectionUtils.isEmpty(includeSubList)) {
            sql.append(" and a.fisincludesuborg in('0','1')");
        } else {
            String includeSubStr = String.join((CharSequence)"','", includeSubList);
            sql.append(" and a.fisincludesuborg in ('").append(includeSubStr).append("')");
        }
        Object[] params = paramList.toArray(new String[paramList.size()]);
        try (DataSet ds = DB.queryDataSet((String)DirectDisFunHelper.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params);){
            ArrayList<UserDisFuncPerm> list = new ArrayList<UserDisFuncPerm>(32);
            UserDisFuncPerm one = null;
            while (ds.hasNext()) {
                Row rs = ds.next();
                one = new UserDisFuncPerm();
                one.setFuserid(rs.getLong("fuserid"));
                one.setForgid(rs.getLong("forgid"));
                one.setFdimtype(rs.getString("fdimtype"));
                one.setFpermitemid(rs.getString("fpermitemid"));
                one.setFentityid(rs.getString("fentitytypeid"));
                one.setFappid(rs.getString("fbizappid"));
                one.setFincludesub(rs.getString("fisincludesuborg"));
                one.setFid(rs.getString("fid"));
                list.add(one);
            }
            ArrayList<UserDisFuncPerm> arrayList = list;
            return arrayList;
        }
    }

    public static Long getCountByUserId(Long userId, String dimType) {
        return DirectDisFunHelper.getCountById(userId, dimType, "fuserid");
    }

    private static Long getCountById(Object id, String dimType, String queryFieldKey) {
        StringBuilder sql = new StringBuilder("select count(*) num from t_perm_disfunperm where ").append(queryFieldKey).append(" = ? ");
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(id);
        if (StringUtils.isNotEmpty((String)dimType)) {
            sql.append(" and fdimtype = ? ");
            paramList.add(dimType);
        }
        Object[] params = paramList.toArray(new Object[paramList.size()]);
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getLong("num");
                }
                return 0L;
            }
        });
    }

    public static PermLevelHash getPermLevelHash(GetPermLevelHashReq req) {
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        final boolean justPermItem = req.isJustPermItem();
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct fbizappid, fentitytypeid, fpermitemid ");
        if (!justPermItem) {
            sb.append(", fdimtype, forgid fdimid, fisincludesuborg fincludesub ");
        }
        sb.append(" from t_perm_disfunperm");
        sb.append(" where fuserid = ? ");
        Long userId = req.getUserId();
        paramList.add(userId);
        String appId = req.getAppId();
        if (StringUtils.isNotEmpty((String)appId)) {
            sb.append(" and fbizappid = ? ");
            paramList.add(appId);
        }
        return (PermLevelHash)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<PermLevelHash>(){

            public PermLevelHash handle(ResultSet rs) throws Exception {
                HashMap<String, Set> funcDimMap = new HashMap<String, Set>(8);
                boolean hasIncludeSub = false;
                String key = null;
                String value = null;
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entNum = rs.getString("fentitytypeid");
                    String permItemID = rs.getString("fpermitemid");
                    if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entNum) || StringUtils.isEmpty((String)permItemID)) continue;
                    key = appId + "@@" + entNum + "@@" + permItemID;
                    if (justPermItem && !funcDimMap.containsKey(key)) {
                        funcDimMap.put(key, new HashSet(1));
                        continue;
                    }
                    if (justPermItem) continue;
                    String fdimtype = rs.getString("fdimtype");
                    Long fdimid = rs.getLong("fdimid");
                    String fincludesub = rs.getString("fincludesub");
                    if (StringUtils.isEmpty((String)fdimtype) || null == fdimid || Objects.equals(0L, fdimid) || StringUtils.isEmpty((String)fincludesub)) continue;
                    if (Objects.equals("1", fincludesub)) {
                        hasIncludeSub = true;
                    }
                    value = fdimtype + "@@" + fdimid + "@@" + fincludesub;
                    funcDimMap.computeIfAbsent(key, k -> new HashSet(8)).add(value);
                }
                return new PermLevelHash(hasIncludeSub, funcDimMap);
            }
        });
    }

    public static Map<String, Map<String, String>> getUserDirectAssignDisPermDim(Long userId) {
        StringBuilder sql = new StringBuilder().append("SELECT DISTINCT a.forgid, a.fdimtype, b.fseq, a.fisincludesuborg FROM t_perm_disfunperm a ").append("LEFT JOIN t_perm_ctrltype b ON a.fdimtype = b.fbizobjectid ").append("WHERE a.fuserid = ").append(userId).append(" ORDER BY b.fseq, a.forgid ");
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), rs -> {
            LinkedHashMap<String, Map> result = new LinkedHashMap<String, Map>(16);
            StringBuilder value = new StringBuilder();
            while (rs.next()) {
                long dimId = rs.getLong(1);
                String dimType = rs.getString(2);
                String includeSub = rs.getString(4);
                value.append(dimId).append(",").append(includeSub).append(",0");
                result.computeIfAbsent(dimType, k -> new LinkedHashMap(16)).put(String.valueOf(dimId), value.toString());
                value.setLength(0);
            }
            return result;
        });
    }

    public static Map<String, Map<String, String>> getUserDimDisFuncPerm(Long userId, List<Long> dimIds, String dimType) {
        StringBuilder sql = new StringBuilder().append("SELECT DISTINCT a.forgid, a.fdimtype, b.fseq, a.fisincludesuborg FROM t_perm_disfunperm a ").append("LEFT JOIN t_perm_ctrltype b ON a.fdimtype = b.fbizobjectid ").append("WHERE a.fuserid = ").append(userId).append(" ORDER BY b.fseq, a.forgid ");
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), rs -> {
            LinkedHashMap<String, Map> result = new LinkedHashMap<String, Map>(16);
            StringBuilder value = new StringBuilder();
            while (rs.next()) {
                long dimId = rs.getLong(1);
                String includeSub = rs.getString(4);
                value.append(dimId).append(",").append(includeSub).append(",0");
                result.computeIfAbsent(dimType, k -> new LinkedHashMap(16)).put(String.valueOf(dimId), value.toString());
                value.setLength(0);
            }
            return result;
        });
    }

    public static boolean isUserIgnoreCheckDisFuncPerm(long userId) {
        return PermissionServiceHelper.isAdminUser((long)userId, (String)"10") || PermissionServiceHelper.isSuperUser((long)userId);
    }
}

