/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SingleOrgContextHelper;
import kd.bos.entity.filter.CompareInputType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.perm.NewDrPerm;
import kd.bos.permission.model.perm.NewDrPrPerm;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.product.ICoreProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class DrHelper {
    private static Log log = LogFactory.getLog(DrHelper.class);

    @Deprecated
    public static List<Long> getDataRulesId(Long dataRuleId) {
        if (null == dataRuleId || 0L == dataRuleId) {
            return new ArrayList<Long>(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select fid from t_perm_datarules_entry where fdataruleid in (");
        sb.append(" select fid from t_perm_datarule_entry where fdataruleid = ? ");
        sb.append(")");
        sb.append(" union ");
        sb.append("select fid from t_perm_datarules_entry where fdataruleid in (");
        sb.append(" select fid from t_perm_datarule_prop where fdataruleid = ? ");
        sb.append(")");
        Object[] params = new Object[]{dataRuleId, dataRuleId};
        return (List)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> innerList = new ArrayList<Long>(8);
                while (rs.next()) {
                    innerList.add(rs.getLong("fid"));
                }
                return innerList;
            }
        });
    }

    public static List<Long> getUserIdList(Long dataRuleId) {
        if (null == dataRuleId || 0L == dataRuleId) {
            return new ArrayList<Long>(1);
        }
        final HashSet result = new HashSet(8);
        StringBuilder sb = new StringBuilder();
        Set<String> roleIdSet = null;
        boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        if (hasEnableRoleDataRuleNewModel) {
            roleIdSet = new HashSet<String>(8);
            sb.setLength(0);
            sb.append("select distinct a.froleid ");
            sb.append(" from t_perm_roledatarule a ");
            sb.append(" inner join t_perm_role b on a.froleid = b.fid and b.fenable ='1' ");
            sb.append(" where a.fdataruleid = ").append(dataRuleId).append(" ");
            Set roleIdSetFromPermItemDr = (Set)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

                public Set<String> handle(ResultSet rs) throws Exception {
                    HashSet<String> set = new HashSet<String>(8);
                    while (rs.next()) {
                        set.add(rs.getString("froleid"));
                    }
                    return set;
                }
            });
            roleIdSet.addAll(roleIdSetFromPermItemDr);
            sb.setLength(0);
            sb.append("select distinct a.froleid ");
            sb.append(" from t_perm_roledatarule_prop a ");
            sb.append(" inner join t_perm_role b on a.froleid = b.fid and b.fenable ='1' ");
            sb.append(" where a.fdataruleid = ").append(dataRuleId).append(" ");
            Set roleIdSetFromPropDr = (Set)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

                public Set<String> handle(ResultSet rs) throws Exception {
                    HashSet<String> set = new HashSet<String>(8);
                    while (rs.next()) {
                        set.add(rs.getString("froleid"));
                    }
                    return set;
                }
            });
            roleIdSet.addAll(roleIdSetFromPropDr);
        } else {
            List<Long> dataRulesIds = DrHelper.getDataRulesId(dataRuleId);
            if (null != dataRulesIds && !dataRulesIds.isEmpty()) {
                List dataRulesIdList = dataRulesIds.stream().map(String::valueOf).collect(Collectors.toList());
                String dataRulesIdStr = String.join((CharSequence)",", dataRulesIdList);
                sb.setLength(0);
                sb.append("select distinct a.froleid ");
                sb.append(" from t_perm_roledatarules a ");
                sb.append(" inner join t_perm_role b on a.froleid = b.fid and b.fenable ='1' ");
                sb.append(" where a.fdatarulesid in (").append(dataRulesIdStr).append(")");
                roleIdSet = (Set)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

                    public Set<String> handle(ResultSet rs) throws Exception {
                        HashSet<String> set = new HashSet<String>(8);
                        while (rs.next()) {
                            set.add(rs.getString("froleid"));
                        }
                        return set;
                    }
                });
            }
        }
        if (null != roleIdSet && !roleIdSet.isEmpty()) {
            Map<String, Set<Long>> roleUserIdSetMap = PermRoleHelper.getRoleUserIdSetMap(roleIdSet);
            for (Map.Entry<String, Set<Long>> roleUserIdSet : roleUserIdSetMap.entrySet()) {
                result.addAll(roleUserIdSet.getValue());
            }
        }
        sb.setLength(0);
        sb.append("select distinct fuserid from t_perm_userdatarule where fdataruleid = ? ");
        sb.append("union ");
        sb.append("select distinct fuserid from t_perm_userdatarule_prop where fdataruleid = ? ");
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])new Object[]{dataRuleId, dataRuleId}, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    result.add(rs.getLong("fuserid"));
                }
                return null;
            }
        });
        return new ArrayList<Long>(result);
    }

    public static Map<Long, Map<String, Object>> getDataRuleMap(final List<Long> dataRuleIdList) {
        if (CollectionUtils.isEmpty(dataRuleIdList)) {
            return new HashMap<Long, Map<String, Object>>(1);
        }
        List dataRuleIds = dataRuleIdList.stream().map(String::valueOf).collect(Collectors.toList());
        String dataRuleIdsStr = String.join((CharSequence)",", dataRuleIds);
        StringBuilder sb = new StringBuilder();
        sb.append("select fid, fnumber, fname, fentitynum from t_perm_datarule where fid in (").append(dataRuleIdsStr).append(")");
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Map<Long, Map<String, Object>>>(){

            public Map<Long, Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>(dataRuleIdList.size());
                HashMap<String, String> map = null;
                while (rs.next()) {
                    Long fid = rs.getLong("fid");
                    String fnumber = rs.getString("fnumber");
                    String fname = rs.getString("fname");
                    String fentitynum = rs.getString("fentitynum");
                    map = new HashMap<String, String>(3);
                    map.put("fnumber", fnumber);
                    map.put("fname", fname);
                    map.put("fentitynum", fentitynum);
                    resultMap.put(fid, map);
                }
                return resultMap;
            }
        });
    }

    public static Set<Long> getAllDrDetailFidSet() {
        StringBuilder sb = new StringBuilder();
        sb.append("select fid from t_perm_datarule where fisdetail = '1'");
        return (Set)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> result = new HashSet<Long>(8);
                while (rs.next()) {
                    result.add(rs.getLong("fid"));
                }
                return result;
            }
        });
    }

    public static Map<Long, Map<String, Object>> getAllDrDetailMap() {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid, a.fnumber, a.fname aName, b.fname bName");
        sb.append(" from t_perm_datarule a ");
        sb.append(" inner join t_perm_datarule_l b on a.fid = b.fid and b.flocaleid=? ");
        sb.append(" where fisdetail = '1' ");
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])new Object[]{RequestContext.get().getLang().name()}, (ResultSetHandler)new ResultSetHandler<Map<Long, Map<String, Object>>>(){

            public Map<Long, Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(8);
                HashMap<String, String> innerMap = null;
                while (rs.next()) {
                    Long fid = rs.getLong("fid");
                    String aName = rs.getString("aName");
                    String bName = rs.getString("bName");
                    String fnumber = rs.getString("fnumber");
                    innerMap = new HashMap<String, String>(2);
                    innerMap.put("fname", StringUtils.isEmpty((Object)bName) ? aName : bName);
                    innerMap.put("fnumber", fnumber);
                    result.put(fid, innerMap);
                }
                return result;
            }
        });
    }

    @Deprecated
    public static Map<String, Object> getDrRulesIdAndRule0IdSetMap(Set<String> roleIdSet) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        final HashMap roleIdRulesIdSetMap = new HashMap(8);
        final HashMap roleIdRule0IdSetMap = new HashMap(8);
        map.put("roleIdRulesIdSetMap", roleIdRulesIdSetMap);
        map.put("roleIdRule0IdSetMap", roleIdRule0IdSetMap);
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return map;
        }
        String roleIdStr = roleIdSet.stream().collect(Collectors.joining("','"));
        StringBuilder sb = new StringBuilder();
        sb.append(" select a.froleid, a.fdatarulesid,  b.fdataruleid ");
        sb.append(" from t_perm_roledatarules a ");
        sb.append(" left join t_perm_datarules_entry b on a.fdatarulesid = b.fid  ");
        sb.append(" where a.froleid in ('").append(roleIdStr).append("') ");
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String froleid = rs.getString("froleid");
                    Long fdatarulesid = rs.getLong("fdatarulesid");
                    Long fdataruleid = rs.getLong("fdataruleid");
                    roleIdRulesIdSetMap.computeIfAbsent(froleid, k -> new HashSet()).add(fdatarulesid);
                    roleIdRule0IdSetMap.computeIfAbsent(froleid, k -> new HashSet()).add(fdataruleid);
                }
                return null;
            }
        });
        return map;
    }

    public static void delByComRoleIdSet(Set<String> roleIdSet) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return;
        }
        boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        if (hasEnableRoleDataRuleNewModel) {
            StringBuilder sbDelRoleDataRule = new StringBuilder();
            String roleIdStr = roleIdSet.stream().collect(Collectors.joining("','"));
            DB.execute((DBRoute)DBRoute.basedata, (String)sbDelRoleDataRule.append("delete from t_perm_roledatarule where froleid in ('").append(roleIdStr).append("') ").toString());
            StringBuilder sbDelRoleDataRuleProp = new StringBuilder();
            DB.execute((DBRoute)DBRoute.basedata, (String)sbDelRoleDataRuleProp.append("delete from t_perm_roledatarule_prop where froleid in ('").append(roleIdStr).append("') ").toString());
        } else {
            DrHelper.delRoleDataRulesByRoleIds(roleIdSet);
        }
    }

    @Deprecated
    private static void delRoleDataRulesByRoleIds(Set<String> roleIdSet) {
        HashSet rulesIdSet = new HashSet(8);
        HashSet rule0IdSet = new HashSet(8);
        Map<String, Object> drRulesIdAndRule0IdSetMap = DrHelper.getDrRulesIdAndRule0IdSetMap(roleIdSet);
        Map roleIdRulesIdSetMap = (Map)drRulesIdAndRule0IdSetMap.get("roleIdRulesIdSetMap");
        for (Map.Entry roleIdRulesIdSet : roleIdRulesIdSetMap.entrySet()) {
            Set set = (Set)roleIdRulesIdSet.getValue();
            if (null == set || set.isEmpty()) continue;
            rulesIdSet.addAll(set);
        }
        Map roleIdRule0IdSetMap = (Map)drRulesIdAndRule0IdSetMap.get("roleIdRule0IdSetMap");
        for (Map.Entry entry : roleIdRule0IdSetMap.entrySet()) {
            Set value = (Set)entry.getValue();
            if (null == value || value.isEmpty()) continue;
            rule0IdSet.addAll(value);
        }
        StringBuilder sb = new StringBuilder();
        String string = roleIdSet.stream().collect(Collectors.joining("','"));
        DB.execute((DBRoute)DBRoute.basedata, (String)sb.append("delete from t_perm_roledatarules where froleid in ('").append(string).append("') ").toString());
        if (null != rulesIdSet && !rulesIdSet.isEmpty()) {
            String rulesIdStr = rulesIdSet.stream().map(String::valueOf).collect(Collectors.joining(","));
            sb.setLength(0);
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.append("delete from t_perm_datarules_entry where fid in (").append(rulesIdStr).append(") ").toString());
            sb.setLength(0);
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.append("delete from t_perm_datarules_l where fid in (").append(rulesIdStr).append(") ").toString());
            sb.setLength(0);
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.append("delete from t_perm_datarules where fid in (").append(rulesIdStr).append(") ").toString());
        }
        if (null != rule0IdSet && !rule0IdSet.isEmpty()) {
            String rule0IdSetStr = rule0IdSet.stream().map(String::valueOf).collect(Collectors.joining(","));
            sb.setLength(0);
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.append("delete from t_perm_datarule_entry where fid in (").append(rule0IdSetStr).append(") ").toString());
            sb.setLength(0);
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.append("delete from t_perm_datarule_prop where fid in (").append(rule0IdSetStr).append(") ").toString());
            sb.setLength(0);
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.append("delete from t_perm_datarule_l where fid in (").append(rule0IdSetStr).append(") ").toString());
            sb.setLength(0);
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.append("delete from t_perm_datarule where fid in (").append(rule0IdSetStr).append(") ").toString());
        }
    }

    public static Map<String, List<NewDrPerm>> compareNewDrPerm(Set<NewDrPerm> pre, Set<NewDrPerm> after) {
        ArrayList<NewDrPerm> preList = new ArrayList<NewDrPerm>(pre);
        ArrayList<NewDrPerm> afterList = new ArrayList<NewDrPerm>(after);
        List<NewDrPerm> delList_ = ListUtil.removeAll(preList, afterList);
        CopyOnWriteArrayList<NewDrPerm> delList = new CopyOnWriteArrayList<NewDrPerm>(delList_);
        List<NewDrPerm> addList_ = ListUtil.removeAll(afterList, preList);
        CopyOnWriteArrayList<NewDrPerm> addList = new CopyOnWriteArrayList<NewDrPerm>(addList_);
        ArrayList updateList = new ArrayList(8);
        delList.stream().forEach(x -> {
            Optional<NewDrPerm> first = addList.stream().filter(y -> y.getAppId().equals(x.getAppId()) && y.getEntityNumber().equals(x.getEntityNumber()) && y.getPermItemId().equals(x.getPermItemId())).findFirst();
            if (first.isPresent()) {
                NewDrPerm ldr = (NewDrPerm)addList.get(0);
                ldr.setDataRuleName(String.valueOf(x.getDataRuleId()));
                updateList.add(ldr);
                delList.remove(x);
                addList.remove(ldr);
            }
        });
        delList.stream().forEach(ldr -> {
            Long dataRuleId = ldr.getDataRuleId();
            ldr.setDataRuleId(Long.valueOf(0L));
            ldr.setDataRuleName(String.valueOf(dataRuleId));
        });
        addList.stream().forEach(ldr -> ldr.setDataRuleName("0"));
        HashMap<String, List<NewDrPerm>> map = new HashMap<String, List<NewDrPerm>>(3);
        map.put("delList", delList);
        map.put("addList", addList);
        map.put("updateList", updateList);
        return map;
    }

    public static Map<String, List<NewDrPrPerm>> compareNewDrPrPerm(Set<NewDrPrPerm> pre, Set<NewDrPrPerm> after) {
        ArrayList<NewDrPrPerm> preList = new ArrayList<NewDrPrPerm>(pre);
        ArrayList<NewDrPrPerm> afterList = new ArrayList<NewDrPrPerm>(after);
        List<NewDrPrPerm> delList_ = ListUtil.removeAll(preList, afterList);
        CopyOnWriteArrayList<NewDrPrPerm> delList = new CopyOnWriteArrayList<NewDrPrPerm>(delList_);
        List<NewDrPrPerm> addList_ = ListUtil.removeAll(afterList, preList);
        CopyOnWriteArrayList<NewDrPrPerm> addList = new CopyOnWriteArrayList<NewDrPrPerm>(addList_);
        ArrayList updateList = new ArrayList(8);
        delList.stream().forEach(x -> {
            Optional<NewDrPrPerm> first = addList.stream().filter(y -> y.getAppId().equals(x.getAppId()) && y.getEntityNumber().equals(x.getEntityNumber()) && y.getPropKey().equals(x.getPropKey()) && y.getPropEntNum().equals(x.getPropEntNum())).findFirst();
            if (first.isPresent()) {
                NewDrPrPerm ldrp = (NewDrPrPerm)addList.get(0);
                ldrp.setDataRuleName(String.valueOf(x.getDataRuleId()));
                updateList.add(ldrp);
                delList.remove(x);
                addList.remove(ldrp);
            }
        });
        delList.stream().forEach(ldrp -> {
            Long dataRuleId = ldrp.getDataRuleId();
            ldrp.setDataRuleId(Long.valueOf(0L));
            ldrp.setDataRuleName(String.valueOf(dataRuleId));
        });
        addList.stream().forEach(ldrp -> ldrp.setDataRuleName("0"));
        HashMap<String, List<NewDrPrPerm>> map = new HashMap<String, List<NewDrPrPerm>>(3);
        map.put("delList", delList);
        map.put("addList", addList);
        map.put("updateList", updateList);
        return map;
    }

    public static CompareType getMyHasRightCtrlTypeCompareType(String permctrlType, String permctrlTypeName) {
        return CompareType.createContant((String)("perm_myhasright_" + permctrlType), (LocaleString)new LocaleString(DrHelper.getMyHasRightPrefixDesc() + permctrlTypeName), (String)"", (boolean)false, (CompareInputType)CompareInputType.INTEGER);
    }

    public static String getMyHasRightPrefixDesc() {
        return ResManager.loadKDString((String)"\u6211\u6709\u6743\u7684", (String)"DrHelper_0", (String)"bos-permission-cache", (Object[])new Object[0]);
    }

    public static void addCustomCompareType(Map<String, Set<CompareType>> filterGridObjectMap, GetFilterFieldsParameter parameterObject) {
        List filterFields = EntityTypeUtil.getFilterFields((GetFilterFieldsParameter)parameterObject);
        MainEntityType mainType = (MainEntityType)parameterObject.getDataEntityType();
        ICoreProductSettingService pService = (ICoreProductSettingService)ServiceFactory.getService(ICoreProductSettingService.class);
        List fields = pService.getFormDisVisitField(parameterObject.getDataEntityType().getName());
        PermCtrlTypeReq req = new PermCtrlTypeReq(null, (Set)Sets.newHashSet((Object[])new String[]{"1"}), null, null, null);
        Map<String, PermCtrlType> permCtrlTypeMap = IsoDimHelper.getEntPermCtrlTypeMap(req);
        HashMap<String, CompareType> paraObjectMap = new HashMap<String, CompareType>(8);
        for (FilterField filterField : filterFields) {
            String refEntityId;
            PermCtrlType permCtrlType;
            IDataEntityProperty grpreffieldProp;
            IDataEntityProperty prop;
            String oriFieldName = filterField.getFieldName();
            String fieldKey = oriFieldName.split("\\.")[0];
            if (!fields.isEmpty() && fields.contains(fieldKey) || parameterObject.isbCompatibleProductMode() && SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)(prop = (IDataEntityProperty)mainType.getAllFields().get(fieldKey))) || !((grpreffieldProp = mainType.findProperty(fieldKey)) instanceof BasedataProp) || null == (permCtrlType = permCtrlTypeMap.get(refEntityId = filterField.getRefEntityId()))) continue;
            String permCtrlTypeName = permCtrlType.getName();
            CompareType myHasRightCtrlTypeCompareType = DrHelper.getMyHasRightCtrlTypeCompareType(refEntityId, permCtrlTypeName);
            int index = oriFieldName.lastIndexOf(".");
            String ff = oriFieldName.substring(0, index);
            paraObjectMap.put(ff, myHasRightCtrlTypeCompareType);
            filterGridObjectMap.computeIfAbsent(ff, k -> new HashSet(8)).add(myHasRightCtrlTypeCompareType);
        }
        for (Map.Entry entry : paraObjectMap.entrySet()) {
            parameterObject.addCustomCompareTypes((String)entry.getKey(), (CompareType)entry.getValue());
        }
    }

    public static Set<String> getUsedDrNumFirst4SetByCompareType(String compareTypeStr) {
        StringBuilder sb = new StringBuilder();
        sb.append("select top 4 fnumber from t_perm_datarule where fisdetail = '1'  and frule like '%\"compareType\":\"").append(compareTypeStr).append("\"%'");
        return (Set)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> set = new HashSet<String>(8);
                while (rs.next()) {
                    set.add(rs.getString("fnumber"));
                }
                return set;
            }
        });
    }
}

