/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.SaveEntityMapInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class EntityMapHelper {
    public static final String ENTITYTYPE_ENITYMAP = "perm_entitymap";
    public static final String FIELD_SRCENTITY = "srcentity";
    private static Log logger = LogFactory.getLog(EntityMapHelper.class);

    public static String[] changeCheckPermEntity(String pSrcEntNum, String pSrcAppId) {
        return EntityMapHelper.changeCheckPermEntity(pSrcEntNum, pSrcAppId, null);
    }

    public static String[] changeCheckPermEntity(String pSrcEntNum, String pSrcAppId, List<SaveEntityMapInfo> allEntityMap) {
        String[] result = new String[]{pSrcEntNum, pSrcAppId};
        return result;
    }

    public static List<SaveEntityMapInfo> getAllCheckPermEntityMap() {
        ArrayList<SaveEntityMapInfo> result = new ArrayList<SaveEntityMapInfo>(8);
        return result;
    }

    private static boolean isGlaxyMode() {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modelType = licenseService.getModeType();
        boolean isGalaxyMode = modelType == 2 || modelType == 4;
        return isGalaxyMode;
    }

    public static Set<String> getAllCheckPermSrcEntities() {
        HashSet<String> result = new HashSet<String>(8);
        List<SaveEntityMapInfo> allMapList = EntityMapHelper.getAllCheckPermEntityMap();
        if (allMapList == null || allMapList.isEmpty()) {
            return new HashSet<String>(8);
        }
        for (SaveEntityMapInfo info : allMapList) {
            String srcEntityNum;
            if (info == null || StringUtils.isEmpty((String)(srcEntityNum = info.getSrcEntityNum()))) continue;
            result.add(srcEntityNum);
        }
        return result;
    }

    public static PermResult saveCheckPermEntMap(List<SaveEntityMapInfo> pEntityMapList, boolean isAdd) {
        String errorMsg = "";
        if (pEntityMapList == null || pEntityMapList.isEmpty()) {
            errorMsg = "entityMapList can't be empty!";
            logger.warn(errorMsg);
            return new PermResult(1, errorMsg, null);
        }
        List<SaveEntityMapInfo> allEntityMapInfoInDB = EntityMapHelper.getAllCheckPermEntityMap();
        if ((allEntityMapInfoInDB == null || allEntityMapInfoInDB.isEmpty()) && !isAdd) {
            logger.warn("saveCheckPermEntMap:nothing delete.");
            return PermResult.ok();
        }
        if (isAdd) {
            for (SaveEntityMapInfo saveEntityMapInfo : pEntityMapList) {
                String pTarEntityNum = saveEntityMapInfo.getTarEntityNum();
                String pSrcEntityNum = saveEntityMapInfo.getSrcEntityNum();
                String desp = saveEntityMapInfo.getDescription();
                if (StringUtils.isEmpty((String)pSrcEntityNum) || StringUtils.isEmpty((String)pTarEntityNum)) {
                    errorMsg = "pSrcEntityNum, pTarEntityNum can't be empty when adding new record!";
                    logger.warn(errorMsg);
                    return new PermResult(1, errorMsg, null);
                }
                if (pSrcEntityNum.equals(pTarEntityNum)) {
                    errorMsg = "Self Mapping is forbidden(pSrcEntityNum can't equal pTarEntityNum)";
                    logger.warn(errorMsg);
                    return new PermResult(1, errorMsg, null);
                }
                for (SaveEntityMapInfo infoFromDB : allEntityMapInfoInDB) {
                    String tarEntityNumFromDB = infoFromDB.getTarEntityNum();
                    String srcEntityNumFromDB = infoFromDB.getSrcEntityNum();
                    if (pSrcEntityNum.equals(tarEntityNumFromDB)) {
                        errorMsg = "EntityMap can't pass on. pSrcEntityNum can't equal tarEntityNumFromDB";
                        logger.warn(errorMsg);
                        return new PermResult(1, errorMsg, null);
                    }
                    if (!pSrcEntityNum.equals(srcEntityNumFromDB)) continue;
                    errorMsg = "Only one target is permitted. pSrcEntityNum has existed in DB";
                    logger.warn(errorMsg);
                    return new PermResult(1, errorMsg, null);
                }
            }
        }
        if (isAdd) {
            String insertSql = "insert into t_perm_entitymap(fid, ftarentity, ftarapp, fsrcentity, fsrcapp, fdescription, fcreatetime) values(?, ?, ?, ?, ?, ?, ?)";
            long[] pkIdArr = DB.genLongIds((String)"t_perm_entitymap", (int)pEntityMapList.size());
            ArrayList insertParamList = new ArrayList(8);
            int arrayIndex = 0;
            for (SaveEntityMapInfo saveEntityMapInfo : pEntityMapList) {
                Object[] params = new Object[7];
                String tarAppId = saveEntityMapInfo.getTarAppId();
                String srcAppId = saveEntityMapInfo.getSrcAppId();
                params[0] = pkIdArr[arrayIndex];
                params[1] = saveEntityMapInfo.getTarEntityNum();
                params[2] = tarAppId;
                params[3] = saveEntityMapInfo.getSrcEntityNum();
                params[4] = srcAppId;
                params[5] = saveEntityMapInfo.getDescription();
                params[6] = TimeServiceHelper.now();
                ++arrayIndex;
                insertParamList.add(params);
            }
            DB.executeBatch((DBRoute)DBRoute.permission, (String)insertSql, (List)insertParamList);
        } else {
            StringBuilder sbDeleteSql;
            ArrayList<Object[]> fourParamList = new ArrayList<Object[]>(8);
            ArrayList<Object[]> oneParamList = new ArrayList<Object[]>(8);
            for (SaveEntityMapInfo saveEntityMapInfo : pEntityMapList) {
                String tempTarEntityNum = saveEntityMapInfo.getTarEntityNum();
                String tempTarAppId = saveEntityMapInfo.getTarAppId();
                String tempSrcEntityNum = saveEntityMapInfo.getSrcEntityNum();
                String tempSrcAppId = saveEntityMapInfo.getSrcAppId();
                if (StringUtils.isEmpty((String)tempSrcEntityNum) && StringUtils.isEmpty((String)tempSrcAppId)) {
                    oneParamList.add(new Object[]{tempTarEntityNum});
                }
                fourParamList.add(new Object[]{tempTarEntityNum, tempTarAppId, tempSrcEntityNum, tempSrcAppId});
            }
            if (!fourParamList.isEmpty()) {
                sbDeleteSql = new StringBuilder("delete from t_perm_entitymap ").append(" where ftarentity = ? and ftarapp = ? and fsrcentity = ? and fsrcapp = ? ");
                DB.executeBatch((DBRoute)DBRoute.permission, (String)sbDeleteSql.toString(), fourParamList);
            }
            if (!oneParamList.isEmpty()) {
                sbDeleteSql = new StringBuilder("delete from t_perm_entitymap where ftarentity = ? ");
                DB.executeBatch((DBRoute)DBRoute.permission, (String)sbDeleteSql.toString(), oneParamList);
            }
        }
        CacheMrg.clearDataEntityCache(ENTITYTYPE_ENITYMAP);
        return PermResult.ok();
    }
}

