/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.enums.EnumsFpsFieldFrom;
import kd.bos.permission.model.perm.FieldPerm;
import kd.bos.permission.model.perm.FieldPermScheme;
import kd.bos.permission.model.perm.UserFieldPermScheme;
import kd.bos.permission.model.perm.req.field.GetFieldPermSchemeF7Req;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class FieldPermSchemeHelper {
    private static Log log = LogFactory.getLog(FieldPermSchemeHelper.class);

    public static Map<Long, FieldPermScheme> getFpsMap(Set<Long> idSet) {
        if (null == idSet || idSet.isEmpty()) {
            return new HashMap<Long, FieldPermScheme>(1);
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", idSet)};
        Map fromCacheMap = BusinessDataServiceHelper.loadFromCache((String)"perm_fieldscheme", (QFilter[])filters);
        if (null == fromCacheMap || fromCacheMap.isEmpty()) {
            return new HashMap<Long, FieldPermScheme>(1);
        }
        HashMap<Long, FieldPermScheme> map = new HashMap<Long, FieldPermScheme>(8);
        FieldPermScheme fieldPermScheme = null;
        ArrayList<FieldPerm> fieldPermList = null;
        FieldPerm fieldPerm = null;
        for (Long mainId : idSet) {
            DynamicObject value = (DynamicObject)fromCacheMap.get(mainId);
            if (null == value) {
                map.put(mainId, fieldPermScheme);
                continue;
            }
            fieldPermScheme = new FieldPermScheme();
            fieldPermScheme.setId(mainId);
            fieldPermScheme.setNumber(value.getString("number"));
            fieldPermScheme.setName(value.getString("name"));
            fieldPermScheme.setFieldFrom(value.getString("fieldfrom"));
            boolean sensitive = value.getBoolean("sensitive");
            fieldPermScheme.setSensitive(sensitive ? "1" : "0");
            fieldPermScheme.setControlFieldType(value.getString("controlfieldtype"));
            fieldPermScheme.setControlMode(value.getString("controlmode"));
            fieldPermScheme.setEnable(value.getString("enable"));
            fieldPermScheme.setDesc(value.getString("desc"));
            fieldPermScheme.setSystem(value.getString("issystem"));
            String entityNumber = value.getString("ent_id");
            fieldPermScheme.setEntityNumber(entityNumber);
            fieldPermScheme.setAppId(value.getString("app_id"));
            fieldPermScheme.setCreatorid(Long.valueOf(value.getLong("creator_id")));
            fieldPermScheme.setCreateTime(value.getString("createtime"));
            fieldPermScheme.setModifierid(Long.valueOf(value.getLong("modifier_id")));
            fieldPermScheme.setModifytime(value.getString("modifytime"));
            DynamicObjectCollection fieldperm_entry = value.getDynamicObjectCollection("fieldperm_entry");
            if (null == fieldperm_entry || fieldperm_entry.isEmpty()) {
                map.put(mainId, fieldPermScheme);
                continue;
            }
            fieldPermList = new ArrayList<FieldPerm>(fieldperm_entry.size());
            for (DynamicObject fieldperm : fieldperm_entry) {
                fieldPerm = new FieldPerm();
                String fieldName = fieldperm.getString("fieldperm_fieldnum");
                fieldPerm.setFieldName(fieldName);
                String controlMode = fieldperm.getString("fieldperm_rowcondition");
                fieldPerm.setControlMode(controlMode);
                fieldPermList.add(fieldPerm);
            }
            fieldPermScheme.setFieldPermList(fieldPermList);
            map.put(mainId, fieldPermScheme);
        }
        return map;
    }

    public static Set<Long> getUserIdSet(Set<Long> fpsIdSet) {
        if (null == fpsIdSet || fpsIdSet.isEmpty()) {
            return new HashSet<Long>(1);
        }
        final HashSet<Long> result = new HashSet<Long>(8);
        StringBuilder sb = new StringBuilder();
        List fpsIdList = fpsIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String fpsIdStr = String.join((CharSequence)",", fpsIdList);
        sb.setLength(0);
        sb.append("select distinct a.froleid ");
        sb.append(" from t_perm_rolefieldscheme a ");
        sb.append(" inner join t_perm_role b on a.froleid = b.fid and b.fenable ='1' ");
        sb.append(" where a.ffieldpermschemeid in (").append(fpsIdStr).append(")");
        Set roleIdSet = (Set)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> set = new HashSet<String>(8);
                while (rs.next()) {
                    set.add(rs.getString("froleid"));
                }
                return set;
            }
        });
        if (null != roleIdSet && !roleIdSet.isEmpty()) {
            Map<String, Set<Long>> roleUserIdSetMap = PermRoleHelper.getRoleUserIdSetMap(roleIdSet);
            for (Map.Entry<String, Set<Long>> roleUserIdSet : roleUserIdSetMap.entrySet()) {
                result.addAll((Collection)roleUserIdSet.getValue());
            }
        }
        sb.setLength(0);
        sb.append("select distinct fuserid from t_perm_userfieldscheme where ffieldpermschemeid in (").append(fpsIdStr).append(")");
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    result.add(rs.getLong("fuserid"));
                }
                return null;
            }
        });
        return result;
    }

    public static List<QFilter> getFpsQfilter(String entNum, boolean sensitive, Set<String> excludeFpsIdSet) {
        ArrayList<QFilter> qList = new ArrayList<QFilter>(10);
        if (kd.bos.util.StringUtils.isEmpty((String)entNum)) {
            return qList;
        }
        QFilter q1 = new QFilter("ent", "=", (Object)entNum);
        Set<Long> fpsIdSetByFieldType = FieldPermSchemeHelper.getFpsIdSetByFieldType(entNum);
        if (null != fpsIdSetByFieldType && !fpsIdSetByFieldType.isEmpty()) {
            QFilter q2 = new QFilter("id", "in", fpsIdSetByFieldType);
            qList.add(q1.or(q2));
        } else {
            qList.add(q1);
        }
        qList.add(new QFilter("sensitive", "=", (Object)(sensitive ? "1" : "0")));
        qList.add(new QFilter("enable", "=", (Object)"1"));
        if (null != excludeFpsIdSet && !excludeFpsIdSet.isEmpty()) {
            Set collect = excludeFpsIdSet.stream().map(Long::valueOf).collect(Collectors.toSet());
            qList.add(new QFilter("id", "not in", collect));
        }
        return qList;
    }

    private static Set<Long> getFpsIdSetByFieldType(String entNum) {
        if (StringUtils.isEmpty((CharSequence)entNum)) {
            return new HashSet<Long>(1);
        }
        GetFieldPermSchemeF7Req req = new GetFieldPermSchemeF7Req(null, entNum, EnumsFpsFieldFrom.FIELD_TYPE.getType(), null);
        List<FieldPermScheme> list = FieldPermSchemeHelper.getFieldPermSchemes(req);
        if (null == list || list.isEmpty()) {
            return new HashSet<Long>(1);
        }
        return list.stream().map(FieldPermScheme::getId).collect(Collectors.toSet());
    }

    public static List<FieldPermScheme> getFieldPermSchemes(GetFieldPermSchemeF7Req req) {
        String entNum = req.getEntNum();
        String appId = req.getAppId();
        Set excludeSchemeIdSet = req.getExcludeSchemeIdSet();
        String fieldFrom = req.getFieldFrom();
        if (kd.bos.util.StringUtils.isEmpty((String)entNum)) {
            return new ArrayList<FieldPermScheme>(1);
        }
        Map<String, Map<String, Set<String>>> entItemClassFieldMap = FormHelper.getEntityItemClassFieldMap(Sets.newHashSet((Object[])new String[]{entNum}));
        if (null == entItemClassFieldMap || entItemClassFieldMap.isEmpty()) {
            return new ArrayList<FieldPermScheme>(1);
        }
        Map<String, Set<String>> entityItemClassFieldMap = entItemClassFieldMap.get(entNum);
        if (null == entityItemClassFieldMap || entityItemClassFieldMap.isEmpty()) {
            return new ArrayList<FieldPermScheme>(1);
        }
        ArrayList<String> paramList = new ArrayList<String>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select b.fid, b.fnumber, b.fname bName, b.fcontrolfieldtype, b.fcontrolmode, b.fappid, b.fentnum, b.ffieldfrom, b.fsensitive, b.fenable, b.fdesc, ");
        sb.append(" b.fcreatorid, b.fcreatetime, b.fmodifierid, b.fmodifytime, b.fissystem, ");
        sb.append(" c.fname cName ");
        sb.append(" from t_perm_fieldscheme b ");
        sb.append(" inner join t_perm_fieldscheme_l c on c.fid = b.fid and c.flocaleid = ? ");
        paramList.add(RequestContext.get().getLang().name());
        sb.append(" where b.fenable ='1' and b.ffieldfrom =? ");
        paramList.add(fieldFrom);
        if (Objects.equals(EnumsFpsFieldFrom.FIELD.getType(), fieldFrom)) {
            if (StringUtils.isNotEmpty((CharSequence)appId)) {
                sb.append(" and b.fappid = ? ");
                paramList.add(appId);
            }
            if (StringUtils.isNotEmpty((CharSequence)entNum)) {
                sb.append(" and b.fentnum = ? ");
                paramList.add(entNum);
            }
        }
        if (null != excludeSchemeIdSet && !excludeSchemeIdSet.isEmpty()) {
            List excludeSchemeIdList = excludeSchemeIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            String excludeSchemeIdStr = String.join((CharSequence)",", excludeSchemeIdList);
            sb.append(" and b.fid not in (").append(excludeSchemeIdStr).append(")");
        }
        ArrayList<FieldPermScheme> list = new ArrayList<FieldPermScheme>(10);
        try (DataSet ds = DB.queryDataSet((String)"FieldPermSchemeHelper.getFieldPermSchemes", (DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));){
            UserFieldPermScheme one = null;
            while (ds.hasNext()) {
                Row row = ds.next();
                String fentnum = row.getString("fentnum");
                if (kd.bos.util.StringUtils.isNotEmpty((String)fentnum) && !Objects.equals(entNum, fentnum)) continue;
                String fcontrolfieldtype = row.getString("fcontrolfieldtype");
                one = new UserFieldPermScheme();
                Long fid = row.getLong("fid");
                one.setId(fid);
                one.setNumber(row.getString("fnumber"));
                String bName = row.getString("bName");
                String cName = row.getString("cName");
                one.setName(kd.bos.util.StringUtils.isEmpty((String)cName) ? bName : cName);
                one.setFieldFrom(row.getString("ffieldfrom"));
                one.setSensitive(row.getString("fsensitive"));
                one.setControlFieldType(fcontrolfieldtype);
                one.setControlMode(row.getString("fcontrolmode"));
                one.setEnable(row.getString("fenable"));
                one.setDesc(row.getString("fdesc"));
                one.setAppId(row.getString("fappid"));
                one.setEntityNumber(fentnum);
                one.setCreatorid(row.getLong("fcreatorid"));
                String fcreatetime = row.getString("fcreatetime");
                one.setCreateTime(fcreatetime);
                one.setModifierid(row.getLong("fmodifierid"));
                String fmodifytime = row.getString("fmodifytime");
                one.setModifytime(fmodifytime);
                one.setSystem(row.getString("fissystem"));
                if (Objects.equals(EnumsFpsFieldFrom.FIELD.getType(), fieldFrom)) {
                    list.add((FieldPermScheme)one);
                    continue;
                }
                if (!Objects.equals(EnumsFpsFieldFrom.FIELD_TYPE.getType(), fieldFrom)) continue;
                try {
                    if (kd.bos.util.StringUtils.isEmpty((String)fcontrolfieldtype) || !entityItemClassFieldMap.containsKey(fcontrolfieldtype)) continue;
                    list.add((FieldPermScheme)one);
                }
                catch (Exception e) {
                    log.warn("FieldPermSchemeHelper.getFieldPermSchemes analyse fcontrolfieldtype error.", (Throwable)e);
                }
            }
        }
        return list;
    }

    public static void buildControlFieldTypeComboEdit(String entNum, ComboEdit comboEdit) {
        if (kd.bos.util.StringUtils.isEmpty((String)entNum) || null == comboEdit) {
            return;
        }
        MainEntityType dataEntityType = null;
        try {
            dataEntityType = EntityMetadataCache.getDataEntityType((String)entNum);
            if (dataEntityType == null) {
                log.debug("FieldPermSchemeHelper.buildControlFieldTypeComboEdit, entNum:{} Not Found ", (Object)entNum);
                return;
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u5bf9\u8c61\u3010%1$s\u3011\u6709\u8fd0\u884c\u65f6\u4f46\u6ca1\u6709\u8bbe\u8ba1\u65f6\uff0c\u8bf7\u68c0\u67e5\u786e\u8ba4\u3002", (String)"FieldPermSchemeHelper_1", (String)"bos-permission-cache", (Object[])new Object[0]), entNum));
        }
        Map<String, String> entNumModelTypeMap = FormHelper.getEntNumModelTypeMap(Sets.newHashSet((Object[])new String[]{entNum}));
        if (CollectionUtils.isEmpty(entNumModelTypeMap)) {
            return;
        }
        String modelType = entNumModelTypeMap.get(entNum);
        if (kd.bos.util.StringUtils.isEmpty((String)modelType)) {
            return;
        }
        FieldPermSchemeHelper.buildControlFieldTypeComboEdit(comboEdit, Sets.newHashSet((Object[])new String[]{modelType}));
    }

    public static void buildControlFieldTypeComboEdit(ComboEdit comboEdit) {
        Set<String> distinctModelTypeSet = FormHelper.getDistinctModelTypeSet();
        FieldPermSchemeHelper.buildControlFieldTypeComboEdit(comboEdit, distinctModelTypeSet);
    }

    private static void buildControlFieldTypeComboEdit(ComboEdit comboEdit, Set<String> modelTypeSet) {
        if (null == comboEdit || null == modelTypeSet || modelTypeSet.isEmpty()) {
            return;
        }
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(10);
        ComboItem comboItem = null;
        for (String modelType : modelTypeSet) {
            DomainModelType domainModelType;
            List categories;
            if (kd.bos.util.StringUtils.isEmpty((String)modelType) || CollectionUtils.isEmpty((Collection)(categories = (domainModelType = DomainModelType.getDomainModelType((String)modelType)).getCategories()))) continue;
            for (Category category : categories) {
                List elementTypes = category.getElementTypes();
                if (null == elementTypes || elementTypes.isEmpty()) continue;
                for (ElementType elementType : elementTypes) {
                    String name;
                    String className = elementType.getClassName();
                    LocaleString localeString = elementType.getName();
                    if (kd.bos.util.StringUtils.isEmpty((String)className) || null == localeString || kd.bos.util.StringUtils.isEmpty((String)(name = localeString.getLocaleValue())) || PermHelperConst.HIDE_CONTROL_FIELDTYPE_SET.contains(className) || !className.startsWith("kd.bos.metadata.entity")) continue;
                    comboItem = new ComboItem();
                    comboItem.setId(className);
                    comboItem.setValue(className);
                    comboItem.setCaption(new LocaleString(name));
                    comboItemList.add(comboItem);
                }
            }
        }
        comboEdit.setMustInput(false);
        comboEdit.setComboItems(comboItemList);
    }
}

