/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.RefEntityTypeCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.model.Dim;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.PermBuilder;
import kd.bos.permission.model.perm.PermCtrlType;
import kd.bos.permission.model.perm.req.PermCtrlTypeReq;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class IsoDimHelper {
    private static Log log = LogFactory.getLog(IsoDimHelper.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_IsoDimHelper_Pool", (int)2);

    public static void reWriteMultiBasedataType(GetEntityTypeEventArgs args, String controlFlag, PermCtrlTypeReq req) {
        try {
            MainEntityType oldMainType = args.getOriginalEntityType();
            MainEntityType newMainType = (MainEntityType)oldMainType.clone();
            IsoDimHelper.rewriteMainEntityType(controlFlag, req, newMainType);
            args.setNewEntityType(newMainType);
        }
        catch (Exception exp) {
            log.warn("IsoDimHelper.reWriteMultiBasedataType error.", (Throwable)exp);
            throw new KDException("IsoDimHelper.reWriteMultiBasedataType error." + exp.getMessage());
        }
    }

    public static void rewriteMainEntityType(String controlFlag, PermCtrlTypeReq req, MainEntityType mainEntityType) {
        try {
            List<PermCtrlType> permCtrlTypeList;
            DynamicProperty dimtypeDynPro = mainEntityType.getProperty(controlFlag);
            if (null == dimtypeDynPro) {
                return;
            }
            if (null == req) {
                req = new PermCtrlTypeReq((Set)Sets.newHashSet((Object[])new String[]{"1"}), null, null, (Set)Sets.newHashSet((Object[])new String[]{"bos_objecttype"}), null);
            }
            if (null == (permCtrlTypeList = IsoDimHelper.getPermCtrlTypeList(req)) || permCtrlTypeList.isEmpty()) {
                return;
            }
            int size = permCtrlTypeList.size();
            LinkedHashMap<String, RefEntityType> itemTypesNew = new LinkedHashMap<String, RefEntityType>(size);
            ArrayList<String> baseEntityIdsNew = new ArrayList<String>(size);
            ArrayList<ValueMapItem> comboItemsNew = new ArrayList<ValueMapItem>(size);
            ItemClassTypeProp property = (ItemClassTypeProp)dimtypeDynPro;
            Map itemTypes = property.getItemTypes();
            List baseEntityIds = property.getBaseEntityIds();
            List comboItems = property.getComboItems();
            for (PermCtrlType permCtrlType : permCtrlTypeList) {
                String entNum = permCtrlType.getBizobjectid();
                try {
                    RefEntityType refEntityType = null;
                    refEntityType = itemTypes.containsKey(entNum) ? (RefEntityType)((DynamicObjectType)itemTypes.get(entNum)).clone() : IsoDimHelper.getRefEntityType(entNum);
                    if (refEntityType == null) {
                        throw new KDBizException("IsoDimHelper.rewriteMainEntityType, Perm DimType " + entNum + " refEntityType Not Found. ");
                    }
                    LocaleString caption = StringUtils.isEmpty((String)permCtrlType.getName()) ? refEntityType.getDisplayName() : new LocaleString(permCtrlType.getName());
                    refEntityType = (RefEntityType)refEntityType.clone();
                    refEntityType.setDisplayName(caption);
                    itemTypesNew.put(entNum, refEntityType);
                    baseEntityIdsNew.add(entNum);
                    ValueMapItem one = new ValueMapItem("", entNum, caption);
                    comboItemsNew.add(one);
                }
                catch (Exception e2) {
                    log.info("IsoDimHelper.rewriteMainEntityType error, {} Not Found.", (Object)entNum, (Object)e2);
                }
            }
            itemTypes.clear();
            itemTypes.putAll(itemTypesNew);
            baseEntityIds.clear();
            baseEntityIds.addAll(baseEntityIdsNew);
            comboItems.clear();
            comboItems.addAll(comboItemsNew);
        }
        catch (Exception e) {
            log.warn("IsoDimHelper.rewriteMainEntityType error.", (Throwable)e);
            throw new KDException("IsoDimHelper.rewriteMainEntityType error." + e.getMessage());
        }
    }

    private static RefEntityType getRefEntityType(String entNum) {
        RequestContext rc = RequestContext.get();
        String key = String.format("%s%s%s", "getRefEntityType_", rc.getAccountId(), entNum);
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            HashMap<String, RefEntityType> map = new HashMap<String, RefEntityType>(8);
            RefEntityType refEntityType = RefEntityTypeCache.getRefEntityType((String)entNum, (boolean)true);
            if (null == refEntityType) {
                return map;
            }
            map.put("refEntityType", refEntityType);
            return map;
        });
        return (RefEntityType)threadCacheMap.get("refEntityType");
    }

    public static List<PermCtrlType> getPermCtrlTypeList(PermCtrlTypeReq req) {
        ArrayList<PermCtrlType> list = new ArrayList<PermCtrlType>(8);
        Map<String, Object> sql_paramsMap = IsoDimHelper.getPermCtrlTypeSqlParamsMap(req);
        String sql = (String)sql_paramsMap.get("sql");
        List paramList = (List)sql_paramsMap.get("paramList");
        try (DataSet permCtrlTypeDs = DB.queryDataSet((String)"IsoDimHelper.getPermCtrlType", (DBRoute)DBRoute.permission, (String)sql, (Object[])paramList.toArray());
             DataSet baseFormDs = DB.queryDataSet((String)"IsoDimHelper.getBaseFormType", (DBRoute)DBRoute.meta, (String)"select fnumber bfnum from t_meta_entitydesign where fmodeltype = 'BaseFormModel'");
             DataSet finalDs = permCtrlTypeDs.join(baseFormDs).on("fbizobjectid", "bfnum").select(new String[]{"fid", "fmasterid", "fmodifytime", "fcreatetime", "fenable", "fmodifierid", "fcreatorid", "fstatus", "fnumber", "fbizobjectid", "aName", "bName", "fsystreefilter", "fmyhasright_dr", "fsystem", "fseq"}).finish();){
            PermCtrlType one = null;
            for (Row row : finalDs) {
                one = new PermCtrlType();
                one.setId(row.getString("fid"));
                one.setMasterid(row.getString("fmasterid"));
                one.setModifytime(row.getString("fmodifytime"));
                one.setCreatetime(row.getString("fcreatetime"));
                one.setEnable(row.getString("fenable"));
                one.setModifierid(row.getString("fmodifierid"));
                one.setCreatorid(row.getString("fcreatorid"));
                one.setStatus(row.getString("fstatus"));
                one.setNumber(row.getString("fnumber"));
                one.setBizobjectid(row.getString("fbizobjectid"));
                String bName = row.getString("bName");
                String aName = row.getString("aName");
                one.setName(StringUtils.isEmpty((String)bName) ? aName : bName);
                one.setSysTreeFilter(row.getString("fsystreefilter"));
                one.setMyhasrightDr(row.getString("fmyhasright_dr"));
                one.setSystem(row.getString("fsystem"));
                one.setSeq(row.getInteger("fseq"));
                list.add(one);
            }
        }
        return list;
    }

    public static Map<String, PermCtrlType> getEntPermCtrlTypeMap(PermCtrlTypeReq req) {
        Map<String, Object> sql_paramsMap = IsoDimHelper.getPermCtrlTypeSqlParamsMap(req);
        String sql = (String)sql_paramsMap.get("sql");
        List paramList = (List)sql_paramsMap.get("paramList");
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Map<String, PermCtrlType>>(){

            public Map<String, PermCtrlType> handle(ResultSet rs) throws Exception {
                HashMap<String, PermCtrlType> map = new HashMap<String, PermCtrlType>(8);
                PermCtrlType one = null;
                while (rs.next()) {
                    one = new PermCtrlType();
                    one.setId(rs.getString("fid"));
                    one.setMasterid(rs.getString("fmasterid"));
                    one.setModifytime(rs.getString("fmodifytime"));
                    one.setCreatetime(rs.getString("fcreatetime"));
                    one.setEnable(rs.getString("fenable"));
                    one.setModifierid(rs.getString("fmodifierid"));
                    one.setCreatorid(rs.getString("fcreatorid"));
                    one.setStatus(rs.getString("fstatus"));
                    one.setNumber(rs.getString("fnumber"));
                    String fbizobjectid = rs.getString("fbizobjectid");
                    one.setBizobjectid(fbizobjectid);
                    String bName = rs.getString("bName");
                    String aName = rs.getString("aName");
                    one.setName(StringUtils.isEmpty((String)bName) ? aName : bName);
                    one.setSysTreeFilter(rs.getString("fsystreefilter"));
                    one.setMyhasrightDr(rs.getString("fmyhasright_dr"));
                    one.setSystem(rs.getString("fsystem"));
                    one.setSeq(Integer.valueOf(rs.getInt("fseq")));
                    map.put(fbizobjectid, one);
                }
                return map;
            }
        });
    }

    public static Map<String, PermCtrlType> getBigPermCtrlTypeMap(PermCtrlTypeReq req) {
        Map<String, Object> sql_paramsMap = IsoDimHelper.getPermCtrlTypeSqlParamsMap(req);
        String sql = (String)sql_paramsMap.get("sql");
        List paramList = (List)sql_paramsMap.get("paramList");
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Map<String, PermCtrlType>>(){

            public Map<String, PermCtrlType> handle(ResultSet rs) throws Exception {
                HashMap<String, PermCtrlType> map = new HashMap<String, PermCtrlType>(8);
                PermCtrlType one = null;
                while (rs.next()) {
                    one = new PermCtrlType();
                    one.setId(rs.getString("fid"));
                    one.setMasterid(rs.getString("fmasterid"));
                    one.setModifytime(rs.getString("fmodifytime"));
                    one.setCreatetime(rs.getString("fcreatetime"));
                    one.setEnable(rs.getString("fenable"));
                    one.setModifierid(rs.getString("fmodifierid"));
                    one.setCreatorid(rs.getString("fcreatorid"));
                    one.setStatus(rs.getString("fstatus"));
                    String fnumber = rs.getString("fnumber");
                    one.setNumber(fnumber);
                    one.setBizobjectid(rs.getString("fbizobjectid"));
                    String bName = rs.getString("bName");
                    String aName = rs.getString("aName");
                    one.setName(StringUtils.isEmpty((String)bName) ? aName : bName);
                    one.setSysTreeFilter(rs.getString("fsystreefilter"));
                    one.setMyhasrightDr(rs.getString("fmyhasright_dr"));
                    one.setSystem(rs.getString("fsystem"));
                    one.setSeq(Integer.valueOf(rs.getInt("fseq")));
                    map.put(fnumber, one);
                }
                return map;
            }
        });
    }

    public static Map<String, PermCtrlType> getPermCtrlTypeMap(PermCtrlTypeReq req) {
        Map<String, Object> sql_paramsMap = IsoDimHelper.getPermCtrlTypeSqlParamsMap(req);
        String sql = (String)sql_paramsMap.get("sql");
        List paramList = (List)sql_paramsMap.get("paramList");
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Map<String, PermCtrlType>>(){

            public Map<String, PermCtrlType> handle(ResultSet rs) throws Exception {
                HashMap<String, PermCtrlType> map = new HashMap<String, PermCtrlType>(8);
                PermCtrlType one = null;
                while (rs.next()) {
                    one = new PermCtrlType();
                    String fid = rs.getString("fid");
                    one.setId(fid);
                    one.setMasterid(rs.getString("fmasterid"));
                    one.setModifytime(rs.getString("fmodifytime"));
                    one.setCreatetime(rs.getString("fcreatetime"));
                    one.setEnable(rs.getString("fenable"));
                    one.setModifierid(rs.getString("fmodifierid"));
                    one.setCreatorid(rs.getString("fcreatorid"));
                    one.setStatus(rs.getString("fstatus"));
                    one.setNumber(rs.getString("fnumber"));
                    one.setBizobjectid(rs.getString("fbizobjectid"));
                    String bName = rs.getString("bName");
                    String aName = rs.getString("aName");
                    one.setName(StringUtils.isEmpty((String)bName) ? aName : bName);
                    one.setSysTreeFilter(rs.getString("fsystreefilter"));
                    one.setMyhasrightDr(rs.getString("fmyhasright_dr"));
                    one.setSystem(rs.getString("fsystem"));
                    one.setSeq(Integer.valueOf(rs.getInt("fseq")));
                    map.put(fid, one);
                }
                return map;
            }
        });
    }

    private static Map<String, Object> getPermCtrlTypeSqlParamsMap(PermCtrlTypeReq req) {
        if (null == req) {
            req = new PermCtrlTypeReq();
        }
        Set idSet = req.getIdSet();
        Set sysTreeFilterSet = req.getSysTreeFilterSet();
        Set myhasrightDrSet = req.getMyhasrightDrSet();
        Set numberSet = req.getNumberSet();
        Set excludeBizEntNumSet = req.getExcludeBizEntNumSet();
        Set bizEntNumRangeSet = req.getBizEntNumRangeSet();
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid, a.fmasterid, a.fmodifytime, a.fcreatetime, a.fenable, a.fmodifierid, a.fcreatorid, a.fstatus, a.fnumber, a.fbizobjectid, a.fname aName, b.fname bName, a.fsystreefilter, a.fmyhasright_dr, a.fsystem, a.fseq ");
        sb.append(" from t_perm_ctrltype a");
        sb.append(" left join t_perm_ctrltype_l b on a.fid = b.fid and b.flocaleid = ? ");
        sb.append(" where a.fenable = '1' and a.fstatus = 'C' ");
        if (null != idSet && !idSet.isEmpty()) {
            String idSetStr = String.join((CharSequence)"','", idSet);
            sb.append(" and a.fid in ('").append(idSetStr).append("') ");
        }
        if (null != sysTreeFilterSet && !sysTreeFilterSet.isEmpty()) {
            String sysTreeFilterSetStr = String.join((CharSequence)"','", sysTreeFilterSet);
            sb.append(" and a.fsystreefilter in ('").append(sysTreeFilterSetStr).append("') ");
        }
        if (null != myhasrightDrSet && !myhasrightDrSet.isEmpty()) {
            String myhasrightDrSetStr = String.join((CharSequence)"','", myhasrightDrSet);
            sb.append(" and a.fmyhasright_dr in ('").append(myhasrightDrSetStr).append("') ");
        }
        if (null != numberSet && !numberSet.isEmpty()) {
            String numberSetStr = String.join((CharSequence)"','", numberSet);
            sb.append(" and a.fnumber in ('").append(numberSetStr).append("') ");
        }
        if (null != excludeBizEntNumSet && !excludeBizEntNumSet.isEmpty()) {
            String excludeBizEntNumSetStr = String.join((CharSequence)"','", excludeBizEntNumSet);
            sb.append(" and a.fbizobjectid not in ('").append(excludeBizEntNumSetStr).append("') ");
        }
        if (null != bizEntNumRangeSet && !bizEntNumRangeSet.isEmpty()) {
            String bizEntNumRangeSetStr = String.join((CharSequence)"','", bizEntNumRangeSet);
            sb.append(" and a.fbizobjectid in ('").append(bizEntNumRangeSetStr).append("') ");
        }
        sb.append(" order by a.fseq");
        ArrayList<Lang> paramList = new ArrayList<Lang>(10);
        paramList.add(RequestContext.get().getLang());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sql", sb.toString());
        map.put("paramList", paramList);
        return map;
    }

    public static Set<String> getPermCtrlTypeNumberSet(Set<String> sysTreeFilterSet, Set<String> numberSet) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fnumber ");
        sb.append(" from t_perm_ctrltype a");
        sb.append(" where a.fenable = '1' and a.fstatus = 'C'");
        if (null != sysTreeFilterSet && !sysTreeFilterSet.isEmpty()) {
            String sysTreeFilterSetStr = String.join((CharSequence)"','", sysTreeFilterSet);
            sb.append(" and a.fsystreefilter in ('").append(sysTreeFilterSetStr).append("') ");
        }
        if (null != numberSet && !numberSet.isEmpty()) {
            String numberSetStr = String.join((CharSequence)"','", numberSet);
            sb.append(" and a.fnumber in ('").append(numberSetStr).append("') ");
        }
        return (Set)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> result = new HashSet<String>(8);
                while (rs.next()) {
                    result.add(rs.getString("fnumber"));
                }
                return result;
            }
        });
    }

    public static Map<String, Map<String, Object>> getPermCtrlTypeMap(String langStr) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fbizobjectid, a.fnumber, b.fname bName, a.fname aName, a.fid");
        sb.append(" from t_perm_ctrltype a");
        sb.append(" left join t_perm_ctrltype_l b on a.fid = b.fid");
        sb.append(" where a.fenable = '1' and a.fstatus = 'C' and b.flocaleid = ?");
        Object[] params = new Object[]{langStr};
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Object>>>(){

            public Map<String, Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(8);
                HashMap<String, String> one = null;
                while (rs.next()) {
                    one = new HashMap<String, String>(3);
                    String fbizobjectid = rs.getString("fbizobjectid");
                    String fnumber = rs.getString("fnumber");
                    String bName = rs.getString("bName");
                    String aName = rs.getString("aName");
                    String fid = rs.getString("fid");
                    one.put("fnumber", fnumber);
                    one.put("fname", StringUtils.isEmpty((String)bName) ? aName : bName);
                    one.put("fid", fid);
                    map.put(fbizobjectid, one);
                }
                return map;
            }
        });
    }

    public static Map<Long, Dim> getDimMap(List<Long> ids, String dimType) {
        if (StringUtils.isEmpty((String)dimType)) {
            return new HashMap<Long, Dim>(1);
        }
        String dimSelectProps = IsoDimHelper.getDimSelectProps(dimType);
        if (CollectionUtils.isEmpty(ids)) {
            return IsoDimHelper.getDimMapWithoutIds(dimType, dimSelectProps);
        }
        return IsoDimHelper.getDimMapWithIds(ids, dimType, dimSelectProps);
    }

    private static Map<Long, Dim> getDimMapWithoutIds(final String dimType, String dimSelectProps) {
        if (StringUtils.isEmpty((String)dimType)) {
            return new HashMap<Long, Dim>(1);
        }
        try {
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)dimType);
            if (IsoDimHelper.checkOrgDim(dimType)) {
                String tableName = met.getAlias();
                String dbRouteKey = met.getDBRouteKey();
                BasedataEntityType bdet = (BasedataEntityType)met;
                String numberProperty = bdet.getNumberProperty();
                final String numberField = bdet.findProperty(numberProperty).getAlias();
                String nameProperty = bdet.getNameProperty();
                final String nameField = bdet.findProperty(nameProperty).getAlias();
                StringBuilder sql = new StringBuilder();
                sql.append("select fid");
                sql.append(',').append(numberField);
                sql.append(',').append(nameField);
                sql.append(" from ").append(tableName);
                return (Map)DB.query((DBRoute)DBRoute.of((String)dbRouteKey), (String)sql.toString(), (ResultSetHandler)new ResultSetHandler<Map<Long, Dim>>(){

                    public Map<Long, Dim> handle(ResultSet rs) throws Exception {
                        HashMap<Long, Dim> map = new HashMap<Long, Dim>(rs.getRow());
                        Dim dim = null;
                        while (rs.next()) {
                            Long dimId = rs.getLong("fid");
                            dim = new Dim(dimId, rs.getString(numberField), rs.getString(nameField), dimType);
                            map.put(dimId, dim);
                        }
                        return map;
                    }
                });
            }
            Map<Object, DynamicObject> dObjFromMap = IsoDimHelper.getDimDynMap(null, dimType, dimSelectProps);
            DynamicObject[] dObjFromArr = (DynamicObject[])dObjFromMap.values().stream().toArray(DynamicObject[]::new);
            return IsoDimHelper.getDimMapResult(dObjFromArr, dimType);
        }
        catch (Exception e) {
            log.warn("IsoDimHelper.getDimMapWithoutIds error.", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private static Map<Long, Dim> getDimMapWithIds(List<Long> ids, final String dimType, final String dimSelectProps) {
        if (StringUtils.isEmpty((String)dimType) || CollectionUtils.isEmpty(ids)) {
            return new HashMap<Long, Dim>(1);
        }
        int size = ids.size();
        int m = SqlUtil.getBatchCount(PermHelperConst.CONST_200, size);
        final List<List<Long>> listAvg = ListUtil.averageAssign(ids, m);
        int avgSize = listAvg.size();
        ArrayList<Future> futureList = new ArrayList<Future>(avgSize);
        int i = 0;
        while (i < avgSize) {
            final int finalI = i++;
            futureList.add(pool.submit(new Callable(){

                public Object call() throws Exception {
                    try {
                        Map<Object, DynamicObject> dObjFromMap = IsoDimHelper.getDimDynMap((List)listAvg.get(finalI), dimType, dimSelectProps);
                        DynamicObject[] dObjFromArr = (DynamicObject[])dObjFromMap.values().stream().toArray(DynamicObject[]::new);
                        return IsoDimHelper.getDimMapResult(dObjFromArr, dimType);
                    }
                    catch (Exception e) {
                        log.warn("IsoDimHelper.getDimMapWithIds.call error.", (Throwable)e);
                        throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
                    }
                }
            }));
        }
        HashMap<Long, Dim> resultMap = new HashMap<Long, Dim>(size);
        for (Future future : futureList) {
            try {
                Map o = (Map)future.get();
                resultMap.putAll(o);
            }
            catch (Exception e) {
                log.warn("IsoDimHelper.getDimMapWithIds, for futureList error.", (Throwable)e);
                throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
            }
        }
        return resultMap;
    }

    private static Map<Long, Dim> getDimMapResult(DynamicObject[] dObjFromArr, String dimType) {
        if (null == dObjFromArr || 0 == dObjFromArr.length) {
            return new HashMap<Long, Dim>(1);
        }
        HashMap<Long, Dim> map = new HashMap<Long, Dim>(dObjFromArr.length);
        Dim dim = null;
        for (DynamicObject dynamicObject : dObjFromArr) {
            if (null == dynamicObject) continue;
            long id = dynamicObject.getLong("id");
            IDataEntityType dataEntityType = dynamicObject.getDataEntityType();
            if (!(dataEntityType instanceof BasedataEntityType)) continue;
            BasedataEntityType bet = (BasedataEntityType)dataEntityType;
            String dimObjName = dynamicObject.getString(bet.getNameProperty());
            String dimObjNumber = dynamicObject.getString(bet.getNumberProperty());
            dim = new Dim(id, dimObjNumber, dimObjName, dimType);
            map.put(id, dim);
        }
        return map;
    }

    public static boolean checkOrgDim(String dimType) {
        if (StringUtils.isEmpty((String)dimType)) {
            return true;
        }
        return "DIM_ORG".equals(dimType) || "bos_org".equals(dimType);
    }

    public static boolean checkOrgDimMulti(String dimType) {
        if (StringUtils.isEmpty((String)dimType)) {
            return false;
        }
        return "DIM_ORG".equals(dimType) || "bos_org".equals(dimType);
    }

    public static boolean addDimTypeFilter(String dimType) {
        return !StringUtils.isEmpty((String)dimType) && !Objects.equals("bos_objecttype", dimType);
    }

    public static boolean checkAuthInSysTree(String dimType) {
        if (StringUtils.isEmpty((String)dimType)) {
            return true;
        }
        PermCtrlTypeReq permCtrlTypeReq = new PermCtrlTypeReq((Set)Sets.newHashSet((Object[])new String[]{"1"}), null, null, null, (Set)Sets.newHashSet((Object[])new String[]{dimType}));
        List<PermCtrlType> permCtrlTypeList = IsoDimHelper.getPermCtrlTypeList(permCtrlTypeReq);
        return null != permCtrlTypeList && !permCtrlTypeList.isEmpty();
    }

    public static String getDimSelectProps(String dimType) {
        if (StringUtils.isEmpty((String)dimType)) {
            return "";
        }
        try {
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)dimType);
            BasedataEntityType bdet = (BasedataEntityType)met;
            String numberProperty = bdet.getNumberProperty();
            String nameProperty = bdet.getNameProperty();
            StringBuilder selectProperties = new StringBuilder();
            selectProperties.append(numberProperty);
            selectProperties.append(',').append(nameProperty);
            return selectProperties.toString();
        }
        catch (Exception e) {
            log.warn("IsoDimHelper.getDimSelectProps error.", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    public static Map<String, String> getFieldFlagMap(String entNum, Set<String> typeSet) {
        try {
            if (StringUtils.isEmpty((String)entNum) || CollectionUtils.isEmpty(typeSet)) {
                throw new KDBizException("entNum or typeSet is empty.");
            }
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)entNum);
            if (null == met) {
                throw new KDBizException("met is null.");
            }
            BasedataEntityType bdet = (BasedataEntityType)met;
            if (null == bdet) {
                throw new KDBizException("{} is not a BasedataEntityType" + entNum);
            }
            HashMap<String, String> map = new HashMap<String, String>(8);
            for (String type : typeSet) {
                if (Objects.equals("id", type)) {
                    map.put(type, "id");
                    continue;
                }
                if (Objects.equals("number", type)) {
                    map.put(type, bdet.getNumberProperty());
                    continue;
                }
                if (!Objects.equals("name", type)) continue;
                map.put(type, bdet.getNameProperty());
            }
            return map;
        }
        catch (Exception e) {
            log.warn("IsoDimHelper.getFieldFlagMap error.", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    public static Map<Object, DynamicObject> getDimDynMap(List<Long> dimIdList, String dimType, String dimSelectProps) {
        DynamicObject[] dynamicObjects;
        HashMap<Object, DynamicObject> result = new HashMap<Object, DynamicObject>(10);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        QFilter filter = null;
        if (!CollectionUtils.isEmpty(dimIdList)) {
            filter = new QFilter("id", "in", dimIdList);
            filterList.add(filter);
        }
        if (StringUtils.isEmpty((String)dimSelectProps)) {
            dimSelectProps = IsoDimHelper.getDimSelectProps(dimType);
        }
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)dimType, (String)dimSelectProps, (QFilter[])((QFilter[])filterList.stream().toArray(QFilter[]::new)))) {
            result.put(dynamicObject.getPkValue(), dynamicObject);
        }
        return result;
    }

    public static Map<Object, DynamicObject> getDimDynMapByDs(List<Long> dimIdList, String dimType) {
        try {
            HashMap<Object, DynamicObject> result = new HashMap<Object, DynamicObject>(10);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
            QFilter filter = null;
            if (!CollectionUtils.isEmpty(dimIdList)) {
                filter = new QFilter("id", "in", dimIdList);
                filterList.add(filter);
            }
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)dimType);
            BasedataEntityType bdet = (BasedataEntityType)met;
            String numberProperty = bdet.getNumberProperty();
            String nameProperty = bdet.getNameProperty();
            String dimSelectProps = "id," + numberProperty + ',' + nameProperty;
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"IsoDimHelper.getDimDynMapByDs", (String)dimType, (String)dimSelectProps, (QFilter[])filterList.toArray(new QFilter[filterList.size()]), (String)"");){
                DynamicObject one = null;
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Object id = row.get("id");
                    one = BusinessDataServiceHelper.newDynamicObject((String)dimType);
                    one.set("id", id);
                    one.set(numberProperty, row.get(numberProperty));
                    one.set(nameProperty, row.get(nameProperty));
                    result.put(id, one);
                }
            }
            return result;
        }
        catch (Exception e) {
            log.warn("IsoDimHelper.getDimDynMapByDs error.", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Set<kd.bos.permission.model.perm.Dim>> getDimSetMap(Set<String> idOrNumberOrNameSet, String keyType, String dimType) {
        HashMap<String, Set<kd.bos.permission.model.perm.Dim>> map = new HashMap<String, Set<kd.bos.permission.model.perm.Dim>>(8);
        Map<String, String> fieldFlagMap = IsoDimHelper.getFieldFlagMap(dimType, Sets.newHashSet((Object[])new String[]{"number", "name"}));
        String fieldFlag = Objects.equals("id", keyType) ? "id" : fieldFlagMap.get(keyType);
        String numberField = fieldFlagMap.get("number");
        String nameField = fieldFlagMap.get("name");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != idOrNumberOrNameSet && !CollectionUtils.isEmpty(idOrNumberOrNameSet)) {
            if (Objects.equals("id", fieldFlag)) {
                qFilterList.add(new QFilter("id", "in", idOrNumberOrNameSet.stream().map(Long::valueOf).collect(Collectors.toSet())));
            } else {
                qFilterList.add(new QFilter(fieldFlag, "in", idOrNumberOrNameSet));
            }
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"IsoDimHelper.getDimMap", (String)dimType, (String)("id, " + IsoDimHelper.getDimSelectProps(dimType)), (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");){
            kd.bos.permission.model.perm.Dim one = null;
            while (ds.hasNext()) {
                Row row = ds.next();
                one = new kd.bos.permission.model.perm.Dim();
                Long id = row.getLong("id");
                String number = row.getString(numberField);
                String name = row.getString(nameField);
                one.setDimId(id);
                one.setDimNumber(number);
                one.setDimName(name);
                if (Objects.equals("id", keyType)) {
                    map.computeIfAbsent(String.valueOf(id), k -> new HashSet()).add(one);
                }
                if (Objects.equals("name", keyType)) {
                    map.computeIfAbsent(name, k -> new HashSet()).add(one);
                    continue;
                }
                if (!Objects.equals("number", keyType)) continue;
                map.computeIfAbsent(number, k -> new HashSet()).add(one);
            }
            HashMap<String, Set<kd.bos.permission.model.perm.Dim>> hashMap = map;
            return hashMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Set<DynamicObject>> getDimDynSetMap(Set<String> idOrNumberOrNameSet, String keyType, String dimType) {
        try {
            Map docMap;
            HashMap<String, Set<DynamicObject>> map = new HashMap<String, Set<DynamicObject>>(8);
            Map<String, String> fieldFlagMap = IsoDimHelper.getFieldFlagMap(dimType, Sets.newHashSet((Object[])new String[]{"number", "name"}));
            String fieldFlag = Objects.equals("id", keyType) ? "id" : fieldFlagMap.get(keyType);
            String numberField = fieldFlagMap.get("number");
            String nameField = fieldFlagMap.get("name");
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
            if (null != idOrNumberOrNameSet && !CollectionUtils.isEmpty(idOrNumberOrNameSet)) {
                if (Objects.equals("id", fieldFlag)) {
                    qFilterList.add(new QFilter("id", "in", idOrNumberOrNameSet.stream().map(Long::valueOf).collect(Collectors.toSet())));
                } else {
                    qFilterList.add(new QFilter(fieldFlag, "in", idOrNumberOrNameSet));
                }
            }
            if (CollectionUtils.isEmpty((Map)(docMap = BusinessDataServiceHelper.loadFromCache((String)dimType, (String)("id, " + IsoDimHelper.getDimSelectProps(dimType)), (QFilter[])((QFilter[])qFilterList.stream().toArray(QFilter[]::new)))))) {
                return map;
            }
            for (Map.Entry doc : docMap.entrySet()) {
                Object key = doc.getKey();
                DynamicObject value = (DynamicObject)doc.getValue();
                if (Objects.equals("id", keyType)) {
                    map.computeIfAbsent(String.valueOf(key), k -> new HashSet()).add(value);
                }
                if (Objects.equals("name", keyType)) {
                    map.computeIfAbsent(value.getString(nameField), k -> new HashSet()).add(value);
                    continue;
                }
                if (!Objects.equals("number", keyType)) continue;
                map.computeIfAbsent(value.getString(numberField), k -> new HashSet()).add(value);
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> permCtrlTypeMap() {
        Map map = BusinessDataServiceHelper.loadFromCache((String)"perm_ctrltype", (String)"bizobjectid.id,number", null);
        if (CollectionUtils.isEmpty((Map)map)) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(map.size() * 2);
        for (Map.Entry mm : map.entrySet()) {
            DynamicObject value = (DynamicObject)mm.getValue();
            String number = value.getString("number");
            String bizObjId = value.getString("bizobjectid.id");
            resultMap.put(number, bizObjId);
            resultMap.put(bizObjId, bizObjId);
        }
        return resultMap;
    }

    public static Map<String, String> permCtrlTypeBigMap() {
        Map map = BusinessDataServiceHelper.loadFromCache((String)"perm_ctrltype", (String)"bizobjectid.id,number", null);
        if (CollectionUtils.isEmpty((Map)map)) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(map.size() * 2);
        for (Map.Entry mm : map.entrySet()) {
            DynamicObject value = (DynamicObject)mm.getValue();
            String number = value.getString("number");
            String bizObjId = value.getString("bizobjectid.id");
            resultMap.put(number, number);
            resultMap.put(bizObjId, number);
        }
        return resultMap;
    }

    public static boolean validateDimType(String dimType, Map<String, String> permCtrlTypeMap) {
        if (StringUtils.isEmpty((String)dimType)) {
            return false;
        }
        if (CollectionUtils.isEmpty(permCtrlTypeMap)) {
            permCtrlTypeMap = IsoDimHelper.permCtrlTypeMap();
        }
        return permCtrlTypeMap.containsKey(dimType) && StringUtils.isNotEmpty((String)permCtrlTypeMap.get(dimType)) && !"bos_objecttype".equals(permCtrlTypeMap.get(dimType));
    }

    public static PermResult checkPropRepeat(DynamicObject dyn) {
        String id = dyn.getString("id");
        String number = dyn.getString("number");
        String name = dyn.getString("name");
        String bizobjectid_id = dyn.getString("bizobjectid_id");
        ArrayList<String> paramList = new ArrayList<String>(10);
        paramList.add(number);
        paramList.add(name);
        paramList.add(bizobjectid_id);
        StringBuilder sb = new StringBuilder();
        sb.append("select count(fid) num from t_perm_ctrltype ");
        sb.append(" where (fnumber = ? or fname = ? or fbizobjectid = ? ) ");
        if (StringUtils.isNotEmpty((String)id)) {
            sb.append(" and fid != ? ");
            paramList.add(id);
        }
        return (PermResult)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<PermResult>(){

            public PermResult handle(ResultSet rs) throws Exception {
                int num;
                if (rs.next() && (num = rs.getInt("num")) > 0) {
                    return PermResult.fail((String)ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u3001\u201c\u540d\u79f0\u201d\uff0c\u6216\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"IsoDimHelper_0", (String)"bos-permission-cache", (Object[])new Object[0]));
                }
                return PermResult.ok();
            }
        });
    }

    public static Integer getMaxSeq() {
        StringBuilder sb = new StringBuilder();
        sb.append("select max(fseq) maxSeq from t_perm_ctrltype ");
        return (Integer)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getInt("maxSeq");
                }
                return 0;
            }
        });
    }

    public static String getCtrlTypeName(String bizObjEntNum) {
        if (StringUtils.isEmpty((String)bizObjEntNum)) {
            return "";
        }
        Map<String, Map<String, Object>> permCtrlTypeMap = IsoDimHelper.getPermCtrlTypeMap(RequestContext.get().getLang().name());
        Map<String, Object> permCtrlType = permCtrlTypeMap.get(bizObjEntNum);
        if (null == permCtrlType || permCtrlType.isEmpty()) {
            return "";
        }
        Object fname = permCtrlType.get("fname");
        if (null == fname) {
            return "";
        }
        return String.valueOf(fname);
    }

    public static String getPermCtrlTypeName(String number) {
        PermCtrlTypeReq req = (PermCtrlTypeReq)PermBuilder.of(PermCtrlTypeReq::new).with(PermCtrlTypeReq::setNumberSet, (Object)Sets.newHashSet((Object[])new String[]{number})).build();
        List<QFilter> qfilterList = IsoDimHelper.getQFilter(req);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"IsoDimHelper.getCtrlypeName", (String)"perm_ctrltype", (String)"name", (QFilter[])qfilterList.toArray(new QFilter[qfilterList.size()]), (String)"");){
            if (ds.hasNext()) {
                Row row = ds.next();
                String string = row.getString("name");
                return string;
            }
        }
        return "";
    }

    private static List<QFilter> getQFilter(PermCtrlTypeReq req) {
        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>(10);
        Set numberSet = req.getNumberSet();
        if (null != numberSet && !numberSet.isEmpty()) {
            qfilterList.add(new QFilter("number", "in", (Object)numberSet));
        }
        return qfilterList;
    }
}

