/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class MenuHelper {
    private static Log log = LogFactory.getLog(MenuHelper.class);

    public static Map<String, List<AppMenuInfo>> getAppIdMenuRuntimeListMap(Set<String> appIdSet) {
        String inStr;
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid, a.fseq, a.fappid, a.fformid, a.fparamtype, a.fparams, a.fopentype, a.fparentid, a.fnavivector, a.fshortcuticon, a.fpermission, b.fid appId ");
        sb.append(" from t_meta_menuruntime a ");
        sb.append(" inner join t_meta_bizapp b on a.fappid = b.fnumber ");
        sb.append(" where 1=1 ");
        if (null != appIdSet && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(inStr = SqlUtil.wrapInParam(appIdSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sb.append(" and b.fid in (").append(inStr).append(") ");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Map<String, List<AppMenuInfo>>>(){

            public Map<String, List<AppMenuInfo>> handle(ResultSet rs) throws Exception {
                HashMap<String, List<AppMenuInfo>> map = new HashMap<String, List<AppMenuInfo>>(8);
                AppMenuInfo one = null;
                while (rs.next()) {
                    one = new AppMenuInfo();
                    String appId = rs.getString("appId");
                    one.setId(rs.getString("fid"));
                    one.setSeq(Short.valueOf(rs.getShort("fseq")));
                    one.setAppId(rs.getString("fappid"));
                    one.setFormId(rs.getString("fformid"));
                    one.setParamType(rs.getString("fparamtype"));
                    one.setParams(rs.getString("fparams"));
                    one.setOpenType(rs.getString("fopentype"));
                    one.setParentId(rs.getString("fparentid"));
                    one.setNaviVector(rs.getString("fnavivector"));
                    one.setShortcutIcon(rs.getString("fshortcuticon"));
                    one.setPermission(rs.getString("fpermission"));
                    map.computeIfAbsent(appId, k -> new ArrayList()).add(one);
                }
                return map;
            }
        });
    }

    public static Map<String, String> getMenuFormNum2EntNumMap(Set<String> menuFormNumSet) {
        return MenuHelper.getMenuFormNum2EntNumMap(menuFormNumSet, null);
    }

    public static Map<String, String> getMenuFormNum2EntNumMap(Set<String> menuFormNumSet, String pAppId) {
        String inStr;
        AppInfo appInfo;
        String appNum;
        StringBuilder sb = new StringBuilder();
        sb.append("select c.fformid, a.fnumber ");
        sb.append(" from t_meta_entitydesign a ");
        sb.append(" inner join t_meta_formdesign b on b.fentityid = a.fid ");
        sb.append(" inner join t_meta_menuruntime c on c.fformid= b.fnumber ");
        sb.append(" where c.fformid != ' ' ");
        if (StringUtils.isNotEmpty((String)pAppId) && StringUtils.isNotEmpty((String)(appNum = (appInfo = AppMetadataCache.getAppInfo((String)pAppId)).getAppId()))) {
            sb.append(" and c.fappid = '").append(appNum).append("' ");
        }
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        if (null != menuFormNumSet && !menuFormNumSet.isEmpty() && StringUtils.isNotEmpty((String)(inStr = SqlUtil.wrapInParam(menuFormNumSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sb.append(" and c.fformid in (").append(inStr).append(") ");
        }
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (Object[])paramList.toArray(paramList.toArray(new Object[paramList.size()])), (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> map = new HashMap<String, String>(8);
                while (rs.next()) {
                    map.put(rs.getString("fformid"), rs.getString("fnumber"));
                }
                return map;
            }
        });
    }

    public static Set<String> getMenuEntNums(String pAppId, List<String> pEntNums) {
        HashSet<String> result = new HashSet<String>(8);
        if (StringUtils.isEmpty((String)pAppId) || pEntNums == null || pEntNums.isEmpty()) {
            return result;
        }
        ArrayList<String> tempNewEntNums = new ArrayList<String>(pEntNums);
        Map<String, String> formNumAndEntNumMap = MenuHelper.getMenuFormNum2EntNumMap(null, pAppId);
        if (formNumAndEntNumMap != null && !formNumAndEntNumMap.isEmpty()) {
            tempNewEntNums.retainAll(formNumAndEntNumMap.values());
            result.addAll(tempNewEntNums);
        }
        return result;
    }
}

