/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.FormMetadataCache;
import kd.bos.permission.model.PermResult;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class OperationHelper {
    public static Map<String, String> getOperationTypeInfoMap(String bizObjectId) {
        if (StringUtils.isEmpty((String)bizObjectId)) {
            bizObjectId = "bos_billtpl";
        }
        List<Map<String, String>> operationInfoList = OperationHelper.getOpInfoList(bizObjectId);
        HashMap<String, String> operationTypeInfoMap = new HashMap<String, String>(operationInfoList.size());
        for (Map<String, String> operationInfo : operationInfoList) {
            String operationType = operationInfo.get("operation_type");
            String oneOperationName = operationInfo.get("operation_name");
            operationTypeInfoMap.put(operationType, oneOperationName);
        }
        return operationTypeInfoMap;
    }

    public static List<Map<String, String>> getOpInfoList(String entityNum) {
        entityNum = FormMetadataCache.getFormConfig((String)entityNum).getEntityTypeId();
        List operationList = EntityMetadataCache.getDataEntityOperate((String)entityNum);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(operationList.size());
        for (Map operationInfo : operationList) {
            boolean includeOperationType;
            Map operationNameMap = (Map)operationInfo.get("name");
            LocaleString operationLocaleName = (LocaleString)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)operationNameMap), LocaleString.class);
            String operationName = operationLocaleName.toString();
            String operationKey = (String)operationInfo.get("key");
            String operationType = (String)operationInfo.get("type");
            boolean entityOperation = OperationTypeCache.isEntityOperation((String)operationType);
            boolean bl = includeOperationType = "view".equalsIgnoreCase(operationType) || "modify".equalsIgnoreCase(operationType) || "push".equalsIgnoreCase(operationType);
            if (!entityOperation && !includeOperationType) continue;
            HashMap<String, String> oneOfResult = new HashMap<String, String>();
            result.add(oneOfResult);
            oneOfResult.put("operation_code", operationKey);
            oneOfResult.put("operation_name", operationName);
            oneOfResult.put("operation_type", operationType);
        }
        return result;
    }

    public static Map<String, String> getOperationInfoMap(String bizObjectId) {
        if (StringUtils.isEmpty((String)bizObjectId)) {
            bizObjectId = "bos_billtpl";
        }
        List<Map<String, String>> operationInfoList = OperationHelper.getOpInfoList(bizObjectId);
        HashMap<String, String> operationInfoMap = new HashMap<String, String>(operationInfoList.size());
        for (Map<String, String> operationInfo : operationInfoList) {
            String operationCode = operationInfo.get("operation_code");
            String oneOperationName = operationInfo.get("operation_name");
            operationInfoMap.put(operationCode, oneOperationName);
        }
        return operationInfoMap;
    }

    public static PermResult returnPermResultByOpResult(OperationResult opResult) {
        List validateErrors;
        ValidateResultCollection validateResultColl;
        List allErrorInfo;
        if (opResult == null) {
            return PermResult.ok((Object)"opResult is null");
        }
        if (opResult.isSuccess()) {
            return PermResult.ok();
        }
        StringBuilder sbErrInfo = new StringBuilder(8);
        String errorMsg = opResult.getMessage();
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            sbErrInfo.append(errorMsg).append(" ");
        }
        if ((allErrorInfo = opResult.getAllErrorInfo()) != null && !allErrorInfo.isEmpty()) {
            for (OperateErrorInfo errInfo : allErrorInfo) {
                if (errInfo == null) continue;
                sbErrInfo.append(errInfo.getMessage()).append(" ");
            }
        }
        if ((validateResultColl = opResult.getValidateResult()) != null && (validateErrors = validateResultColl.getValidateErrors()) != null && !validateErrors.isEmpty()) {
            for (ValidateResult validateResult : validateErrors) {
                List opErrInfos;
                if (validateResult == null || (opErrInfos = validateResult.getAllErrorInfo()) == null) continue;
                for (OperateErrorInfo opErrInfo : opErrInfos) {
                    if (opErrInfo == null) continue;
                    String opErrInfoMsg = opErrInfo.getMessage();
                    sbErrInfo.append(opErrInfoMsg).append(" ");
                }
            }
        }
        return PermResult.fail((StringBuilder)sbErrInfo);
    }
}

