/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.OperationHelper;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.model.perm.OperationRule;
import kd.bos.permission.model.perm.req.OperationRuleReq;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class OperationRuleHelper {
    private static Log logger = LogFactory.getLog(OperationRuleHelper.class);

    public static List<OperationRule> getOperationRule(OperationRuleReq req) {
        String appId = req.getAppId();
        String entityNum = req.getEntityNum();
        String opType = req.getOperationType();
        String opKey = req.getOperationKey();
        Set<Object> fieldKeys = new HashSet(16);
        Map<String, String> templateOpInfoMap = OperationHelper.getOperationInfoMap("bos_billtpl");
        Map<Object, Object> curEntityOpInfoMap = new HashMap(16);
        Map<Object, Object> operationKeyMap = new HashMap(16);
        if (entityNum != null) {
            MainEntityType entityTypeInfo = EntityMetadataCache.getDataEntityType((String)entityNum);
            fieldKeys = entityTypeInfo.getAllFields().keySet();
            curEntityOpInfoMap = OperationHelper.getOperationTypeInfoMap(entityNum);
            operationKeyMap = OperationHelper.getOperationInfoMap(entityNum);
        }
        StringBuilder sql = new StringBuilder();
        if (StringUtils.isEmpty((String)appId)) {
            sql.append("SELECT fid, fname, fbizappid, foperationtype, foperationkey, frule, fispublic, fispreset, fenabled FROM t_perm_operationrule WHERE fispublic = '1' ");
        } else {
            sql.append("SELECT fid, fname, fbizappid, fentitytypeid, foperationtype, foperationkey, frule, fispublic, fispreset, fenabled FROM t_perm_operationrule a ").append("WHERE (fispublic = '1' ").append("OR (fentitytypeid = '").append(entityNum).append("' AND fbizappid = '").append(appId).append("')) ");
        }
        if (!StringUtils.isEmpty((String)opType)) {
            sql.append("AND foperationtype = '").append(opType).append("' ");
            if (!StringUtils.isEmpty((String)opKey)) {
                sql.append("AND foperationkey = '").append(opKey).append("' ");
            }
        }
        ArrayList<OperationRule> opRules = null;
        if (StringUtils.isEmpty((String)appId)) {
            Map<Object, Object> finalOperationKeyMap = operationKeyMap;
            opRules = (ArrayList<OperationRule>)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), rs -> {
                ArrayList<OperationRule> result = new ArrayList<OperationRule>(10);
                while (rs.next()) {
                    String ruleId = rs.getString("fid");
                    String name = rs.getString("fname");
                    String operationType = rs.getString("foperationtype");
                    String operationKey = rs.getString("foperationkey");
                    String operationName = (String)templateOpInfoMap.get(operationType);
                    if (StringUtils.isNotEmpty((String)operationKey)) {
                        operationName = (String)finalOperationKeyMap.get(operationKey);
                    }
                    String rule = rs.getString("frule");
                    boolean isPublic = rs.getBoolean("fispublic");
                    boolean preset = rs.getBoolean("fispreset");
                    boolean enable = rs.getBoolean("fenabled");
                    OperationRule opRule = new OperationRule(ruleId, null, name, null, null, operationType, operationKey, operationName, isPublic, preset, enable, rule);
                    result.add(opRule);
                }
                return result;
            });
        } else {
            StringBuilder operationRuleObjSb = new StringBuilder();
            operationRuleObjSb.append("SELECT fid objid, foperationruleid, fobjenabled, fbizappid objappid, fentitytypeid objentity FROM t_perm_operationruleobj ").append("WHERE fentitytypeid = '").append(entityNum).append("' AND fbizappid = '").append(appId).append("' ");
            opRules = new ArrayList<OperationRule>(10);
            try (DataSet operationRuleDS = DB.queryDataSet((String)"getOperationRule-queryOperationRule", (DBRoute)DBRoute.permission, (String)sql.toString());
                 DataSet operationRuleObjDS = DB.queryDataSet((String)"getOperationRule-queryOperationRuleObj", (DBRoute)DBRoute.permission, (String)operationRuleObjSb.toString());
                 DataSet resultDS = operationRuleDS.join(operationRuleObjDS, JoinType.LEFT).on("fid", "foperationruleid").select(new String[]{"fid", "fname", "fbizappid", "fentitytypeid", "foperationtype", "foperationkey", "frule", "fispublic", "fispreset", "fenabled"}, new String[]{"objid", "fobjenabled", "objappid", "objentity"}).finish();){
                block27: while (resultDS.hasNext()) {
                    Row row = resultDS.next();
                    boolean isPublic = row.getBoolean("fispublic");
                    String operationType = row.getString("foperationtype");
                    String operationKey = row.getString("foperationkey");
                    boolean enable = true;
                    String fobjenabled = row.getString("fobjenabled");
                    if (!"1".equals(fobjenabled)) {
                        enable = false;
                    }
                    String rule = null;
                    if (StringUtils.isNotEmpty((String)entityNum)) {
                        if (curEntityOpInfoMap.get(operationType) == null && isPublic && !enable) continue;
                        rule = row.getString("frule");
                        rule = PermCommonUtil.replaceBackSlach(rule);
                        JSONObject jsonObj = JSONObject.parseObject((String)rule);
                        JSONArray jsonArray = jsonObj.getJSONArray("filterRow");
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            JSONObject filterRow = (JSONObject)jsonArray.getObject(i, JSONObject.class);
                            String fieldName = filterRow.getString("fieldName");
                            if (fieldName.contains(".")) {
                                fieldName = fieldName.substring(0, fieldName.indexOf(46));
                            }
                            if (!enable && !fieldKeys.contains(fieldName)) continue block27;
                        }
                    }
                    String operationName = "";
                    operationName = isPublic ? templateOpInfoMap.get(operationType) : (String)curEntityOpInfoMap.get(operationType);
                    if (StringUtils.isNotEmpty((String)operationKey)) {
                        operationName = (String)operationKeyMap.get(operationKey);
                    }
                    String ruleId = row.getString("fid");
                    String ruleObjId = row.getString("objid");
                    String name = row.getString("fname");
                    boolean preset = row.getBoolean("fispreset");
                    String entity = row.getString("objentity");
                    if (StringUtils.isEmpty((String)entity)) {
                        entity = row.getString("fentitytypeid");
                    }
                    OperationRule opRule = new OperationRule(ruleId, ruleObjId, name, appId, entity, operationType, operationKey, operationName, isPublic, preset, enable, rule);
                    opRules.add(opRule);
                }
            }
        }
        return opRules;
    }
}

