/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.model.Org;
import kd.bos.permission.cache.model.OrgPattern;
import kd.bos.permission.model.perm.Dim;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class OrgHelper {
    private static Log logger = LogFactory.getLog(OrgHelper.class);

    @SdkInternal
    public static Set<Long> getOrgIdSet0115() {
        List allOrgList15;
        HashSet<Long> set = new HashSet<Long>(8);
        List allOrgList01 = OrgUnitServiceHelper.getAllOrg((String)"01");
        if (!CollectionUtils.isEmpty((Collection)allOrgList01)) {
            set.addAll(allOrgList01);
        }
        if (!CollectionUtils.isEmpty((Collection)(allOrgList15 = OrgUnitServiceHelper.getAllOrg((String)"15")))) {
            set.addAll(allOrgList15);
        }
        return set;
    }

    @SdkInternal
    public static Map<Long, Org> getAllOrgMap() {
        Map loadMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id, number, name", null);
        if (CollectionUtils.isEmpty((Map)loadMap)) {
            return new HashMap<Long, Org>(1);
        }
        HashMap<Long, Org> map = new HashMap<Long, Org>(loadMap.size());
        for (Map.Entry loadMapOne : loadMap.entrySet()) {
            Long key = (Long)loadMapOne.getKey();
            DynamicObject value = (DynamicObject)loadMapOne.getValue();
            if (null == value) continue;
            String number = value.getString("number");
            String name = value.getString("name");
            Org orgDo = new Org(key, number, name);
            map.put(key, orgDo);
        }
        return map;
    }

    public static Map<String, String> getAllOrgNameMap() {
        String key = String.format("%s%s", "getAllOrgNameMap_", RequestContext.get().getAccountId());
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(8);
            Map<String, String> allOrgNameMapPri = OrgHelper.getAllOrgNameMapPri();
            if (null == allOrgNameMapPri) {
                return map;
            }
            map.put("getAllOrgNameMap_", allOrgNameMapPri);
            return map;
        });
        return (Map)threadCacheMap.get("getAllOrgNameMap_");
    }

    private static Map<String, String> getAllOrgNameMapPri() {
        Map loadMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id, number, name", null);
        if (CollectionUtils.isEmpty((Map)loadMap)) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> map = new HashMap<String, String>(loadMap.size());
        for (Map.Entry loadMapOne : loadMap.entrySet()) {
            String key = String.valueOf(loadMapOne.getKey());
            DynamicObject value = (DynamicObject)loadMapOne.getValue();
            if (null == value) {
                map.put(key, "");
                continue;
            }
            map.put(key, value.getString("name"));
        }
        return map;
    }

    @SdkInternal
    public static Map<Long, Org> getOrgMap(List<Long> orgIdList) {
        if (CollectionUtils.isEmpty(orgIdList)) {
            return new HashMap<Long, Org>(1);
        }
        HashMap<Long, Org> map = new HashMap<Long, Org>(8);
        QFilter idFilter = new QFilter("id", "in", orgIdList);
        QFilter[] filters = new QFilter[]{idFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgHelper.getOrgMap", (String)"bos_org", (String)"id, number, name", (QFilter[])filters, (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long id = row.getLong("id");
                String number = row.getString("number");
                String name = row.getString("name");
                Org orgDo = new Org(id, number, name);
                map.put(id, orgDo);
            }
        }
        return map;
    }

    @SdkInternal
    public static Map<String, OrgPattern> getOrgPatternMap() {
        DynamicObject[] arr = BusinessDataServiceHelper.load((String)"bos_org_pattern", (String)"id, number, name, patterntype", null);
        if (null == arr || 0 == arr.length) {
            return new HashMap<String, OrgPattern>(1);
        }
        HashMap<String, OrgPattern> map = new HashMap<String, OrgPattern>(arr.length);
        Arrays.stream(arr).forEach(x -> {
            String id = x.getString("id");
            String number = x.getString("number");
            String patterntype = x.getString("patterntype");
            String name = x.getString("name");
            OrgPattern orgDo = new OrgPattern(id, number, patterntype, name);
            map.put(id, orgDo);
        });
        return map;
    }

    public static Map<String, String> getOrgPatternTypeMap() {
        String key = String.format("%s%s", "getOrgPatternTypeMap_", RequestContext.get().getAccountId());
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(8);
            Map<String, String> orgPatternTypeMapPri = OrgHelper.getOrgPatternTypeMapPri();
            if (null == orgPatternTypeMapPri) {
                return map;
            }
            map.put("getOrgPatternTypeMap_", orgPatternTypeMapPri);
            return map;
        });
        return (Map)threadCacheMap.get("getOrgPatternTypeMap_");
    }

    private static Map<String, String> getOrgPatternTypeMapPri() {
        DynamicObject[] arr = BusinessDataServiceHelper.load((String)"bos_org_pattern", (String)"id, number, name, patterntype", null);
        if (null == arr || 0 == arr.length) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> map = new HashMap<String, String>(arr.length);
        Arrays.stream(arr).forEach(x -> {
            long id = x.getLong("id");
            String patterntype = x.getString("patterntype");
            map.put(String.valueOf(id), patterntype);
        });
        return map;
    }

    @SdkInternal
    public static String[] getSuitableViewId(String viewNumberOrId) {
        if (StringUtils.isEmpty((String)viewNumberOrId)) {
            logger.warn("OrgHelper.getSuitableViewId, viewNumberOrId is empty.");
            return new String[]{"", ""};
        }
        String selectProperties = "id,number";
        DynamicObject dObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_viewschema", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)viewNumberOrId)});
        if (null != dObj) {
            return new String[]{dObj.getString("number"), dObj.getString("id")};
        }
        dObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_viewschema", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(viewNumberOrId))});
        if (null != dObj) {
            return new String[]{dObj.getString("number"), dObj.getString("id")};
        }
        logger.warn("OrgHelper.getSuitableViewId, find by viewNumberOrId is empty.");
        return new String[]{"", ""};
    }

    @SdkInternal
    public static Map<String, Set<Dim>> getOrgMap(Set<String> idOrNumberOrNameSet, String keyType) {
        HashMap<String, Set<Dim>> map = new HashMap<String, Set<Dim>>(8);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("id", keyType)) {
            qFilterList.add(new QFilter("id", "in", idOrNumberOrNameSet.stream().map(Long::valueOf).collect(Collectors.toSet())));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("number", keyType)) {
            qFilterList.add(new QFilter("number", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("name", keyType)) {
            qFilterList.add(new QFilter("name", "in", idOrNumberOrNameSet));
        }
        Dim one = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgHelper.getOrgMap", (String)"bos_org", (String)"id, number, name", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                one = new Dim();
                Long id = row.getLong("id");
                String number = row.getString("number");
                String name = row.getString("name");
                one.setDimId(id);
                one.setDimNumber(number);
                one.setDimName(name);
                if (Objects.equals("id", keyType)) {
                    map.computeIfAbsent(String.valueOf(id), k -> new HashSet()).add(one);
                    continue;
                }
                if (Objects.equals("name", keyType)) {
                    map.computeIfAbsent(name, k -> new HashSet()).add(one);
                    continue;
                }
                if (!Objects.equals("number", keyType)) continue;
                map.computeIfAbsent(number, k -> new HashSet()).add(one);
            }
        }
        return map;
    }
}

