/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.model.PermUserRole;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class OrgUserHelper {
    @Deprecated
    public static Map<String, List<PermUserRole>> getOrgUserMapByRoleAndDim(String roleId, String dimType) {
        List<PermUserRole> list = OrgUserHelper.getByRoleAndDim(roleId, null, null, null, dimType);
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<String, List<PermUserRole>>(1);
        }
        return list.stream().collect(Collectors.groupingBy(x -> x.getForgid() + "_" + x.getFisincludesuborg()));
    }

    public static Map<Long, List<PermUserRole>> getOrgUserMapByRoleAndDim(String roleId, List<Long> dimIdList, String dimType) {
        List<PermUserRole> list = OrgUserHelper.getByRoleAndDim(roleId, null, null, dimIdList, dimType);
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<Long, List<PermUserRole>>(1);
        }
        return list.stream().collect(Collectors.groupingBy(PermUserRole::getForgid));
    }

    public static Set<Long> getDimIdSet(String roleId, List<Long> dimIdList, String dimType) {
        List dimIds;
        String dimIdStr;
        List<String> roleIdList;
        LinkedHashSet<Long> resultSet = new LinkedHashSet<Long>(8);
        StringBuilder sql = new StringBuilder("select a.forgid");
        sql.append(" from t_perm_userrole a");
        boolean isOrgDim = IsoDimHelper.checkOrgDim(dimType);
        if (isOrgDim) {
            sql.append(" inner join t_sec_user b on a.fuserid = b.fid ");
            sql.append(" inner join t_org_org c on a.forgid = c.fid ");
        }
        sql.append(" where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>(8);
        List<String> list = roleIdList = StringUtils.isEmpty((String)roleId) ? null : Collections.singletonList(roleId);
        if (CollectionUtils.isEmpty(roleIdList)) {
            sql.append(" and a.froleid > ' ' ");
        } else {
            String roleIdStr = String.join((CharSequence)"','", roleIdList);
            sql.append(" and a.froleid in ('").append(roleIdStr).append("')");
        }
        if (StringUtils.isNotEmpty((String)dimType)) {
            sql.append(" and a.fdimtype = ?");
            paramList.add(dimType);
        }
        sql.append(" and a.fisincludesuborg in('0','1')");
        sql.append(" and a.fuserid > 0");
        if (!CollectionUtils.isEmpty(dimIdList) && StringUtils.isNotEmpty((String)(dimIdStr = String.join((CharSequence)",", dimIds = dimIdList.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sql.append(" and a.forgid in (").append(dimIdStr).append(")");
        }
        Object[] params = paramList.toArray(new String[paramList.size()]);
        try (DataSet urDs = DB.queryDataSet((String)OrgUserHelper.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params);){
            while (urDs.hasNext()) {
                Row rs = urDs.next();
                resultSet.add(rs.getLong("forgid"));
            }
            LinkedHashSet<Long> linkedHashSet = resultSet;
            return linkedHashSet;
        }
    }

    @Deprecated
    public static Map<Long, List<PermUserRole>> getUserOrgMapByRoleAndDim(String roleId, String dimType) {
        List<PermUserRole> list = OrgUserHelper.getByRoleAndDim(roleId, null, null, null, dimType);
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<Long, List<PermUserRole>>(1);
        }
        return list.stream().collect(Collectors.groupingBy(x -> x.getFuserid()));
    }

    public static Map<Long, List<PermUserRole>> getUserOrgMapByRoleAndDim(String roleId, List<Long> userIdList, String dimType) {
        List<PermUserRole> list = OrgUserHelper.getByRoleAndDim(roleId, null, userIdList, null, dimType);
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<Long, List<PermUserRole>>(1);
        }
        return list.stream().collect(Collectors.groupingBy(x -> x.getFuserid()));
    }

    public static Set<Long> getUserIdSet(String roleId, List<Long> userIdList, String dimType) {
        List<String> roleIdList;
        LinkedHashSet<Long> resultSet = new LinkedHashSet<Long>(8);
        StringBuilder sql = new StringBuilder("select a.fuserid");
        sql.append(" from t_perm_userrole a");
        boolean isOrgDim = IsoDimHelper.checkOrgDim(dimType);
        if (isOrgDim) {
            sql.append(" inner join t_sec_user b on a.fuserid = b.fid ");
            sql.append(" inner join t_org_org c on a.forgid = c.fid ");
        }
        sql.append(" where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>(8);
        List<String> list = roleIdList = StringUtils.isEmpty((String)roleId) ? null : Collections.singletonList(roleId);
        if (CollectionUtils.isEmpty(roleIdList)) {
            sql.append(" and a.froleid > ' ' ");
        } else {
            String roleIdStr = String.join((CharSequence)"','", roleIdList);
            sql.append(" and a.froleid in ('").append(roleIdStr).append("')");
        }
        if (StringUtils.isNotEmpty((String)dimType)) {
            sql.append(" and a.fdimtype = ?");
            paramList.add(dimType);
        }
        sql.append(" and a.fisincludesuborg in('0','1')");
        if (!CollectionUtils.isEmpty(userIdList)) {
            List collect = userIdList.stream().map(String::valueOf).collect(Collectors.toList());
            String userIdStr = String.join((CharSequence)",", collect);
            sql.append(" and a.fuserid in (").append(userIdStr).append(")");
        } else {
            sql.append(" and a.fuserid > 0");
        }
        Object[] params = paramList.toArray(new String[paramList.size()]);
        try (DataSet urDs = DB.queryDataSet((String)OrgUserHelper.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params);){
            while (urDs.hasNext()) {
                Row rs = urDs.next();
                resultSet.add(rs.getLong("fuserid"));
            }
            LinkedHashSet<Long> linkedHashSet = resultSet;
            return linkedHashSet;
        }
    }

    public static List<PermUserRole> getByDimAndOther(List<String> roleIdList, List<String> includeSubList, List<Long> userIdList, List<Long> dimIdList, String dimType) {
        boolean isOrgDim = IsoDimHelper.checkOrgDim(dimType);
        StringBuilder sql = new StringBuilder("select a.froleid, a.fdimtype, a.fisincludesuborg, a.fuserid, a.forgid, a.fstarttime, a.fendtime, a.fid ");
        sql.append(" from t_perm_userrole a");
        if (isOrgDim) {
            sql.append(" inner join t_sec_user b on a.fuserid = b.fid ");
            sql.append(" inner join t_org_org c on a.forgid = c.fid ");
        }
        sql.append(" where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>(8);
        if (CollectionUtils.isEmpty(roleIdList)) {
            sql.append(" and a.froleid > ' ' ");
        } else {
            String roleIdStr = String.join((CharSequence)"','", roleIdList);
            sql.append(" and a.froleid in ('").append(roleIdStr).append("')");
        }
        if (StringUtils.isNotEmpty((String)dimType)) {
            sql.append(" and a.fdimtype = ?");
            paramList.add(dimType);
        }
        if (CollectionUtils.isEmpty(includeSubList)) {
            sql.append(" and a.fisincludesuborg in('0','1')");
        } else {
            String includeSubStr = String.join((CharSequence)"','", includeSubList);
            sql.append(" and a.fisincludesuborg in ('").append(includeSubStr).append("')");
        }
        if (!CollectionUtils.isEmpty(userIdList)) {
            List collect = userIdList.stream().map(String::valueOf).collect(Collectors.toList());
            String userIdStr = String.join((CharSequence)",", collect);
            sql.append(" and a.fuserid in (").append(userIdStr).append(")");
        } else {
            sql.append(" and a.fuserid > 0");
        }
        if (!CollectionUtils.isEmpty(dimIdList)) {
            List dimIds = dimIdList.stream().map(String::valueOf).collect(Collectors.toList());
            String dimIdStr = String.join((CharSequence)",", dimIds);
            sql.append(" and a.forgid in (").append(dimIdStr).append(")");
        }
        Object[] params = paramList.toArray(new String[paramList.size()]);
        try (DataSet urDs = DB.queryDataSet((String)OrgUserHelper.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params);){
            ArrayList<PermUserRole> list = new ArrayList<PermUserRole>(32);
            PermUserRole one = null;
            while (urDs.hasNext()) {
                Row rs = urDs.next();
                one = new PermUserRole();
                one.setFroleid(rs.getString("froleid"));
                one.setFdimtype(rs.getString("fdimtype"));
                one.setFisincludesuborg(rs.getString("fisincludesuborg"));
                one.setFuserid(rs.getLong("fuserid"));
                one.setForgid(rs.getLong("forgid"));
                one.setFstarttime(rs.getDate("fstarttime"));
                one.setFendtime(rs.getDate("fendtime"));
                one.setFid(rs.getString("fid"));
                list.add(one);
            }
            ArrayList<PermUserRole> arrayList = list;
            return arrayList;
        }
    }

    public static List<PermUserRole> getPURList(Set<String> roleIdSet, Set<String> includeSubSet, Set<Long> userIdSet, Set<Long> dimIdSet, Set<String> dimTypeSet, boolean roleAssignUser) {
        StringBuilder sql = new StringBuilder("select a.froleid, a.fdimtype, a.fisincludesuborg, a.fuserid, a.forgid, a.fstarttime, a.fendtime, a.fid ");
        sql.append(" from t_perm_userrole a");
        StringBuilder whereStr = new StringBuilder("and (");
        if (roleAssignUser) {
            String roleIdStr = String.join((CharSequence)"','", roleIdSet);
            sql.append(" where a.froleid in ('").append(roleIdStr).append("') ");
            if (userIdSet != null && !userIdSet.isEmpty()) {
                List collect = userIdSet.stream().map(String::valueOf).collect(Collectors.toList());
                String userIdStr = String.join((CharSequence)",", collect);
                whereStr.append(" a.fuserid in (").append(userIdStr).append(") or");
            }
        } else {
            List collect = userIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            String userIdStr = String.join((CharSequence)",", collect);
            sql.append(" where a.fuserid in (").append(userIdStr).append(") ");
            if (roleIdSet != null && !roleIdSet.isEmpty()) {
                String roleIdStr = String.join((CharSequence)"','", roleIdSet);
                whereStr.append(" a.froleid in ('").append(roleIdStr).append("') or");
            }
        }
        if (null != dimTypeSet && !dimTypeSet.isEmpty()) {
            String dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet);
            whereStr.append(" a.fdimtype in ('").append(dimTypeSetStr).append("') or");
        }
        if (null != includeSubSet && !includeSubSet.isEmpty()) {
            String includeSubStr = String.join((CharSequence)"','", includeSubSet);
            whereStr.append(" a.fisincludesuborg in ('").append(includeSubStr).append("') or");
        }
        if (null != dimIdSet && !dimIdSet.isEmpty()) {
            List dimIds = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            String dimIdStr = String.join((CharSequence)",", dimIds);
            whereStr.append(" a.forgid in (").append(dimIdStr).append(") or");
        }
        if (!Objects.equals(Character.valueOf('('), Character.valueOf(whereStr.charAt(whereStr.length() - 1)))) {
            whereStr.deleteCharAt(whereStr.length() - 1).deleteCharAt(whereStr.length() - 1).append(')');
            sql.append((CharSequence)whereStr);
        }
        try (DataSet urDs = DB.queryDataSet((String)OrgUserHelper.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString());){
            ArrayList<PermUserRole> list = new ArrayList<PermUserRole>(32);
            PermUserRole one = null;
            while (urDs.hasNext()) {
                Row rs = urDs.next();
                one = new PermUserRole();
                one.setFroleid(rs.getString("froleid"));
                one.setFdimtype(rs.getString("fdimtype"));
                one.setFisincludesuborg(rs.getString("fisincludesuborg"));
                one.setFuserid(rs.getLong("fuserid"));
                one.setForgid(rs.getLong("forgid"));
                one.setFstarttime(rs.getDate("fstarttime"));
                one.setFendtime(rs.getDate("fendtime"));
                one.setFid(rs.getString("fid"));
                list.add(one);
            }
            ArrayList<PermUserRole> arrayList = list;
            return arrayList;
        }
    }

    public static Map<String, List<DynamicObject>> getByDimAndOtherMap(Set<String> roleIdSet, Set<String> includeSubSet, Set<Long> userIdSet, Set<Long> dimIdSet, Set<String> dimTypeSet) {
        ArrayList<QFilter> qfilterList = new ArrayList<QFilter>(8);
        if (CollectionUtils.isEmpty(roleIdSet)) {
            qfilterList.add(new QFilter("role", ">", (Object)" "));
        } else {
            qfilterList.add(new QFilter("role", "in", roleIdSet));
        }
        if (!CollectionUtils.isEmpty(dimTypeSet)) {
            qfilterList.add(new QFilter("itemclasstypefield", "in", dimTypeSet));
        }
        if (CollectionUtils.isEmpty(includeSubSet)) {
            qfilterList.add(new QFilter("includesuborg", "in", (Object)Sets.newHashSet((Object[])new String[]{"0", "1"})));
        } else {
            qfilterList.add(new QFilter("includesuborg", "in", includeSubSet));
        }
        if (CollectionUtils.isEmpty(userIdSet)) {
            qfilterList.add(new QFilter("user", ">", (Object)0));
        } else {
            qfilterList.add(new QFilter("user", "in", userIdSet));
        }
        if (CollectionUtils.isEmpty(dimIdSet)) {
            qfilterList.add(new QFilter("itemclass", ">", (Object)0));
        } else {
            qfilterList.add(new QFilter("itemclass", "in", dimIdSet));
        }
        String selectedField = "id" + "," + "role" + "," + "user" + "," + "itemclass" + "," + "itemclasstypefield" + "," + "includesuborg" + "," + "starttime" + "," + "endtime" + "," + "source" + "," + "fromtypedesc" + "," + "creator" + "," + "createtime" + "," + "modifier" + "," + "modifytime" + "," + "bizroleid" + ",";
        DynamicObject[] arrDObj = BusinessDataServiceHelper.load((String)"perm_userrole_multype", (String)selectedField, (QFilter[])qfilterList.toArray(new QFilter[0]));
        if (null == arrDObj || 0 == arrDObj.length) {
            return new HashMap<String, List<DynamicObject>>(1);
        }
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(arrDObj.length);
        StringBuilder key = null;
        ArrayList<DynamicObject> vList = null;
        for (DynamicObject dobj : arrDObj) {
            key = new StringBuilder();
            key.append(dobj.get("role_id")).append("@@");
            key.append(dobj.get("user_id")).append("@@");
            key.append(dobj.get("itemclass_id")).append("@@");
            key.append(dobj.get("itemclasstypefield"));
            vList = (ArrayList<DynamicObject>)map.get(key.toString());
            if (CollectionUtils.isEmpty((Collection)vList)) {
                vList = new ArrayList<DynamicObject>(8);
                vList.add(dobj);
                map.put(key.toString(), vList);
                continue;
            }
            vList.add(dobj);
        }
        return map;
    }

    public static List<PermUserRole> getByRoleAndDim(String roleId, List<String> includeSubList, List<Long> userIdList, List<Long> dimIdList, String dimType) {
        List<String> roleIdList = StringUtils.isEmpty((String)roleId) ? null : Collections.singletonList(roleId);
        return OrgUserHelper.getByDimAndOther(roleIdList, includeSubList, userIdList, dimIdList, dimType);
    }

    @Deprecated
    public static Map<String, List<PermUserRole>> getOrgRoleMapByRoleAndDim(Long userId, String dimType) {
        List<PermUserRole> list = OrgUserHelper.getByUserAndDim(userId, null, dimType);
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<String, List<PermUserRole>>(1);
        }
        return list.stream().collect(Collectors.groupingBy(x -> x.getForgid() + "_" + x.getFisincludesuborg()));
    }

    public static Map<Long, List<PermUserRole>> getOrgRoleMapByRoleAndDim(Long userId, List<Long> dimIdList, String dimType) {
        List<PermUserRole> list = OrgUserHelper.getByUserAndDim(userId, dimIdList, dimType);
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<Long, List<PermUserRole>>(1);
        }
        return list.stream().collect(Collectors.groupingBy(PermUserRole::getForgid));
    }

    public static List<PermUserRole> getByUserAndDim(Long userId, List<Long> dimIdList, String dimType) {
        return OrgUserHelper.getByDimAndOther(null, null, Collections.singletonList(userId), dimIdList, dimType);
    }

    public static Long getCountByRoleId(String roleId, String dimType) {
        return OrgUserHelper.getCountById(roleId, dimType, "froleid");
    }

    public static Long getCountByUserId(Long userId, String dimType) {
        return OrgUserHelper.getCountById(userId, dimType, "fuserid");
    }

    private static Long getCountById(Object id, String dimType, String queryFieldKey) {
        StringBuilder sql = new StringBuilder("select count(*) num from t_perm_userrole where ").append(queryFieldKey).append(" = ? ");
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(id);
        if (StringUtils.isNotEmpty((String)dimType)) {
            sql.append(" and fdimtype = ? ");
            paramList.add(dimType);
        }
        Object[] params = paramList.toArray(new Object[paramList.size()]);
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getLong("num");
                }
                return 0L;
            }
        });
    }

    public static Map<String, Set<Long>> getRoleAssignDim(String roleId, String dimType) {
        LinkedHashMap<String, Set<Long>> result = new LinkedHashMap<String, Set<Long>>(10);
        if (StringUtils.isEmpty((String)roleId)) {
            return result;
        }
        boolean isOrgDim = IsoDimHelper.checkOrgDim(dimType);
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimType);
        ArrayList<String> paramList = new ArrayList<String>(8);
        paramList.add(roleId);
        StringBuilder sql = new StringBuilder("select a.fdimtype,a.forgid from t_perm_userrole a ");
        if (isOrgDim) {
            sql.append(" inner join t_org_org b on a.forgid = b.fid ");
        }
        sql.append(" where a.froleid = ? ");
        if (StringUtils.isNotEmpty((String)dimType)) {
            sql.append(" and a.fdimtype = ? ");
            paramList.add(suitableDimType[1]);
        }
        sql.append(" order by a.forgid asc ");
        Object[] params = paramList.toArray();
        try (DataSet dataSet = DB.queryDataSet((String)OrgUserHelper.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params).distinct();){
            while (dataSet.hasNext()) {
                Row rs = dataSet.next();
                String fdimtype = rs.getString("fdimtype");
                Long forgid = rs.getLong("forgid");
                result.computeIfAbsent(fdimtype, k -> new LinkedHashSet(10)).add(forgid);
            }
            LinkedHashMap<String, Set<Long>> linkedHashMap = result;
            return linkedHashMap;
        }
    }

    public static Set<Long> getRoleAssignUser(String roleId, boolean onlyOrgDim) {
        HashSet<Long> result = new HashSet<Long>(10);
        if (StringUtils.isEmpty((String)roleId)) {
            return result;
        }
        ArrayList<String> paramList = new ArrayList<String>(8);
        paramList.add(roleId);
        StringBuilder sql = new StringBuilder("select a.fuserid from t_perm_userrole a ").append(" join t_perm_ctrltype ct on (a.fdimtype = ct.fbizobjectid and ct.fsystreefilter = '1') ");
        if (onlyOrgDim) {
            sql.append(" inner join t_org_org b on a.forgid = b.fid ");
        }
        sql.append(" where a.froleid = ? ");
        if (onlyOrgDim) {
            sql.append(" and a.fdimtype = ? ");
            paramList.add("bos_org");
        }
        Object[] params = paramList.toArray();
        try (DataSet dataSet = DB.queryDataSet((String)OrgUserHelper.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params).distinct();){
            while (dataSet.hasNext()) {
                Row rs = dataSet.next();
                result.add(rs.getLong("fuserid"));
            }
            HashSet<Long> hashSet = result;
            return hashSet;
        }
    }

    public static Set<String> getDimUserStrSet(Set<String> roleIdSet, Set<String> queryDBDimTypeSet, Set<Long> queryDBDimIdSet, Set<Long> queryDBUserIdSet, boolean containRole) {
        StringBuilder sql = new StringBuilder("select forgid, fdimtype, fuserid,froleid from t_perm_userrole where 1=1 ");
        if (null != roleIdSet && !roleIdSet.isEmpty()) {
            String roleIdSetStr = String.join((CharSequence)"','", roleIdSet);
            sql.append(" and froleid in ('").append(roleIdSetStr).append("')");
        }
        if (null != queryDBDimTypeSet && !queryDBDimTypeSet.isEmpty()) {
            List queryDBDimTypeList = queryDBDimTypeSet.stream().map(String::valueOf).collect(Collectors.toList());
            String queryDBDimTypeStr = String.join((CharSequence)"','", queryDBDimTypeList);
            sql.append(" and fdimtype in ('").append(queryDBDimTypeStr).append("')");
        }
        if (null != queryDBUserIdSet && !queryDBUserIdSet.isEmpty()) {
            List queryDBUserIdList = queryDBUserIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            String queryDBUserIdStr = String.join((CharSequence)",", queryDBUserIdList);
            sql.append(" and fuserid in (").append(queryDBUserIdStr).append(")");
        }
        if (null != queryDBDimIdSet && !queryDBDimIdSet.isEmpty()) {
            List queryDBDimIdList = queryDBDimIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            String queryDBDimIdStr = String.join((CharSequence)",", queryDBDimIdList);
            sql.append(" and forgid in (").append(queryDBDimIdStr).append(")");
        }
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sql.toString(), resultSet -> {
            HashSet<String> set = new HashSet<String>(8);
            while (resultSet.next()) {
                long forgid = resultSet.getLong("forgid");
                String fdimtype = resultSet.getString("fdimtype");
                if (containRole) {
                    String froleid = resultSet.getString("froleid");
                    set.add(fdimtype + "$" + forgid + "$" + froleid);
                    continue;
                }
                long fuserid = resultSet.getLong("fuserid");
                set.add(fdimtype + "$" + forgid + "$" + fuserid);
            }
            return set;
        });
    }
}

