/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.PermissionControlType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.BizRoleService;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.BizRoleUg;
import kd.bos.permission.cache.model.BizRoleUser;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.model.permbase.App;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.model.perm.BusiRole;
import kd.bos.permission.model.perm.Dim;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.PermItem;
import kd.bos.permission.model.perm.PermLevelHash;
import kd.bos.permission.model.perm.busirole.BusiRoleBcFuncPerm;
import kd.bos.permission.model.perm.busirole.BusiRoleComRole;
import kd.bos.permission.model.perm.busirole.BusiRoleDimObj;
import kd.bos.permission.model.perm.busirole.BusiRoleDisFuncPerm;
import kd.bos.permission.model.perm.req.BusiRoleSearchReq;
import kd.bos.permission.model.perm.req.GetPermLevelHashReq;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermBusiRoleHelper {
    private static Log logger = LogFactory.getLog(PermBusiRoleHelper.class);

    public static Set<Long> getUserIds(Long bizRoleId) {
        List<Long> userIdList = BizRoleService.getUsersByBizRoleID(bizRoleId);
        return new HashSet<Long>(userIdList);
    }

    public static Set<BizRoleUser> getBizRoleUserSet(final Long bizRoleId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select fbizroleid, fuserid, fstarttime, fendtime");
        sb.append(" from t_perm_userbizrole");
        sb.append(" where fbizroleid = ? ");
        Object[] params = new Object[]{bizRoleId};
        return (Set)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Set<BizRoleUser>>(){

            public Set<BizRoleUser> handle(ResultSet rs) throws Exception {
                HashSet<BizRoleUser> bizroleUserSet = new HashSet<BizRoleUser>(8);
                BizRoleUser one = null;
                while (rs.next()) {
                    one = new BizRoleUser();
                    one.setFbizroleid(bizRoleId);
                    one.setFuserid(rs.getLong("fuserid"));
                    String startTimeStr = rs.getString("fstarttime");
                    String endTimeStr = rs.getString("fendtime");
                    Date startTime = StringUtils.isEmpty((String)startTimeStr) ? null : DateUtil.toDate(startTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                    Date endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate(endTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                    one.setFstarttime(startTime);
                    one.setFendtime(endTime);
                    bizroleUserSet.add(one);
                }
                return bizroleUserSet;
            }
        });
    }

    public static Set<BizRoleUg> getBizRoleUgSet(Long bizRoleId, Long userGroupId) {
        StringBuilder sb = new StringBuilder();
        sb.append("select fusrgrpid, fbizroleid ");
        sb.append(" from t_perm_usrgrpbizrole");
        sb.append(" where 1=1 ");
        ArrayList<Long> paramList = new ArrayList<Long>(8);
        if (null != bizRoleId && bizRoleId > 0L) {
            sb.append(" and fbizroleid = ? ");
            paramList.add(bizRoleId);
        }
        if (null != userGroupId && userGroupId > 0L) {
            sb.append(" and fusrgrpid = ? ");
            paramList.add(userGroupId);
        }
        return (Set)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Set<BizRoleUg>>(){

            public Set<BizRoleUg> handle(ResultSet rs) throws Exception {
                HashSet<BizRoleUg> bizroleUserSet = new HashSet<BizRoleUg>(8);
                BizRoleUg one = null;
                while (rs.next()) {
                    one = new BizRoleUg();
                    one.setBusiRoleId(rs.getLong("fbizroleid"));
                    one.setUsrGrpId(rs.getLong("fusrgrpid"));
                    bizroleUserSet.add(one);
                }
                return bizroleUserSet;
            }
        });
    }

    public static List<User> getUserList(Long bizRoleId, String langStr) {
        if (null == bizRoleId || 0L == bizRoleId) {
            return new ArrayList<User>(1);
        }
        try {
            Set<Long> userIdSet = PermBusiRoleHelper.getUserIds(bizRoleId);
            return UserHelper.getUserListBySet(userIdSet, langStr);
        }
        catch (Exception e) {
            logger.warn("PermBusiRoleHelper.getUserList error", (Throwable)e);
            return new ArrayList<User>(1);
        }
    }

    public static Map<String, Set<Long>> getUserIdSetMap(Set<String> roleIdOrNumberSet, String keyType) {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        Map<String, Set<Long>> usrUserIdSetMap = PermBusiRoleHelper.getUsrUserIdSetMap(roleIdOrNumberSet, keyType);
        Map<String, Set<Long>> usrGrpUserIdSetMap = PermBusiRoleHelper.getUsrGrpUserIdSetMap(roleIdOrNumberSet, keyType);
        for (Map.Entry<String, Set<Long>> one : usrUserIdSetMap.entrySet()) {
            map.computeIfAbsent(one.getKey(), k -> new HashSet()).addAll((Collection)one.getValue());
        }
        for (Map.Entry<String, Set<Long>> one : usrGrpUserIdSetMap.entrySet()) {
            map.computeIfAbsent(one.getKey(), k -> new HashSet()).addAll((Collection)one.getValue());
        }
        return map;
    }

    private static Map<String, Set<Long>> getUsrUserIdSetMap(Set<String> roleIdOrNumberSet, final String keyType) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid, a.fnumber, b.fuserid ", new Object[0]);
        sqlBuilder.append(" from t_perm_bizrole a ", new Object[0]);
        sqlBuilder.append(" inner join t_perm_userbizrole b on a.fid = b.fbizroleid ", new Object[0]);
        sqlBuilder.append(" where 1=1 ", new Object[0]);
        if (null != roleIdOrNumberSet && !roleIdOrNumberSet.isEmpty() && Objects.equals("id", keyType)) {
            sqlBuilder.appendIn(" and a.fid", roleIdOrNumberSet.stream().map(Long::valueOf).toArray());
        }
        if (null != roleIdOrNumberSet && !roleIdOrNumberSet.isEmpty() && Objects.equals("number", keyType)) {
            sqlBuilder.appendIn(" and a.fnumber", roleIdOrNumberSet.toArray());
        }
        final HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String bizRoleId = rs.getString("fid");
                    String bizRoleNum = rs.getString("fnumber");
                    Long userId = rs.getLong("fuserid");
                    if (Objects.equals("id", keyType)) {
                        map.computeIfAbsent(bizRoleId, k -> new HashSet()).add(userId);
                        continue;
                    }
                    if (!Objects.equals("number", keyType)) continue;
                    map.computeIfAbsent(bizRoleNum, k -> new HashSet()).add(userId);
                }
                return null;
            }
        });
        return map;
    }

    private static Map<String, Set<Long>> getUsrGrpUserIdSetMap(Set<String> roleIdOrNumberSet, final String keyType) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid, a.fnumber, c.fuserid ", new Object[0]);
        sqlBuilder.append(" from t_perm_bizrole a ", new Object[0]);
        sqlBuilder.append(" inner join t_perm_usrgrpbizrole b on b.fbizroleid = a.fid ", new Object[0]);
        sqlBuilder.append(" inner join t_sec_usergroupstaff c on c.fusergroupid = b.fusrgrpid ", new Object[0]);
        sqlBuilder.append(" where 1=1 ", new Object[0]);
        if (null != roleIdOrNumberSet && !roleIdOrNumberSet.isEmpty() && Objects.equals("id", keyType)) {
            sqlBuilder.appendIn(" and a.fid", roleIdOrNumberSet.stream().map(Long::valueOf).toArray());
        }
        if (null != roleIdOrNumberSet && !roleIdOrNumberSet.isEmpty() && Objects.equals("number", keyType)) {
            sqlBuilder.appendIn(" and a.fnumber", roleIdOrNumberSet.toArray());
        }
        final HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(8);
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    String bizRoleId = rs.getString("fid");
                    String bizRoleNum = rs.getString("fnumber");
                    Long userId = rs.getLong("fuserid");
                    if (Objects.equals("id", keyType)) {
                        map.computeIfAbsent(bizRoleId, k -> new HashSet()).add(userId);
                        continue;
                    }
                    if (!Objects.equals("number", keyType)) continue;
                    map.computeIfAbsent(bizRoleNum, k -> new HashSet()).add(userId);
                }
                return null;
            }
        });
        return map;
    }

    public static Map<Long, Map<String, Object>> getRoleMap(final List<Long> roleIdList, String langStr) {
        if (CollectionUtils.isEmpty(roleIdList)) {
            return new HashMap<Long, Map<String, Object>>(1);
        }
        List roleIds = roleIdList.stream().map(String::valueOf).collect(Collectors.toList());
        String roleIdsStr = String.join((CharSequence)",", roleIds);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid, a.fnumber, a.fname aName, b.fname bName");
        sb.append(" from t_perm_bizrole a");
        sb.append(" left join t_perm_bizrole_l b on a.fid = b.fid and b.flocaleid=?");
        sb.append(" where a.fid in (").append(roleIdsStr).append(")");
        Object[] params = new Object[]{langStr};
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<Long, Map<String, Object>>>(){

            public Map<Long, Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>(roleIdList.size());
                HashMap<String, String> map = null;
                while (rs.next()) {
                    Long fid = rs.getLong("fid");
                    String fnumber = rs.getString("fnumber");
                    String aName = rs.getString("aName");
                    String bName = rs.getString("bName");
                    map = new HashMap<String, String>(2);
                    map.put("fnumber", fnumber);
                    map.put("fname", StringUtils.isEmpty((String)bName) ? aName : bName);
                    resultMap.put(fid, map);
                }
                return resultMap;
            }
        });
    }

    public static Map<String, Set<String>> getComRoleIdBizRoleNumMap(Set<String> comRoleIdSet) {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.froleid, b.fnumber ");
        sb.append(" from t_perm_bizrolecomrole a ");
        sb.append(" left join t_perm_bizrole b on a.fid = b.fid ");
        sb.append(" where 1=1 ");
        if (null != comRoleIdSet && !comRoleIdSet.isEmpty()) {
            String comRoleIdSetStr = String.join((CharSequence)"','", comRoleIdSet);
            sb.append(" and a.froleid in ('").append(comRoleIdSetStr).append("')");
        }
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Map<String, Set<String>>>(){

            public Map<String, Set<String>> handle(ResultSet rs) throws Exception {
                HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
                while (rs.next()) {
                    String roleId = rs.getString("froleid");
                    String bizRoleFnumber = rs.getString("fnumber");
                    map.computeIfAbsent(roleId, k -> new HashSet()).add(bizRoleFnumber);
                }
                return map;
            }
        });
    }

    public static Map<String, Set<String>> getRoleDimTypeSetMap(Set<String> busiRoleIdSet, boolean includeAssignedDim, boolean includeFormDim) {
        if (null == busiRoleIdSet || busiRoleIdSet.isEmpty()) {
            return new HashMap<String, Set<String>>(1);
        }
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>(busiRoleIdSet.size());
        if (includeFormDim) {
            Map<String, Map<String, Set<Entity>>> roleDimTypeEntityMap = PermBusiRoleHelper.getRoleDimTypeEntityMap(busiRoleIdSet, null);
            for (Map.Entry<String, Object> entry : roleDimTypeEntityMap.entrySet()) {
                Map value = (Map)entry.getValue();
                for (Map.Entry dimTypeEntityMap : value.entrySet()) {
                    resultMap.computeIfAbsent(entry.getKey(), k -> new HashSet(8)).add(dimTypeEntityMap.getKey());
                }
            }
        }
        if (includeAssignedDim) {
            Map<String, Set<String>> roleDimTypeSetMapByAssinedDim = PermBusiRoleHelper.getRoleDimTypeSetMapByAssinedDim(busiRoleIdSet);
            for (Map.Entry<String, Object> entry : roleDimTypeSetMapByAssinedDim.entrySet()) {
                resultMap.computeIfAbsent(entry.getKey(), k -> new HashSet(8)).addAll((Collection)entry.getValue());
            }
        }
        return resultMap;
    }

    private static Map<String, Set<String>> getRoleDimTypeSetMapByAssinedDim(Set<String> busiRoleIdSet) {
        if (null == busiRoleIdSet || busiRoleIdSet.isEmpty()) {
            return new HashMap<String, Set<String>>(1);
        }
        String busiRoleIdSetStr = busiRoleIdSet.stream().collect(Collectors.joining(","));
        StringBuilder sb = new StringBuilder();
        sb.append("select fid, fdimtype from t_perm_bizroleorg ");
        sb.append(" where fid in (").append(busiRoleIdSetStr).append(") ");
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Map<String, Set<String>>>(){

            public Map<String, Set<String>> handle(ResultSet rs) throws Exception {
                HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
                while (rs.next()) {
                    map.computeIfAbsent(rs.getString("fid"), k -> new HashSet(8)).add(rs.getString("fdimtype"));
                }
                return map;
            }
        });
    }

    public static Map<String, Map<String, Set<Entity>>> getRoleDimTypeEntityMap(Set<String> busiRoleIdSet, Set<String> dimTypeSet) {
        if (null == busiRoleIdSet || busiRoleIdSet.isEmpty()) {
            return new HashMap<String, Map<String, Set<Entity>>>(1);
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        paraMap.put("busiRoleIdSet", busiRoleIdSet);
        paraMap.put("dimTypeSet", dimTypeSet);
        Map<String, String> permCtrlTypeMap = IsoDimHelper.permCtrlTypeMap();
        paraMap.put("permCtrlTypeMap", permCtrlTypeMap);
        Map<String, DynamicObject> allCloudMap = AppHelper.getAllCloudMap();
        paraMap.put("allCloudMap", allCloudMap);
        Map<String, Map<String, Object>> appInfoMap = AppHelper.getAppInfoMap(new HashMap<String, Object>(1));
        paraMap.put("appInfoMap", appInfoMap);
        Map<String, String> entityNameMap = FormHelper.getAllEntityNameMap(RequestContext.get().getLang().name());
        paraMap.put("entityNameMap", entityNameMap);
        String busiRoleIdSetStr = busiRoleIdSet.stream().collect(Collectors.joining(","));
        HashMap<String, Map<String, Set<Entity>>> resultMap = new HashMap<String, Map<String, Set<Entity>>>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid bizRoleId, b.fbizappid , b.fentitytypeid ");
        sb.append(" from t_perm_bizrolecomrole a ");
        sb.append(" inner join t_perm_rolepermdetial b on a.froleid =b.froleid ");
        sb.append(" where a.fid in (").append(busiRoleIdSetStr).append(") ");
        paraMap.put("sql", sb.toString());
        paraMap.put("paramsList", null);
        Map<String, Map<String, Set<Entity>>> commRoleDimTypeEntityMap = PermBusiRoleHelper.getRoleDimTypeEntityMap(paraMap);
        for (Map.Entry<String, Map<String, Set<Entity>>> entry : commRoleDimTypeEntityMap.entrySet()) {
            String string = entry.getKey();
            Map<String, Set<Entity>> value = entry.getValue();
            for (Map.Entry<String, Set<Entity>> entry2 : value.entrySet()) {
                String string2 = entry2.getKey();
                Set<Entity> entitySet = entry2.getValue();
                resultMap.computeIfAbsent(string, k -> new HashMap(8)).computeIfAbsent(string2, k -> new HashSet(8)).addAll(entitySet);
            }
        }
        sb.setLength(0);
        sb.append("select fid bizRoleId, fbizappid , fentitytypeid ");
        sb.append(" from t_perm_bizroleperm  ");
        sb.append(" where fid in (").append(busiRoleIdSetStr).append(") ");
        paraMap.put("sql", sb.toString());
        paraMap.put("paramsList", null);
        Map<String, Map<String, Set<Entity>>> bcDimTypeEntityMap = PermBusiRoleHelper.getRoleDimTypeEntityMap(paraMap);
        for (Map.Entry<String, Map<String, Set<Entity>>> entry : bcDimTypeEntityMap.entrySet()) {
            String busiRoleId = entry.getKey();
            Map<String, Set<Entity>> value = entry.getValue();
            for (Map.Entry<String, Set<Entity>> entry3 : value.entrySet()) {
                String dimType = entry3.getKey();
                Set<Entity> entitySet = entry3.getValue();
                resultMap.computeIfAbsent(busiRoleId, k -> new HashMap(8)).computeIfAbsent(dimType, k -> new HashSet(8)).addAll(entitySet);
            }
        }
        sb.setLength(0);
        sb.append("select fid bizRoleId, fbizappid , fentitytypeid ");
        sb.append(" from t_perm_bizroledisperm  ");
        sb.append(" where fid in (").append(busiRoleIdSetStr).append(") ");
        paraMap.put("sql", sb.toString());
        paraMap.put("paramsList", null);
        Map<String, Map<String, Set<Entity>>> map = PermBusiRoleHelper.getRoleDimTypeEntityMap(paraMap);
        for (Map.Entry<String, Map<String, Set<Entity>>> roleDimTypeEntity : map.entrySet()) {
            String busiRoleId = roleDimTypeEntity.getKey();
            Map<String, Set<Entity>> map2 = roleDimTypeEntity.getValue();
            for (Map.Entry<String, Set<Entity>> dimTypeEntity : map2.entrySet()) {
                String dimType = dimTypeEntity.getKey();
                Set<Entity> entitySet = dimTypeEntity.getValue();
                resultMap.computeIfAbsent(busiRoleId, k -> new HashMap(8)).computeIfAbsent(dimType, k -> new HashSet(8)).addAll(entitySet);
            }
        }
        return resultMap;
    }

    private static Map<String, Map<String, Set<Entity>>> getRoleDimTypeEntityMap(Map<String, Object> paraMap) {
        Object sql = paraMap.get("sql");
        if (null == sql) {
            logger.warn("PermBusiRoleHelper.getCommRoleDimTypeEntityMap, sql could not be null.");
            return new HashMap<String, Map<String, Set<Entity>>>(1);
        }
        String exeSql = (String)sql;
        Object[] exeParams = null;
        Object paramsList = paraMap.get("paramsList");
        if (null != paramsList) {
            List params = (List)paramsList;
            exeParams = params.toArray(new Object[params.size()]);
        }
        final HashSet dimTypeSet = null == paraMap || null == paraMap.get("dimTypeSet") ? new HashSet(8) : (Set)paraMap.get("dimTypeSet");
        final boolean dimTypeSetEmpty = null == dimTypeSet || dimTypeSet.isEmpty();
        final Map permCtrlTypeMap = null == paraMap || null == paraMap.get("permCtrlTypeMap") ? IsoDimHelper.permCtrlTypeMap() : (Map)paraMap.get("permCtrlTypeMap");
        final HashMap allCloudMap = null == paraMap || null == paraMap.get("allCloudMap") ? new HashMap(8) : (Map)paraMap.get("allCloudMap");
        final HashMap appInfoMap = null == paraMap || null == paraMap.get("appInfoMap") ? new HashMap(8) : (Map)paraMap.get("appInfoMap");
        final HashMap entityNameMap = null == paraMap || null == paraMap.get("entityNameMap") ? new HashMap(8) : (Map)paraMap.get("entityNameMap");
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)exeSql, (Object[])exeParams, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Set<Entity>>>>(){

            public Map<String, Map<String, Set<Entity>>> handle(ResultSet rs) throws Exception {
                HashMap<String, Map<String, Set<Entity>>> map = new HashMap<String, Map<String, Set<Entity>>>(8);
                Entity one = null;
                String cloudId = "";
                String cloudNumber = "";
                String cloudName = "";
                while (rs.next()) {
                    String curDim;
                    String dimType;
                    String fbizappid = rs.getString("fbizappid");
                    String fentitytypeid = rs.getString("fentitytypeid");
                    one = new Entity();
                    DynamicObject cloudObj = (DynamicObject)allCloudMap.get(fbizappid);
                    if (null != cloudObj) {
                        cloudId = cloudObj.getString("bizcloud.id");
                        cloudNumber = cloudObj.getString("bizcloud.number");
                        cloudName = cloudObj.getString("bizcloud.name");
                    }
                    one.setCloudId(cloudId);
                    one.setCloudNumber(cloudNumber);
                    one.setCloudName(cloudName);
                    one.setAppId(fbizappid);
                    Map appMap = (Map)appInfoMap.get(fbizappid);
                    if (null != appMap && !appMap.isEmpty()) {
                        one.setAppNumber((String)appMap.get("number"));
                        one.setAppName((String)appMap.get("name"));
                    }
                    one.setEntityNumber(fentitytypeid);
                    one.setEntityName((String)entityNameMap.get(fentitytypeid));
                    PermissionControlType permissionControlType = FormHelper.getPermissionControlType(fentitytypeid);
                    if (null == permissionControlType || null == (dimType = StringUtils.isEmpty((String)(curDim = permissionControlType.getDimension())) ? "bos_objecttype" : (String)permCtrlTypeMap.get(curDim))) continue;
                    if (dimTypeSetEmpty) {
                        map.computeIfAbsent(rs.getString("bizRoleId"), k -> new HashMap(8)).computeIfAbsent(dimType, k -> new HashSet(8)).add(one);
                        continue;
                    }
                    if (!dimTypeSet.contains(dimType)) continue;
                    map.computeIfAbsent(rs.getString("bizRoleId"), k -> new HashMap(8)).computeIfAbsent(dimType, k -> new HashSet(8)).add(one);
                }
                return map;
            }
        });
    }

    public static Map<String, Long> getNumIdMap(Set<String> numSet) {
        if (null == numSet || numSet.isEmpty()) {
            return new HashMap<String, Long>(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select fnumber, fid from t_perm_bizrole");
        String numSetStr = String.join((CharSequence)"','", numSet);
        sb.append(" where fnumber in ('").append(numSetStr).append("')");
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Map<String, Long>>(){

            public Map<String, Long> handle(ResultSet rs) throws Exception {
                HashMap<String, Long> map = new HashMap<String, Long>(8);
                while (rs.next()) {
                    map.put(rs.getString("fnumber"), rs.getLong("fid"));
                }
                return map;
            }
        });
    }

    public static Set<String> getCommRoleIdSet(Set<Long> busiRoleIdSet) {
        if (null == busiRoleIdSet || busiRoleIdSet.isEmpty()) {
            return new HashSet<String>(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fid ");
        sb.append(" from t_perm_role a ");
        sb.append(" inner join t_perm_bizrolecomrole b on a.fid = b.froleid ");
        sb.append(" where a.fenable = '1' ");
        List busiRoleIdList = busiRoleIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String busiRoleIdStr = String.join((CharSequence)",", busiRoleIdList);
        sb.append(" and b.fid in (").append(busiRoleIdStr).append(')');
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> set = new HashSet<String>(8);
                while (rs.next()) {
                    set.add(rs.getString("fid"));
                }
                return set;
            }
        });
    }

    public static PermLevelHash getCommRolePermLevelHash(GetPermLevelHashReq req) {
        Set busiRoleIdSet = req.getBusiRoleIdSet();
        if (null == busiRoleIdSet || busiRoleIdSet.isEmpty()) {
            return new PermLevelHash(false, new HashMap(1));
        }
        Set<String> commRoleIdSet = PermBusiRoleHelper.getCommRoleIdSet(busiRoleIdSet);
        if (null == commRoleIdSet || commRoleIdSet.isEmpty()) {
            return new PermLevelHash(false, new HashMap(1));
        }
        ArrayList<String> paramList = new ArrayList<String>(10);
        final boolean justPermItem = req.isJustPermItem();
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fbizappid, a.fentitytypeid, a.fpermitemid ");
        if (!justPermItem) {
            sb.append(", c.fdimtype, c.forgid fdimid, c.fisincludesuborg fincludesub ");
        }
        sb.append(" from t_perm_rolepermdetial a ");
        sb.append(" inner join t_perm_bizrolecomrole b on b.froleid = a.froleid ");
        if (!justPermItem) {
            sb.append(" inner join t_perm_bizroleorg c on c.fid = b.fid ");
        }
        List busiRoleIdList = busiRoleIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String busiRoleIdStr = String.join((CharSequence)",", busiRoleIdList);
        sb.append(" where b.fid in (").append(busiRoleIdStr).append(')');
        List commRoleIdList = commRoleIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String commRoleIdStr = String.join((CharSequence)"','", commRoleIdList);
        sb.append(" and a.froleid in ('").append(commRoleIdStr).append("')");
        String appId = req.getAppId();
        if (StringUtils.isNotEmpty((String)appId)) {
            sb.append(" and a.fbizappid = ? ");
            paramList.add(appId);
        }
        return (PermLevelHash)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<PermLevelHash>(){

            public PermLevelHash handle(ResultSet rs) throws Exception {
                HashMap<String, Set> funcDimMap = new HashMap<String, Set>(8);
                boolean hasIncludeSub = false;
                String key = null;
                String value = null;
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entNum = rs.getString("fentitytypeid");
                    String permItemID = rs.getString("fpermitemid");
                    if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entNum) || StringUtils.isEmpty((String)permItemID)) continue;
                    key = appId + "@@" + entNum + "@@" + permItemID;
                    if (justPermItem && !funcDimMap.containsKey(key)) {
                        funcDimMap.put(key, new HashSet(1));
                        continue;
                    }
                    if (justPermItem) continue;
                    String fdimtype = rs.getString("fdimtype");
                    Long fdimid = rs.getLong("fdimid");
                    String fincludesub = rs.getString("fincludesub");
                    if (StringUtils.isEmpty((String)fdimtype) || null == fdimid || Objects.equals(0L, fdimid) || StringUtils.isEmpty((String)fincludesub)) continue;
                    if (Objects.equals("1", fincludesub)) {
                        hasIncludeSub = true;
                    }
                    value = fdimtype + "@@" + fdimid + "@@" + fincludesub;
                    funcDimMap.computeIfAbsent(key, k -> new HashSet(8)).add(value);
                }
                return new PermLevelHash(hasIncludeSub, funcDimMap);
            }
        });
    }

    public static PermLevelHash getBcPermLevelHash(GetPermLevelHashReq req) {
        Set busiRoleIdSet = req.getBusiRoleIdSet();
        if (null == busiRoleIdSet || busiRoleIdSet.isEmpty()) {
            return new PermLevelHash(false, new HashMap(1));
        }
        ArrayList<String> paramList = new ArrayList<String>(10);
        final boolean justPermItem = req.isJustPermItem();
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fbizappid, a.fentitytypeid, a.fpermitemid ");
        if (!justPermItem) {
            sb.append(", b.fdimtype, b.forgid fdimid, b.fisincludesuborg fincludesub ");
        }
        sb.append(" from t_perm_bizroleperm a ");
        if (!justPermItem) {
            sb.append(" inner join t_perm_bizroleorg b on a.fid = b.fid ");
        }
        List busiRoleIdList = busiRoleIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String busiRoleIdStr = String.join((CharSequence)",", busiRoleIdList);
        sb.append(" where a.fid in (").append(busiRoleIdStr).append(')');
        String appId = req.getAppId();
        if (StringUtils.isNotEmpty((String)appId)) {
            sb.append(" and a.fbizappid = ? ");
            paramList.add(appId);
        }
        return (PermLevelHash)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<PermLevelHash>(){

            public PermLevelHash handle(ResultSet rs) throws Exception {
                HashMap<String, Set> funcDimMap = new HashMap<String, Set>(8);
                boolean hasIncludeSub = false;
                String key = null;
                String value = null;
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entNum = rs.getString("fentitytypeid");
                    String permItemID = rs.getString("fpermitemid");
                    if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entNum) || StringUtils.isEmpty((String)permItemID)) continue;
                    key = appId + "@@" + entNum + "@@" + permItemID;
                    if (justPermItem && !funcDimMap.containsKey(key)) {
                        funcDimMap.put(key, new HashSet(1));
                        continue;
                    }
                    if (justPermItem) continue;
                    String fdimtype = rs.getString("fdimtype");
                    Long fdimid = rs.getLong("fdimid");
                    String fincludesub = rs.getString("fincludesub");
                    if (StringUtils.isEmpty((String)fdimtype) || null == fdimid || Objects.equals(0L, fdimid) || StringUtils.isEmpty((String)fincludesub)) continue;
                    if (Objects.equals("1", fincludesub)) {
                        hasIncludeSub = true;
                    }
                    value = fdimtype + "@@" + fdimid + "@@" + fincludesub;
                    funcDimMap.computeIfAbsent(key, k -> new HashSet(8)).add(value);
                }
                return new PermLevelHash(hasIncludeSub, funcDimMap);
            }
        });
    }

    public static PermLevelHash getDisPermLevelHash(GetPermLevelHashReq req) {
        Set busiRoleIdSet = req.getBusiRoleIdSet();
        if (null == busiRoleIdSet || busiRoleIdSet.isEmpty()) {
            return new PermLevelHash(false, new HashMap(1));
        }
        ArrayList<String> paramList = new ArrayList<String>(10);
        final boolean justPermItem = req.isJustPermItem();
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fbizappid, a.fentitytypeid, a.fpermitemid ");
        if (!justPermItem) {
            sb.append(", b.fdimtype, b.forgid fdimid, b.fisincludesuborg fincludesub ");
        }
        sb.append(" from t_perm_bizroledisperm a ");
        if (!justPermItem) {
            sb.append(" inner join t_perm_bizroleorg b on a.fid = b.fid ");
        }
        List busiRoleIdList = busiRoleIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String busiRoleIdStr = String.join((CharSequence)",", busiRoleIdList);
        sb.append(" where a.fid in (").append(busiRoleIdStr).append(')');
        String appId = req.getAppId();
        if (StringUtils.isNotEmpty((String)appId)) {
            sb.append(" and a.fbizappid = ? ");
            paramList.add(appId);
        }
        return (PermLevelHash)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<PermLevelHash>(){

            public PermLevelHash handle(ResultSet rs) throws Exception {
                HashMap<String, Set> funcDimMap = new HashMap<String, Set>(8);
                boolean hasIncludeSub = false;
                String key = null;
                String value = null;
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entNum = rs.getString("fentitytypeid");
                    String permItemID = rs.getString("fpermitemid");
                    if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entNum) || StringUtils.isEmpty((String)permItemID)) continue;
                    key = appId + "@@" + entNum + "@@" + permItemID;
                    if (justPermItem && !funcDimMap.containsKey(key)) {
                        funcDimMap.put(key, new HashSet(1));
                        continue;
                    }
                    if (justPermItem) continue;
                    String fdimtype = rs.getString("fdimtype");
                    Long fdimid = rs.getLong("fdimid");
                    String fincludesub = rs.getString("fincludesub");
                    if (StringUtils.isEmpty((String)fdimtype) || null == fdimid || Objects.equals(0L, fdimid) || StringUtils.isEmpty((String)fincludesub)) continue;
                    if (Objects.equals("1", fincludesub)) {
                        hasIncludeSub = true;
                    }
                    value = fdimtype + "@@" + fdimid + "@@" + fincludesub;
                    funcDimMap.computeIfAbsent(key, k -> new HashSet(8)).add(value);
                }
                return new PermLevelHash(hasIncludeSub, funcDimMap);
            }
        });
    }

    public static Map<String, Set<BusiRole>> getRoleIdOrNumOrNameBusiRoleMap(Set<String> idOrNumberOrNameSet, String keyType) {
        HashMap<String, Set<BusiRole>> map = new HashMap<String, Set<BusiRole>>(8);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("id", keyType)) {
            qFilterList.add(new QFilter("id", "in", idOrNumberOrNameSet.stream().map(Long::valueOf).collect(Collectors.toSet())));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("number", keyType)) {
            qFilterList.add(new QFilter("number", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("name", keyType)) {
            qFilterList.add(new QFilter("name", "in", idOrNumberOrNameSet));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"PermBusiRoleHelper.getRoleIdOrNumOrNameBusiRoleMap", (String)"perm_busirole", (String)"id, number, name", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");){
            BusiRole one = null;
            while (ds.hasNext()) {
                Row row = ds.next();
                one = new BusiRole();
                Long id = row.getLong("id");
                String number = row.getString("number");
                String name = row.getString("name");
                one.setId(id);
                one.setNumber(number);
                one.setName(name);
                if (Objects.equals("id", keyType)) {
                    map.computeIfAbsent(String.valueOf(id), k -> new HashSet()).add(one);
                }
                if (Objects.equals("name", keyType)) {
                    map.computeIfAbsent(name, k -> new HashSet()).add(one);
                    continue;
                }
                if (!Objects.equals("number", keyType)) continue;
                map.computeIfAbsent(number, k -> new HashSet()).add(one);
            }
        }
        return map;
    }

    public static Map<String, Set<BusiRoleComRole>> getComRoleSetMap(Set<String> idOrNumberSet, final String keyType) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid bizRoleId, a.fnumber bizRoleNum, b.froleid comRoleId, c.fnumber comRoleNum, cL.fname comRoleName, c.fenable comRoleEnable, b.fentryid ", new Object[0]);
        sqlBuilder.append(" from t_perm_bizrole a ", new Object[0]);
        sqlBuilder.append(" inner join t_perm_bizrolecomrole b on b.fid = a.fid ", new Object[0]);
        sqlBuilder.append(" left join t_perm_role c on c.fid  = b.froleid ", new Object[0]);
        sqlBuilder.append(" left join t_perm_role_l cL on cL.fid  = c.fid ", new Object[0]).append(" and cL.flocaleid = ? ", new Object[]{RequestContext.get().getLang().name()});
        sqlBuilder.append(" where 1=1 ", new Object[0]);
        if (null != idOrNumberSet && !idOrNumberSet.isEmpty() && Objects.equals("id", keyType)) {
            sqlBuilder.appendIn(" and a.fid", idOrNumberSet.stream().map(Long::valueOf).toArray());
        }
        if (null != idOrNumberSet && !idOrNumberSet.isEmpty() && Objects.equals("number", keyType)) {
            sqlBuilder.appendIn(" and a.fnumber", idOrNumberSet.toArray());
        }
        return (Map)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<String, Set<BusiRoleComRole>>>(){

            public Map<String, Set<BusiRoleComRole>> handle(ResultSet rs) throws SQLException {
                HashMap<String, Set<BusiRoleComRole>> map = new HashMap<String, Set<BusiRoleComRole>>(8);
                BusiRoleComRole one = null;
                while (rs.next()) {
                    String bizRoleId = rs.getString("bizRoleId");
                    String bizRoleNum = rs.getString("bizRoleNum");
                    String comRoleId = rs.getString("comRoleId");
                    String comRoleNum = rs.getString("comRoleNum");
                    String comRoleName = rs.getString("comRoleName");
                    String comRoleEnable = rs.getString("comRoleEnable");
                    one = new BusiRoleComRole();
                    one.setBusiRoleId(bizRoleId);
                    one.setBusiRoleNum(bizRoleNum);
                    one.setEntryId(rs.getString("fentryid"));
                    one.setComRoleId(comRoleId);
                    one.setComRoleNumber(comRoleNum);
                    one.setComRoleName(comRoleName);
                    one.setComRoleEnable(comRoleEnable);
                    if (Objects.equals("id", keyType)) {
                        map.computeIfAbsent(bizRoleId, k -> new HashSet()).add(one);
                        continue;
                    }
                    if (!Objects.equals("number", keyType)) continue;
                    map.computeIfAbsent(bizRoleNum, k -> new HashSet()).add(one);
                }
                return map;
            }
        });
    }

    public static Map<String, Set<BusiRoleDimObj>> getDimObjSetMap(Set<String> idOrNumberSet, final String keyType) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid, a.fnumber, b.fdimtype, b.forgid,  b.fisincludesuborg, b.fentryid ", new Object[0]);
        sqlBuilder.append(" from t_perm_bizrole a ", new Object[0]);
        sqlBuilder.append(" inner join t_perm_bizroleorg b on b.fid = a.fid ", new Object[0]);
        sqlBuilder.append(" where 1=1 ", new Object[0]);
        if (null != idOrNumberSet && !idOrNumberSet.isEmpty() && Objects.equals("id", keyType)) {
            sqlBuilder.appendIn(" and a.fid", idOrNumberSet.stream().map(Long::valueOf).toArray());
        }
        if (null != idOrNumberSet && !idOrNumberSet.isEmpty() && Objects.equals("number", keyType)) {
            sqlBuilder.appendIn(" and a.fnumber", idOrNumberSet.toArray());
        }
        final Map<String, String> permCtrlTypeBigMap = IsoDimHelper.permCtrlTypeBigMap();
        final HashMap<String, Set<BusiRoleDimObj>> map = new HashMap<String, Set<BusiRoleDimObj>>(8);
        final HashMap dimTypeSmallDimIdSetMap = new HashMap(8);
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<String, Set<BusiRoleDimObj>>>(){

            public Map<String, Set<BusiRoleDimObj>> handle(ResultSet rs) throws SQLException {
                BusiRoleDimObj one = null;
                while (rs.next()) {
                    String busiRoleNum = rs.getString("fnumber");
                    String fdimtype = rs.getString("fdimtype");
                    Long forgid = rs.getLong("forgid");
                    Boolean fisincludesuborg = rs.getBoolean("fisincludesuborg");
                    one = new BusiRoleDimObj();
                    one.setBusiRoleNum(busiRoleNum);
                    one.setEntryId(rs.getString("fentryid"));
                    one.setDimTypeSmall(fdimtype);
                    one.setDimTypeBig((String)permCtrlTypeBigMap.get(fdimtype));
                    one.setDimId(forgid);
                    one.setIncludeSub(fisincludesuborg);
                    if (Objects.equals("id", keyType)) {
                        map.computeIfAbsent(rs.getString("fid"), k -> new HashSet()).add(one);
                    } else if (Objects.equals("number", keyType)) {
                        map.computeIfAbsent(busiRoleNum, k -> new HashSet()).add(one);
                    }
                    dimTypeSmallDimIdSetMap.computeIfAbsent(fdimtype, k -> new HashSet(8)).add(forgid);
                }
                return map;
            }
        });
        if (null == map || map.isEmpty()) {
            return map;
        }
        HashMap<String, Map<String, Set<Dim>>> dimTypeDimIdDimMap = new HashMap<String, Map<String, Set<Dim>>>(8);
        if (null != dimTypeSmallDimIdSetMap && !dimTypeSmallDimIdSetMap.isEmpty()) {
            for (Map.Entry dimTypeSmallDimIdSet : dimTypeSmallDimIdSetMap.entrySet()) {
                String dimTypeSmall = (String)dimTypeSmallDimIdSet.getKey();
                Set dimIdSet = (Set)dimTypeSmallDimIdSet.getValue();
                if (StringUtils.isEmpty((String)dimTypeSmall) || kd.bos.util.CollectionUtils.isEmpty((Collection)dimIdSet)) continue;
                Map<String, Set<Dim>> dimIdDimSetMap = IsoDimHelper.getDimSetMap(dimIdSet.stream().map(String::valueOf).collect(Collectors.toSet()), "id", dimTypeSmall);
                dimTypeDimIdDimMap.put(dimTypeSmall, dimIdDimSetMap);
            }
        }
        for (Map.Entry one : map.entrySet()) {
            Set value = (Set)one.getValue();
            if (null == value || value.isEmpty()) continue;
            for (BusiRoleDimObj inner : value) {
                Dim dim;
                Set dims;
                String dimTypeSmall = inner.getDimTypeSmall();
                Long dimId = inner.getDimId();
                Map dimIdDimMap = (Map)dimTypeDimIdDimMap.get(dimTypeSmall);
                if (null == dimIdDimMap || dimIdDimMap.isEmpty() || null == (dims = (Set)dimIdDimMap.get(String.valueOf(dimId))) || dims.isEmpty() || null == (dim = (Dim)dims.stream().findFirst().orElseGet(null))) continue;
                inner.setDimNum(dim.getDimNumber());
            }
        }
        return map;
    }

    public static Map<String, Set<BusiRoleBcFuncPerm>> getBcFuncPermSetMap(Set<String> idOrNumberSet, final String keyType) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid, a.fnumber, b.fbizappid, b.fentitytypeid,  b.fpermitemid, b.fentryid ", new Object[0]);
        sqlBuilder.append(" from t_perm_bizrole a ", new Object[0]);
        sqlBuilder.append(" inner join t_perm_bizroleperm b on b.fid = a.fid ", new Object[0]);
        sqlBuilder.append(" where 1=1 ", new Object[0]);
        if (null != idOrNumberSet && !idOrNumberSet.isEmpty() && Objects.equals("id", keyType)) {
            sqlBuilder.appendIn(" and a.fid", idOrNumberSet.stream().map(Long::valueOf).toArray());
        }
        if (null != idOrNumberSet && !idOrNumberSet.isEmpty() && Objects.equals("number", keyType)) {
            sqlBuilder.appendIn(" and a.fnumber", idOrNumberSet.toArray());
        }
        final HashMap<String, Set<BusiRoleBcFuncPerm>> map = new HashMap<String, Set<BusiRoleBcFuncPerm>>(8);
        final HashSet<String> appIdSet = new HashSet<String>(8);
        final HashSet<String> permItemIdSet = new HashSet<String>(8);
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<String, Set<BusiRoleBcFuncPerm>>>(){

            public Map<String, Set<BusiRoleBcFuncPerm>> handle(ResultSet rs) throws SQLException {
                BusiRoleBcFuncPerm one = null;
                while (rs.next()) {
                    one = new BusiRoleBcFuncPerm();
                    Long busiRoleId = rs.getLong("fid");
                    String busiRoleNum = rs.getString("fnumber");
                    String fbizappid = rs.getString("fbizappid");
                    String fpermitemid = rs.getString("fpermitemid");
                    one.setBusiRoleId(busiRoleId);
                    one.setBusiRoleNum(busiRoleNum);
                    one.setEntryId(rs.getString("fentryid"));
                    one.setAppId(fbizappid);
                    one.setEntityNumber(rs.getString("fentitytypeid"));
                    one.setPermItemId(fpermitemid);
                    if (Objects.equals("id", keyType)) {
                        map.computeIfAbsent(String.valueOf(busiRoleId), k -> new HashSet()).add(one);
                    } else if (Objects.equals("number", keyType)) {
                        map.computeIfAbsent(busiRoleNum, k -> new HashSet()).add(one);
                    }
                    appIdSet.add(fbizappid);
                    permItemIdSet.add(fpermitemid);
                }
                return map;
            }
        });
        if (null == map || map.isEmpty()) {
            return map;
        }
        Map<String, App> appMap = AppHelper.getAppMap(appIdSet);
        Map<String, PermItem> permItemMap = PermItemHelper.getPermItemMap(permItemIdSet);
        for (Map.Entry one : map.entrySet()) {
            Set value = (Set)one.getValue();
            if (null == value || value.isEmpty()) continue;
            for (BusiRoleBcFuncPerm funcPerm : value) {
                String permItemId;
                PermItem permItem;
                String appId = funcPerm.getAppId();
                App app = appMap.get(appId);
                if (null != app) {
                    funcPerm.setAppNumber(app.getAppNumber());
                }
                if (null == (permItem = permItemMap.get(permItemId = funcPerm.getPermItemId()))) continue;
                funcPerm.setPermItemNumber(permItem.getPermItemNumber());
            }
        }
        return map;
    }

    public static Map<String, Set<BusiRoleDisFuncPerm>> getDisFuncPermSetMap(Set<String> idOrNumberSet, final String keyType) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid, a.fnumber, b.fbizappid, b.fentitytypeid,  b.fpermitemid, b.fentryid ", new Object[0]);
        sqlBuilder.append(" from t_perm_bizrole a ", new Object[0]);
        sqlBuilder.append(" inner join t_perm_bizroledisperm b on b.fid = a.fid ", new Object[0]);
        sqlBuilder.append(" where 1=1 ", new Object[0]);
        if (null != idOrNumberSet && !idOrNumberSet.isEmpty() && Objects.equals("id", keyType)) {
            sqlBuilder.appendIn(" and a.fid", idOrNumberSet.stream().map(Long::valueOf).toArray());
        }
        if (null != idOrNumberSet && !idOrNumberSet.isEmpty() && Objects.equals("number", keyType)) {
            sqlBuilder.appendIn(" and a.fnumber", idOrNumberSet.toArray());
        }
        final HashMap<String, Set<BusiRoleDisFuncPerm>> map = new HashMap<String, Set<BusiRoleDisFuncPerm>>(8);
        final HashSet<String> appIdSet = new HashSet<String>(8);
        final HashSet<String> permItemIdSet = new HashSet<String>(8);
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<String, Set<BusiRoleDisFuncPerm>>>(){

            public Map<String, Set<BusiRoleDisFuncPerm>> handle(ResultSet rs) throws SQLException {
                BusiRoleDisFuncPerm one = null;
                while (rs.next()) {
                    one = new BusiRoleDisFuncPerm();
                    Long busiRoleId = rs.getLong("fid");
                    String busiRoleNum = rs.getString("fnumber");
                    String fbizappid = rs.getString("fbizappid");
                    String fpermitemid = rs.getString("fpermitemid");
                    one.setBusiRoleId(busiRoleId);
                    one.setBusiRoleNum(busiRoleNum);
                    one.setEntryId(rs.getString("fentryid"));
                    one.setAppId(fbizappid);
                    one.setEntityNumber(rs.getString("fentitytypeid"));
                    one.setPermItemId(fpermitemid);
                    if (Objects.equals("id", keyType)) {
                        map.computeIfAbsent(String.valueOf(busiRoleId), k -> new HashSet()).add(one);
                    } else if (Objects.equals("number", keyType)) {
                        map.computeIfAbsent(busiRoleNum, k -> new HashSet()).add(one);
                    }
                    appIdSet.add(fbizappid);
                    permItemIdSet.add(fpermitemid);
                }
                return map;
            }
        });
        if (null == map || map.isEmpty()) {
            return map;
        }
        Map<String, App> appMap = AppHelper.getAppMap(appIdSet);
        Map<String, PermItem> permItemMap = PermItemHelper.getPermItemMap(permItemIdSet);
        for (Map.Entry one : map.entrySet()) {
            Set value = (Set)one.getValue();
            if (null == value || value.isEmpty()) continue;
            for (BusiRoleDisFuncPerm funcPerm : value) {
                String permItemId;
                PermItem permItem;
                String appId = funcPerm.getAppId();
                App app = appMap.get(appId);
                if (null != app) {
                    funcPerm.setAppNumber(app.getAppNumber());
                }
                if (null == (permItem = permItemMap.get(permItemId = funcPerm.getPermItemId()))) continue;
                funcPerm.setPermItemNumber(permItem.getPermItemNumber());
            }
        }
        return map;
    }

    public static Map<Long, BusiRole> getBusiRoleBaseMap(Set<Long> busiRoleIdSet, BusiRoleSearchReq req) {
        ArrayList<String> paramList = new ArrayList<String>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid, a.fnumber,  a.fusertype, a.fstatus, a.fenable, ");
        sb.append(" a.fcreatetime, a.fcreatorid, a.fmodifytime, a.fmodifierid, a.fdisablerid, a.fdisabledate, a.fname, a.fdescription, a.fgroupid, ");
        sb.append(" b.fname");
        sb.append(" from t_perm_bizrole a ");
        sb.append(" inner join t_perm_bizrole_l b on a.fid = b.fid ");
        sb.append(" where b.flocaleid = ? ");
        paramList.add(RequestContext.get().getLang().name());
        if (null != busiRoleIdSet && !busiRoleIdSet.isEmpty()) {
            String roleIdStr = busiRoleIdSet.stream().map(String::valueOf).collect(Collectors.joining(","));
            sb.append(" and a.fid in (").append(roleIdStr).append(") ");
        }
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Map<Long, BusiRole>>(){

            public Map<Long, BusiRole> handle(ResultSet rs) throws Exception {
                LinkedHashMap<Long, BusiRole> map = new LinkedHashMap<Long, BusiRole>(8);
                BusiRole one = null;
                while (rs.next()) {
                    one = new BusiRole();
                    long fid = rs.getLong("fid");
                    one.setId(Long.valueOf(fid));
                    String fusertype = rs.getString("fusertype");
                    one.setType(fusertype);
                    String fnumber = rs.getString("fnumber");
                    one.setNumber(fnumber);
                    String fname = rs.getString("fname");
                    one.setName(fname);
                    String fdescription = rs.getString("fdescription");
                    one.setRemark(fdescription);
                    String fcreatetime = rs.getString("fcreatetime");
                    one.setCreateTime(StringUtils.isEmpty((String)fcreatetime) ? null : DateUtil.toDate(fcreatetime.substring(0, 19), "yyyy-MM-dd HH:mm:ss"));
                    one.setCreatorId(rs.getString("fcreatorid"));
                    String fmodifytime = rs.getString("fmodifytime");
                    one.setModifyTime(StringUtils.isEmpty((String)fmodifytime) ? null : DateUtil.toDate(fmodifytime.substring(0, 19), "yyyy-MM-dd HH:mm:ss"));
                    one.setModifierId(rs.getString("fmodifierid"));
                    one.setStatus(rs.getString("fstatus"));
                    String fenable = rs.getString("fenable");
                    one.setEnable(Boolean.valueOf(!StringUtils.isEmpty((String)fenable) && !" ".equals(fenable) && !"0".equals(fenable)));
                    one.setGroupId(rs.getString("fgroupid"));
                    map.put(fid, one);
                }
                return map;
            }
        });
    }

    public static Map<String, Map<String, List<String>>> getAppEntityByBizRole(Set<String> roleIdOrNumberSet, String keyType) {
        HashMap<String, Map<String, List<String>>> resultMap = new HashMap<String, Map<String, List<String>>>(8);
        if (null == roleIdOrNumberSet || roleIdOrNumberSet.isEmpty() || StringUtils.isEmpty((String)keyType)) {
            return resultMap;
        }
        Map<String, Set<PermItem>> permItemSetMap = PermBusiRoleHelper.getPermItemSetMap(roleIdOrNumberSet, keyType);
        for (String roleIdOrNumber : roleIdOrNumberSet) {
            Set<PermItem> permItems = permItemSetMap.get(roleIdOrNumber);
            if (null == permItems || permItems.isEmpty()) {
                resultMap.put(roleIdOrNumber, new HashMap(0));
                continue;
            }
            HashMap innerMap = new HashMap(8);
            permItems.stream().forEach(x -> innerMap.computeIfAbsent(x.getAppId(), k -> new ArrayList(10)).add(x.getEntityNumber()));
            resultMap.put(roleIdOrNumber, innerMap);
        }
        return resultMap;
    }

    private static Map<String, Set<PermItem>> getPermItemSetMap(Set<String> roleIdOrNumberSet, String keyType) {
        HashMap<String, Set<PermItem>> map = new HashMap<String, Set<PermItem>>(8);
        Map<String, Set<PermItem>> comRolePermItemSetMap = PermBusiRoleHelper.getComRolePermItemSetMap(roleIdOrNumberSet, keyType);
        Map<String, Set<PermItem>> bcPermItemSetMap = PermBusiRoleHelper.getBcPermItemSetMap(roleIdOrNumberSet, keyType);
        for (Map.Entry<String, Set<PermItem>> one : comRolePermItemSetMap.entrySet()) {
            map.computeIfAbsent(one.getKey(), k -> new HashSet()).addAll((Collection)one.getValue());
        }
        for (Map.Entry<String, Set<PermItem>> one : bcPermItemSetMap.entrySet()) {
            map.computeIfAbsent(one.getKey(), k -> new HashSet()).addAll((Collection)one.getValue());
        }
        return map;
    }

    private static Map<String, Set<PermItem>> getComRolePermItemSetMap(Set<String> roleIdOrNumberSet, final String keyType) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid, a.fnumber, c.fbizappid, c.fentitytypeid ", new Object[0]);
        sqlBuilder.append(" from t_perm_bizrole a ", new Object[0]);
        sqlBuilder.append(" inner join t_perm_bizrolecomrole b on b.fid = a.fid ", new Object[0]);
        sqlBuilder.append(" inner join t_perm_rolepermdetial c on c.froleid = b.froleid  ", new Object[0]);
        sqlBuilder.append(" where 1=1 ", new Object[0]);
        if (null != roleIdOrNumberSet && !roleIdOrNumberSet.isEmpty() && Objects.equals("id", keyType)) {
            sqlBuilder.appendIn(" and a.fid", roleIdOrNumberSet.stream().map(Long::valueOf).toArray());
        }
        if (null != roleIdOrNumberSet && !roleIdOrNumberSet.isEmpty() && Objects.equals("number", keyType)) {
            sqlBuilder.appendIn(" and a.fnumber", roleIdOrNumberSet.toArray());
        }
        return (Map)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<String, Set<PermItem>>>(){

            public Map<String, Set<PermItem>> handle(ResultSet rs) throws SQLException {
                HashMap<String, Set<PermItem>> map = new HashMap<String, Set<PermItem>>(8);
                PermItem one = null;
                while (rs.next()) {
                    String bizRoleId = rs.getString("fid");
                    String bizRoleNum = rs.getString("fnumber");
                    one = new PermItem();
                    one.setAppId(rs.getString("fbizappid"));
                    one.setEntityNumber(rs.getString("fentitytypeid"));
                    if (Objects.equals("id", keyType)) {
                        map.computeIfAbsent(bizRoleId, k -> new HashSet()).add(one);
                        continue;
                    }
                    if (!Objects.equals("number", keyType)) continue;
                    map.computeIfAbsent(bizRoleNum, k -> new HashSet()).add(one);
                }
                return map;
            }
        });
    }

    private static Map<String, Set<PermItem>> getBcPermItemSetMap(Set<String> roleIdOrNumberSet, final String keyType) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid, a.fnumber, b.fbizappid, b.fentitytypeid", new Object[0]);
        sqlBuilder.append(" from t_perm_bizrole a ", new Object[0]);
        sqlBuilder.append(" inner join t_perm_bizroleperm b on b.fid = a.fid ", new Object[0]);
        sqlBuilder.append(" where 1=1 ", new Object[0]);
        if (null != roleIdOrNumberSet && !roleIdOrNumberSet.isEmpty() && Objects.equals("id", keyType)) {
            sqlBuilder.appendIn(" and a.fid", roleIdOrNumberSet.stream().map(Long::valueOf).toArray());
        }
        if (null != roleIdOrNumberSet && !roleIdOrNumberSet.isEmpty() && Objects.equals("number", keyType)) {
            sqlBuilder.appendIn(" and a.fnumber", roleIdOrNumberSet.toArray());
        }
        return (Map)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<String, Set<PermItem>>>(){

            public Map<String, Set<PermItem>> handle(ResultSet rs) throws SQLException {
                HashMap<String, Set<PermItem>> map = new HashMap<String, Set<PermItem>>(8);
                PermItem one = null;
                while (rs.next()) {
                    String bizRoleId = rs.getString("fid");
                    String bizRoleNum = rs.getString("fnumber");
                    one = new PermItem();
                    one.setAppId(rs.getString("fbizappid"));
                    one.setEntityNumber(rs.getString("fentitytypeid"));
                    if (Objects.equals("id", keyType)) {
                        map.computeIfAbsent(bizRoleId, k -> new HashSet()).add(one);
                        continue;
                    }
                    if (!Objects.equals("number", keyType)) continue;
                    map.computeIfAbsent(bizRoleNum, k -> new HashSet()).add(one);
                }
                return map;
            }
        });
    }

    public static Map<Long, Set<String>> getBusiRoleComRoleIdSetMap(Set<Long> busiRoleIdSet) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (null != busiRoleIdSet && !busiRoleIdSet.isEmpty()) {
            filterList.add(new QFilter("id", "in", busiRoleIdSet));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PermBusiRoleHelper.getRoleAppEntIdSetMap", (String)"perm_busirole", (String)"id, role_entry.role_visible_id", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            HashMap<Long, Set<String>> map = new HashMap<Long, Set<String>>(8);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long busiRoleId = row.getLong("id");
                String comRoleId = row.getString("role_entry.role_visible_id");
                if (null == busiRoleId || Objects.equals(0L, busiRoleId) || StringUtils.isEmpty((String)comRoleId)) continue;
                map.computeIfAbsent(busiRoleId, k -> new HashSet(8)).add(comRoleId);
            }
            HashMap<Long, Set<String>> hashMap = map;
            return hashMap;
        }
    }
}

