/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormConfig;
import kd.bos.instance.AppGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class PermGrayHelper {
    private static final Log logger = LogFactory.getLog(PermGrayHelper.class);

    @SdkInternal
    public static boolean isGrayUpgrade() {
        boolean isGrayUpgrade = AppGroup.isGrayUpgrade();
        logger.debug("PermGrayHelper.isGrayUpgrade():" + isGrayUpgrade);
        return isGrayUpgrade;
    }

    @SdkInternal
    public static List<AppInfo> loadGrayAppInfoList() {
        boolean grayUpgrade = PermGrayHelper.isGrayUpgrade();
        if (!grayUpgrade) {
            return new ArrayList<AppInfo>(8);
        }
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        List appInfoStrList = metadataService.loadGrayAppInfoList();
        ArrayList<AppInfo> appInfoList = new ArrayList<AppInfo>(8);
        for (String infoStr : appInfoStrList) {
            AppInfo appInfo = (AppInfo)SerializationUtils.fromJsonString((String)infoStr, AppInfo.class);
            appInfoList.add(appInfo);
        }
        logger.debug("PermGrayHelper.loadGrayAppInfoList():" + appInfoStrList);
        return appInfoList;
    }

    @SdkInternal
    public static AppInfo findGrayAppInfoByNum(String appNum) {
        if (StringUtils.isEmpty((String)appNum)) {
            return null;
        }
        List<AppInfo> loadGrayAppInfoList = PermGrayHelper.loadGrayAppInfoList();
        return PermGrayHelper.findGrayAppInfoByNum(appNum, loadGrayAppInfoList);
    }

    @SdkInternal
    public static AppInfo findGrayAppInfoByNum(String appKey, List<AppInfo> loadGrayAppInfoList) {
        if (StringUtils.isEmpty((String)appKey) || CollectionUtils.isEmpty(loadGrayAppInfoList)) {
            return null;
        }
        return PermGrayHelper.findGrayAppInfo(appKey, loadGrayAppInfoList, true);
    }

    public static AppInfo findGrayAppInfoById(String appId) {
        if (StringUtils.isEmpty((String)appId)) {
            return null;
        }
        List<AppInfo> loadGrayAppInfoList = PermGrayHelper.loadGrayAppInfoList();
        return PermGrayHelper.findGrayAppInfoById(appId, loadGrayAppInfoList);
    }

    public static AppInfo findGrayAppInfoById(String appKey, List<AppInfo> loadGrayAppInfoList) {
        if (StringUtils.isEmpty((String)appKey) || CollectionUtils.isEmpty(loadGrayAppInfoList)) {
            return null;
        }
        return PermGrayHelper.findGrayAppInfo(appKey, loadGrayAppInfoList, false);
    }

    @SdkInternal
    public static AppInfo findGrayAppInfo(String appKey, List<AppInfo> loadGrayAppInfoList, boolean isQueryNum) {
        if (StringUtils.isEmpty((String)appKey) || CollectionUtils.isEmpty(loadGrayAppInfoList)) {
            return null;
        }
        AppInfo appInfo = null;
        try {
            appInfo = AppMetadataCache.getAppInfo((String)appKey);
        }
        catch (Exception e) {
            logger.warn("AppMetadataCache Can't find appKey(" + appKey + "), then try find In PermGrayHelper.loadGrayAppInfoList", (Throwable)e);
        }
        if (appInfo == null) {
            for (AppInfo grayAppInfo : loadGrayAppInfoList) {
                if (grayAppInfo == null) continue;
                if (isQueryNum) {
                    if (!appKey.equals(grayAppInfo.getAppId())) continue;
                    appInfo = grayAppInfo;
                    logger.debug("Find In PermGrayHelper.findGrayAppInfo:appKey(" + appKey + ")");
                    break;
                }
                if (!appKey.equals(grayAppInfo.getId())) continue;
                appInfo = grayAppInfo;
                logger.debug("Find In PermGrayHelper.findGrayAppInfo:appKey(" + appKey + ")");
                break;
            }
        }
        return appInfo;
    }

    public static List<FormConfig> loadGrayFormConfigList(String appGroup) {
        if (StringUtils.isEmpty((String)appGroup)) {
            return new ArrayList<FormConfig>(8);
        }
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        List formConfigStrList = metadataService.loadGrayFormConfigList(appGroup);
        ArrayList<FormConfig> formConfigList = new ArrayList<FormConfig>(formConfigStrList.size());
        for (String strConfig : formConfigStrList) {
            FormConfig formConfig;
            if (StringUtils.isEmpty((String)strConfig)) continue;
            try {
                formConfig = (FormConfig)ControlTypes.fromJsonStringToObj((String)strConfig);
            }
            catch (Exception e) {
                formConfig = (FormConfig)SerializationUtils.fromJsonString((String)strConfig, FormConfig.class);
            }
            formConfigList.add(formConfig);
        }
        logger.debug("PermGrayHelper.loadGrayFormConfigList(" + appGroup + "):" + formConfigStrList.toString());
        return formConfigList;
    }
}

