/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.helper.AdminSchemeHelper;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.CloudHelper;
import kd.bos.permission.cache.helper.ConstantsHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.model.permbase.PermItem;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.perm.req.permitem.GetPlainPermItemListReq;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class PermItemHelper {
    private static final Log logger = LogFactory.getLog(PermItemHelper.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"PermItemHelper", (int)2);

    @SdkInternal
    public static Map<String, Map<String, String>> getAllPermItemInfoMap() {
        Map dynMap = BusinessDataServiceHelper.loadFromCache((String)"perm_permitem", (String)"id, number, name", null);
        if (CollectionUtils.isEmpty((Map)dynMap)) {
            return new HashMap<String, Map<String, String>>(1);
        }
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(dynMap.size());
        HashMap<String, String> valueMap = null;
        for (Map.Entry dyn : dynMap.entrySet()) {
            String id = (String)dyn.getKey();
            DynamicObject value = (DynamicObject)dyn.getValue();
            valueMap = new HashMap<String, String>(2);
            if (null == value) {
                valueMap.put("number", "");
                valueMap.put("name", "");
                resultMap.put(id, valueMap);
                continue;
            }
            String number = value.getString("number");
            valueMap.put("number", StringUtils.isEmpty((String)number) ? "" : number);
            String name = value.getString("name");
            valueMap.put("name", StringUtils.isEmpty((String)name) ? "" : name);
            resultMap.put(id, valueMap);
        }
        return resultMap;
    }

    @SdkInternal
    public static Map<String, kd.bos.permission.model.perm.PermItem> getPermItemMap(Set<String> permItemIdSet) {
        DynamicObjectCollection doc;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != permItemIdSet && !permItemIdSet.isEmpty()) {
            qFilterList.add(new QFilter("id", "in", permItemIdSet));
        }
        if (CollectionUtils.isEmpty((Collection)(doc = QueryServiceHelper.query((String)"perm_permitem", (String)"id, name, number", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]))))) {
            return new HashMap<String, kd.bos.permission.model.perm.PermItem>(1);
        }
        kd.bos.permission.model.perm.PermItem one = null;
        HashMap<String, kd.bos.permission.model.perm.PermItem> map = new HashMap<String, kd.bos.permission.model.perm.PermItem>(doc.size());
        for (DynamicObject dyn : doc) {
            one = new kd.bos.permission.model.perm.PermItem();
            String id = dyn.getString("id");
            String name = dyn.getString("name");
            String number = dyn.getString("number");
            one.setPermItemId(id);
            one.setPermItemName(name);
            one.setPermItemNumber(number);
            map.put(id, one);
        }
        return map;
    }

    public static Map<String, String> getAllPermItemIdNameMap() {
        Map dynMap = BusinessDataServiceHelper.loadFromCache((String)"perm_permitem", (String)"id, number, name", null);
        if (CollectionUtils.isEmpty((Map)dynMap)) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> map = new HashMap<String, String>(dynMap.size());
        for (Map.Entry dyn : dynMap.entrySet()) {
            String id = (String)dyn.getKey();
            DynamicObject value = (DynamicObject)dyn.getValue();
            if (null == value) {
                map.put(id, "");
                continue;
            }
            String name = value.getString("name");
            String number = value.getString("number");
            map.put(id, StringUtils.isEmpty((String)name) ? number : name);
        }
        return map;
    }

    @SdkInternal
    public static Map<String, String> getAllPermItemIdNumberMap() {
        Map dynMap = BusinessDataServiceHelper.loadFromCache((String)"perm_permitem", (String)"id, number", null);
        if (CollectionUtils.isEmpty((Map)dynMap)) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> map = new HashMap<String, String>(dynMap.size());
        for (Map.Entry dyn : dynMap.entrySet()) {
            String id = (String)dyn.getKey();
            DynamicObject value = (DynamicObject)dyn.getValue();
            if (null == value) {
                map.put(id, "");
                continue;
            }
            String number = value.getString("number");
            map.put(id, StringUtils.isEmpty((String)number) ? "" : number);
        }
        return map;
    }

    @SdkInternal
    public static Map<String, String> getAllPermItemNumberIdMap() {
        Map dynMap = BusinessDataServiceHelper.loadFromCache((String)"perm_permitem", (String)"id, number", null);
        if (CollectionUtils.isEmpty((Map)dynMap)) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> map = new HashMap<String, String>(dynMap.size());
        for (Map.Entry dyn : dynMap.entrySet()) {
            String number;
            Object idObj = dyn.getKey();
            DynamicObject value = (DynamicObject)dyn.getValue();
            if (null == idObj || null == value || StringUtils.isEmpty((String)(number = value.getString("number")))) continue;
            map.put(number, String.valueOf(idObj));
        }
        return map;
    }

    @SdkInternal
    public static List<PermItem> getPlainPermItemList(Map<String, Object> paraMap) {
        List<kd.bos.permission.model.perm.PermItem> plainPermItemList;
        GetPlainPermItemListReq req = new GetPlainPermItemListReq();
        if (null != paraMap) {
            req.setDimType(null == paraMap.get("dimension") ? "" : (String)paraMap.get("dimension"));
            req.setDimDiffHide(null == paraMap.get("dimDiffHide") ? null : (String)paraMap.get("dimDiffHide"));
            req.setCurDimNullShow(null == paraMap.get("curDimNullShow") ? null : (String)paraMap.get("curDimNullShow"));
            req.setFspShowForSpecialUser(null == paraMap.get("FormShowParam_ShowForSpecialUser") ? "" : (String)paraMap.get("FormShowParam_ShowForSpecialUser"));
        }
        if (null == (plainPermItemList = PermItemHelper.getPlainPermItemList(req)) || plainPermItemList.isEmpty()) {
            return new ArrayList<PermItem>(1);
        }
        return plainPermItemList.stream().map(x -> PermItemHelper.map2PermItem(x)).collect(Collectors.toList());
    }

    @SdkInternal
    private static PermItem map2PermItem(kd.bos.permission.model.perm.PermItem p) {
        PermItem item = new PermItem();
        item.setCloudId(p.getCloudId());
        item.setCloudNumber(p.getCloudNumber());
        item.setCloudName(p.getCloudName());
        item.setCloudSeq(p.getCloudSeq());
        item.setAppId(p.getAppId());
        item.setAppNumber(p.getAppNumber());
        item.setAppName(p.getAppName());
        item.setAppSeq(p.getAppSeq());
        item.setEntityId(p.getEntityId());
        item.setEntityNumber(p.getEntityNumber());
        item.setEntityName(p.getEntityName());
        item.setPermItemId(p.getPermItemId());
        item.setPermItemNumber(p.getPermItemNumber());
        item.setPermItemName(p.getPermItemName());
        return item;
    }

    @SdkInternal
    public static List<kd.bos.permission.model.perm.PermItem> getPlainPermItemList(GetPlainPermItemListReq req) {
        String dimType = req.getDimType();
        boolean showForSpecial = false;
        String showForSpecialUser = req.getFspShowForSpecialUser();
        if ("true".equals(showForSpecialUser)) {
            showForSpecial = true;
        }
        HashMap<String, String> formShowOnTreeStatusMap = new HashMap<String, String>(8);
        HashMap<String, Object> formShowOnTreeStatusParaMap = new HashMap<String, Object>(8);
        String[] suitableDimType = PermCommonUtil.getSuitableDimType(dimType);
        formShowOnTreeStatusParaMap.put("dimension", suitableDimType[0]);
        formShowOnTreeStatusParaMap.put("dimDiffHide", req.getDimDiffHide());
        formShowOnTreeStatusParaMap.put("curDimNullShow", req.getCurDimNullShow());
        PermCommonUtil.getFormShowOnTreeStatusMap(formShowOnTreeStatusParaMap, formShowOnTreeStatusMap);
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List formNumsFromStdBlackList = service.getFormBlackList();
        boolean formNumsFromStdBlackListIsEmpty = true;
        if (formNumsFromStdBlackList != null && !formNumsFromStdBlackList.isEmpty()) {
            formNumsFromStdBlackListIsEmpty = false;
        }
        List appIdsInBlackList = null == service.getAppIdBlackList() || service.getAppIdBlackList().isEmpty() ? new ArrayList(1) : service.getAppIdBlackList();
        Long curUserId = RequestContext.get().getCurrUserId();
        List adminChargeApps = PermissionServiceHelper.getAdminChargeApps((Long)curUserId);
        boolean enableSysAuthority = PermCommonUtil.isEnableSysAuthority();
        List<String> sysCloudApp = AdminSchemeHelper.queryAllSysApp(false, false);
        String appIdBlackList = StringUtils.isEmpty((String)RunModeServiceHelper.getAppIdFromBlacklist()) ? "" : RunModeServiceHelper.getAppIdFromBlacklist();
        Map<String, Object> paraMap = PermItemHelper.wrapParamMap();
        ArrayList<kd.bos.permission.model.perm.PermItem> itemList = new ArrayList<kd.bos.permission.model.perm.PermItem>(1280);
        HashMap detailMap = new HashMap(1280);
        try (DataSet cloudDataSet = CloudHelper.getCloudDataSet(enableSysAuthority);
             DataSet appDataSet = AppHelper.getAppDataSet(paraMap);
             DataSet entDataSet = FormHelper.getEntDataSet(paraMap);
             DataSet permItemDataSet = PermItemHelper.getPermItemDataSet();
             DataSet cloudAppDs = cloudDataSet.join(appDataSet).on("cloudId", "fbizcloudid").select(new String[]{"cloudId", "cloudNum", "cloudName", "cseq"}, new String[]{"oriAppId", "oriAppNum", "appName", "falluserapp", "fdeploystatus", "aseq"}).finish().distinct();
             DataSet cloudAppEntDs = cloudAppDs.join(entDataSet).on("oriAppId", "oriAppId").select(new String[]{"cloudId", "cloudNum", "cloudName", "cseq", "oriAppId", "oriAppNum", "appName", "falluserapp", "fdeploystatus", "aseq"}, new String[]{"oriEntId", "oriEntNum", "entName"}).finish().distinct();
             DataSet finalDs = cloudAppEntDs.join(permItemDataSet).on("oriEntNum", "funcpermEntnum").select(new String[]{"cloudId", "cloudNum", "cloudName", "cseq", "oriAppId", "oriAppNum", "appName", "falluserapp", "fdeploystatus", "aseq", "oriEntId", "oriEntNum", "entName"}, new String[]{"permItemId", "permItemNum", "permItemName"}).finish().distinct();){
            Map<String, Set<String>> allUserAppEntMap = AppHelper.getAllUserAppEntMap();
            Set disabledCloudIds = ManageServiceHelper.getDisabledCloudIds();
            boolean cloudSetNotEmpty = null != disabledCloudIds && !disabledCloudIds.isEmpty();
            Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
            boolean appSetNotEmpty = null != disabledAppIds && !disabledAppIds.isEmpty();
            String name_is_empty = ConstantsHelper.getNameIsEmpty();
            Set filterAppNumSet = req.getFilterAppNumSet();
            boolean filterAppNumSetNotEmpty = null != filterAppNumSet && !filterAppNumSet.isEmpty();
            Set filterEntNumSet = req.getFilterEntNumSet();
            boolean filterEntNumSetNotEmpty = null != filterEntNumSet && !filterEntNumSet.isEmpty();
            boolean returnByField = req.isReturnByField();
            Set returnFieldSet = req.getReturnFieldSet();
            try {
                DataSet[] dataSets = finalDs.splitByGroup(new String[]{"cloudId"});
                int length = dataSets.length;
                int m = SqlUtil.getBatchCount(10, length);
                List<List<DataSet>> listAvg = ListUtil.averageAssign(Arrays.asList(dataSets), m);
                ArrayList<Future> futureList = new ArrayList<Future>(m);
                for (List<DataSet> dataSetList : listAvg) {
                    HashMap<String, Object> callacleParamMap = new HashMap<String, Object>(16);
                    callacleParamMap.put("data", dataSetList);
                    callacleParamMap.put("appIdBlackList", appIdBlackList);
                    callacleParamMap.put("appIdsInBlackList", appIdsInBlackList);
                    callacleParamMap.put("adminChargeApps", adminChargeApps);
                    callacleParamMap.put("formShowOnTreeStatusMap", formShowOnTreeStatusMap);
                    callacleParamMap.put("formNumsFromStdBlackListIsEmpty", formNumsFromStdBlackListIsEmpty);
                    callacleParamMap.put("formNumsFromStdBlackList", formNumsFromStdBlackList);
                    callacleParamMap.put("allUserAppEntMap", allUserAppEntMap);
                    callacleParamMap.put("enableSysAuthority", enableSysAuthority);
                    callacleParamMap.put("sysCloudApp", sysCloudApp);
                    callacleParamMap.put("showForSpecial", showForSpecial);
                    callacleParamMap.put("disabledCloudIds", disabledCloudIds);
                    callacleParamMap.put("cloudSetNotEmpty", cloudSetNotEmpty);
                    callacleParamMap.put("disabledAppIds", disabledAppIds);
                    callacleParamMap.put("appSetNotEmpty", appSetNotEmpty);
                    callacleParamMap.put("name_is_empty", name_is_empty);
                    callacleParamMap.put("filterAppNumSet", filterAppNumSet);
                    callacleParamMap.put("filterAppNumSetNotEmpty", filterAppNumSetNotEmpty);
                    callacleParamMap.put("filterEntNumSet", filterEntNumSet);
                    callacleParamMap.put("filterEntNumSetNotEmpty", filterEntNumSetNotEmpty);
                    callacleParamMap.put("returnByField", returnByField);
                    callacleParamMap.put("returnFieldSet", returnFieldSet);
                    futureList.add(pool.submit(PermItemHelper.wrapDetailParamCallable(callacleParamMap)));
                }
                for (Future future : futureList) {
                    Map futureMap = (Map)future.get();
                    Map itemEntNameMap = (Map)futureMap.get("itemEntNameMap");
                    detailMap.putAll(itemEntNameMap);
                }
            }
            catch (Exception e) {
                logger.warn("PermItemHelper.getPlainPermItemList future error", (Throwable)e);
                ArrayList<kd.bos.permission.model.perm.PermItem> arrayList = new ArrayList<kd.bos.permission.model.perm.PermItem>(0);
                if (finalDs != null) {
                    if (var32_44 != null) {
                        try {
                            finalDs.close();
                        }
                        catch (Throwable throwable) {
                            var32_44.addSuppressed(throwable);
                        }
                    } else {
                        finalDs.close();
                    }
                }
                if (cloudAppEntDs != null) {
                    if (var30_40 != null) {
                        try {
                            cloudAppEntDs.close();
                        }
                        catch (Throwable throwable) {
                            var30_40.addSuppressed(throwable);
                        }
                    } else {
                        cloudAppEntDs.close();
                    }
                }
                if (cloudAppDs != null) {
                    if (var28_36 != null) {
                        try {
                            cloudAppDs.close();
                        }
                        catch (Throwable throwable) {
                            var28_36.addSuppressed(throwable);
                        }
                    } else {
                        cloudAppDs.close();
                    }
                }
                if (permItemDataSet != null) {
                    if (var26_32 != null) {
                        try {
                            permItemDataSet.close();
                        }
                        catch (Throwable throwable) {
                            var26_32.addSuppressed(throwable);
                        }
                    } else {
                        permItemDataSet.close();
                    }
                }
                if (entDataSet != null) {
                    if (var24_28 != null) {
                        try {
                            entDataSet.close();
                        }
                        catch (Throwable throwable) {
                            var24_28.addSuppressed(throwable);
                        }
                    } else {
                        entDataSet.close();
                    }
                }
                if (appDataSet != null) {
                    if (var22_24 != null) {
                        try {
                            appDataSet.close();
                        }
                        catch (Throwable throwable) {
                            var22_24.addSuppressed(throwable);
                        }
                    } else {
                        appDataSet.close();
                    }
                }
                if (cloudDataSet != null) {
                    if (var20_20 != null) {
                        try {
                            cloudDataSet.close();
                        }
                        catch (Throwable throwable) {
                            var20_20.addSuppressed(throwable);
                        }
                    } else {
                        cloudDataSet.close();
                    }
                }
                return arrayList;
            }
            if (detailMap.isEmpty()) {
                ArrayList<kd.bos.permission.model.perm.PermItem> arrayList = itemList;
                return arrayList;
            }
            itemList.addAll(detailMap.values());
        }
        return itemList;
    }

    @SdkInternal
    private static Map<String, Object> wrapParamMap() {
        Map formBlackMap;
        HashMap<String, Object> paraMap = new HashMap<String, Object>(8);
        HashSet<String> entNumNotInSet = new HashSet<String>(8);
        Long curUserId = RequestContext.get().getCurrUserId();
        List<String> formnums = null;
        if (PermCommonUtil.isCosmicUser(curUserId)) {
            formnums = PermCommonUtil.getAdminPermExcludedEntities();
        }
        if (null != formnums && !formnums.isEmpty()) {
            entNumNotInSet.addAll(formnums);
        }
        if (null != (formBlackMap = RunModeServiceHelper.getAllEntityBlacklist()) && !formBlackMap.isEmpty()) {
            entNumNotInSet.addAll(formBlackMap.values());
        }
        paraMap.put("entNumNotInSet", entNumNotInSet);
        paraMap.put("fdeploystatus", "2");
        return paraMap;
    }

    @SdkInternal
    private static Callable<Map<String, Object>> wrapDetailParamCallable(final Map<String, Object> paramMap) {
        return new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                HashMap<String, Object> map = new HashMap<String, Object>(3);
                HashMap<String, kd.bos.permission.model.perm.PermItem> itemEntNameMap = new HashMap<String, kd.bos.permission.model.perm.PermItem>(100);
                map.put("itemEntNameMap", itemEntNameMap);
                map.put("message", "");
                List dataSetList = (List)paramMap.get("data");
                String appIdBlackList = (String)paramMap.get("appIdBlackList");
                List appIdsInBlackList = (List)paramMap.get("appIdsInBlackList");
                List adminChargeApps = (List)paramMap.get("adminChargeApps");
                Map formShowOnTreeStatusMap = (Map)paramMap.get("formShowOnTreeStatusMap");
                boolean formNumsFromStdBlackListIsEmpty = (Boolean)paramMap.get("formNumsFromStdBlackListIsEmpty");
                List formNumsFromStdBlackList = (List)paramMap.get("formNumsFromStdBlackList");
                Map allUserAppEntMap = (Map)paramMap.get("allUserAppEntMap");
                boolean enableSysAuthority = (Boolean)paramMap.get("enableSysAuthority");
                List sysCloudApp = (List)paramMap.get("sysCloudApp");
                boolean showForSpecial = (Boolean)paramMap.get("showForSpecial");
                Set disabledCloudIds = (Set)paramMap.get("disabledCloudIds");
                boolean cloudSetNotEmpty = (Boolean)paramMap.get("cloudSetNotEmpty");
                Set disabledAppIds = (Set)paramMap.get("disabledAppIds");
                boolean appSetNotEmpty = (Boolean)paramMap.get("appSetNotEmpty");
                String name_is_empty = (String)paramMap.get("name_is_empty");
                Set filterAppNumSet = (Set)paramMap.get("filterAppNumSet");
                boolean filterAppNumSetNotEmpty = (Boolean)paramMap.get("filterAppNumSetNotEmpty");
                Set filterEntNumSet = (Set)paramMap.get("filterEntNumSet");
                boolean filterEntNumSetNotEmpty = (Boolean)paramMap.get("filterEntNumSetNotEmpty");
                boolean returnByField = (Boolean)paramMap.get("returnByField");
                Set returnFieldSet = (Set)paramMap.get("returnFieldSet");
                try {
                    for (int i = 0; i < dataSetList.size(); ++i) {
                        try (DataSet dataSet = (DataSet)dataSetList.get(i);){
                            while (dataSet.hasNext()) {
                                Set allUserEntNumSet;
                                Row row = dataSet.next();
                                String cloudId = row.getString("cloudId");
                                String cloudNum = row.getString("cloudNum");
                                String cloudName = row.getString("cloudName");
                                int cloudSeq = row.getInteger("cseq");
                                String appId = row.getString("oriAppId");
                                int appSeq = row.getInteger("aseq");
                                String appNum = row.getString("oriAppNum");
                                String appName = row.getString("appName");
                                String falluserapp = row.getString("falluserapp");
                                String appDeploystatus = row.getString("fdeploystatus");
                                String entdId = row.getString("oriEntId");
                                String entdNum = row.getString("oriEntNum");
                                String entdName = row.getString("entName");
                                String permItemId = row.getString("permItemId");
                                String permItemNum = row.getString("permItemNum");
                                String permItemName = row.getString("permItemName");
                                if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entdId) || StringUtils.isEmpty((String)permItemId) || filterAppNumSetNotEmpty && !filterAppNumSet.contains(appNum) || filterEntNumSetNotEmpty && !filterEntNumSet.contains(entdNum) || Objects.equals("perm_admingroup", entdNum) || Objects.equals("perm_useradmingroup", entdNum) || appSetNotEmpty && disabledAppIds.contains(appId) || cloudSetNotEmpty && disabledCloudIds.contains(cloudId) || !"2".equals(appDeploystatus) || appIdBlackList.contains(appId) || appIdsInBlackList.contains(appId) || !showForSpecial && !adminChargeApps.contains(appId) || "false".equals(formShowOnTreeStatusMap.get(entdNum)) || !formNumsFromStdBlackListIsEmpty && formNumsFromStdBlackList.contains(entdNum) || !enableSysAuthority && sysCloudApp.contains(appId) || "1".equals(falluserapp) && (null == (allUserEntNumSet = (Set)allUserAppEntMap.get(appId)) || allUserEntNumSet.isEmpty() || !allUserEntNumSet.contains(entdNum))) continue;
                                kd.bos.permission.model.perm.PermItem item = new kd.bos.permission.model.perm.PermItem();
                                if (returnByField) {
                                    if (returnFieldSet.contains("cloudId")) {
                                        item.setCloudId(cloudId);
                                    }
                                    if (returnFieldSet.contains("cloudSeq")) {
                                        item.setCloudSeq(cloudSeq);
                                    }
                                    if (returnFieldSet.contains("cloudNumber")) {
                                        item.setCloudNumber(cloudNum);
                                    }
                                    if (returnFieldSet.contains("cloudName")) {
                                        item.setCloudName(cloudName);
                                    }
                                    if (returnFieldSet.contains("appId")) {
                                        item.setAppId(appId);
                                    }
                                    if (returnFieldSet.contains("appSeq")) {
                                        item.setAppSeq(appSeq);
                                    }
                                    if (returnFieldSet.contains("appNumber")) {
                                        item.setAppNumber(appNum);
                                    }
                                    if (returnFieldSet.contains("appName")) {
                                        item.setAppName(appName);
                                    }
                                    if (returnFieldSet.contains("entityId")) {
                                        item.setEntityId(entdId);
                                    }
                                    if (returnFieldSet.contains("entityNumber")) {
                                        item.setEntityNumber(entdNum);
                                    }
                                    if (returnFieldSet.contains("entityName")) {
                                        item.setEntityName(StringUtils.isEmpty((String)entdName) || " ".equals(entdName) ? entdNum + name_is_empty : entdName);
                                    }
                                    if (returnFieldSet.contains("permItemId")) {
                                        item.setPermItemId(permItemId);
                                    }
                                    if (returnFieldSet.contains("permItemNumber")) {
                                        item.setPermItemNumber(permItemNum);
                                    }
                                    if (returnFieldSet.contains("permItemName")) {
                                        item.setPermItemName(permItemName);
                                    }
                                } else {
                                    item.setCloudId(cloudId);
                                    item.setCloudSeq(cloudSeq);
                                    item.setCloudNumber(cloudNum);
                                    item.setCloudName(cloudName);
                                    item.setAppId(appId);
                                    item.setAppSeq(appSeq);
                                    item.setAppNumber(appNum);
                                    item.setAppName(appName);
                                    item.setEntityId(entdId);
                                    item.setEntityNumber(entdNum);
                                    item.setEntityName(StringUtils.isEmpty((String)entdName) || " ".equals(entdName) ? entdNum + name_is_empty : entdName);
                                    item.setPermItemId(permItemId);
                                    item.setPermItemNumber(permItemNum);
                                    item.setPermItemName(permItemName);
                                }
                                itemEntNameMap.put(cloudId + "|" + appId + "|" + entdNum + "|" + permItemId, item);
                            }
                            continue;
                        }
                    }
                    return map;
                }
                catch (Exception e) {
                    logger.warn("UserDirectAssignPermTask.wrapDetailParamCallable error.", (Throwable)e);
                    throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
                }
            }
        };
    }

    @SdkInternal
    public static DataSet getPermItemDataSet() {
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fentitytypeid funcpermEntnum, b.fid permItemId, b.fnumber permItemNum, ");
        sb.append("case when bL.fname is null or bL.fname = '' or bL.fname = ' ' ");
        sb.append("then b.fname else  bL.fname ");
        sb.append("  end permItemName ");
        sb.append(" from t_perm_functionperm a ");
        sb.append(" inner join t_perm_permitem b on b.fid = a.fpermitemid ");
        sb.append(" left join t_perm_permitem_l bL on (bL.fid = b.fid and bL.flocaleid = ?) ");
        return DB.queryDataSet((String)PermItemHelper.class.getName(), (DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])new Object[]{RequestContext.get().getLang().name()});
    }

    public static String getPermItemNameById(String permItemId) {
        DynamicObject permitem = null;
        try {
            permitem = BusinessDataServiceHelper.loadSingleFromCache((Object)permItemId, (String)"perm_permitem");
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        if (null == permitem) {
            return "";
        }
        return permitem.getLocaleString("name").getLocaleValue();
    }

    @SdkInternal
    public static Map<String, String> getAEPFromPermItemNode(String permItemNode) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("appId", "");
        map.put("entNum", "");
        map.put("permItemId", "");
        if (StringUtils.isEmpty((String)permItemNode)) {
            return map;
        }
        if (permItemNode.indexOf(124) == -1 || permItemNode.indexOf(64) == -1 || permItemNode.indexOf(35) == -1) {
            return map;
        }
        String[] split = permItemNode.split("@");
        if (null == split || 0 == split.length) {
            return map;
        }
        map.put("appId", split[1].substring(0, split[1].indexOf("#")));
        String[] split1 = split[0].split("\\|");
        if (null == split1 || 0 == split1.length) {
            return map;
        }
        map.put("entNum", split1[0]);
        map.put("permItemId", split1[1]);
        return map;
    }

    @SdkInternal
    public static boolean checkPermItemUsed(Set<Object> permItemIdSet) {
        return QueryServiceHelper.exists((String)"perm_functionperm", (QFilter[])new QFilter[]{new QFilter("permitem", "in", permItemIdSet)});
    }

    @SdkInternal
    public static Map<String, Set<kd.bos.permission.model.perm.PermItem>> getPermItemMap(Set<String> idOrNumberOrNameSet, String keyType) {
        HashMap<String, Set<kd.bos.permission.model.perm.PermItem>> map = new HashMap<String, Set<kd.bos.permission.model.perm.PermItem>>(8);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("id", keyType)) {
            qFilterList.add(new QFilter("id", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("number", keyType)) {
            qFilterList.add(new QFilter("number", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("name", keyType)) {
            qFilterList.add(new QFilter("name", "in", idOrNumberOrNameSet));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"PermItemHelper.getPermItemMap", (String)"perm_permitem", (String)"id, number, name", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");){
            kd.bos.permission.model.perm.PermItem one = null;
            while (ds.hasNext()) {
                Row row = ds.next();
                one = new kd.bos.permission.model.perm.PermItem();
                String id = row.getString("id");
                String number = row.getString("number");
                String name = row.getString("name");
                one.setAppId(id);
                one.setAppNumber(number);
                one.setAppName(name);
                if (Objects.equals("id", keyType)) {
                    map.computeIfAbsent(String.valueOf(id), k -> new HashSet()).add(one);
                }
                if (Objects.equals("name", keyType)) {
                    map.computeIfAbsent(name, k -> new HashSet()).add(one);
                    continue;
                }
                if (!Objects.equals("number", keyType)) continue;
                map.computeIfAbsent(number, k -> new HashSet()).add(one);
            }
        }
        return map;
    }
}

