/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.PermissionControlType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.UserBizRoleCache;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.AppHelper;
import kd.bos.permission.cache.helper.FormHelper;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.OrgHelper;
import kd.bos.permission.cache.helper.PermItemHelper;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.model.permbase.App;
import kd.bos.permission.cache.model.permbase.PermItem;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.enums.ComRoleContentEnum;
import kd.bos.permission.model.perm.ComRole;
import kd.bos.permission.model.perm.ComRoleAdminGrp;
import kd.bos.permission.model.perm.ComRoleFieldPermScheme;
import kd.bos.permission.model.perm.Entity;
import kd.bos.permission.model.perm.FieldPerm;
import kd.bos.permission.model.perm.FieldPermScheme;
import kd.bos.permission.model.perm.NewDrPerm;
import kd.bos.permission.model.perm.NewDrPrPerm;
import kd.bos.permission.model.perm.PermLevelHash;
import kd.bos.permission.model.perm.UserDimFieldPerm;
import kd.bos.permission.model.perm.comrole.ComRoleFuncPerm;
import kd.bos.permission.model.perm.req.ComRoleEnableChangeReq;
import kd.bos.permission.model.perm.req.GetComRoleListReq;
import kd.bos.permission.model.perm.req.GetPermLevelHashReq;
import kd.bos.permission.model.perm.req.field.ComRoleFieldPermSchemeReq;
import kd.bos.permission.model.perm.req.field.GetUserDimFieldPermReq;
import kd.bos.permission.model.perm.resp.field.GetUserDimFieldPermResp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermRoleHelper {
    private static Log logger = LogFactory.getLog(PermRoleHelper.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Perm_PermRoleHelper_Pool", (int)1);
    private static ThreadPool fieldPermPool = ThreadPools.newFixedThreadPool((String)"Perm_PermRoleHelper_FieldPermPool", (int)4);

    public static Set<Long> getBusiRoleUserIdsByCommRoleIds(Set<String> roleIdSet) {
        if (CollectionUtils.isEmpty(roleIdSet)) {
            return new HashSet<Long>(1);
        }
        String roleIdsStr = String.join((CharSequence)"','", roleIdSet);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fuserid");
        sb.append(" from t_perm_userbizrole a");
        sb.append(" inner join t_perm_bizrolecomrole b on a.fbizroleid = b.fid");
        sb.append(" where b.froleid in ('").append(roleIdsStr).append("')");
        final HashSet<Long> userIdSet = new HashSet<Long>(8);
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    userIdSet.add(rs.getLong("fuserid"));
                }
                return null;
            }
        });
        return userIdSet;
    }

    public static Set<Long> getBusiRoleEnableUserIdsByCommRoleIds(Set<String> roleIdSet) {
        if (CollectionUtils.isEmpty(roleIdSet)) {
            return new HashSet<Long>(1);
        }
        String roleIdsStr = String.join((CharSequence)"','", roleIdSet);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fuserid");
        sb.append(" from t_perm_userbizrole a");
        sb.append(" inner join t_perm_bizrolecomrole b on a.fbizroleid = b.fid");
        sb.append(" inner join t_sec_user c on c.fid = a.fuserid");
        sb.append(" where b.froleid in ('").append(roleIdsStr).append("')");
        sb.append(" and c.fenable = '1' ");
        final HashSet<Long> userIdSet = new HashSet<Long>(8);
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    userIdSet.add(rs.getLong("fuserid"));
                }
                return null;
            }
        });
        return userIdSet;
    }

    public static Set<Long> getUserIds(Set<String> roleIdSet) {
        if (CollectionUtils.isEmpty(roleIdSet)) {
            return new HashSet<Long>(1);
        }
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getUserIdSet");
        commParam.put("roleIdList", new ArrayList<String>(roleIdSet));
        commParam.put("selectTSecUserGroupStaff", "1");
        commParam.put("selectTPermRole", "1");
        Map<String, Object> commRoleInfoMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (CollectionUtils.isEmpty(commRoleInfoMap)) {
            return new HashSet<Long>(1);
        }
        Set userIdSet = (Set)commRoleInfoMap.get("userIdSet");
        return CollectionUtils.isEmpty((Collection)userIdSet) ? new HashSet(1) : userIdSet;
    }

    @Deprecated
    public static Set<Long> getEnableUserIds(Set<String> roleIdSet) {
        Map<String, Set<Long>> enableUserIdMap = PermRoleHelper.getEnableUserIdMap(roleIdSet);
        return CollectionUtils.isEmpty(enableUserIdMap) ? new HashSet<Long>(1) : enableUserIdMap.values().stream().flatMap(x -> x.stream()).collect(Collectors.toSet());
    }

    public static Map<String, Set<Long>> getEnableUserIdMap(Set<String> roleIdSet) {
        if (CollectionUtils.isEmpty(roleIdSet)) {
            return new HashMap<String, Set<Long>>(1);
        }
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getUserIdSet");
        commParam.put("roleIdList", new ArrayList<String>(roleIdSet));
        commParam.put("userEnable", "1");
        commParam.put("selectTSecUserGroupStaff", "1");
        commParam.put("selectTPermRole", "1");
        commParam.put("selectTSecUser", "1");
        Map<String, Object> commRoleInfoMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (CollectionUtils.isEmpty(commRoleInfoMap)) {
            return new HashMap<String, Set<Long>>(1);
        }
        Map roleUserIdSetMap = (Map)commRoleInfoMap.get("roleUserIdSetMap");
        return CollectionUtils.isEmpty((Map)roleUserIdSetMap) ? new HashMap(1) : roleUserIdSetMap;
    }

    public static List<User> getUserList(String roleId, String langStr) {
        if (StringUtils.isEmpty((String)roleId)) {
            return new ArrayList<User>(1);
        }
        try {
            Map<String, Set<Long>> roleUserIdSetMap = PermRoleHelper.getRoleUserIdSetMap(Collections.singleton(roleId));
            Set<Long> userIdSet = roleUserIdSetMap.get(roleId);
            return UserHelper.getUserListBySet(userIdSet, langStr);
        }
        catch (Exception e) {
            logger.warn("PermRoleHelper.getUserList error", (Throwable)e);
            return new ArrayList<User>(1);
        }
    }

    public static Map<String, Set<Long>> getRoleUserIdSetMap(Set<String> roleIdSet) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return new HashMap<String, Set<Long>>(1);
        }
        final HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>(roleIdSet.size());
        String roleIdsStr = String.join((CharSequence)"','", roleIdSet);
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct froleid, fuserid");
        sb.append(" from t_perm_userrole where froleid in ('").append(roleIdsStr).append("')");
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    map.computeIfAbsent(rs.getString("froleid"), k -> new HashSet()).add(rs.getLong("fuserid"));
                }
                return null;
            }
        });
        sb.setLength(0);
        sb.append(" select a.froleid, b.fuserid ");
        sb.append(" from t_perm_usrgrprole a ");
        sb.append(" inner join t_sec_usergroupstaff b on  b.fusergroupid = a.fusrgrpid ");
        sb.append(" where a.froleid in ('").append(roleIdsStr).append("')");
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    map.computeIfAbsent(rs.getString("froleid"), k -> new HashSet()).add(rs.getLong("fuserid"));
                }
                return null;
            }
        });
        sb.setLength(0);
        sb.append("select b.froleid, a.fuserid");
        sb.append(" from t_perm_userbizrole a");
        sb.append(" inner join t_perm_bizrolecomrole b on a.fbizroleid = b.fid");
        sb.append(" where b.froleid in ('").append(roleIdsStr).append("')");
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    map.computeIfAbsent(rs.getString("froleid"), k -> new HashSet()).add(rs.getLong("fuserid"));
                }
                return null;
            }
        });
        sb.setLength(0);
        sb.append("select b.froleid, d.fuserid");
        sb.append(" from t_perm_usrgrpbizrole a");
        sb.append(" inner join t_sec_usergroupstaff d on d.fusergroupid  = a.fusrgrpid ");
        sb.append(" inner join t_perm_bizrolecomrole b on a.fbizroleid = b.fid");
        sb.append(" where b.froleid in ('").append(roleIdsStr).append("')");
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    map.computeIfAbsent(rs.getString("froleid"), k -> new HashSet()).add(rs.getLong("fuserid"));
                }
                return null;
            }
        });
        return map;
    }

    public static Map<String, Map<String, Object>> getRoleMap(final List<String> roleIdList, String langStr) {
        if (CollectionUtils.isEmpty(roleIdList)) {
            return new HashMap<String, Map<String, Object>>(1);
        }
        String roleIdsStr = String.join((CharSequence)"','", roleIdList);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid, a.fnumber, a.fname aName, b.fname bName, a.fissystem ");
        sb.append(" from t_perm_role a");
        sb.append(" left join t_perm_role_l b on a.fid = b.fid and b.flocaleid=?");
        sb.append(" where a.fid in ('").append(roleIdsStr).append("')");
        Object[] params = new Object[]{langStr};
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Object>>>(){

            public Map<String, Map<String, Object>> handle(ResultSet rs) throws Exception {
                HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(roleIdList.size());
                HashMap<String, Object> map = null;
                while (rs.next()) {
                    String fid = rs.getString("fid");
                    String fnumber = rs.getString("fnumber");
                    String aName = rs.getString("aName");
                    String bName = rs.getString("bName");
                    String fissystem = rs.getString("fissystem");
                    map = new HashMap<String, Object>(2);
                    map.put("fnumber", fnumber);
                    map.put("fname", StringUtils.isEmpty((String)bName) ? aName : bName);
                    map.put("fissystem", "1".equals(fissystem) ? Boolean.TRUE : Boolean.FALSE);
                    resultMap.put(fid, map);
                }
                return resultMap;
            }
        });
    }

    public static Long getCountByRoleId(String roleId) {
        String sql = "select count(*) num from t_perm_userrole where froleid = ? ";
        Object[] params = new Object[]{roleId};
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getLong("num");
                }
                return 0L;
            }
        });
    }

    public static Map<String, Set<String>> getCommRoleAppEntSetMap(Set<String> roleIdSet) {
        if (CollectionUtils.isEmpty(roleIdSet)) {
            return new HashMap<String, Set<String>>(1);
        }
        String roleIdStr = roleIdSet.stream().collect(Collectors.joining("','"));
        StringBuilder rolepermdetailSb = new StringBuilder();
        rolepermdetailSb.append("select distinct fbizappid, fentitytypeid from t_perm_rolepermdetial where froleid in ('").append(roleIdStr).append("') ");
        return (Map)DB.query((DBRoute)DBRoute.base, (String)rolepermdetailSb.toString(), (ResultSetHandler)new ResultSetHandler<Map<String, Set<String>>>(){

            public Map<String, Set<String>> handle(ResultSet rs) throws Exception {
                HashMap<String, Set<String>> appEntity = new HashMap<String, Set<String>>();
                while (rs.next()) {
                    String appId = rs.getString("fbizappid");
                    String entityNum = rs.getString("fentitytypeid");
                    appEntity.computeIfAbsent(appId, k -> new HashSet()).add(entityNum);
                }
                return appEntity;
            }
        });
    }

    public static Map<String, Map<String, Set<String>>> getRoleAppEntIdSetMap(Set<String> roleIdSet) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (null != roleIdSet && !roleIdSet.isEmpty()) {
            filterList.add(new QFilter("role", "in", roleIdSet));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PermRoleHelper.getRoleAppEntIdSetMap", (String)"perm_rolefuncperm", (String)"role_id, bizapp_id, entity_id", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            HashMap<String, Map<String, Set<String>>> map = new HashMap<String, Map<String, Set<String>>>(8);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String role_id = row.getString("role_id");
                String bizapp_id = row.getString("bizapp_id");
                String entity_id = row.getString("entity_id");
                if (StringUtils.isEmpty((String)role_id) || StringUtils.isEmpty((String)bizapp_id) || StringUtils.isEmpty((String)entity_id)) continue;
                map.computeIfAbsent(role_id, k -> new HashMap(8)).computeIfAbsent(bizapp_id, k -> new HashSet(8)).add(entity_id);
            }
            HashMap<String, Map<String, Set<String>>> hashMap = map;
            return hashMap;
        }
    }

    public static Map<String, Map<String, Set<String>>> getRoleIdAppEntSetMap(Set<String> roleIdSet) {
        if (CollectionUtils.isEmpty(roleIdSet)) {
            return new HashMap<String, Map<String, Set<String>>>(0);
        }
        HashMap<String, Map<String, Set<String>>> result = new HashMap<String, Map<String, Set<String>>>(8);
        Map<String, Set<ComRoleFuncPerm>> roleIdPermSetMap = PermRoleHelper.getRolePermSetMap(roleIdSet, "id");
        for (String roleId : roleIdSet) {
            Set<ComRoleFuncPerm> comRoleFuncPerms = roleIdPermSetMap.get(roleId);
            if (null == comRoleFuncPerms) {
                result.put(roleId, new HashMap(1));
                continue;
            }
            for (ComRoleFuncPerm one : comRoleFuncPerms) {
                result.computeIfAbsent(roleId, k -> new HashMap(8)).computeIfAbsent(one.getAppId(), k -> new HashSet(8)).add(one.getEntityNumber());
            }
        }
        return result;
    }

    public static Map<Object, DynamicObject> getRoleDynMap(Set<String> roleIdSet) {
        try {
            int size = roleIdSet.size();
            int m = SqlUtil.getBatchCount(PermHelperConst.CONST_200, size);
            final CountDownLatch countDownLatch = new CountDownLatch(m);
            LinkedList<Future> futureList = new LinkedList<Future>();
            ArrayList<String> idList = new ArrayList<String>(roleIdSet);
            List<List<String>> listAvg = ListUtil.averageAssign(idList, m);
            for (int i = 0; i < listAvg.size(); ++i) {
                final List<String> idSchemes = listAvg.get(i);
                Future oneList = pool.submit((Callable)new Callable<Map<Object, DynamicObject>>(){

                    @Override
                    public Map<Object, DynamicObject> call() throws Exception {
                        try {
                            QFilter uFilter = new QFilter("id", "in", (Object)idSchemes);
                            Map map = BusinessDataServiceHelper.loadFromCache((String)"perm_role", (String)"name, number", (QFilter[])new QFilter[]{uFilter});
                            return map;
                        }
                        catch (Exception e) {
                            logger.warn("UserHelper.getUserDynMap.call error.", (Throwable)e);
                            throw new KDBizException(new ErrorCode("0", "UserHelper.getUserDynMap.call error."), new Object[0]);
                        }
                        finally {
                            if (null != countDownLatch) {
                                countDownLatch.countDown();
                            }
                        }
                    }
                });
                futureList.add(oneList);
            }
            countDownLatch.await();
            HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(size);
            for (Future listFuture : futureList) {
                Map part = (Map)listFuture.get();
                map.putAll(part);
            }
            return map;
        }
        catch (Exception e) {
            logger.warn("UserHelper.getUserDynMap error", (Throwable)e);
            return new HashMap<Object, DynamicObject>(1);
        }
    }

    public static Map<String, Object> getCommRoleInfoMap(Map<String, Object> param) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        Set roleIdSet = null;
        Set allDimIdSet = null;
        Set includesubDimIdSet = null;
        Map dimIdIncludesubMap = null;
        Map dimIdIncludesubStrMap = null;
        Set userIdSet = null;
        Map roleUserIdSetMap = null;
        Set permItemIdSet = null;
        Map roleDimIncludeSubMap = new HashMap(1);
        PermLevelHash permLevelHash = null;
        String queryType = (String)param.get("queryType");
        if ("getRoleIdSet".equals(queryType)) {
            resultMap.put("roleIdSet", new HashSet(8));
            roleIdSet = (Set)resultMap.get("roleIdSet");
        } else if ("getDimIncludeSubInfo".equals(queryType)) {
            resultMap.put("allDimIdSet", new HashSet(8));
            resultMap.put("includesubDimIdSet", new HashSet(8));
            resultMap.put("dimIdIncludesubMap", new HashMap(8));
            resultMap.put("dimIdIncludesubStrMap", new HashMap(8));
            allDimIdSet = (Set)resultMap.get("allDimIdSet");
            includesubDimIdSet = (Set)resultMap.get("includesubDimIdSet");
            dimIdIncludesubMap = (Map)resultMap.get("dimIdIncludesubMap");
            dimIdIncludesubStrMap = (Map)resultMap.get("dimIdIncludesubStrMap");
        } else if ("getUserIdSet".equals(queryType)) {
            resultMap.put("userIdSet", new HashSet(8));
            userIdSet = (Set)resultMap.get("userIdSet");
            resultMap.put("roleUserIdSetMap", new HashMap(8));
            roleUserIdSetMap = (Map)resultMap.get("roleUserIdSetMap");
        } else if ("getPermItemIdSet".equals(queryType)) {
            resultMap.put("permItemIdSet", new HashSet(8));
            permItemIdSet = (Set)resultMap.get("permItemIdSet");
        } else if ("getRoleDimIncludeSubMap".equals(queryType)) {
            resultMap.put("roleDimIncludeSubMap", new HashMap(8));
            roleDimIncludeSubMap = (Map)resultMap.get("roleDimIncludeSubMap");
        } else if ("getPermLevelHash".equals(queryType)) {
            permLevelHash = new PermLevelHash();
        }
        boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        param.put("enableValidateTime", enableValidateTime);
        Map<Object, Object> userCommRoleInfoMap = new HashMap(8);
        Map<Object, Object> usrGrpCommRoleInfoMap = new HashMap(8);
        Object type = param.get("type");
        if (null == type) {
            userCommRoleInfoMap = PermRoleHelper.getUserCommRoleInfoMap(param);
            usrGrpCommRoleInfoMap = PermRoleHelper.getUsrGrpCommRoleInfoMap(param);
        } else if (Objects.equals(1, type)) {
            userCommRoleInfoMap = PermRoleHelper.getUserCommRoleInfoMap(param);
        } else if (Objects.equals(2, type)) {
            usrGrpCommRoleInfoMap = PermRoleHelper.getUsrGrpCommRoleInfoMap(param);
        }
        if ("getRoleIdSet".equals(queryType)) {
            Set userRoleIdSet = null == userCommRoleInfoMap.get("roleIdSet") ? new HashSet(1) : (Set)userCommRoleInfoMap.get("roleIdSet");
            Set usrgrpRoleIdSet = null == usrGrpCommRoleInfoMap.get("roleIdSet") ? new HashSet(1) : (Set)usrGrpCommRoleInfoMap.get("roleIdSet");
            roleIdSet.addAll(userRoleIdSet);
            roleIdSet.addAll(usrgrpRoleIdSet);
        } else if ("getDimIncludeSubInfo".equals(queryType)) {
            Boolean includeSub;
            Long dimId;
            Set userAllDimIdSet = null == userCommRoleInfoMap.get("allDimIdSet") ? new HashSet(1) : (Set)userCommRoleInfoMap.get("allDimIdSet");
            Set userIncludesubDimIdSet = null == userCommRoleInfoMap.get("includesubDimIdSet") ? new HashSet(1) : (Set)userCommRoleInfoMap.get("includesubDimIdSet");
            Map userDimIdIncludesubMap = null == userCommRoleInfoMap.get("dimIdIncludesubMap") ? new HashMap(1) : (Map)userCommRoleInfoMap.get("dimIdIncludesubMap");
            Set usrgrpAllDimIdSet = null == usrGrpCommRoleInfoMap.get("allDimIdSet") ? new HashSet(1) : (Set)usrGrpCommRoleInfoMap.get("allDimIdSet");
            Set usrgrpIncludesubDimIdSet = null == usrGrpCommRoleInfoMap.get("includesubDimIdSet") ? new HashSet(1) : (Set)usrGrpCommRoleInfoMap.get("includesubDimIdSet");
            Map usrgrpDimIdIncludesubMap = null == usrGrpCommRoleInfoMap.get("dimIdIncludesubMap") ? new HashMap(1) : (Map)usrGrpCommRoleInfoMap.get("dimIdIncludesubMap");
            allDimIdSet.addAll(userAllDimIdSet);
            allDimIdSet.addAll(usrgrpAllDimIdSet);
            includesubDimIdSet.addAll(userIncludesubDimIdSet);
            includesubDimIdSet.addAll(usrgrpIncludesubDimIdSet);
            for (Map.Entry dimIdIncludesub : userDimIdIncludesubMap.entrySet()) {
                dimId = (Long)dimIdIncludesub.getKey();
                includeSub = (Boolean)dimIdIncludesub.getValue();
                if (null != dimIdIncludesubMap.get(dimId) && Boolean.TRUE.equals(dimIdIncludesubMap.get(dimId))) continue;
                dimIdIncludesubMap.put(dimId, includeSub);
                dimIdIncludesubStrMap.put(dimId, includeSub != false ? "1" : "0");
            }
            for (Map.Entry dimIdIncludesub : usrgrpDimIdIncludesubMap.entrySet()) {
                dimId = (Long)dimIdIncludesub.getKey();
                includeSub = (Boolean)dimIdIncludesub.getValue();
                if (null != dimIdIncludesubMap.get(dimId) && Boolean.TRUE.equals(dimIdIncludesubMap.get(dimId))) continue;
                dimIdIncludesubMap.put(dimId, includeSub);
                dimIdIncludesubStrMap.put(dimId, includeSub != false ? "1" : "0");
            }
        } else if ("getUserIdSet".equals(queryType)) {
            Set userUserIdSet = null == userCommRoleInfoMap.get("userIdSet") ? new HashSet(1) : (Set)userCommRoleInfoMap.get("userIdSet");
            Set usrgrpUserIdSet = null == usrGrpCommRoleInfoMap.get("userIdSet") ? new HashSet(1) : (Set)usrGrpCommRoleInfoMap.get("userIdSet");
            userIdSet.addAll(userUserIdSet);
            userIdSet.addAll(usrgrpUserIdSet);
            Map userRoleUserIdSetMap = null == userCommRoleInfoMap.get("roleUserIdSetMap") ? new HashMap(1) : (Map)userCommRoleInfoMap.get("roleUserIdSetMap");
            Map usrgrpRoleUserIdSetMap = null == usrGrpCommRoleInfoMap.get("roleUserIdSetMap") ? new HashMap(1) : (Map)usrGrpCommRoleInfoMap.get("roleUserIdSetMap");
            for (Map.Entry one : userRoleUserIdSetMap.entrySet()) {
                roleUserIdSetMap.computeIfAbsent(one.getKey(), k -> new HashSet(8)).addAll((Collection)one.getValue());
            }
            for (Map.Entry one : usrgrpRoleUserIdSetMap.entrySet()) {
                roleUserIdSetMap.computeIfAbsent(one.getKey(), k -> new HashSet(8)).addAll((Collection)one.getValue());
            }
        } else if ("getPermItemIdSet".equals(queryType)) {
            Set userPermItemIdSet = null == userCommRoleInfoMap.get("permItemIdSet") ? new HashSet(1) : (Set)userCommRoleInfoMap.get("permItemIdSet");
            Set usrgrpPermItemIdSet = null == usrGrpCommRoleInfoMap.get("permItemIdSet") ? new HashSet(1) : (Set)usrGrpCommRoleInfoMap.get("permItemIdSet");
            permItemIdSet.addAll(userPermItemIdSet);
            permItemIdSet.addAll(usrgrpPermItemIdSet);
        } else if ("getRoleDimIncludeSubMap".equals(queryType)) {
            Map dimIncludeSubMap;
            String roleId;
            Map userRoleDimIncludeSubMap = null == userCommRoleInfoMap.get("roleDimIncludeSubMap") ? new HashMap(1) : (Map)userCommRoleInfoMap.get("roleDimIncludeSubMap");
            Map usrgrpRoleDimIncludeSubMap = null == usrGrpCommRoleInfoMap.get("roleDimIncludeSubMap") ? new HashMap(1) : (Map)usrGrpCommRoleInfoMap.get("roleDimIncludeSubMap");
            Map finalRoleDimIncludeSubMap = roleDimIncludeSubMap;
            for (Map.Entry dimIdIncludesub : userRoleDimIncludeSubMap.entrySet()) {
                roleId = (String)dimIdIncludesub.getKey();
                dimIncludeSubMap = (Map)dimIdIncludesub.getValue();
                dimIncludeSubMap.forEach((k, v) -> {
                    if (v.booleanValue()) {
                        finalRoleDimIncludeSubMap.computeIfAbsent(roleId, id -> new HashMap()).put(k, v);
                    } else {
                        finalRoleDimIncludeSubMap.computeIfAbsent(roleId, id -> new HashMap()).putIfAbsent(k, v);
                    }
                });
            }
            for (Map.Entry dimIdIncludesub : usrgrpRoleDimIncludeSubMap.entrySet()) {
                roleId = (String)dimIdIncludesub.getKey();
                dimIncludeSubMap = (Map)dimIdIncludesub.getValue();
                dimIncludeSubMap.forEach((k, v) -> {
                    if (v.booleanValue()) {
                        finalRoleDimIncludeSubMap.computeIfAbsent(roleId, id -> new HashMap()).put(k, v);
                    } else {
                        finalRoleDimIncludeSubMap.computeIfAbsent(roleId, id -> new HashMap()).putIfAbsent(k, v);
                    }
                });
            }
        } else if ("getPermLevelHash".equals(queryType)) {
            Set value;
            String key;
            PermLevelHash userRolePermLevelHash = null == userCommRoleInfoMap.get("permLevelHash") ? new PermLevelHash() : (PermLevelHash)userCommRoleInfoMap.get("permLevelHash");
            boolean userRoleHasIncludeSub = userRolePermLevelHash.isHasIncludeSub();
            Map userRoleFuncDimMap = userRolePermLevelHash.getFuncDimMap();
            PermLevelHash usrgrpRolePermLevelHash = null == usrGrpCommRoleInfoMap.get("permLevelHash") ? new PermLevelHash() : (PermLevelHash)usrGrpCommRoleInfoMap.get("permLevelHash");
            boolean usrgrpRoleHasIncludeSub = usrgrpRolePermLevelHash.isHasIncludeSub();
            Map usrgrpRoleFuncDimMap = usrgrpRolePermLevelHash.getFuncDimMap();
            HashMap<String, Set> finalIncludeSubMap = new HashMap<String, Set>(8);
            if (null != userRoleFuncDimMap && !userRoleFuncDimMap.isEmpty()) {
                for (Map.Entry userRoleFuncDim : userRoleFuncDimMap.entrySet()) {
                    key = (String)userRoleFuncDim.getKey();
                    value = (Set)userRoleFuncDim.getValue();
                    finalIncludeSubMap.computeIfAbsent(key, k -> new HashSet(8)).addAll(value);
                }
            }
            if (null != usrgrpRoleFuncDimMap && !usrgrpRoleFuncDimMap.isEmpty()) {
                for (Map.Entry usrgrpRoleFuncDim : usrgrpRoleFuncDimMap.entrySet()) {
                    key = (String)usrgrpRoleFuncDim.getKey();
                    value = (Set)usrgrpRoleFuncDim.getValue();
                    finalIncludeSubMap.computeIfAbsent(key, k -> new HashSet(8)).addAll(value);
                }
            }
            if (permLevelHash != null) {
                permLevelHash.setHasIncludeSub(userRoleHasIncludeSub || usrgrpRoleHasIncludeSub);
                permLevelHash.setFuncDimMap(finalIncludeSubMap);
            }
            resultMap.put("permLevelHash", permLevelHash);
        }
        return resultMap;
    }

    private static Map<String, Object> getUsrGrpCommRoleInfoMap(Map<String, Object> param) {
        Set usrGrpIds;
        Object usrGrpIdSet;
        Object userEnable;
        Object enable;
        Object orgView;
        Object permItemId;
        Object entityNum;
        Object appId;
        List dimTypeList;
        Object includeSub;
        List dimIds;
        List dimIdList;
        List roleNumbers;
        Object roleNumberList;
        List roleIds;
        Object roleIdList;
        Object selectTSecUser;
        Object selectTOrgStructure;
        Object selectTPermRolePermDetail;
        Object selectTSecUserGroupStaff;
        final String queryType = (String)param.get("queryType");
        if ("getPermLevelHash".equals(queryType)) {
            return PermRoleHelper.getUsrGrpPermLevelHashMap(param);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        if ("getRoleIdSet".equals(queryType)) {
            Sets.SetView usrGrpRoleIdSet = PermRoleHelper.getUsrGrpRoleIdSet(param);
            if (null != param.get("appId") || null != param.get("entityNum") || null != param.get("permItemId")) {
                Set<String> roleIdByAppEntPermItem = PermRoleHelper.getRoleIdByAppEntPermItem(param);
                usrGrpRoleIdSet = Sets.intersection(usrGrpRoleIdSet, roleIdByAppEntPermItem);
            }
            resultMap.put("roleIdSet", usrGrpRoleIdSet);
            return resultMap;
        }
        Set allDimIdSet = null;
        Set includesubDimIdSet = null;
        Map dimIdIncludesubMap = null;
        Set userIdSet = null;
        Map roleUserIdSetMap = null;
        Set permItemIdSet = null;
        Map roleDimIncludeSubMap = null;
        if ("getDimIncludeSubInfo".equals(queryType)) {
            resultMap.put("allDimIdSet", new HashSet(8));
            resultMap.put("includesubDimIdSet", new HashSet(8));
            resultMap.put("dimIdIncludesubMap", new HashMap(8));
            allDimIdSet = (Set)resultMap.get("allDimIdSet");
            includesubDimIdSet = (Set)resultMap.get("includesubDimIdSet");
            dimIdIncludesubMap = (Map)resultMap.get("dimIdIncludesubMap");
        } else if ("getUserIdSet".equals(queryType)) {
            resultMap.put("userIdSet", new HashSet(8));
            userIdSet = (Set)resultMap.get("userIdSet");
            resultMap.put("roleUserIdSetMap", new HashMap(8));
            roleUserIdSetMap = (Map)resultMap.get("roleUserIdSetMap");
        } else if ("getPermItemIdSet".equals(queryType)) {
            resultMap.put("permItemIdSet", new HashSet(8));
            permItemIdSet = (Set)resultMap.get("permItemIdSet");
        } else if ("getRoleDimIncludeSubMap".equals(queryType)) {
            resultMap.put("roleDimIncludeSubMap", new HashMap(8));
            roleDimIncludeSubMap = (Map)resultMap.get("roleDimIncludeSubMap");
        }
        ArrayList<Object> paramList = new ArrayList<Object>(8);
        StringBuilder sb = new StringBuilder();
        if ("getDimIncludeSubInfo".equals(queryType)) {
            sb.append("select distinct a.fdimid, a.fincludesub ");
        } else if ("getUserIdSet".equals(queryType)) {
            sb.append("select distinct a.froleid, c.fuserid ");
        } else if ("getPermItemIdSet".equals(queryType)) {
            sb.append("select distinct d.fpermitemid ");
        } else if ("getRoleDimIncludeSubMap".equals(queryType)) {
            sb.append("select distinct a.froleid, a.fdimid, a.fincludesub ");
        }
        final boolean enableValidateTime = (Boolean)param.get("enableValidateTime");
        if (enableValidateTime) {
            sb.append(", a.fstarttime, a.fendtime ");
        }
        sb.append("from t_perm_usrgrprole a ");
        Object selectTPermRole = param.get("selectTPermRole");
        if (null != selectTPermRole) {
            sb.append("inner join t_perm_role b on b.fid = a.froleid  ");
        }
        if (null != (selectTSecUserGroupStaff = param.get("selectTSecUserGroupStaff"))) {
            sb.append("inner join t_sec_usergroupstaff c on c.fusergroupid = a.fusrgrpid ");
        }
        if (null != (selectTPermRolePermDetail = param.get("selectTPermRolePermDetail"))) {
            sb.append("inner join t_perm_rolepermdetial d on d.froleid = a.froleid ");
        }
        if (null != (selectTOrgStructure = param.get("selectTOrgStructure"))) {
            sb.append("inner join t_org_structure os on os.forgid = a.fdimid ");
        }
        if (null != (selectTSecUser = param.get("selectTSecUser"))) {
            sb.append("inner join t_sec_user sc on sc.fid = c.fuserid ");
        }
        sb.append("where 1=1 ");
        Object userId = param.get("userId");
        if (null != userId) {
            sb.append(" and c.fuserid = ? ");
            paramList.add(userId);
        }
        if (null != (roleIdList = param.get("roleIdList")) && null != (roleIds = ((List)roleIdList).stream().map(String::valueOf).collect(Collectors.toList())) && !roleIds.isEmpty()) {
            String roleIdsStr = String.join((CharSequence)"','", roleIds);
            sb.append(" and a.froleid in ('").append(roleIdsStr).append("')");
        }
        if (null != (roleNumberList = param.get("roleNumberList")) && null != (roleNumbers = ((List)roleNumberList).stream().map(String::valueOf).collect(Collectors.toList())) && !roleNumbers.isEmpty()) {
            String roleNumbersStr = String.join((CharSequence)"','", roleNumbers);
            sb.append(" and b.fnumber in ('").append(roleNumbersStr).append("')");
        }
        if (null != (dimIdList = (List)param.get("dimIdList")) && !dimIdList.isEmpty() && null != (dimIds = dimIdList.stream().map(String::valueOf).collect(Collectors.toList())) && !dimIds.isEmpty()) {
            String dimIdsStr = String.join((CharSequence)"','", dimIds);
            sb.append(" and a.fdimid in ('").append(dimIdsStr).append("')");
        }
        if (null != (includeSub = param.get("includeSub"))) {
            sb.append(" and a.fincludesub = ? ");
            paramList.add(includeSub);
        }
        if (null != (dimTypeList = (List)param.get("dimTypeList")) && !dimTypeList.isEmpty()) {
            String dimTypeStr = String.join((CharSequence)"','", dimTypeList);
            sb.append(" and a.fdimtype in ('").append(dimTypeStr).append("')");
        }
        if (null != (appId = param.get("appId"))) {
            sb.append(" and d.fbizappid = ? ");
            paramList.add(appId);
        }
        if (null != (entityNum = param.get("entityNum"))) {
            sb.append(" and d.fentitytypeid = ? ");
            paramList.add(entityNum);
        }
        if (null != (permItemId = param.get("permItemId"))) {
            sb.append(" and d.fpermitemid = ? ");
            paramList.add(permItemId);
        }
        if (null != (orgView = param.get("orgView"))) {
            sb.append(" and os.fviewid = ? ");
            String[] suitableViewId = OrgHelper.getSuitableViewId(String.valueOf(orgView));
            paramList.add(Long.valueOf(suitableViewId[1]));
        }
        if (null != (enable = param.get("enable"))) {
            sb.append(" and b.fenable = ? ");
            paramList.add(enable);
        }
        if (null != (userEnable = param.get("userEnable"))) {
            sb.append(" and sc.fenable = ? ");
            paramList.add(userEnable);
        }
        if (null != (usrGrpIdSet = param.get("usrGrpIdSet")) && null != (usrGrpIds = ((Set)usrGrpIdSet).stream().map(String::valueOf).collect(Collectors.toSet())) && !usrGrpIds.isEmpty()) {
            String usrGrpIdStr = String.join((CharSequence)",", usrGrpIds);
            sb.append(" and a.fusrgrpid in (").append(usrGrpIdStr).append(")");
        }
        final Set finalAllDimIdSet = allDimIdSet;
        final Set finalIncludesubDimIdSet = includesubDimIdSet;
        final Map finalDimIdIncludesubMap = dimIdIncludesubMap;
        final Set finalUserIdSet = userIdSet;
        final Map finalRoleUserIdSetMap = roleUserIdSetMap;
        final Set finalPermItemIdSet = permItemIdSet;
        final Map finalRoleDimIncludeSubMap = roleDimIncludeSubMap;
        DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    Boolean includeSub;
                    String froleid;
                    if (enableValidateTime) {
                        Date endTime;
                        String startTimeStr = rs.getString("fstarttime");
                        String endTimeStr = rs.getString("fendtime");
                        Date startTime = StringUtils.isEmpty((String)startTimeStr) ? null : DateUtil.toDate(startTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                        if (!PermCommonUtil.isInValidateTime(startTime, endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate(endTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss"))) continue;
                    }
                    if ("getDimIncludeSubInfo".equals(queryType)) {
                        Boolean includeSub2;
                        Long dimId = rs.getLong("fdimid");
                        finalAllDimIdSet.add(dimId);
                        String includeSubStr = rs.getString("fincludesub");
                        includeSubStr = StringUtils.isEmpty((String)includeSubStr) || "0".equals(includeSubStr) ? "0" : "1";
                        Boolean bl = includeSub2 = StringUtils.isEmpty((String)includeSubStr) || "0".equals(includeSubStr) ? Boolean.FALSE : Boolean.TRUE;
                        if (Boolean.TRUE.equals(includeSub2)) {
                            finalIncludesubDimIdSet.add(dimId);
                        }
                        if (null != finalDimIdIncludesubMap.get(dimId) && Boolean.TRUE.equals(finalDimIdIncludesubMap.get(dimId))) continue;
                        finalDimIdIncludesubMap.put(dimId, includeSub2);
                        continue;
                    }
                    if ("getUserIdSet".equals(queryType)) {
                        froleid = rs.getString("froleid");
                        long fuserid = rs.getLong("fuserid");
                        finalUserIdSet.add(fuserid);
                        finalRoleUserIdSetMap.computeIfAbsent(froleid, k -> new HashSet(8)).add(fuserid);
                        continue;
                    }
                    if ("getPermItemIdSet".equals(queryType)) {
                        finalPermItemIdSet.add(rs.getString("fpermitemid"));
                        continue;
                    }
                    if (!"getRoleDimIncludeSubMap".equals(queryType)) continue;
                    froleid = rs.getString("froleid");
                    Long dimId = rs.getLong("fdimid");
                    String includeSubStr = rs.getString("fincludesub");
                    includeSubStr = StringUtils.isEmpty((String)includeSubStr) || "0".equals(includeSubStr) ? "0" : "1";
                    Boolean bl = includeSub = StringUtils.isEmpty((String)includeSubStr) || "0".equals(includeSubStr) ? Boolean.FALSE : Boolean.TRUE;
                    if (Boolean.TRUE.equals(includeSub)) {
                        finalRoleDimIncludeSubMap.computeIfAbsent(froleid, k -> new HashMap(8)).put(dimId, includeSub);
                        continue;
                    }
                    finalRoleDimIncludeSubMap.computeIfAbsent(froleid, k -> new HashMap(8)).putIfAbsent(dimId, includeSub);
                }
                return null;
            }
        });
        return resultMap;
    }

    private static Set<String> getUsrGrpRoleIdSet(Map<String, Object> param) {
        Object includeSub;
        List dimIds;
        List dimIdList;
        Object userIdObj = param.get("userId");
        if (null == userIdObj) {
            return new HashSet<String>(1);
        }
        Long userId = (Long)userIdObj;
        Set<Long> usrGrpIdSet = UserHelper.getUsrGrpId(userId);
        if (null == usrGrpIdSet || usrGrpIdSet.isEmpty()) {
            return new HashSet<String>(1);
        }
        ArrayList<Object> paramList = new ArrayList<Object>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.froleid ");
        final boolean enableValidateTime = (Boolean)param.get("enableValidateTime");
        if (enableValidateTime) {
            sb.append(", a.fstarttime, a.fendtime ");
        }
        sb.append(" from t_perm_role b");
        sb.append(" inner join t_perm_usrgrprole a on a.froleid = b.fid");
        Object selectTOrgStructure = param.get("selectTOrgStructure");
        if (null != selectTOrgStructure) {
            sb.append(" inner join t_org_structure os on os.forgid = a.fdimid ");
        }
        sb.append(" where b.fenable ='1' ");
        List dimTypeList = (List)param.get("dimTypeList");
        if (null != dimTypeList && !dimTypeList.isEmpty()) {
            String dimTypeStr = String.join((CharSequence)"','", dimTypeList);
            sb.append(" and a.fdimtype in ('").append(dimTypeStr).append("')");
        }
        if (null != (dimIdList = (List)param.get("dimIdList")) && !dimIdList.isEmpty() && null != (dimIds = dimIdList.stream().map(String::valueOf).collect(Collectors.toList())) && !dimIds.isEmpty()) {
            String dimIdsStr = String.join((CharSequence)",", dimIds);
            sb.append(" and a.fdimid in (").append(dimIdsStr).append(")");
        }
        if (null != (includeSub = param.get("includeSub"))) {
            sb.append(" and a.fincludesub = ? ");
            paramList.add(includeSub);
        }
        List usrGrpIdList = usrGrpIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String usrGrpIdStr = String.join((CharSequence)",", usrGrpIdList);
        sb.append(" and a.fusrgrpid in(").append(usrGrpIdStr).append(')');
        Object orgView = param.get("orgView");
        if (null != orgView) {
            sb.append(" and os.fviewid = ? ");
            String[] suitableViewId = OrgHelper.getSuitableViewId(String.valueOf(orgView));
            paramList.add(Long.valueOf(suitableViewId[1]));
        }
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> set = new HashSet<String>(8);
                while (rs.next()) {
                    if (enableValidateTime) {
                        Date endTime;
                        String startTimeStr = rs.getString("fstarttime");
                        String endTimeStr = rs.getString("fendtime");
                        Date startTime = StringUtils.isEmpty((String)startTimeStr) ? null : DateUtil.toDate(startTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                        Date date = endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate(endTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                        if (!PermCommonUtil.isInValidateTime(startTime, endTime)) continue;
                    }
                    String froleid = rs.getString("froleid");
                    set.add(froleid);
                }
                return set;
            }
        });
    }

    private static Map<String, Object> getUserCommRoleInfoMap(Map<String, Object> param) {
        Object userEnable;
        Object enable;
        Object orgView;
        Object permItemId;
        Object entityNum;
        Object appId;
        List dimTypeList;
        Object includeSub;
        List dimIds;
        List dimIdList;
        List roleNumbers;
        Object roleNumberList;
        List roleIds;
        Object roleIdList;
        Object selectTSecUser;
        Object selectTOrgStructure;
        Object selectTPermRolePermDetail;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        Set roleIdSet = null;
        Set allDimIdSet = null;
        Set includesubDimIdSet = null;
        Map dimIdIncludesubMap = null;
        Set userIdSet = null;
        Map roleUserIdSetMap = null;
        Set permItemIdSet = null;
        Map roleDimIncludeSubMap = null;
        final String queryType = (String)param.get("queryType");
        if ("getPermLevelHash".equals(queryType)) {
            return PermRoleHelper.getUsrPermLevelHashMap(param);
        }
        if ("getRoleIdSet".equals(queryType)) {
            resultMap.put("roleIdSet", new HashSet(8));
            roleIdSet = (Set)resultMap.get("roleIdSet");
        } else if ("getDimIncludeSubInfo".equals(queryType)) {
            resultMap.put("allDimIdSet", new HashSet(8));
            resultMap.put("includesubDimIdSet", new HashSet(8));
            resultMap.put("dimIdIncludesubMap", new HashMap(8));
            allDimIdSet = (Set)resultMap.get("allDimIdSet");
            includesubDimIdSet = (Set)resultMap.get("includesubDimIdSet");
            dimIdIncludesubMap = (Map)resultMap.get("dimIdIncludesubMap");
        } else if ("getUserIdSet".equals(queryType)) {
            resultMap.put("userIdSet", new HashSet(8));
            userIdSet = (Set)resultMap.get("userIdSet");
            resultMap.put("roleUserIdSetMap", new HashMap(8));
            roleUserIdSetMap = (Map)resultMap.get("roleUserIdSetMap");
        } else if ("getPermItemIdSet".equals(queryType)) {
            resultMap.put("permItemIdSet", new HashSet(8));
            permItemIdSet = (Set)resultMap.get("permItemIdSet");
        } else if ("getRoleDimIncludeSubMap".equals(queryType)) {
            resultMap.put("roleDimIncludeSubMap", new HashMap(8));
            roleDimIncludeSubMap = (Map)resultMap.get("roleDimIncludeSubMap");
        }
        ArrayList<Object> paramList = new ArrayList<Object>(8);
        StringBuilder sb = new StringBuilder();
        if ("getRoleIdSet".equals(queryType)) {
            sb.append("select distinct a.froleid ");
        } else if ("getDimIncludeSubInfo".equals(queryType)) {
            sb.append("select distinct a.forgid, a.fisincludesuborg ");
        } else if ("getUserIdSet".equals(queryType)) {
            sb.append("select distinct a.froleid, a.fuserid ");
        } else if ("getPermItemIdSet".equals(queryType)) {
            sb.append("select distinct c.fpermitemid ");
        } else if ("getRoleDimIncludeSubMap".equals(queryType)) {
            sb.append("select distinct a.froleid, a.forgid, a.fisincludesuborg ");
        }
        final boolean enableValidateTime = (Boolean)param.get("enableValidateTime");
        if (enableValidateTime) {
            sb.append(", a.fstarttime, a.fendtime ");
        }
        sb.append("from t_perm_userrole a ");
        Object selectTPermRole = param.get("selectTPermRole");
        if (null != selectTPermRole) {
            sb.append("inner join t_perm_role b on b.fid = a.froleid  ");
        }
        if (null != (selectTPermRolePermDetail = param.get("selectTPermRolePermDetail"))) {
            sb.append("inner join t_perm_rolepermdetial c on c.froleid = a.froleid  ");
        }
        if (null != (selectTOrgStructure = param.get("selectTOrgStructure"))) {
            sb.append("inner join t_org_structure os on os.forgid = a.forgid ");
        }
        if (null != (selectTSecUser = param.get("selectTSecUser"))) {
            sb.append("inner join t_sec_user sc on sc.fid = a.fuserid ");
        }
        sb.append("where 1=1 ");
        Object userId = param.get("userId");
        if (null != userId) {
            sb.append(" and a.fuserid = ? ");
            paramList.add(userId);
        }
        if (null != (roleIdList = param.get("roleIdList")) && null != (roleIds = ((List)roleIdList).stream().map(String::valueOf).collect(Collectors.toList())) && !roleIds.isEmpty()) {
            String roleIdsStr = String.join((CharSequence)"','", roleIds);
            sb.append(" and a.froleid in ('").append(roleIdsStr).append("')");
        }
        if (null != (roleNumberList = param.get("roleNumberList")) && null != (roleNumbers = ((List)roleNumberList).stream().map(String::valueOf).collect(Collectors.toList())) && !roleNumbers.isEmpty()) {
            String roleNumbersStr = String.join((CharSequence)"','", roleNumbers);
            sb.append(" and b.fnumber in ('").append(roleNumbersStr).append("')");
        }
        if (null != (dimIdList = (List)param.get("dimIdList")) && !dimIdList.isEmpty() && null != (dimIds = dimIdList.stream().map(String::valueOf).collect(Collectors.toList())) && !dimIds.isEmpty()) {
            String dimIdsStr = String.join((CharSequence)"','", dimIds);
            sb.append(" and a.forgid in ('").append(dimIdsStr).append("')");
        }
        if (null != (includeSub = param.get("includeSub"))) {
            sb.append(" and a.fisincludesuborg = ? ");
            paramList.add(includeSub);
        }
        if (null != (dimTypeList = (List)param.get("dimTypeList")) && !dimTypeList.isEmpty()) {
            String dimTypeStr = String.join((CharSequence)"','", dimTypeList);
            sb.append(" and a.fdimtype in ('").append(dimTypeStr).append("')");
        }
        if (null != (appId = param.get("appId"))) {
            sb.append(" and c.fbizappid = ? ");
            paramList.add(appId);
        }
        if (null != (entityNum = param.get("entityNum"))) {
            sb.append(" and c.fentitytypeid = ? ");
            paramList.add(entityNum);
        }
        if (null != (permItemId = param.get("permItemId"))) {
            sb.append(" and c.fpermitemid = ? ");
            paramList.add(permItemId);
        }
        if (null != (orgView = param.get("orgView"))) {
            sb.append(" and os.fviewid = ? ");
            String[] suitableViewId = OrgHelper.getSuitableViewId(String.valueOf(orgView));
            paramList.add(Long.valueOf(suitableViewId[1]));
        }
        if (null != (enable = param.get("enable"))) {
            sb.append(" and b.fenable = ? ");
            paramList.add(enable);
        }
        if (null != (userEnable = param.get("userEnable"))) {
            sb.append(" and sc.fenable = ? ");
            paramList.add(userEnable);
        }
        final Set finalRoleIdSet = roleIdSet;
        final Set finalAllDimIdSet = allDimIdSet;
        final Set finalIncludesubDimIdSet = includesubDimIdSet;
        final Map finalDimIdIncludesubMap = dimIdIncludesubMap;
        final Set finalUserIdSet = userIdSet;
        final Map finalRoleUserIdSetMap = roleUserIdSetMap;
        final Set finalPermItemIdSet = permItemIdSet;
        final Map finalRoleDimIncludeSubMap = roleDimIncludeSubMap;
        DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    Boolean includeSub;
                    String froleid;
                    if (enableValidateTime) {
                        Date endTime;
                        String startTimeStr = rs.getString("fstarttime");
                        String endTimeStr = rs.getString("fendtime");
                        Date startTime = StringUtils.isEmpty((String)startTimeStr) ? null : DateUtil.toDate(startTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                        if (!PermCommonUtil.isInValidateTime(startTime, endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate(endTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss"))) continue;
                    }
                    if ("getRoleIdSet".equals(queryType)) {
                        finalRoleIdSet.add(rs.getString("froleid"));
                        continue;
                    }
                    if ("getDimIncludeSubInfo".equals(queryType)) {
                        Boolean includeSub2;
                        Long dimId = rs.getLong("forgid");
                        finalAllDimIdSet.add(dimId);
                        String includeSubStr = rs.getString("fisincludesuborg");
                        includeSubStr = StringUtils.isEmpty((String)includeSubStr) || "0".equals(includeSubStr) ? "0" : "1";
                        Boolean bl = includeSub2 = StringUtils.isEmpty((String)includeSubStr) || "0".equals(includeSubStr) ? Boolean.FALSE : Boolean.TRUE;
                        if (Boolean.TRUE.equals(includeSub2)) {
                            finalIncludesubDimIdSet.add(dimId);
                        }
                        if (null != finalDimIdIncludesubMap.get(dimId) && Boolean.TRUE.equals(finalDimIdIncludesubMap.get(dimId))) continue;
                        finalDimIdIncludesubMap.put(dimId, includeSub2);
                        continue;
                    }
                    if ("getUserIdSet".equals(queryType)) {
                        froleid = rs.getString("froleid");
                        long fuserid = rs.getLong("fuserid");
                        finalUserIdSet.add(fuserid);
                        finalRoleUserIdSetMap.computeIfAbsent(froleid, k -> new HashSet(8)).add(fuserid);
                        continue;
                    }
                    if ("getPermItemIdSet".equals(queryType)) {
                        finalPermItemIdSet.add(rs.getString("fpermitemid"));
                        continue;
                    }
                    if (!"getRoleDimIncludeSubMap".equals(queryType)) continue;
                    froleid = rs.getString("froleid");
                    Long dimId = rs.getLong("forgid");
                    String includeSubStr = rs.getString("fisincludesuborg");
                    includeSubStr = StringUtils.isEmpty((String)includeSubStr) || "0".equals(includeSubStr) ? "0" : "1";
                    Boolean bl = includeSub = StringUtils.isEmpty((String)includeSubStr) || "0".equals(includeSubStr) ? Boolean.FALSE : Boolean.TRUE;
                    if (Boolean.TRUE.equals(includeSub)) {
                        finalRoleDimIncludeSubMap.computeIfAbsent(froleid, k -> new HashMap(8)).put(dimId, includeSub);
                        continue;
                    }
                    finalRoleDimIncludeSubMap.computeIfAbsent(froleid, k -> new HashMap(8)).putIfAbsent(dimId, includeSub);
                }
                return null;
            }
        });
        return resultMap;
    }

    public static List<PermItem> getRolePlainPermItemList(String roleId, String pageId) {
        ArrayList<PermItem> itemList = new ArrayList<PermItem>(1280);
        String algoKeyPrefix = PermRoleHelper.class + ".getPlainPermItemList.";
        String sql = "select fbizappid, fentitytypeid, fpermitemid, fentryid, fid from t_perm_rolepermdetial where froleid = ?";
        try (DataSet rolePermDS = DB.queryDataSet((String)(algoKeyPrefix + "rolePermDS"), (DBRoute)DBRoute.permission, (String)sql, (Object[])new Object[]{roleId});){
            Map<String, DynamicObject> allCloudMap = AppHelper.getAllCloudMap();
            Map<String, Map<String, Object>> appInfoMap = AppHelper.getAppInfoMap(new HashMap<String, Object>(1));
            Map<String, Map<String, String>> allPermItemInfoMap = PermItemHelper.getAllPermItemInfoMap();
            Map<String, Map<String, Object>> entDesignInfoWithNumKey = FormHelper.getEntDesignInfoWithNumKey(null);
            PermItem item = null;
            while (rolePermDS.hasNext()) {
                Row row = rolePermDS.next();
                String appId = row.getString("fbizappid");
                String entNum = row.getString("fentitytypeid");
                String permItemId = row.getString("fpermitemid");
                String rolepermId = row.getString("fid");
                String rolepermDetailId = row.getString("fentryid");
                item = new PermItem();
                DynamicObject cloudObj = allCloudMap.get(appId);
                if (null != cloudObj) {
                    item.setCloudId(cloudObj.getString("bizcloud.id"));
                    item.setCloudNumber(cloudObj.getString("bizcloud.number"));
                    item.setCloudName(cloudObj.getString("bizcloud.name"));
                }
                item.setAppId(appId);
                Map<String, Object> appMap = appInfoMap.get(appId);
                if (null != appMap && !appMap.isEmpty()) {
                    item.setAppNumber((String)appMap.get("number"));
                    item.setAppName((String)appMap.get("name"));
                }
                item.setEntityNumber(entNum);
                Map<String, Object> entMap = entDesignInfoWithNumKey.get(entNum);
                if (null != entMap && !entMap.isEmpty()) {
                    item.setEntityId((String)entMap.get("id"));
                    item.setEntityName((String)entMap.get("name"));
                }
                item.setPermItemId(permItemId);
                Map<String, String> permItemInfo = allPermItemInfoMap.get(permItemId);
                if (null != permItemInfo && !permItemInfo.isEmpty()) {
                    item.setPermItemNumber(permItemInfo.get("number"));
                    item.setPermItemName(permItemInfo.get("name"));
                }
                item.setRolepermId(rolepermId);
                item.setRolepermDetailId(rolepermDetailId);
                itemList.add(item);
            }
        }
        return itemList;
    }

    public static Map<String, Object> getAllRoleNumOrNameIdSetMap() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        HashMap<String, Set> roleNumberIdSetMap = new HashMap<String, Set>(8);
        HashMap<String, Set> roleNameIdSetMap = new HashMap<String, Set>(8);
        resultMap.put("roleNumberIdSetMap", roleNumberIdSetMap);
        resultMap.put("roleNameIdSetMap", roleNameIdSetMap);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"PermRoleHelper.getAllRoleNumOrNameIdSetMap", (String)"perm_role", (String)"id, number, name", null, (String)"");){
            while (ds.hasNext()) {
                Row row = ds.next();
                String id = row.getString("id");
                String number = row.getString("number");
                String name = row.getString("name");
                roleNumberIdSetMap.computeIfAbsent(number, k -> new HashSet()).add(id);
                roleNameIdSetMap.computeIfAbsent(name, k -> new HashSet()).add(id);
            }
        }
        return resultMap;
    }

    public static Map<String, Set<ComRole>> getRoleIdOrNumOrNameComRoleMap(Set<String> idOrNumberOrNameSet, String keyType) {
        HashMap<String, Set<ComRole>> map = new HashMap<String, Set<ComRole>>(8);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("id", keyType)) {
            qFilterList.add(new QFilter("id", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("number", keyType)) {
            qFilterList.add(new QFilter("number", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("name", keyType)) {
            qFilterList.add(new QFilter("name", "in", idOrNumberOrNameSet));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"PermRoleHelper.getRoleIdOrNumOrNameComRoleMap", (String)"perm_role", (String)"id, number, name", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");){
            ComRole one = null;
            while (ds.hasNext()) {
                Row row = ds.next();
                one = new ComRole();
                String id = row.getString("id");
                String number = row.getString("number");
                String name = row.getString("name");
                one.setId(id);
                one.setNumber(number);
                one.setName(name);
                if (Objects.equals("id", keyType)) {
                    map.computeIfAbsent(id, k -> new HashSet()).add(one);
                }
                if (Objects.equals("name", keyType)) {
                    map.computeIfAbsent(name, k -> new HashSet()).add(one);
                    continue;
                }
                if (!Objects.equals("number", keyType)) continue;
                map.computeIfAbsent(number, k -> new HashSet()).add(one);
            }
        }
        return map;
    }

    public static Map<String, Object> queryRolePermMap(Set<String> roleIdSet) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        final HashMap roleRolePermFidMap = new HashMap(8);
        final HashMap roleRolePermDetailFentryidMap = new HashMap(8);
        final HashMap roleIdFuncPermMap = new HashMap(8);
        final HashMap roleIdFentryIdMap = new HashMap(8);
        map.put("roleRolePermFidMap", roleRolePermFidMap);
        map.put("roleRolePermDetailFentryidMap", roleRolePermDetailFentryidMap);
        map.put("roleIdFuncPermMap", roleIdFuncPermMap);
        map.put("roleIdFentryIdMap", roleIdFentryIdMap);
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return map;
        }
        String roleIdStr = roleIdSet.stream().collect(Collectors.joining("','"));
        StringBuilder sb = new StringBuilder();
        sb.append("select b.fid rolepermid, a.fid afroleid, ");
        sb.append(" b.fid bfid, b.fentryid bfentryid, b.fpermitemid bfpermitemid, b.fentitytypeid bfentitytypeid, b.fbizappid bfbizappid, b.froleid bfroleid ");
        sb.append(" from t_perm_role a ");
        sb.append(" left join t_perm_rolepermdetial b on a.fid = b.froleid ");
        sb.append(" where a.fid in ('").append(roleIdStr).append("') ");
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String afroleid = rs.getString("afroleid");
                    String bfbizappid = rs.getString("bfbizappid");
                    String bfentitytypeid = rs.getString("bfentitytypeid");
                    String bfpermitemid = rs.getString("bfpermitemid");
                    String bfentryid = rs.getString("bfentryid");
                    String rolepermid = rs.getString("rolepermid");
                    roleRolePermFidMap.computeIfAbsent(afroleid, k -> new HashSet(8)).add(rolepermid);
                    roleRolePermDetailFentryidMap.computeIfAbsent(afroleid + "|" + bfbizappid + "|" + bfentitytypeid + "|" + bfpermitemid, k -> new HashSet(8)).add(bfentryid);
                    roleIdFuncPermMap.computeIfAbsent(afroleid, k -> new HashSet(8)).add(bfbizappid + "|" + bfentitytypeid + "|" + bfpermitemid + "|" + bfentryid);
                    roleIdFentryIdMap.computeIfAbsent(afroleid, k -> new HashSet(8)).add(bfentryid);
                }
                return null;
            }
        });
        return map;
    }

    public static Map<String, Object> queryRoleFieldPermMap(Set<String> roleIdSet) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        final HashMap roleFieldPermFidMap = new HashMap(8);
        final HashMap fieldPermFidMap = new HashMap(8);
        final HashMap roleIdFieldPermDetailEntryIdMap = new HashMap(8);
        final HashMap fieldPermDetailEntryIdMap = new HashMap(8);
        final HashMap roleIdFieldPermMap = new HashMap(8);
        map.put("roleFieldPermFidMap", roleFieldPermFidMap);
        map.put("fieldPermFidMap", fieldPermFidMap);
        map.put("roleIdFieldPermDetailEntryIdMap", roleIdFieldPermDetailEntryIdMap);
        map.put("fieldPermDetailEntryIdMap", fieldPermDetailEntryIdMap);
        map.put("roleIdFieldPermMap", roleIdFieldPermMap);
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return map;
        }
        String roleIdStr = roleIdSet.stream().collect(Collectors.joining("','"));
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid afid, a.froleid afroleid, a.ffieldpermid affieldpermid, ");
        sb.append(" b.fid bfid, b.fnumber bfnumber, ");
        sb.append(" c.fentryid cfentryid, c.fid cfid, c.fbizappid cfbizappid, c.fentitytypeid cfentitytypeid, c.ffieldname cffieldname, c.fcontrolmode cfcontrolmode");
        sb.append(" from t_perm_rolefieldperm a  ");
        sb.append(" left join t_perm_fieldperm b on a.ffieldpermid = b.fid ");
        sb.append(" left join t_perm_fieldpermdetail c on c.fid  = b.fid ");
        sb.append(" where a.froleid in ('").append(roleIdStr).append("') ");
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String afroleid = rs.getString("afroleid");
                    String cfbizappid = rs.getString("cfbizappid");
                    String cfentitytypeid = rs.getString("cfentitytypeid");
                    String cffieldname = rs.getString("cffieldname");
                    String cfentryid = rs.getString("cfentryid");
                    String afid = rs.getString("afid");
                    String bfid = rs.getString("bfid");
                    String cfcontrolmode = rs.getString("cfcontrolmode");
                    roleFieldPermFidMap.computeIfAbsent(afroleid, k -> new HashSet()).add(afid);
                    fieldPermFidMap.computeIfAbsent(afroleid, k -> new HashSet()).add(bfid);
                    roleIdFieldPermDetailEntryIdMap.computeIfAbsent(afroleid, k -> new HashSet()).add(cfentryid);
                    fieldPermDetailEntryIdMap.computeIfAbsent(afroleid + "|" + cfbizappid + "|" + cfentitytypeid + "|" + cffieldname, k -> new HashSet()).add(cfentryid);
                    roleIdFieldPermMap.computeIfAbsent(afroleid, k -> new HashSet()).add(cfbizappid + "|" + cfentitytypeid + "|" + cffieldname + "|" + cfcontrolmode);
                }
                return null;
            }
        });
        return map;
    }

    public static Map<String, Object> queryRoleDrMap(Set<String> roleIdSet) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        final HashMap roleAppEntPermItemDrIdMap = new HashMap(8);
        map.put("roleAppEntPermItemDrIdMap", roleAppEntPermItemDrIdMap);
        boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        if (hasEnableRoleDataRuleNewModel) {
            if (null == roleIdSet || roleIdSet.isEmpty()) {
                return map;
            }
            String roleIdStr = roleIdSet.stream().collect(Collectors.joining("','"));
            StringBuilder sb = new StringBuilder();
            sb.append("select rdr.fid pkid, rdr.froleid roleid, ");
            sb.append(" rdr.fappid appid, rdr.fentitynum entitynum, rdr.fpermitemid permitemid, rdr.fdataruleid dataruleid ");
            sb.append(" from t_perm_roledatarule rdr ");
            sb.append(" where rdr.froleid in ('").append(roleIdStr).append("') ");
            DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

                public Void handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        String roleid = rs.getString("roleid");
                        String appid = rs.getString("appid");
                        String entitynum = rs.getString("entitynum");
                        String permitemid = rs.getString("permitemid");
                        Long dataruleid = rs.getLong("dataruleid");
                        roleAppEntPermItemDrIdMap.computeIfAbsent(roleid, k -> new HashSet()).add(appid + "|" + entitynum + "|" + permitemid + "|" + dataruleid);
                    }
                    return null;
                }
            });
        } else {
            final HashMap dataRule0FidMap = new HashMap(8);
            final HashMap dataRuleL0FpkidMap = new HashMap(8);
            final HashMap dataRuleEntryFentryIdMap = new HashMap(8);
            final HashMap dataRulesFidMap = new HashMap(8);
            final HashMap dataRulesLPkidMap = new HashMap(8);
            final HashMap dataRulesEntryEntryidMap = new HashMap(8);
            final HashMap roleDataRulesFidMap = new HashMap(8);
            map.put("dataRule0FidMap", dataRule0FidMap);
            map.put("dataRuleL0FpkidMap", dataRuleL0FpkidMap);
            map.put("dataRuleEntryFentryIdMap", dataRuleEntryFentryIdMap);
            map.put("dataRulesFidMap", dataRulesFidMap);
            map.put("dataRulesLPkidMap", dataRulesLPkidMap);
            map.put("dataRulesEntryEntryidMap", dataRulesEntryEntryidMap);
            map.put("roleDataRulesFidMap", roleDataRulesFidMap);
            if (null == roleIdSet || roleIdSet.isEmpty()) {
                return map;
            }
            final String langStr = RequestContext.get().getLang().name();
            String roleIdStr = roleIdSet.stream().collect(Collectors.joining("','"));
            StringBuilder sb = new StringBuilder();
            sb.append("select a.fid afid, a.fdatarulesid afdatarulesid, a.froleid afroleid, ");
            sb.append(" b.fid bfid, b.fnumber bfnumber, b.fstatus bfstatus, b.fenable bfenable, b.fname bfname, ");
            sb.append(" bL.fid bLfid, bL.flocaleid bLflocaleid, bL.fname bLfname, bL.fpkid bLfpkid, ");
            sb.append(" c.fentryid cfentryid, c.fid cfid, c.fbizappid cfbizappid, c.fentitynum cfentitynum, c.fdataruleid cfdataruleid, ");
            sb.append(" d.fid dfid, d.fnumber dfnumber, d.fbizappid dfbizappid, d.fentitynum dfentitynum, d.fisdetail dfisdetail, d.fstatus dfstatus, d.fenable dfenable, d.fname dfname, ");
            sb.append(" dL.fid dLfid, dL.flocaleid dLflocaleid, dL.fname dLfname, dL.fpkid dLfpkid, ");
            sb.append(" e.fentryid efentryid, e.fid efid, e.fpermitemid efpermitemid, e.fdataruleid efdataruleid, ");
            sb.append(" f.fid ffid ");
            sb.append(" from t_perm_roledatarules a ");
            sb.append(" left join t_perm_datarules b on a.fdatarulesid = b.fid ");
            sb.append(" left join t_perm_datarules_l bL on bL.fid = b.fid and bL.flocaleid = ? ");
            sb.append(" left join t_perm_datarules_entry c on c.fid = b.fid  ");
            sb.append(" left join t_perm_datarule d on d.fid = c.fdataruleid and d.fisdetail = '0' ");
            sb.append(" left join t_perm_datarule_l dL on dL.fid = d.fid and dL.flocaleid = ? ");
            sb.append(" left join t_perm_datarule_entry e on e.fid = d.fid ");
            sb.append(" left join t_perm_datarule f on f.fid =  e.fdataruleid and f.fisdetail ='1' ");
            sb.append(" where a.froleid in ('").append(roleIdStr).append("') ");
            DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])new Object[]{langStr, langStr}, (ResultSetHandler)new ResultSetHandler<Void>(){

                public Void handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        String afroleid = rs.getString("afroleid");
                        String dfbizappid = rs.getString("dfbizappid");
                        String dfentitynum = rs.getString("dfentitynum");
                        String efpermitemid = rs.getString("efpermitemid");
                        String dfid = rs.getString("dfid");
                        String dLfpkid = rs.getString("dLfpkid");
                        String efentryid = rs.getString("efentryid");
                        String bfid = rs.getString("bfid");
                        String bLfpkid = rs.getString("bLfpkid");
                        String cfdataruleid = rs.getString("cfdataruleid");
                        String cfentryid = rs.getString("cfentryid");
                        String afid = rs.getString("afid");
                        String efdataruleid = rs.getString("efdataruleid");
                        String ffid = rs.getString("ffid");
                        String roleAppEntStr = afroleid + "|" + dfbizappid + "|" + dfentitynum;
                        dataRule0FidMap.computeIfAbsent(roleAppEntStr, k -> new HashSet()).add(dfid);
                        dataRuleL0FpkidMap.computeIfAbsent(roleAppEntStr + "|" + langStr, k -> new HashSet()).add(dLfpkid);
                        dataRuleEntryFentryIdMap.computeIfAbsent(roleAppEntStr + "|" + efpermitemid + "|" + efdataruleid, k -> new HashSet()).add(efentryid);
                        dataRulesFidMap.computeIfAbsent(afroleid, k -> new HashSet()).add(bfid);
                        dataRulesLPkidMap.computeIfAbsent(afroleid + "|" + langStr, k -> new HashSet()).add(bLfpkid);
                        dataRulesEntryEntryidMap.computeIfAbsent(roleAppEntStr + "|" + cfdataruleid, k -> new HashSet()).add(cfentryid);
                        roleDataRulesFidMap.computeIfAbsent(afroleid, k -> new HashSet()).add(afid);
                        roleAppEntPermItemDrIdMap.computeIfAbsent(afroleid, k -> new HashSet()).add(dfbizappid + "|" + dfentitynum + "|" + efpermitemid + "|" + ffid);
                    }
                    return null;
                }
            });
        }
        return map;
    }

    public static Map<String, Object> queryRoleDrPrMap(Set<String> roleIdSet) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        final HashMap roleAppEntPropDrIdMap = new HashMap(8);
        map.put("roleAppEntPropDrIdMap", roleAppEntPropDrIdMap);
        boolean hasEnableRoleDataRuleNewModel = PermCommonUtil.hasEnableRoleDataRuleNewModel();
        if (hasEnableRoleDataRuleNewModel) {
            if (null == roleIdSet || roleIdSet.isEmpty()) {
                return map;
            }
            String roleIdStr = roleIdSet.stream().collect(Collectors.joining("','"));
            StringBuilder sb = new StringBuilder();
            sb.append("select rdrp.fid pkid, rdrp.froleid roleid, ");
            sb.append(" rdrp.fappid appid, rdrp.fentitynum entitynum, rdrp.fpropkey propkey, rdrp.fpropentnum propentnum, rdrp.fdataruleid dataruleid ");
            sb.append(" from t_perm_roledatarule_prop rdrp ");
            sb.append(" where rdrp.froleid in ('").append(roleIdStr).append("') ");
            DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

                public Void handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        String roleid = rs.getString("roleid");
                        String appid = rs.getString("appid");
                        String entitynum = rs.getString("entitynum");
                        String propkey = rs.getString("propkey");
                        Long dataruleid = rs.getLong("dataruleid");
                        roleAppEntPropDrIdMap.computeIfAbsent(roleid, k -> new HashSet()).add(appid + "|" + entitynum + "|" + propkey + "|" + dataruleid);
                    }
                    return null;
                }
            });
        } else {
            final HashMap dataRule0FidMap = new HashMap(8);
            final HashMap dataRuleL0FpkidMap = new HashMap(8);
            final HashMap dataRulePropFentryIdMap = new HashMap(8);
            final HashMap dataRulesFidMap = new HashMap(8);
            final HashMap dataRulesLPkidMap = new HashMap(8);
            final HashMap dataRulesEntryEntryidMap = new HashMap(8);
            final HashMap roleDataRulesFidMap = new HashMap(8);
            map.put("dataRule0FidMap", dataRule0FidMap);
            map.put("dataRuleL0FpkidMap", dataRuleL0FpkidMap);
            map.put("dataRulePropFentryIdMap", dataRulePropFentryIdMap);
            map.put("dataRulesFidMap", dataRulesFidMap);
            map.put("dataRulesLPkidMap", dataRulesLPkidMap);
            map.put("dataRulesEntryEntryidMap", dataRulesEntryEntryidMap);
            map.put("roleDataRulesFidMap", roleDataRulesFidMap);
            if (null == roleIdSet || roleIdSet.isEmpty()) {
                return map;
            }
            final String langStr = RequestContext.get().getLang().name();
            String roleIdStr = roleIdSet.stream().collect(Collectors.joining("','"));
            StringBuilder sb = new StringBuilder();
            sb.append("select a.fid afid, a.fdatarulesid afdatarulesid, a.froleid afroleid, ");
            sb.append(" b.fid bfid, b.fnumber bfnumber, b.fstatus bfstatus, b.fenable bfenable, b.fname bfname, ");
            sb.append(" bL.fid bLfid, bL.flocaleid bLflocaleid, bL.fname bLfname, bL.fpkid bLfpkid, ");
            sb.append(" c.fentryid cfentryid, c.fid cfid, c.fbizappid cfbizappid, c.fentitynum cfentitynum, c.fdataruleid cfdataruleid, ");
            sb.append(" d.fid dfid, d.fnumber dfnumber, d.fbizappid dfbizappid, d.fentitynum dfentitynum, d.fisdetail dfisdetail, d.fstatus dfstatus, d.fenable dfenable, d.fname dfname, ");
            sb.append(" dL.fid dLfid, dL.flocaleid dLflocaleid, dL.fname dLfname, dL.fpkid dLfpkid, ");
            sb.append(" e.fentryid efentryid, e.fid efid, e.fpropkey efpropkey, e.fpropentnum efpropentnum, e.fdataruleid efdataruleid, ");
            sb.append(" f.fid ffid ");
            sb.append(" from t_perm_roledatarules a ");
            sb.append(" left join t_perm_datarules b on a.fdatarulesid = b.fid ");
            sb.append(" left join t_perm_datarules_l bL on bL.fid = b.fid and bL.flocaleid = ? ");
            sb.append(" left join t_perm_datarules_entry c on c.fid = b.fid  ");
            sb.append(" left join t_perm_datarule d on d.fid = c.fdataruleid and d.fisdetail = '0' ");
            sb.append(" left join t_perm_datarule_l dL on dL.fid = d.fid and dL.flocaleid = ? ");
            sb.append(" left join t_perm_datarule_prop e on e.fid = d.fid ");
            sb.append(" left join t_perm_datarule f on f.fid =  e.fdataruleid and f.fisdetail ='1' ");
            sb.append(" where a.froleid in ('").append(roleIdStr).append("') ");
            DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])new Object[]{langStr, langStr}, (ResultSetHandler)new ResultSetHandler<Void>(){

                public Void handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        String afroleid = rs.getString("afroleid");
                        String dfbizappid = rs.getString("dfbizappid");
                        String dfentitynum = rs.getString("dfentitynum");
                        String efpropkey = rs.getString("efpropkey");
                        String efpropentnum = rs.getString("efpropentnum");
                        String dfid = rs.getString("dfid");
                        String dLfpkid = rs.getString("dLfpkid");
                        String efentryid = rs.getString("efentryid");
                        String bfid = rs.getString("bfid");
                        String bLfpkid = rs.getString("bLfpkid");
                        String cfdataruleid = rs.getString("cfdataruleid");
                        String cfentryid = rs.getString("cfentryid");
                        String afid = rs.getString("afid");
                        String efdataruleid = rs.getString("efdataruleid");
                        String ffid = rs.getString("ffid");
                        String roleAppEntStr = afroleid + "|" + dfbizappid + "|" + dfentitynum;
                        dataRule0FidMap.computeIfAbsent(roleAppEntStr, k -> new HashSet()).add(dfid);
                        dataRuleL0FpkidMap.computeIfAbsent(roleAppEntStr + "|" + langStr, k -> new HashSet()).add(dLfpkid);
                        dataRulePropFentryIdMap.computeIfAbsent(roleAppEntStr + "|" + efpropkey + "|" + efpropentnum + "|" + efdataruleid, k -> new HashSet()).add(efentryid);
                        dataRulesFidMap.computeIfAbsent(afroleid, k -> new HashSet()).add(bfid);
                        dataRulesLPkidMap.computeIfAbsent(afroleid + "|" + langStr, k -> new HashSet()).add(bLfpkid);
                        dataRulesEntryEntryidMap.computeIfAbsent(roleAppEntStr + "|" + cfdataruleid, k -> new HashSet()).add(cfentryid);
                        roleDataRulesFidMap.computeIfAbsent(afroleid, k -> new HashSet()).add(afid);
                        roleAppEntPropDrIdMap.computeIfAbsent(afroleid, k -> new HashSet()).add(dfbizappid + "|" + dfentitynum + "|" + efpropkey + "|" + efpropentnum + "|" + ffid);
                    }
                    return null;
                }
            });
        }
        return map;
    }

    public static Map<String, Object> queryAdmGrpMap(Set<String> roleIdSet) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        final HashMap roleIdAdminGrpMap = new HashMap(8);
        final HashMap roleAdminGrpFidMap = new HashMap(8);
        final HashMap roleIdAdmGrpId2FidMap = new HashMap(8);
        map.put("roleIdAdminGrpMap", roleIdAdminGrpMap);
        map.put("roleAdminGrpFidMap", roleAdminGrpFidMap);
        map.put("roleIdAdmGrpId2FidMap", roleIdAdmGrpId2FidMap);
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return map;
        }
        String roleIdStr = roleIdSet.stream().collect(Collectors.joining("','"));
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid afid, a.fadmingroupid afadmingroupid, a.froleid afroleid, a.fismodifiable afismodifiable ");
        sb.append(" from t_perm_admingrouprole a ");
        sb.append(" where a.froleid in ('").append(roleIdStr).append("') ");
        DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    String afid = rs.getString("afid");
                    String afadmingroupid = rs.getString("afadmingroupid");
                    String afroleid = rs.getString("afroleid");
                    String afismodifiable = rs.getString("afismodifiable");
                    roleIdAdminGrpMap.computeIfAbsent(afroleid, k -> new HashSet()).add(afadmingroupid + "|" + afismodifiable + "|" + afid);
                    roleAdminGrpFidMap.computeIfAbsent(afroleid + "|" + afadmingroupid + "|" + afismodifiable, k -> new HashSet()).add(afid);
                    roleIdAdmGrpId2FidMap.put(afroleid + "|" + afadmingroupid, afid);
                }
                return null;
            }
        });
        return map;
    }

    public static Map<String, Set<kd.bos.permission.model.perm.PermItem>> getFuncPermSetMap(Set<String> roleIdSet, Map<String, Object> rolePermMap) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return new HashMap<String, Set<kd.bos.permission.model.perm.PermItem>>(1);
        }
        if (null == rolePermMap) {
            rolePermMap = PermRoleHelper.queryRolePermMap(roleIdSet);
        }
        HashMap<String, Set<kd.bos.permission.model.perm.PermItem>> map = new HashMap<String, Set<kd.bos.permission.model.perm.PermItem>>(rolePermMap.size());
        Map roleIdFuncPermMap = (Map)rolePermMap.get("roleIdFuncPermMap");
        for (Map.Entry entry : roleIdFuncPermMap.entrySet()) {
            String froleid = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            if (null == value || value.isEmpty()) continue;
            kd.bos.permission.model.perm.PermItem item = null;
            for (String str : value) {
                String[] split = str.split("\\|");
                if (null == split || 0 == split.length || split.length < 3) continue;
                String dfbizappid = split[0];
                String dfentitynum = split[1];
                String bfpermitemid = split[2];
                if (!StringUtils.isNotEmpty((String)dfbizappid) || !StringUtils.isNotEmpty((String)dfentitynum) || !StringUtils.isNotEmpty((String)bfpermitemid) || "null".equals(bfpermitemid)) continue;
                item = new kd.bos.permission.model.perm.PermItem();
                item.setAppId(dfbizappid);
                item.setEntityNumber(dfentitynum);
                item.setPermItemId(bfpermitemid);
                map.computeIfAbsent(froleid, k -> new HashSet()).add(item);
            }
        }
        return map;
    }

    public static Map<String, Set<ComRoleFuncPerm>> getRoleFuncPermSetMap(Set<String> roleIdSet, Map<String, Object> rolePermMap) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return new HashMap<String, Set<ComRoleFuncPerm>>(1);
        }
        if (null == rolePermMap) {
            rolePermMap = PermRoleHelper.queryRolePermMap(roleIdSet);
        }
        HashMap<String, Set<ComRoleFuncPerm>> map = new HashMap<String, Set<ComRoleFuncPerm>>(rolePermMap.size());
        Map roleIdFuncPermMap = (Map)rolePermMap.get("roleIdFuncPermMap");
        for (Map.Entry entry : roleIdFuncPermMap.entrySet()) {
            String froleid = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            if (null == value || value.isEmpty()) continue;
            ComRoleFuncPerm item = null;
            for (String str : value) {
                String[] split = str.split("\\|");
                if (null == split || 0 == split.length || 4 != split.length) continue;
                String dfbizappid = split[0];
                String dfentitynum = split[1];
                String bfpermitemid = split[2];
                String bfentryid = split[3];
                if (!StringUtils.isNotEmpty((String)dfbizappid) || !StringUtils.isNotEmpty((String)dfentitynum) || !StringUtils.isNotEmpty((String)bfpermitemid) || "null".equals(bfpermitemid) || !StringUtils.isNotEmpty((String)bfentryid)) continue;
                item = new ComRoleFuncPerm();
                item.setAppId(dfbizappid);
                item.setEntityNumber(dfentitynum);
                item.setPermItemId(bfpermitemid);
                item.setEntryId(bfentryid);
                map.computeIfAbsent(froleid, k -> new HashSet()).add(item);
            }
        }
        return map;
    }

    public static Map<String, Set<FieldPerm>> getFieldPermSetMap(Set<String> roleIdSet, Map<String, Object> roleFieldPermMap) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return new HashMap<String, Set<FieldPerm>>(1);
        }
        if (null == roleFieldPermMap) {
            roleFieldPermMap = PermRoleHelper.queryRoleFieldPermMap(roleIdSet);
        }
        HashMap<String, Set<FieldPerm>> map = new HashMap<String, Set<FieldPerm>>(roleFieldPermMap.size());
        Map roleIdFieldPermMap = (Map)roleFieldPermMap.get("roleIdFieldPermMap");
        for (Map.Entry entry : roleIdFieldPermMap.entrySet()) {
            String froleid = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            if (null == value || value.isEmpty()) continue;
            FieldPerm item = null;
            for (String str : value) {
                String[] split = str.split("\\|");
                if (null == split || 0 == split.length || 4 != split.length) continue;
                String dfbizappid = split[0];
                String dfentitynum = split[1];
                String fieldName = split[2];
                String fcontrolmode = split[3];
                if (!StringUtils.isNotEmpty((String)dfbizappid) || !StringUtils.isNotEmpty((String)dfentitynum) || !StringUtils.isNotEmpty((String)fieldName) || !StringUtils.isNotEmpty((String)fcontrolmode) || "null".equals(fieldName)) continue;
                item = new FieldPerm();
                item.setAppId(dfbizappid);
                item.setEntityNumber(dfentitynum);
                item.setFieldName(fieldName);
                item.setControlMode(fcontrolmode);
                map.computeIfAbsent(froleid, k -> new HashSet()).add(item);
            }
        }
        return map;
    }

    public static Map<String, Set<FieldPermScheme>> getFpsSetMap(Set<String> roleIdSet) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return new HashMap<String, Set<FieldPermScheme>>(1);
        }
        String roleIdStr = roleIdSet.stream().collect(Collectors.joining("','"));
        StringBuilder sb = new StringBuilder();
        sb.append("select a.froleid, a.ffieldpermschemeid, a.fappid, a.fentnum, b.fsensitive");
        sb.append(" from t_perm_rolefieldscheme a");
        sb.append(" left join t_perm_fieldscheme b on b.fid = a.ffieldpermschemeid");
        sb.append(" where a.froleid in ('").append(roleIdStr).append("') ");
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Map<String, Set<FieldPermScheme>>>(){

            public Map<String, Set<FieldPermScheme>> handle(ResultSet rs) throws Exception {
                HashMap<String, Set<FieldPermScheme>> map = new HashMap<String, Set<FieldPermScheme>>(8);
                FieldPermScheme one = null;
                while (rs.next()) {
                    String froleid = rs.getString("froleid");
                    Long ffieldpermschemeid = rs.getLong("ffieldpermschemeid");
                    String fappid = rs.getString("fappid");
                    String fentnum = rs.getString("fentnum");
                    String fsensitive = rs.getString("fsensitive");
                    one = new FieldPermScheme();
                    one.setId(ffieldpermschemeid);
                    one.setAppId(fappid);
                    one.setEntityNumber(fentnum);
                    one.setSensitive(fsensitive);
                    map.computeIfAbsent(froleid, k -> new HashSet()).add(one);
                }
                return map;
            }
        });
    }

    public static Map<String, Set<NewDrPerm>> getNewDrPermSetMap(Set<String> roleIdSet, Map<String, Object> roleDrMap) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return new HashMap<String, Set<NewDrPerm>>(1);
        }
        if (null == roleDrMap) {
            roleDrMap = PermRoleHelper.queryRoleDrMap(roleIdSet);
        }
        HashMap<String, Set<NewDrPerm>> map = new HashMap<String, Set<NewDrPerm>>(roleDrMap.size());
        Map roleAppEntPermItemDrIdMap = (Map)roleDrMap.get("roleAppEntPermItemDrIdMap");
        for (Map.Entry entry : roleAppEntPermItemDrIdMap.entrySet()) {
            String froleid = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            if (null == value || value.isEmpty()) continue;
            NewDrPerm item = null;
            for (String str : value) {
                String[] split = str.split("\\|");
                if (null == split || 0 == split.length || 4 != split.length) continue;
                String dfbizappid = split[0];
                String dfentitynum = split[1];
                String efpermitemid = split[2];
                String ffid = split[3];
                if (!StringUtils.isNotEmpty((String)dfbizappid) || !StringUtils.isNotEmpty((String)dfentitynum) || !StringUtils.isNotEmpty((String)efpermitemid) || !StringUtils.isNotEmpty((String)ffid) || "null".equals(ffid)) continue;
                item = new NewDrPerm();
                item.setAppId(dfbizappid);
                item.setEntityNumber(dfentitynum);
                item.setPermItemId(efpermitemid);
                item.setDataRuleId(Long.valueOf(ffid));
                map.computeIfAbsent(froleid, k -> new HashSet()).add(item);
            }
        }
        return map;
    }

    public static Map<String, Set<NewDrPrPerm>> getNewDrPrPermSetMap(Set<String> roleIdSet, Map<String, Object> roleDrPrMap) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return new HashMap<String, Set<NewDrPrPerm>>(1);
        }
        if (null == roleDrPrMap) {
            roleDrPrMap = PermRoleHelper.queryRoleDrPrMap(roleIdSet);
        }
        HashMap<String, Set<NewDrPrPerm>> map = new HashMap<String, Set<NewDrPrPerm>>(roleDrPrMap.size());
        Map roleAppEntPropDrIdMap = (Map)roleDrPrMap.get("roleAppEntPropDrIdMap");
        for (Map.Entry entry : roleAppEntPropDrIdMap.entrySet()) {
            String froleid = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            if (null == value || value.isEmpty()) continue;
            NewDrPrPerm item = null;
            for (String str : value) {
                String[] split = str.split("\\|");
                if (null == split || 0 == split.length || 5 != split.length) continue;
                String dfbizappid = split[0];
                String dfentitynum = split[1];
                String efpropkey = split[2];
                String efpropentnum = split[3];
                String ffid = split[4];
                if (!StringUtils.isNotEmpty((String)dfbizappid) || !StringUtils.isNotEmpty((String)dfentitynum) || !StringUtils.isNotEmpty((String)efpropkey) || !StringUtils.isNotEmpty((String)efpropentnum) || !StringUtils.isNotEmpty((String)ffid) || "null".equals(ffid)) continue;
                item = new NewDrPrPerm();
                item.setAppId(dfbizappid);
                item.setEntityNumber(dfentitynum);
                item.setPropKey(efpropkey);
                item.setPropEntNum(efpropentnum);
                item.setDataRuleId(Long.valueOf(ffid));
                map.computeIfAbsent(froleid, k -> new HashSet()).add(item);
            }
        }
        return map;
    }

    public static Map<String, Set<ComRoleAdminGrp>> getComRoleAdminGrpSetMap(Set<String> roleIdSet, Map<String, Object> adminGrpMap) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return new HashMap<String, Set<ComRoleAdminGrp>>(1);
        }
        if (null == adminGrpMap) {
            adminGrpMap = PermRoleHelper.queryAdmGrpMap(roleIdSet);
        }
        HashMap<String, Set<ComRoleAdminGrp>> map = new HashMap<String, Set<ComRoleAdminGrp>>(adminGrpMap.size());
        Map roleIdAdminGrpMap = (Map)adminGrpMap.get("roleIdAdminGrpMap");
        for (Map.Entry entry : roleIdAdminGrpMap.entrySet()) {
            String froleid = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            if (null == value || value.isEmpty()) continue;
            ComRoleAdminGrp item = null;
            for (String str : value) {
                String[] split = str.split("\\|");
                if (null == split || 0 == split.length || split.length < 3) continue;
                String afadmingroupid = split[0];
                String afismodifiable = split[1];
                String afid = split[2];
                if (!StringUtils.isNotEmpty((String)afadmingroupid) || !StringUtils.isNotEmpty((String)afismodifiable)) continue;
                item = new ComRoleAdminGrp();
                item.setAdminGroupId(afadmingroupid);
                item.setRoleId(froleid);
                item.setModifiable(!StringUtils.isEmpty((String)afismodifiable) && !"0".equals(afismodifiable));
                item.setEntryId(afid);
                map.computeIfAbsent(froleid, k -> new HashSet()).add(item);
            }
        }
        return map;
    }

    public static void adminGrp2DB(List<Object[]> t_perm_admingrouprole_insertParamList, Set<String> t_perm_admingrouprole_delFIdSet) {
        if (null != t_perm_admingrouprole_insertParamList && !t_perm_admingrouprole_insertParamList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("insert into t_perm_admingrouprole (fid, fadmingroupid, froleid, fismodifiable) values");
            sb.append("(?,?,?,?)");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sb.toString(), t_perm_admingrouprole_insertParamList);
        }
        if (null != t_perm_admingrouprole_delFIdSet && !t_perm_admingrouprole_delFIdSet.isEmpty()) {
            String inStr = String.join((CharSequence)"','", t_perm_admingrouprole_delFIdSet);
            StringBuilder sb = new StringBuilder().append("delete from t_perm_admingrouprole where fid in ('").append(inStr).append("')");
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.toString());
        }
    }

    public static void DR_NewModel2DB(List<Object[]> t_perm_roledatarule_insertParamList, List<Object[]> t_perm_roledatarule_prop_insertParamList, List<Object[]> t_perm_roledatarule_delParamList, List<Object[]> t_perm_roledatarule_prop_delParamList) {
        StringBuilder insertSql;
        if (null != t_perm_roledatarule_insertParamList && !t_perm_roledatarule_insertParamList.isEmpty()) {
            insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_roledatarule ");
            insertSql.append(" (fid,froleid,fappid,fentitynum,fpermitemid,fdataruleid,fcreatorid,fcreatetime) ");
            insertSql.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), t_perm_roledatarule_insertParamList);
        }
        if (null != t_perm_roledatarule_prop_insertParamList && !t_perm_roledatarule_prop_insertParamList.isEmpty()) {
            insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_perm_roledatarule_prop ");
            insertSql.append(" (fid,froleid,fappid,fentitynum,fpropkey,fpropentnum,fdataruleid,fcreatorid,fcreatetime) ");
            insertSql.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?);");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), t_perm_roledatarule_prop_insertParamList);
        }
        if (null != t_perm_roledatarule_delParamList && !t_perm_roledatarule_delParamList.isEmpty()) {
            StringBuilder delSql = new StringBuilder();
            delSql.append("delete from t_perm_roledatarule ");
            delSql.append(" where froleid = ? and fappid = ? and fentitynum = ? and fpermitemid = ? ");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)delSql.toString(), t_perm_roledatarule_delParamList);
        }
        if (null != t_perm_roledatarule_prop_delParamList && !t_perm_roledatarule_prop_delParamList.isEmpty()) {
            insertSql = new StringBuilder();
            insertSql.append("delete from t_perm_roledatarule_prop ");
            insertSql.append(" where froleid = ? and fappid = ? and fentitynum = ? and fpropkey = ? ");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), t_perm_roledatarule_prop_delParamList);
        }
    }

    @Deprecated
    public static void DR2DB(List<Object[]> t_perm_datarule_insertParamList, List<Object[]> t_perm_dataruleL_insertParamList, List<Object[]> t_perm_datarule_entry_insertParamList, List<Object[]> t_perm_datarule_prop_insertParamList, List<Object[]> t_perm_datarules_insertParamList, List<Object[]> t_perm_datarulesL_insertParamList, List<Object[]> t_perm_datarules_entry_insertParamList, List<Object[]> t_perm_roledatarules_insertParamList, Set<String> t_perm_datarule_entry_delEntryIdSet, Set<String> t_perm_datarule_prop_delEntryIdSet) {
        StringBuilder sb;
        String inStr;
        StringBuilder sb2;
        if (null != t_perm_datarule_insertParamList && !t_perm_datarule_insertParamList.isEmpty()) {
            sb2 = new StringBuilder();
            sb2.append("insert into t_perm_datarule (fid, fmasterid, fnumber, fbizappid, fentitynum, frule, fisdetail, fcreatetime, fcreatorid, fmodifytime, fmodifierid, fstatus, fenable, fdescription, frule_tag, fname, fapplyscope, fcloudid) values ");
            sb2.append("(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sb2.toString(), t_perm_datarule_insertParamList);
        }
        if (null != t_perm_dataruleL_insertParamList && !t_perm_dataruleL_insertParamList.isEmpty()) {
            sb2 = new StringBuilder();
            sb2.append("insert into t_perm_datarule_l (fid, flocaleid, fname, fdescription, fpkid) values ");
            sb2.append("(?,?,?,?,?)");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sb2.toString(), t_perm_dataruleL_insertParamList);
        }
        if (null != t_perm_datarule_entry_insertParamList && !t_perm_datarule_entry_insertParamList.isEmpty()) {
            sb2 = new StringBuilder();
            sb2.append("insert into t_perm_datarule_entry (fentryid, fid, fseq, fpermitemid, fopkey, foptype, fdataruleid) values");
            sb2.append("(?,?,?,?,?,?,?)");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sb2.toString(), t_perm_datarule_entry_insertParamList);
        }
        if (null != t_perm_datarule_prop_insertParamList && !t_perm_datarule_prop_insertParamList.isEmpty()) {
            sb2 = new StringBuilder();
            sb2.append("insert into t_perm_datarule_prop (fid, fentryid, fpropkey, fdataruleid, fpropentnum, fseq) values");
            sb2.append("(?,?,?,?,?,?)");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sb2.toString(), t_perm_datarule_prop_insertParamList);
        }
        if (null != t_perm_datarules_insertParamList && !t_perm_datarules_insertParamList.isEmpty()) {
            sb2 = new StringBuilder();
            sb2.append("insert into t_perm_datarules (fid, fmasterid, fnumber, fstatus, fenable, fcreatetime, fcreatorid, fmodifytime, fmodifierid, fname, fdataruleid) values");
            sb2.append("(?,?,?,?,?,?,?,?,?,?,?)");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sb2.toString(), t_perm_datarules_insertParamList);
        }
        if (null != t_perm_datarulesL_insertParamList && !t_perm_datarulesL_insertParamList.isEmpty()) {
            sb2 = new StringBuilder();
            sb2.append("insert into t_perm_datarules_l (fid, flocaleid, fname, fpkid) values");
            sb2.append("(?,?,?,?)");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sb2.toString(), t_perm_datarulesL_insertParamList);
        }
        if (null != t_perm_datarules_entry_insertParamList && !t_perm_datarules_entry_insertParamList.isEmpty()) {
            sb2 = new StringBuilder();
            sb2.append("insert into t_perm_datarules_entry (fentryid, fid, fseq, fbizappid, fentitynum, fdataruleid) values");
            sb2.append("(?,?,?,?,?,?)");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sb2.toString(), t_perm_datarules_entry_insertParamList);
        }
        if (null != t_perm_roledatarules_insertParamList && !t_perm_roledatarules_insertParamList.isEmpty()) {
            sb2 = new StringBuilder();
            sb2.append("insert into t_perm_roledatarules (fid, fdatarulesid, froleid, fcreatetime, fcreatorid, fmodifytime, fmodifierid) values");
            sb2.append("(?,?,?,?,?,?,?)");
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)sb2.toString(), t_perm_roledatarules_insertParamList);
        }
        if (null != t_perm_datarule_entry_delEntryIdSet && !t_perm_datarule_entry_delEntryIdSet.isEmpty()) {
            inStr = String.join((CharSequence)"','", t_perm_datarule_entry_delEntryIdSet);
            sb = new StringBuilder().append("delete from t_perm_datarule_entry where fentryid in ('").append(inStr).append("')");
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.toString());
        }
        if (null != t_perm_datarule_prop_delEntryIdSet && !t_perm_datarule_prop_delEntryIdSet.isEmpty()) {
            inStr = String.join((CharSequence)"','", t_perm_datarule_prop_delEntryIdSet);
            sb = new StringBuilder().append("delete from t_perm_datarule_prop where fentryid in ('").append(inStr).append("')");
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.toString());
        }
    }

    public static void fieldPerm2DB(List<Object[]> t_perm_fieldperm_insertParamList, List<Object[]> t_perm_rolefieldperm_insertParamList, List<Object[]> t_perm_fieldpermdetail_insertParamList, Set<String> t_perm_fieldperm_delFIdSet, Set<String> t_perm_rolefieldperm_delFIdSet, Set<String> t_perm_fieldpermdetail_delEntryIdSet) {
        StringBuilder sb;
        String inStr;
        if (null != t_perm_fieldperm_insertParamList && !t_perm_fieldperm_insertParamList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)"insert into t_perm_fieldperm(fid, fnumber) values (?,?)", t_perm_fieldperm_insertParamList);
        }
        if (null != t_perm_rolefieldperm_insertParamList && !t_perm_rolefieldperm_insertParamList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)"insert into t_perm_rolefieldperm (fid, froleid, ffieldpermid, finheritmode) values(?,?,?, ' ')", t_perm_rolefieldperm_insertParamList);
        }
        if (null != t_perm_fieldpermdetail_insertParamList && !t_perm_fieldpermdetail_insertParamList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)"INSERT INTO t_perm_fieldpermdetail (fentryid, fid, fseq, fentitytypeid, ffieldname, fcontrolmode, fbizappid) VALUES(?, ?, ?, ?, ?, ?, ?)", t_perm_fieldpermdetail_insertParamList);
        }
        if (null != t_perm_fieldpermdetail_delEntryIdSet && !t_perm_fieldpermdetail_delEntryIdSet.isEmpty()) {
            inStr = String.join((CharSequence)"','", t_perm_fieldpermdetail_delEntryIdSet);
            sb = new StringBuilder().append("delete from t_perm_fieldpermdetail where fentryid in ('").append(inStr).append("')");
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.toString());
        }
        if (null != t_perm_fieldperm_delFIdSet && !t_perm_fieldperm_delFIdSet.isEmpty()) {
            inStr = String.join((CharSequence)"','", t_perm_fieldperm_delFIdSet);
            sb = new StringBuilder().append("delete from t_perm_fieldperm where fid in ('").append(inStr).append("')");
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.toString());
        }
        if (null != t_perm_rolefieldperm_delFIdSet && !t_perm_rolefieldperm_delFIdSet.isEmpty()) {
            inStr = String.join((CharSequence)"','", t_perm_rolefieldperm_delFIdSet);
            sb = new StringBuilder().append("delete from t_perm_rolefieldperm where fid in ('").append(inStr).append("')");
            DB.execute((DBRoute)DBRoute.basedata, (String)sb.toString());
        }
    }

    @Deprecated
    public static void funcPerm2DB(List<Object[]> t_perm_roleperm_insertParamList, List<Object[]> t_perm_rolepermdetial_insertParamList, Set<String> t_perm_rolepermdetial_delEntryIdSet) {
        PermRoleHelper.funcPerm2DB(t_perm_roleperm_insertParamList, t_perm_rolepermdetial_insertParamList, null, t_perm_rolepermdetial_delEntryIdSet, null);
    }

    /*
     * Exception decompiling
     */
    public static void funcPerm2DB(List<Object[]> t_perm_roleperm_insertParamList, List<Object[]> t_perm_rolepermdetial_insertParamList, List<Object[]> t_perm_rolepermdetial_updateParamList, Set<String> t_perm_rolepermdetial_delEntryIdSet, Set<String> t_perm_roleperm_delFidSet) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, ComRole> getComRoleBaseMap(Set<String> roleIdSet, GetComRoleListReq req) {
        ArrayList<String> paramList = new ArrayList<String>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid afid,");
        sb.append(" a.ftype aftype, a.fnumber afnumber, a.fbizdomainid afbizdomainid, ");
        sb.append(" a.fcreatetime afcreatetime, a.fcreatorid afcreatorid, a.fmodifytime afmodifytime, a.fmodifierid afmodifierid,");
        sb.append(" a.fstatus afstatus, a.fenable afenable,");
        sb.append(" a.fgroupid afgroupid, a.fissystem afissystem, a.fremark afremark, ");
        sb.append(" a.fname afname, a.fdimtypeid afdimtypeid, a.fcreateadmingrp afcreateadmingrp, a.fusescope afusescope, ");
        sb.append(" b.fname bfname ");
        sb.append(" from t_perm_role a ");
        sb.append(" left join t_perm_role_l b on a.fid = b.fid and b.flocaleid = ? ");
        paramList.add(RequestContext.get().getLang().name());
        sb.append(" where 1=1 ");
        if (null != roleIdSet && !roleIdSet.isEmpty()) {
            String roleIdStr = roleIdSet.stream().collect(Collectors.joining("','"));
            sb.append(" and a.fid in ('").append(roleIdStr).append("') ");
        }
        if (null != req) {
            String number;
            String dimTypeId;
            String name = req.getName();
            if (StringUtils.isNotEmpty((String)name)) {
                sb.append(" and b.fname like '%").append(name).append("%'");
            }
            if (StringUtils.isNotEmpty((String)(dimTypeId = req.getDimTypeId()))) {
                sb.append(" and a.fdimtypeid = ? ");
                paramList.add(dimTypeId);
            }
            if (StringUtils.isNotEmpty((String)(number = req.getNumber()))) {
                sb.append(" and a.fnumber like '%").append(number).append("%'");
            }
            boolean enable = req.isEnable();
            sb.append(" and a.fenable = ?");
            paramList.add(enable ? "1" : "0");
        }
        sb.append(" order by a.fmodifytime desc ");
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Map<String, ComRole>>(){

            public Map<String, ComRole> handle(ResultSet rs) throws Exception {
                LinkedHashMap<String, ComRole> map = new LinkedHashMap<String, ComRole>(8);
                ComRole comRole = null;
                while (rs.next()) {
                    comRole = new ComRole();
                    String afid = rs.getString("afid");
                    comRole.setId(afid);
                    comRole.setType(rs.getString("aftype"));
                    comRole.setNumber(rs.getString("afnumber"));
                    comRole.setBizDomainId(rs.getString("afbizdomainid"));
                    String afcreatetime = rs.getString("afcreatetime");
                    comRole.setCreateTime(StringUtils.isEmpty((String)afcreatetime) ? null : DateUtil.toDate(afcreatetime.substring(0, 19), "yyyy-MM-dd HH:mm:ss"));
                    comRole.setCreatorId(rs.getString("afcreatorid"));
                    String afmodifytime = rs.getString("afmodifytime");
                    comRole.setModifyTime(StringUtils.isEmpty((String)afmodifytime) ? null : DateUtil.toDate(afmodifytime.substring(0, 19), "yyyy-MM-dd HH:mm:ss"));
                    comRole.setModifierId(rs.getString("afmodifierid"));
                    comRole.setStatus(rs.getString("afstatus"));
                    String afenable = rs.getString("afenable");
                    comRole.setEnable(Boolean.valueOf(!StringUtils.isEmpty((String)afenable) && !" ".equals(afenable) && !"0".equals(afenable)));
                    comRole.setGroupId(rs.getString("afgroupid"));
                    String afissystem = rs.getString("afissystem");
                    comRole.setSystem(Boolean.valueOf(!StringUtils.isEmpty((String)afissystem) && !" ".equals(afissystem) && !"0".equals(afissystem)));
                    comRole.setRemark(rs.getString("afremark"));
                    String afname = rs.getString("afname");
                    String bfname = rs.getString("bfname");
                    comRole.setName(StringUtils.isEmpty((String)bfname) ? afname : bfname);
                    comRole.setDimTypeId(rs.getString("afdimtypeid"));
                    comRole.setCreateAdminGrp(rs.getString("afcreateadmingrp"));
                    comRole.setUseScope(rs.getString("afusescope"));
                    map.put(afid, comRole);
                }
                return map;
            }
        });
    }

    public static Map<String, Set<String>> getComRoleIdAssignedUTrueNameMap(Set<String> comRoleIdSet) {
        Map<String, List<String>> comRoleIdAssignedUTrueNameListMap = PermRoleHelper.getComRoleIdAssignedUTrueNameListMap(comRoleIdSet);
        if (null == comRoleIdAssignedUTrueNameListMap || comRoleIdAssignedUTrueNameListMap.isEmpty()) {
            return new HashMap<String, Set<String>>(0);
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
        for (Map.Entry<String, List<String>> one : comRoleIdAssignedUTrueNameListMap.entrySet()) {
            map.put(one.getKey(), new HashSet(one.getValue()));
        }
        return map;
    }

    public static Map<String, List<String>> getComRoleIdAssignedUTrueNameListMap(Set<String> comRoleIdSet) {
        return PermRoleHelper.getComRoleIdAssignedUTrueNameListMap(comRoleIdSet, null, null);
    }

    public static Map<String, List<String>> getComRoleIdAssignedUTrueNameListMap(Set<String> comRoleIdSet, Integer topN, String orderBy) {
        String langStr = RequestContext.get().getLang().toString();
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        if (null != topN && topN > 0) {
            sb.append(" top ").append(topN);
        }
        sb.append(" t.froleid,u.ftruename,ul.ftruename name_l ");
        sb.append(" from t_perm_userrole t ");
        sb.append(" inner join t_sec_user u on t.fuserid = u.fid ");
        sb.append(" left join t_sec_user_l ul on u.fid = ul.fid and ul.flocaleid = ? ");
        sb.append(" where 1=1 ");
        if (null != comRoleIdSet && !comRoleIdSet.isEmpty()) {
            String comRoleIdSetStr = String.join((CharSequence)"','", comRoleIdSet);
            sb.append(" and t.froleid in ('").append(comRoleIdSetStr).append("')");
        }
        if (StringUtils.isNotEmpty((String)orderBy)) {
            sb.append(" order by ").append(orderBy);
        }
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])new Object[]{langStr}, (ResultSetHandler)new ResultSetHandler<Map<String, List<String>>>(){

            public Map<String, List<String>> handle(ResultSet rs) throws Exception {
                HashMap<String, List<String>> map = new HashMap<String, List<String>>(8);
                while (rs.next()) {
                    String roleId = rs.getString("froleid");
                    String ftruename = rs.getString("name_l");
                    if (StringUtils.isEmpty((String)ftruename)) {
                        ftruename = rs.getString("ftruename");
                    }
                    map.computeIfAbsent(roleId, k -> new ArrayList(10)).add(ftruename);
                }
                return map;
            }
        });
    }

    public static Map<String, Set<String>> getComRoleIdAssignedUgNameMap(Set<String> comRoleIdSet) {
        Map<String, List<String>> comRoleIdAssignedUgNameListMap = PermRoleHelper.getComRoleIdAssignedUgNameListMap(comRoleIdSet);
        if (null == comRoleIdAssignedUgNameListMap || comRoleIdAssignedUgNameListMap.isEmpty()) {
            return new HashMap<String, Set<String>>(0);
        }
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
        for (Map.Entry<String, List<String>> one : comRoleIdAssignedUgNameListMap.entrySet()) {
            map.put(one.getKey(), new HashSet(one.getValue()));
        }
        return map;
    }

    public static Map<String, List<String>> getComRoleIdAssignedUgNameListMap(Set<String> comRoleIdSet) {
        String langStr = RequestContext.get().getLang().toString();
        StringBuilder sb = new StringBuilder();
        sb.append("select a.froleid , b.fname , bL.fname bLName ");
        sb.append(" from t_perm_usrgrprole a ");
        sb.append(" inner join t_sec_usergroup b on a.fusrgrpid = b.fid ");
        sb.append(" left join t_sec_usergroup_l bL on bL.fid = b.fid  and bL.flocaleid = ? ");
        sb.append(" where 1=1 ");
        if (null != comRoleIdSet && !comRoleIdSet.isEmpty()) {
            String comRoleIdSetStr = String.join((CharSequence)"','", comRoleIdSet);
            sb.append(" and a.froleid in ('").append(comRoleIdSetStr).append("')");
        }
        return (Map)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])new Object[]{langStr}, (ResultSetHandler)new ResultSetHandler<Map<String, List<String>>>(){

            public Map<String, List<String>> handle(ResultSet rs) throws Exception {
                HashMap<String, List<String>> map = new HashMap<String, List<String>>(8);
                while (rs.next()) {
                    String roleId = rs.getString("froleid");
                    String bLName = rs.getString("bLName");
                    if (StringUtils.isEmpty((String)bLName)) {
                        bLName = rs.getString("fname");
                    }
                    map.computeIfAbsent(roleId, k -> new ArrayList(10)).add(bLName);
                }
                return map;
            }
        });
    }

    public static void enableChange(ComRoleEnableChangeReq req) {
        Set roleIdSet = req.getRoleIdSet();
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return;
        }
        boolean enable = req.isEnable();
        String roleIdStr = roleIdSet.stream().collect(Collectors.joining("','"));
        StringBuilder sb = new StringBuilder();
        sb.append("update t_perm_role set fenable = ?, fmodifytime = ?, fmodifierid = ? where fid in ('").append(roleIdStr).append("') ");
        DB.execute((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])new Object[]{enable ? "1" : "0", new Date(), RequestContext.get().getCurrUserId()});
    }

    public static List<ComRole> getList(GetComRoleListReq req) {
        Map<String, ComRole> comRoleBaseMap = PermRoleHelper.getComRoleBaseMap(req.getComRoleIdSet(), req);
        Set<String> roleIdSet = comRoleBaseMap.keySet();
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Set queryRangeSet = req.getQueryRangeSet();
        boolean containsBase = queryRangeSet.contains(ComRoleContentEnum.BASE.getType());
        boolean containsFunc = queryRangeSet.contains(ComRoleContentEnum.FUNC.getType());
        boolean containsField = queryRangeSet.contains(ComRoleContentEnum.FIELD.getType());
        boolean containsNewDr = queryRangeSet.contains(ComRoleContentEnum.NEWDR.getType());
        boolean containsNewAdminGroup = queryRangeSet.contains(ComRoleContentEnum.ADMINGROUP.getType());
        Map<String, Set<kd.bos.permission.model.perm.PermItem>> funcPermSetMap = containsFunc ? PermRoleHelper.getFuncPermSetMap(roleIdSet, null) : Collections.EMPTY_MAP;
        Map<String, Set<FieldPerm>> fieldPermSetMap = containsField ? PermRoleHelper.getFieldPermSetMap(roleIdSet, null) : Collections.EMPTY_MAP;
        Map<String, Set<NewDrPerm>> newDrPermSetMap = containsNewDr ? PermRoleHelper.getNewDrPermSetMap(roleIdSet, null) : Collections.EMPTY_MAP;
        Map<String, Set<NewDrPrPerm>> newDrPrPermSetMap = containsNewDr ? PermRoleHelper.getNewDrPrPermSetMap(roleIdSet, null) : Collections.EMPTY_MAP;
        Map<String, Set<ComRoleAdminGrp>> comRoleAdminGrpSetMap = containsNewAdminGroup ? PermRoleHelper.getComRoleAdminGrpSetMap(roleIdSet, null) : Collections.EMPTY_MAP;
        ArrayList<ComRole> list = new ArrayList<ComRole>(comRoleBaseMap.size());
        ComRole one = null;
        for (Map.Entry<String, ComRole> comRoleBase : comRoleBaseMap.entrySet()) {
            String roleId = comRoleBase.getKey();
            ComRole value = comRoleBase.getValue();
            one = new ComRole();
            if (containsBase) {
                one = value;
            } else {
                one.setId(roleId);
            }
            one.setFuncPermSet(containsFunc ? funcPermSetMap.get(roleId) : null);
            one.setFieldPermSet(containsField ? fieldPermSetMap.get(roleId) : null);
            one.setNewDrPermSet(containsNewDr ? newDrPermSetMap.get(roleId) : null);
            one.setNewDrPrPermSet(containsNewDr ? newDrPrPermSetMap.get(roleId) : null);
            one.setComRoleAdminGrpSet(containsNewAdminGroup ? comRoleAdminGrpSetMap.get(roleId) : null);
            list.add(one);
        }
        return list;
    }

    public static Map<String, String> getRoleNumIdMap(Set<String> roleNumSet) {
        if (null == roleNumSet || roleNumSet.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        String roleNumSetStr = roleNumSet.stream().collect(Collectors.joining("','"));
        StringBuilder sb = new StringBuilder();
        sb.append("select fid, fnumber from t_perm_role ");
        sb.append(" where fnumber in ('").append(roleNumSetStr).append("') ");
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws Exception {
                HashMap<String, String> map = new HashMap<String, String>(8);
                while (rs.next()) {
                    map.put(rs.getString("fnumber"), rs.getString("fid"));
                }
                return map;
            }
        });
    }

    public static Map<String, Set<String>> getRoleDimTypeSetMap(Set<String> roleIdSet, boolean includeAssignedDim, boolean includeFormDim) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return new HashMap<String, Set<String>>(1);
        }
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>(roleIdSet.size());
        if (includeFormDim) {
            Map<String, Map<String, Set<Entity>>> roleDimTypeEntityMap = PermRoleHelper.getRoleDimTypeEntityMap(roleIdSet, null);
            for (Map.Entry<String, Object> entry : roleDimTypeEntityMap.entrySet()) {
                Map value = (Map)entry.getValue();
                for (Map.Entry dimTypeEntityMap : value.entrySet()) {
                    resultMap.computeIfAbsent(entry.getKey(), k -> new HashSet(8)).add(dimTypeEntityMap.getKey());
                }
            }
        }
        if (includeAssignedDim) {
            Map<String, Set<String>> roleDimTypeSetMapByAssinedDim = PermRoleHelper.getRoleDimTypeSetMapByAssinedDim(roleIdSet);
            for (Map.Entry<String, Object> entry : roleDimTypeSetMapByAssinedDim.entrySet()) {
                resultMap.computeIfAbsent(entry.getKey(), k -> new HashSet(8)).addAll((Collection)entry.getValue());
            }
        }
        return resultMap;
    }

    private static Map<String, Set<String>> getRoleDimTypeSetMapByAssinedDim(Set<String> roleIdSet) {
        return PermRoleHelper.getRoleDimTypeSetMapByAssined(roleIdSet, null);
    }

    public static Map<String, Set<String>> getRoleDimTypeSetMapByAssined(Set<String> roleIdSet, Set<Long> userIdSet) {
        if ((null == roleIdSet || roleIdSet.isEmpty()) && (null == userIdSet || userIdSet.isEmpty())) {
            return new HashMap<String, Set<String>>(1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct froleid, fdimtype from t_perm_userrole where 1=1 ");
        if (null != roleIdSet && !roleIdSet.isEmpty()) {
            String roleIdSetStr = roleIdSet.stream().collect(Collectors.joining("','"));
            sb.append(" and froleid in ('").append(roleIdSetStr).append("') ");
        }
        if (null != userIdSet && !userIdSet.isEmpty()) {
            List userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            String userIdStr = String.join((CharSequence)",", userIdList);
            sb.append(" and fuserid in (").append(userIdStr).append(")");
        }
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Map<String, Set<String>>>(){

            public Map<String, Set<String>> handle(ResultSet rs) throws Exception {
                HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
                while (rs.next()) {
                    map.computeIfAbsent(rs.getString("froleid"), k -> new HashSet(8)).add(rs.getString("fdimtype"));
                }
                return map;
            }
        });
    }

    public static Map<String, Map<String, Set<Entity>>> getRoleDimTypeEntityMap(Set<String> roleIdSet, Set<String> dimTypeSet) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return new HashMap<String, Map<String, Set<Entity>>>(0);
        }
        Map<String, Set<String>> roleEntNumSetMap = PermRoleHelper.getRoleEntNumSetMap(roleIdSet);
        Set entNumSet = roleEntNumSetMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (null == entNumSet || entNumSet.isEmpty()) {
            return new HashMap<String, Map<String, Set<Entity>>>(0);
        }
        dimTypeSet = null == dimTypeSet || dimTypeSet.isEmpty() ? new HashSet(8) : dimTypeSet;
        final boolean dimTypeSetEmpty = null == dimTypeSet || dimTypeSet.isEmpty();
        final Map<String, String> permCtrlTypeMap = IsoDimHelper.permCtrlTypeMap();
        final Map<String, DynamicObject> allCloudMap = AppHelper.getAllCloudMap();
        final Map<String, Map<String, Object>> appInfoMap = AppHelper.getAppInfoMap(new HashMap<String, Object>(1));
        final Map<String, String> entityNameMap = FormHelper.getAllEntityNameMap(RequestContext.get().getLang().name());
        final Map<String, PermissionControlType> permControlTypeMap = PermCommonUtil.getPermControlType();
        String roleIdSetStr = roleIdSet.stream().collect(Collectors.joining("','"));
        StringBuilder sb = new StringBuilder();
        sb.append("select froleid, fbizappid, fentitytypeid from t_perm_rolepermdetial ");
        sb.append(" where froleid in ('").append(roleIdSetStr).append("') ");
        sb.append(" order by fbizappid asc, fentitytypeid asc");
        final Set<String> finalDimTypeSet = dimTypeSet;
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Set<Entity>>>>(){

            public Map<String, Map<String, Set<Entity>>> handle(ResultSet rs) throws Exception {
                HashMap<String, Map<String, Set<Entity>>> map = new HashMap<String, Map<String, Set<Entity>>>(8);
                Entity one = null;
                String cloudId = "";
                String cloudNumber = "";
                String cloudName = "";
                while (rs.next()) {
                    String curDim;
                    String dimType;
                    String fbizappid = rs.getString("fbizappid");
                    String fentitytypeid = rs.getString("fentitytypeid");
                    one = new Entity();
                    DynamicObject cloudObj = (DynamicObject)allCloudMap.get(fbizappid);
                    if (null != cloudObj) {
                        cloudId = cloudObj.getString("bizcloud.id");
                        cloudNumber = cloudObj.getString("bizcloud.number");
                        cloudName = cloudObj.getString("bizcloud.name");
                    }
                    one.setCloudId(cloudId);
                    one.setCloudNumber(cloudNumber);
                    one.setCloudName(cloudName);
                    one.setAppId(fbizappid);
                    Map appMap = (Map)appInfoMap.get(fbizappid);
                    if (null != appMap && !appMap.isEmpty()) {
                        one.setAppNumber((String)appMap.get("number"));
                        one.setAppName((String)appMap.get("name"));
                    }
                    one.setEntityNumber(fentitytypeid);
                    one.setEntityName((String)entityNameMap.get(fentitytypeid));
                    PermissionControlType permissionControlType = (PermissionControlType)permControlTypeMap.get(fentitytypeid);
                    if (null == permissionControlType || null == (dimType = StringUtils.isEmpty((String)(curDim = permissionControlType.getDimension())) ? "bos_objecttype" : (String)permCtrlTypeMap.get(curDim))) continue;
                    if (dimTypeSetEmpty) {
                        map.computeIfAbsent(rs.getString("froleid"), k -> new HashMap(8)).computeIfAbsent(dimType, k -> new HashSet(8)).add(one);
                        continue;
                    }
                    if (!finalDimTypeSet.contains(dimType)) continue;
                    map.computeIfAbsent(rs.getString("froleid"), k -> new HashMap(8)).computeIfAbsent(dimType, k -> new HashSet(8)).add(one);
                }
                return map;
            }
        });
    }

    private static Map<String, Set<String>> getRoleEntNumSetMap(Set<String> roleIdSet) {
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return new HashMap<String, Set<String>>(0);
        }
        Map<String, Map<String, Set<String>>> roleAppEntIdSetMap = PermRoleHelper.getRoleAppEntIdSetMap(roleIdSet);
        if (null == roleAppEntIdSetMap || roleAppEntIdSetMap.isEmpty()) {
            return new HashMap<String, Set<String>>(0);
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(roleIdSet.size());
        for (String roleId : roleIdSet) {
            Map<String, Set<String>> map = roleAppEntIdSetMap.get(roleId);
            if (null == map || map.isEmpty()) {
                result.put(roleId, new HashSet(0));
                continue;
            }
            HashSet collect = map.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            result.put(roleId, null == collect ? new HashSet(0) : collect);
        }
        return result;
    }

    public static Map<Long, String> getGetHasPermDimObj(Map<String, Object> commParam) {
        String includeSub;
        Long dimId;
        boolean needQueryRpd;
        if (commParam == null) {
            commParam = new HashMap<String, Object>(1);
        }
        boolean bl = needQueryRpd = commParam.isEmpty() ? true : (Boolean)commParam.get("needQueryRpd");
        if (needQueryRpd) {
            Set<String> rpdRoleIdSet = PermRoleHelper.getRoleIdByAppEntPermItem(commParam);
            commParam.put("rpdRoleIdSet", rpdRoleIdSet);
        }
        Map<Long, String> userroleMap = PermRoleHelper.getGetHasPermDimObjByUserRole(commParam);
        Map<Long, String> usrgrpRoleMap = PermRoleHelper.getGetHasPermDimObjByUsrGrpRole(commParam);
        HashMap<Long, String> map = new HashMap<Long, String>(8);
        for (Map.Entry<Long, String> dimIdIncludesub : userroleMap.entrySet()) {
            dimId = dimIdIncludesub.getKey();
            includeSub = dimIdIncludesub.getValue();
            if (null != map.get(dimId) && Objects.equals("1", map.get(dimId))) continue;
            map.put(dimId, includeSub);
        }
        for (Map.Entry<Long, String> dimIdIncludesub : usrgrpRoleMap.entrySet()) {
            dimId = dimIdIncludesub.getKey();
            includeSub = dimIdIncludesub.getValue();
            if (null != map.get(dimId) && Objects.equals("1", map.get(dimId))) continue;
            map.put(dimId, includeSub);
        }
        return map;
    }

    private static Set<String> getRoleIdByAppEntPermItem(Map<String, Object> commParam) {
        ArrayList<Object> paramList = new ArrayList<Object>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct froleid from t_perm_rolepermdetial where  1=1 ");
        if (null != commParam.get("appId")) {
            sb.append(" and fbizappid = ? ");
            paramList.add(commParam.get("appId"));
        }
        if (null != commParam.get("entityNum")) {
            sb.append(" and fentitytypeid = ? ");
            paramList.add(commParam.get("entityNum"));
        }
        if (null != commParam.get("permItemId")) {
            sb.append(" and fpermitemid = ? ");
            paramList.add(commParam.get("permItemId"));
        }
        Set rpdRoleIdSet = (Set)DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> set = new HashSet<String>(8);
                while (rs.next()) {
                    set.add(rs.getString("froleid"));
                }
                return set;
            }
        });
        return rpdRoleIdSet;
    }

    private static Map<Long, String> getGetHasPermDimObjByUsrGrpRole(Map<String, Object> commParam) {
        Set dimTypeSet;
        Set rpdRoleIdSet = null;
        boolean needQueryRpd = (Boolean)commParam.get("needQueryRpd");
        if (needQueryRpd && (null == (rpdRoleIdSet = null == commParam.get("rpdRoleIdSet") ? PermRoleHelper.getRoleIdByAppEntPermItem(commParam) : (Set)commParam.get("rpdRoleIdSet")) || rpdRoleIdSet.isEmpty())) {
            return new HashMap<Long, String>(8);
        }
        ArrayList<Object> paramList = new ArrayList<Object>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.fdimid, a.fincludesub , a.fstarttime, a.fendtime ");
        sb.append(" from t_perm_usrgrprole a  ");
        sb.append(" inner join t_sec_usergroupstaff b on b.fusergroupid = a.fusrgrpid ");
        sb.append(" inner join t_perm_role c on c.fid = a.froleid ");
        sb.append(" where 1=1 ");
        if (null != commParam.get("userId")) {
            sb.append(" and b.fuserid = ? ");
            paramList.add(commParam.get("userId"));
        }
        if (null != rpdRoleIdSet && !rpdRoleIdSet.isEmpty()) {
            String rpdRoleIdSetStr = String.join((CharSequence)"','", rpdRoleIdSet);
            sb.append(" and a.froleid in ('").append(rpdRoleIdSetStr).append("')");
        }
        if (null != (dimTypeSet = (Set)commParam.get("dimTypeSet")) && !dimTypeSet.isEmpty()) {
            String dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet);
            sb.append(" and a.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        String enable = "1";
        if (null != commParam.get("enable")) {
            enable = (String)commParam.get("enable");
        }
        sb.append(" and c.fenable = ? ");
        paramList.add(enable);
        final HashMap<Long, String> map = new HashMap<Long, String>(8);
        final boolean enableValidateTime = (Boolean)commParam.get("enableValidateTime");
        DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    if (enableValidateTime) {
                        Date endTime;
                        String startTimeStr = rs.getString("fstarttime");
                        String endTimeStr = rs.getString("fendtime");
                        Date startTime = StringUtils.isEmpty((String)startTimeStr) ? null : DateUtil.toDate(startTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                        Date date = endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate(endTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                        if (!PermCommonUtil.isInValidateTime(startTime, endTime)) continue;
                    }
                    Long dimId = rs.getLong("fdimid");
                    String includeSubStr = rs.getString("fincludesub");
                    String string = includeSubStr = StringUtils.isEmpty((String)includeSubStr) || "0".equals(includeSubStr) ? "0" : "1";
                    if (null != map.get(dimId) && Objects.equals("1", map.get(dimId))) continue;
                    map.put(dimId, includeSubStr);
                }
                return null;
            }
        });
        return map;
    }

    private static Map<Long, String> getGetHasPermDimObjByUserRole(Map<String, Object> commParam) {
        Set dimTypeSet;
        Set rpdRoleIdSet = null;
        boolean needQueryRpd = (Boolean)commParam.get("needQueryRpd");
        if (needQueryRpd && (null == (rpdRoleIdSet = null == commParam.get("rpdRoleIdSet") ? PermRoleHelper.getRoleIdByAppEntPermItem(commParam) : (Set)commParam.get("rpdRoleIdSet")) || rpdRoleIdSet.isEmpty())) {
            return new HashMap<Long, String>(8);
        }
        ArrayList<Object> paramList = new ArrayList<Object>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.forgid, a.fisincludesuborg , a.fstarttime, a.fendtime ");
        sb.append(" from t_perm_userrole a ");
        sb.append(" inner join t_perm_role b on a.froleid = b.fid ");
        sb.append(" where 1=1 ");
        if (null != commParam.get("userId")) {
            sb.append(" and a.fuserid = ? ");
            paramList.add(commParam.get("userId"));
        }
        if (null != rpdRoleIdSet && !rpdRoleIdSet.isEmpty()) {
            String rpdRoleIdSetStr = String.join((CharSequence)"','", rpdRoleIdSet);
            sb.append(" and a.froleid in ('").append(rpdRoleIdSetStr).append("')");
        }
        if (null != (dimTypeSet = (Set)commParam.get("dimTypeSet")) && !dimTypeSet.isEmpty()) {
            String dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet);
            sb.append(" and a.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        String enable = "1";
        if (null != commParam.get("enable")) {
            enable = (String)commParam.get("enable");
        }
        sb.append(" and b.fenable = ? ");
        paramList.add(enable);
        final HashMap<Long, String> map = new HashMap<Long, String>(8);
        final boolean enableValidateTime = (Boolean)commParam.get("enableValidateTime");
        DB.query((DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    if (enableValidateTime) {
                        Date endTime;
                        String startTimeStr = rs.getString("fstarttime");
                        String endTimeStr = rs.getString("fendtime");
                        Date startTime = StringUtils.isEmpty((String)startTimeStr) ? null : DateUtil.toDate(startTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                        Date date = endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate(endTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                        if (!PermCommonUtil.isInValidateTime(startTime, endTime)) continue;
                    }
                    Long dimId = rs.getLong("forgid");
                    String includeSubStr = rs.getString("fisincludesuborg");
                    String string = includeSubStr = StringUtils.isEmpty((String)includeSubStr) || "0".equals(includeSubStr) ? "0" : "1";
                    if (null != map.get(dimId) && Objects.equals("1", map.get(dimId))) continue;
                    map.put(dimId, includeSubStr);
                }
                return null;
            }
        });
        return map;
    }

    public static PermLevelHash getPermLevelHash(GetPermLevelHashReq req) {
        Long userId = req.getUserId();
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getPermLevelHash");
        commParam.put("userId", userId);
        commParam.put("appId", req.getAppId());
        commParam.put("enable", "1");
        commParam.put("selectTPermRole", "1");
        commParam.put("selectTSecUserGroupStaff", "1");
        commParam.put("selectTPermRolePermDetail", "1");
        commParam.put("justPermItem", req.isJustPermItem());
        Map<String, Object> curOrgDimCommMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (CollectionUtils.isEmpty(curOrgDimCommMap)) {
            return new PermLevelHash(false, new HashMap(1));
        }
        PermLevelHash permLevelHash = (PermLevelHash)curOrgDimCommMap.get("permLevelHash");
        return null == permLevelHash ? new PermLevelHash(false, new HashMap(1)) : permLevelHash;
    }

    private static Map<String, Object> getUsrPermLevelHashMap(Map<String, Object> param) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        Object userIdObj = param.get("userId");
        Object appIdObj = param.get("appId");
        if (null == userIdObj || null == appIdObj) {
            resultMap.put("permLevelHash", new PermLevelHash(false, new HashMap(1)));
            return resultMap;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.froleid , a.fdimtype, a.forgid fdimid, a.fisincludesuborg fincludesub ");
        final boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        if (enableValidateTime) {
            sb.append(", a.fstarttime, a.fendtime ");
        }
        sb.append(" from t_perm_role b");
        sb.append(" inner join t_perm_userrole a on a.froleid = b.fid");
        sb.append(" where b.fenable ='1' ");
        ArrayList<Object> paramList = new ArrayList<Object>(10);
        Object userId = param.get("userId");
        if (null != userId) {
            sb.append(" and a.fuserid = ? ");
            paramList.add(userId);
        }
        final boolean[] hasIncludeSubArr = new boolean[]{false};
        final HashMap dimIncludeMap = new HashMap(8);
        DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(paramList.toArray(new Object[paramList.size()])), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                String value = null;
                while (rs.next()) {
                    String froleid = rs.getString("froleid");
                    String fdimtype = rs.getString("fdimtype");
                    Long fdimid = rs.getLong("fdimid");
                    String fincludesub = rs.getString("fincludesub");
                    if (StringUtils.isEmpty((String)fdimtype) || null == fdimid || Objects.equals(0L, fdimid) || StringUtils.isEmpty((String)fincludesub)) continue;
                    if (enableValidateTime) {
                        Date endTime;
                        String startTimeStr = rs.getString("fstarttime");
                        String endTimeStr = rs.getString("fendtime");
                        Date startTime = StringUtils.isEmpty((String)startTimeStr) ? null : DateUtil.toDate(startTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                        if (!PermCommonUtil.isInValidateTime(startTime, endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate(endTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss"))) continue;
                    }
                    if (Objects.equals("1", fincludesub)) {
                        hasIncludeSubArr[0] = true;
                    }
                    value = fdimtype + "@@" + fdimid + "@@" + fincludesub;
                    dimIncludeMap.computeIfAbsent(froleid, k -> new HashSet(8)).add(value);
                }
                return null;
            }
        });
        Set dimIncludeRoleIdSet = dimIncludeMap.keySet();
        if (null == dimIncludeRoleIdSet || dimIncludeRoleIdSet.isEmpty()) {
            resultMap.put("permLevelHash", new PermLevelHash(false, new HashMap(1)));
            return resultMap;
        }
        sb.setLength(0);
        sb.append("select distinct d.fbizappid, d.fentitytypeid, d.fpermitemid, d.froleid ");
        sb.append(" from t_perm_rolepermdetial d ");
        sb.append(" where 1=1");
        paramList.clear();
        String appId = (String)appIdObj;
        if (StringUtils.isNotEmpty((String)appId)) {
            sb.append(" and d.fbizappid = ? ");
            paramList.add(appId);
        }
        final HashMap roleFunMap = new HashMap(8);
        DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                String value = null;
                while (rs.next()) {
                    String froleid = rs.getString("froleid");
                    String appId = rs.getString("fbizappid");
                    String entNum = rs.getString("fentitytypeid");
                    String permItemID = rs.getString("fpermitemid");
                    if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entNum) || StringUtils.isEmpty((String)permItemID)) continue;
                    value = appId + "@@" + entNum + "@@" + permItemID;
                    roleFunMap.computeIfAbsent(froleid, k -> new HashSet(8)).add(value);
                }
                return null;
            }
        });
        Set roleFunRoleIdSet = roleFunMap.keySet();
        if (null == roleFunRoleIdSet || roleFunRoleIdSet.isEmpty()) {
            resultMap.put("permLevelHash", new PermLevelHash(false, new HashMap(1)));
            return resultMap;
        }
        Sets.SetView roleIdSet = Sets.intersection(dimIncludeRoleIdSet, roleFunRoleIdSet);
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            resultMap.put("permLevelHash", new PermLevelHash(false, new HashMap(1)));
            return resultMap;
        }
        HashMap<String, Set> funcDimMap = new HashMap<String, Set>(8);
        for (String roleId : roleIdSet) {
            Set roleFunSet;
            Set dimIncludeSet = (Set)dimIncludeMap.get(roleId);
            if (null == dimIncludeSet || dimIncludeSet.isEmpty() || null == (roleFunSet = (Set)roleFunMap.get(roleId)) || roleFunSet.isEmpty()) continue;
            for (String roleFun : roleFunSet) {
                funcDimMap.computeIfAbsent(roleFun, k -> new HashSet(8)).addAll(dimIncludeSet);
            }
        }
        boolean hasIncludeSub = hasIncludeSubArr[0];
        resultMap.put("permLevelHash", new PermLevelHash(hasIncludeSub, funcDimMap));
        return resultMap;
    }

    private static Map<String, Object> getUsrGrpPermLevelHashMap(Map<String, Object> param) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        Object userIdObj = param.get("userId");
        Object appIdObj = param.get("appId");
        if (null == userIdObj || null == appIdObj) {
            resultMap.put("permLevelHash", new PermLevelHash(false, new HashMap(1)));
            return resultMap;
        }
        Long userId = (Long)userIdObj;
        Set<Long> usrGrpIdSet = UserHelper.getUsrGrpId(userId);
        if (null == usrGrpIdSet || usrGrpIdSet.isEmpty()) {
            resultMap.put("permLevelHash", new PermLevelHash(false, new HashMap(1)));
            return resultMap;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct a.froleid , a.fdimtype, a.fdimid, a.fincludesub ");
        final boolean enableValidateTime = PermCommonUtil.isEnableValidateTime();
        if (enableValidateTime) {
            sb.append(", a.fstarttime, a.fendtime ");
        }
        sb.append(" from t_perm_role b");
        sb.append(" inner join t_perm_usrgrprole a on a.froleid = b.fid");
        sb.append(" where b.fenable ='1' ");
        List usrGrpIdList = usrGrpIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String usrGrpIdStr = String.join((CharSequence)",", usrGrpIdList);
        sb.append(" and a.fusrgrpid in(").append(usrGrpIdStr).append(')');
        final boolean[] hasIncludeSubArr = new boolean[]{false};
        final HashMap dimIncludeMap = new HashMap(8);
        DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                String value = null;
                while (rs.next()) {
                    String froleid = rs.getString("froleid");
                    String fdimtype = rs.getString("fdimtype");
                    Long fdimid = rs.getLong("fdimid");
                    String fincludesub = rs.getString("fincludesub");
                    if (StringUtils.isEmpty((String)fdimtype) || null == fdimid || Objects.equals(0L, fdimid) || StringUtils.isEmpty((String)fincludesub)) continue;
                    if (enableValidateTime) {
                        Date endTime;
                        String startTimeStr = rs.getString("fstarttime");
                        String endTimeStr = rs.getString("fendtime");
                        Date startTime = StringUtils.isEmpty((String)startTimeStr) ? null : DateUtil.toDate(startTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                        if (!PermCommonUtil.isInValidateTime(startTime, endTime = StringUtils.isEmpty((String)endTimeStr) ? null : DateUtil.toDate(endTimeStr.substring(0, 19), "yyyy-MM-dd HH:mm:ss"))) continue;
                    }
                    if (Objects.equals("1", fincludesub)) {
                        hasIncludeSubArr[0] = true;
                    }
                    value = fdimtype + "@@" + fdimid + "@@" + fincludesub;
                    dimIncludeMap.computeIfAbsent(froleid, k -> new HashSet(8)).add(value);
                }
                return null;
            }
        });
        Set dimIncludeRoleIdSet = dimIncludeMap.keySet();
        if (null == dimIncludeRoleIdSet || dimIncludeRoleIdSet.isEmpty()) {
            resultMap.put("permLevelHash", new PermLevelHash(false, new HashMap(1)));
            return resultMap;
        }
        sb.setLength(0);
        ArrayList<String> paramList = new ArrayList<String>(6);
        sb.append("select distinct d.fbizappid, d.fentitytypeid, d.fpermitemid, d.froleid ");
        sb.append(" from t_perm_rolepermdetial d ");
        sb.append(" where 1=1");
        String appId = (String)appIdObj;
        if (StringUtils.isNotEmpty((String)appId)) {
            sb.append(" and d.fbizappid = ? ");
            paramList.add(appId);
        }
        final HashMap roleFunMap = new HashMap(8);
        DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                String value = null;
                while (rs.next()) {
                    String froleid = rs.getString("froleid");
                    String appId = rs.getString("fbizappid");
                    String entNum = rs.getString("fentitytypeid");
                    String permItemID = rs.getString("fpermitemid");
                    if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entNum) || StringUtils.isEmpty((String)permItemID)) continue;
                    value = appId + "@@" + entNum + "@@" + permItemID;
                    roleFunMap.computeIfAbsent(froleid, k -> new HashSet(8)).add(value);
                }
                return null;
            }
        });
        Set roleFunRoleIdSet = roleFunMap.keySet();
        if (null == roleFunRoleIdSet || roleFunRoleIdSet.isEmpty()) {
            resultMap.put("permLevelHash", new PermLevelHash(false, new HashMap(1)));
            return resultMap;
        }
        Sets.SetView roleIdSet = Sets.intersection(dimIncludeRoleIdSet, roleFunRoleIdSet);
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            resultMap.put("permLevelHash", new PermLevelHash(false, new HashMap(1)));
            return resultMap;
        }
        HashMap<String, Set> funcDimMap = new HashMap<String, Set>(8);
        for (String roleId : roleIdSet) {
            Set roleFunSet;
            Set dimIncludeSet = (Set)dimIncludeMap.get(roleId);
            if (null == dimIncludeSet || dimIncludeSet.isEmpty() || null == (roleFunSet = (Set)roleFunMap.get(roleId)) || roleFunSet.isEmpty()) continue;
            for (String roleFun : roleFunSet) {
                funcDimMap.computeIfAbsent(roleFun, k -> new HashSet(8)).addAll(dimIncludeSet);
            }
        }
        boolean hasIncludeSub = hasIncludeSubArr[0];
        resultMap.put("permLevelHash", new PermLevelHash(hasIncludeSub, funcDimMap));
        return resultMap;
    }

    private static DataSet getFieldPermSchemeDataSet(ComRoleFieldPermSchemeReq req) {
        Set sensitiveSet;
        Set enableSet;
        Set fieldFromSet;
        Set entNumSet;
        Set roleIdSet = req.getRoleIdSet();
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return null;
        }
        ArrayList<String> paramList = new ArrayList<String>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.froleid, a.fappid, a.fentnum, ");
        sb.append(" b.fid, b.fnumber, b.fname bName, b.ffieldfrom, b.fsensitive, b.fcontrolfieldtype, b.fcontrolmode, b.fenable, b.fdesc, ");
        sb.append(" b.fcreatorid, b.fcreatetime, b.fmodifierid, b.fmodifytime, ");
        sb.append(" c.fname cName ");
        sb.append(" from t_perm_rolefieldscheme a ");
        sb.append(" inner join t_perm_fieldscheme b on b.fid = a.ffieldpermschemeid  ");
        sb.append(" inner join t_perm_fieldscheme_l c on c.fid = b.fid and c.flocaleid = ? ");
        String roleIdSetStr = String.join((CharSequence)"','", roleIdSet);
        sb.append(" where a.froleid in ('").append(roleIdSetStr).append("')");
        Set appIdSet = req.getAppIdSet();
        if (null != appIdSet && !appIdSet.isEmpty()) {
            String appIdSetStr = String.join((CharSequence)"','", appIdSet);
            sb.append(" and a.fappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entNumSet = req.getEntNumSet()) && !entNumSet.isEmpty()) {
            String entNumSetStr = String.join((CharSequence)"','", entNumSet);
            sb.append(" and a.fentnum in ('").append(entNumSetStr).append("')");
        }
        if (null != (fieldFromSet = req.getFieldFromSet()) && !fieldFromSet.isEmpty()) {
            String fieldFromSetStr = String.join((CharSequence)"','", fieldFromSet);
            sb.append(" and b.ffieldfrom in ('").append(fieldFromSetStr).append("')");
        }
        if (null != (enableSet = req.getEnableSet()) && !enableSet.isEmpty()) {
            String enableSetStr = String.join((CharSequence)"','", enableSet);
            sb.append(" and b.fenable in ('").append(enableSetStr).append("')");
        }
        if (null != (sensitiveSet = req.getSensitiveSet()) && !sensitiveSet.isEmpty()) {
            String sensitiveSetStr = String.join((CharSequence)"','", sensitiveSet);
            sb.append(" and b.fsensitive in ('").append(sensitiveSetStr).append("')");
        }
        sb.append(" ORDER BY b.fnumber desc ");
        paramList.add(RequestContext.get().getLang().name());
        return DB.queryDataSet((String)"PermRoleHelper.getFieldPermSchemeDataSet", (DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));
    }

    public static Map<String, Set<String>> getEntAppIdFpsIdSetMap(ComRoleFieldPermSchemeReq req) {
        try (DataSet ds = PermRoleHelper.getFieldPermSchemeDataSet(req);){
            if (null == ds) {
                HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>(1);
                return hashMap;
            }
            HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
            while (ds.hasNext()) {
                Row row = ds.next();
                String fentnum = row.getString("fentnum");
                String fappid = row.getString("fappid");
                Long fpsId = row.getLong("fid");
                map.computeIfAbsent(fentnum + "@" + fappid, k -> new LinkedHashSet(8)).add(String.valueOf(fpsId));
            }
            HashMap<String, Set<String>> hashMap = map;
            return hashMap;
        }
    }

    public static Map<Long, Set<ComRoleFieldPermScheme>> getFpsComRoleMap(Set<Long> fpdIdSet) {
        if (null == fpdIdSet || fpdIdSet.isEmpty()) {
            return new HashMap<Long, Set<ComRoleFieldPermScheme>>(1);
        }
        HashMap<Long, Set<ComRoleFieldPermScheme>> map = new HashMap<Long, Set<ComRoleFieldPermScheme>>(8);
        ArrayList<String> paramList = new ArrayList<String>(8);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.froleid, a.ffieldpermschemeid, b.fnumber fpsNumber, c.fnumber roleNum, c.fname cName, cL.fname cLName ");
        sb.append(" from t_perm_rolefieldscheme a ");
        sb.append(" inner join t_perm_fieldscheme b on b.fid = a.ffieldpermschemeid ");
        sb.append(" inner join t_perm_role c on c.fid = a.froleid ");
        sb.append(" inner join t_perm_role_l cL on cL.fid = c.fid and cL.flocaleid=? ");
        Set collect = fpdIdSet.stream().map(String::valueOf).collect(Collectors.toSet());
        String fpdIdSetStr = String.join((CharSequence)",", collect);
        sb.append(" where a.ffieldpermschemeid in (").append(fpdIdSetStr).append(")");
        paramList.add(RequestContext.get().getLang().name());
        try (DataSet dataSet = DB.queryDataSet((String)"PermRoleHelper.getFpsComRoleIdSetMap", (DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));){
            ComRoleFieldPermScheme one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                one = new ComRoleFieldPermScheme();
                one.setRoleId(row.getString("froleid"));
                one.setRoleNumber(row.getString("roleNum"));
                String cName = row.getString("cName");
                String cLName = row.getString("cLName");
                one.setRoleName(StringUtils.isEmpty((String)cLName) ? cName : cLName);
                one.setNumber(row.getString("fpsNumber"));
                map.computeIfAbsent(row.getLong("ffieldpermschemeid"), k -> new HashSet(8)).add(one);
            }
        }
        return map;
    }

    public static GetUserDimFieldPermResp getUserDimFieldPermResp(final GetUserDimFieldPermReq req, final Map<String, Map<String, Set<String>>> entItemClassFieldMap) {
        final String classMethodStr = "PermRoleHelper.getUserDimFieldPermResp";
        try {
            Set userIdSet = req.getUserIdSet();
            if (PermCommonUtil.isEnableSingleBizRole() && null != userIdSet && !userIdSet.isEmpty() && Objects.equals(1, userIdSet.size())) {
                String selBizRoleId = UserBizRoleCache.getSelBizRole((Long)new ArrayList(userIdSet).get(0));
                req.setSingleBizRoleId(Long.valueOf(StringUtils.isEmpty((String)selBizRoleId) ? 0L : Long.parseLong(selBizRoleId)));
            }
            ArrayList<Future> futureList = new ArrayList<Future>(12);
            final CountDownLatch countDownLatch = new CountDownLatch(12);
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return PermRoleHelper.getUserDimFieldPermRespCall(PermRoleHelper.userBizComRoleFieldTypeFps(req, entItemClassFieldMap), classMethodStr + ".userBizComRoleFieldTypeFps.call error.", countDownLatch);
                }
            }));
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return PermRoleHelper.getUserDimFieldPermRespCall(PermRoleHelper.userComRoleFieldTypeFps(req, entItemClassFieldMap), classMethodStr + ".userComRoleFieldTypeFps.call error.", countDownLatch);
                }
            }));
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return PermRoleHelper.getUserDimFieldPermRespCall(PermRoleHelper.usrGrpBizComRoleFieldTypeFps(req, entItemClassFieldMap), classMethodStr + ".usrGrpBizComRoleFieldTypeFps.call error.", countDownLatch);
                }
            }));
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return PermRoleHelper.getUserDimFieldPermRespCall(PermRoleHelper.usrGrpComRoleFieldTypeFps(req, entItemClassFieldMap), classMethodStr + ".usrGrpComRoleFieldTypeFps.call error.", countDownLatch);
                }
            }));
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return PermRoleHelper.getUserDimFieldPermRespCall(PermRoleHelper.userBizComRoleFieldFps(req), classMethodStr + ".userBizComRoleFieldFps.call error.", countDownLatch);
                }
            }));
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return PermRoleHelper.getUserDimFieldPermRespCall(PermRoleHelper.userComRoleFieldFps(req), classMethodStr + ".userComRoleFieldFps.call error.", countDownLatch);
                }
            }));
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return PermRoleHelper.getUserDimFieldPermRespCall(PermRoleHelper.usrGrpBizComRoleFieldFps(req), classMethodStr + ".usrGrpBizComRoleFieldFps.call error.", countDownLatch);
                }
            }));
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return PermRoleHelper.getUserDimFieldPermRespCall(PermRoleHelper.usrGrpComRoleFieldFps(req), classMethodStr + ".usrGrpComRoleFieldFps.call error.", countDownLatch);
                }
            }));
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return PermRoleHelper.getUserDimFieldPermRespCall(PermRoleHelper.userBizComRoleMx(req), classMethodStr + ".userBizComRoleMx.call error.", countDownLatch);
                }
            }));
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return PermRoleHelper.getUserDimFieldPermRespCall(PermRoleHelper.userComRoleMx(req), classMethodStr + ".userComRoleMx.call error.", countDownLatch);
                }
            }));
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return PermRoleHelper.getUserDimFieldPermRespCall(PermRoleHelper.usrGrpBizComRoleMx(req), classMethodStr + ".usrGrpBizComRoleMx.call error.", countDownLatch);
                }
            }));
            futureList.add(fieldPermPool.submit((Callable)new Callable<GetUserDimFieldPermResp>(){

                @Override
                public GetUserDimFieldPermResp call() throws Exception {
                    return PermRoleHelper.getUserDimFieldPermRespCall(PermRoleHelper.usrGrpComRoleMx(req), classMethodStr + ".usrGrpComRoleMx.call error.", countDownLatch);
                }
            }));
            countDownLatch.await();
            Integer returnType = req.getReturnType();
            GetUserDimFieldPermResp resp = new GetUserDimFieldPermResp();
            HashSet finalUdfpSet = new HashSet(8);
            for (int i = 0; i < futureList.size(); ++i) {
                try {
                    Future future = (Future)futureList.get(i);
                    GetUserDimFieldPermResp part = (GetUserDimFieldPermResp)future.get();
                    if (null == part) continue;
                    Set partUdfpSet = part.getUdfpSet();
                    if (!Objects.equals(1, returnType) || null == partUdfpSet || partUdfpSet.isEmpty()) continue;
                    finalUdfpSet.addAll(partUdfpSet);
                    continue;
                }
                catch (Exception e) {
                    logger.warn("{}.futureList.for error", (Object)classMethodStr, (Object)e);
                }
            }
            resp.setUdfpSet(finalUdfpSet);
            return resp;
        }
        catch (Exception e) {
            logger.warn("{} error", (Object)classMethodStr, (Object)e);
            return new GetUserDimFieldPermResp();
        }
    }

    private static GetUserDimFieldPermResp getUserDimFieldPermRespCall(GetUserDimFieldPermResp req, String errorMsg, CountDownLatch countDownLatch) {
        try {
            GetUserDimFieldPermResp getUserDimFieldPermResp = req;
            return getUserDimFieldPermResp;
        }
        catch (Exception e) {
            logger.warn(errorMsg, (Throwable)e);
            throw e;
        }
        finally {
            if (null != countDownLatch) {
                countDownLatch.countDown();
            }
        }
    }

    private static GetUserDimFieldPermResp usrGrpComRoleMx(GetUserDimFieldPermReq req) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        ArrayList<Object> paramList = new ArrayList<Object>(3);
        StringBuilder sb = new StringBuilder();
        sb.append("select ugs.fuserid, fpd.fbizappid fappid, fpd.fentitytypeid fentnum, ugr.fdimtype, ugr.fdimid,  ugr.fincludesub, fpd.ffieldname, fpd.fcontrolmode");
        sb.append(" from t_perm_usrgrprole ugr");
        sb.append(" inner join t_sec_usergroupstaff ugs on ugr.fusrgrpid = ugs.fusergroupid");
        sb.append(" inner join t_perm_rolefieldperm rfp on rfp.froleid = ugr.froleid");
        sb.append(" inner join t_perm_fieldpermdetail fpd on fpd.fid = rfp.ffieldpermid");
        sb.append(" inner join t_perm_role kk on kk.fid = ugr.froleid and kk.fenable='1' ");
        sb.append(" where 1=1 ");
        Set userIdSet = req.getUserIdSet();
        if (null != userIdSet && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and ugs.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and fpd.fbizappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and fpd.fentitytypeid in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and ugr.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and ugr.fdimid in (").append(dimIdListStr).append(")");
        }
        return PermRoleHelper.wrapUserDimFieldPermResult(req, "PermRoleHelper.usrGrpComRoleMx", sb, paramList);
    }

    private static GetUserDimFieldPermResp usrGrpBizComRoleMx(GetUserDimFieldPermReq req) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        Set userIdSet;
        ArrayList<Object> paramList = new ArrayList<Object>(3);
        StringBuilder sb = new StringBuilder();
        sb.append("select ugs.fuserid, fpd.fbizappid fappid, fpd.fentitytypeid fentnum, bo.fdimtype, bo.forgid fdimid, bo.fisincludesuborg fincludesub, fpd.ffieldname , fpd.fcontrolmode");
        sb.append(" from t_perm_usrgrpbizrole ugb");
        sb.append(" inner join t_sec_usergroupstaff ugs on ugb.fusrgrpid = ugs.fusergroupid");
        sb.append(" inner join t_perm_bizroleorg bo on ugb.fbizroleid = bo.fid");
        sb.append(" inner join t_perm_bizrolecomrole bcr on bcr.fid = ugb.fbizroleid");
        sb.append(" inner join t_perm_rolefieldperm rfp on rfp.froleid = bcr.froleid");
        sb.append(" inner join t_perm_fieldpermdetail fpd on fpd.fid = rfp.ffieldpermid");
        sb.append(" inner join t_perm_role kk on kk.fid = bcr.froleid and kk.fenable='1' ");
        sb.append(" where 1=1 ");
        Long singleBizRoleId = req.getSingleBizRoleId();
        if (null != singleBizRoleId && singleBizRoleId > 0L) {
            sb.append(" and ugb.fbizroleid = ? ");
            paramList.add(singleBizRoleId);
        }
        if (null != (userIdSet = req.getUserIdSet()) && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and ugs.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and fpd.fbizappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and fpd.fentitytypeid in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and bo.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and bo.forgid in (").append(dimIdListStr).append(")");
        }
        return PermRoleHelper.wrapUserDimFieldPermResult(req, "PermRoleHelper.usrGrpBizComRoleMx", sb, paramList);
    }

    private static GetUserDimFieldPermResp userComRoleMx(GetUserDimFieldPermReq req) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        ArrayList<Object> paramList = new ArrayList<Object>(3);
        StringBuilder sb = new StringBuilder();
        sb.append("select ur.fuserid, fpd.fbizappid fappid, fpd.fentitytypeid fentnum, ur.fdimtype, ur.forgid fdimid, ur.fisincludesuborg fincludesub, fpd.ffieldname, fpd.fcontrolmode");
        sb.append(" from t_perm_userrole ur");
        sb.append(" inner join t_perm_rolefieldperm rfp on rfp.froleid = ur.froleid");
        sb.append(" inner join t_perm_fieldpermdetail fpd on fpd.fid = rfp.ffieldpermid");
        sb.append(" inner join t_perm_role kk on kk.fid = ur.froleid and kk.fenable='1' ");
        sb.append(" where 1=1 ");
        Set userIdSet = req.getUserIdSet();
        if (null != userIdSet && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and ur.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and fpd.fbizappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and fpd.fentitytypeid in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and ur.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and ur.forgid in (").append(dimIdListStr).append(")");
        }
        return PermRoleHelper.wrapUserDimFieldPermResult(req, "PermRoleHelper.userComRoleMx", sb, paramList);
    }

    private static GetUserDimFieldPermResp userBizComRoleMx(GetUserDimFieldPermReq req) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        Set userIdSet;
        ArrayList<Object> paramList = new ArrayList<Object>(3);
        StringBuilder sb = new StringBuilder();
        sb.append("select ubr.fuserid, fpd.fbizappid fappid, fpd.fentitytypeid fentnum, bo.fdimtype, bo.forgid fdimid, bo.fisincludesuborg fincludesub, fpd.ffieldname, fpd.fcontrolmode");
        sb.append(" from t_perm_userbizrole ubr");
        sb.append(" inner join t_perm_bizroleorg bo on ubr.fbizroleid = bo.fid");
        sb.append(" inner join t_perm_bizrolecomrole bcr on bcr.fid = ubr.fbizroleid");
        sb.append(" inner join t_perm_rolefieldperm rfp on rfp.froleid = bcr.froleid");
        sb.append(" inner join t_perm_fieldpermdetail fpd on fpd.fid = rfp.ffieldpermid");
        sb.append(" inner join t_perm_role kk on kk.fid = bcr.froleid and kk.fenable='1' ");
        sb.append(" where 1=1 ");
        Long singleBizRoleId = req.getSingleBizRoleId();
        if (null != singleBizRoleId && singleBizRoleId > 0L) {
            sb.append(" and ubr.fbizroleid = ? ");
            paramList.add(singleBizRoleId);
        }
        if (null != (userIdSet = req.getUserIdSet()) && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and ubr.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and fpd.fbizappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and fpd.fentitytypeid in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and bo.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and bo.forgid in (").append(dimIdListStr).append(")");
        }
        return PermRoleHelper.wrapUserDimFieldPermResult(req, "PermRoleHelper.userBizComRoleMx", sb, paramList);
    }

    private static GetUserDimFieldPermResp usrGrpComRoleFieldFps(GetUserDimFieldPermReq req) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        ArrayList<Object> paramList = new ArrayList<Object>(4);
        StringBuilder sb = new StringBuilder();
        sb.append("select b.fuserid, d.fappid, d.fentnum, a.fdimtype, a.fdimid fdimid, a.fincludesub fincludesub, f.ffieldname, f.fcontrolmode ");
        sb.append(" from t_perm_usrgrprole a");
        sb.append(" inner join t_sec_usergroupstaff b on a.fusrgrpid = b.fusergroupid");
        sb.append(" inner join t_perm_rolefieldscheme d on d.froleid = a.froleid");
        sb.append(" inner join t_perm_fieldscheme e on e.fid = d.ffieldpermschemeid");
        sb.append(" inner join t_perm_fieldschemed f on f.fid = e.fid");
        sb.append(" inner join t_perm_role kk on kk.fid = a.froleid and kk.fenable='1' ");
        sb.append(" where e.ffieldfrom = ? and e.fenable = ? ");
        paramList.add("2");
        paramList.add("1");
        Set userIdSet = req.getUserIdSet();
        if (null != userIdSet && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and b.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and d.fappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and d.fentnum in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and a.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and a.fdimid in (").append(dimIdListStr).append(")");
        }
        return PermRoleHelper.wrapUserDimFieldPermResult(req, "PermRoleHelper.usrGrpComRoleFieldFps", sb, paramList);
    }

    private static GetUserDimFieldPermResp usrGrpBizComRoleFieldFps(GetUserDimFieldPermReq req) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        Set userIdSet;
        ArrayList<Object> paramList = new ArrayList<Object>(4);
        StringBuilder sb = new StringBuilder();
        sb.append("select b.fuserid, d.fappid, d.fentnum, c.fdimtype, c.forgid fdimid, c.fisincludesuborg fincludesub, f.ffieldname, f.fcontrolmode");
        sb.append(" from t_perm_usrgrpbizrole a");
        sb.append(" inner join t_sec_usergroupstaff b on a.fusrgrpid = b.fusergroupid");
        sb.append(" inner join t_perm_bizroleorg c on a.fbizroleid = c.fid");
        sb.append(" inner join t_perm_bizrolecomrole bcr on bcr.fid = a.fbizroleid");
        sb.append(" inner join t_perm_rolefieldscheme d on d.froleid = bcr.froleid");
        sb.append(" inner join t_perm_fieldscheme e on e.fid = d.ffieldpermschemeid");
        sb.append(" inner join t_perm_fieldschemed f on f.fid = e.fid");
        sb.append(" inner join t_perm_role kk on kk.fid = bcr.froleid and kk.fenable='1' ");
        sb.append(" where e.ffieldfrom = ? and e.fenable = ? ");
        paramList.add("2");
        paramList.add("1");
        Long singleBizRoleId = req.getSingleBizRoleId();
        if (null != singleBizRoleId && singleBizRoleId > 0L) {
            sb.append(" and a.fbizroleid = ? ");
            paramList.add(singleBizRoleId);
        }
        if (null != (userIdSet = req.getUserIdSet()) && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and b.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and d.fappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and d.fentnum in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and c.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and c.forgid in (").append(dimIdListStr).append(")");
        }
        return PermRoleHelper.wrapUserDimFieldPermResult(req, "PermRoleHelper.usrGrpBizComRoleFieldFps", sb, paramList);
    }

    private static GetUserDimFieldPermResp userComRoleFieldFps(GetUserDimFieldPermReq req) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        ArrayList<Object> paramList = new ArrayList<Object>(4);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fuserid, d.fappid, d.fentnum, a.fdimtype, a.forgid fdimid, a.fisincludesuborg fincludesub, f.ffieldname, f.fcontrolmode");
        sb.append(" from t_perm_userrole a ");
        sb.append(" inner join t_perm_rolefieldscheme d on d.froleid = a.froleid");
        sb.append(" inner join t_perm_fieldscheme e on e.fid = d.ffieldpermschemeid");
        sb.append(" inner join t_perm_fieldschemed f on f.fid = e.fid");
        sb.append(" inner join t_perm_role kk on kk.fid = a.froleid and kk.fenable='1' ");
        sb.append(" where e.ffieldfrom = ? and e.fenable = ? ");
        paramList.add("2");
        paramList.add("1");
        Set userIdSet = req.getUserIdSet();
        if (null != userIdSet && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and a.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and d.fappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and d.fentnum in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and a.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and a.forgid in (").append(dimIdListStr).append(")");
        }
        return PermRoleHelper.wrapUserDimFieldPermResult(req, "PermRoleHelper.userComRoleFieldFps", sb, paramList);
    }

    private static GetUserDimFieldPermResp userBizComRoleFieldFps(GetUserDimFieldPermReq req) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        Set userIdSet;
        ArrayList<Object> paramList = new ArrayList<Object>(4);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fuserid, d.fappid, d.fentnum, b.fdimtype, b.forgid fdimid, b.fisincludesuborg fincludesub, f.ffieldname, f.fcontrolmode");
        sb.append(" from t_perm_userbizrole a");
        sb.append(" inner join t_perm_bizroleorg b on a.fbizroleid = b.fid");
        sb.append(" inner join t_perm_bizrolecomrole c on c.fid = a.fbizroleid");
        sb.append(" inner join t_perm_rolefieldscheme d on d.froleid = c.froleid");
        sb.append(" inner join t_perm_fieldscheme e on e.fid = d.ffieldpermschemeid");
        sb.append(" inner join t_perm_fieldschemed f on f.fid = e.fid");
        sb.append(" inner join t_perm_role kk on kk.fid = c.froleid and kk.fenable='1' ");
        sb.append(" where e.ffieldfrom = ? and e.fenable = ? ");
        paramList.add("2");
        paramList.add("1");
        Long singleBizRoleId = req.getSingleBizRoleId();
        if (null != singleBizRoleId && singleBizRoleId > 0L) {
            sb.append(" and a.fbizroleid = ? ");
            paramList.add(singleBizRoleId);
        }
        if (null != (userIdSet = req.getUserIdSet()) && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and a.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and d.fappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and d.fentnum in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and b.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and b.forgid in (").append(dimIdListStr).append(")");
        }
        return PermRoleHelper.wrapUserDimFieldPermResult(req, "PermRoleHelper.userBizComRoleFieldFps", sb, paramList);
    }

    private static GetUserDimFieldPermResp wrapUserDimFieldPermResult(GetUserDimFieldPermReq req, String algoKey, StringBuilder sb, List<Object> paramList) {
        GetUserDimFieldPermResp response = new GetUserDimFieldPermResp();
        try {
            HashSet<UserDimFieldPerm> udfpSet = null;
            Integer returnType = req.getReturnType();
            if (Objects.equals(1, returnType)) {
                udfpSet = new HashSet<UserDimFieldPerm>(8);
            }
            try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()])).distinct();){
                UserDimFieldPerm one = null;
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Long fuserid = row.getLong("fuserid");
                    String fappid = row.getString("fappid");
                    String fentnum = row.getString("fentnum");
                    String fdimtype = row.getString("fdimtype");
                    Long fdimid = row.getLong("fdimid");
                    String fincludesub = row.getString("fincludesub");
                    Boolean includeSub = StringUtils.isNotEmpty((String)fincludesub) && Objects.equals("1", fincludesub) ? Boolean.TRUE : Boolean.FALSE;
                    String ffieldname = row.getString("ffieldname");
                    String fcontrolmode = row.getString("fcontrolmode");
                    if (!Objects.equals(1, returnType)) continue;
                    one = new UserDimFieldPerm();
                    one.setUserId(fuserid);
                    one.setAppId(fappid);
                    one.setEntityNumber(fentnum);
                    one.setDimType(fdimtype);
                    one.setDimId(fdimid);
                    one.setIncludeSub(includeSub);
                    one.setFieldName(ffieldname);
                    one.setControlMode(fcontrolmode);
                    udfpSet.add(one);
                }
            }
            if (Objects.equals(1, returnType)) {
                response.setUdfpSet(udfpSet);
            }
        }
        catch (Exception e) {
            logger.warn("PermRoleHelper.wrapUserDimFieldPermResult error", (Throwable)e);
        }
        return response;
    }

    private static GetUserDimFieldPermResp usrGrpComRoleFieldTypeFps(GetUserDimFieldPermReq req, Map<String, Map<String, Set<String>>> entItemClassFieldMap) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        ArrayList<Object> paramList = new ArrayList<Object>(4);
        StringBuilder sb = new StringBuilder();
        sb.append("select b.fuserid, d.fappid, d.fentnum, a.fdimtype, a.fdimid,  a.fincludesub, e.fcontrolfieldtype, e.fcontrolmode");
        sb.append(" from t_perm_usrgrprole a");
        sb.append(" inner join t_sec_usergroupstaff b on a.fusrgrpid = b.fusergroupid");
        sb.append(" inner join t_perm_rolefieldscheme d on d.froleid = a.froleid");
        sb.append(" inner join t_perm_fieldscheme e on e.fid = d.ffieldpermschemeid");
        sb.append(" inner join t_perm_role kk on kk.fid = a.froleid and kk.fenable='1' ");
        sb.append(" where e.ffieldfrom = ? and e.fenable = ? ");
        paramList.add("1");
        paramList.add("1");
        Set userIdSet = req.getUserIdSet();
        if (null != userIdSet && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and b.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and d.fappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and d.fentnum in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and a.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and a.fdimid in (").append(dimIdListStr).append(")");
        }
        return PermRoleHelper.wrapUserDimFieldPermResultWithFieldType("PermRoleHelper.usrGrpComRoleFieldTypeFps", req, paramList, sb, entItemClassFieldMap);
    }

    private static GetUserDimFieldPermResp usrGrpBizComRoleFieldTypeFps(GetUserDimFieldPermReq req, Map<String, Map<String, Set<String>>> entItemClassFieldMap) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        Set userIdSet;
        ArrayList<Object> paramList = new ArrayList<Object>(4);
        StringBuilder sb = new StringBuilder();
        sb.append("select b.fuserid, d.fappid, d.fentnum, c.fdimtype, c.forgid fdimid, c.fisincludesuborg fincludesub, e.fcontrolfieldtype, e.fcontrolmode");
        sb.append(" from t_perm_usrgrpbizrole a");
        sb.append(" inner join t_sec_usergroupstaff b on a.fusrgrpid = b.fusergroupid");
        sb.append(" inner join t_perm_bizroleorg c on a.fbizroleid = c.fid");
        sb.append(" inner join t_perm_bizrolecomrole bcr on bcr.fid = a.fbizroleid");
        sb.append(" inner join t_perm_rolefieldscheme d on d.froleid = bcr.froleid");
        sb.append(" inner join t_perm_fieldscheme e on e.fid = d.ffieldpermschemeid");
        sb.append(" inner join t_perm_role kk on kk.fid = bcr.froleid and kk.fenable='1' ");
        sb.append(" where e.ffieldfrom = ? and e.fenable = ? ");
        paramList.add("1");
        paramList.add("1");
        Long singleBizRoleId = req.getSingleBizRoleId();
        if (null != singleBizRoleId && singleBizRoleId > 0L) {
            sb.append(" and a.fbizroleid = ? ");
            paramList.add(singleBizRoleId);
        }
        if (null != (userIdSet = req.getUserIdSet()) && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and b.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and d.fappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and d.fentnum in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and c.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and c.forgid in (").append(dimIdListStr).append(")");
        }
        return PermRoleHelper.wrapUserDimFieldPermResultWithFieldType("PermRoleHelper.usrGrpBizComRoleFieldTypeFps", req, paramList, sb, entItemClassFieldMap);
    }

    private static GetUserDimFieldPermResp userComRoleFieldTypeFps(GetUserDimFieldPermReq req, Map<String, Map<String, Set<String>>> entItemClassFieldMap) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        ArrayList<Object> paramList = new ArrayList<Object>(4);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fuserid, d.fappid, d.fentnum, a.fdimtype, a.forgid fdimid, a.fisincludesuborg fincludesub, e.fcontrolfieldtype, e.fcontrolmode");
        sb.append(" from t_perm_userrole a");
        sb.append(" inner join t_perm_rolefieldscheme d on d.froleid = a.froleid");
        sb.append(" inner join t_perm_fieldscheme e on e.fid = d.ffieldpermschemeid");
        sb.append(" inner join t_perm_role kk on kk.fid = a.froleid and kk.fenable='1' ");
        sb.append(" where e.ffieldfrom = ? and e.fenable = ? ");
        paramList.add("1");
        paramList.add("1");
        Set userIdSet = req.getUserIdSet();
        if (null != userIdSet && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and a.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and d.fappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and d.fentnum in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and a.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and a.forgid in (").append(dimIdListStr).append(")");
        }
        return PermRoleHelper.wrapUserDimFieldPermResultWithFieldType("PermRoleHelper.userComRoleFieldTypeFps", req, paramList, sb, entItemClassFieldMap);
    }

    private static GetUserDimFieldPermResp userBizComRoleFieldTypeFps(GetUserDimFieldPermReq req, Map<String, Map<String, Set<String>>> entItemClassFieldMap) {
        List dimIdList;
        String dimIdListStr;
        Set dimIdSet;
        String dimTypeSetStr;
        Set dimTypeSet;
        String entityNumSetStr;
        Set entityNumSet;
        String appIdSetStr;
        Set appIdSet;
        List userIdList;
        String userIdStr;
        Set userIdSet;
        ArrayList<Object> paramList = new ArrayList<Object>(4);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fuserid, d.fappid, d.fentnum, b.fdimtype, b.forgid fdimid, b.fisincludesuborg fincludesub, e.fcontrolfieldtype, e.fcontrolmode");
        sb.append(" from t_perm_userbizrole a");
        sb.append(" inner join t_perm_bizroleorg b on a.fbizroleid = b.fid");
        sb.append(" inner join t_perm_bizrolecomrole c on c.fid = a.fbizroleid");
        sb.append(" inner join t_perm_rolefieldscheme d on d.froleid = c.froleid");
        sb.append(" inner join t_perm_fieldscheme e on e.fid = d.ffieldpermschemeid");
        sb.append(" inner join t_perm_role kk on kk.fid = c.froleid and kk.fenable='1' ");
        sb.append(" where e.ffieldfrom = ? and e.fenable = ? ");
        paramList.add("1");
        paramList.add("1");
        Long singleBizRoleId = req.getSingleBizRoleId();
        if (null != singleBizRoleId && singleBizRoleId > 0L) {
            sb.append(" and a.fbizroleid = ? ");
            paramList.add(singleBizRoleId);
        }
        if (null != (userIdSet = req.getUserIdSet()) && !userIdSet.isEmpty() && StringUtils.isNotEmpty((String)(userIdStr = String.join((CharSequence)",", userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and a.fuserid in (").append(userIdStr).append(")");
        }
        if (null != (appIdSet = req.getAppIdSet()) && !appIdSet.isEmpty() && StringUtils.isNotEmpty((String)(appIdSetStr = String.join((CharSequence)"','", appIdSet)))) {
            sb.append(" and d.fappid in ('").append(appIdSetStr).append("')");
        }
        if (null != (entityNumSet = req.getEntityNumSet()) && !entityNumSet.isEmpty() && StringUtils.isNotEmpty((String)(entityNumSetStr = String.join((CharSequence)"','", entityNumSet)))) {
            sb.append(" and d.fentnum in ('").append(entityNumSetStr).append("')");
        }
        if (null != (dimTypeSet = req.getDimTypeSet()) && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet)))) {
            sb.append(" and b.fdimtype in ('").append(dimTypeSetStr).append("')");
        }
        if (null != (dimIdSet = req.getDimIdSet()) && !dimIdSet.isEmpty() && StringUtils.isNotEmpty((String)(dimIdListStr = String.join((CharSequence)",", dimIdList = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList()))))) {
            sb.append(" and b.forgid in (").append(dimIdListStr).append(")");
        }
        return PermRoleHelper.wrapUserDimFieldPermResultWithFieldType("PermRoleHelper.userBizComRoleFieldTypeFps", req, paramList, sb, entItemClassFieldMap);
    }

    private static GetUserDimFieldPermResp wrapUserDimFieldPermResultWithFieldType(String algoKey, GetUserDimFieldPermReq req, List<Object> paramList, StringBuilder sb, Map<String, Map<String, Set<String>>> entItemClassFieldMap) {
        GetUserDimFieldPermResp response = new GetUserDimFieldPermResp();
        try {
            HashSet<UserDimFieldPerm> udfpSet = null;
            UserDimFieldPerm one = null;
            Integer returnType = req.getReturnType();
            if (Objects.equals(1, returnType)) {
                udfpSet = new HashSet<UserDimFieldPerm>(8);
            }
            Set entityNumSet = req.getEntityNumSet();
            try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()])).distinct();
                 DataSet copy = ds.copy();){
                String fcontrolfieldtype;
                String fentnum;
                String fappid;
                Row row;
                while (copy.hasNext()) {
                    row = copy.next();
                    fappid = row.getString("fappid");
                    fentnum = row.getString("fentnum");
                    fcontrolfieldtype = row.getString("fcontrolfieldtype");
                    if (StringUtils.isEmpty((String)fcontrolfieldtype) || StringUtils.isEmpty((String)fentnum) || StringUtils.isEmpty((String)fappid)) continue;
                    if (!CollectionUtils.isEmpty(entItemClassFieldMap) || CollectionUtils.isEmpty((Collection)entityNumSet)) break;
                    entItemClassFieldMap.putAll(FormHelper.getEntityItemClassFieldMap(entityNumSet));
                    break;
                }
                while (ds.hasNext()) {
                    Set<String> fieldNameSet;
                    Map<String, Set<String>> entityItemClassFieldMap;
                    row = ds.next();
                    fappid = row.getString("fappid");
                    fentnum = row.getString("fentnum");
                    fcontrolfieldtype = row.getString("fcontrolfieldtype");
                    if (StringUtils.isEmpty((String)fcontrolfieldtype) || StringUtils.isEmpty((String)fentnum) || StringUtils.isEmpty((String)fappid) || null == (entityItemClassFieldMap = entItemClassFieldMap.get(fentnum)) || entityItemClassFieldMap.isEmpty() || !entityItemClassFieldMap.containsKey(fcontrolfieldtype) || CollectionUtils.isEmpty(fieldNameSet = entityItemClassFieldMap.get(fcontrolfieldtype))) continue;
                    Long fuserid = row.getLong("fuserid");
                    String fdimtype = row.getString("fdimtype");
                    Long fdimid = row.getLong("fdimid");
                    String fincludesub = row.getString("fincludesub");
                    Boolean includeSub = StringUtils.isNotEmpty((String)fincludesub) && Objects.equals("1", fincludesub) ? Boolean.TRUE : Boolean.FALSE;
                    String fcontrolmode = row.getString("fcontrolmode");
                    for (String fieldName : fieldNameSet) {
                        if (!Objects.equals(1, returnType)) continue;
                        one = new UserDimFieldPerm();
                        one.setUserId(fuserid);
                        one.setAppId(fappid);
                        one.setEntityNumber(fentnum);
                        one.setDimType(fdimtype);
                        one.setDimId(fdimid);
                        one.setIncludeSub(includeSub);
                        one.setFieldName(fieldName);
                        one.setControlMode(fcontrolmode);
                        udfpSet.add(one);
                    }
                }
                if (Objects.equals(1, returnType)) {
                    response.setUdfpSet(udfpSet);
                }
            }
        }
        catch (Exception e) {
            logger.warn("PermRoleHelper.wrapUserDimFieldPermResultWithFieldType error", (Throwable)e);
        }
        return response;
    }

    public static Map<String, String> getRoleIdRolePermIdMap(Set<String> roleIdSet) {
        DynamicObjectCollection doc;
        if (null == roleIdSet || roleIdSet.isEmpty()) {
            return new HashMap<String, String>(1);
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != roleIdSet && !roleIdSet.isEmpty()) {
            qFilterList.add(new QFilter("roleid", "in", roleIdSet));
        }
        if (CollectionUtils.isEmpty((Collection)(doc = QueryServiceHelper.query((String)"perm_roleperm", (String)"id, roleid", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]))))) {
            return new HashMap<String, String>(1);
        }
        HashMap<String, String> map = new HashMap<String, String>(doc.size());
        for (DynamicObject dyn : doc) {
            String rolepermId = dyn.getString("id");
            String roleid = dyn.getString("roleid");
            String exist = (String)map.get(roleid);
            if (StringUtils.isNotEmpty((String)exist)) {
                throw new KDBizException("rolepermId is more than one.");
            }
            map.put(roleid, rolepermId);
        }
        return map;
    }

    public static Map<String, Set<ComRoleAdminGrp>> getAdmGrpSetMap(Set<String> roleIdOrNumberSet, final String keyType) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid, a.fnumber, b.fid entryId, b.fadmingroupid ,b.fismodifiable, c.fnumber admGroupNum  ", new Object[0]);
        sqlBuilder.append(" from t_perm_role a ", new Object[0]);
        sqlBuilder.append(" inner join t_perm_admingrouprole b on a.fid = b.froleid ", new Object[0]);
        sqlBuilder.append("  inner join t_perm_admingroup c on c.fid = b.fadmingroupid ", new Object[0]);
        sqlBuilder.append(" where 1=1 ", new Object[0]);
        if (null != roleIdOrNumberSet && !roleIdOrNumberSet.isEmpty() && Objects.equals("id", keyType)) {
            sqlBuilder.appendIn(" and a.fid", roleIdOrNumberSet.toArray());
        }
        if (null != roleIdOrNumberSet && !roleIdOrNumberSet.isEmpty() && Objects.equals("number", keyType)) {
            sqlBuilder.appendIn(" and a.fnumber", roleIdOrNumberSet.toArray());
        }
        return (Map)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<String, Set<ComRoleAdminGrp>>>(){

            public Map<String, Set<ComRoleAdminGrp>> handle(ResultSet rs) throws SQLException {
                HashMap<String, Set<ComRoleAdminGrp>> map = new HashMap<String, Set<ComRoleAdminGrp>>(8);
                ComRoleAdminGrp one = null;
                while (rs.next()) {
                    one = new ComRoleAdminGrp();
                    one.setEntryId(rs.getString("entryId"));
                    String roleId = rs.getString("fid");
                    one.setRoleId(roleId);
                    String roleNum = rs.getString("fnumber");
                    one.setRoleNumber(roleNum);
                    one.setAdminGroupId(rs.getString("fadmingroupid"));
                    one.setAdminGroupNumber(rs.getString("admGroupNum"));
                    one.setModifiable(rs.getBoolean("fismodifiable"));
                    if (Objects.equals("id", keyType)) {
                        map.computeIfAbsent(roleId, k -> new HashSet()).add(one);
                        continue;
                    }
                    if (!Objects.equals("number", keyType)) continue;
                    map.computeIfAbsent(roleNum, k -> new HashSet()).add(one);
                }
                return map;
            }
        });
    }

    public static Map<String, Set<ComRoleFuncPerm>> getRolePermSetMap(Set<String> roleIdOrNumberSet, final String keyType) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid, a.fnumber, b.fentryid, b.fbizappid, b.fentitytypeid, b.fpermitemid  ", new Object[0]);
        sqlBuilder.append(" from t_perm_role a ", new Object[0]);
        sqlBuilder.append(" inner join t_perm_rolepermdetial b on a.fid = b.froleid ", new Object[0]);
        sqlBuilder.append(" where 1=1 ", new Object[0]);
        if (null != roleIdOrNumberSet && !roleIdOrNumberSet.isEmpty() && Objects.equals("id", keyType)) {
            sqlBuilder.appendIn(" and a.fid", roleIdOrNumberSet.toArray());
        }
        if (null != roleIdOrNumberSet && !roleIdOrNumberSet.isEmpty() && Objects.equals("number", keyType)) {
            sqlBuilder.appendIn(" and a.fnumber", roleIdOrNumberSet.toArray());
        }
        final HashMap<String, Set<ComRoleFuncPerm>> map = new HashMap<String, Set<ComRoleFuncPerm>>(8);
        final HashSet<String> appIdSet = new HashSet<String>(8);
        final HashSet<String> permItemIdSet = new HashSet<String>(8);
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Map<String, Set<ComRoleFuncPerm>>>(){

            public Map<String, Set<ComRoleFuncPerm>> handle(ResultSet rs) throws SQLException {
                ComRoleFuncPerm one = null;
                while (rs.next()) {
                    one = new ComRoleFuncPerm();
                    String roleNum = rs.getString("fnumber");
                    one.setRoleNumber(roleNum);
                    one.setEntryId(rs.getString("fentryid"));
                    String fbizappid = rs.getString("fbizappid");
                    one.setAppId(fbizappid);
                    one.setEntityNumber(rs.getString("fentitytypeid"));
                    String fpermitemid = rs.getString("fpermitemid");
                    one.setPermItemId(fpermitemid);
                    if (Objects.equals("id", keyType)) {
                        map.computeIfAbsent(rs.getString("fid"), k -> new HashSet()).add(one);
                    } else if (Objects.equals("number", keyType)) {
                        map.computeIfAbsent(roleNum, k -> new HashSet()).add(one);
                    }
                    appIdSet.add(fbizappid);
                    permItemIdSet.add(fpermitemid);
                }
                return map;
            }
        });
        if (null == map || map.isEmpty()) {
            return map;
        }
        Map<String, App> appMap = AppHelper.getAppMap(appIdSet);
        Map<String, kd.bos.permission.model.perm.PermItem> permItemMap = PermItemHelper.getPermItemMap(permItemIdSet);
        for (Map.Entry one : map.entrySet()) {
            Set value = (Set)one.getValue();
            if (null == value || value.isEmpty()) continue;
            for (ComRoleFuncPerm funcPerm : value) {
                String permItemId;
                kd.bos.permission.model.perm.PermItem permItem;
                String appId = funcPerm.getAppId();
                App app = appMap.get(appId);
                if (null != app) {
                    funcPerm.setAppNumber(app.getAppNumber());
                }
                if (null == (permItem = permItemMap.get(permItemId = funcPerm.getPermItemId()))) continue;
                funcPerm.setPermItemNumber(permItem.getPermItemNumber());
            }
        }
        return map;
    }

    private static /* synthetic */ Object[] lambda$funcPerm2DB$27(String x) {
        return new Object[]{x};
    }
}

