/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.OrgUserHelper;
import kd.bos.permission.cache.helper.PermBusiRoleHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.callable.GetUserIdsByGroupIds;
import kd.bos.permission.cache.model.UgRoleDim;
import kd.bos.permission.cache.model.log.UsrGrpUser;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.perm.usrgrp.UsrGrp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UserGroupHelper {
    private static Log logger = LogFactory.getLog(UserGroupHelper.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Perm_UserGroupHelper_Pool", (int)2);

    public static Set<Long> getUserListBySet(Set<Long> userGroupIdSet) {
        if (CollectionUtils.isEmpty(userGroupIdSet)) {
            return new HashSet<Long>(1);
        }
        HashSet<Long> set = null;
        try {
            int size = userGroupIdSet.size();
            int m = SqlUtil.getBatchCount(PermHelperConst.SQL_IN_QUERY_NUM, size);
            ArrayList<Future> futureList = new ArrayList<Future>(m);
            ArrayList<Long> userGroupdIdList = new ArrayList<Long>(userGroupIdSet);
            List<List<Long>> listAvg = ListUtil.averageAssign(userGroupdIdList, m);
            for (int i = 0; i < listAvg.size(); ++i) {
                List<Long> userGroupdIds = listAvg.get(i);
                Future oneList = pool.submit((Callable)new GetUserIdsByGroupIds(new HashSet<Long>(userGroupdIds)));
                futureList.add(oneList);
            }
            set = new HashSet<Long>(size);
            for (Future listFuture : futureList) {
                set.addAll((Collection)listFuture.get());
            }
            return set;
        }
        catch (Exception e) {
            logger.warn("UserGroupHelper.getUserListBySet error", (Throwable)e);
            return new HashSet<Long>(1);
        }
    }

    public static List<Long> getUserIdsByGroupIds(final Set<Long> userGroupdIdSet) {
        if (CollectionUtils.isEmpty(userGroupdIdSet)) {
            return new ArrayList<Long>(1);
        }
        List userGroupIdList = userGroupdIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String userGroupIdStr = String.join((CharSequence)",", userGroupIdList);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fuserid");
        sb.append(" from t_sec_usergroupstaff a");
        sb.append(" where a.fusergroupid in (").append(userGroupIdStr).append(")");
        return (List)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> innerList = new ArrayList<Long>(userGroupdIdSet.size());
                while (rs.next()) {
                    innerList.add(rs.getLong("fuserid"));
                }
                return innerList;
            }
        });
    }

    public static Set<UsrGrpUser> getUsrGrpUserList(Set<Long> usrGrpIdSet, Set<Long> userIdSet) {
        Map usrGrpUserMap;
        if ((null == usrGrpIdSet || usrGrpIdSet.isEmpty()) && (null == userIdSet || userIdSet.isEmpty())) {
            return new HashSet<UsrGrpUser>(1);
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        if (null != usrGrpIdSet && !usrGrpIdSet.isEmpty()) {
            qFilterList.add(new QFilter("usergroup", "in", usrGrpIdSet));
        }
        if (null != userIdSet && !userIdSet.isEmpty()) {
            qFilterList.add(new QFilter("user", "in", userIdSet));
        }
        if (null == (usrGrpUserMap = BusinessDataServiceHelper.loadFromCache((String)"bos_usergroupstaff", (String)"usergroup_id, user_id, from_type", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]))) || usrGrpUserMap.isEmpty()) {
            return new HashSet<UsrGrpUser>(1);
        }
        HashSet<UsrGrpUser> result = new HashSet<UsrGrpUser>(usrGrpUserMap.size());
        UsrGrpUser usrGrpUser = null;
        for (Map.Entry entry : usrGrpUserMap.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            if (null == value) continue;
            usrGrpUser = new UsrGrpUser();
            usrGrpUser.setUsrGrpId(value.getLong("usergroup_id"));
            usrGrpUser.setUserId(value.getLong("user_id"));
            usrGrpUser.setFromType(value.getString("from_type"));
            result.add(usrGrpUser);
        }
        return result;
    }

    public static Map<Long, UsrGrpUser> getUsrGrpInfoMapByIds(Set<Long> usrGrpIdSet) {
        if (null == usrGrpIdSet || usrGrpIdSet.isEmpty()) {
            return new HashMap<Long, UsrGrpUser>(1);
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        if (null != usrGrpIdSet && !usrGrpIdSet.isEmpty()) {
            qFilterList.add(new QFilter("id", "in", usrGrpIdSet));
        }
        StringBuilder selectProp = new StringBuilder();
        selectProp.append("id");
        selectProp.append(", ").append("name");
        selectProp.append(", ").append("number");
        selectProp.append(", usrgrpstd_id");
        selectProp.append(", usrgrpstd");
        Map usrGrpUserMap = BusinessDataServiceHelper.loadFromCache((String)"bos_usrgrp", (String)selectProp.toString(), (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]));
        if (null == usrGrpUserMap || usrGrpUserMap.isEmpty()) {
            return new HashMap<Long, UsrGrpUser>(1);
        }
        HashMap<Long, UsrGrpUser> result = new HashMap<Long, UsrGrpUser>(usrGrpUserMap.size());
        UsrGrpUser usrGrpUser = null;
        for (Map.Entry entry : usrGrpUserMap.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            if (null == value) continue;
            usrGrpUser = new UsrGrpUser();
            long usrGrpId = value.getLong("id");
            usrGrpUser.setUsrGrpId(usrGrpId);
            usrGrpUser.setUsrGrpName(value.getString("name"));
            usrGrpUser.setUsrGrpNumber(value.getString("number"));
            usrGrpUser.setUsrGrpStdId(value.getLong("usrgrpstd_id"));
            DynamicObject usrgrpstd = value.getDynamicObject("usrgrpstd");
            if (null != usrgrpstd) {
                usrGrpUser.setUsrGrpStdDesc(usrgrpstd.getString("name"));
            }
            result.put(usrGrpId, usrGrpUser);
        }
        return result;
    }

    public static List<UgRoleDim> getUsrGrpRoleList(Set<String> roleIdSet, Set<String> includeSubSet, Set<Long> usrGrpIdSet, Set<Long> dimIdSet, String dimType) {
        return UserGroupHelper.getUsrGrpRoleList(roleIdSet, includeSubSet, usrGrpIdSet, dimIdSet, Sets.newHashSet((Object[])new String[]{dimType}));
    }

    public static List<UgRoleDim> getUsrGrpRoleList(Set<String> roleIdSet, Set<String> includeSubSet, Set<Long> usrGrpIdSet, Set<Long> dimIdSet, Set<String> dimTypeSet) {
        String inStr;
        boolean isOrgDim = false;
        if (null != dimTypeSet && !dimTypeSet.isEmpty() && Objects.equals(1, dimTypeSet.size()) && StringUtils.isNotEmpty((String)((String)dimTypeSet.stream().findFirst().get()))) {
            isOrgDim = IsoDimHelper.checkOrgDim((String)dimTypeSet.stream().findFirst().get());
        }
        StringBuilder sql = new StringBuilder("select a.froleid, a.fdimtype, a.fincludesub, a.fusrgrpid, a.fdimid, a.fstarttime, a.fendtime");
        sql.append(" from t_perm_usrgrprole a");
        if (isOrgDim) {
            sql.append(" inner join t_sec_usergroup b on a.fusrgrpid = b.fid ");
            sql.append(" inner join t_org_org c on a.fdimid = c.fid ");
        }
        sql.append(" where 1=1 ");
        ArrayList<Object> paramList = new ArrayList<Object>(8);
        if (CollectionUtils.isEmpty(roleIdSet)) {
            sql.append(" and a.froleid > ' ' ");
        } else {
            String roleIdStr = String.join((CharSequence)"','", roleIdSet);
            sql.append(" and a.froleid in ('").append(roleIdStr).append("')");
        }
        if (null != dimTypeSet && !dimTypeSet.isEmpty() && StringUtils.isNotEmpty((String)(inStr = SqlUtil.wrapInParam(dimTypeSet.stream().map(x -> x).collect(Collectors.toSet()), paramList)))) {
            sql.append(" and a.fdimtype in (").append(inStr).append(") ");
        }
        if (CollectionUtils.isEmpty(includeSubSet)) {
            sql.append(" and a.fincludesub in('0','1')");
        } else {
            String includeSubStr = String.join((CharSequence)"','", includeSubSet);
            sql.append(" and a.fincludesub in ('").append(includeSubStr).append("')");
        }
        if (!CollectionUtils.isEmpty(usrGrpIdSet)) {
            List collect = usrGrpIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            String usrGrpIdStr = String.join((CharSequence)",", collect);
            sql.append(" and a.fusrgrpid in (").append(usrGrpIdStr).append(")");
        } else {
            sql.append(" and a.fusrgrpid > 0");
        }
        if (!CollectionUtils.isEmpty(dimIdSet)) {
            List dimIds = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            String dimIdStr = String.join((CharSequence)",", dimIds);
            sql.append(" and a.fdimid in (").append(dimIdStr).append(")");
        }
        sql.append(" order by a.fdimid desc ");
        Object[] params = paramList.toArray(new String[paramList.size()]);
        try (DataSet ds = DB.queryDataSet((String)UserGroupHelper.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString(), (Object[])params);){
            ArrayList<UgRoleDim> list = new ArrayList<UgRoleDim>(32);
            UgRoleDim one = null;
            while (ds.hasNext()) {
                Row rs = ds.next();
                one = new UgRoleDim();
                one.setUsrGrpId(rs.getLong("fusrgrpid"));
                one.setRoleId(rs.getString("froleid"));
                one.setDimId(rs.getLong("fdimid"));
                one.setIncludeSub(rs.getString("fincludesub"));
                one.setDimType(rs.getString("fdimtype"));
                one.setStarttime(rs.getDate("fstarttime"));
                one.setEndtime(rs.getDate("fendtime"));
                list.add(one);
            }
            ArrayList<UgRoleDim> arrayList = list;
            return arrayList;
        }
    }

    public static Long getCountByRoleId(String roleId) {
        return UserGroupHelper.getCount("froleid", roleId, null);
    }

    public static Long getCountByUgId(Long ugId, String dimType) {
        return UserGroupHelper.getCount("fusrgrpid", ugId, dimType);
    }

    private static Long getCount(String queryFieldKey, Object queryFieldV, String dimType) {
        StringBuilder sql = new StringBuilder("select count(*) num from t_perm_usrgrprole where ").append(queryFieldKey).append(" = ? ");
        ArrayList<Object> paramList = new ArrayList<Object>(2);
        paramList.add(queryFieldV);
        if (StringUtils.isNotEmpty((String)dimType)) {
            sql.append(" and fdimtype = ? ");
            paramList.add(dimType);
        }
        Object[] params = paramList.toArray(new Object[paramList.size()]);
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getLong("num");
                }
                return 0L;
            }
        });
    }

    public static Map<Long, Map<String, Set<String>>> getUsrGrpIdAppEntSetMap(Set<Long> usrGrpIdSet) {
        if (null == usrGrpIdSet || usrGrpIdSet.isEmpty()) {
            return new HashMap<Long, Map<String, Set<String>>>(1);
        }
        final HashMap<Long, Map<String, Set<String>>> map = new HashMap<Long, Map<String, Set<String>>>(8);
        String usrGrpIdSetStr = usrGrpIdSet.stream().map(String::valueOf).collect(Collectors.joining(","));
        UserGroupHelper.usrgrp_comrole_appentsetmap(usrGrpIdSet, map);
        UserGroupHelper.usrgrp_busirole_appentsetmap(usrGrpIdSet, map);
        StringBuilder busiRolePermSb = new StringBuilder();
        busiRolePermSb.append("select a.fusrgrpid, b.fbizappid, b.fentitytypeid ");
        busiRolePermSb.append(" from t_perm_usrgrpbizrole a ");
        busiRolePermSb.append(" inner join t_perm_bizroleperm b on  b.fid = a.fbizroleid ");
        busiRolePermSb.append(" where a.fusrgrpid in (").append(usrGrpIdSetStr).append(')');
        DB.query((DBRoute)DBRoute.base, (String)busiRolePermSb.toString(), (ResultSetHandler)new ResultSetHandler<Void>(){

            public Void handle(ResultSet rs) throws Exception {
                while (rs.next()) {
                    map.computeIfAbsent(rs.getLong("fusrgrpid"), k -> new HashMap()).computeIfAbsent(rs.getString("fbizappid"), k -> new HashSet()).add(rs.getString("fentitytypeid"));
                }
                return null;
            }
        });
        return map;
    }

    private static void usrgrp_busirole_appentsetmap(Set<Long> usrGrpIdSet, Map<Long, Map<String, Set<String>>> map) {
        Map<Long, Set<Long>> usrGrpBusiRoleIdSetMap = UserGroupHelper.getUsrGrpBusiRoleIdSetMap(usrGrpIdSet);
        if (null == usrGrpBusiRoleIdSetMap || usrGrpBusiRoleIdSetMap.isEmpty()) {
            return;
        }
        Set<Long> busiRoleIdSet = usrGrpBusiRoleIdSetMap.values().stream().flatMap(x -> x.stream()).collect(Collectors.toSet());
        if (null == busiRoleIdSet || busiRoleIdSet.isEmpty()) {
            return;
        }
        Map<Long, Set<String>> busiRoleComRoleIdSetMap = PermBusiRoleHelper.getBusiRoleComRoleIdSetMap(busiRoleIdSet);
        if (null == busiRoleComRoleIdSetMap || busiRoleComRoleIdSetMap.isEmpty()) {
            return;
        }
        Set<String> comRoleIdSet = busiRoleComRoleIdSetMap.values().stream().flatMap(x -> x.stream()).collect(Collectors.toSet());
        if (null == comRoleIdSet || comRoleIdSet.isEmpty()) {
            return;
        }
        Map<String, Map<String, Set<String>>> roleAppEntIdSetMap = PermRoleHelper.getRoleAppEntIdSetMap(comRoleIdSet);
        if (null == roleAppEntIdSetMap || roleAppEntIdSetMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, Set<Long>> usrGrpRoleIdSet : usrGrpBusiRoleIdSetMap.entrySet()) {
            Long usrgrpId = usrGrpRoleIdSet.getKey();
            Set<Long> busiRoleIdSetValue = usrGrpRoleIdSet.getValue();
            if (null == usrgrpId || Objects.equals(0L, usrgrpId) || null == busiRoleIdSetValue || busiRoleIdSetValue.isEmpty()) continue;
            for (Long busiRoleIdV : busiRoleIdSetValue) {
                Set<String> comRoleIdVSet = busiRoleComRoleIdSetMap.get(busiRoleIdV);
                if (null == comRoleIdVSet || comRoleIdVSet.isEmpty()) continue;
                for (String comRoleIdV : comRoleIdVSet) {
                    Map<String, Set<String>> appEntSet = roleAppEntIdSetMap.get(comRoleIdV);
                    if (null == appEntSet || appEntSet.isEmpty()) continue;
                    for (Map.Entry<String, Set<String>> appEnt : appEntSet.entrySet()) {
                        String appId = appEnt.getKey();
                        Set<String> value = appEnt.getValue();
                        if (StringUtils.isEmpty((String)appId) || null == value || value.isEmpty()) continue;
                        map.computeIfAbsent(usrgrpId, k -> new HashMap(8)).computeIfAbsent(appId, k -> new HashSet(8)).addAll(value);
                    }
                }
            }
        }
    }

    private static void usrgrp_comrole_appentsetmap(Set<Long> usrGrpIdSet, Map<Long, Map<String, Set<String>>> map) {
        Map<Long, Set<String>> usrGrpRoleIdSetMap = UserGroupHelper.getUsrGrpRoleIdSetMap(usrGrpIdSet);
        if (null == usrGrpRoleIdSetMap || usrGrpRoleIdSetMap.isEmpty()) {
            return;
        }
        Set<String> comRoleIdSet = usrGrpRoleIdSetMap.values().stream().flatMap(x -> x.stream()).collect(Collectors.toSet());
        if (null == comRoleIdSet || comRoleIdSet.isEmpty()) {
            return;
        }
        Map<String, Map<String, Set<String>>> roleAppEntIdSetMap = PermRoleHelper.getRoleAppEntIdSetMap(comRoleIdSet);
        if (null == roleAppEntIdSetMap || roleAppEntIdSetMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, Set<String>> usrGrpRoleIdSet : usrGrpRoleIdSetMap.entrySet()) {
            Long usrgrpId = usrGrpRoleIdSet.getKey();
            Set<String> roleIdSetValue = usrGrpRoleIdSet.getValue();
            if (null == usrgrpId || Objects.equals(0L, usrgrpId) || null == roleIdSetValue || roleIdSetValue.isEmpty()) continue;
            for (String roleIdV : roleIdSetValue) {
                Map<String, Set<String>> appEntSet = roleAppEntIdSetMap.get(roleIdV);
                if (null == appEntSet || appEntSet.isEmpty()) continue;
                for (Map.Entry<String, Set<String>> appEnt : appEntSet.entrySet()) {
                    String appId = appEnt.getKey();
                    Set<String> value = appEnt.getValue();
                    if (StringUtils.isEmpty((String)appId) || null == value || value.isEmpty()) continue;
                    map.computeIfAbsent(usrgrpId, k -> new HashMap(8)).computeIfAbsent(appId, k -> new HashSet(8)).addAll(value);
                }
            }
        }
    }

    public static Map<Long, Set<String>> getUsrGrpRoleIdSetMap(Set<Long> usrGrpIdSet) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (null != usrGrpIdSet && !usrGrpIdSet.isEmpty()) {
            filterList.add(new QFilter("usrgrpid", "in", usrGrpIdSet));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserGroupHelper.getUsrGrpRoleIdSetMap", (String)"perm_usrgrprole", (String)"usrgrpid_id, role_id", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            HashMap<Long, Set<String>> map = new HashMap<Long, Set<String>>(8);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long usrgrpid_id = row.getLong("usrgrpid_id");
                String role_id = row.getString("role_id");
                if (null == usrgrpid_id || Objects.equals(0L, usrgrpid_id) || StringUtils.isEmpty((String)role_id)) continue;
                map.computeIfAbsent(usrgrpid_id, k -> new HashSet(8)).add(role_id);
            }
            HashMap<Long, Set<String>> hashMap = map;
            return hashMap;
        }
    }

    public static Map<Long, Set<Long>> getUsrGrpBusiRoleIdSetMap(Set<Long> usrGrpIdSet) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        if (null != usrGrpIdSet && !usrGrpIdSet.isEmpty()) {
            filterList.add(new QFilter("usergroup", "in", usrGrpIdSet));
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserGroupHelper.getUsrGrpBusiRoleIdSetMap", (String)"perm_usrgrpbusirole", (String)"usergroup_id, bizrole_id", (QFilter[])filterList.toArray(filterList.toArray(new QFilter[filterList.size()])), (String)"");){
            HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(8);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long usergroup_id = row.getLong("usergroup_id");
                Long bizrole_id = row.getLong("bizrole_id");
                if (null == usergroup_id || Objects.equals(0L, usergroup_id) || null == bizrole_id || Objects.equals(0L, bizrole_id)) continue;
                map.computeIfAbsent(usergroup_id, k -> new HashSet(8)).add(bizrole_id);
            }
            HashMap<Long, Set<Long>> hashMap = map;
            return hashMap;
        }
    }

    public static Set<Long> getUsrGrpIdSet(Map<String, Object> paramMap) {
        Long userId = 0L;
        if (null != paramMap.get("userId")) {
            userId = (Long)paramMap.get("userId");
        }
        return (Set)DB.query((DBRoute)DBRoute.basedata, (String)"select distinct fusergroupid from t_sec_usergroupstaff where fuserid = ? ", (Object[])new Object[]{userId}, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> set = new HashSet<Long>(8);
                while (rs.next()) {
                    set.add(rs.getLong("fusergroupid"));
                }
                return set;
            }
        });
    }

    public static List<UgRoleDim> getPURList(Set<String> roleIdSet, Set<String> includeSubSet, Set<Long> usrGrpIdSet, Set<Long> dimIdSet, Set<String> dimTypeSet, boolean roleAssignUsrGrp) {
        StringBuilder sql = new StringBuilder("select a.froleid, a.fdimtype, a.fincludesub, a.fusrgrpid, a.fdimid, a.fstarttime, a.fendtime ");
        sql.append(" from t_perm_usrgrprole a");
        StringBuilder whereStr = new StringBuilder("and (");
        if (roleAssignUsrGrp) {
            String roleIdStr = String.join((CharSequence)"','", roleIdSet);
            sql.append(" where a.froleid in ('").append(roleIdStr).append("') ");
            if (usrGrpIdSet != null && !usrGrpIdSet.isEmpty()) {
                List collect = usrGrpIdSet.stream().map(String::valueOf).collect(Collectors.toList());
                String usrGrpIdStr = String.join((CharSequence)",", collect);
                whereStr.append(" a.fusrgrpid in (").append(usrGrpIdStr).append(") or");
            }
        } else {
            List collect = usrGrpIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            String usrGrpIdStr = String.join((CharSequence)",", collect);
            sql.append(" where a.fusrgrpid in (").append(usrGrpIdStr).append(") ");
            if (roleIdSet != null && !roleIdSet.isEmpty()) {
                String roleIdStr = String.join((CharSequence)"','", roleIdSet);
                whereStr.append(" a.froleid in ('").append(roleIdStr).append("') or");
            }
        }
        if (null != dimTypeSet && !dimTypeSet.isEmpty()) {
            String dimTypeSetStr = String.join((CharSequence)"','", dimTypeSet);
            whereStr.append(" a.fdimtype in ('").append(dimTypeSetStr).append("') or");
        }
        if (null != includeSubSet && !includeSubSet.isEmpty()) {
            String includeSubStr = String.join((CharSequence)"','", includeSubSet);
            whereStr.append(" a.fincludesub in ('").append(includeSubStr).append("') or");
        }
        if (null != dimIdSet && !dimIdSet.isEmpty()) {
            List dimIds = dimIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            String dimIdStr = String.join((CharSequence)",", dimIds);
            whereStr.append(" a.fdimid in (").append(dimIdStr).append(") or");
        }
        if (!Objects.equals(Character.valueOf('('), Character.valueOf(whereStr.charAt(whereStr.length() - 1)))) {
            whereStr.deleteCharAt(whereStr.length() - 1).deleteCharAt(whereStr.length() - 1).append(')');
            sql.append((CharSequence)whereStr);
        }
        try (DataSet urDs = DB.queryDataSet((String)OrgUserHelper.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString());){
            ArrayList<UgRoleDim> list = new ArrayList<UgRoleDim>(32);
            UgRoleDim one = null;
            while (urDs.hasNext()) {
                Row rs = urDs.next();
                one = new UgRoleDim();
                one.setRoleId(rs.getString("froleid"));
                one.setDimType(rs.getString("fdimtype"));
                one.setIncludeSub(rs.getString("fincludesub"));
                one.setUsrGrpId(rs.getLong("fusrgrpid"));
                one.setDimId(rs.getLong("fdimid"));
                one.setStarttime(rs.getDate("fstarttime"));
                one.setEndtime(rs.getDate("fendtime"));
                list.add(one);
            }
            ArrayList<UgRoleDim> arrayList = list;
            return arrayList;
        }
    }

    public static Map<String, Set<UsrGrp>> getUsrGrpMap(Set<String> idOrNumberOrNameSet, String keyType) {
        HashMap<String, Set<UsrGrp>> map = new HashMap<String, Set<UsrGrp>>(8);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("id", keyType)) {
            qFilterList.add(new QFilter("id", "in", idOrNumberOrNameSet.stream().map(Long::valueOf).collect(Collectors.toSet())));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("number", keyType)) {
            qFilterList.add(new QFilter("number", "in", idOrNumberOrNameSet));
        }
        if (null != idOrNumberOrNameSet && !idOrNumberOrNameSet.isEmpty() && Objects.equals("name", keyType)) {
            qFilterList.add(new QFilter("name", "in", idOrNumberOrNameSet));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"UserGroupHelper.getUsrGrpMap", (String)"bos_usrgrp", (String)"id, number, name, usrgrpstd_id, usrgrpstd.number, usrgrpstd.name", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");){
            UsrGrp one = null;
            while (ds.hasNext()) {
                Row row = ds.next();
                one = new UsrGrp();
                Long id = row.getLong("id");
                String number = row.getString("number");
                String name = row.getString("name");
                Long usrGrpStdId = row.getLong("usrgrpstd_id");
                String usrGrpStdNum = row.getString("usrgrpstd.number");
                String usrGrpStdName = row.getString("usrgrpstd.name");
                one.setUserGroupId(id);
                one.setUserGroupNum(number);
                one.setUserGroupName(name);
                one.setUsrGrpStdId(usrGrpStdId);
                one.setUsrGrpStdNum(usrGrpStdNum);
                one.setUsrGrpStdName(usrGrpStdName);
                if (Objects.equals("id", keyType)) {
                    map.computeIfAbsent(String.valueOf(id), k -> new HashSet()).add(one);
                }
                if (Objects.equals("name", keyType)) {
                    map.computeIfAbsent(name, k -> new HashSet()).add(one);
                    continue;
                }
                if (!Objects.equals("number", keyType)) continue;
                map.computeIfAbsent(number, k -> new HashSet()).add(one);
            }
        }
        return map;
    }
}

