/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper;

import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.LoginClientEnum;
import kd.bos.login.service.impl.SessionComServiceImpl;
import kd.bos.login.utils.DateUtils;
import kd.bos.login.utils.LocalCacheUtils;
import kd.bos.login.utils.StrategeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.helper.IsoDimHelper;
import kd.bos.permission.cache.helper.PermRoleHelper;
import kd.bos.permission.cache.helper.callable.GetUserByIds;
import kd.bos.permission.cache.model.User;
import kd.bos.permission.cache.util.DateUtil;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.UserParam;
import kd.bos.permission.model.perm.UserFieldPermScheme;
import kd.bos.permission.model.perm.user.PermUser;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UserHelper {
    private static Log logger = LogFactory.getLog(UserHelper.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Perm_UserHelper_Pool", (int)2);

    public static List<User> getUserListBySet(Set<Long> userIdSet, String langStr) {
        if (CollectionUtils.isEmpty(userIdSet)) {
            return new ArrayList<User>(1);
        }
        ArrayList<User> list = null;
        try {
            int size = userIdSet.size();
            int m = SqlUtil.getBatchCount(PermHelperConst.SQL_IN_QUERY_NUM, size);
            CountDownLatch countwnLatch = new CountDownLatch(m);
            ArrayList<Future> futureList = new ArrayList<Future>(m);
            ArrayList<Long> userIdList = new ArrayList<Long>(userIdSet);
            List<List<Long>> listAvg = ListUtil.averageAssign(userIdList, m);
            for (int i = 0; i < listAvg.size(); ++i) {
                List<Long> userIds = listAvg.get(i);
                Future oneList = pool.submit((Callable)new GetUserByIds(new HashSet<Long>(userIds), countwnLatch, langStr));
                futureList.add(oneList);
            }
            countwnLatch.await();
            list = new ArrayList<User>(size);
            for (Future listFuture : futureList) {
                list.addAll((Collection)listFuture.get());
            }
            return list;
        }
        catch (Exception e) {
            logger.warn("UserHelper.getUserListBySet error", (Throwable)e);
            return new ArrayList<User>(1);
        }
    }

    public static List<User> getUserInfoByIds(Set<Long> userIdSet, String langStr) {
        return UserHelper.getUserInfoByIds(userIdSet, false);
    }

    public static List<User> getUserInfoByIds(Set<Long> userIdSet, boolean truenameLVBoolean) {
        if (CollectionUtils.isEmpty(userIdSet)) {
            return new ArrayList<User>(0);
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_user", (String)"id, name, number, phone, email, username, gender, picturefield, islocked, isforbidden, userdisablerid, userdisabletime", (QFilter[])new QFilter[]{new QFilter("id", "in", userIdSet)}, (String)"");
        if (null == load || Objects.equals(0, load.length)) {
            return new ArrayList<User>(0);
        }
        ArrayList<User> list = new ArrayList<User>(userIdSet.size());
        User user = null;
        for (DynamicObject row : load) {
            Long fid = row.getLong("id");
            String truename = row.getString("name");
            String fnumber = row.getString("number");
            String fphone = row.getString("phone");
            String femail = row.getString("email");
            String fusername = row.getString("username");
            String fgender = row.getString("gender");
            String favatar = row.getString("picturefield");
            Boolean fislocked = row.getBoolean("islocked");
            Boolean fisforbidden = row.getBoolean("isforbidden");
            Long fuserdisablerid = row.getLong("userdisablerid_id");
            Object fuserdisabletime = row.get("userdisabletime");
            user = new User(fid, truename, fnumber, fphone, femail, fusername);
            if (truenameLVBoolean) {
                OrmLocaleValue truenameLV = (OrmLocaleValue)row.get("name");
                user.setFtruenameLv(truenameLV);
            }
            user.setFgender(fgender);
            user.setFavatar(favatar);
            user.setFislocked(null != fislocked && fislocked != false ? "1" : "0");
            user.setFisforbidden(null != fisforbidden && fisforbidden != false ? "1" : "0");
            user.setFuserdisablerid(fuserdisablerid);
            Timestamp timestamp = null;
            if (fuserdisabletime instanceof Timestamp) {
                timestamp = (Timestamp)fuserdisabletime;
            }
            user.setFuserdisabletime(timestamp);
            list.add(user);
        }
        return list;
    }

    public static Map<Long, String> getForbiddeName(Collection<User> users) {
        DynamicObject[] userArr;
        HashSet<Long> ids = new HashSet<Long>();
        HashMap<Long, String> hashMap = new HashMap<Long, String>(users.size());
        if (CollectionUtils.isEmpty(users)) {
            return hashMap;
        }
        for (User user : users) {
            if (user.getFuserdisablerid() == null) continue;
            ids.add(user.getFuserdisablerid());
        }
        for (DynamicObject user : userArr = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
            String name = user.getString("name");
            if (StringUtils.isBlank((String)name)) {
                name = "";
            }
            hashMap.put((Long)user.getPkValue(), name);
        }
        return hashMap;
    }

    public static Map<Long, User> getUserInfoMapByIds(Set<Long> userIdSet, String langStr) {
        return UserHelper.getUserInfoMapByIds(userIdSet, langStr, false);
    }

    public static Map<Long, User> getUserInfoMapByIds(Set<Long> userIdSet, String langStr, boolean truenameLVBoolean) {
        if (CollectionUtils.isEmpty(userIdSet)) {
            return new HashMap<Long, User>(0);
        }
        List<User> userInfoByIds = UserHelper.getUserInfoByIds(userIdSet, truenameLVBoolean);
        if (CollectionUtils.isEmpty(userInfoByIds)) {
            return new HashMap<Long, User>(0);
        }
        return userInfoByIds.stream().collect(Collectors.toMap(User::getFid, Function.identity(), (key1, key2) -> key2));
    }

    public static Map<Long, User> getUserPositionInfoMapByIds(Set<Long> userIdSet, String langStr) {
        if (CollectionUtils.isEmpty(userIdSet)) {
            return new HashMap<Long, User>(1);
        }
        final List userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList());
        String userIdStr = String.join((CharSequence)",", userIdList);
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fid, a.fdptid, a.fposition aposition, b.fposition bposition, a.fentryid positionEntryId, a.fispartjob");
        sb.append(" from t_sec_userposition a ");
        sb.append(" left join t_sec_userposition_l b on a.fentryid = b.fentryid and b.flocaleid=?");
        sb.append(" where a.fid in (").append(userIdStr).append(")");
        Object[] params = new Object[]{langStr};
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<Long, User>>(){

            public Map<Long, User> handle(ResultSet rs) throws Exception {
                HashMap<Long, User> map = new HashMap<Long, User>(userIdList.size());
                User user = null;
                while (rs.next()) {
                    Long fid = rs.getLong("fid");
                    Long fdptid = rs.getLong("fdptid");
                    String aposition = rs.getString("aposition");
                    String bposition = rs.getString("bposition");
                    user = new User(fid, fdptid, StringUtils.isEmpty((String)bposition) || StringUtils.isEmpty((String)bposition.trim()) ? aposition : bposition);
                    Long positionEntryId = rs.getLong("positionEntryId");
                    user.setPositionEntryId(positionEntryId);
                    String fispartjob = rs.getString("fispartjob");
                    user.setFispartjob(fispartjob);
                    map.put(fid, user);
                }
                return map;
            }
        });
    }

    public static Map<Long, User> getUPIFullJobMapByIds(Set<Long> userIdSet, final String langStr) {
        if (CollectionUtils.isEmpty(userIdSet)) {
            return new HashMap<Long, User>(1);
        }
        try {
            int size = userIdSet.size();
            int m = SqlUtil.getBatchCount(PermHelperConst.CONST_200, size);
            final CountDownLatch countDownLatch = new CountDownLatch(m);
            LinkedList<Future> futureList = new LinkedList<Future>();
            ArrayList<Long> idList = new ArrayList<Long>(userIdSet);
            List<List<Long>> listAvg = ListUtil.averageAssign(idList, m);
            for (int i = 0; i < listAvg.size(); ++i) {
                final List<Long> idSchemes = listAvg.get(i);
                Future oneList = pool.submit((Callable)new Callable<Map<Long, User>>(){

                    @Override
                    public Map<Long, User> call() throws Exception {
                        try {
                            final List userIdList = idSchemes.stream().map(String::valueOf).collect(Collectors.toList());
                            String userIdStr = String.join((CharSequence)",", userIdList);
                            StringBuilder sb = new StringBuilder();
                            sb.append("select a.fid, a.fdptid, a.fposition aposition, b.fposition bposition, a.fentryid positionEntryId, a.fispartjob");
                            sb.append(" from t_sec_userposition a ");
                            sb.append(" left join t_sec_userposition_l b on a.fentryid = b.fentryid and b.flocaleid=?");
                            sb.append(" where a.fid in (").append(userIdStr).append(")");
                            sb.append(" and (a.fispartjob = '0' or a.fdptid is null)");
                            Object[] params = new Object[]{langStr};
                            Map map = (Map)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<Long, User>>(){

                                public Map<Long, User> handle(ResultSet rs) throws Exception {
                                    HashMap<Long, User> map = new HashMap<Long, User>(userIdList.size());
                                    User user = null;
                                    while (rs.next()) {
                                        Long fid = rs.getLong("fid");
                                        Long fdptid = rs.getLong("fdptid");
                                        String aposition = rs.getString("aposition");
                                        String bposition = rs.getString("bposition");
                                        user = new User(fid, fdptid, StringUtils.isEmpty((String)bposition) || StringUtils.isEmpty((String)bposition.trim()) ? aposition : bposition);
                                        Long positionEntryId = rs.getLong("positionEntryId");
                                        user.setPositionEntryId(positionEntryId);
                                        String fispartjob = rs.getString("fispartjob");
                                        user.setFispartjob(fispartjob);
                                        map.put(fid, user);
                                    }
                                    return map;
                                }
                            });
                            return map;
                        }
                        catch (Exception e) {
                            logger.warn("UserHelper.getUPIFullJobMapByIds.call error.", (Throwable)e);
                            throw new KDBizException(new ErrorCode("0", "UserHelper.getUPIFullJobMapByIds.call error."), new Object[0]);
                        }
                        finally {
                            if (null != countDownLatch) {
                                countDownLatch.countDown();
                            }
                        }
                    }
                });
                futureList.add(oneList);
            }
            countDownLatch.await();
            HashMap<Long, User> map = new HashMap<Long, User>(size);
            for (Future listFuture : futureList) {
                Map part = (Map)listFuture.get();
                map.putAll(part);
            }
            return map;
        }
        catch (Exception e) {
            logger.warn("UserHelper.getUPIFullJobMapByIds error", (Throwable)e);
            return new HashMap<Long, User>(1);
        }
    }

    public static Map<Object, DynamicObject> getUserDynMap(Set<Long> userIdSet) {
        try {
            int size = userIdSet.size();
            if (0 == size) {
                return new HashMap<Object, DynamicObject>(1);
            }
            int m = SqlUtil.getBatchCount(PermHelperConst.CONST_200, size);
            final CountDownLatch countDownLatch = new CountDownLatch(m);
            LinkedList<Future> futureList = new LinkedList<Future>();
            ArrayList<Long> idList = new ArrayList<Long>(userIdSet);
            List<List<Long>> listAvg = ListUtil.averageAssign(idList, m);
            for (int i = 0; i < listAvg.size(); ++i) {
                final List<Long> idSchemes = listAvg.get(i);
                Future oneList = pool.submit((Callable)new Callable<Map<Object, DynamicObject>>(){

                    @Override
                    public Map<Object, DynamicObject> call() throws Exception {
                        try {
                            QFilter uFilter = new QFilter("id", "in", (Object)idSchemes);
                            Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"email,  enable, masterid, name, number, phone, usertypes.name", (QFilter[])new QFilter[]{uFilter});
                            return map;
                        }
                        catch (Exception e) {
                            logger.warn("UserHelper.getUserDynMap.call error.", (Throwable)e);
                            throw new KDBizException(new ErrorCode("0", "UserHelper.getUserDynMap.call error."), new Object[0]);
                        }
                        finally {
                            if (null != countDownLatch) {
                                countDownLatch.countDown();
                            }
                        }
                    }
                });
                futureList.add(oneList);
            }
            countDownLatch.await();
            HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(size);
            for (Future listFuture : futureList) {
                Map part = (Map)listFuture.get();
                map.putAll(part);
            }
            return map;
        }
        catch (Exception e) {
            logger.warn("UserHelper.getUserDynMap error", (Throwable)e);
            return new HashMap<Object, DynamicObject>(1);
        }
    }

    public static String getUserTypesStr(DynamicObject user) {
        DynamicObjectCollection usertypesDoc = user.getDynamicObjectCollection("usertypes");
        if (!CollectionUtils.isEmpty((Collection)usertypesDoc)) {
            return usertypesDoc.stream().map(x -> x.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue()).collect(Collectors.joining("\uff1b"));
        }
        return "";
    }

    public static Map<Long, Set<String>> getUserTypeMap(Set<Long> userIdSet) {
        if (null == userIdSet || userIdSet.isEmpty()) {
            return new HashMap<Long, Set<String>>(0);
        }
        Map doc = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"usertypes", (QFilter[])new QFilter[]{new QFilter("id", "in", userIdSet)});
        if (null == doc || doc.isEmpty()) {
            return new HashMap<Long, Set<String>>(0);
        }
        HashMap<Long, Set<String>> map = new HashMap<Long, Set<String>>(doc.size());
        for (Map.Entry dd : doc.entrySet()) {
            Object userIdObj = dd.getKey();
            DynamicObject value = (DynamicObject)dd.getValue();
            if (null == userIdObj || null == value) continue;
            Long userId = (Long)userIdObj;
            DynamicObjectCollection usertypesDoc = value.getDynamicObjectCollection("usertypes");
            if (CollectionUtils.isEmpty((Collection)usertypesDoc)) {
                map.put(userId, new HashSet(0));
                continue;
            }
            Set fbasedataidId = usertypesDoc.stream().map(x -> x.getString("fbasedataid_id")).collect(Collectors.toSet());
            map.put(userId, fbasedataidId);
        }
        return map;
    }

    public static Set<String> getCommRoleIds(Long userId, String dimType, List<Long> dimIdList, String includeSub, String orgView) {
        HashMap<String, Object> commParam = new HashMap<String, Object>(8);
        commParam.put("queryType", "getRoleIdSet");
        commParam.put("userId", userId);
        commParam.put("dimTypeList", IsoDimHelper.addDimTypeFilter(dimType) ? Collections.singletonList(dimType) : new ArrayList(1));
        commParam.put("dimIdList", null == dimIdList || dimIdList.isEmpty() ? new ArrayList(1) : dimIdList);
        commParam.put("includeSub", includeSub);
        commParam.put("orgView", orgView);
        commParam.put("enable", "1");
        commParam.put("selectTSecUserGroupStaff", "1");
        if (StringUtils.isNotEmpty((String)dimType) && IsoDimHelper.checkOrgDimMulti(dimType) && StringUtils.isNotEmpty((String)orgView)) {
            commParam.put("selectTOrgStructure", "1");
        }
        commParam.put("selectTPermRole", "1");
        Map<String, Object> curOrgDimCommMap = PermRoleHelper.getCommRoleInfoMap(commParam);
        if (CollectionUtils.isEmpty(curOrgDimCommMap)) {
            return new HashSet<String>(1);
        }
        Set roleIdSet = (Set)curOrgDimCommMap.get("roleIdSet");
        if (CollectionUtils.isEmpty((Collection)roleIdSet)) {
            return new HashSet<String>(1);
        }
        return roleIdSet;
    }

    public static Set<String> getJustCommRoleIdSetByUserId(Long userId) {
        Set<String> resultSet = new HashSet<String>(8);
        try {
            String cacheType = CacheMrg.getType4UserOwnJustCommRoleIds();
            String cacheKey = String.valueOf(userId);
            String cachedStr = CacheMrg.getCache(cacheType, cacheKey);
            if (StringUtils.isNotEmpty((String)cachedStr)) {
                resultSet = (Set)SerializationUtils.fromJsonString((String)cachedStr, Set.class);
                return resultSet;
            }
            HashMap<String, Object> commParam = new HashMap<String, Object>(8);
            commParam.put("queryType", "getRoleIdSet");
            commParam.put("userId", userId);
            commParam.put("enable", "1");
            commParam.put("selectTPermRole", "1");
            Map<String, Object> curOrgDimCommMap = PermRoleHelper.getCommRoleInfoMap(commParam);
            if (CollectionUtils.isEmpty(curOrgDimCommMap)) {
                return new HashSet<String>(1);
            }
            resultSet = (Set)curOrgDimCommMap.get("roleIdSet");
            CacheMrg.putCache(cacheType, cacheKey, SerializationUtils.toJsonString(resultSet));
            return resultSet;
        }
        catch (Exception e) {
            logger.warn("UserHelper.getJustCommRoleIdSetByUserId,\u53ea\u5305\u542b\u901a\u7528\u89d2\u8272-\u7528\u6237\u3001\u901a\u7528\u89d2\u8272-\u7528\u6237\u7ec4-\u7528\u6237\u7684\u5173\u7cfb\u4e2d\u5173\u8054\u7684\u5df2\u542f\u7528\u7684\u901a\u7528\u89d2\u8272\uff0c\u4e0d\u5305\u542b\u4e1a\u52a1\u89d2\u8272\uff0c \u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return resultSet;
        }
    }

    public static Date getCommRoleMinStartTimeByUserId(Long userId, String dimType, List<Long> dimIdList, String includeSub) {
        ArrayList<Object> paramList = new ArrayList<Object>(6);
        StringBuilder sb = new StringBuilder();
        sb.append("select min(ur.fstarttime) min_starttime");
        sb.append(" from t_perm_role r inner join t_perm_userrole ur on r.fid=ur.froleid");
        sb.append(" where ur.fuserid=?");
        paramList.add(userId);
        if (!CollectionUtils.isEmpty(dimIdList)) {
            List dimIds = dimIdList.stream().map(String::valueOf).collect(Collectors.toList());
            String dimIdsStr = String.join((CharSequence)"','", dimIds);
            sb.append(" and ur.forgid in ('").append(dimIdsStr).append("')");
        }
        if (StringUtils.isNotEmpty((String)dimType)) {
            sb.append(" and ur.fdimtype = ?");
            paramList.add(dimType);
        }
        if (StringUtils.isNotEmpty((String)includeSub)) {
            sb.append(" and ur.fisincludesuborg = ? ");
            paramList.add(includeSub);
        }
        sb.append(" and r.fenable = '1' and  now() < ur.fstarttime ");
        return (Date)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Date>(){

            public Date handle(ResultSet rs) throws Exception {
                Date minStartTime = null;
                if (rs.next()) {
                    String min_starttime = rs.getString("min_starttime");
                    minStartTime = StringUtils.isEmpty((String)min_starttime) ? null : DateUtil.toDate(min_starttime.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                }
                return minStartTime;
            }
        });
    }

    public static Date getCommRoleMinEndTimeByUserId(Long userId, String dimType, List<Long> dimIdList, String includeSub) {
        ArrayList<Object> paramList = new ArrayList<Object>(6);
        StringBuilder sb = new StringBuilder();
        sb.append("select min(ur.fendtime) min_endtime");
        sb.append(" from t_perm_role r inner join t_perm_userrole ur on r.fid=ur.froleid");
        sb.append(" where ur.fuserid=?");
        paramList.add(userId);
        if (!CollectionUtils.isEmpty(dimIdList)) {
            List dimIds = dimIdList.stream().map(String::valueOf).collect(Collectors.toList());
            String dimIdsStr = String.join((CharSequence)"','", dimIds);
            sb.append(" and ur.forgid in ('").append(dimIdsStr).append("')");
        }
        if (StringUtils.isNotEmpty((String)dimType)) {
            sb.append(" and ur.fdimtype = ?");
            paramList.add(dimType);
        }
        if (StringUtils.isNotEmpty((String)includeSub)) {
            sb.append(" and ur.fisincludesuborg = ? ");
            paramList.add(includeSub);
        }
        sb.append(" and r.fenable = '1' and now() < ur.fendtime ");
        return (Date)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Date>(){

            public Date handle(ResultSet rs) throws Exception {
                Date minEndDate = null;
                while (rs.next()) {
                    String min_endtime = rs.getString("min_endtime");
                    minEndDate = StringUtils.isEmpty((String)min_endtime) ? null : DateUtil.toDate(min_endtime.substring(0, 19), "yyyy-MM-dd HH:mm:ss");
                }
                return minEndDate;
            }
        });
    }

    public static Set<Long> getUserIdSet(String fenable, Set<Long> notInSet) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fid from t_sec_user where 1=1");
        ArrayList<String> paramList = new ArrayList<String>(8);
        if (StringUtils.isNotEmpty((String)fenable)) {
            sql.append(" and fenable = ?");
            paramList.add(fenable);
        }
        if (null != notInSet && notInSet.size() > 0) {
            List notInList = notInSet.stream().map(String::valueOf).collect(Collectors.toList());
            String notInStr = String.join((CharSequence)",", notInList);
            sql.append(" and fid not in (").append(notInStr).append(')');
        }
        return (Set)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), resultSet -> {
            HashSet<Long> allUsersId = new HashSet<Long>(128);
            while (resultSet.next()) {
                allUsersId.add(resultSet.getLong("fid"));
            }
            return allUsersId;
        });
    }

    public static Long getUserCount(String fenable, Set<Long> notInSet) {
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) num from t_sec_user where 1=1");
        ArrayList<String> paramList = new ArrayList<String>(8);
        if (StringUtils.isNotEmpty((String)fenable)) {
            sql.append(" and fenable = ?");
            paramList.add(fenable);
        }
        if (null != notInSet && notInSet.size() > 0) {
            List notInList = notInSet.stream().map(String::valueOf).collect(Collectors.toList());
            String notInStr = String.join((CharSequence)",", notInList);
            sql.append(" and fid not in (").append(notInStr).append(')');
        }
        return (Long)DB.query((DBRoute)DBRoute.base, (String)sql.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), rs -> {
            if (rs.next()) {
                return rs.getLong("num");
            }
            return 0L;
        });
    }

    public static PermResult resetPssw(Map<Long, User> userInfoMap) {
        try {
            if (null == userInfoMap || userInfoMap.isEmpty()) {
                return PermResult.fail((String)"userInfoMap is empty");
            }
            Set<Long> userIdSet = userInfoMap.keySet();
            List updateUsers = userIdSet.stream().map(userId -> {
                UserParam userParam = new UserParam();
                userParam.setId(userId.longValue());
                return userParam;
            }).collect(Collectors.toList());
            UserServiceHelper.changePsw(updateUsers);
            HashSet<Long> successUserIdSet = new HashSet<Long>(8);
            HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(8);
            for (UserParam updateUser : updateUsers) {
                boolean bl = updateUser.isSuccess();
                if (!bl) {
                    errorMsgMap.put(updateUser.getId(), updateUser.getMsg());
                    continue;
                }
                successUserIdSet.add(updateUser.getId());
            }
            if (null != successUserIdSet && !successUserIdSet.isEmpty()) {
                for (Long successUserId : successUserIdSet) {
                    User user = userInfoMap.get(successUserId);
                    if (null == user) continue;
                    UserHelper.removePasswordCache(user.getFusername(), user.getFphone(), user.getFemail(), String.valueOf(successUserId));
                }
                String date = DateUtils.getDate();
                String userName = RequestContext.get().getUserName();
                String string = String.format(ResManager.loadKDString((String)"\u60a8\u7684\u8d26\u53f7\u5df2\u4e8e%1$s\u88ab\u7ba1\u7406\u5458%2$s\u91cd\u7f6e\u5bc6\u7801\uff0c\u88ab\u8feb\u4e0b\u7ebf\u3002\u5982\u9700\u5e2e\u52a9\uff0c\u8bf7\u8054\u7cfb\u60a8\u7684\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"UserHelper_0", (String)"bos-permission-cache", (Object[])new Object[0]), date, userName);
                UserHelper.removeSessionByUserId(successUserIdSet, string);
            }
            if (null == errorMsgMap || errorMsgMap.isEmpty()) {
                return PermResult.ok((StringBuilder)new StringBuilder().append(ResManager.loadKDString((String)"\u7528\u6237\u91cd\u7f6e\u5bc6\u7801\u6210\u529f\uff0c\u6062\u590d\u4e3a\u51fa\u5382\u5bc6\u7801\u3002\u8bf7\u544a\u77e5\u7528\u6237\u901a\u8fc7\u4ee5\u4e0b\u65b9\u5f0f\u91cd\u7f6e\u65b0\u5bc6\u7801\uff1a\u767b\u5f55\u754c\u9762->\u627e\u56de\u5bc6\u7801\u3002", (String)"UserHelper_1", (String)"bos-permission-cache", (Object[])new Object[0])));
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : errorMsgMap.entrySet()) {
                Long uId = (Long)entry.getKey();
                User user = userInfoMap.get(uId);
                if (null == user) continue;
                sb.append("\n");
                sb.append(user.getFtruename()).append("  ").append(user.getFnumber()).append("\uff1a").append((String)entry.getValue());
            }
            String failMes = String.format(ResManager.loadKDString((String)"\u7528\u6237\u91cd\u7f6e\u5bc6\u7801\u5b58\u5728\u5931\u8d25\uff0c\u8be6\u60c5\u5982\u4e0b\uff1a%1$s", (String)"UserHelper_2", (String)"bos-permission-cache", (Object[])new Object[0]), sb.toString());
            return PermResult.fail((String)failMes);
        }
        catch (Exception e) {
            logger.warn("UserHelper.resetPssw error", (Throwable)e);
            return PermResult.fail((String)e.getMessage());
        }
    }

    private static void removePasswordCache(String fusername, String fphone, String femail, String userId) {
        Account currentCenter = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
        StrategeUtils.clearPasswordWrongTimes((Account)currentCenter, (String)userId, (String)LoginClientEnum.WEB.toString());
        String loginPassword = "s_login_password";
        LocalCacheUtils.remove((String)(fusername + loginPassword));
        LocalCacheUtils.remove((String)(fphone + loginPassword));
        LocalCacheUtils.remove((String)(femail + loginPassword));
    }

    public static PermResult removeSessionByUserId(Set<Long> userIdSet, String logOutDesc) {
        try {
            if (null == userIdSet || userIdSet.isEmpty()) {
                return PermResult.fail((String)"userIdSet is empty");
            }
            SessionComServiceImpl service = new SessionComServiceImpl();
            List userIdList = userIdSet.stream().map(String::valueOf).collect(Collectors.toList());
            boolean ok = service.removeSessionByUserId(userIdList, logOutDesc, false);
            if (ok) {
                return PermResult.ok();
            }
            return PermResult.fail((String)"removeSessionByUserId fail");
        }
        catch (Exception e) {
            logger.warn("UserHelper.removeSessionByUserId error", (Throwable)e);
            return PermResult.fail((String)e.getMessage());
        }
    }

    public static Set<Long> getUsrGrpId(Long userId) {
        ArrayList<Long> paramList = new ArrayList<Long>(6);
        StringBuilder sb = new StringBuilder();
        sb.append("select fusergroupid");
        sb.append(" from t_sec_usergroupstaff");
        sb.append(" where fuserid = ? ");
        paramList.add(userId);
        return (Set)DB.query((DBRoute)DBRoute.permission, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]), (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> set = new HashSet<Long>(8);
                while (rs.next()) {
                    set.add(rs.getLong("fusergroupid"));
                }
                return set;
            }
        });
    }

    public static Map<Long, Set<UserFieldPermScheme>> getFpsUserMap(Set<Long> fpdIdSet) {
        if (null == fpdIdSet || fpdIdSet.isEmpty()) {
            return new HashMap<Long, Set<UserFieldPermScheme>>(1);
        }
        HashMap<Long, Set<UserFieldPermScheme>> map = new HashMap<Long, Set<UserFieldPermScheme>>(8);
        ArrayList<String> paramList = new ArrayList<String>(8);
        StringBuilder sb = new StringBuilder();
        sb.append(" select a.fuserid, a.ffieldpermschemeid, b.fnumber fpsNumber, c.fnumber userNum, c.ftruename cName, cL.ftruename cLName  ");
        sb.append("  from t_perm_userfieldscheme a ");
        sb.append(" inner join t_perm_fieldscheme b on b.fid = a.ffieldpermschemeid ");
        sb.append(" inner join t_sec_user c on c.fid = a.fuserid ");
        sb.append(" inner join t_sec_user_l cL on cL.fid = c.fid and cL.flocaleid=? ");
        Set collect = fpdIdSet.stream().map(String::valueOf).collect(Collectors.toSet());
        String fpdIdSetStr = String.join((CharSequence)",", collect);
        sb.append(" where a.ffieldpermschemeid in (").append(fpdIdSetStr).append(")");
        paramList.add(RequestContext.get().getLang().name());
        try (DataSet dataSet = DB.queryDataSet((String)"PermRoleHelper.getFpsComRoleIdSetMap", (DBRoute)DBRoute.basedata, (String)sb.toString(), (Object[])paramList.toArray(new Object[paramList.size()]));){
            UserFieldPermScheme one = null;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                one = new UserFieldPermScheme();
                one.setUserId(row.getLong("fuserid"));
                one.setUserNumber(row.getString("userNum"));
                String cName = row.getString("cName");
                String cLName = row.getString("cLName");
                one.setUserName(StringUtils.isEmpty((String)cLName) ? cName : cLName);
                one.setNumber(row.getString("fpsNumber"));
                map.computeIfAbsent(row.getLong("ffieldpermschemeid"), k -> new HashSet(8)).add(one);
            }
        }
        return map;
    }

    public static Map<Long, Set<UserFieldPermScheme>> getFpsSetMap(Set<Long> userIdSet) {
        if (null == userIdSet || userIdSet.isEmpty()) {
            return new HashMap<Long, Set<UserFieldPermScheme>>(1);
        }
        String userIdSetStr = userIdSet.stream().map(String::valueOf).collect(Collectors.joining(","));
        StringBuilder sb = new StringBuilder();
        sb.append("select a.fuserid, a.ffieldpermschemeid, a.fappid, a.fentnum, a.fdimtype, a.fdimid, a.fincludesub, b.fsensitive");
        sb.append(" from t_perm_userfieldscheme a");
        sb.append(" left join t_perm_fieldscheme b on b.fid = a.ffieldpermschemeid");
        sb.append(" where a.fuserid in (").append(userIdSetStr).append(") ");
        return (Map)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Map<Long, Set<UserFieldPermScheme>>>(){

            public Map<Long, Set<UserFieldPermScheme>> handle(ResultSet rs) throws Exception {
                HashMap<Long, Set<UserFieldPermScheme>> map = new HashMap<Long, Set<UserFieldPermScheme>>(8);
                UserFieldPermScheme one = null;
                while (rs.next()) {
                    Long fuserid = rs.getLong("fuserid");
                    one = new UserFieldPermScheme();
                    one.setUserId(fuserid);
                    one.setId(Long.valueOf(rs.getLong("ffieldpermschemeid")));
                    one.setAppId(rs.getString("fappid"));
                    one.setEntityNumber(rs.getString("fentnum"));
                    one.setDimType(rs.getString("fdimtype"));
                    one.setDimId(Long.valueOf(rs.getLong("fdimid")));
                    one.setIncludeSub(rs.getString("fincludesub"));
                    one.setSensitive(rs.getString("fsensitive"));
                    map.computeIfAbsent(fuserid, k -> new HashSet()).add(one);
                }
                return map;
            }
        });
    }

    public static Set<String> getEditingPermUserId() {
        String key;
        String type = CacheMrg.getType4EditingPermUserId();
        String str = CacheMrg.getCache(type, key = "ids");
        if (StringUtils.isNotEmpty((String)str)) {
            return (Set)SerializationUtils.fromJsonString((String)str, Set.class);
        }
        return new HashSet<String>(1);
    }

    public static void addEditingPermUserId(List<String> userIds) {
        if (null == userIds) {
            userIds = new ArrayList<String>(1);
        }
        Set<String> collect = UserHelper.getEditingPermUserId();
        collect.addAll(new HashSet<String>(userIds));
        String type = CacheMrg.getType4EditingPermUserId();
        String key = "ids";
        CacheMrg.putCache(type, key, SerializationUtils.toJsonString(collect));
    }

    public static void delEditingPermUserId(List<String> delUserIds) {
        if (null == delUserIds) {
            delUserIds = new ArrayList<String>(1);
        }
        Set<String> ori = UserHelper.getEditingPermUserId();
        Sets.SetView leaved = Sets.difference(ori, new HashSet<String>(delUserIds));
        String type = CacheMrg.getType4EditingPermUserId();
        String key = "ids";
        CacheMrg.putCache(type, key, SerializationUtils.toJsonString((Object)leaved));
    }

    public static Map<Long, Boolean> getUserEnableMap(Set<Long> userIdSet) {
        try {
            final int size = userIdSet.size();
            if (0 == size) {
                return new HashMap<Long, Boolean>(1);
            }
            int m = SqlUtil.getBatchCount(PermHelperConst.CONST_200, size);
            final CountDownLatch countDownLatch = new CountDownLatch(m);
            LinkedList<Future> futureList = new LinkedList<Future>();
            ArrayList<Long> idList = new ArrayList<Long>(userIdSet);
            List<List<Long>> listAvg = ListUtil.averageAssign(idList, m);
            for (int i = 0; i < listAvg.size(); ++i) {
                final List<Long> idSchemes = listAvg.get(i);
                Future oneList = pool.submit((Callable)new Callable<Map<Long, Boolean>>(){

                    @Override
                    public Map<Long, Boolean> call() throws Exception {
                        try {
                            QFilter uFilter = new QFilter("id", "in", (Object)idSchemes);
                            Map bos_userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)" enable", (QFilter[])new QFilter[]{uFilter});
                            HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(size);
                            for (Map.Entry partOne : bos_userMap.entrySet()) {
                                DynamicObject value = (DynamicObject)partOne.getValue();
                                if (null == value) continue;
                                map.put((Long)partOne.getKey(), value.getBoolean("enable"));
                            }
                            HashMap<Long, Boolean> hashMap = map;
                            return hashMap;
                        }
                        catch (Exception e) {
                            logger.warn("UserHelper.getUserEnableMap.call error.", (Throwable)e);
                            throw new KDBizException(new ErrorCode("0", "UserHelper.getUserEnableMap.call error."), new Object[0]);
                        }
                        finally {
                            if (null != countDownLatch) {
                                countDownLatch.countDown();
                            }
                        }
                    }
                });
                futureList.add(oneList);
            }
            countDownLatch.await();
            HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(size);
            for (Future listFuture : futureList) {
                Map part = (Map)listFuture.get();
                map.putAll(part);
            }
            return map;
        }
        catch (Exception e) {
            logger.warn("UserHelper.getUserEnableMap error", (Throwable)e);
            return new HashMap<Long, Boolean>(1);
        }
    }

    public static Map<String, Set<User>> getUserMap(Set<String> idOrNumberOrTrueNameSet, String keyType) {
        HashMap<String, Set<User>> map = new HashMap<String, Set<User>>(8);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (null != idOrNumberOrTrueNameSet && !idOrNumberOrTrueNameSet.isEmpty() && Objects.equals("id", keyType)) {
            qFilterList.add(new QFilter("id", "in", idOrNumberOrTrueNameSet.stream().map(Long::valueOf).collect(Collectors.toSet())));
        }
        if (null != idOrNumberOrTrueNameSet && !idOrNumberOrTrueNameSet.isEmpty() && Objects.equals("number", keyType)) {
            qFilterList.add(new QFilter("number", "in", idOrNumberOrTrueNameSet));
        }
        if (null != idOrNumberOrTrueNameSet && !idOrNumberOrTrueNameSet.isEmpty() && Objects.equals("name", keyType)) {
            qFilterList.add(new QFilter("name", "in", idOrNumberOrTrueNameSet));
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"UserHelper.getUserMap", (String)"bos_user", (String)"id, number, name", (QFilter[])qFilterList.toArray(new QFilter[qFilterList.size()]), (String)"");){
            User one = null;
            while (ds.hasNext()) {
                Row row = ds.next();
                one = new User();
                Long id = row.getLong("id");
                String number = row.getString("number");
                String name = row.getString("name");
                one.setFid(id);
                one.setFnumber(number);
                one.setFtruename(name);
                if (Objects.equals("id", keyType)) {
                    map.computeIfAbsent(String.valueOf(id), k -> new HashSet()).add(one);
                }
                if (Objects.equals("name", keyType)) {
                    map.computeIfAbsent(name, k -> new HashSet()).add(one);
                    continue;
                }
                if (!Objects.equals("number", keyType)) continue;
                map.computeIfAbsent(number, k -> new HashSet()).add(one);
            }
        }
        return map;
    }

    public static List<QFilter> getUserF7QfilterList(boolean lspFilter, Boolean isOrgBaseAdmin, String externalUserType, Set<Long> excludeUserIdSet, boolean excludeSelf, Set<String> enableSet, Set<String> forbiddenSet, Set<String> userTypeNotInSet) {
        ArrayList<QFilter> rangeFilterList = new ArrayList<QFilter>(10);
        HashSet<Long> filterUserIds = null == excludeUserIdSet ? new HashSet<Long>(8) : excludeUserIdSet;
        long currUserId = RequestContext.get().getCurrUserId();
        if (excludeSelf) {
            filterUserIds.add(currUserId);
        }
        if (kd.bos.util.CollectionUtils.isNotEmpty(filterUserIds)) {
            rangeFilterList.add(new QFilter("id", "not in", filterUserIds));
        }
        if (null != enableSet && !enableSet.isEmpty()) {
            rangeFilterList.add(new QFilter("enable", "in", enableSet));
        }
        if (null != forbiddenSet && !forbiddenSet.isEmpty()) {
            rangeFilterList.add(new QFilter("isforbidden", "in", forbiddenSet));
        }
        if (null != userTypeNotInSet && !userTypeNotInSet.isEmpty()) {
            rangeFilterList.add(new QFilter("usertype", "not in", userTypeNotInSet));
        }
        if (lspFilter) {
            QFilter adminChargeUsersFilter;
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
            if (null != isOrgBaseAdmin) {
                lsp.setCustomParam("isOrgBaseAdmin", (Object)isOrgBaseAdmin);
            }
            if (StringUtils.isNotEmpty((String)externalUserType)) {
                lsp.setCustomParam("externalUserType", (Object)externalUserType);
            }
            if (null != (adminChargeUsersFilter = UserUtils.getAdminChargeUsersFilter((long)currUserId, (ListShowParameter)lsp, null))) {
                rangeFilterList.add(adminChargeUsersFilter);
            }
        }
        return rangeFilterList;
    }

    public static Set<PermUser> getF7Users(boolean lspFilter, Boolean isOrgBaseAdmin, String externalUserType, Set<Long> excludeUserIdSet, boolean excludeSelf, Set<String> enableSet, Set<String> forbiddenSet, Set<String> userTypeNotInSet) {
        HashSet<PermUser> resultSet = new HashSet<PermUser>(8);
        List<QFilter> userF7Qfilter = UserHelper.getUserF7QfilterList(lspFilter, isOrgBaseAdmin, externalUserType, excludeUserIdSet, excludeSelf, enableSet, forbiddenSet, userTypeNotInSet);
        if (null == userF7Qfilter || userF7Qfilter.isEmpty()) {
            return resultSet;
        }
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"UserHelper.getF7Users", (String)"bos_user", (String)"id, name, number", (QFilter[])userF7Qfilter.toArray(userF7Qfilter.toArray(new QFilter[userF7Qfilter.size()])), (String)"");){
            PermUser one = null;
            while (ds.hasNext()) {
                Row row = ds.next();
                one = new PermUser(row.getLong("id"), row.getString("number"), row.getString("name"));
                resultSet.add(one);
            }
        }
        return resultSet;
    }
}

