/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.helper.callable;

import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.helper.UserHelper;
import kd.bos.permission.cache.model.User;

public class GetUserByIds
implements Callable {
    private static Log logger = LogFactory.getLog(GetUserByIds.class);
    private Set<Long> userIds;
    private CountDownLatch countDownLatch;
    private String langStr;

    public GetUserByIds(Set<Long> userIds, CountDownLatch countDownLatch, String langStr) {
        this.userIds = userIds;
        this.countDownLatch = countDownLatch;
        this.langStr = langStr;
    }

    public Object call() throws Exception {
        try {
            List<User> list = UserHelper.getUserInfoByIds(this.userIds, this.langStr);
            return list;
        }
        catch (Exception e) {
            logger.warn("GetUserByIds.call error.", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", "GetUserByIds.call error."), new Object[0]);
        }
        finally {
            if (null != this.countDownLatch) {
                this.countDownLatch.countDown();
            }
        }
    }
}

