/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.model;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class CustomPermServInfo {
    private String servAppNum = "";
    private String serviceFactory = "";
    private String serviceName = "";
    private String methodName = "";
    private boolean skipPlatformImp = false;
    private boolean and = false;
    private String appId = "";
    private String appNum = "";
    private String cloudNumLowerCase = "";
    private Long scenarioid = 0L;
    private static final Log logger = LogFactory.getLog(CustomPermServInfo.class);

    public String getCloudNumLowerCase() {
        return this.cloudNumLowerCase;
    }

    public void setCloudNumLowerCase(String cloudNumLowerCase) {
        this.cloudNumLowerCase = cloudNumLowerCase;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Long getScenarioid() {
        return this.scenarioid;
    }

    public void setScenarioid(Long scenarioid) {
        this.scenarioid = scenarioid;
    }

    public String getServAppNum() {
        return this.servAppNum;
    }

    public void setServAppNum(String servAppNum) {
        this.servAppNum = servAppNum;
    }

    public String getAppNum() {
        return this.appNum;
    }

    public void setAppNum(String appNum) {
        this.appNum = appNum;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(String serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public boolean isSkipPlatformImp() {
        return this.skipPlatformImp;
    }

    public void setSkipPlatformImp(boolean isSkipPlatformImp) {
        this.skipPlatformImp = isSkipPlatformImp;
    }

    public boolean isAnd() {
        return this.and;
    }

    public void setAnd(boolean isAnd) {
        this.and = isAnd;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public static CustomPermServInfo getCustPermServInfo(String appId, Map<String, Object> customParam) {
        if (StringUtils.isEmpty((String)appId)) {
            return null;
        }
        String customPermServTypeKey = CacheMrg.getCustomPermServ();
        String key = String.format("%s%s", customPermServTypeKey, appId);
        Map threadCacheMap = (Map)ThreadCache.get((Object)key, () -> {
            HashMap<String, CustomPermServInfo> map = new HashMap<String, CustomPermServInfo>(8);
            CustomPermServInfo customPermServInfo = CustomPermServInfo.getCustomPermServInfo(appId, customPermServTypeKey);
            if (null == customPermServInfo) {
                return map;
            }
            map.put("custompermservinfo", customPermServInfo);
            return map;
        });
        return (CustomPermServInfo)threadCacheMap.get("custompermservinfo");
    }

    private static CustomPermServInfo getCustomPermServInfo(String appId, String customPermServTypeKey) {
        Map loadFromCache = null;
        String cacheValue = CacheMrg.getCache(customPermServTypeKey, appId);
        if ("PERM_DATA_LOADED".equals(cacheValue)) {
            return null;
        }
        if (StringUtils.isEmpty((String)cacheValue)) {
            try {
                String cloudNum;
                DynamicObject cloudObj;
                DynamicObject appDObj;
                loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"perm_custompermserv", (QFilter[])new QFilter[]{new QFilter("app", "=", (Object)appId)});
                if (CollectionUtils.isEmpty((Map)loadFromCache)) {
                    CustomPermServInfo cpsi = (CustomPermServInfo)DB.query((DBRoute)DBRoute.basedata, (String)"select fid,fservfactory,fservname,fisskip,fisand,fappid,fservappnum from t_perm_custpermserv where fappid = ' ' and fscenarioid = 0 ", (ResultSetHandler)new ResultSetHandler<CustomPermServInfo>(){

                        public CustomPermServInfo handle(ResultSet rs) throws Exception {
                            CustomPermServInfo cpsi = null;
                            if (rs.next()) {
                                cpsi = new CustomPermServInfo();
                                cpsi.setServiceFactory(rs.getString("fservfactory"));
                                cpsi.setServiceName(rs.getString("fservname"));
                                cpsi.setSkipPlatformImp(rs.getBoolean("fisskip"));
                                cpsi.setAnd(rs.getBoolean("fisand"));
                                cpsi.setServAppNum(rs.getString("fservappnum"));
                            }
                            return cpsi;
                        }
                    });
                    if (cpsi == null) {
                        CacheMrg.putCache(customPermServTypeKey, appId, "PERM_DATA_LOADED");
                        return null;
                    }
                    CacheMrg.putCache(customPermServTypeKey, appId, SerializationUtils.toJsonString((Object)cpsi));
                    return cpsi;
                }
                CustomPermServInfo cpsi = new CustomPermServInfo();
                DynamicObject dObj = (DynamicObject)loadFromCache.values().iterator().next();
                cpsi.setServiceFactory(dObj.getString("servfactory"));
                cpsi.setServiceName(dObj.getString("servname"));
                cpsi.setAppId(appId);
                DynamicObject appObj = dObj.getDynamicObject("app");
                if (appObj != null) {
                    cpsi.setAppNum(appObj.getString("number"));
                }
                cpsi.setSkipPlatformImp(dObj.getBoolean("isskip"));
                cpsi.setAnd(dObj.getBoolean("isand"));
                String servAppNum = dObj.getString("servapp");
                DynamicObject[] appDobjArr = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"bizcloud", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)servAppNum)});
                if (appDobjArr != null && appDobjArr.length > 0 && (appDObj = appDobjArr[0]) != null && (cloudObj = appDObj.getDynamicObject("bizcloud")) != null && StringUtils.isNotEmpty((String)(cloudNum = cloudObj.getString("number")))) {
                    cpsi.setCloudNumLowerCase(cloudNum.toLowerCase());
                }
                cpsi.setServAppNum(servAppNum);
                CacheMrg.putCache(customPermServTypeKey, appId, SerializationUtils.toJsonString((Object)cpsi));
                return cpsi;
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        CustomPermServInfo cpsi = null;
        try {
            cpsi = (CustomPermServInfo)SerializationUtils.fromJsonString((String)cacheValue, CustomPermServInfo.class);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
        return cpsi;
    }

    public static CustomPermServInfo getCustPermServInfo(Long pScenarioId) {
        if (pScenarioId == null || pScenarioId == 0L) {
            return null;
        }
        Object loadFromCache = null;
        String customPermServTypeKey = CacheMrg.getCustomPermServ();
        String cacheValue = CacheMrg.getCache(customPermServTypeKey, String.valueOf(pScenarioId));
        if ("PERM_DATA_LOADED".equals(cacheValue)) {
            return null;
        }
        if (StringUtils.isEmpty((String)cacheValue)) {
            try {
                CustomPermServInfo cpsi = (CustomPermServInfo)DB.query((DBRoute)DBRoute.basedata, (String)"select fid,fservappnum,fservfactory,fservname,fmethodname,fscenarioid from t_perm_custpermserv where fscenarioid = 1 ", (ResultSetHandler)new ResultSetHandler<CustomPermServInfo>(){

                    public CustomPermServInfo handle(ResultSet rs) throws Exception {
                        CustomPermServInfo cpsi = null;
                        if (rs.next()) {
                            cpsi = new CustomPermServInfo();
                            cpsi.setServAppNum(rs.getString("fservappnum"));
                            cpsi.setServiceFactory(rs.getString("fservfactory"));
                            cpsi.setServiceName(rs.getString("fservname"));
                            cpsi.setMethodName(rs.getString("fmethodname"));
                            cpsi.setScenarioid(rs.getLong("fscenarioid"));
                        }
                        return cpsi;
                    }
                });
                if (cpsi == null) {
                    CacheMrg.putCache(customPermServTypeKey, String.valueOf(pScenarioId), "PERM_DATA_LOADED");
                    return null;
                }
                CacheMrg.putCache(customPermServTypeKey, String.valueOf(pScenarioId), SerializationUtils.toJsonString((Object)cpsi));
                return cpsi;
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        CustomPermServInfo cpsi = null;
        try {
            cpsi = (CustomPermServInfo)SerializationUtils.fromJsonString((String)cacheValue, CustomPermServInfo.class);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
        return cpsi;
    }
}

