/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class PermUserRole
implements Serializable {
    private static final long serialVersionUID = -2727031167544961076L;
    private static final Log log = LogFactory.getLog(PermUserRole.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_PermUserRole_Pool", (int)2);
    private String fid;
    private Long forgid;
    private Long fuserid;
    private String froleid;
    private String fisincludesuborg;
    private String fsource;
    private String fdimtype;
    private Date fstarttime;
    private Date fendtime;

    public PermUserRole() {
    }

    public PermUserRole(Long fuserid) {
        this.fuserid = fuserid;
    }

    public PermUserRole(Long forgid, String fisincludesuborg) {
        this.forgid = forgid;
        this.fisincludesuborg = fisincludesuborg;
    }

    public PermUserRole(Long fuserid, Date fstarttime, Date fendtime) {
        this.fuserid = fuserid;
        this.fstarttime = fstarttime;
        this.fendtime = fendtime;
    }

    public PermUserRole(Long forgid, Long fuserid, String froleid, String fisincludesuborg, String fdimtype) {
        this.forgid = forgid;
        this.fuserid = fuserid;
        this.froleid = froleid;
        this.fisincludesuborg = fisincludesuborg;
        this.fdimtype = fdimtype;
    }

    public PermUserRole(String fid, Long forgid, Long fuserid, String fisincludesuborg, Date fstarttime, Date fendtime) {
        this.fid = fid;
        this.forgid = forgid;
        this.fuserid = fuserid;
        this.fisincludesuborg = fisincludesuborg;
        this.fstarttime = fstarttime;
        this.fendtime = fendtime;
    }

    public PermUserRole(String fid, Long forgid, Long fuserid, String froleid, String fisincludesuborg, String fdimtype, Date fstarttime, Date fendtime) {
        this.fid = fid;
        this.forgid = forgid;
        this.fuserid = fuserid;
        this.froleid = froleid;
        this.fisincludesuborg = fisincludesuborg;
        this.fdimtype = fdimtype;
        this.fstarttime = fstarttime;
        this.fendtime = fendtime;
    }

    public PermUserRole(String fid, Long forgid, Long fuserid, String froleid, String fisincludesuborg, String fsource, String fdimtype, Date fstarttime, Date fendtime) {
        this.fid = fid;
        this.forgid = forgid;
        this.fuserid = fuserid;
        this.froleid = froleid;
        this.fisincludesuborg = fisincludesuborg;
        this.fsource = fsource;
        this.fdimtype = fdimtype;
        this.fstarttime = fstarttime;
        this.fendtime = fendtime;
    }

    public static PermUserRole userrole2pur(DynamicObject dyn) {
        Boolean includeSub = dyn.getBoolean("includesuborg");
        String includeSubStr = null == includeSub || Boolean.FALSE.equals(includeSub) ? "0" : "1";
        return new PermUserRole(dyn.getString("id"), dyn.getLong("itemclass_id"), dyn.getLong("user_id"), dyn.getString("role_id"), includeSubStr, dyn.getString("source"), dyn.getString("itemclasstypefield"), dyn.getDate("starttime"), dyn.getDate("endtime"));
    }

    public static Map<String, Object> logCompareMutiThread(List<PermUserRole> preList, List<PermUserRole> afterList) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("del", new LinkedList());
        map.put("add", new LinkedList());
        map.put("update", new LinkedList());
        try {
            HashMap<String, Set> dimTypeDimIdSetMap = new HashMap<String, Set>(8);
            for (PermUserRole one : preList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getFdimtype(), k -> new HashSet(8)).add(one.getForgid());
            }
            for (PermUserRole one : afterList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getFdimtype(), k -> new HashSet(8)).add(one.getForgid());
            }
            if (null == dimTypeDimIdSetMap || dimTypeDimIdSetMap.isEmpty()) {
                return map;
            }
            List del = (List)map.get("del");
            List add = (List)map.get("add");
            List update = (List)map.get("update");
            for (Map.Entry dimTypeDimIdSet : dimTypeDimIdSetMap.entrySet()) {
                Set dimIdSet = (Set)dimTypeDimIdSet.getValue();
                int m = SqlUtil.getBatchCount(2, dimIdSet.size());
                ArrayList<Future> futureList = new ArrayList<Future>(m);
                List listAvg = ListUtil.averageAssign(new ArrayList(dimIdSet), m);
                for (int i = 0; i < listAvg.size(); ++i) {
                    List oneThreadList = listAvg.get(i);
                    List<PermUserRole> oneThreadPreList = preList.stream().filter(x -> oneThreadList.contains(x.getForgid())).collect(Collectors.toList());
                    List<PermUserRole> oneThreadAfterList = afterList.stream().filter(x -> oneThreadList.contains(x.getForgid())).collect(Collectors.toList());
                    futureList.add(pool.submit(PermUserRole.diff(oneThreadPreList, oneThreadAfterList)));
                }
                if (CollectionUtils.isEmpty(futureList)) continue;
                for (Future future : futureList) {
                    try {
                        Map futureMap = (Map)future.get();
                        List futureDel = (List)futureMap.get("del");
                        List futureAdd = (List)futureMap.get("add");
                        List futureUpdate = (List)futureMap.get("update");
                        del.addAll(futureDel);
                        add.addAll(futureAdd);
                        update.addAll(futureUpdate);
                    }
                    catch (Exception e) {
                        log.warn("PermUserRole.logCompareMutiThread --> error, preList:{}, afterList:{}", new Object[]{preList, afterList, e});
                        throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
                    }
                }
            }
            return map;
        }
        catch (Exception e) {
            log.warn("PermUserRole.logCompareMutiThread --> error, fid:{}, preList:{}, afterList:{}", new Object[]{preList, afterList, e});
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private static Callable<Map<String, List<PermUserRole>>> diff(final List<PermUserRole> preList, final List<PermUserRole> afterList) {
        return new Callable<Map<String, List<PermUserRole>>>(){

            @Override
            public Map<String, List<PermUserRole>> call() throws Exception {
                try {
                    return PermUserRole.logCompare(preList, afterList);
                }
                catch (Exception ex) {
                    log.warn("PermUserRole.diff --> error, preList:{}, afterList:{}", new Object[]{preList, afterList, ex});
                    throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
                }
            }
        };
    }

    public static Map<String, List<PermUserRole>> logCompare(List<PermUserRole> preList, List<PermUserRole> afterList) {
        HashMap<String, List<PermUserRole>> map = new HashMap<String, List<PermUserRole>>(3);
        List<PermUserRole> delList = ListUtil.removeAll(preList, afterList);
        List<PermUserRole> addList = ListUtil.removeAll(afterList, preList);
        map.put("del", delList);
        map.put("add", addList);
        map.put("update", new LinkedList());
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermUserRole that = (PermUserRole)o;
        return Objects.equals(this.forgid, that.forgid) && Objects.equals(this.fuserid, that.fuserid) && Objects.equals(this.froleid, that.froleid) && Objects.equals(this.fisincludesuborg, that.fisincludesuborg) && Objects.equals(this.fdimtype, that.fdimtype) && Objects.equals(this.fstarttime, that.fstarttime) && Objects.equals(this.fendtime, that.fendtime);
    }

    public int hashCode() {
        return Objects.hash(this.forgid, this.fuserid, this.froleid, this.fisincludesuborg, this.fdimtype, this.fstarttime, this.fendtime);
    }

    public String getFid() {
        return this.fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public Long getForgid() {
        return this.forgid;
    }

    public void setForgid(Long forgid) {
        this.forgid = forgid;
    }

    public Long getFuserid() {
        return this.fuserid;
    }

    public void setFuserid(Long fuserid) {
        this.fuserid = fuserid;
    }

    public String getFroleid() {
        return this.froleid;
    }

    public void setFroleid(String froleid) {
        this.froleid = froleid;
    }

    public String getFisincludesuborg() {
        return this.fisincludesuborg;
    }

    public void setFisincludesuborg(String fisincludesuborg) {
        this.fisincludesuborg = fisincludesuborg;
    }

    public String getFsource() {
        return this.fsource;
    }

    public void setFsource(String fsource) {
        this.fsource = fsource;
    }

    public String getFdimtype() {
        return this.fdimtype;
    }

    public void setFdimtype(String fdimtype) {
        this.fdimtype = fdimtype;
    }

    public Date getFstarttime() {
        return this.fstarttime;
    }

    public void setFstarttime(Date fstarttime) {
        this.fstarttime = fstarttime;
    }

    public Date getFendtime() {
        return this.fendtime;
    }

    public void setFendtime(Date fendtime) {
        this.fendtime = fendtime;
    }
}

