/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.ListUtil;
import kd.bos.permission.model.perm.DataChangeType;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class UgRoleDim
extends DataChangeType
implements Serializable {
    private static final long serialVersionUID = 7099052672247157957L;
    private static final Log log = LogFactory.getLog(UgRoleDim.class);
    private static ThreadPool pool = ThreadPools.newFixedThreadPool((String)"Permission_UgRoleDim_Pool", (int)1);
    private Long usrGrpId;
    private String usrGrpName;
    private String usrGrpNumber;
    private String roleId;
    private String roleName;
    private String roleNumber;
    private Long dimId;
    private String dimName;
    private String dimNumber;
    private String includeSub;
    private String includeSubDesc;
    private String dimType;
    private String dimTypeDesc;
    private Date starttime;
    private Date endtime;

    public static Map<String, Object> logCompareMutiThread(List<UgRoleDim> preList, List<UgRoleDim> afterList) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("del", new LinkedList());
        map.put("add", new LinkedList());
        map.put("update", new LinkedList());
        try {
            HashMap<String, Set> dimTypeDimIdSetMap = new HashMap<String, Set>(8);
            for (UgRoleDim one : preList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            for (UgRoleDim one : afterList) {
                dimTypeDimIdSetMap.computeIfAbsent(one.getDimType(), k -> new HashSet(8)).add(one.getDimId());
            }
            if (null == dimTypeDimIdSetMap || dimTypeDimIdSetMap.isEmpty()) {
                return map;
            }
            List del = (List)map.get("del");
            List add = (List)map.get("add");
            List update = (List)map.get("update");
            for (Map.Entry dimTypeDimIdSet : dimTypeDimIdSetMap.entrySet()) {
                List<UgRoleDim> oneThreadAfterList;
                List<UgRoleDim> oneThreadPreList;
                ArrayList oneThreadList;
                Set dimIdSet = (Set)dimTypeDimIdSet.getValue();
                Iterator iterator = dimIdSet.iterator();
                int i = 1;
                int oneThreadDeal = 15;
                ArrayList list = new ArrayList(oneThreadDeal);
                ArrayList<Future> futureList = new ArrayList<Future>(dimIdSet.size() / oneThreadDeal + 1);
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                    if ((i & oneThreadDeal) == 0) {
                        oneThreadList = list;
                        oneThreadPreList = preList.stream().filter(x -> oneThreadList.contains(x.getDimId())).collect(Collectors.toList());
                        oneThreadAfterList = afterList.stream().filter(x -> oneThreadList.contains(x.getDimId())).collect(Collectors.toList());
                        futureList.add(pool.submit(UgRoleDim.diff(oneThreadPreList, oneThreadAfterList)));
                        list.clear();
                    }
                    ++i;
                }
                if (!CollectionUtils.isEmpty(list)) {
                    oneThreadList = list;
                    oneThreadPreList = preList.stream().filter(x -> oneThreadList.contains(x.getDimId())).collect(Collectors.toList());
                    oneThreadAfterList = afterList.stream().filter(x -> oneThreadList.contains(x.getDimId())).collect(Collectors.toList());
                    futureList.add(pool.submit(UgRoleDim.diff(oneThreadPreList, oneThreadAfterList)));
                }
                if (CollectionUtils.isEmpty(futureList)) continue;
                for (Future future : futureList) {
                    try {
                        Map futureMap = (Map)future.get();
                        List futureDel = (List)futureMap.get("del");
                        List futureAdd = (List)futureMap.get("add");
                        List futureUpdate = (List)futureMap.get("update");
                        del.addAll(futureDel);
                        add.addAll(futureAdd);
                        update.addAll(futureUpdate);
                    }
                    catch (Exception e) {
                        log.warn("UsrGrpRole.logCompareMutiThread --> error, preList:{}, afterList:{}", new Object[]{preList, afterList, e});
                        throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
                    }
                }
            }
            return map;
        }
        catch (Exception e) {
            log.warn("UsrGrpRole.logCompareMutiThread --> error, fid:{}, preList:{}, afterList:{}", new Object[]{preList, afterList, e});
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private static Callable<Map<String, List<UgRoleDim>>> diff(final List<UgRoleDim> preList, final List<UgRoleDim> afterList) {
        return new Callable<Map<String, List<UgRoleDim>>>(){

            @Override
            public Map<String, List<UgRoleDim>> call() throws Exception {
                try {
                    return UgRoleDim.logCompare(preList, afterList);
                }
                catch (Exception ex) {
                    log.warn("UsrGrpRole.diff --> error, preList:{}, afterList:{}", new Object[]{preList, afterList, ex});
                    throw new KDBizException(new ErrorCode("0", ex.getMessage()), new Object[0]);
                }
            }
        };
    }

    public static Map<String, List<UgRoleDim>> logCompare(List<UgRoleDim> preList, List<UgRoleDim> afterList) {
        HashMap<String, List<UgRoleDim>> map = new HashMap<String, List<UgRoleDim>>(3);
        List<UgRoleDim> delList = ListUtil.removeAll(preList, afterList);
        List<UgRoleDim> addList = ListUtil.removeAll(afterList, preList);
        map.put("del", delList);
        map.put("add", addList);
        map.put("update", new LinkedList());
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UgRoleDim ugRoleDim = (UgRoleDim)o;
        return Objects.equals(this.usrGrpId, ugRoleDim.usrGrpId) && Objects.equals(this.roleId, ugRoleDim.roleId) && Objects.equals(this.dimId, ugRoleDim.dimId) && Objects.equals(this.includeSub, ugRoleDim.includeSub) && Objects.equals(this.dimType, ugRoleDim.dimType) && Objects.equals(this.starttime, ugRoleDim.starttime) && Objects.equals(this.endtime, ugRoleDim.endtime);
    }

    public int hashCode() {
        return Objects.hash(this.usrGrpId, this.roleId, this.dimId, this.includeSub, this.dimType, this.starttime, this.endtime);
    }

    public Long getUsrGrpId() {
        return this.usrGrpId;
    }

    public void setUsrGrpId(Long usrGrpId) {
        this.usrGrpId = usrGrpId;
    }

    public String getUsrGrpName() {
        return this.usrGrpName;
    }

    public void setUsrGrpName(String usrGrpName) {
        this.usrGrpName = usrGrpName;
    }

    public String getUsrGrpNumber() {
        return this.usrGrpNumber;
    }

    public void setUsrGrpNumber(String usrGrpNumber) {
        this.usrGrpNumber = usrGrpNumber;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleNumber() {
        return this.roleNumber;
    }

    public void setRoleNumber(String roleNumber) {
        this.roleNumber = roleNumber;
    }

    public Long getDimId() {
        return this.dimId;
    }

    public void setDimId(Long dimId) {
        this.dimId = dimId;
    }

    public String getDimName() {
        return this.dimName;
    }

    public void setDimName(String dimName) {
        this.dimName = dimName;
    }

    public String getDimNumber() {
        return this.dimNumber;
    }

    public void setDimNumber(String dimNumber) {
        this.dimNumber = dimNumber;
    }

    public String getIncludeSub() {
        return this.includeSub;
    }

    public void setIncludeSub(String includeSub) {
        this.includeSub = includeSub;
    }

    public String getIncludeSubDesc() {
        return this.includeSubDesc;
    }

    public void setIncludeSubDesc(String includeSubDesc) {
        this.includeSubDesc = includeSubDesc;
    }

    public String getDimType() {
        return this.dimType;
    }

    public void setDimType(String dimType) {
        this.dimType = dimType;
    }

    public String getDimTypeDesc() {
        return this.dimTypeDesc;
    }

    public void setDimTypeDesc(String dimTypeDesc) {
        this.dimTypeDesc = dimTypeDesc;
    }

    public Date getStarttime() {
        return this.starttime;
    }

    public void setStarttime(Date starttime) {
        this.starttime = starttime;
    }

    public Date getEndtime() {
        return this.endtime;
    }

    public void setEndtime(Date endtime) {
        this.endtime = endtime;
    }
}

