/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.util.StringUtils;

public class ChoiceFieldPageCustomQuery {
    private static Log logger = LogFactory.getLog(ChoiceFieldPageCustomQuery.class);
    private BlockingDeque<IDataEntityProperty> propertyStack = new LinkedBlockingDeque<IDataEntityProperty>();
    private static final String QUERY_ENTITYTYPE_FLAG = "isQueryEntityType";
    private static final String JOINPROP_FLAG = "isJoinProp";
    private static final String ENTITYPROP_FLAG = "isEntityProp";
    private boolean isMainEntity = true;
    private String joinEntityName = "";
    private String joinEntityNum = "";

    public List<Map<String, String>> executeQuery(String entityNum) {
        entityNum = FormMetadataCache.getFormConfig((String)entityNum).getEntityTypeId();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        return this.parseProperty((IDataEntityType)mainEntityType);
    }

    private String getIdByNumber(String number, MetaCategory category) {
        MetadataReader reader = new MetadataReader();
        return reader.loadIdByNumber(number, category);
    }

    public List<Map<String, String>> parseProperty(IDataEntityType entityType, List<String> selectedIDs, Map<String, Object> formViewCustomParam, String filter) {
        MainEntityType mainEntityType;
        Map map;
        String name;
        String key;
        HashMap<String, Object> properties;
        DataEntityPropertyCollection propertyCollection;
        boolean isSingleOrg = PermCommonUtil.isSingleOrg();
        if (formViewCustomParam == null) {
            formViewCustomParam = new HashMap<String, Object>(16);
        }
        boolean billTypePropShow = false;
        Object billTypePropShowObj = formViewCustomParam.get("BillTypePropShow");
        if (null != billTypePropShowObj) {
            String billTypePropShowStr = (String)billTypePropShowObj;
            boolean bl = billTypePropShow = Objects.equals("1", billTypePropShowStr);
        }
        if (entityType == null) {
            return Collections.emptyList();
        }
        if (entityType instanceof QueryEntityType) {
            formViewCustomParam.put(QUERY_ENTITYTYPE_FLAG, "true");
        }
        if ((propertyCollection = entityType.getProperties()) == null || propertyCollection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(propertyCollection.size());
        ArrayList<String> propertyfielddKeys = new ArrayList<String>(20);
        String entityNum = entityType.getName();
        for (IDataEntityProperty property : propertyCollection) {
            this.propertyStack.offerLast(property);
            if (!this.shouldSkip(property, formViewCustomParam)) {
                String orgFunc;
                propertyfielddKeys.add(property.getName());
                if (!(isSingleOrg && property instanceof OrgProp && !"01".equalsIgnoreCase(orgFunc = ((OrgProp)property).getOrgFunc()) || property instanceof BillTypeProp && !billTypePropShow)) {
                    List<Map<String, String>> subResult;
                    if (property instanceof EntryProp) {
                        EntryProp entryProp = (EntryProp)property;
                        EntryType entryType = (EntryType)entryProp.getItemType();
                        formViewCustomParam.put(ENTITYPROP_FLAG, "true");
                        subResult = this.parseProperty((IDataEntityType)entryType, selectedIDs, formViewCustomParam, null);
                        result.addAll(subResult);
                        if (null == formViewCustomParam.get(JOINPROP_FLAG)) {
                            formViewCustomParam.remove(ENTITYPROP_FLAG, "true");
                        }
                    } else if (property instanceof JoinProperty) {
                        JoinProperty joinProp = (JoinProperty)property;
                        IDataEntityType joinEntityType = joinProp.getComplexType();
                        this.joinEntityNum = joinEntityType.getName();
                        this.joinEntityName = joinEntityType.getDisplayName().toString();
                        formViewCustomParam.put(JOINPROP_FLAG, "true");
                        this.isMainEntity = false;
                        subResult = this.parseProperty(joinEntityType, selectedIDs, formViewCustomParam, null);
                        result.addAll(subResult);
                        this.joinEntityName = "";
                        this.joinEntityNum = "";
                        this.isMainEntity = true;
                        formViewCustomParam.remove(JOINPROP_FLAG, "true");
                    } else {
                        properties = new HashMap<String, Object>(2);
                        boolean isJoinProp = formViewCustomParam.get(JOINPROP_FLAG) != null;
                        key = this.getPropertyName(false, true, isJoinProp);
                        name = this.getPropertyName(true, true, isJoinProp);
                        if (!StringUtils.isEmpty((String)name) && (selectedIDs == null || selectedIDs.isEmpty() || selectedIDs.contains(key + "||" + name))) {
                            if (!this.isMainEntity) {
                                key = formViewCustomParam.get(QUERY_ENTITYTYPE_FLAG) != null && formViewCustomParam.get(ENTITYPROP_FLAG) != null && !Objects.equals(this.joinEntityNum, entityNum) ? this.joinEntityNum + '.' + entityNum + "." + key : entityNum + "." + key;
                            } else if (formViewCustomParam.get(QUERY_ENTITYTYPE_FLAG) != null && formViewCustomParam.get(ENTITYPROP_FLAG) != null) {
                                key = entityNum + "." + key;
                            }
                            properties.put("field_id", key);
                            properties.put("field_name", name);
                            if (this.ifShowBaseDataProp(formViewCustomParam)) {
                                Object propEntityNum = "";
                                if (property instanceof BasedataProp) {
                                    propEntityNum = ((BasedataProp)property).getBaseEntityId();
                                } else if (property instanceof RefBillProp) {
                                    propEntityNum = ((RefBillProp)property).getBillEntityId();
                                } else if (property instanceof MulBasedataProp) {
                                    propEntityNum = ((MulBasedataProp)property).getBaseEntityId();
                                }
                                properties.put("field_entityNum", propEntityNum);
                            }
                            result.add(properties);
                        }
                    }
                }
            }
            this.propertyStack.pollLast();
        }
        if (result.isEmpty()) {
            return result;
        }
        ArrayList<Object> fielddKeys = new ArrayList<Object>(result.size());
        for (Map map2 : result) {
            fielddKeys.add(map2.get("field_id"));
        }
        if (formViewCustomParam.get(QUERY_ENTITYTYPE_FLAG) == null) {
            String metadataId = this.getIdByNumber(entityNum, MetaCategory.Form);
            if (StringUtils.isEmpty((String)metadataId)) {
                return result;
            }
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)metadataId, (MetaCategory)MetaCategory.Entity);
            if (entityMetadata == null || entityMetadata.getItems() == null) {
                return result;
            }
            if (!this.ifShowBaseDataProp(formViewCustomParam)) {
                List items = entityMetadata.getItems();
                for (EntityItem entityField : items) {
                    properties = new HashMap(2);
                    if (!(entityField instanceof Field)) continue;
                    key = entityField.getKey();
                    name = entityField.getName().toString();
                    if (entityField instanceof BasedataPropField) {
                        BasedataPropField basedataPropField = (BasedataPropField)entityField;
                        String refBaseFieldId = basedataPropField.getRefBaseFieldId();
                        BasedataField basedataField = (BasedataField)entityMetadata.getFieldById(refBaseFieldId);
                        if (basedataField == null || fielddKeys.contains(key = basedataField.getKey() + '.' + basedataPropField.getRefDisplayProp()) || propertyfielddKeys.contains(key) || selectedIDs != null && !selectedIDs.isEmpty() && !selectedIDs.contains(key + "||" + name)) continue;
                        properties.put("field_id", key);
                        properties.put("field_name", name);
                        result.add(properties);
                        fielddKeys.add(key);
                        continue;
                    }
                    if (fielddKeys.contains(key) || propertyfielddKeys.contains(key) || selectedIDs != null && !selectedIDs.isEmpty() && !selectedIDs.contains(key + "||" + name)) continue;
                    properties.put("field_id", key);
                    properties.put("field_name", name);
                    result.add(properties);
                    fielddKeys.add(key);
                }
            }
        }
        if (formViewCustomParam.get(ENTITYPROP_FLAG) == null) {
            this.filterPropByStdBlackList(entityNum, result);
        }
        if (formViewCustomParam.get(ENTITYPROP_FLAG) == null && entityType instanceof MainEntityType && !CollectionUtils.isEmpty((Map)(map = EntityTypeUtil.getKeyFields((MainEntityType)(mainEntityType = (MainEntityType)entityType))))) {
            Collection values = map.values();
            HashSet<String> hiddenField = new HashSet<String>(16);
            for (String string : values) {
                String[] arr = string.split("\\.");
                hiddenField.add(arr[0]);
            }
            if (hiddenField.size() > 0) {
                boolean finalBillTypePropShow = billTypePropShow;
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    IDataEntityProperty pp;
                    Map data = (Map)iterator.next();
                    String entryFieldId = (String)data.get("field_id");
                    if (!hiddenField.contains(entryFieldId) || null != (pp = mainEntityType.findProperty(entryFieldId)) && pp instanceof BillTypeProp && finalBillTypePropShow) continue;
                    iterator.remove();
                }
            }
        }
        if (filter != null && !"1=1".equals(filter)) {
            Algo algo = Algo.create((String)"ChoiceFieldPageCustomQuery");
            ArrayList<kd.bos.algo.Field> arrayList = new ArrayList<kd.bos.algo.Field>(2);
            arrayList.add(new kd.bos.algo.Field("fieldid", (DataType)DataType.StringType));
            arrayList.add(new kd.bos.algo.Field("fieldnumber", (DataType)DataType.StringType));
            arrayList.add(new kd.bos.algo.Field("fieldEntNum", (DataType)DataType.StringType));
            RowMeta rowMeta = new RowMeta(arrayList.toArray(new kd.bos.algo.Field[0]));
            DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
            for (Map map3 : result) {
                builder.append(new Object[]{map3.get("field_id"), map3.get("field_name"), map3.get("field_entityNum")});
            }
            filter = filter.replace("ftlike", "like");
            Throwable throwable = null;
            try (DataSet dataset = builder.build();
                 DataSet dataset2 = dataset.filter(filter);){
                result.clear();
                for (Row row : dataset2) {
                    String fieldId = row.getString("fieldid");
                    String fieldNum = row.getString("fieldnumber");
                    String fieldEntNum = row.getString("fieldEntNum");
                    HashMap<String, String> map4 = new HashMap<String, String>(2);
                    map4.put("field_id", fieldId);
                    map4.put("field_name", fieldNum);
                    map4.put("field_entityNum", fieldEntNum);
                    result.add(map4);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        return result;
    }

    private void filterPropByStdBlackList(String entityNum, List<Map<String, String>> fieldInfos) {
        List<String> fieldKeysFromStdBlackList = PermCommonUtil.getFieldKeysFromStdBlackList(entityNum);
        Iterator<Map<String, String>> iter = fieldInfos.iterator();
        while (iter.hasNext()) {
            Map<String, String> fieldInfo = iter.next();
            String fieldKey = fieldInfo.get("field_id");
            if (!fieldKeysFromStdBlackList.contains(fieldKey)) continue;
            iter.remove();
        }
    }

    public List<Map<String, String>> parseProperty(IDataEntityType entityType, List<String> selectedIDs) {
        return this.parseProperty(entityType, selectedIDs, null, null);
    }

    public List<Map<String, String>> parseProperty(IDataEntityType entityType) {
        return this.parseProperty(entityType, null);
    }

    private boolean ifShowBaseDataProp(Map<String, Object> formViewCustomParam) {
        return formViewCustomParam != null && "true".equals((String)formViewCustomParam.get("param_ifShowBaseDataProp"));
    }

    private boolean shouldSkip(IDataEntityProperty property, Map<String, Object> formViewCustomParam) {
        boolean result;
        boolean bl = result = !DynamicProperty.class.isInstance(property) || PKFieldProp.class.isInstance(property) || "seq".equals(property.getName()) || "treeentryentity".equals(property.getName());
        if (result) {
            return true;
        }
        if (this.ifShowBaseDataProp(formViewCustomParam)) {
            if (property instanceof FlexProp) {
                return true;
            }
            if (!(property instanceof BasedataProp || property instanceof MulBasedataProp || property instanceof EntryProp || property instanceof RefBillProp)) {
                return true;
            }
        }
        return false;
    }

    private String getPropertyName(boolean displayName, boolean getSimpleId, boolean isJoinProp) {
        int lastIndex;
        Iterator<IDataEntityProperty> propertyIterator = this.propertyStack.iterator();
        StringBuilder propertyNameBuffer = new StringBuilder();
        int index = 0;
        while (propertyIterator.hasNext()) {
            LocaleString propertyLocaleDisplayName;
            DynamicProperty property = (DynamicProperty)propertyIterator.next();
            String propertyName = displayName ? ((propertyLocaleDisplayName = property.getDisplayName()) == null ? (isJoinProp && index == 0 ? this.joinEntityName : "") : propertyLocaleDisplayName.toString()) : property.getName();
            propertyNameBuffer.append(propertyName);
            if (propertyIterator.hasNext()) {
                propertyNameBuffer.append('.');
            }
            ++index;
        }
        String strPropertyName = propertyNameBuffer.toString();
        if (!displayName && getSimpleId && (lastIndex = strPropertyName.lastIndexOf(46)) != -1) {
            strPropertyName = strPropertyName.substring(lastIndex + 1, strPropertyName.length());
        }
        return strPropertyName;
    }
}

