/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.util.SqlUtil;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AdminSchemeDetailUpgradeUtil {
    private static final Log logger = LogFactory.getLog(AdminSchemeDetailUpgradeUtil.class);
    private static final List<Long> preSchemeIdList = Arrays.asList(586817719983145984L, 586840171824022528L);
    private static final String TABLE_T_PERM_ADMINSCHEMEDETAIL = "t_perm_adminschemedetail";
    private static final String PERM_ADMINSCHEME = "perm_adminscheme";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean upgrade(StringBuilder pProcessInfo) {
        if (null == pProcessInfo) {
            pProcessInfo = new StringBuilder();
        }
        boolean upgradeOk = false;
        DLock lock = DLock.create((String)"kd.bos.permission.cache.util.AdminSchemeDetailUpgradeUtil");
        lock.lock();
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                List<Long> preSchemeEntryIdList = AdminSchemeDetailUpgradeUtil.getPreSchemeEntryIdList();
                List<Object[]> preDetailList = AdminSchemeDetailUpgradeUtil.getNewPreDetailList(preSchemeEntryIdList);
                if (!CollectionUtils.isEmpty(preDetailList)) {
                    AdminSchemeDetailUpgradeUtil.delAllOldPred();
                    logger.debug("\u6e05\u7a7at_perm_adminschemedetail\u8868\u539f\u6709\u6743\u9650\u63a7\u5236\u7b56\u7565\u660e\u7ec6\uff0c\u5b8c\u6210");
                    String sql = "insert into t_perm_adminschemedetail (fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid) values(?, ?, ?, ?, ?, ?)";
                    SqlUtil.syncInsert(preDetailList, sql, PermHelperConst.SQL_INSERT_BATCH_NUM_5000, DBRoute.base, true);
                    logger.debug("\u5165\u5e93t_perm_adminschemedetail\u8868\u65b0\u7684\u6743\u9650\u63a7\u5236\u7b56\u7565\u660e\u7ec6\uff0c\u5b8c\u6210");
                }
                upgradeOk = true;
            }
            catch (Exception e) {
                logger.warn("\u5347\u7ea7\u6743\u9650\u63a7\u5236\u7b56\u7565\u529f\u80fd\u6743\u9650,\u5f02\u5e38", (Throwable)e);
                pProcessInfo.append(e.getMessage());
                txHandle.markRollback();
                upgradeOk = false;
            }
            finally {
                if (upgradeOk) {
                    CacheMrg.clearAllCache();
                    CacheMrg.clearHasEnableOldAdmin();
                }
                lock.unlock();
            }
            boolean bl = upgradeOk;
            return bl;
        }
    }

    private static List<Long> getPreSchemeEntryIdList() {
        List preSchemeIdStrList = preSchemeIdList.stream().map(String::valueOf).collect(Collectors.toList());
        String preSchemeIdStr = String.join((CharSequence)",", preSchemeIdStrList);
        StringBuilder sb = new StringBuilder();
        sb.append("select fentryid from t_perm_adminschemeentry where fid in ( ").append(preSchemeIdStr).append(" )");
        return (List)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> list = new ArrayList<Long>(4);
                while (rs.next()) {
                    list.add(rs.getLong("fentryid"));
                }
                if (CollectionUtils.isEmpty(list)) {
                    return null;
                }
                return list;
            }
        });
    }

    private static void delAllOldPred() {
        String delAdminschemedetail = "truncate table t_perm_adminschemedetail";
        DB.execute((DBRoute)DBRoute.basedata, (String)delAdminschemedetail);
    }

    private static List<Object[]> getNewPreDetailList(final List<Long> preSchemeEntryIdList) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct fentryid, fbizappid, fentitynum");
        sb.append(" from t_perm_adminschemedetail");
        return (List)DB.query((DBRoute)DBRoute.base, (String)sb.toString(), null, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws Exception {
                ArrayList<Object[]> list = new ArrayList<Object[]>(1024);
                Long idx = 1L;
                Object[] one = null;
                while (rs.next()) {
                    String fentitynum = rs.getString("fentitynum");
                    Set permissionItems = EntityMetadataCache.getPermissionItems((String)fentitynum);
                    if (CollectionUtils.isEmpty((Collection)permissionItems)) continue;
                    Long fentryid = rs.getLong("fentryid");
                    Long fseq = 0L;
                    String fbizappid = rs.getString("fbizappid");
                    if (preSchemeEntryIdList.contains(fentryid)) {
                        for (String item : permissionItems) {
                            one = new Object[]{fentryid, idx, fseq, fbizappid, fentitynum, item};
                            Long l = idx;
                            Long l2 = idx = Long.valueOf(idx + 1L);
                            list.add(one);
                        }
                        continue;
                    }
                    long[] newIds = DB.genLongIds((String)AdminSchemeDetailUpgradeUtil.TABLE_T_PERM_ADMINSCHEMEDETAIL, (int)permissionItems.size());
                    int indexj = 0;
                    for (String item : permissionItems) {
                        one = new Object[]{fentryid, newIds[indexj], fseq, fbizappid, fentitynum, item};
                        ++indexj;
                        list.add(one);
                    }
                }
                return list;
            }
        });
    }
}

