/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.cache.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.cache.constant.PermHelperConst;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.permission.cache.util.SqlUtil;
import kd.bos.permission.model.PermResult;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class AppendPermByAddNewEntUpgradeUtil {
    private static final Log logger = LogFactory.getLog(AppendPermByAddNewEntUpgradeUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PermResult upgrade(List<Object[]> needAppendPermList, StringBuilder pProcessInfo) {
        DLock lock = null;
        try {
            lock = DLock.create((String)"bos/permissinon/AppendPermByAddNewEntUpgradeUtil");
            lock.lock();
            if (null == pProcessInfo) {
                pProcessInfo = new StringBuilder();
            }
            if (null == needAppendPermList || needAppendPermList.isEmpty()) {
                logger.debug("AppendPermByAddNewEntUpgradeUtil.upgrade, needAppendPermList is empty.");
                PermResult permResult = PermResult.ok();
                return permResult;
            }
            for (int i = 0; i < needAppendPermList.size(); ++i) {
                Object[] needAppendPermObj = needAppendPermList.get(i);
                if (null == needAppendPermObj || Objects.equals(0, needAppendPermObj.length)) {
                    logger.debug("AppendPermByAddNewEntUpgradeUtil.upgrade, needAppendPermObj is empty, i:{}", (Object)i);
                    continue;
                }
                Object appIdObj = needAppendPermObj[0];
                Object entNumObj = needAppendPermObj[1];
                Object permItemIdObj = needAppendPermObj[2];
                if (Objects.isNull(appIdObj) || Objects.isNull(entNumObj) || Objects.isNull(permItemIdObj)) {
                    logger.debug("AppendPermByAddNewEntUpgradeUtil.upgrade, appIdObj:{}, entNumObj:{}, permItemIdObj:{}, i:{}", new Object[]{appIdObj, entNumObj, permItemIdObj, i});
                    continue;
                }
                String appId = (String)appIdObj;
                String entNum = (String)entNumObj;
                String permItemId = (String)permItemIdObj;
                if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entNum) || StringUtils.isEmpty((String)permItemId)) {
                    logger.debug("AppendPermByAddNewEntUpgradeUtil.upgrade, appId or entNum or permItemId is empty, appId:{}, entNum:{}, permItemId:{}, i:{}", new Object[]{appId, entNum, permItemId, i});
                    continue;
                }
                Object threeStrategyEntryIdObj = Objects.equals(3, needAppendPermObj.length) ? null : needAppendPermObj[3];
                Object[] threeStrategyEntryIdArr = Objects.isNull(threeStrategyEntryIdObj) ? new Long[]{} : (Long[])threeStrategyEntryIdObj;
                try (TXHandle h = TX.requiresNew();){
                    try {
                        if (null == threeStrategyEntryIdArr || threeStrategyEntryIdArr.length <= 0) continue;
                        AppendPermByAddNewEntUpgradeUtil.appendAdminSchemeDetail((Long[])threeStrategyEntryIdArr, appId, entNum, permItemId);
                        continue;
                    }
                    catch (Exception e) {
                        String errInfo = String.format(ResManager.loadKDString((String)"\u3010\u5728\u201c\u7cfb\u7edf\u670d\u52a1\u4e91\u201d\u589e\u52a0\u4e1a\u52a1\u5bf9\u8c61\u53ca\u6743\u9650\u9879-\u8ffd\u52a0\u6388\u6743\u3011\u5347\u7ea7\u5f02\u5e38\uff0cappId\uff1a%1$s\uff0centNum\uff1a%2$s\uff0cpermItemId\uff1a%3$s\uff0cthreeStrategyEntryIdArr\uff1a%4$s\uff0c%5$s", (String)"AppendPermByAddNewEntUpgradeUtil_0", (String)"bos-permission-cache", (Object[])new Object[0]), appId, entNum, permItemId, Arrays.toString(threeStrategyEntryIdArr), e.getMessage());
                        logger.warn(errInfo, (Throwable)e);
                        h.markRollback();
                        pProcessInfo.append(errInfo);
                        throw e;
                    }
                }
            }
        }
        finally {
            CacheMrg.clearAllCache();
            CacheMrg.clearHasEnableOldAdmin();
            if (null != lock) {
                lock.unlock();
            }
        }
        return PermResult.ok();
    }

    private static void appendAdminSchemeDetail(Long[] threeStrategyEntryIdArr, String appId, String entNum, String permItemId) {
        boolean needCheckAdminPerm = PermCommonUtil.needCheckAdminPerm(appId, entNum);
        if (!needCheckAdminPerm) {
            return;
        }
        Set<String> exist = AppendPermByAddNewEntUpgradeUtil.queryForAdminSchemeDetail(threeStrategyEntryIdArr, appId, entNum, permItemId);
        int size = threeStrategyEntryIdArr.length - exist.size();
        if (Objects.equals(0, size)) {
            return;
        }
        long[] detailIds = DB.genLongIds((String)"t_perm_adminschemedetail", (int)size);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(size);
        int idx = 0;
        for (Long threeStrategyEntryId : threeStrategyEntryIdArr) {
            String unique = threeStrategyEntryId + "_" + appId + "_" + entNum + "_" + permItemId;
            if (exist.contains(unique)) continue;
            paramList.add(new Object[]{threeStrategyEntryId, detailIds[idx], 0, appId, entNum, permItemId});
            ++idx;
        }
        String sql = "insert into t_perm_adminschemedetail (fentryid, fdetailid, fseq, fbizappid, fentitynum, fpermitemid) values(?, ?, ?, ?, ?, ?)";
        SqlUtil.syncInsert(paramList, sql, PermHelperConst.SQL_INSERT_BATCH_NUM_5000, DBRoute.base, true);
    }

    private static Set<String> queryForAdminSchemeDetail(Long[] threeStrategyEntryIdArr, String appId, String entNum, String permItemId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fentryid, a.fdetailid, a.fseq, a.fbizappid, a.fentitynum, a.fpermitemid from t_perm_adminschemedetail a ", new Object[0]);
        sqlBuilder.append(" inner join t_perm_adminschemeentry b on b.fentryid  = a.fentryid ", new Object[0]);
        sqlBuilder.append(" where b.fid = ? ", new Object[]{PermHelperConst.THREE_STRATEGY_ID});
        sqlBuilder.appendIn(" and a.fentryid", (Object[])threeStrategyEntryIdArr);
        sqlBuilder.appendIn(" and a.fbizappid", (Object[])new String[]{appId});
        sqlBuilder.appendIn(" and a.fentitynum", (Object[])new String[]{entNum});
        sqlBuilder.appendIn(" and a.fpermitemid", (Object[])new String[]{permItemId});
        return (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                HashSet<String> exist = new HashSet<String>(8);
                while (rs.next()) {
                    exist.add(rs.getObject("fentryid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitynum") + "_" + rs.getObject("fpermitemid"));
                }
                return exist;
            }
        });
    }
}

